/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.processor;

import java.util.ArrayList;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.RegistrationException;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.OnNoTokenPolicyAware;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;
import org.mule.util.Preconditions;

public abstract class DevkitBasedMessageProcessor
extends ExpressionEvaluatorSupport
implements FlowConstructAware,
MuleContextAware,
Startable,
Disposable,
Stoppable,
Initialisable {
    private String operationName;
    private String accessTokenId;
    protected Object moduleObject;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;

    public DevkitBasedMessageProcessor(String operationName) {
        this.operationName = operationName;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            return this.doProcess(event);
        }
        catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        }
        catch (NotAuthorizedException e) {
            Object policyAwareCandidate = this.evaluateIfExpression(event, this.moduleObject);
            Preconditions.checkArgument((boolean)(policyAwareCandidate instanceof OnNoTokenPolicyAware), (String)String.format("Was expecting config to be an instance of %s but it's a %s instead", OnNoTokenPolicyAware.class.getName(), policyAwareCandidate.getClass().getName()));
            try {
                return this.handleNotAuthorized((OnNoTokenPolicyAware)policyAwareCandidate, e, event);
            }
            catch (Exception ne) {
                this.handleException(event, ne);
            }
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(event, e);
        }
        return event;
    }

    protected abstract MuleEvent doProcess(MuleEvent var1) throws Exception;

    private void handleException(MuleEvent event, Throwable e) throws MuleException {
        throw new MessagingException(CoreMessages.failedToInvoke((String)this.operationName), event, e);
    }

    private MuleEvent handleNotAuthorized(OnNoTokenPolicyAware policyAware, NotAuthorizedException e, MuleEvent event) throws NotAuthorizedException {
        OnNoTokenPolicy policy = policyAware.getOnNoTokenPolicy();
        if (policy == null) {
            throw new IllegalStateException("OnNoTokenPolicy cannot be null");
        }
        return policy.handleNotAuthorized(policyAware, e, event);
    }

    protected final Object findOrCreate(Class<?> moduleClass, boolean shouldAutoCreate, MuleEvent muleEvent) throws IllegalAccessException, InstantiationException, ConfigurationException, RegistrationException {
        Object temporaryObject = this.moduleObject;
        if (temporaryObject == null && (temporaryObject = this.muleContext.getRegistry().lookupObject(moduleClass)) == null) {
            if (shouldAutoCreate) {
                temporaryObject = moduleClass.newInstance();
                this.muleContext.getRegistry().registerObject(moduleClass.getName(), temporaryObject);
            } else {
                throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot find object"));
            }
        }
        return this.evaluateIfExpression(muleEvent, temporaryObject);
    }

    private Object evaluateIfExpression(MuleEvent muleEvent, Object object) throws ConfigurationException {
        if (object instanceof String && (object = this.muleContext.getExpressionManager().evaluate((String)object, muleEvent, true)) == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage((String)"Cannot find object by config name"));
        }
        return object;
    }

    public final void overwritePayload(MuleEvent event, Object resultPayload) throws Exception {
        TransformerTemplate.OverwitePayloadCallback overwritePayloadCallback = null;
        overwritePayloadCallback = resultPayload == null ? new TransformerTemplate.OverwitePayloadCallback((Object)NullPayload.getInstance()) : new TransformerTemplate.OverwitePayloadCallback(resultPayload);
        ArrayList<TransformerTemplate> transformerList = new ArrayList<TransformerTemplate>();
        transformerList.add(new TransformerTemplate((TransformerTemplate.TransformerCallback)overwritePayloadCallback));
        event.getMessage().applyTransformers(event, transformerList);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public final void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public final MuleContext getMuleContext() {
        return this.muleContext;
    }

    public final void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public final FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public final void setModuleObject(Object value) {
        this.moduleObject = value;
    }

    public String getAccessTokenId() {
        return this.accessTokenId;
    }

    public void setAccessTokenId(String accessTokenId) {
        this.accessTokenId = accessTokenId;
    }
}

