/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.construct.Flow;
import org.mule.module.apikit.Configuration;
import org.mule.module.apikit.FlowResolver;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.MessageSourceAdapter;
import org.mule.module.apikit.ProxyConfiguration;
import org.mule.module.apikit.UrlUtils;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.module.apikit.injector.RamlUpdater;
import org.mule.module.apikit.spi.RouterService;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolver;
import org.mule.util.BeanUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration
implements Initialisable,
MuleContextAware,
Startable {
    public static final String APPLICATION_RAML = "application/raml+yaml";
    private static final String CONSOLE_URL_FILE = "consoleurl";
    private static final int URI_CACHE_SIZE = 1000;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected FlowConstruct flowConstruct;
    protected MuleContext muleContext;
    private String name;
    protected String raml;
    private Raml baseApi;
    protected Raml api;
    private String baseSchemeHostPort;
    private Map<String, String> apikitRaml = new ConcurrentHashMap<String, String>();
    private boolean disableValidations;
    protected Map<String, FlowResolver> restFlowMapWrapper;
    protected Map<URIPattern, Resource> routingTable;
    protected LoadingCache<String, URIResolver> uriResolverCache;
    protected LoadingCache<String, URIPattern> uriPatternCache;
    private List<String> consoleUrls = new ArrayList<String>();
    private boolean started;
    protected boolean extensionEnabled = false;
    private RouterService routerExtension = null;

    public void initialise() throws InitialisationException {
        if (this.muleContext == null) {
            return;
        }
        ResourceLoader loader = this.getRamlResourceLoader();
        this.validateRaml(loader);
        RamlDocumentBuilder builder = new RamlDocumentBuilder(loader, new TagResolver[0]);
        this.api = (Raml)builder.build(this.raml);
        this.cleanBaseUriParameters(this.api);
        this.baseSchemeHostPort = UrlUtils.getBaseSchemeHostPort(this.api.getBaseUri());
        this.initializeRestFlowMap();
        this.initializeRestFlowMapWrapper();
        this.loadRoutingTable();
        this.buildResourcePatternCaches();
    }

    public void start() throws MuleException {
    }

    private void loadRoutingTable() {
        if (this.routingTable == null) {
            this.routingTable = new ConcurrentHashMap<URIPattern, Resource>();
        }
        this.buildRoutingTable(this.getApi().getResources());
    }

    private void buildResourcePatternCaches() {
        this.logger.info("Building resource URI cache...");
        this.uriResolverCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIResolver>(){

            public URIResolver load(String path) throws IOException {
                return new URIResolver(path);
            }
        });
        this.uriPatternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, URIPattern>(){

            public URIPattern load(String path) throws Exception {
                URIResolver resolver = (URIResolver)AbstractConfiguration.this.uriResolverCache.get((Object)path);
                URIPattern match = resolver.find(AbstractConfiguration.this.routingTable.keySet(), URIResolver.MatchRule.BEST_MATCH);
                if (match == null) {
                    AbstractConfiguration.this.logger.warn("No matching patterns for URI " + path);
                    throw new NotFoundException(path);
                }
                return match;
            }
        });
    }

    private void buildRoutingTable(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            String parentUri = resource.getParentUri();
            if (parentUri.contains("{version}")) {
                resource.setParentUri(parentUri.replaceAll("\\{version}", this.getApi().getVersion()));
            }
            String uri = resource.getUri();
            this.logger.debug("Adding URI to the routing table: " + uri);
            this.routingTable.put(new URIPattern(uri), resource);
            if (resource.getResources() == null) continue;
            this.buildRoutingTable(resource.getResources());
        }
    }

    public void loadApiDefinition(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        this.injectEndpointUri(this.api);
        this.resetRamlMap();
    }

    public void updateApi(Raml newApi) {
        this.api = newApi;
        this.loadRoutingTable();
        this.resetRamlMap();
    }

    private void resetRamlMap() {
        this.apikitRaml = new ConcurrentHashMap<String, String>();
        this.apikitRaml.put(this.baseSchemeHostPort, new RamlEmitter().dump(this.api));
    }

    protected abstract void initializeRestFlowMap();

    protected void validateRaml(ResourceLoader resourceLoader) {
        List<Object> results = new ArrayList<ValidationResult>();
        try (InputStream content = resourceLoader.fetchResource(this.raml);){
            if (content != null) {
                results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(this.raml);
            } else {
                results.add(ValidationResult.createErrorResult((String)"Raml resource not found "));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, results);
        if (!warnings.isEmpty()) {
            this.logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.raml);
            if (result.getLine() != -1) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public abstract ResourceLoader getRamlResourceLoader();

    private void injectEndpointUri(Raml ramlApi) {
        String address = this.getEndpointAddress(this.flowConstruct);
        ramlApi.setBaseUri(address);
        this.baseSchemeHostPort = UrlUtils.getBaseSchemeHostPort(address);
    }

    private void cleanBaseUriParameters(Raml ramlApi) {
        ramlApi.getBaseUriParameters().clear();
        this.cleanBaseUriParameters(ramlApi.getResources());
    }

    private void cleanBaseUriParameters(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            resource.getBaseUriParameters().clear();
            for (Action action : resource.getActions().values()) {
                action.getBaseUriParameters().clear();
            }
            if (resource.getResources().isEmpty()) continue;
            this.cleanBaseUriParameters(resource.getResources());
        }
    }

    public String getEndpointAddress(FlowConstruct flowConstruct) {
        MessageSourceAdapter adapter = new MessageSourceAdapter(((Flow)flowConstruct).getMessageSource());
        String address = adapter.getAddress();
        String path = adapter.getPath();
        String scheme = adapter.getScheme();
        String chAddress = System.getProperty("fullDomain");
        String chBaseUri = scheme + "://" + chAddress + path;
        if (this.logger.isDebugEnabled()) {
            if (this.api != null) {
                this.logger.debug("yaml baseUri: " + this.api.getBaseUri());
            }
            this.logger.debug("mule baseUri: " + address);
            this.logger.debug("chub baseUri: " + chBaseUri);
        }
        if (chAddress != null) {
            address = chBaseUri;
        }
        if (address.endsWith("/")) {
            this.logger.debug("removing trailing slash from baseuri -> " + address);
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getApikitRaml(String schemeHostPort) {
        if (schemeHostPort == null) {
            return this.apikitRaml.get(this.baseSchemeHostPort);
        }
        String hostRaml = this.apikitRaml.get(schemeHostPort);
        if (hostRaml == null) {
            Raml clone = this.shallowCloneRaml(this.api);
            clone.setBaseUri(this.api.getBaseUri().replace(this.baseSchemeHostPort, schemeHostPort));
            hostRaml = new RamlEmitter().dump(clone);
            this.apikitRaml.put(schemeHostPort, hostRaml);
        }
        return hostRaml;
    }

    public String getApikitRaml(MuleEvent event) {
        return this.getApikitRaml(UrlUtils.getBaseSchemeHostPort(event));
    }

    public String getApikitRamlConsole(MuleEvent event) {
        String schemeHostPort = this.baseSchemeHostPort;
        String bindAllInterfaces = "0.0.0.0";
        if (schemeHostPort.contains(bindAllInterfaces)) {
            try {
                URL url = new URL(UrlUtils.getBaseSchemeHostPort(event));
                schemeHostPort = schemeHostPort.replace(bindAllInterfaces, url.getHost());
            }
            catch (MalformedURLException e) {
                throw new ApikitRuntimeException(e);
            }
        }
        return this.getApikitRaml(schemeHostPort);
    }

    private Raml deepCloneRaml(Raml source) {
        Raml target = (Raml)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)source));
        this.copyCompiledSchemas(source, target);
        return target;
    }

    private void copyCompiledSchemas(Raml source, Raml target) {
        target.setCompiledSchemas(source.getCompiledSchemas());
    }

    private Raml shallowCloneRaml(Raml source) {
        try {
            return (Raml)BeanUtils.cloneBean((Object)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDisableValidations() {
        return this.disableValidations;
    }

    public void setDisableValidations(boolean disableValidations) {
        this.disableValidations = disableValidations;
    }

    public Raml getApi() {
        return this.api;
    }

    public Map<String, FlowResolver> getRestFlowMap() {
        return this.restFlowMapWrapper;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected void initializeRestFlowMapWrapper() {
        this.restFlowMapWrapper = this.populateFlowMapWrapper();
    }

    private Map<String, FlowResolver> populateFlowMapWrapper() {
        HashMap<String, FlowResolver> map = new HashMap<String, FlowResolver>();
        this.populateMapKeys(map, this.api.getResources());
        return map;
    }

    private void populateMapKeys(Map<String, FlowResolver> wrapperFlowMap, Map<String, Resource> resources) {
        for (Map.Entry<String, Resource> resourceEntry : resources.entrySet()) {
            String resource = resourceEntry.getValue().getUri();
            for (Map.Entry actionEntry : resourceEntry.getValue().getActions().entrySet()) {
                String key = ((ActionType)actionEntry.getKey()).name().toLowerCase() + ":" + resource;
                wrapperFlowMap.put(key, this.getFlowResolver(this, key));
            }
            this.populateMapKeys(wrapperFlowMap, resourceEntry.getValue().getResources());
        }
    }

    protected abstract FlowResolver getFlowResolver(AbstractConfiguration var1, String var2);

    public void addConsoleUrl(String url) {
        if (StringUtils.isNotBlank((String)url)) {
            url = url.replace("0.0.0.0", "127.0.0.1");
            this.consoleUrls.add(url);
        }
    }

    public void publishConsoleUrls(String parentDirectory) {
        this.started = true;
        if (this.isLastRouterToStart()) {
            this.dumpUrlsFile(parentDirectory);
        }
        if (this.logger.isInfoEnabled()) {
            for (String consoleUrl : this.consoleUrls) {
                String msg = String.format("APIKit Console URL: %s", consoleUrl);
                this.logger.info(StringMessageUtils.getBoilerPlate((String)msg));
            }
        }
    }

    private boolean isLastRouterToStart() {
        for (AbstractConfiguration configuration : AbstractConfiguration.getAllConfigurations(this.muleContext)) {
            if (configuration.started) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUrlsFile(String parentDirectory) {
        File urlFile = new File(parentDirectory, CONSOLE_URL_FILE);
        FileWriter writer = null;
        try {
            if (!urlFile.exists()) {
                urlFile.createNewFile();
            }
            writer = new FileWriter(urlFile, true);
            for (String consoleUrl : this.getAllConsoleUrls()) {
                writer.write(consoleUrl + "\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                this.logger.error("cannot publish console url for studio", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private List<String> getAllConsoleUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        for (AbstractConfiguration configuration : AbstractConfiguration.getAllConfigurations(this.muleContext)) {
            urls.addAll(configuration.consoleUrls);
        }
        return urls;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRaml() {
        return this.raml;
    }

    public void setRaml(String raml) {
        this.raml = raml;
    }

    public Action getEventAction(MuleEvent event) {
        URIPattern uriPattern;
        HttpRestRequest request = this.getHttpRestRequest(event);
        String path = request.getResourcePath();
        try {
            uriPattern = (URIPattern)this.uriPatternCache.get((Object)path);
        }
        catch (ExecutionException e) {
            return null;
        }
        Resource resource = this.routingTable.get(uriPattern);
        return resource.getAction(request.getMethod());
    }

    protected abstract HttpRestRequest getHttpRestRequest(MuleEvent var1);

    public static Collection<AbstractConfiguration> getAllConfigurations(MuleContext muleContext) {
        HashSet configurations = Sets.newHashSet();
        configurations.addAll(muleContext.getRegistry().lookupObjects(Configuration.class));
        configurations.addAll(muleContext.getRegistry().lookupObjects(ProxyConfiguration.class));
        return configurations;
    }

    public RamlUpdater getRamlUpdater() {
        if (this.baseApi == null) {
            this.baseApi = this.deepCloneRaml(this.api);
        }
        return new RamlUpdater(this.deepCloneRaml(this.baseApi), this);
    }

    public Set<String> getFlowActionRefs(Flow flow) {
        HashSet<String> actionRefs = new HashSet<String>();
        for (Map.Entry<String, FlowResolver> entry : this.restFlowMapWrapper.entrySet()) {
            if (flow != entry.getValue().getFlow()) continue;
            actionRefs.add(entry.getKey());
        }
        return actionRefs;
    }

    public boolean isExtensionEnabled() {
        return this.extensionEnabled;
    }

    public void setExtensionEnabled(boolean extensionEnabled) {
        ServiceLoader<RouterService> loader;
        Iterator<RouterService> it;
        if (extensionEnabled && (it = (loader = ServiceLoader.load(RouterService.class)).iterator()).hasNext()) {
            this.extensionEnabled = true;
            this.routerExtension = it.next();
        }
    }

    public RouterService getRouterExtension() {
        return this.routerExtension;
    }
}

