/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.validation.cache.SchemaCacheUtils;
import org.raml.model.Raml;

public class JsonSchemaCacheLoader
extends CacheLoader<String, JsonSchema> {
    private static final String RESOURCE_PREFIX = "resource:/";
    private Raml api;

    public JsonSchemaCacheLoader(Raml api) {
        this.api = api;
    }

    public JsonSchema load(String schemaLocation) throws IOException {
        Object pathOrSchema = SchemaCacheUtils.resolveJsonSchema(schemaLocation, this.api);
        if (pathOrSchema instanceof String) {
            return this.parseSchema(this.resolveLocationIfNecessary(this.formatUri((String)pathOrSchema)));
        }
        return this.parseSchema((JsonNode)pathOrSchema);
    }

    private String formatUri(String location) {
        URI uri = URI.create(location);
        if (uri.getScheme() == null) {
            if (location.charAt(0) == '/') {
                location = location.substring(1);
            }
            location = RESOURCE_PREFIX + location;
        }
        return location;
    }

    private String resolveLocationIfNecessary(String path) {
        URI uri = URI.create(path);
        String scheme = uri.getScheme();
        if (scheme == null || "resource".equals(scheme)) {
            return this.openSchema(uri.getPath()).toString();
        }
        return path;
    }

    private URL openSchema(String path) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null && path.startsWith("/")) {
            return this.openSchema(path.substring(1));
        }
        return url;
    }

    private JsonSchema parseSchema(JsonNode jsonNode) {
        try {
            return this.getSchemaFactory().getJsonSchema(jsonNode);
        }
        catch (ProcessingException e) {
            throw new ApikitRuntimeException(e);
        }
    }

    private JsonSchema parseSchema(String uri) {
        try {
            return this.getSchemaFactory().getJsonSchema(uri);
        }
        catch (ProcessingException e) {
            throw new ApikitRuntimeException(e);
        }
    }

    private JsonSchemaFactory getSchemaFactory() {
        ValidationConfiguration validationCfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV3).freeze();
        return JsonSchemaFactory.newBuilder().setLoadingConfiguration(LoadingConfiguration.byDefault()).setValidationConfiguration(validationCfg).freeze();
    }
}

