/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.apikit.UrlUtils;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.transport.http.components.ResourceNotFoundException;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.FilenameUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleHandler {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    public static final String MIME_TYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_SVG = "image/svg+xml";
    public static final String MIME_TYPE_CSS = "text/css";
    private static final String RESOURCE_BASE = System.getProperty("apikit.console.old") != null ? "/console" : "/console2";
    private Map<String, String> homePage = new ConcurrentHashMap<String, String>();
    private String consolePath;
    private String baseSchemeHostPort;
    private boolean standalone;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String ramlUri;

    public ConsoleHandler(String ramlUri) {
        this(ramlUri, "");
        this.standalone = true;
    }

    public ConsoleHandler(String ramlUri, String consolePath) {
        this.consolePath = this.sanitize(consolePath);
        InputStream indexInputStream = this.getClass().getResourceAsStream(RESOURCE_BASE + "/index.html");
        String indexHtml = IOUtils.toString((InputStream)indexInputStream);
        IOUtils.closeQuietly((InputStream)indexInputStream);
        this.ramlUri = ramlUri.endsWith("/") ? ramlUri : ramlUri + "/";
        String baseHomePage = indexHtml.replaceFirst("<raml-console src=\"[^\"]+\"", "<raml-console src=\"./?\"");
        this.baseSchemeHostPort = UrlUtils.getBaseSchemeHostPort(this.ramlUri);
        this.homePage.put(this.baseSchemeHostPort, baseHomePage);
    }

    private String sanitize(String consolePath) {
        if (consolePath.endsWith("/")) {
            consolePath = consolePath.substring(0, consolePath.length() - 1);
        }
        if (!consolePath.isEmpty() && !consolePath.startsWith("/")) {
            consolePath = "/" + consolePath;
        }
        return consolePath;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleEvent resultEvent;
        ByteArrayOutputStream baos;
        InputStream in;
        String path;
        block13: {
            path = UrlUtils.getResourceRelativePath(event.getMessage());
            String contextPath = UrlUtils.getBasePath(event.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Console request: " + path);
            }
            in = null;
            baos = null;
            if (!path.equals(this.consolePath) || contextPath.endsWith("/") && this.standalone) break block13;
            event.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(301));
            String scheme = UrlUtils.getScheme(event.getMessage());
            String host = (String)event.getMessage().getInboundProperty("Host");
            String requestPath = (String)event.getMessage().getInboundProperty("http.request.path");
            String redirectLocation = scheme + "://" + host + requestPath + "/";
            String queryString = (String)event.getMessage().getInboundProperty("http.query.string");
            if (StringUtils.isNotEmpty((String)queryString)) {
                redirectLocation = redirectLocation + "?" + queryString;
            }
            event.getMessage().setOutboundProperty("Location", (Object)redirectLocation);
            MuleEvent muleEvent = event;
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)baos);
            return muleEvent;
        }
        try {
            if (path.equals(this.consolePath) || path.equals(this.consolePath + "/") || path.equals(this.consolePath + "/index.html")) {
                path = RESOURCE_BASE + "/index.html";
                in = new ByteArrayInputStream(this.getHomePage(UrlUtils.getBaseSchemeHostPort(event)).getBytes());
            } else if (path.startsWith(this.consolePath)) {
                in = this.getClass().getResourceAsStream(RESOURCE_BASE + path.substring(this.consolePath.length()));
            }
            if (in == null) {
                throw new NotFoundException(path);
            }
            baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.getMimeType(path);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)buffer, event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(200));
            resultEvent.getMessage().setOutboundProperty("Content-Type", (Object)mimetype);
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)buffer.length);
            if (mimetype.equals("text/html")) {
                resultEvent.getMessage().setOutboundProperty("Expires", (Object)-1);
            }
        }
        catch (IOException e) {
            try {
                throw new ResourceNotFoundException(HttpMessages.fileNotFound((String)(RESOURCE_BASE + path)), event);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)baos);
        return resultEvent;
    }

    private String getHomePage(String schemeHostPort) {
        if (schemeHostPort == null) {
            return this.homePage.get(this.baseSchemeHostPort);
        }
        String page = this.homePage.get(schemeHostPort);
        if (page == null) {
            page = this.homePage.get(this.baseSchemeHostPort).replace(this.baseSchemeHostPort, schemeHostPort);
            this.homePage.put(schemeHostPort, page);
        }
        return page;
    }

    private String getMimeType(String path) {
        String mimeType = DEFAULT_MIME_TYPE;
        if (FilenameUtils.getExtension((String)path).equals("html")) {
            mimeType = "text/html";
        } else if (FilenameUtils.getExtension((String)path).equals("js")) {
            mimeType = MIME_TYPE_JAVASCRIPT;
        } else if (FilenameUtils.getExtension((String)path).equals("png")) {
            mimeType = MIME_TYPE_PNG;
        } else if (FilenameUtils.getExtension((String)path).equals("gif")) {
            mimeType = MIME_TYPE_GIF;
        } else if (FilenameUtils.getExtension((String)path).equals("svg")) {
            mimeType = MIME_TYPE_SVG;
        } else if (FilenameUtils.getExtension((String)path).equals("css")) {
            mimeType = MIME_TYPE_CSS;
        }
        return mimeType;
    }

    public String getConsoleUrl() {
        String path = "";
        if (this.consolePath.startsWith("/")) {
            path = this.consolePath.substring(1, this.consolePath.length());
        }
        return this.ramlUri + path;
    }
}

