/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.net.MalformedURLException;
import java.net.URL;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.apikit.exception.ApikitRuntimeException;

public class UrlUtils {
    public static String getBaseSchemeHostPort(MuleEvent event) {
        String host = (String)event.getMessage().getInboundProperty("host");
        String chHost = System.getProperty("fullDomain");
        if (chHost != null) {
            host = chHost;
        }
        return UrlUtils.getScheme(event.getMessage()) + "://" + host;
    }

    public static String getScheme(MuleMessage message) {
        String scheme = (String)message.getInboundProperty("http.scheme");
        if (scheme == null) {
            String endpoint = (String)message.getInboundProperty("http.context.uri");
            if (endpoint == null) {
                throw new ApikitRuntimeException("Cannot figure out the request scheme");
            }
            if (endpoint.startsWith("http:")) {
                scheme = "http";
            } else if (endpoint.startsWith("https:")) {
                scheme = "https";
            } else {
                throw new ApikitRuntimeException("Unsupported scheme: " + endpoint);
            }
        }
        return scheme;
    }

    public static String getBaseSchemeHostPort(String baseUri) {
        URL url;
        try {
            url = new URL(baseUri);
        }
        catch (MalformedURLException e) {
            return "http://localhost";
        }
        return url.getProtocol() + "://" + url.getAuthority();
    }

    public static String getResourceRelativePath(MuleMessage message) {
        String path = (String)message.getInboundProperty("http.request.path");
        String basePath = UrlUtils.getBasePath(message);
        if (!(path = path.substring(basePath.length())).startsWith("/") && !path.isEmpty()) {
            path = "/" + path;
        }
        return path;
    }

    public static String getBasePath(MuleMessage message) {
        String path = (String)message.getInboundProperty("http.context.path");
        if (path == null) {
            path = (String)message.getInboundProperty("http.listener.path");
            if (path != null && path.endsWith("/*")) {
                path = path.substring(0, path.length() - 2);
            }
            if (path == null) {
                throw new IllegalArgumentException("Cannot resolve request base path");
            }
        }
        return path;
    }
}

