/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors.processors;

import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.modules.cors.CorsFilter;
import org.mule.modules.cors.MuleCorsFilter;
import org.mule.modules.cors.model.CorsConfig;
import org.mule.processor.AbstractRequestResponseMessageProcessor;

public class ValidateMessageProcessor
extends AbstractRequestResponseMessageProcessor
implements Initialisable {
    protected boolean publicResource;
    protected boolean acceptsCredentials;
    protected CorsConfig config;
    protected CorsFilter corsFilter;

    protected MuleEvent processRequest(MuleEvent event) throws MuleException {
        return this.corsFilter.filter(event);
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (event != null && !VoidMuleEvent.getInstance().equals(event) && Boolean.TRUE.equals(event.getMessage().getInvocationProperty("MULE___corsStopProcessing"))) {
            return event;
        }
        return super.processNext(event);
    }

    protected MuleEvent processResponse(String origin, String method, String requestMethod, String requestHeaders, MuleEvent event) throws MuleException {
        this.corsFilter.addHeaders(event, origin, method, requestMethod, requestHeaders);
        return event;
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        String method = (String)event.getMessage().getInboundProperty("http.method");
        String requestMethod = (String)event.getMessage().getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)event.getMessage().getInboundProperty("Access-Control-Request-Headers");
        try {
            MuleEvent muleEvent = this.processResponse(origin, method, requestMethod, requestHeaders, this.processNext(this.processRequest(event)));
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            throw e;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        String method = (String)event.getMessage().getInboundProperty("http.method");
        String requestMethod = (String)event.getMessage().getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)event.getMessage().getInboundProperty("Access-Control-Request-Headers");
        CorsReplyToHandler corsReplyToHandler = new CorsReplyToHandler(event.getReplyToHandler(), origin, method, requestMethod, requestHeaders);
        event = new DefaultMuleEvent(event, (ReplyToHandler)corsReplyToHandler);
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
        try {
            MuleEvent result = this.processNext(this.processRequest(event));
            if (!(result instanceof NonBlockingVoidMuleEvent)) {
                return this.processResponse(origin, method, requestMethod, requestHeaders, result);
            }
            return result;
        }
        catch (MessagingException exception) {
            this.processFinally(event, exception);
            throw exception;
        }
    }

    public void initialise() throws InitialisationException {
        if (this.publicResource && this.acceptsCredentials) {
            throw new IllegalArgumentException("Resource may not be public and accept credentials at the same time");
        }
        this.corsFilter = new MuleCorsFilter(this.config, this.publicResource, this.acceptsCredentials);
    }

    public void setPublicResource(boolean publicResource) {
        this.publicResource = publicResource;
    }

    public void setAcceptsCredentials(boolean acceptsCredentials) {
        this.acceptsCredentials = acceptsCredentials;
    }

    public void setConfig(CorsConfig config) {
        this.config = config;
    }

    class CorsReplyToHandler
    implements ReplyToHandler {
        private final String origin;
        private final String method;
        private final String requestMethod;
        private final String requestHeaders;
        private final ReplyToHandler originalReplyToHandler;

        public CorsReplyToHandler(ReplyToHandler originalReplyToHandler, String origin, String method, String requestMethod, String requestHeaders) {
            this.originalReplyToHandler = originalReplyToHandler;
            this.origin = origin;
            this.method = method;
            this.requestMethod = requestMethod;
            this.requestHeaders = requestHeaders;
        }

        public void processReplyTo(MuleEvent event, MuleMessage muleMessage, Object replyTo) throws MuleException {
            MuleEvent response = ValidateMessageProcessor.this.processResponse(this.origin, this.method, this.requestMethod, this.requestHeaders, (MuleEvent)new DefaultMuleEvent(event, this.originalReplyToHandler));
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)response);
            if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                this.originalReplyToHandler.processReplyTo(response, null, null);
            }
            ValidateMessageProcessor.this.processFinally(event, null);
        }

        public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
            this.originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
            ValidateMessageProcessor.this.processFinally(exception.getEvent(), exception);
        }
    }
}

