/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.StartException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.ApiRouter;
import org.mule.module.apikit.HttpRestRequest;
import org.mule.module.apikit.RamlDescriptorHandler;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.exception.InvalidUriParameterException;
import org.mule.module.apikit.exception.MethodNotAllowedException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.uri.ResolvedVariables;
import org.mule.module.apikit.uri.URIPattern;
import org.mule.module.apikit.uri.URIResolveResult;
import org.mule.module.apikit.uri.URIResolver;
import org.mule.processor.AbstractRequestResponseMessageProcessor;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.parameter.UriParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouter
extends AbstractRequestResponseMessageProcessor
implements ApiRouter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected FlowConstruct flowConstruct;
    protected AbstractConfiguration config;
    protected RamlDescriptorHandler ramlHandler;

    public void start() throws MuleException {
        this.startConfiguration();
        this.ramlHandler = new RamlDescriptorHandler(this.config);
        this.config.publishConsoleUrls(this.muleContext.getConfiguration().getWorkingDirectory());
    }

    protected abstract void startConfiguration() throws StartException;

    protected Raml getApi() {
        return this.config.getApi();
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        if (this.config.isExtensionEnabled() && this.config.getRouterExtension().isExecutable(event)) {
            return this.config.getRouterExtension().processBlockingRequest(event, (AbstractRequestResponseMessageProcessor)this);
        }
        return this.processBlockingRequest(event);
    }

    public MuleEvent processBlockingRequest(MuleEvent event) throws MuleException {
        RouterRequest result = this.processRouterRequest(event);
        event = result.getEvent();
        if (result.getFlow() != null) {
            event = result.getFlow().process(event);
        }
        return this.processRouterResponse(event, result.getSuccessStatus());
    }

    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        final RouterRequest result = this.processRouterRequest(event);
        event = result.getEvent();
        final ReplyToHandler originalReplyToHandler = event.getReplyToHandler();
        event = new DefaultMuleEvent(event, new ReplyToHandler(){

            public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                MuleEvent response = AbstractRouter.this.processRouterResponse((MuleEvent)new DefaultMuleEvent(event, originalReplyToHandler), result.getSuccessStatus());
                OptimizedRequestContext.unsafeSetEvent((MuleEvent)response);
                if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                    originalReplyToHandler.processReplyTo(response, null, null);
                }
                AbstractRouter.this.processFinally(event, null);
            }

            public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                AbstractRouter.this.processFinally(exception.getEvent(), exception);
            }
        });
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
        if (result.getFlow() != null) {
            event = result.getFlow().process(event);
        }
        if (!(event instanceof NonBlockingVoidMuleEvent)) {
            return this.processRouterResponse(event, result.getSuccessStatus());
        }
        return event;
    }

    protected RouterRequest processRouterRequest(MuleEvent event) throws MuleException {
        URIResolver uriResolver;
        URIPattern uriPattern;
        HttpRestRequest request = this.getHttpRestRequest(event);
        String path = request.getResourcePath();
        MuleEvent handled = this.handleEvent(event, path);
        if (handled != null) {
            return new RouterRequest(handled);
        }
        if (this.ramlHandler.handles(request)) {
            return new RouterRequest(this.ramlHandler.processRouterRequest(event));
        }
        path = path.isEmpty() ? "/" : path;
        try {
            uriPattern = (URIPattern)this.getUriPatternCache().get((Object)path);
            uriResolver = (URIResolver)this.getUriResolverCache().get((Object)path);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof MuleRestException) {
                throw (MuleRestException)((Object)e.getCause());
            }
            throw new DefaultMuleException((Throwable)e);
        }
        Resource resource = this.getRoutingTable().get(uriPattern);
        if (resource.getAction(request.getMethod()) == null) {
            throw new MethodNotAllowedException(resource.getUri(), request.getMethod());
        }
        URIResolveResult resolvedVariables = uriResolver.resolve(uriPattern);
        this.processUriParameters(resolvedVariables, resource, event);
        Flow flow = this.getFlow(resource, request);
        if (flow == null) {
            throw new ApikitRuntimeException("Flow not found for resource: " + resource);
        }
        MuleEvent validatedEvent = request.validate(resource.getAction(request.getMethod()));
        return new RouterRequest(validatedEvent, flow, request.getSuccessStatus());
    }

    private MuleEvent processRouterResponse(MuleEvent event, Integer successStatus) {
        if (event == null || VoidMuleEvent.getInstance().equals(event)) {
            return event;
        }
        return this.doProcessRouterResponse(event, successStatus);
    }

    protected abstract MuleEvent doProcessRouterResponse(MuleEvent var1, Integer var2);

    protected MuleEvent processRequest(MuleEvent event) throws MuleException {
        throw new UnsupportedOperationException();
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        throw new UnsupportedOperationException();
    }

    protected MuleEvent processResponse(MuleEvent event) throws MuleException {
        throw new UnsupportedOperationException();
    }

    private Map<URIPattern, Resource> getRoutingTable() {
        return this.config.routingTable;
    }

    private LoadingCache<String, URIResolver> getUriResolverCache() {
        return this.config.uriResolverCache;
    }

    private LoadingCache<String, URIPattern> getUriPatternCache() {
        return this.config.uriPatternCache;
    }

    protected abstract MuleEvent handleEvent(MuleEvent var1, String var2) throws MuleException;

    private HttpRestRequest getHttpRestRequest(MuleEvent event) {
        return this.config.getHttpRestRequest(event);
    }

    private void processUriParameters(ResolvedVariables resolvedVariables, Resource resource, MuleEvent event) throws InvalidUriParameterException {
        if (this.logger.isDebugEnabled()) {
            for (String string : resolvedVariables.names()) {
                this.logger.debug("        uri parameter: " + string + "=" + resolvedVariables.get(string));
            }
        }
        if (!this.config.isDisableValidations()) {
            for (Map.Entry entry : resource.getResolvedUriParameters().entrySet()) {
                String value = (String)resolvedVariables.get((String)entry.getKey());
                UriParameter uriParameter = (UriParameter)entry.getValue();
                if (uriParameter.validate(value)) continue;
                String msg = String.format("Invalid value '%s' for uri parameter %s. %s", value, entry.getKey(), uriParameter.message(value));
                throw new InvalidUriParameterException(msg);
            }
        }
        HashMap<String, String> uriParams = new HashMap<String, String>();
        for (String name : resolvedVariables.names()) {
            String value = String.valueOf(resolvedVariables.get(name));
            event.getMessage().setInvocationProperty(name, (Object)value);
            uriParams.put(name, value);
        }
        if (event.getMessage().getInboundProperty("http.uri.params") != null) {
            ((Map)event.getMessage().getInboundProperty("http.uri.params")).putAll(uriParams);
        }
    }

    protected abstract Flow getFlow(Resource var1, HttpRestRequest var2);

    private static class RouterRequest {
        private MuleEvent event;
        private Flow flow;
        private Integer successStatus;

        public RouterRequest(MuleEvent event) {
            this(event, null, null);
        }

        public RouterRequest(MuleEvent event, Flow flow, Integer successStatus) {
            this.event = event;
            this.flow = flow;
            this.successStatus = successStatus;
        }

        public MuleEvent getEvent() {
            return this.event;
        }

        public Flow getFlow() {
            return this.flow;
        }

        public Integer getSuccessStatus() {
            return this.successStatus;
        }
    }
}

