/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.message.ds.StringDataSource;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.HttpProtocolAdapter;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.exception.InvalidFormParameterException;
import org.mule.module.apikit.exception.InvalidHeaderException;
import org.mule.module.apikit.exception.InvalidQueryParameterException;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.exception.UnsupportedMediaTypeException;
import org.mule.module.apikit.uri.URICoder;
import org.mule.module.apikit.validation.RestSchemaValidator;
import org.mule.module.apikit.validation.RestSchemaValidatorFactory;
import org.mule.module.apikit.validation.SchemaType;
import org.mule.module.apikit.validation.cache.SchemaCacheUtils;
import org.mule.module.http.internal.ParameterMap;
import org.mule.transport.http.transformers.FormTransformer;
import org.mule.util.CaseInsensitiveHashMap;
import org.raml.model.Action;
import org.raml.model.MimeType;
import org.raml.model.Response;
import org.raml.model.parameter.FormParameter;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRestRequest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleEvent requestEvent;
    protected AbstractConfiguration config;
    protected Action action;
    protected HttpProtocolAdapter adapter;

    public HttpRestRequest(MuleEvent event, AbstractConfiguration config) {
        this.requestEvent = event;
        this.config = config;
        this.adapter = new HttpProtocolAdapter(event);
    }

    public HttpProtocolAdapter getAdapter() {
        return this.adapter;
    }

    public String getResourcePath() {
        String path = this.adapter.getResourceURI().getPath();
        String basePath = this.adapter.getBasePath();
        int start = basePath.endsWith("/") ? basePath.length() - 1 : basePath.length();
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        return URICoder.decode(path.substring(start, end));
    }

    public String getMethod() {
        return this.adapter.getMethod().toLowerCase();
    }

    public String getContentType() {
        return this.adapter.getRequestMediaType();
    }

    public MuleEvent validate(Action action) throws MuleException {
        this.action = action;
        if (!this.config.isDisableValidations()) {
            this.processQueryParameters();
            this.processHeaders();
        }
        this.negotiateInputRepresentation();
        List<MimeType> responseMimeTypes = this.getResponseMimeTypes();
        String responseRepresentation = this.negotiateOutputRepresentation(responseMimeTypes);
        if (responseMimeTypes != null) {
            this.requestEvent.getMessage().setInvocationProperty("_ApikitResponseTransformer_contractMimeTypes", responseMimeTypes);
        }
        if (responseRepresentation != null) {
            this.requestEvent.getMessage().setInvocationProperty("_ApikitResponseTransformer_bestMatchRepresentation", (Object)responseRepresentation);
        }
        this.requestEvent.getMessage().setInvocationProperty("_ApikitResponseTransformer_apikitRouterRequest", (Object)"yes");
        return this.requestEvent;
    }

    private void processQueryParameters() throws InvalidQueryParameterException {
        for (String expectedKey : this.action.getQueryParameters().keySet()) {
            QueryParameter expected = (QueryParameter)this.action.getQueryParameters().get(expectedKey);
            Object actual = ((Map)this.requestEvent.getMessage().getInboundProperty("http.query.params")).get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidQueryParameterException("Required query parameter " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                this.setQueryParameter(expectedKey, expected.getDefaultValue());
            }
            if (actual == null) continue;
            if (actual instanceof Collection && !expected.isRepeat()) {
                throw new InvalidQueryParameterException("Query parameter " + expectedKey + " is not repeatable");
            }
            if (!(actual instanceof Collection)) {
                actual = Collections.singletonList(actual);
            }
            for (String param : (Collection)actual) {
                if (expected.validate(param)) continue;
                String msg = String.format("Invalid value '%s' for query parameter %s. %s", param, expectedKey, expected.message(param));
                throw new InvalidQueryParameterException(msg);
            }
        }
    }

    private void setQueryParameter(String key, String value) {
        HashMap<String, String> queryParamMap;
        if (this.requestEvent.getMessage().getInboundProperty("http.headers") != null) {
            this.requestEvent.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
        }
        if ((queryParamMap = (HashMap<String, String>)this.requestEvent.getMessage().getInboundProperty("http.query.params")) instanceof ParameterMap) {
            queryParamMap = new HashMap<String, String>(queryParamMap);
            this.requestEvent.getMessage().setProperty("http.query.params", queryParamMap, PropertyScope.INBOUND);
        }
        queryParamMap.put(key, value);
    }

    private void processHeaders() throws InvalidHeaderException {
        for (String expectedKey : this.action.getHeaders().keySet()) {
            Header expected = (Header)this.action.getHeaders().get(expectedKey);
            Map<String, String> incomingHeaders = this.getIncomingHeaders(this.requestEvent.getMessage());
            if (expectedKey.contains("{?}")) {
                String regex = expectedKey.replace("{?}", ".*");
                for (String incoming : incomingHeaders.keySet()) {
                    String incomingValue = incomingHeaders.get(incoming);
                    if (!incoming.matches(regex) || expected.validate(incomingValue)) continue;
                    String msg = String.format("Invalid value '%s' for header %s. %s", incomingValue, expectedKey, expected.message(incomingValue));
                    throw new InvalidHeaderException(msg);
                }
                continue;
            }
            String actual = incomingHeaders.get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidHeaderException("Required header " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                this.setHeader(expectedKey, expected.getDefaultValue());
            }
            if (actual == null || expected.validate(actual)) continue;
            String msg = String.format("Invalid value '%s' for header %s. %s", actual, expectedKey, expected.message(actual));
            throw new InvalidHeaderException(msg);
        }
    }

    private Map<String, String> getIncomingHeaders(MuleMessage message) {
        CaseInsensitiveHashMap incomingHeaders = new CaseInsensitiveHashMap();
        if (message.getInboundProperty("http.headers") != null) {
            incomingHeaders = new CaseInsensitiveHashMap((Map)message.getInboundProperty("http.headers"));
        } else {
            for (String key : message.getInboundPropertyNames()) {
                if (key.startsWith("http.")) continue;
                incomingHeaders.put(key, String.valueOf(message.getInboundProperty(key)));
            }
        }
        return incomingHeaders;
    }

    private void setHeader(String key, String value) {
        this.requestEvent.getMessage().setProperty(key, (Object)value, PropertyScope.INBOUND);
        if (this.requestEvent.getMessage().getInboundProperty("http.headers") != null) {
            ((Map)this.requestEvent.getMessage().getInboundProperty("http.headers")).put(key, value);
        }
    }

    private void negotiateInputRepresentation() throws MuleRestException {
        if (this.action == null || !this.action.hasBody()) {
            this.logger.debug("=== no body types defined: accepting any request content-type");
            return;
        }
        String requestMimeTypeName = null;
        boolean found = false;
        if (this.adapter.getRequestMediaType() != null) {
            requestMimeTypeName = this.adapter.getRequestMediaType();
        }
        for (String mimeTypeName : this.action.getBody().keySet()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("comparing request media type %s with expected %s\n", requestMimeTypeName, mimeTypeName));
            }
            if (!mimeTypeName.equals(requestMimeTypeName)) continue;
            found = true;
            if (this.config.isDisableValidations()) break;
            this.valideateBody(mimeTypeName);
            break;
        }
        if (!found) {
            this.handleUnsupportedMediaType();
        }
    }

    protected void handleUnsupportedMediaType() throws UnsupportedMediaTypeException {
        throw new UnsupportedMediaTypeException();
    }

    private void valideateBody(String mimeTypeName) throws MuleRestException {
        MimeType actionMimeType = (MimeType)this.action.getBody().get(mimeTypeName);
        if (actionMimeType.getSchema() != null && (mimeTypeName.contains("xml") || mimeTypeName.contains("json"))) {
            this.validateSchema(mimeTypeName);
        } else if (actionMimeType.getFormParameters() != null && mimeTypeName.contains("multipart/form-data")) {
            this.validateMultipartForm(actionMimeType.getFormParameters());
        } else if (actionMimeType.getFormParameters() != null && mimeTypeName.contains("application/x-www-form-urlencoded")) {
            this.validateUrlencodedForm(actionMimeType.getFormParameters());
        }
    }

    private void validateUrlencodedForm(Map<String, List<FormParameter>> formParameters) throws BadRequestException {
        Map paramMap;
        try {
            paramMap = this.requestEvent.getMessage().getPayload() instanceof Map ? (Map)this.requestEvent.getMessage().getPayload() : (Map)new FormTransformer().transformMessage(this.requestEvent.getMessage(), this.requestEvent.getEncoding());
        }
        catch (TransformerException e) {
            this.logger.warn("Cannot validate url-encoded form", (Throwable)e);
            return;
        }
        for (String expectedKey : formParameters.keySet()) {
            if (formParameters.get(expectedKey).size() != 1) continue;
            FormParameter expected = formParameters.get(expectedKey).get(0);
            Object actual = paramMap.get(expectedKey);
            if (actual == null && expected.isRequired()) {
                throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
            }
            if (actual == null && expected.getDefaultValue() != null) {
                paramMap.put(expectedKey, expected.getDefaultValue());
            }
            if (actual == null || !(actual instanceof String) || expected.validate((String)actual)) continue;
            String msg = String.format("Invalid value '%s' for form parameter %s. %s", actual, expectedKey, expected.message((String)actual));
            throw new InvalidQueryParameterException(msg);
        }
        this.requestEvent.getMessage().setPayload((Object)paramMap);
    }

    private void validateMultipartForm(Map<String, List<FormParameter>> formParameters) throws BadRequestException {
        for (String expectedKey : formParameters.keySet()) {
            if (formParameters.get(expectedKey).size() != 1) continue;
            FormParameter expected = formParameters.get(expectedKey).get(0);
            DataHandler dataHandler = this.requestEvent.getMessage().getInboundAttachment(expectedKey);
            if (dataHandler == null && expected.isRequired()) {
                throw new InvalidFormParameterException("Required form parameter " + expectedKey + " not specified");
            }
            if (dataHandler != null || expected.getDefaultValue() == null) continue;
            DataHandler defaultDataHandler = new DataHandler((DataSource)new StringDataSource(expected.getDefaultValue(), expectedKey));
            try {
                ((DefaultMuleMessage)this.requestEvent.getMessage()).addInboundAttachment(expectedKey, defaultDataHandler);
            }
            catch (Exception e) {
                this.logger.warn("Cannot set default part " + expectedKey, (Throwable)e);
            }
        }
    }

    private void validateSchema(String mimeTypeName) throws MuleRestException {
        SchemaType schemaType = mimeTypeName.contains("json") ? SchemaType.JSONSchema : SchemaType.XMLSchema;
        RestSchemaValidator validator = RestSchemaValidatorFactory.getInstance().createValidator(schemaType, this.requestEvent.getMuleContext());
        validator.validate(this.config.getName(), SchemaCacheUtils.getSchemaCacheKey(this.action, mimeTypeName), this.requestEvent, this.config.getApi());
    }

    private String negotiateOutputRepresentation(List<MimeType> mimeTypes) throws MuleRestException {
        if (this.action == null || this.action.getResponses() == null || mimeTypes.isEmpty()) {
            return null;
        }
        MediaType bestMatch = RestContentTypeParser.bestMatch(mimeTypes, this.adapter.getAcceptableResponseMediaTypes());
        if (bestMatch == null) {
            return this.handleNotAcceptable();
        }
        this.logger.debug("=== negotiated response content-type: " + bestMatch.toString());
        for (MimeType representation : mimeTypes) {
            if (!representation.getType().equals(bestMatch.withoutParameters().toString())) continue;
            return representation.getType();
        }
        return this.handleNotAcceptable();
    }

    protected String handleNotAcceptable() throws NotAcceptableException {
        throw new NotAcceptableException();
    }

    private List<MimeType> getResponseMimeTypes() {
        Response response;
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        int status = this.getSuccessStatus();
        if (status != -1 && (response = (Response)this.action.getResponses().get(String.valueOf(status))) != null && response.hasBody()) {
            Collection types = response.getBody().values();
            this.logger.debug(String.format("=== adding response mimeTypes for status %d : %s", status, types));
            mimeTypes.addAll(types);
        }
        return mimeTypes;
    }

    protected int getSuccessStatus() {
        for (String status : this.action.getResponses().keySet()) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return code;
        }
        return 200;
    }
}

