/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.ExecutionException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.JsonSchemaCache;
import org.mule.transformer.types.DataTypeFactory;
import org.raml.model.Raml;
import org.raml.parser.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestJsonSchemaValidator
extends AbstractRestSchemaValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RestJsonSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public void validate(String configId, String schemaPath, MuleEvent muleEvent, Raml api) throws BadRequestException {
        try {
            JsonNode data;
            Object input = muleEvent.getMessage().getPayload();
            if (input instanceof InputStream) {
                input = StreamUtils.toString((InputStream)((InputStream)input));
                this.logger.debug("transforming payload to perform JSON Schema validation");
                DataType dataType = DataTypeFactory.create(String.class, (String)muleEvent.getMessage().getDataType().getMimeType());
                muleEvent.getMessage().setPayload(input, dataType);
            }
            if (input instanceof String) {
                data = JsonLoader.fromReader((Reader)new StringReader((String)input));
            } else if (input instanceof byte[]) {
                data = JsonLoader.fromReader((Reader)new InputStreamReader(new ByteArrayInputStream((byte[])input)));
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            JsonSchema schema = (JsonSchema)JsonSchemaCache.getJsonSchemaCache(this.muleContext, configId, api).get((Object)schemaPath);
            ProcessingReport report = schema.validate(data);
            if (!report.isSuccess()) {
                String message = report.iterator().hasNext() ? ((ProcessingMessage)report.iterator().next()).getMessage() : "no message";
                this.logger.info("Schema validation failed: " + message);
                throw new BadRequestException(message);
            }
        }
        catch (ExecutionException e) {
            throw new BadRequestException(e);
        }
        catch (RegistrationException e) {
            throw new BadRequestException(e);
        }
        catch (IOException e) {
            throw new BadRequestException(e);
        }
        catch (ProcessingException e) {
            throw new BadRequestException(e);
        }
    }
}

