/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.RamlBuilder;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.impl.commons.RamlHeader;
import org.raml.v2.impl.commons.RamlVersion;
import org.raml.v2.impl.v08.grammar.Raml08Grammar;
import org.raml.v2.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.suggester.DefaultSuggestion;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.RamlParsingContextType;
import org.raml.v2.suggester.Suggestion;
import org.raml.v2.suggester.Suggestions;
import org.raml.v2.utils.Inflector;

public class RamlSuggester {
    public Suggestions suggestions(String document, int offset) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        RamlParsingContext ramlParsingContext = this.getContext(document, offset);
        int location = ramlParsingContext.getLocation();
        String content = ramlParsingContext.getContent();
        List<Suggestion> suggestions = this.getSuggestions(ramlParsingContext, document, offset, location);
        if (content.isEmpty()) {
            result.addAll(suggestions);
        } else {
            for (Suggestion suggestion : suggestions) {
                if (!suggestion.getValue().startsWith(content)) continue;
                result.add(suggestion);
            }
        }
        Collections.sort(result);
        return new Suggestions(result, content, location);
    }

    private List<Suggestion> getSuggestions(RamlParsingContext context, String document, int offset, int location) {
        switch (context.getContextType()) {
            case FUNCTION_CALL: {
                return this.getFunctionCallSuggestions();
            }
            case STRING_TEMPLATE: {
                return this.getTemplateParameterSuggestions(document, offset, location);
            }
            case LIBRARY_CALL: 
            case ITEM: 
            case VALUE: {
                return this.getSuggestionsAt(context, document, offset, location);
            }
        }
        return this.getSuggestionByColumn(context, document, offset, location);
    }

    @Nonnull
    private List<Suggestion> getTemplateParameterSuggestions(String document, int offset, int location) {
        Node rootNode = this.getRootNode(document, offset, location);
        boolean inTrait = false;
        for (Node node = this.searchNodeAt(rootNode, location); node != null; node = node.getParent()) {
            String value;
            if (!(node instanceof KeyValueNode) || !(((KeyValueNode)node).getKey() instanceof StringNode) || !(value = ((StringNode)((KeyValueNode)node).getKey()).getValue()).equals("traits") && !value.equals("resourceTypes")) continue;
            inTrait = value.equals("traits");
            break;
        }
        return inTrait ? this.defaultTraitParameters() : this.defaultResourceTypeParameters();
    }

    @Nonnull
    private List<Suggestion> defaultTraitParameters() {
        List<Suggestion> suggestions = this.defaultResourceTypeParameters();
        suggestions.add(new DefaultSuggestion("methodName", "The name of the method", ""));
        return suggestions;
    }

    @Nonnull
    private List<Suggestion> defaultResourceTypeParameters() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        suggestions.add(new DefaultSuggestion("resourcePath", "The resource's full URI relative to the baseUri (if any)", ""));
        suggestions.add(new DefaultSuggestion("resourcePathName", "The rightmost path fragment of the resource's relative URI, omitting any parametrize brackets (\"{\" and \"}\")", ""));
        return suggestions;
    }

    @Nonnull
    private List<Suggestion> getFunctionCallSuggestions() {
        Method[] declaredMethods;
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        for (Method declaredMethod : declaredMethods = Inflector.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(declaredMethod.getModifiers()) || !Modifier.isPublic(declaredMethod.getModifiers())) continue;
            suggestions.add(new DefaultSuggestion("!" + declaredMethod.getName(), "", declaredMethod.getName()));
        }
        return suggestions;
    }

    private List<Suggestion> getSuggestionsAt(RamlParsingContext context, String document, int offset, int location) {
        Node root = this.getRootNode(document, offset, location);
        Node node = this.searchNodeAt(root, location);
        if (node != null) {
            if (node.getParent() instanceof KeyValueNode && node.getParent().getChildren().indexOf(node) == 0) {
                node = node.getParent().getParent();
            }
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor(document);
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private Node getRootNode(String document, int offset, int location) {
        RamlBuilder ramlBuilder = new RamlBuilder(RamlBuilder.FIRST_PHASE);
        try {
            return ramlBuilder.build(document);
        }
        catch (Exception e) {
            String header = document.substring(0, location + 1);
            String footer = this.getFooter(document, offset);
            String realDocument = header + footer;
            return ramlBuilder.build(realDocument);
        }
    }

    private List<Suggestion> getSuggestionByColumn(RamlParsingContext context, String document, int offset, int location) {
        int columnNumber = this.getColumnNumber(document, offset);
        Node root = this.getRootNode(document, offset, location);
        Node node = this.searchNodeAt(root, location);
        if (node != null) {
            node = this.getValueNodeAtColumn(columnNumber, node);
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor(document);
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Nonnull
    private RamlParsingContext getContext(String document, int offset) {
        int location;
        RamlParsingContext context = null;
        StringBuilder content = new StringBuilder();
        block7: for (location = offset; location >= 0 && context == null; --location) {
            char character = document.charAt(location);
            switch (character) {
                case ':': {
                    context = new RamlParsingContext(RamlParsingContextType.VALUE, this.revertAndTrim(content), location + 1);
                    continue block7;
                }
                case ',': 
                case '-': 
                case '[': 
                case '{': {
                    context = new RamlParsingContext(RamlParsingContextType.ITEM, this.revertAndTrim(content), location);
                    continue block7;
                }
                case '<': {
                    if (location > 0 && document.charAt(location - 1) == '<') {
                        --location;
                        String contextContent = this.revertAndTrim(content);
                        String[] split = contextContent.split("\\|");
                        if (split.length > 1) {
                            context = new RamlParsingContext(RamlParsingContextType.FUNCTION_CALL, split[split.length - 1].trim(), location);
                            continue block7;
                        }
                        if (contextContent.endsWith("|")) {
                            context = new RamlParsingContext(RamlParsingContextType.FUNCTION_CALL, "", location);
                            continue block7;
                        }
                        context = new RamlParsingContext(RamlParsingContextType.STRING_TEMPLATE, contextContent, location);
                        continue block7;
                    }
                    content.append(character);
                    continue block7;
                }
                case '.': {
                    context = new RamlParsingContext(RamlParsingContextType.LIBRARY_CALL, this.revertAndTrim(content), location);
                    continue block7;
                }
                case '\n': {
                    context = new RamlParsingContext(RamlParsingContextType.ANY, this.revertAndTrim(content), location);
                    continue block7;
                }
                default: {
                    content.append(character);
                }
            }
        }
        if (context == null) {
            context = new RamlParsingContext(RamlParsingContextType.ANY, this.revertAndTrim(content), location);
        }
        return context;
    }

    @Nonnull
    private String revertAndTrim(StringBuilder content) {
        return content.reverse().toString().trim();
    }

    private Node getValueNodeAtColumn(int columnNumber, Node node) {
        if (columnNumber == 0) {
            return node.getRootNode();
        }
        List<Node> path = this.createPathToRoot(node);
        for (Node element : path) {
            if (element instanceof KeyValueNode) {
                if (element.getStartPosition().getColumn() >= columnNumber) continue;
                node = ((KeyValueNode)element).getValue();
                continue;
            }
            if (!(element instanceof ObjectNode) || element.getStartPosition().getColumn() > columnNumber) continue;
            node = element;
        }
        return node;
    }

    @Nonnull
    private List<Node> createPathToRoot(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        for (Node parent = node; parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    @Nonnull
    private String getFooter(String document, int offset) {
        int loc = offset;
        char current = document.charAt(loc);
        while (loc < document.length() - 1 && current != '\n' && current != '}' && current != ']' && current != ',') {
            current = document.charAt(++loc);
        }
        return loc < document.length() ? document.substring(loc) : "";
    }

    private int getColumnNumber(String document, int offset) {
        StringBuilder contextLine = this.getContextLine(document, offset);
        int columnNumber = 0;
        for (int i = 0; i < contextLine.length() && Character.isWhitespace(contextLine.charAt(i)); ++i) {
            ++columnNumber;
        }
        return columnNumber;
    }

    @Nonnull
    private StringBuilder getContextLine(String document, int offset) {
        StringBuilder contextLine = new StringBuilder();
        int location = offset;
        char character = document.charAt(location);
        while (location > 0 && character != '\n') {
            contextLine.append(character);
            character = document.charAt(--location);
        }
        return contextLine.reverse();
    }

    @Nullable
    private Node searchNodeAt(Node root, int location) {
        if (root.getEndPosition().getIndex() != location || !root.getChildren().isEmpty()) {
            List<Node> children = root.getChildren();
            for (Node child : children) {
                if (child.getEndPosition().getIndex() == location) {
                    if (child.getChildren().isEmpty()) {
                        return child;
                    }
                    return this.searchNodeAt(child, location);
                }
                if (child.getEndPosition().getIndex() <= location && !this.isLastNode(child)) continue;
                if (child.getChildren().isEmpty()) {
                    return child;
                }
                return this.searchNodeAt(child, location);
            }
            return null;
        }
        return root;
    }

    private boolean isLastNode(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        List<Node> children = parent.getChildren();
        Node lastChild = children.get(children.size() - 1);
        return node.equals(lastChild);
    }

    @Nullable
    public Rule getRuleFor(String stringContent) {
        try {
            RamlHeader ramlHeader = RamlHeader.parse(stringContent);
            if (RamlVersion.RAML_08 == ramlHeader.getVersion()) {
                return new Raml08Grammar().raml();
            }
            if (ramlHeader.getFragment() != null) {
                return ramlHeader.getFragment().getRule(new Raml10Grammar());
            }
        }
        catch (RamlHeader.InvalidHeaderException invalidHeaderException) {
            // empty catch block
        }
        return null;
    }
}

