/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.nodes.ArrayNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.NodeType;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public class ArrayRule
extends Rule {
    private Rule of;

    public ArrayRule(Rule of) {
        this.of = of;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        List<Suggestion> suggestions = this.of.getSuggestions(node, context);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Suggestion suggestion : suggestions) {
            if (node instanceof ArrayNode && !((ArrayNode)node).isJsonStyle()) {
                result.add(suggestion);
                continue;
            }
            result.add(suggestion.withValue("- " + suggestion.getValue()));
        }
        return result;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        if (pathToRoot.isEmpty()) {
            return Collections.emptyList();
        }
        Node mappingNode = pathToRoot.get(0);
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(mappingNode, context);
            }
        }
        return this.of.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof ArrayNode;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.Array);
        }
        Node result = this.createNodeUsingFactory(node, new Object[0]);
        List<Node> children = node.getChildren();
        for (Node child : children) {
            if (this.of.matches(child)) {
                Node transform = this.of.apply(child);
                child.replaceWith(transform);
                continue;
            }
            child.replaceWith(ErrorNodeFactory.createInvalidArrayElement(child));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Array[" + this.of.getDescription() + "]";
    }
}

