/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons;

import java.util.StringTokenizer;
import org.raml.v2.impl.commons.RamlVersion;
import org.raml.v2.impl.v10.RamlFragment;

public class RamlHeader {
    public static final String RAML_HEADER_PREFIX = "#%RAML";
    private RamlVersion version;
    private RamlFragment fragment;

    public RamlHeader(RamlVersion version, RamlFragment fragment) {
        this.version = version;
        this.fragment = fragment;
    }

    public RamlHeader(RamlVersion version) {
        this(version, null);
    }

    public static RamlHeader parse(String stringContent) throws InvalidHeaderException {
        StringTokenizer lines = new StringTokenizer(stringContent, "\n");
        if (lines.hasMoreElements()) {
            String raml;
            String header = lines.nextToken().trim();
            StringTokenizer headerParts = new StringTokenizer(header);
            if (headerParts.hasMoreTokens() && RAML_HEADER_PREFIX.equals(raml = headerParts.nextToken()) && headerParts.hasMoreTokens()) {
                RamlVersion version;
                String stringVersion = headerParts.nextToken();
                try {
                    version = RamlVersion.parse(stringVersion);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidHeaderVersionException(stringVersion);
                }
                if (version == RamlVersion.RAML_10) {
                    String fragmentText = headerParts.hasMoreTokens() ? headerParts.nextToken() : "";
                    RamlFragment fragment = RamlFragment.byName(fragmentText);
                    if (fragment == null) {
                        throw new InvalidHeaderFragmentException(fragmentText);
                    }
                    return new RamlHeader(RamlVersion.RAML_10, fragment);
                }
                return new RamlHeader(RamlVersion.RAML_08);
            }
            throw new InvalidHeaderException(header);
        }
        throw new MissingHeaderException();
    }

    public RamlVersion getVersion() {
        return this.version;
    }

    public RamlFragment getFragment() {
        return this.fragment;
    }

    public static class MissingHeaderException
    extends InvalidHeaderException {
    }

    public static class InvalidHeaderVersionException
    extends InvalidHeaderException {
        public InvalidHeaderVersionException(String version) {
            super(version);
        }
    }

    public static class InvalidHeaderFragmentException
    extends InvalidHeaderException {
        public InvalidHeaderFragmentException(String fragmentText) {
            super(fragmentText);
        }
    }

    public static class InvalidHeaderException
    extends Exception {
        public InvalidHeaderException() {
        }

        public InvalidHeaderException(String message) {
            super(message);
        }
    }
}

