/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.phase;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.raml.v2.impl.commons.nodes.StringTemplateNode;
import org.raml.v2.impl.commons.nodes.TemplateExpressionNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.Position;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.StringNodeImpl;
import org.raml.v2.phase.Transformer;

public class StringTemplateExpressionTransformer
implements Transformer {
    static Pattern templatePattern = Pattern.compile("<<(.+?)>>");

    @Override
    public boolean matches(Node node) {
        if (node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            return templatePattern.matcher(value).find();
        }
        return false;
    }

    @Override
    public Node transform(Node node) {
        String value = ((StringNode)node).getValue();
        StringTemplateNode stringTemplateNode = new StringTemplateNode(value);
        Matcher templateMatcher = templatePattern.matcher(value);
        Position startPosition = node.getStartPosition();
        int previousEndPosition = 0;
        while (templateMatcher.find()) {
            int start = templateMatcher.start();
            int end = templateMatcher.end();
            if (start > previousEndPosition) {
                StringNodeImpl stringNode = new StringNodeImpl(value.substring(previousEndPosition, start));
                stringNode.setStartPosition(startPosition.rightShift(previousEndPosition));
                stringNode.setEndPosition(startPosition.rightShift(start));
                stringTemplateNode.addChild(stringNode);
            }
            TemplateExpressionNode expressionNode = new TemplateExpressionNode(templateMatcher.group(1));
            expressionNode.setStartPosition(startPosition.rightShift(templateMatcher.start(1)));
            expressionNode.setEndPosition(startPosition.rightShift(templateMatcher.end(1)));
            stringTemplateNode.addChild(expressionNode);
            previousEndPosition = end;
        }
        if (value.length() > previousEndPosition) {
            StringNodeImpl stringNode = new StringNodeImpl(value.substring(previousEndPosition, value.length()));
            stringNode.setStartPosition(startPosition.rightShift(previousEndPosition));
            stringNode.setEndPosition(startPosition.rightShift(value.length()));
            stringTemplateNode.addChild(stringNode);
        }
        return stringTemplateNode;
    }
}

