/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.v08;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.raml.v2.impl.commons.phase.IncludeResolver;
import org.raml.v2.impl.commons.phase.ResourceTypesTraitsTransformer;
import org.raml.v2.impl.commons.phase.StringTemplateExpressionTransformer;
import org.raml.v2.impl.v08.grammar.Raml08Grammar;
import org.raml.v2.impl.v10.phase.TypesTransformer;
import org.raml.v2.loader.ResourceLoader;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.snakeyaml.RamlNodeParser;
import org.raml.v2.phase.GrammarPhase;
import org.raml.v2.phase.Phase;
import org.raml.v2.phase.TransformationPhase;

public class Raml08Builder {
    public Node build(String stringContent, ResourceLoader resourceLoader, String resourceLocation, int maxPhaseNumber) throws IOException {
        Node rootNode = RamlNodeParser.parse(stringContent);
        List<Phase> phases = this.createPhases(resourceLoader, resourceLocation);
        for (int i = 0; i < phases.size(); ++i) {
            Phase phase;
            List<ErrorNode> errorNodes;
            if (i >= maxPhaseNumber || (errorNodes = (rootNode = (phase = phases.get(i)).apply(rootNode)).findDescendantsWith(ErrorNode.class)).isEmpty()) continue;
            return rootNode;
        }
        return rootNode;
    }

    private List<Phase> createPhases(ResourceLoader resourceLoader, String resourceLocation) {
        TransformationPhase first = new TransformationPhase(new IncludeResolver(resourceLoader, resourceLocation), new StringTemplateExpressionTransformer(), new TypesTransformer());
        Raml08Grammar raml08Grammar = new Raml08Grammar();
        GrammarPhase second = new GrammarPhase(raml08Grammar.raml());
        TransformationPhase third = new TransformationPhase(new ResourceTypesTraitsTransformer(raml08Grammar));
        return Arrays.asList(first, second, third);
    }
}

