/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.v10.nodes.types.builtin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNodeVisitor;
import org.raml.v2.nodes.AbstractRamlNode;
import org.raml.v2.nodes.IntegerNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.NodeType;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.utils.NodeSelector;

public class NumericTypeNode
extends AbstractRamlNode
implements TypeNode,
ObjectNode {
    public NumericTypeNode() {
    }

    private NumericTypeNode(NumericTypeNode node) {
        super(node);
    }

    public Number getMinimum() {
        return NodeSelector.selectIntValue("minimum", this.getSource());
    }

    public Number getMaximum() {
        return NodeSelector.selectIntValue("maximum", this.getSource());
    }

    public Number getMultiple() {
        return NodeSelector.selectIntValue("multipleOf", this.getSource());
    }

    public String getFormat() {
        return NodeSelector.selectStringValue("format", this.getSource());
    }

    @Override
    @Nonnull
    public Node copy() {
        return new NumericTypeNode(this);
    }

    @Override
    public NodeType getType() {
        return NodeType.Object;
    }

    @Override
    public <T> T visit(TypeNodeVisitor<T> visitor) {
        return visitor.visitNumber(this);
    }

    @Nonnull
    public List<Number> getEnumValues() {
        Node values = this.get("enum");
        ArrayList enumValues = Lists.newArrayList();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add(((IntegerNode)node).getValue());
            }
        }
        return enumValues;
    }
}

