/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.utils;

import javax.annotation.Nullable;
import org.raml.v2.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.snakeyaml.SYIncludeNode;

public class NodeUtils {
    @Nullable
    public static Node getGrandParent(Node node) {
        return NodeUtils.getAncestor(node, 2);
    }

    @Nullable
    public static Node getAncestor(Node node, int level) {
        Node parent;
        int i = 1;
        for (parent = node.getParent(); i < level && parent != null; parent = parent.getParent(), ++i) {
        }
        return parent;
    }

    private static Node traverseToRoot(Node node) {
        if (node == null || node instanceof RamlDocumentNode) {
            return node;
        }
        if (node.getParent() == null) {
            return node;
        }
        return NodeUtils.traverseToRoot(node.getParent());
    }

    public static ObjectNode getTypesRoot(Node node) {
        Node typesRoot = NodeUtils.traverseToRoot(node).get("types");
        return typesRoot instanceof ObjectNode ? (ObjectNode)typesRoot : null;
    }

    public static boolean isStringNode(Node node) {
        return node != null && node instanceof StringNode;
    }

    public static Node getType(Node node) {
        return node.get("type") != null ? node.get("type") : node.get("schema");
    }

    public static boolean isErrorResult(Node node) {
        return node != null && (node instanceof ErrorNode || node.findDescendantsWith(ErrorNode.class).size() > 0);
    }

    public static TypeNode getType(String typeName, Node node) {
        Node definitionContext = NodeUtils.getNodeContext(node);
        if (definitionContext == null) {
            return null;
        }
        if (typeName != null && typeName.contains(".")) {
            return NodeUtils.getTypeFromContext(typeName, definitionContext);
        }
        if (definitionContext.get("types") != null) {
            Node type = definitionContext.get("types").get(typeName);
            return type instanceof TypeNode ? (TypeNode)type : null;
        }
        return null;
    }

    private static TypeNode getTypeFromContext(String typeName, Node definitionContext) {
        Node localContext = definitionContext.get("uses");
        if (localContext == null) {
            return null;
        }
        Node resolution = localContext;
        String objectName = typeName.substring(typeName.lastIndexOf(".") + 1);
        String navigationPath = typeName.substring(0, typeName.lastIndexOf("."));
        if (!navigationPath.contains(".")) {
            return resolution != null && resolution.get(navigationPath) != null && resolution.get(navigationPath).get("types") != null && resolution.get(navigationPath).get("types").get(objectName) instanceof TypeNode ? (TypeNode)resolution.get(navigationPath).get("types").get(objectName) : null;
        }
        for (String path : navigationPath.split(".")) {
            if (resolution == null) {
                return null;
            }
            resolution = resolution.get(path);
        }
        return resolution != null && resolution.get("types") != null && resolution.get("types").get(objectName) instanceof TypeNode ? (TypeNode)resolution.get("types").get(objectName) : null;
    }

    private static Node getNodeContext(Node node) {
        if (node == null || node instanceof RamlDocumentNode) {
            return node;
        }
        if (node.getSource() != null && node.getSource() instanceof SYIncludeNode) {
            return node;
        }
        if (node.getParent() == null) {
            return node;
        }
        return NodeUtils.getNodeContext(node.getParent());
    }
}

