/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.raml.v2.grammar.rule.xml.XsdResourceResolver;
import org.raml.v2.loader.ResourceLoader;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.SchemaNodeImpl;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.utils.NodeUtils;
import org.xml.sax.SAXException;

public class SchemaGenerator {
    private ResourceLoader resourceLoader;

    public SchemaGenerator(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public SchemaGenerator() {
    }

    public Schema generateXmlSchema(Node node) throws SAXException {
        if (!SchemaGenerator.isXmlSchemaNode(node)) {
            throw new SAXException("invalid xml schema");
        }
        SchemaNodeImpl schema = (SchemaNodeImpl)node;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new XsdResourceResolver(this.resourceLoader, schema.getSchemaPath()));
        return factory.newSchema(new StreamSource(new StringReader(schema.getValue())));
    }

    public JsonSchema generateJsonSchema(Node node) throws IOException, ProcessingException {
        if (!SchemaGenerator.isJsonSchemaNode(node)) {
            throw new ProcessingException("invalid json schema");
        }
        SchemaNodeImpl schema = (SchemaNodeImpl)node;
        JsonNode jsonSchema = JsonLoader.fromString((String)schema.getValue());
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().freeze();
        if (schema.getTypeReference() != null) {
            return factory.getJsonSchema(jsonSchema, "/definitions/" + schema.getTypeReference());
        }
        return factory.getJsonSchema(jsonSchema);
    }

    public static boolean isJsonSchemaNode(Node node) {
        return NodeUtils.isStringNode(node) && SchemaGenerator.nodeStartsWith((StringNode)node, "{");
    }

    public static boolean isXmlSchemaNode(Node node) {
        return NodeUtils.isStringNode(node) && SchemaGenerator.nodeStartsWith((StringNode)node, "<");
    }

    private static boolean isSchema(Node node) {
        return node instanceof SchemaNodeImpl;
    }

    public static boolean isSchemaNode(Node node) {
        return SchemaGenerator.isSchema(node) || SchemaGenerator.isJsonSchemaNode(node) || SchemaGenerator.isXmlSchemaNode(node);
    }

    public static boolean nodeStartsWith(StringNode node, String prefix) {
        return node.getValue().startsWith(prefix);
    }

    public static void wrapNode(Node node, String actualPath) {
        SchemaNodeImpl schemaNode = new SchemaNodeImpl((StringNode)node, actualPath);
        node.replaceWith(schemaNode);
    }
}

