/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parser;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.injector.RamlUpdater;
import org.mule.module.apikit.parser.ParserWrapper;
import org.mule.raml.implv1.model.RamlImplV1;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.util.BeanUtils;
import org.raml.emitter.RamlEmitter;
import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.loader.CompositeResourceLoader;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.FileResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentBuilder;
import org.raml.parser.visitor.RamlValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWrapperV1
implements ParserWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ParserWrapperV1.class);
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private Raml baseApi;

    public ParserWrapperV1(String ramlPath, String appHome) {
        this.ramlPath = ramlPath;
        this.resourceLoader = appHome != null ? new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(appHome)}) : new DefaultResourceLoader();
    }

    @Override
    public void validate() {
        List<Object> results = new ArrayList<ValidationResult>();
        InputStream content = this.resourceLoader.fetchResource(this.ramlPath);
        if (content != null) {
            results = RamlValidationService.createDefault((ResourceLoader)this.resourceLoader, (TagResolver[])new TagResolver[0]).validate(this.ramlPath);
        } else {
            results.add(ValidationResult.createErrorResult((String)"Raml resource not found "));
        }
        List errors = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, results);
        if (!errors.isEmpty()) {
            String msg = this.aggregateMessages(errors, "Invalid API descriptor -- errors found: ");
            throw new ApikitRuntimeException(msg);
        }
        List warnings = ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, results);
        if (!warnings.isEmpty()) {
            logger.warn(this.aggregateMessages(warnings, "API descriptor Warnings -- warnings found: "));
        }
    }

    private String aggregateMessages(List<ValidationResult> results, String header) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(results.size()).append("\n\n");
        for (ValidationResult result : results) {
            sb.append(result.getMessage()).append(" -- ");
            sb.append(" file: ");
            sb.append(result.getIncludeName() != null ? result.getIncludeName() : this.ramlPath);
            if (result.getLine() != -1) {
                sb.append(" -- line ");
                sb.append(result.getLine());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public IRaml build() {
        RamlDocumentBuilder builder = new RamlDocumentBuilder(this.resourceLoader, new TagResolver[0]);
        Raml api = (Raml)builder.build(this.ramlPath);
        return new RamlImplV1(api);
    }

    @Override
    public String dump(IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        Raml ramlImpl = this.getRamlImpl(api);
        if (!oldSchemeHostPort.equals(newSchemeHostPort)) {
            Raml clone = this.shallowCloneRaml(ramlImpl);
            clone.setBaseUri(api.getBaseUri().replace(oldSchemeHostPort, newSchemeHostPort));
            ramlImpl = clone;
        }
        return new RamlEmitter().dump(ramlImpl);
    }

    private Raml shallowCloneRaml(Raml source) {
        try {
            return (Raml)BeanUtils.cloneBean((Object)source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RamlUpdater getRamlUpdater(IRaml api, AbstractConfiguration configuration) {
        if (this.baseApi == null) {
            this.baseApi = this.deepCloneRaml(this.getRamlImpl(api));
        }
        return new RamlUpdater(this.deepCloneRaml(this.baseApi), configuration);
    }

    @Override
    public void updateBaseUri(IRaml api, String baseUri) {
        Raml ramlImpl = this.getRamlImpl(api);
        ramlImpl.setBaseUri(baseUri);
        this.cleanBaseUriParameters(ramlImpl);
    }

    private void cleanBaseUriParameters(Raml ramlApi) {
        ramlApi.getBaseUriParameters().clear();
        this.cleanBaseUriParameters(ramlApi.getResources());
    }

    private void cleanBaseUriParameters(Map<String, Resource> resources) {
        for (Resource resource : resources.values()) {
            resource.getBaseUriParameters().clear();
            for (Action action : resource.getActions().values()) {
                action.getBaseUriParameters().clear();
            }
            if (resource.getResources().isEmpty()) continue;
            this.cleanBaseUriParameters(resource.getResources());
        }
    }

    private Raml getRamlImpl(IRaml api) {
        return ((RamlImplV1)api).getRaml();
    }

    private Raml deepCloneRaml(Raml source) {
        Raml target = (Raml)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)source));
        this.copyCompiledSchemas(source, target);
        return target;
    }

    private void copyCompiledSchemas(Raml source, Raml target) {
        target.setCompiledSchemas(source.getCompiledSchemas());
    }
}

