/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.parser;

import java.io.InputStream;
import java.util.List;
import org.mule.module.apikit.AbstractConfiguration;
import org.mule.module.apikit.UrlUtils;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.injector.RamlUpdater;
import org.mule.module.apikit.parser.ParserWrapper;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.interfaces.model.IRaml;
import org.raml.v2.RamlBuilder;
import org.raml.v2.loader.CompositeResourceLoader;
import org.raml.v2.loader.DefaultResourceLoader;
import org.raml.v2.loader.FileResourceLoader;
import org.raml.v2.loader.ResourceLoader;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.Position;
import org.raml.v2.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWrapperV2
implements ParserWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ParserWrapperV2.class);
    private final String ramlPath;
    private final ResourceLoader resourceLoader;

    public ParserWrapperV2(String ramlPath, String appHome) {
        this.ramlPath = ramlPath;
        this.resourceLoader = appHome != null ? new CompositeResourceLoader(new ResourceLoader[]{new DefaultResourceLoader(), new FileResourceLoader(appHome)}) : new DefaultResourceLoader();
    }

    @Override
    public void validate() {
        String errorMessage = null;
        InputStream content = this.resourceLoader.fetchResource(this.ramlPath);
        if (content != null) {
            RamlBuilder builder = new RamlBuilder();
            Node raml = builder.build(StreamUtils.reader((InputStream)content), this.resourceLoader, this.ramlPath);
            List errors = raml.findDescendantsWith(ErrorNode.class);
            if (!errors.isEmpty()) {
                errorMessage = this.errorSummary(errors);
            }
        } else {
            errorMessage = "Raml resource not found ";
        }
        if (errorMessage != null) {
            throw new ApikitRuntimeException(errorMessage);
        }
    }

    private String errorSummary(List<ErrorNode> errors) {
        StringBuilder message = new StringBuilder("Invalid API descriptor -- errors found: ");
        message.append(errors.size()).append("\n\n");
        for (ErrorNode error : errors) {
            message.append(error.getErrorMessage()).append(" -- file: ");
            Position startPosition = error.getStartPosition();
            if (startPosition.getResource() != null) {
                message.append(startPosition.getResource());
            } else {
                message.append(this.ramlPath);
            }
            if (startPosition.getLine() >= 0) {
                message.append(" -- line ");
                message.append(startPosition.getLine());
            }
            message.append("\n");
        }
        return message.toString();
    }

    @Override
    public IRaml build() {
        return ParserV2Utils.build((ResourceLoader)this.resourceLoader, (String)this.ramlPath);
    }

    @Override
    public String dump(IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        String dump = StreamUtils.toString((InputStream)this.resourceLoader.fetchResource(this.ramlPath));
        dump = UrlUtils.rewriteBaseUri(dump, newSchemeHostPort);
        return dump;
    }

    @Override
    public RamlUpdater getRamlUpdater(IRaml api, AbstractConfiguration configuration) {
        throw new UnsupportedOperationException("RAML 1.0 is read only");
    }

    @Override
    public void updateBaseUri(IRaml api, String baseUri) {
        logger.debug("RAML 1.0 parser does not support base uri updates");
    }
}

