/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.DefaultValue;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.grammar.rule.StringValueRule;
import org.raml.v2.internal.framework.nodes.DefaultPosition;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.KeyValueNodeImpl;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class KeyValueRule
extends Rule {
    private final Rule keyRule;
    private final Rule valueRule;
    private String description;
    private boolean required;
    private DefaultValue defaultValue;

    public KeyValueRule(Rule keyRule, Rule valueRule) {
        this.keyRule = keyRule;
        this.valueRule = valueRule;
        this.required = false;
    }

    public KeyValueRule required() {
        this.required = true;
        return this;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return this.getValueRule().getSuggestions(node, context);
    }

    @Nonnull
    public List<Suggestion> getKeySuggestions(Node node, RamlParsingContext context) {
        List<Suggestion> suggestions = this.getKeyRule().getSuggestions(node, context);
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        Iterator<Suggestion> i$ = suggestions.iterator();
        while (i$.hasNext()) {
            Suggestion suggestion;
            Suggestion keySuggest = suggestion = i$.next();
            if (this.description != null) {
                keySuggest = suggestion.withDescription(this.description);
            }
            keySuggest = keySuggest.withValue(suggestion.getValue() + ": ");
            result.add(keySuggest);
        }
        return result;
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        if (!pathToRoot.isEmpty()) {
            return this.valueRule.getSuggestions(pathToRoot.subList(1, pathToRoot.size()), context);
        }
        return super.getSuggestions(pathToRoot, context);
    }

    public KeyValueRule description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof KeyValueNode && this.getKeyRule().matches(((KeyValueNode)node).getKey());
    }

    public boolean repeated() {
        return !(this.getKeyRule() instanceof StringValueRule);
    }

    public Rule getKeyRule() {
        return this.keyRule;
    }

    public Rule getValueRule() {
        return this.valueRule;
    }

    @Override
    public KeyValueRule then(Class<? extends Node> clazz) {
        super.then(clazz);
        return this;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!(node instanceof KeyValueNode)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.KeyValue);
        }
        if (!this.getKeyRule().matches(((KeyValueNode)node).getKey())) {
            return this.getKeyRule().apply(node);
        }
        Node result = this.createNodeUsingFactory(node, new Object[0]);
        KeyValueNode keyValueNode = (KeyValueNode)node;
        Node key = keyValueNode.getKey();
        key.replaceWith(this.getKeyRule().apply(key));
        Node value = keyValueNode.getValue();
        value.replaceWith(this.getValueRule().apply(value));
        return result;
    }

    @Override
    public String getDescription() {
        return this.getKeyRule().getDescription() + ": " + this.getValueRule().getDescription();
    }

    public boolean isRequired() {
        return this.required;
    }

    @Nonnull
    public KeyValueRule defaultValue(DefaultValue defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public void applyDefault(Node parent) {
        if (this.defaultValue == null) {
            return;
        }
        if (!(this.getKeyRule() instanceof StringValueRule)) {
            throw new RuntimeException("Key rule " + this.getKeyRule().getClass().getSimpleName() + " does not support default values");
        }
        Node valueNode = this.defaultValue.getDefaultValue(parent);
        if (valueNode == null) {
            return;
        }
        StringNodeImpl keyNode = new StringNodeImpl(((StringValueRule)this.getKeyRule()).getValue());
        KeyValueNodeImpl newNode = new KeyValueNodeImpl(keyNode, valueNode);
        newNode.setEndPosition(DefaultPosition.emptyPosition());
        newNode.setStartPosition(DefaultPosition.emptyPosition());
        parent.addChild(newNode);
    }
}

