/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.impl.commons.model.CommonAttributes;
import org.raml.v2.internal.impl.commons.model.ExampleSpec;
import org.raml.v2.internal.impl.commons.model.RamlValidationResult;
import org.raml.v2.internal.impl.commons.model.builder.ModelUtils;
import org.raml.v2.internal.impl.commons.nodes.ExampleTypeNode;
import org.raml.v2.internal.impl.commons.nodes.PayloadValidationResultNode;
import org.raml.v2.internal.utils.NodeSelector;
import org.raml.v2.internal.utils.NodeUtils;
import org.raml.v2.internal.utils.NodeValidator;

public class TypeDeclaration
extends CommonAttributes {
    private KeyValueNode node;

    public TypeDeclaration(Node node) {
        this.node = (KeyValueNode)node;
    }

    @Override
    protected Node getNode() {
        return this.node.getValue();
    }

    public String name() {
        return ((StringNode)this.node.getKey()).getValue();
    }

    public ExampleSpec example() {
        ExampleTypeNode example = (ExampleTypeNode)NodeSelector.selectFrom("example", this.getNode());
        if (example != null) {
            return new ExampleSpec(example.getParent());
        }
        return null;
    }

    public List<ExampleSpec> examples() {
        return this.getList("examples", ExampleSpec.class);
    }

    public String schemaContent() {
        List<String> type = this.type("type");
        type.addAll(this.type("schema"));
        if (!type.isEmpty()) {
            return type.get(0);
        }
        return null;
    }

    public List<String> schema() {
        return this.type("schema");
    }

    public List<String> type() {
        return this.type("type");
    }

    private List<String> type(String key) {
        ArrayList<String> result = new ArrayList<String>();
        Node type = NodeSelector.selectFrom(key, this.getNode());
        if (type instanceof SimpleTypeNode) {
            result.add(((SimpleTypeNode)type).getLiteralValue());
        } else if (type != null) {
            result.add(type.toString());
        }
        return result;
    }

    public List<RamlValidationResult> validate(String payload) {
        NodeValidator validator = new NodeValidator(NodeUtils.getResourceLoader(this.node));
        PayloadValidationResultNode payloadValidationResultNode = validator.validatePayload(this.node.getValue(), payload);
        ArrayList<RamlValidationResult> results = new ArrayList<RamlValidationResult>();
        for (ErrorNode errorNode : payloadValidationResultNode.findDescendantsWith(ErrorNode.class)) {
            results.add(new RamlValidationResult(errorNode));
        }
        return results;
    }

    public Boolean required() {
        Boolean required = (Boolean)ModelUtils.getSimpleValue("required", this.getNode());
        return required == null ? true : required;
    }

    public String defaultValue() {
        Object defaultValue = ModelUtils.getSimpleValue("default", this.getNode());
        return defaultValue != null ? defaultValue.toString() : null;
    }
}

