/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.impl.commons.model.Api;
import org.raml.v2.internal.impl.commons.model.builder.ModelUtils;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;

public class ModelProxyBuilder {
    public static <T> T createRaml(Class<T> apiInterface, RamlDocumentNode delegateNode) {
        return (T)Proxy.newProxyInstance(apiInterface.getClassLoader(), new Class[]{apiInterface}, (InvocationHandler)new SimpleProxy(new Api(delegateNode)));
    }

    private static class SimpleProxy
    implements InvocationHandler {
        private Object delegate;

        public SimpleProxy(Object delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("delegate cannot be null");
            }
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> returnType = method.getReturnType();
            Type genericReturnType = method.getGenericReturnType();
            Method delegateMethod = this.findMatchingMethod(method);
            if (ModelUtils.isPrimitiveOrWrapperOrString(returnType) || this.isObject(returnType)) {
                return delegateMethod.invoke(this.delegate, args);
            }
            if (!(genericReturnType instanceof ParameterizedType)) {
                Object result = delegateMethod.invoke(this.delegate, args);
                if (result == null) {
                    return null;
                }
                if (result instanceof List) {
                    if (((List)result).isEmpty()) {
                        return null;
                    }
                    result = ((List)result).get(0);
                }
                return Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)new SimpleProxy(result));
            }
            if (List.class.isAssignableFrom(returnType)) {
                ArrayList<Object> returnList = new ArrayList<Object>();
                List result = (List)delegateMethod.invoke(this.delegate, args);
                Class itemClass = (Class)((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                if (ModelUtils.isPrimitiveOrWrapperOrString(itemClass)) {
                    return result;
                }
                for (Object item : result) {
                    returnList.add(Proxy.newProxyInstance(itemClass.getClassLoader(), new Class[]{itemClass}, (InvocationHandler)new SimpleProxy(item)));
                }
                return returnList;
            }
            throw new RuntimeException("case not handled yet... " + returnType.getName());
        }

        private boolean isObject(Class<?> type) {
            return "java.lang.Object".equals(type.getName());
        }

        private Method findMatchingMethod(Method method) {
            try {
                return this.delegate.getClass().getMethod(this.getActualMethodName(method), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Method not found: " + this.delegate.getClass().getName() + "." + method.getName());
            }
        }

        private String getActualMethodName(Method method) {
            if (method.toGenericString().contains("List<org.raml.v2.api.model.v08.bodies.BodyLike> org.raml.v2.api.model.v08.methods.MethodBase.body()") || method.toGenericString().contains("List<org.raml.v2.api.model.v08.bodies.BodyLike> org.raml.v2.api.model.v08.bodies.Response.body()")) {
                return "bodyV08";
            }
            if (method.toGenericString().contains("List<org.raml.v2.api.model.v08.api.GlobalSchema> org.raml.v2.api.model.v08.api.Api.schemas()")) {
                return "schemasV08";
            }
            return method.getName();
        }
    }
}

