/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model.builder;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.utils.NodeSelector;

public class ModelUtils {
    private static final Set<Class<?>> WRAPPERS_PLUS_STRING = new HashSet();

    public static <T> T getSimpleValue(String key, Node node) {
        return NodeSelector.selectType(key, node, null);
    }

    public static String getStringValue(String key, Node node) {
        return (String)ModelUtils.getSimpleValue(key, node);
    }

    public static StringType getStringTypeValue(String key, Node node) {
        String value = (String)ModelUtils.getSimpleValue(key, node);
        if (value != null) {
            return new StringType(value);
        }
        return null;
    }

    public static boolean isPrimitiveOrWrapperOrString(Class<?> type) {
        return type.isPrimitive() || WRAPPERS_PLUS_STRING.contains(type);
    }

    static {
        WRAPPERS_PLUS_STRING.add(Boolean.class);
        WRAPPERS_PLUS_STRING.add(Character.class);
        WRAPPERS_PLUS_STRING.add(Byte.class);
        WRAPPERS_PLUS_STRING.add(Short.class);
        WRAPPERS_PLUS_STRING.add(Integer.class);
        WRAPPERS_PLUS_STRING.add(Long.class);
        WRAPPERS_PLUS_STRING.add(Float.class);
        WRAPPERS_PLUS_STRING.add(Double.class);
        WRAPPERS_PLUS_STRING.add(BigInteger.class);
        WRAPPERS_PLUS_STRING.add(BigDecimal.class);
        WRAPPERS_PLUS_STRING.add(String.class);
    }
}

