/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes.types.builtin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.nodes.AbstractRamlNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.SimpleTypeNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.internal.utils.NodeSelector;

public abstract class NumericTypeNode<T>
extends AbstractRamlNode
implements TypeNode,
ObjectNode {
    public NumericTypeNode() {
    }

    protected NumericTypeNode(NumericTypeNode node) {
        super(node);
    }

    public Number getMinimum() {
        return NodeSelector.selectIntValue("minimum", this.getSource());
    }

    public Number getMaximum() {
        return NodeSelector.selectIntValue("maximum", this.getSource());
    }

    public Number getMultiple() {
        return NodeSelector.selectIntValue("multipleOf", this.getSource());
    }

    public String getFormat() {
        return NodeSelector.selectStringValue("format", this.getSource());
    }

    @Override
    public NodeType getType() {
        return NodeType.Object;
    }

    @Nonnull
    public List<Number> getEnumValues() {
        Node values = this.get("enum");
        ArrayList enumValues = Lists.newArrayList();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add((Number)((SimpleTypeNode)node).getValue());
            }
        }
        return enumValues;
    }
}

