/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.parser.visitor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.mule.raml.implv1.parser.rule.ValidationResultImpl;
import org.mule.raml.implv1.parser.visitor.RamlDocumentBuilderImpl;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.visitor.IRamlDocumentBuilder;
import org.mule.raml.interfaces.parser.visitor.IRamlValidationService;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlValidationService;

public class RamlValidationServiceImpl
implements IRamlValidationService {
    RamlDocumentBuilderImpl ramlDocumentBuilderImpl;
    List<IValidationResult> errors;
    List<IValidationResult> warnings;

    public RamlValidationServiceImpl(IRamlDocumentBuilder ramlDocumentBuilder) {
        this.ramlDocumentBuilderImpl = (RamlDocumentBuilderImpl)ramlDocumentBuilder.getInstance();
    }

    public IRamlValidationService validate(String resource) {
        return this.validate(null, resource);
    }

    public IRamlValidationService validate(String resourceContent, String resource) {
        ResourceLoader resourceLoader = this.ramlDocumentBuilderImpl.getResourceLoader();
        List results = new ArrayList();
        InputStream content = null;
        if (resourceContent != null) {
            results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(resourceContent, resource);
        } else {
            content = resourceLoader.fetchResource(resource);
            if (content != null) {
                results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(resource);
            }
        }
        if (resourceContent == null && content == null) {
            results.add(ValidationResult.createErrorResult((String)"Raml resource not found "));
        }
        this.errors = new ArrayList<IValidationResult>();
        for (ValidationResult validationResult : ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, results)) {
            this.errors.add(new ValidationResultImpl(validationResult));
        }
        this.warnings = new ArrayList<IValidationResult>();
        for (ValidationResult validationResult : ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, results)) {
            this.warnings.add(new ValidationResultImpl(validationResult));
        }
        return this;
    }

    public List<IValidationResult> getErrors() {
        return this.errors;
    }

    public List<IValidationResult> getWarnings() {
        return this.warnings;
    }
}

