/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v10.model.MimeTypeImpl;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.implv2.v10.model.ResourceImpl;
import org.mule.raml.implv2.v10.model.ResponseImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.ISecurityReference;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v10.bodies.Response;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;

public class ActionImpl
implements IAction {
    private Method method;

    public ActionImpl(Method method) {
        this.method = method;
    }

    public IActionType getType() {
        return IActionType.valueOf((String)this.method.method().toUpperCase());
    }

    public boolean hasBody() {
        return !this.method.body().isEmpty();
    }

    public Map<String, IResponse> getResponses() {
        LinkedHashMap<String, IResponse> result = new LinkedHashMap<String, IResponse>();
        for (Response response : this.method.responses()) {
            result.put(response.code().value(), new ResponseImpl(response));
        }
        return result;
    }

    public IResource getResource() {
        return new ResourceImpl(this.method.resource());
    }

    public Map<String, IMimeType> getBody() {
        LinkedHashMap<String, IMimeType> result = new LinkedHashMap<String, IMimeType>();
        for (TypeDeclaration typeDeclaration : this.method.body()) {
            result.put(typeDeclaration.name(), new MimeTypeImpl(typeDeclaration));
        }
        return result;
    }

    public Map<String, IParameter> getQueryParameters() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (TypeDeclaration typeDeclaration : this.method.queryParameters()) {
            result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
        }
        return result;
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public Map<String, IParameter> getHeaders() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (TypeDeclaration typeDeclaration : this.method.headers()) {
            result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
        }
        return result;
    }

    public List<ISecurityReference> getSecuredBy() {
        throw new UnsupportedOperationException();
    }

    public List<String> getIs() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, IParameter> headers) {
        throw new UnsupportedOperationException();
    }

    public void setQueryParameters(Map<String, IParameter> queryParameters) {
        throw new UnsupportedOperationException();
    }

    public void setBody(Map<String, IMimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void addResponse(String key, IResponse response) {
        throw new UnsupportedOperationException();
    }

    public void addSecurityReference(String securityReferenceName) {
        throw new UnsupportedOperationException();
    }

    public void addIs(String is) {
        throw new UnsupportedOperationException();
    }
}

