/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.utils.JSonDumper;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class JsonSchemaValidationRule
extends Rule {
    private JsonSchema schema;

    public JsonSchemaValidationRule(JsonSchemaExternalType schemaNode) {
        try {
            this.schema = SchemaGenerator.generateJsonSchema(schemaNode);
        }
        catch (Exception e) {
            this.schema = null;
        }
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Lists.newArrayList();
    }

    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)"Invalid JsonSchema");
        }
        try {
            String value = node instanceof StringNode ? ((StringNode)node).getValue() : JSonDumper.dump(node);
            if (value == null) {
                return ErrorNodeFactory.createInvalidJsonExampleNode((String)("Source example is not valid: " + node));
            }
            JsonNode json = JsonLoader.fromString((String)value);
            ProcessingReport report = this.schema.validate(json);
            if (!report.isSuccess()) {
                Iterator iterator = report.iterator();
                ArrayList errors = Lists.newArrayList();
                while (iterator.hasNext()) {
                    ProcessingMessage next = (ProcessingMessage)iterator.next();
                    errors.add(next.toString());
                }
                return ErrorNodeFactory.createInvalidJsonExampleNode((String)("{\n" + Joiner.on((String)",\n").join((Iterable)errors) + "\n}"));
            }
        }
        catch (ProcessingException | IOException e) {
            return ErrorNodeFactory.createInvalidJsonExampleNode((String)("Invalid json content : " + node.toString()));
        }
        return node;
    }

    public String getDescription() {
        return "JSON Schema validation rule";
    }
}

