(function(){function Lexer(options){this.tokens=[],this.tokens.links={},this.options=options||marked.defaults,this.rules=block.normal,this.options.gfm&&(this.options.tables?this.rules=block.tables:this.rules=block.gfm)}function InlineLexer(links,options){if(this.options=options||marked.defaults,this.links=links,this.rules=inline.normal,this.renderer=this.options.renderer||new Renderer,this.renderer.options=this.options,!this.links)throw new Error("Tokens array requires a `links` property.");this.options.gfm?this.options.breaks?this.rules=inline.breaks:this.rules=inline.gfm:this.options.pedantic&&(this.rules=inline.pedantic)}function Renderer(options){this.options=options||{}}function Parser(options){this.tokens=[],this.token=null,this.options=options||marked.defaults,this.options.renderer=this.options.renderer||new Renderer,this.renderer=this.options.renderer,this.renderer.options=this.options}function escape(html,encode){return html.replace(encode?/&/g:/&(?!#?\w+;)/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}function unescape(html){return html.replace(/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/g,function(_,n){return n=n.toLowerCase(),"colon"===n?":":"#"===n.charAt(0)?"x"===n.charAt(1)?String.fromCharCode(parseInt(n.substring(2),16)):String.fromCharCode(+n.substring(1)):""})}function replace(regex,opt){return regex=regex.source,opt=opt||"",function self(name,val){return name?(val=val.source||val,val=val.replace(/(^|[^\[])\^/g,"$1"),regex=regex.replace(name,val),self):new RegExp(regex,opt)}}function noop(){}function merge(obj){for(var target,key,i=1;i<arguments.length;i++){target=arguments[i];for(key in target)Object.prototype.hasOwnProperty.call(target,key)&&(obj[key]=target[key])}return obj}function marked(src,opt,callback){if(callback||"function"==typeof opt){callback||(callback=opt,opt=null),opt=merge({},marked.defaults,opt||{});var tokens,pending,highlight=opt.highlight,i=0;try{tokens=Lexer.lex(src,opt)}catch(e){return callback(e)}pending=tokens.length;var done=function(err){if(err)return opt.highlight=highlight,callback(err);var out;try{out=Parser.parse(tokens,opt)}catch(e){err=e}return opt.highlight=highlight,err?callback(err):callback(null,out)};if(!highlight||highlight.length<3)return done();if(delete opt.highlight,!pending)return done();for(;i<tokens.length;i++)!function(token){return"code"!==token.type?--pending||done():highlight(token.text,token.lang,function(err,code){return err?done(err):null==code||code===token.text?--pending||done():(token.text=code,token.escaped=!0,void(--pending||done()))})}(tokens[i])}else try{return opt&&(opt=merge({},marked.defaults,opt)),Parser.parse(Lexer.lex(src,opt),opt)}catch(e){if(e.message+="\nPlease report this to https://github.com/chjj/marked.",(opt||marked.defaults).silent)return"<p>An error occured:</p><pre>"+escape(e.message+"",!0)+"</pre>";throw e}}var block={newline:/^\n+/,code:/^( {4}[^\n]+\n*)+/,fences:noop,hr:/^( *[-*_]){3,} *(?:\n+|$)/,heading:/^ *(#{1,6}) *([^\n]+?) *#* *(?:\n+|$)/,nptable:noop,lheading:/^([^\n]+)\n *(=|-){2,} *(?:\n+|$)/,blockquote:/^( *>[^\n]+(\n(?!def)[^\n]+)*\n*)+/,list:/^( *)(bull) [\s\S]+?(?:hr|def|\n{2,}(?! )(?!\1bull )\n*|\s*$)/,html:/^ *(?:comment *(?:\n|\s*$)|closed *(?:\n{2,}|\s*$)|closing *(?:\n{2,}|\s*$))/,def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +["(]([^\n]+)[")])? *(?:\n+|$)/,table:noop,paragraph:/^((?:[^\n]+\n?(?!hr|heading|lheading|blockquote|tag|def))+)\n*/,text:/^[^\n]+/};block.bullet=/(?:[*+-]|\d+\.)/,block.item=/^( *)(bull) [^\n]*(?:\n(?!\1bull )[^\n]*)*/,block.item=replace(block.item,"gm")(/bull/g,block.bullet)(),block.list=replace(block.list)(/bull/g,block.bullet)("hr","\\n+(?=\\1?(?:[-*_] *){3,}(?:\\n+|$))")("def","\\n+(?="+block.def.source+")")(),block.blockquote=replace(block.blockquote)("def",block.def)(),block._tag="(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:/|[^\\w\\s@]*@)\\b",block.html=replace(block.html)("comment",/<!--[\s\S]*?-->/)("closed",/<(tag)[\s\S]+?<\/\1>/)("closing",/<tag(?:"[^"]*"|'[^']*'|[^'">])*?>/)(/tag/g,block._tag)(),block.paragraph=replace(block.paragraph)("hr",block.hr)("heading",block.heading)("lheading",block.lheading)("blockquote",block.blockquote)("tag","<"+block._tag)("def",block.def)(),block.normal=merge({},block),block.gfm=merge({},block.normal,{fences:/^ *(`{3,}|~{3,})[ \.]*(\S+)? *\n([\s\S]*?)\s*\1 *(?:\n+|$)/,paragraph:/^/,heading:/^ *(#{1,6}) +([^\n]+?) *#* *(?:\n+|$)/}),block.gfm.paragraph=replace(block.paragraph)("(?!","(?!"+block.gfm.fences.source.replace("\\1","\\2")+"|"+block.list.source.replace("\\1","\\3")+"|")(),block.tables=merge({},block.gfm,{nptable:/^ *(\S.*\|.*)\n *([-:]+ *\|[-| :]*)\n((?:.*\|.*(?:\n|$))*)\n*/,table:/^ *\|(.+)\n *\|( *[-:]+[-| :]*)\n((?: *\|.*(?:\n|$))*)\n*/}),Lexer.rules=block,Lexer.lex=function(src,options){var lexer=new Lexer(options);return lexer.lex(src)},Lexer.prototype.lex=function(src){return src=src.replace(/\r\n|\r/g,"\n").replace(/\t/g,"    ").replace(/\u00a0/g," ").replace(/\u2424/g,"\n"),this.token(src,!0)},Lexer.prototype.token=function(src,top,bq){for(var next,loose,cap,bull,b,item,space,i,l,src=src.replace(/^ +$/gm,"");src;)if((cap=this.rules.newline.exec(src))&&(src=src.substring(cap[0].length),cap[0].length>1&&this.tokens.push({type:"space"})),cap=this.rules.code.exec(src))src=src.substring(cap[0].length),cap=cap[0].replace(/^ {4}/gm,""),this.tokens.push({type:"code",text:this.options.pedantic?cap:cap.replace(/\n+$/,"")});else if(cap=this.rules.fences.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"code",lang:cap[2],text:cap[3]||""});else if(cap=this.rules.heading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:cap[1].length,text:cap[2]});else if(top&&(cap=this.rules.nptable.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].split(/ *\| */);this.tokens.push(item)}else if(cap=this.rules.lheading.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"heading",depth:"="===cap[2]?1:2,text:cap[1]});else if(cap=this.rules.hr.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"hr"});else if(cap=this.rules.blockquote.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"blockquote_start"}),cap=cap[0].replace(/^ *> ?/gm,""),this.token(cap,top,!0),this.tokens.push({type:"blockquote_end"});else if(cap=this.rules.list.exec(src)){for(src=src.substring(cap[0].length),bull=cap[2],this.tokens.push({type:"list_start",ordered:bull.length>1}),cap=cap[0].match(this.rules.item),next=!1,l=cap.length,i=0;i<l;i++)item=cap[i],space=item.length,item=item.replace(/^ *([*+-]|\d+\.) +/,""),~item.indexOf("\n ")&&(space-=item.length,item=this.options.pedantic?item.replace(/^ {1,4}/gm,""):item.replace(new RegExp("^ {1,"+space+"}","gm"),"")),this.options.smartLists&&i!==l-1&&(b=block.bullet.exec(cap[i+1])[0],bull===b||bull.length>1&&b.length>1||(src=cap.slice(i+1).join("\n")+src,i=l-1)),loose=next||/\n\n(?!\s*$)/.test(item),i!==l-1&&(next="\n"===item.charAt(item.length-1),loose||(loose=next)),this.tokens.push({type:loose?"loose_item_start":"list_item_start"}),this.token(item,!1,bq),this.tokens.push({type:"list_item_end"});this.tokens.push({type:"list_end"})}else if(cap=this.rules.html.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:this.options.sanitize?"paragraph":"html",pre:!this.options.sanitizer&&("pre"===cap[1]||"script"===cap[1]||"style"===cap[1]),text:cap[0]});else if(!bq&&top&&(cap=this.rules.def.exec(src)))src=src.substring(cap[0].length),this.tokens.links[cap[1].toLowerCase()]={href:cap[2],title:cap[3]};else if(top&&(cap=this.rules.table.exec(src))){for(src=src.substring(cap[0].length),item={type:"table",header:cap[1].replace(/^ *| *\| *$/g,"").split(/ *\| */),align:cap[2].replace(/^ *|\| *$/g,"").split(/ *\| */),cells:cap[3].replace(/(?: *\| *)?\n$/,"").split("\n")},i=0;i<item.align.length;i++)/^ *-+: *$/.test(item.align[i])?item.align[i]="right":/^ *:-+: *$/.test(item.align[i])?item.align[i]="center":/^ *:-+ *$/.test(item.align[i])?item.align[i]="left":item.align[i]=null;for(i=0;i<item.cells.length;i++)item.cells[i]=item.cells[i].replace(/^ *\| *| *\| *$/g,"").split(/ *\| */);this.tokens.push(item)}else if(top&&(cap=this.rules.paragraph.exec(src)))src=src.substring(cap[0].length),this.tokens.push({type:"paragraph",text:"\n"===cap[1].charAt(cap[1].length-1)?cap[1].slice(0,-1):cap[1]});else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),this.tokens.push({type:"text",text:cap[0]});else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0));return this.tokens};var inline={escape:/^\\([\\`*{}\[\]()#+\-.!_>])/,autolink:/^<([^ >]+(@|:\/)[^ >]+)>/,url:noop,tag:/^<!--[\s\S]*?-->|^<\/?\w+(?:"[^"]*"|'[^']*'|[^'">])*?>/,link:/^!?\[(inside)\]\(href\)/,reflink:/^!?\[(inside)\]\s*\[([^\]]*)\]/,nolink:/^!?\[((?:\[[^\]]*\]|[^\[\]])*)\]/,strong:/^__([\s\S]+?)__(?!_)|^\*\*([\s\S]+?)\*\*(?!\*)/,em:/^\b_((?:[^_]|__)+?)_\b|^\*((?:\*\*|[\s\S])+?)\*(?!\*)/,code:/^(`+)\s*([\s\S]*?[^`])\s*\1(?!`)/,br:/^ {2,}\n(?!\s*$)/,del:noop,text:/^[\s\S]+?(?=[\\<!\[_*`]| {2,}\n|$)/};inline._inside=/(?:\[[^\]]*\]|[^\[\]]|\](?=[^\[]*\]))*/,inline._href=/\s*<?([\s\S]*?)>?(?:\s+['"]([\s\S]*?)['"])?\s*/,inline.link=replace(inline.link)("inside",inline._inside)("href",inline._href)(),inline.reflink=replace(inline.reflink)("inside",inline._inside)(),inline.normal=merge({},inline),inline.pedantic=merge({},inline.normal,{strong:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,em:/^_(?=\S)([\s\S]*?\S)_(?!_)|^\*(?=\S)([\s\S]*?\S)\*(?!\*)/}),inline.gfm=merge({},inline.normal,{escape:replace(inline.escape)("])","~|])")(),url:/^(https?:\/\/[^\s<]+[^<.,:;"')\]\s])/,del:/^~~(?=\S)([\s\S]*?\S)~~/,text:replace(inline.text)("]|","~]|")("|","|https?://|")()}),inline.breaks=merge({},inline.gfm,{br:replace(inline.br)("{2,}","*")(),text:replace(inline.gfm.text)("{2,}","*")()}),InlineLexer.rules=inline,InlineLexer.output=function(src,links,options){var inline=new InlineLexer(links,options);return inline.output(src)},InlineLexer.prototype.output=function(src){for(var link,text,href,cap,out="";src;)if(cap=this.rules.escape.exec(src))src=src.substring(cap[0].length),out+=cap[1];else if(cap=this.rules.autolink.exec(src))src=src.substring(cap[0].length),"@"===cap[2]?(text=":"===cap[1].charAt(6)?this.mangle(cap[1].substring(7)):this.mangle(cap[1]),href=this.mangle("mailto:")+text):(text=escape(cap[1]),href=text),out+=this.renderer.link(href,null,text);else if(this.inLink||!(cap=this.rules.url.exec(src))){if(cap=this.rules.tag.exec(src))!this.inLink&&/^<a /i.test(cap[0])?this.inLink=!0:this.inLink&&/^<\/a>/i.test(cap[0])&&(this.inLink=!1),src=src.substring(cap[0].length),out+=this.options.sanitize?this.options.sanitizer?this.options.sanitizer(cap[0]):escape(cap[0]):cap[0];else if(cap=this.rules.link.exec(src))src=src.substring(cap[0].length),this.inLink=!0,out+=this.outputLink(cap,{href:cap[2],title:cap[3]}),this.inLink=!1;else if((cap=this.rules.reflink.exec(src))||(cap=this.rules.nolink.exec(src))){if(src=src.substring(cap[0].length),link=(cap[2]||cap[1]).replace(/\s+/g," "),link=this.links[link.toLowerCase()],!link||!link.href){out+=cap[0].charAt(0),src=cap[0].substring(1)+src;continue}this.inLink=!0,out+=this.outputLink(cap,link),this.inLink=!1}else if(cap=this.rules.strong.exec(src))src=src.substring(cap[0].length),out+=this.renderer.strong(this.output(cap[2]||cap[1]));else if(cap=this.rules.em.exec(src))src=src.substring(cap[0].length),out+=this.renderer.em(this.output(cap[2]||cap[1]));else if(cap=this.rules.code.exec(src))src=src.substring(cap[0].length),out+=this.renderer.codespan(escape(cap[2],!0));else if(cap=this.rules.br.exec(src))src=src.substring(cap[0].length),out+=this.renderer.br();else if(cap=this.rules.del.exec(src))src=src.substring(cap[0].length),out+=this.renderer.del(this.output(cap[1]));else if(cap=this.rules.text.exec(src))src=src.substring(cap[0].length),out+=this.renderer.text(escape(this.smartypants(cap[0])));else if(src)throw new Error("Infinite loop on byte: "+src.charCodeAt(0))}else src=src.substring(cap[0].length),text=escape(cap[1]),href=text,out+=this.renderer.link(href,null,text);return out},InlineLexer.prototype.outputLink=function(cap,link){var href=escape(link.href),title=link.title?escape(link.title):null;return"!"!==cap[0].charAt(0)?this.renderer.link(href,title,this.output(cap[1])):this.renderer.image(href,title,escape(cap[1]))},InlineLexer.prototype.smartypants=function(text){return this.options.smartypants?text.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014\/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014\/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…"):text},InlineLexer.prototype.mangle=function(text){if(!this.options.mangle)return text;for(var ch,out="",l=text.length,i=0;i<l;i++)ch=text.charCodeAt(i),Math.random()>.5&&(ch="x"+ch.toString(16)),out+="&#"+ch+";";return out},Renderer.prototype.code=function(code,lang,escaped){if(this.options.highlight){var out=this.options.highlight(code,lang);null!=out&&out!==code&&(escaped=!0,code=out)}return lang?'<pre><code class="'+this.options.langPrefix+escape(lang,!0)+'">'+(escaped?code:escape(code,!0))+"\n</code></pre>\n":"<pre><code>"+(escaped?code:escape(code,!0))+"\n</code></pre>"},Renderer.prototype.blockquote=function(quote){return"<blockquote>\n"+quote+"</blockquote>\n"},Renderer.prototype.html=function(html){return html},Renderer.prototype.heading=function(text,level,raw){return"<h"+level+' id="'+this.options.headerPrefix+raw.toLowerCase().replace(/[^\w]+/g,"-")+'">'+text+"</h"+level+">\n"},Renderer.prototype.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},Renderer.prototype.list=function(body,ordered){var type=ordered?"ol":"ul";return"<"+type+">\n"+body+"</"+type+">\n"},Renderer.prototype.listitem=function(text){return"<li>"+text+"</li>\n"},Renderer.prototype.paragraph=function(text){return"<p>"+text+"</p>\n"},Renderer.prototype.table=function(header,body){return"<table>\n<thead>\n"+header+"</thead>\n<tbody>\n"+body+"</tbody>\n</table>\n"},Renderer.prototype.tablerow=function(content){return"<tr>\n"+content+"</tr>\n"},Renderer.prototype.tablecell=function(content,flags){var type=flags.header?"th":"td",tag=flags.align?"<"+type+' style="text-align:'+flags.align+'">':"<"+type+">";return tag+content+"</"+type+">\n"},Renderer.prototype.strong=function(text){return"<strong>"+text+"</strong>"},Renderer.prototype.em=function(text){return"<em>"+text+"</em>"},Renderer.prototype.codespan=function(text){return"<code>"+text+"</code>"},Renderer.prototype.br=function(){return this.options.xhtml?"<br/>":"<br>"},Renderer.prototype.del=function(text){return"<del>"+text+"</del>"},Renderer.prototype.link=function(href,title,text){if(this.options.sanitize){try{var prot=decodeURIComponent(unescape(href)).replace(/[^\w:]/g,"").toLowerCase()}catch(e){return""}if(0===prot.indexOf("javascript:")||0===prot.indexOf("vbscript:"))return""}var out='<a href="'+href+'"';return title&&(out+=' title="'+title+'"'),out+=">"+text+"</a>"},Renderer.prototype.image=function(href,title,text){var out='<img src="'+href+'" alt="'+text+'"';return title&&(out+=' title="'+title+'"'),out+=this.options.xhtml?"/>":">"},Renderer.prototype.text=function(text){return text},Parser.parse=function(src,options,renderer){var parser=new Parser(options,renderer);return parser.parse(src)},Parser.prototype.parse=function(src){this.inline=new InlineLexer(src.links,this.options,this.renderer),this.tokens=src.reverse();for(var out="";this.next();)out+=this.tok();return out},Parser.prototype.next=function(){return this.token=this.tokens.pop()},Parser.prototype.peek=function(){return this.tokens[this.tokens.length-1]||0},Parser.prototype.parseText=function(){for(var body=this.token.text;"text"===this.peek().type;)body+="\n"+this.next().text;return this.inline.output(body)},Parser.prototype.tok=function(){switch(this.token.type){case"space":return"";case"hr":return this.renderer.hr();case"heading":return this.renderer.heading(this.inline.output(this.token.text),this.token.depth,this.token.text);case"code":return this.renderer.code(this.token.text,this.token.lang,this.token.escaped);case"table":var i,row,cell,flags,j,header="",body="";for(cell="",i=0;i<this.token.header.length;i++)flags={header:!0,align:this.token.align[i]},cell+=this.renderer.tablecell(this.inline.output(this.token.header[i]),{header:!0,align:this.token.align[i]});for(header+=this.renderer.tablerow(cell),i=0;i<this.token.cells.length;i++){for(row=this.token.cells[i],cell="",j=0;j<row.length;j++)cell+=this.renderer.tablecell(this.inline.output(row[j]),{header:!1,align:this.token.align[j]});body+=this.renderer.tablerow(cell)}return this.renderer.table(header,body);case"blockquote_start":for(var body="";"blockquote_end"!==this.next().type;)body+=this.tok();return this.renderer.blockquote(body);case"list_start":for(var body="",ordered=this.token.ordered;"list_end"!==this.next().type;)body+=this.tok();return this.renderer.list(body,ordered);case"list_item_start":for(var body="";"list_item_end"!==this.next().type;)body+="text"===this.token.type?this.parseText():this.tok();return this.renderer.listitem(body);case"loose_item_start":for(var body="";"list_item_end"!==this.next().type;)body+=this.tok();return this.renderer.listitem(body);case"html":var html=this.token.pre||this.options.pedantic?this.token.text:this.inline.output(this.token.text);return this.renderer.html(html);case"paragraph":return this.renderer.paragraph(this.inline.output(this.token.text));case"text":return this.renderer.paragraph(this.parseText())}},noop.exec=noop,marked.options=marked.setOptions=function(opt){return merge(marked.defaults,opt),marked},marked.defaults={gfm:!0,tables:!0,breaks:!1,pedantic:!1,sanitize:!1,sanitizer:null,mangle:!0,smartLists:!1,silent:!1,highlight:null,langPrefix:"lang-",smartypants:!1,headerPrefix:"",renderer:new Renderer,xhtml:!1},marked.Parser=Parser,marked.parser=Parser.parse,marked.Renderer=Renderer,marked.Lexer=Lexer,marked.lexer=Lexer.lex,marked.InlineLexer=InlineLexer,marked.inlineLexer=InlineLexer.output,marked.parse=marked,"undefined"!=typeof module&&"object"==typeof exports?module.exports=marked:"function"==typeof define&&define.amd?define(function(){return marked}):this.marked=marked}).call(function(){return this||("undefined"!=typeof window?window:global)}()),function(root,factory){"object"==typeof exports&&"object"==typeof module?module.exports=factory(require("fs")):"function"==typeof define&&define.amd?define(["fs"],factory):"object"==typeof exports?exports.Parser=factory(require("fs")):(root.RAML=root.RAML||{},root.RAML.Parser=factory(root.fs))}(this,function(__WEBPACK_EXTERNAL_MODULE_44__){return function(modules){function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:!1};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.loaded=!0,module.exports}var installedModules={};return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.p="",__webpack_require__(0)}([function(module,exports,__webpack_require__){"use strict";function loadApiSync(apiPath,arg1,arg2){return apiLoader.loadApi(apiPath,arg1,arg2).getOrElse(null)}function loadRAMLSync(ramlPath,arg1,arg2){return apiLoader.loadApi(ramlPath,arg1,arg2).getOrElse(null)}function optionsForContent(content,arg2){return{fsResolver:{content:function(pathStr){return pathStr==path.resolve("/","#local.raml").replace(/\\/,"/")?content:arg2&&arg2.fsResolver?arg2.fsResolver.content(pathStr):void 0},contentAsync:function(pathStr){return pathStr==path.resolve("/","#local.raml").replace(/\\/,"/")?Promise.resolve(content):arg2&&arg2.fsResolver?arg2.fsResolver.contentAsync(pathStr):void 0}},httpResolver:arg2?arg2.httpResolver:null,rejectOnErrors:!!arg2&&arg2.rejectOnErrors,attributeDefaults:!arg2||arg2.attributeDefaults}}function parseRAMLSync(content,arg2){return apiLoader.loadApi("/#local.raml",[],optionsForContent(content,arg2)).getOrElse(null)}function parseRAML(content,arg2){return apiLoader.loadApiAsync("/#local.raml",[],optionsForContent(content,arg2))}function loadApi(apiPath,arg1,arg2){return apiLoader.loadApiAsync(apiPath,arg1,arg2)}function loadRAML(ramlPath,arg1,arg2){return apiLoader.loadRAMLAsync(ramlPath,arg1,arg2)}function getLanguageElementByRuntimeType(runtimeType){return apiLoader.getLanguageElementByRuntimeType(runtimeType)}function isFragment(node){return exports.api10.isFragment(node)}function asFragment(node){return exports.api10.asFragment(node)}var apiLoader=__webpack_require__(9),path=__webpack_require__(15),PromiseConstructor=__webpack_require__(35);exports.api10=__webpack_require__(12),exports.api08=__webpack_require__(13),exports.loadApiSync=loadApiSync,exports.loadRAMLSync=loadRAMLSync,exports.parseRAMLSync=parseRAMLSync,exports.parseRAML=parseRAML,exports.loadApi=loadApi,exports.loadRAML=loadRAML,exports.getLanguageElementByRuntimeType=getLanguageElementByRuntimeType,exports.isFragment=isFragment,exports.asFragment=asFragment,exports.hl=__webpack_require__(10),exports.ll=__webpack_require__(11),exports.search=__webpack_require__(1),exports.stubs=__webpack_require__(2),exports.utils=__webpack_require__(3),exports.project=__webpack_require__(4),exports.universeHelpers=__webpack_require__(14),exports.ds=__webpack_require__(36),exports.schema=__webpack_require__(5),exports.universes=exports.ds.universesInfo,exports.parser=__webpack_require__(6),exports.expander=__webpack_require__(7),exports.wrapperHelper=__webpack_require__(8),"undefined"==typeof Promise&&"undefined"!=typeof window&&(window.Promise=PromiseConstructor)},function(module,exports,__webpack_require__){"use strict";function determineCompletionKind(text,offset){return search.determineCompletionKind(text,offset)}function enumValues(c,n){return search.enumValues(c,n)}function globalDeclarations(n){return search.globalDeclarations(n)}function qName(n,p){return hlimpl.qName(n,p)}function subTypesWithLocals(t,n){return search.subTypesWithLocals(t,n)}function nodesDeclaringType(t,n){return search.nodesDeclaringType(t,n)}function isExampleNodeContent(n){return search.isExampleNodeContent(n)}function findExampleContentType(n){return search.findExampleContentType(n)}function parseDocumentationContent(n,t){return search.parseDocumentationContent(n,t)}function parseStructuredExample(exampleNode,type){return search.parseStructuredExample(exampleNode,type)}function isExampleNode(node){return search.isExampleNode(node)}function referenceTargets(p0,c){return search.referenceTargets(p0,c)}function findUsages(unit,offset){return search.findUsages(unit,offset)}function findDeclaration(unit,offset,nodePart){return search.findDeclaration(unit,offset,nodePart)}var search=__webpack_require__(23),hlimpl=__webpack_require__(16);!function(LocationKind){LocationKind[LocationKind.VALUE_COMPLETION=0]="VALUE_COMPLETION",LocationKind[LocationKind.KEY_COMPLETION=1]="KEY_COMPLETION",LocationKind[LocationKind.PATH_COMPLETION=2]="PATH_COMPLETION",LocationKind[LocationKind.DIRECTIVE_COMPLETION=3]="DIRECTIVE_COMPLETION",LocationKind[LocationKind.VERSION_COMPLETION=4]="VERSION_COMPLETION",LocationKind[LocationKind.ANNOTATION_COMPLETION=5]="ANNOTATION_COMPLETION",LocationKind[LocationKind.SEQUENCE_KEY_COPLETION=6]="SEQUENCE_KEY_COPLETION",LocationKind[LocationKind.INCOMMENT=7]="INCOMMENT"}(exports.LocationKind||(exports.LocationKind={}));exports.LocationKind;exports.determineCompletionKind=determineCompletionKind,exports.enumValues=enumValues,exports.globalDeclarations=globalDeclarations,exports.qName=qName,exports.subTypesWithLocals=subTypesWithLocals,exports.nodesDeclaringType=nodesDeclaringType,exports.isExampleNodeContent=isExampleNodeContent,exports.findExampleContentType=findExampleContentType,exports.parseDocumentationContent=parseDocumentationContent,exports.parseStructuredExample=parseStructuredExample,exports.isExampleNode=isExampleNode,exports.referenceTargets=referenceTargets,exports.findUsages=findUsages,exports.findDeclaration=findDeclaration},function(module,exports,__webpack_require__){"use strict";function createStubNode(t,p,key,unit){return void 0===key&&(key=null),stubs.createStubNode(t,p,key,unit)}function createStub(parent,property,key){return stubs.createStub(parent,property,key)}function createStubNoParentPatch(parent,property,key){return stubs.createStub0(parent,property,key)}function createResourceStub(parent,key){return stubs.createResourceStub(parent,key)}function createMethodStub(parent,key){return stubs.createMethodStub(parent,key)}function createResponseStub(parent,key){return stubs.createResponseStub(parent,key)}function createBodyStub(parent,key){return stubs.createBodyStub(parent,key)}function createUriParameterStub(parent,key){return stubs.createUriParameterStub(parent,key)}function createQueryParameterStub(parent,key){return stubs.createQueryParameterStub(parent,key)}function createASTPropImpl(node,parent,_def,_prop,fk){return void 0===fk&&(fk=!1),new hlimpl.ASTPropImpl(node,parent,_def,_prop,fk)}function createASTNodeImpl(node,parent,_def,_prop){return new hlimpl.ASTNodeImpl(node,parent,_def,_prop)}function createVirtualASTPropImpl(node,parent,_def,_prop){return new VirtualAttr(node,parent,_def,_prop)}function createVirtualNodeImpl(node,parent,_def,_prop){return new VirtualNode(node,parent,_def,_prop)}function createMapping(name,value){return jsyaml.createMapping(name,value)}function createMap(){return jsyaml.createMap([])}function createAttr(_property,val){return stubs.createAttr(_property,val)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},hlimpl=__webpack_require__(16),jsyaml=__webpack_require__(27),stubs=__webpack_require__(17);exports.createStubNode=createStubNode,exports.createStub=createStub,exports.createStubNoParentPatch=createStubNoParentPatch,exports.createResourceStub=createResourceStub,exports.createMethodStub=createMethodStub,exports.createResponseStub=createResponseStub,exports.createBodyStub=createBodyStub,exports.createUriParameterStub=createUriParameterStub,exports.createQueryParameterStub=createQueryParameterStub,exports.createASTPropImpl=createASTPropImpl,exports.createASTNodeImpl=createASTNodeImpl,exports.createVirtualASTPropImpl=createVirtualASTPropImpl,exports.createVirtualNodeImpl=createVirtualNodeImpl;var VirtualAttr=function(_super){function VirtualAttr(){_super.apply(this,arguments)}return __extends(VirtualAttr,_super),VirtualAttr.prototype.value=function(){return""},VirtualAttr}(hlimpl.ASTPropImpl),VirtualNode=function(_super){function VirtualNode(){_super.apply(this,arguments)}return __extends(VirtualNode,_super),VirtualNode.prototype.value=function(){return""},VirtualNode}(hlimpl.ASTNodeImpl);exports.createMapping=createMapping,exports.createMap=createMap,exports.createAttr=createAttr},function(module,exports,__webpack_require__){"use strict";function hasAsyncRequests(){return rs.hasAsyncRequests()}function addLoadCallback(x){rs.addLoadCallback(x)}function getTransformerNames(){return expander.getTransformNames()}function getFragmentDefenitionName(node){return hlimpl.getFragmentDefenitionName(node)}function genStructuredValue(name,parent,pr){if(pr.range()instanceof defs.ReferenceType){var mockNode=(pr.range(),jsyaml.createNode(name));return new hlimpl.StructuredValue(mockNode,parent,pr)}return name}function parseUrl(u){return(new linter.UrlParameterNameValidator).parseUrl(u)}var rs=__webpack_require__(28),hlimpl=__webpack_require__(16),defs=__webpack_require__(36),jsyaml=__webpack_require__(27),expander=__webpack_require__(24),linter=__webpack_require__(25),builder=__webpack_require__(26);exports.hasAsyncRequests=hasAsyncRequests,exports.addLoadCallback=addLoadCallback,exports.getTransformerNames=getTransformerNames,exports.updateType=function(node){var type=builder.doDescrimination(node);null==type&&node.property()&&(type=node.property().range()),type&&node.patchType(type)},exports.getFragmentDefenitionName=getFragmentDefenitionName,exports.genStructuredValue=genStructuredValue,exports.parseUrl=parseUrl},function(module,exports,__webpack_require__){"use strict";function createProject(path,r,h){return new limpl.Project(path,r,h)}var limpl=__webpack_require__(27);exports.createProject=createProject},function(module,exports,__webpack_require__){"use strict";function createSchema(c,u){return su.createSchema(c,new contentprovider.ContentProvider(u))}function getXMLSchema(c){return su.getXMLSchema(c)}function getJSONSchema(c,u){return su.getJSONSchema(c,new contentprovider.ContentProvider(u))}function completeReference(includePath,includeReference,content){return refResolvers.completeReference(includePath,includeReference,content)}function getIncludePath(p){return refResolvers.getIncludePath(p)}function getIncludeReference(p){return refResolvers.getIncludeReference(p)}function createSchemaModelGenerator(){return new schemaGenImpl.SchemaToModelGenerator}function createModelToSchemaGenerator(){return new schemaGenImpl.ModelToSchemaGenerator}var def=__webpack_require__(36),refResolvers=__webpack_require__(29),schemaGenImpl=__webpack_require__(18),contentprovider=__webpack_require__(30),su=def.getSchemaUtils();exports.createSchema=createSchema,exports.getXMLSchema=getXMLSchema,exports.getJSONSchema=getJSONSchema,exports.completeReference=completeReference,exports.getIncludePath=getIncludePath,exports.getIncludeReference=getIncludeReference,exports.createSchemaModelGenerator=createSchemaModelGenerator,exports.createModelToSchemaGenerator=createModelToSchemaGenerator},function(module,exports,__webpack_require__){"use strict";exports.modify=__webpack_require__(19)},function(module,exports,__webpack_require__){"use strict";function expandTraitsAndResourceTypes(api){return ex.expandTraitsAndResourceTypes(api)}var ex=__webpack_require__(24);exports.expandTraitsAndResourceTypes=expandTraitsAndResourceTypes},function(module,exports,__webpack_require__){"use strict";function completeRelativeUri(res){return wh.completeRelativeUri(res)}var wh=__webpack_require__(32);exports.completeRelativeUri=completeRelativeUri},function(module,exports,__webpack_require__){"use strict";function loadApi(apiPath,arg1,arg2){var api=loadRAMLInternal(apiPath,arg1,arg2);return new Opt(api)}function loadRAML(ramlPath,arg1,arg2){var result=loadRAMLInternal(ramlPath,arg1,arg2);return new Opt(result)}function loadRAMLInternal(apiPath,arg1,arg2){var gotArray=Array.isArray(arg1),extensionsAndOverlays=gotArray?arg1:null,options=gotArray?arg2:arg1;options=options||{};var project=getProject(apiPath,options),pr=apiPath.indexOf("://"),unitName=pr!=-1&&pr<6?apiPath:path.basename(apiPath),unit=project.unit(unitName);arg2&&!extensionsAndOverlays&&(extensionsAndOverlays=null);var api;if(unit)if(extensionsAndOverlays&&extensionsAndOverlays.length>0){var extensionUnits=[];extensionsAndOverlays.forEach(function(currentPath){if(!currentPath||0==currentPath.trim().length)throw new Error("Extensions and overlays list should contain legal file paths")}),extensionsAndOverlays.forEach(function(unitPath){extensionUnits.push(project.unit(path.basename(unitPath)))}),extensionUnits.forEach(function(extensionUnit){return toApi(extensionUnit,options)}),api=toApi(expander.mergeAPIs(unit,extensionUnits,hlimpl.OverlayMergeMode.MERGE),options);
}else api=toApi(unit,options),api.highLevel().setMergeMode(hlimpl.OverlayMergeMode.MERGE);if(!unit)throw new Error("Can not resolve :"+apiPath);if(options.rejectOnErrors&&api&&api.errors().filter(function(x){return!x.isWarning}).length)throw toError(api);return null!=options.attributeDefaults&&api?api.setAttributeDefaults(options.attributeDefaults):api&&api.setAttributeDefaults(!0),api}function loadApiAsync(apiPath,arg1,arg2){var ramlPromise=loadRAMLAsync(apiPath,arg1,arg2);return ramlPromise.then(function(loadedRaml){return loadedRaml})}function loadRAMLAsync(ramlPath,arg1,arg2){var gotArray=Array.isArray(arg1),extensionsAndOverlays=gotArray?arg1:null,options=gotArray?arg2:arg1;options=options||{};var project=getProject(ramlPath,options),pr=ramlPath.indexOf("://"),unitName=pr!=-1&&pr<6?ramlPath:path.basename(ramlPath);return arg2&&!extensionsAndOverlays&&(extensionsAndOverlays=null),extensionsAndOverlays&&0!=extensionsAndOverlays.length?(extensionsAndOverlays.forEach(function(currentPath){if(!currentPath||0==currentPath.trim().length)throw new Error("Extensions and overlays list should contain legal file paths")}),fetchAndLoadApiAsync(project,unitName,options).then(function(masterApi){var apiPromises=[];return extensionsAndOverlays.forEach(function(extensionUnitPath){apiPromises.push(fetchAndLoadApiAsync(project,path.basename(extensionUnitPath),options))}),Promise.all(apiPromises).then(function(apis){var overlayUnits=[];apis.forEach(function(currentApi){return overlayUnits.push(currentApi.highLevel().lowLevel().unit())});var result=expander.mergeAPIs(masterApi.highLevel().lowLevel().unit(),overlayUnits,hlimpl.OverlayMergeMode.MERGE);return null!=options.attributeDefaults&&result?result.setAttributeDefaults(options.attributeDefaults):result&&result.setAttributeDefaults(!0),result}).then(function(mergedHighLevel){return toApi(mergedHighLevel,options)})})):fetchAndLoadApiAsync(project,unitName,options).then(function(masterApi){return masterApi.highLevel().setMergeMode(hlimpl.OverlayMergeMode.MERGE),null!=options.attributeDefaults&&masterApi?masterApi.setAttributeDefaults(options.attributeDefaults):masterApi&&masterApi.setAttributeDefaults(!0),masterApi})}function getLanguageElementByRuntimeType(runtimeType){if(null==runtimeType)return null;var highLevelNode=runtimeType.getAdapter(ramlServices.RAMLService).getDeclaringNode();return null==highLevelNode?null:highLevelNode.wrapperNode()}function fetchAndLoadApiAsync(project,unitName,options){return llimpl.fetchIncludesAndMasterAsync(project,unitName).then(function(x){try{var api=toApi(x,options);return options.rejectOnErrors&&api&&api.errors().filter(function(x){return!x.isWarning}).length?Promise.reject(toError(api)):api}catch(err){return Promise.reject(err)}})}function getProject(apiPath,options){options=options||{};var includeResolver=options.fsResolver,httpResolver=options.httpResolver,projectRoot=path.dirname(apiPath),project=new jsyaml.Project(projectRoot,includeResolver,httpResolver);return project}function toApi(unitOrHighlevel,options,checkApisOverlays){if(void 0===checkApisOverlays&&(checkApisOverlays=!1),!unitOrHighlevel)return null;var unit=null,highLevel=null;unitOrHighlevel.isRAMLUnit?unit=unitOrHighlevel:(highLevel=unitOrHighlevel,unit=highLevel.lowLevel().unit());var api,contents=unit.contents(),ramlFirstLine=hlimpl.ramlFirstLine(contents);if(!ramlFirstLine)throw new Error("Invalid first line. A RAML document is expected to start with '#%RAML <version> <?fragment type>'.");var typeName,ramlVersion,verStr=ramlFirstLine[1];ramlFirstLine[2];if("0.8"==verStr?ramlVersion="RAML08":"1.0"==verStr&&(ramlVersion="RAML10"),!ramlVersion)throw new Error("Unknown version of RAML expected to see one of '#%RAML 0.8' or '#%RAML 1.0'");if("RAML08"==ramlVersion&&checkApisOverlays)throw new Error("Extensions and overlays are not supported in RAML 0.8.");var universe=universeProvider(ramlVersion);universe.type(typeName);return highLevel||(highLevel=hlimpl.fromUnit(unit)),api=highLevel.wrapperNode()}function toError(api){var error=new Error("Api contains errors.");return error.parserErrors=api.errors(),error}function loadApis1(projectRoot,cacheChildren,expandTraitsAndResourceTypes){void 0===cacheChildren&&(cacheChildren=!1),void 0===expandTraitsAndResourceTypes&&(expandTraitsAndResourceTypes=!0);var universe=universeProvider("RAML10"),apiType=universe.type(universeDef.Universe10.Api.name),p=new jsyaml.Project(projectRoot),result=[];return p.units().forEach(function(x){var lowLevel=x.ast();cacheChildren&&(lowLevel=llimpl.toChildCachingNode(lowLevel));var api=new RamlWrapper1Impl.ApiImpl(new hlimpl.ASTNodeImpl(lowLevel,null,apiType,null));expandTraitsAndResourceTypes&&(api=expander.expandTraitsAndResourceTypes(api)),result.push(api)}),result}var RamlWrapper1Impl=__webpack_require__(20),path=__webpack_require__(15),Opt=__webpack_require__(21),jsyaml=__webpack_require__(27),hlimpl=__webpack_require__(16),llimpl=__webpack_require__(27),expander=__webpack_require__(24),universeDef=__webpack_require__(22),ramlServices=__webpack_require__(33),universeProvider=__webpack_require__(34);exports.loadApi=loadApi,exports.loadRAML=loadRAML,exports.loadApiAsync=loadApiAsync,exports.loadRAMLAsync=loadRAMLAsync,exports.getLanguageElementByRuntimeType=getLanguageElementByRuntimeType,exports.toError=toError,exports.loadApis1=loadApis1},function(module,exports,__webpack_require__){"use strict";function isParseResult(object){return object.asElement&&object.getKind&&object.asAttr&&object.lowLevel}!function(NodeKind){NodeKind[NodeKind.BASIC=0]="BASIC",NodeKind[NodeKind.NODE=1]="NODE",NodeKind[NodeKind.ATTRIBUTE=2]="ATTRIBUTE"}(exports.NodeKind||(exports.NodeKind={}));exports.NodeKind;!function(RAMLVersion){RAMLVersion[RAMLVersion.RAML10=0]="RAML10",RAMLVersion[RAMLVersion.RAML08=1]="RAML08"}(exports.RAMLVersion||(exports.RAMLVersion={}));exports.RAMLVersion;exports.isParseResult=isParseResult,function(IssueCode){IssueCode[IssueCode.UNRESOLVED_REFERENCE=0]="UNRESOLVED_REFERENCE",IssueCode[IssueCode.YAML_ERROR=1]="YAML_ERROR",IssueCode[IssueCode.UNKNOWN_NODE=2]="UNKNOWN_NODE",IssueCode[IssueCode.MISSING_REQUIRED_PROPERTY=3]="MISSING_REQUIRED_PROPERTY",IssueCode[IssueCode.PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE=4]="PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE",IssueCode[IssueCode.KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT=5]="KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT",IssueCode[IssueCode.UNABLE_TO_RESOLVE_INCLUDE_FILE=6]="UNABLE_TO_RESOLVE_INCLUDE_FILE",IssueCode[IssueCode.INVALID_VALUE_SCHEMA=7]="INVALID_VALUE_SCHEMA",IssueCode[IssueCode.MISSED_CONTEXT_REQUIREMENT=8]="MISSED_CONTEXT_REQUIREMENT",IssueCode[IssueCode.NODE_HAS_VALUE=9]="NODE_HAS_VALUE",IssueCode[IssueCode.ONLY_OVERRIDE_ALLOWED=10]="ONLY_OVERRIDE_ALLOWED",IssueCode[IssueCode.ILLEGAL_PROPERTY_VALUE=11]="ILLEGAL_PROPERTY_VALUE",IssueCode[IssueCode.ILLEGAL_PROPERTY=12]="ILLEGAL_PROPERTY",IssueCode[IssueCode.INVALID_PROPERTY=13]="INVALID_PROPERTY"}(exports.IssueCode||(exports.IssueCode={}));exports.IssueCode},function(module,exports,__webpack_require__){"use strict";function setAttr(t,value){return new ASTChangeCommand(CommandKind.CHANGE_VALUE,t,value,(-1))}function setAttrStructured(t,value){return new ASTChangeCommand(CommandKind.CHANGE_VALUE,t,value.lowLevel(),(-1))}function setKey(t,value){return new ASTChangeCommand(CommandKind.CHANGE_KEY,t,value,(-1))}function removeNode(t,child){return new ASTChangeCommand(CommandKind.REMOVE_CHILD,t,child,(-1))}function insertNode(t,child,insertAfter,toSeq){void 0===insertAfter&&(insertAfter=null),void 0===toSeq&&(toSeq=!1);var s=new ASTChangeCommand(CommandKind.ADD_CHILD,t,child,(-1));return s.insertionPoint=insertAfter,s.toSeq=toSeq,s}function initRamlFile(root,newroot){return new ASTChangeCommand(CommandKind.INIT_RAML_FILE,root,newroot,(-1))}function buildPath(reference,unitPath,rootPath){if(path.isAbsolute(reference)){var e=path.extname(unitPath);".xsd"!=e&&(reference=reference.substr(1),unitPath=toAbsolutePath(rootPath,path.basename(unitPath)))}return isWebPath(reference)||path.isAbsolute(reference)?reference:isWebPath(unitPath)||path.isAbsolute(unitPath)?toAbsolutePath(path.dirname(unitPath),reference):toAbsolutePath(path.dirname(toAbsolutePath(rootPath,unitPath)),reference)}function toAbsolutePath(context,reference){if(isWebPath(reference))return reference;var apath;if(isWebPath(context)){var rp=util.stringEndsWith(context,"/")?context:context+"/";apath=URL.resolve(rp,reference).replace(/\\/g,"/")}else apath=path.resolve(context,reference).replace(/\\/g,"/");return apath}function isWebPath(reference){return null!=reference&&(util.stringStartsWith(reference,"http://")||util.stringStartsWith(reference,"https://"))}function isLowLevelNode(object){return object.start&&object.end&&object.unit&&object.key&&object.value&&object.children&&object.includePath}var path=__webpack_require__(15),URL=__webpack_require__(37),util=__webpack_require__(31),ASTDelta=function(){function ASTDelta(){}return ASTDelta}();exports.ASTDelta=ASTDelta,function(CommandKind){CommandKind[CommandKind.ADD_CHILD=0]="ADD_CHILD",CommandKind[CommandKind.REMOVE_CHILD=1]="REMOVE_CHILD",CommandKind[CommandKind.MOVE_CHILD=2]="MOVE_CHILD",CommandKind[CommandKind.CHANGE_KEY=3]="CHANGE_KEY",CommandKind[CommandKind.CHANGE_VALUE=4]="CHANGE_VALUE",CommandKind[CommandKind.INIT_RAML_FILE=5]="INIT_RAML_FILE"}(exports.CommandKind||(exports.CommandKind={}));var CommandKind=exports.CommandKind,TextChangeCommand=function(){function TextChangeCommand(offset,replacementLength,text,unit,target){void 0===target&&(target=null),this.offset=offset,this.replacementLength=replacementLength,this.text=text,this.unit=unit,this.target=target}return TextChangeCommand}();exports.TextChangeCommand=TextChangeCommand;var CompositeCommand=function(){function CompositeCommand(){this.commands=[]}return CompositeCommand}();exports.CompositeCommand=CompositeCommand,function(InsertionPointType){InsertionPointType[InsertionPointType.NONE=0]="NONE",InsertionPointType[InsertionPointType.START=1]="START",InsertionPointType[InsertionPointType.END=2]="END",InsertionPointType[InsertionPointType.POINT=3]="POINT"}(exports.InsertionPointType||(exports.InsertionPointType={}));var ASTChangeCommand=(exports.InsertionPointType,function(){function ASTChangeCommand(kind,target,value,position){this.toSeq=!1,this.kind=kind,this.target=target,this.value=value,this.position=position}return ASTChangeCommand}());exports.ASTChangeCommand=ASTChangeCommand,exports.setAttr=setAttr,exports.setAttrStructured=setAttrStructured,exports.setKey=setKey,exports.removeNode=removeNode,exports.insertNode=insertNode,exports.initRamlFile=initRamlFile;var LineMapperImpl=function(){function LineMapperImpl(content,absPath){this.content=content,this.absPath=absPath}return LineMapperImpl.prototype.position=function(_pos){var pos=_pos;this.initMapping();for(var i=0;i<this.mapping.length;i++){var lineLength=this.mapping[i];if(pos<lineLength)return{line:i,column:pos,position:_pos};pos-=lineLength}if(0==pos)return{line:this.mapping.length-1,column:this.mapping[this.mapping.length-1],position:this.content.length};if(1==pos)return{line:this.mapping.length-1,column:this.mapping[this.mapping.length-1]-1,position:_pos-1};throw new Error("Character position exceeds text length: "+_pos+" > + "+this.content.length+".\nUnit path: "+this.absPath)},LineMapperImpl.prototype.initMapping=function(){if(null==this.mapping){if(null==this.content)throw new Error("Line Mapper has been given null content"+(null!=this.absPath?". Path: "+this.absPath:" and null path."));this.mapping=[];for(var ind=0,l=this.content.length,i=0;i<l;i++)"\r"==this.content.charAt(i)?i<l-1&&"\n"==this.content.charAt(i+1)?(this.mapping.push(i-ind+2),ind=i+2,i++):(this.mapping.push(i-ind+1),ind=i+1):"\n"==this.content.charAt(i)&&(this.mapping.push(i-ind+1),ind=i+1);this.mapping.push(l-ind)}},LineMapperImpl}();exports.LineMapperImpl=LineMapperImpl,exports.buildPath=buildPath,exports.toAbsolutePath=toAbsolutePath,exports.isWebPath=isWebPath,exports.isLowLevelNode=isLowLevelNode},function(module,exports,__webpack_require__){"use strict";function isApi(node){return"Api"==node.kind()&&"RAML10"==node.RAMLVersion()}function isLibraryBase(node){return"LibraryBase"==node.kind()&&"RAML10"==node.RAMLVersion()}function isAnnotable(node){return"Annotable"==node.kind()&&"RAML10"==node.RAMLVersion()}function isAnnotationRef(node){return"AnnotationRef"==node.kind()&&"RAML10"==node.RAMLVersion()}function isReference(node){return"Reference"==node.kind()&&"RAML10"==node.RAMLVersion()}function isValueType(node){return"ValueType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isStringType(node){return"StringType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isUriTemplate(node){return"UriTemplate"==node.kind()&&"RAML10"==node.RAMLVersion()}function isRelativeUriString(node){return"RelativeUriString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isFullUriTemplateString(node){return"FullUriTemplateString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isStatusCodeString(node){return"StatusCodeString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isFixedUriString(node){return"FixedUriString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isContentType(node){return"ContentType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isMarkdownString(node){return"MarkdownString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isSchemaString(node){return"SchemaString"==node.kind()&&"RAML10"==node.RAMLVersion()}function isMimeType(node){return"MimeType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isAnyType(node){return"AnyType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isNumberType(node){return"NumberType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isIntegerType(node){return"IntegerType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isNullType(node){return"NullType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isTimeOnlyType(node){return"TimeOnlyType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateOnlyType(node){return"DateOnlyType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateTimeOnlyType(node){return"DateTimeOnlyType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateTimeType(node){return"DateTimeType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isFileType(node){return"FileType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isBooleanType(node){return"BooleanType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isAnnotationTarget(node){return"AnnotationTarget"==node.kind()&&"RAML10"==node.RAMLVersion()}function isTraitRef(node){return"TraitRef"==node.kind()&&"RAML10"==node.RAMLVersion()}function isTrait(node){return"Trait"==node.kind()&&"RAML10"==node.RAMLVersion()}function isMethodBase(node){return"MethodBase"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOperation(node){return"Operation"==node.kind()&&"RAML10"==node.RAMLVersion()}function isTypeDeclaration(node){return"TypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isModelLocation(node){return"ModelLocation"==node.kind()&&"RAML10"==node.RAMLVersion()}function isLocationKind(node){return"LocationKind"==node.kind()&&"RAML10"==node.RAMLVersion()}function isExampleSpec(node){return"ExampleSpec"==node.kind()&&"RAML10"==node.RAMLVersion()}function isUsesDeclaration(node){return"UsesDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isXMLFacetInfo(node){return"XMLFacetInfo"==node.kind()&&"RAML10"==node.RAMLVersion()}function isArrayTypeDeclaration(node){return"ArrayTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isUnionTypeDeclaration(node){return"UnionTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isObjectTypeDeclaration(node){return"ObjectTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isStringTypeDeclaration(node){return"StringTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isBooleanTypeDeclaration(node){return"BooleanTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isNumberTypeDeclaration(node){return"NumberTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isIntegerTypeDeclaration(node){return"IntegerTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateOnlyTypeDeclaration(node){return"DateOnlyTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isTimeOnlyTypeDeclaration(node){return"TimeOnlyTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateTimeOnlyTypeDeclaration(node){return"DateTimeOnlyTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateTimeTypeDeclaration(node){return"DateTimeTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDateTypeDeclaration(node){return"DateTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isFileTypeDeclaration(node){return"FileTypeDeclaration"==node.kind()&&"RAML10"==node.RAMLVersion()}function isResponse(node){return"Response"==node.kind()&&"RAML10"==node.RAMLVersion()}function isSecuritySchemePart(node){return"SecuritySchemePart"==node.kind()&&"RAML10"==node.RAMLVersion()}function isSecuritySchemeRef(node){return"SecuritySchemeRef"==node.kind()&&"RAML10"==node.RAMLVersion()}function isAbstractSecurityScheme(node){return"AbstractSecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isSecuritySchemeSettings(node){return"SecuritySchemeSettings"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOAuth1SecuritySchemeSettings(node){return"OAuth1SecuritySchemeSettings"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOAuth2SecuritySchemeSettings(node){return"OAuth2SecuritySchemeSettings"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOAuth2SecurityScheme(node){return"OAuth2SecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOAuth1SecurityScheme(node){return"OAuth1SecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isPassThroughSecurityScheme(node){return"PassThroughSecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isBasicSecurityScheme(node){return"BasicSecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDigestSecurityScheme(node){return"DigestSecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isCustomSecurityScheme(node){return"CustomSecurityScheme"==node.kind()&&"RAML10"==node.RAMLVersion()}function isMethod(node){return"Method"==node.kind()&&"RAML10"==node.RAMLVersion()}function isResourceTypeRef(node){return"ResourceTypeRef"==node.kind()&&"RAML10"==node.RAMLVersion()}function isResourceType(node){return"ResourceType"==node.kind()&&"RAML10"==node.RAMLVersion()}function isResourceBase(node){return"ResourceBase"==node.kind()&&"RAML10"==node.RAMLVersion()}function isResource(node){return"Resource"==node.kind()&&"RAML10"==node.RAMLVersion()}function isDocumentationItem(node){return"DocumentationItem"==node.kind()&&"RAML10"==node.RAMLVersion()}function isLibrary(node){return"Library"==node.kind()&&"RAML10"==node.RAMLVersion()}function isOverlay(node){return"Overlay"==node.kind()&&"RAML10"==node.RAMLVersion()}function isExtension(node){return"Extension"==node.kind()&&"RAML10"==node.RAMLVersion()}function isFragment(node){return null==node.highLevel().parent()}function asFragment(node){return isFragment(node)?node:null}exports.isApi=isApi,exports.isLibraryBase=isLibraryBase,exports.isAnnotable=isAnnotable,exports.isAnnotationRef=isAnnotationRef,exports.isReference=isReference,exports.isValueType=isValueType,exports.isStringType=isStringType,exports.isUriTemplate=isUriTemplate,exports.isRelativeUriString=isRelativeUriString,exports.isFullUriTemplateString=isFullUriTemplateString,exports.isStatusCodeString=isStatusCodeString,exports.isFixedUriString=isFixedUriString,exports.isContentType=isContentType,exports.isMarkdownString=isMarkdownString,exports.isSchemaString=isSchemaString,exports.isMimeType=isMimeType,exports.isAnyType=isAnyType,exports.isNumberType=isNumberType,exports.isIntegerType=isIntegerType,exports.isNullType=isNullType,exports.isTimeOnlyType=isTimeOnlyType,exports.isDateOnlyType=isDateOnlyType,exports.isDateTimeOnlyType=isDateTimeOnlyType,exports.isDateTimeType=isDateTimeType,exports.isFileType=isFileType,exports.isBooleanType=isBooleanType,exports.isAnnotationTarget=isAnnotationTarget,exports.isTraitRef=isTraitRef,exports.isTrait=isTrait,exports.isMethodBase=isMethodBase,exports.isOperation=isOperation,exports.isTypeDeclaration=isTypeDeclaration,exports.isModelLocation=isModelLocation,exports.isLocationKind=isLocationKind,exports.isExampleSpec=isExampleSpec,exports.isUsesDeclaration=isUsesDeclaration,exports.isXMLFacetInfo=isXMLFacetInfo,exports.isArrayTypeDeclaration=isArrayTypeDeclaration,exports.isUnionTypeDeclaration=isUnionTypeDeclaration,exports.isObjectTypeDeclaration=isObjectTypeDeclaration,exports.isStringTypeDeclaration=isStringTypeDeclaration,exports.isBooleanTypeDeclaration=isBooleanTypeDeclaration,exports.isNumberTypeDeclaration=isNumberTypeDeclaration,exports.isIntegerTypeDeclaration=isIntegerTypeDeclaration,exports.isDateOnlyTypeDeclaration=isDateOnlyTypeDeclaration,exports.isTimeOnlyTypeDeclaration=isTimeOnlyTypeDeclaration,exports.isDateTimeOnlyTypeDeclaration=isDateTimeOnlyTypeDeclaration,exports.isDateTimeTypeDeclaration=isDateTimeTypeDeclaration,exports.isDateTypeDeclaration=isDateTypeDeclaration,exports.isFileTypeDeclaration=isFileTypeDeclaration,exports.isResponse=isResponse,exports.isSecuritySchemePart=isSecuritySchemePart,exports.isSecuritySchemeRef=isSecuritySchemeRef,exports.isAbstractSecurityScheme=isAbstractSecurityScheme,exports.isSecuritySchemeSettings=isSecuritySchemeSettings,exports.isOAuth1SecuritySchemeSettings=isOAuth1SecuritySchemeSettings,exports.isOAuth2SecuritySchemeSettings=isOAuth2SecuritySchemeSettings,exports.isOAuth2SecurityScheme=isOAuth2SecurityScheme,exports.isOAuth1SecurityScheme=isOAuth1SecurityScheme,exports.isPassThroughSecurityScheme=isPassThroughSecurityScheme,exports.isBasicSecurityScheme=isBasicSecurityScheme,exports.isDigestSecurityScheme=isDigestSecurityScheme,exports.isCustomSecurityScheme=isCustomSecurityScheme,exports.isMethod=isMethod,exports.isResourceTypeRef=isResourceTypeRef,exports.isResourceType=isResourceType,exports.isResourceBase=isResourceBase,exports.isResource=isResource,exports.isDocumentationItem=isDocumentationItem,exports.isLibrary=isLibrary,exports.isOverlay=isOverlay,exports.isExtension=isExtension,exports.isFragment=isFragment,exports.asFragment=asFragment},function(module,exports,__webpack_require__){"use strict";function isApi(node){return"Api"==node.kind()&&"RAML08"==node.RAMLVersion()}function isFullUriTemplateString(node){return"FullUriTemplateString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isUriTemplate(node){return"UriTemplate"==node.kind()&&"RAML08"==node.RAMLVersion()}function isStringType(node){return"StringType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isValueType(node){return"ValueType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isAnyType(node){return"AnyType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isNumberType(node){return"NumberType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isBooleanType(node){return"BooleanType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isReference(node){return"Reference"==node.kind()&&"RAML08"==node.RAMLVersion()}function isResourceTypeRef(node){return"ResourceTypeRef"==node.kind()&&"RAML08"==node.RAMLVersion()}function isResourceType(node){return"ResourceType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isMethod(node){return"Method"==node.kind()&&"RAML08"==node.RAMLVersion()}function isMethodBase(node){return"MethodBase"==node.kind()&&"RAML08"==node.RAMLVersion()}function isResponse(node){return"Response"==node.kind()&&"RAML08"==node.RAMLVersion()}function isStatusCodeString(node){return"StatusCodeString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isParameter(node){return"Parameter"==node.kind()&&"RAML08"==node.RAMLVersion()}function isParameterLocation(node){return"ParameterLocation"==node.kind()&&"RAML08"==node.RAMLVersion()}function isMarkdownString(node){return"MarkdownString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isStringTypeDeclaration(node){return"StringTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isBooleanTypeDeclaration(node){return"BooleanTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isNumberTypeDeclaration(node){return"NumberTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isIntegerTypeDeclaration(node){return"IntegerTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isDateTypeDeclaration(node){return"DateTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isFileTypeDeclaration(node){return"FileTypeDeclaration"==node.kind()&&"RAML08"==node.RAMLVersion()}function isBodyLike(node){return"BodyLike"==node.kind()&&"RAML08"==node.RAMLVersion()}function isSchemaString(node){return"SchemaString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isJSonSchemaString(node){return"JSonSchemaString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isXMLSchemaString(node){return"XMLSchemaString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isExampleString(node){return"ExampleString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isJSONExample(node){return"JSONExample"==node.kind()&&"RAML08"==node.RAMLVersion()}function isXMLExample(node){return"XMLExample"==node.kind()&&"RAML08"==node.RAMLVersion()}function isXMLBody(node){return"XMLBody"==node.kind()&&"RAML08"==node.RAMLVersion()}function isJSONBody(node){return"JSONBody"==node.kind()&&"RAML08"==node.RAMLVersion()}function isSecuritySchemeRef(node){return"SecuritySchemeRef"==node.kind()&&"RAML08"==node.RAMLVersion()}function isAbstractSecurityScheme(node){return"AbstractSecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isSecuritySchemePart(node){return"SecuritySchemePart"==node.kind()&&"RAML08"==node.RAMLVersion()}function isTraitRef(node){return"TraitRef"==node.kind()&&"RAML08"==node.RAMLVersion()}function isTrait(node){return"Trait"==node.kind()&&"RAML08"==node.RAMLVersion()}function isSecuritySchemeSettings(node){return"SecuritySchemeSettings"==node.kind()&&"RAML08"==node.RAMLVersion()}function isOAuth1SecuritySchemeSettings(node){return"OAuth1SecuritySchemeSettings"==node.kind()&&"RAML08"==node.RAMLVersion()}function isFixedUri(node){return"FixedUri"==node.kind()&&"RAML08"==node.RAMLVersion()}function isOAuth2SecuritySchemeSettings(node){return"OAuth2SecuritySchemeSettings"==node.kind()&&"RAML08"==node.RAMLVersion()}function isOAuth2SecurityScheme(node){return"OAuth2SecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isOAuth1SecurityScheme(node){return"OAuth1SecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isBasicSecurityScheme(node){return"BasicSecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isDigestSecurityScheme(node){return"DigestSecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isCustomSecurityScheme(node){return"CustomSecurityScheme"==node.kind()&&"RAML08"==node.RAMLVersion()}function isMimeType(node){return"MimeType"==node.kind()&&"RAML08"==node.RAMLVersion()}function isRelativeUriString(node){return"RelativeUriString"==node.kind()&&"RAML08"==node.RAMLVersion()}function isGlobalSchema(node){return"GlobalSchema"==node.kind()&&"RAML08"==node.RAMLVersion()}function isRAMLSimpleElement(node){return"RAMLSimpleElement"==node.kind()&&"RAML08"==node.RAMLVersion()}function isDocumentationItem(node){return"DocumentationItem"==node.kind()&&"RAML08"==node.RAMLVersion()}function isResource(node){return"Resource"==node.kind()&&"RAML08"==node.RAMLVersion()}exports.isApi=isApi,exports.isFullUriTemplateString=isFullUriTemplateString,exports.isUriTemplate=isUriTemplate,exports.isStringType=isStringType,exports.isValueType=isValueType,exports.isAnyType=isAnyType,exports.isNumberType=isNumberType,exports.isBooleanType=isBooleanType,exports.isReference=isReference,exports.isResourceTypeRef=isResourceTypeRef,exports.isResourceType=isResourceType,exports.isMethod=isMethod,exports.isMethodBase=isMethodBase,exports.isResponse=isResponse,exports.isStatusCodeString=isStatusCodeString,exports.isParameter=isParameter,exports.isParameterLocation=isParameterLocation,exports.isMarkdownString=isMarkdownString,exports.isStringTypeDeclaration=isStringTypeDeclaration,exports.isBooleanTypeDeclaration=isBooleanTypeDeclaration,exports.isNumberTypeDeclaration=isNumberTypeDeclaration,exports.isIntegerTypeDeclaration=isIntegerTypeDeclaration,exports.isDateTypeDeclaration=isDateTypeDeclaration,exports.isFileTypeDeclaration=isFileTypeDeclaration,exports.isBodyLike=isBodyLike,exports.isSchemaString=isSchemaString,exports.isJSonSchemaString=isJSonSchemaString,exports.isXMLSchemaString=isXMLSchemaString,exports.isExampleString=isExampleString,exports.isJSONExample=isJSONExample,exports.isXMLExample=isXMLExample,exports.isXMLBody=isXMLBody,exports.isJSONBody=isJSONBody,exports.isSecuritySchemeRef=isSecuritySchemeRef,exports.isAbstractSecurityScheme=isAbstractSecurityScheme,exports.isSecuritySchemePart=isSecuritySchemePart,exports.isTraitRef=isTraitRef,exports.isTrait=isTrait,exports.isSecuritySchemeSettings=isSecuritySchemeSettings,exports.isOAuth1SecuritySchemeSettings=isOAuth1SecuritySchemeSettings,exports.isFixedUri=isFixedUri,exports.isOAuth2SecuritySchemeSettings=isOAuth2SecuritySchemeSettings,exports.isOAuth2SecurityScheme=isOAuth2SecurityScheme,exports.isOAuth1SecurityScheme=isOAuth1SecurityScheme,exports.isBasicSecurityScheme=isBasicSecurityScheme,exports.isDigestSecurityScheme=isDigestSecurityScheme,exports.isCustomSecurityScheme=isCustomSecurityScheme,exports.isMimeType=isMimeType,exports.isRelativeUriString=isRelativeUriString,exports.isGlobalSchema=isGlobalSchema,exports.isRAMLSimpleElement=isRAMLSimpleElement,exports.isDocumentationItem=isDocumentationItem,exports.isResource=isResource},function(module,exports,__webpack_require__){"use strict";function isDocumentationProperty(p){return p.nameId()===universe.Universe10.Api.properties.documentation.name||p.nameId()===universe.Universe08.Api.properties.documentation.name}function isUsagePropertyName(name){return name===universe.Universe10.Trait.properties.usage.name||name===universe.Universe08.Trait.properties.usage.name||name===universe.Universe10.ResourceType.properties.usage.name||name===universe.Universe08.ResourceType.properties.usage.name||name===universe.Universe10.Library.properties.usage.name||name===universe.Universe10.Overlay.properties.usage.name||name===universe.Universe10.Extension.properties.usage.name}function isUsageProperty(p){return isUsagePropertyName(p.nameId())}function isMasterRefProperty(p){return p.nameId()==universe.Universe10.Overlay.properties.extends.name||p.nameId()==universe.Universe10.Extension.properties.extends.name}function isDescriptionPropertyName(name){return name===universe.Universe10.TypeDeclaration.properties.description.name||"description"===name}function isDescriptionProperty(p){return isDescriptionPropertyName(p.nameId())}function isRequiredPropertyName(name){return name===universe.Universe10.TypeDeclaration.properties.required.name||name===universe.Universe08.Parameter.properties.required.name||"required"===name}function isDisplayNamePropertyName(name){return name===universe.Universe10.TypeDeclaration.properties.displayName.name||"displayName"===name}function isDisplayNameProperty(p){return isDisplayNamePropertyName(p.nameId())}function isRequiredProperty(p){return isRequiredPropertyName(p.nameId())}function isTitlePropertyName(name){return name===universe.Universe10.Api.properties.title.name||name===universe.Universe08.Api.properties.title.name||name===universe.Universe10.DocumentationItem.properties.title.name||name===universe.Universe08.DocumentationItem.properties.title.name||name===universe.Universe10.Overlay.properties.title.name||name===universe.Universe10.Extension.properties.title.name;
}function isTitleProperty(p){return isTitlePropertyName(p.nameId())}function isHeadersProperty(p){return isHeadersPropertyName(p.nameId())}function isHeadersPropertyName(name){return name===universe.Universe08.MethodBase.properties.headers.name||name===universe.Universe08.Response.properties.headers.name||name===universe.Universe08.SecuritySchemePart.properties.headers.name||name===universe.Universe10.MethodBase.properties.headers.name||name===universe.Universe10.Response.properties.headers.name}function isFormParametersProperty(p){return isFormParametersPropertyName(p.nameId())}function isFormParametersPropertyName(name){return name===universe.Universe08.BodyLike.properties.formParameters.name}function isQueryParametersProperty(p){return isQueryParametersPropertyName(p.nameId())}function isQueryParametersPropertyName(name){return name===universe.Universe08.MethodBase.properties.queryParameters.name||name===universe.Universe08.SecuritySchemePart.properties.queryParameters.name||name===universe.Universe10.MethodBase.properties.queryParameters.name}function isAnnotationsProperty(p){return p.nameId()===universe.Universe10.Api.properties.annotations.name||p.nameId()===universe.Universe10.TypeDeclaration.properties.annotations.name||p.nameId()===universe.Universe10.Response.properties.annotations.name}function isAnnotationProperty(p){return p.nameId()===universe.Universe10.AnnotationRef.properties.annotation.name}function isIsProperty(p){return p.nameId()===universe.Universe10.MethodBase.properties.is.name||p.nameId()===universe.Universe08.Method.properties.is.name||p.nameId()===universe.Universe10.ResourceBase.properties.is.name||p.nameId()===universe.Universe08.ResourceType.properties.is.name||p.nameId()===universe.Universe08.Resource.properties.is.name}function isSecuredByProperty(p){return p.nameId()===universe.Universe10.Api.properties.securedBy.name||p.nameId()===universe.Universe08.Api.properties.securedBy.name||p.nameId()===universe.Universe10.MethodBase.properties.securedBy.name||p.nameId()===universe.Universe08.MethodBase.properties.securedBy.name||p.nameId()===universe.Universe08.ResourceType.properties.securedBy.name||p.nameId()===universe.Universe08.Resource.properties.securedBy.name||p.nameId()===universe.Universe10.ResourceBase.properties.securedBy.name}function isSecuritySchemesProperty(p){return p.nameId()===universe.Universe10.LibraryBase.properties.securitySchemes.name||p.nameId()===universe.Universe08.Api.properties.securitySchemes.name}function isSecuritySchemeProperty(p){return p.nameId()===universe.Universe10.SecuritySchemeRef.properties.securityScheme.name||p.nameId()===universe.Universe08.SecuritySchemeRef.properties.securityScheme.name}function isTypeProperty(p){return p.nameId()===universe.Universe10.AbstractSecurityScheme.properties.type.name||p.nameId()===universe.Universe08.AbstractSecurityScheme.properties.type.name||p.nameId()===universe.Universe08.ResourceType.properties.type.name||p.nameId()===universe.Universe08.Resource.properties.type.name||p.nameId()===universe.Universe08.Parameter.properties.type.name||p.nameId()===universe.Universe10.ResourceBase.properties.type.name||p.nameId()===universe.Universe10.TypeDeclaration.properties.type.name}function isPropertiesProperty(p){return p.nameId()===universe.Universe10.ObjectTypeDeclaration.properties.properties.name}function isResponsesProperty(p){return p.nameId()===universe.Universe10.MethodBase.properties.responses.name||p.nameId()===universe.Universe08.MethodBase.properties.responses.name}function isProtocolsProperty(p){return p.nameId()===universe.Universe10.Api.properties.protocols.name||p.nameId()===universe.Universe08.Api.properties.protocols.name||p.nameId()===universe.Universe10.MethodBase.properties.protocols.name}function isNameProperty(p){return p.nameId()===universe.Universe10.TypeDeclaration.properties.name.name||p.nameId()===universe.Universe10.TypeDeclaration.properties.name.name||p.nameId()===universe.Universe08.AbstractSecurityScheme.properties.name.name||p.nameId()===universe.Universe10.AbstractSecurityScheme.properties.name.name||p.nameId()===universe.Universe08.Trait.properties.name.name||p.nameId()===universe.Universe10.Trait.properties.name.name||"name"===p.nameId()}function isBodyProperty(p){return p.nameId()===universe.Universe10.MethodBase.properties.body.name||p.nameId()===universe.Universe08.MethodBase.properties.body.name||p.nameId()===universe.Universe10.Response.properties.body.name||p.nameId()===universe.Universe08.Response.properties.body.name}function isDefaultValue(p){return p.nameId()===universe.Universe10.TypeDeclaration.properties.default.name||p.nameId()===universe.Universe08.Parameter.properties.default.name}function isSchemaProperty(p){return p.nameId()===universe.Universe08.BodyLike.properties.schema.name||p.nameId()===universe.Universe08.XMLBody.properties.schema.name||p.nameId()===universe.Universe08.JSONBody.properties.schema.name||p.nameId()===universe.Universe10.TypeDeclaration.properties.schema.name}function isTraitsProperty(p){return p.nameId()===universe.Universe08.Api.properties.traits.name||p.nameId()===universe.Universe10.LibraryBase.properties.traits.name}function isTraitProperty(p){return p.nameId()===universe.Universe08.TraitRef.properties.trait.name||p.nameId()===universe.Universe10.TraitRef.properties.trait.name}function isResourceTypesProperty(p){return p.nameId()===universe.Universe08.Api.properties.resourceTypes.name||p.nameId()===universe.Universe10.LibraryBase.properties.resourceTypes.name}function isResourceTypeProperty(p){return p.nameId()===universe.Universe08.ResourceTypeRef.properties.resourceType.name||p.nameId()===universe.Universe10.ResourceTypeRef.properties.resourceType.name}function isFacetsProperty(p){return p.nameId()===universe.Universe10.TypeDeclaration.properties.facets.name}function isSchemasProperty(p){return p.nameId()===universe.Universe08.Api.properties.schemas.name||p.nameId()===universe.Universe10.LibraryBase.properties.schemas.name}function isResourcesProperty(p){return p.nameId()===universe.Universe10.Api.properties.resources.name||p.nameId()===universe.Universe08.Api.properties.resources.name||p.nameId()===universe.Universe10.Resource.properties.resources.name||p.nameId()===universe.Universe08.Resource.properties.resources.name}function isMethodsProperty(p){return p.nameId()===universe.Universe10.ResourceBase.properties.methods.name||p.nameId()===universe.Universe08.Resource.properties.methods.name||p.nameId()===universe.Universe08.ResourceType.properties.methods.name}function isTypesProperty(p){return p.nameId()===universe.Universe10.LibraryBase.properties.types.name}function isExampleProperty(p){return p.nameId()===universe.Universe10.TypeDeclaration.properties.example.name||"example"===p.nameId()}function isEnumProperty(p){return p.nameId()===universe.Universe10.StringTypeDeclaration.properties.enum.name||p.nameId()===universe.Universe10.NumberTypeDeclaration.properties.enum.name||p.nameId()===universe.Universe08.StringTypeDeclaration.properties.enum.name}function isExamplesProperty(p){return p.nameId()===universe.Universe10.TypeDeclaration.properties.example.name||p.nameId()===universe.Universe10.TypeDeclaration.properties.examples.name}function isValueProperty(p){return p.nameId()===universe.Universe08.GlobalSchema.properties.value.name}function isUriParametersProperty(p){return p.nameId()===universe.Universe08.Api.properties.uriParameters.name||p.nameId()===universe.Universe08.ResourceType.properties.uriParameters.name||p.nameId()===universe.Universe08.Resource.properties.uriParameters.name||p.nameId()===universe.Universe10.ResourceBase.properties.uriParameters.name}function isBaseUriParametersProperty(p){return p.nameId()===universe.Universe08.Resource.properties.baseUriParameters.name||p.nameId()===universe.Universe08.Api.properties.baseUriParameters.name||p.nameId()===universe.Universe10.Api.properties.baseUriParameters.name}function isRAMLVersionProperty(p){return p.nameId()===universe.Universe08.Api.properties.RAMLVersion.name||p.nameId()===universe.Universe10.Api.properties.RAMLVersion.name}function isUsesProperty(p){return p.nameId()===universe.Universe10.FragmentDeclaration.properties.uses.name}function isAnnotationTypesProperty(p){return p.nameId()===universe.Universe10.LibraryBase.properties.annotationTypes.name}function isMethodType(type){return type.key()==universe.Universe10.Method||type.key()==universe.Universe08.Method}function isApiType(type){return type.key()==universe.Universe10.Api||type.key()==universe.Universe08.Api}function isBooleanTypeType(type){return type.key()==universe.Universe10.BooleanType||type.key()==universe.Universe08.BooleanType}function isMarkdownStringType(type){return type.key()==universe.Universe10.MarkdownString||type.key()==universe.Universe08.MarkdownString}function isResourceType(type){return type.key()==universe.Universe10.Resource||type.key()==universe.Universe08.Resource}function isTraitType(type){return type.key()==universe.Universe10.Trait||type.key()==universe.Universe08.Trait}function isTraitRefType(type){return type.key()==universe.Universe10.TraitRef||type.key()==universe.Universe08.TraitRef}function isResourceTypeRefType(type){return type.key()==universe.Universe10.ResourceTypeRef||type.key()==universe.Universe08.ResourceTypeRef}function isGlobalSchemaType(type){return type.key()==universe.Universe08.GlobalSchema}function isSecuritySchemaType(type){return type.key()==universe.Universe10.AbstractSecurityScheme||type.key()==universe.Universe08.AbstractSecurityScheme}function isSecuritySchemeRefType(type){return type.key()==universe.Universe10.SecuritySchemeRef||type.key()==universe.Universe08.SecuritySchemeRef}function isTypeDeclarationType(type){return type.key()==universe.Universe10.TypeDeclaration}function isResponseType(type){return type.key()==universe.Universe10.Response||type.key()==universe.Universe08.Response}function isBodyLikeType(type){return type.key()==universe.Universe08.BodyLike}function isOverlayType(type){return type.key()==universe.Universe10.Overlay}function isAnnotationTypeType(type){return!1}function isResourceTypeType(type){return type.key()==universe.Universe10.ResourceType||type.key()==universe.Universe08.ResourceType}function isSchemaStringType(type){return type.key()==universe.Universe10.SchemaString||type.key()==universe.Universe08.SchemaString}function isMethodBaseType(type){return type.key()==universe.Universe10.MethodBase||type.key()==universe.Universe08.MethodBase}function isLibraryType(type){return type.key()==universe.Universe10.Library}function isStringTypeType(type){return type.key()==universe.Universe10.StringType||type.key()==universe.Universe08.StringType}function isExampleSpecType(type){return type.key()==universe.Universe10.ExampleSpec}function isExtensionType(type){return type.key()==universe.Universe10.Extension}function isTypeDeclarationTypeOrDescendant(type){return type.isAssignableFrom(universe.Universe10.TypeDeclaration.name)}function isDocumentationType(type){return type.key()==universe.Universe10.DocumentationItem||type.key()==universe.Universe08.DocumentationItem}function isAnnotationRefTypeOrDescendant(type){return type.isAssignableFrom(universe.Universe10.AnnotationRef.name)}function isApiSibling(type){return type.isAssignableFrom(universe.Universe10.Api.name)||type.isAssignableFrom(universe.Universe08.Api.name)}function isLibraryBaseSibling(type){return type.isAssignableFrom(universe.Universe10.LibraryBase.name)}function isResourceBaseSibling(type){return type.isAssignableFrom(universe.Universe10.ResourceBase.name)||type.isAssignableFrom(universe.Universe08.Resource.name)}function isObjectTypeDeclarationSibling(type){return type.isAssignableFrom(universe.Universe10.ObjectTypeDeclaration.name)}function isTypeDeclarationSibling(type){return type.isAssignableFrom(universe.Universe10.TypeDeclaration.name)}function isMethodBaseSibling(type){return type.isAssignableFrom(universe.Universe10.MethodBase.name)||type.isAssignableFrom(universe.Universe08.MethodBase.name)}function isSecuritySchemePartType(type){return type.key()==universe.Universe10.SecuritySchemePart||type.key()==universe.Universe08.SecuritySchemePart}function isMediaTypeProperty(p){return p.nameId()===universe.Universe08.Api.properties.mediaType.name||p.nameId()===universe.Universe10.Api.properties.mediaType.name}function isRAML08Type(type){return"RAML08"==type.universe().version()}function isRAML10Type(type){return"RAML10"==type.universe().version()}function isRAML08Node(node){return isRAML08Type(node.definition())}function isRAML08Attribute(node){return isRAML08Type(node.definition())}function isRAML10Node(node){return isRAML10Type(node.definition())}function isRAML10Attribute(node){return isRAML10Type(node.definition())}var universe=__webpack_require__(22);exports.isDocumentationProperty=isDocumentationProperty,exports.isUsagePropertyName=isUsagePropertyName,exports.isUsageProperty=isUsageProperty,exports.isMasterRefProperty=isMasterRefProperty,exports.isDescriptionPropertyName=isDescriptionPropertyName,exports.isDescriptionProperty=isDescriptionProperty,exports.isRequiredPropertyName=isRequiredPropertyName,exports.isDisplayNamePropertyName=isDisplayNamePropertyName,exports.isDisplayNameProperty=isDisplayNameProperty,exports.isRequiredProperty=isRequiredProperty,exports.isTitlePropertyName=isTitlePropertyName,exports.isTitleProperty=isTitleProperty,exports.isHeadersProperty=isHeadersProperty,exports.isHeadersPropertyName=isHeadersPropertyName,exports.isFormParametersProperty=isFormParametersProperty,exports.isFormParametersPropertyName=isFormParametersPropertyName,exports.isQueryParametersProperty=isQueryParametersProperty,exports.isQueryParametersPropertyName=isQueryParametersPropertyName,exports.isAnnotationsProperty=isAnnotationsProperty,exports.isAnnotationProperty=isAnnotationProperty,exports.isIsProperty=isIsProperty,exports.isSecuredByProperty=isSecuredByProperty,exports.isSecuritySchemesProperty=isSecuritySchemesProperty,exports.isSecuritySchemeProperty=isSecuritySchemeProperty,exports.isTypeProperty=isTypeProperty,exports.isPropertiesProperty=isPropertiesProperty,exports.isResponsesProperty=isResponsesProperty,exports.isProtocolsProperty=isProtocolsProperty,exports.isNameProperty=isNameProperty,exports.isBodyProperty=isBodyProperty,exports.isDefaultValue=isDefaultValue,exports.isSchemaProperty=isSchemaProperty,exports.isTraitsProperty=isTraitsProperty,exports.isTraitProperty=isTraitProperty,exports.isResourceTypesProperty=isResourceTypesProperty,exports.isResourceTypeProperty=isResourceTypeProperty,exports.isFacetsProperty=isFacetsProperty,exports.isSchemasProperty=isSchemasProperty,exports.isResourcesProperty=isResourcesProperty,exports.isMethodsProperty=isMethodsProperty,exports.isTypesProperty=isTypesProperty,exports.isExampleProperty=isExampleProperty,exports.isEnumProperty=isEnumProperty,exports.isExamplesProperty=isExamplesProperty,exports.isValueProperty=isValueProperty,exports.isUriParametersProperty=isUriParametersProperty,exports.isBaseUriParametersProperty=isBaseUriParametersProperty,exports.isRAMLVersionProperty=isRAMLVersionProperty,exports.isUsesProperty=isUsesProperty,exports.isAnnotationTypesProperty=isAnnotationTypesProperty,exports.isMethodType=isMethodType,exports.isApiType=isApiType,exports.isBooleanTypeType=isBooleanTypeType,exports.isMarkdownStringType=isMarkdownStringType,exports.isResourceType=isResourceType,exports.isTraitType=isTraitType,exports.isTraitRefType=isTraitRefType,exports.isResourceTypeRefType=isResourceTypeRefType,exports.isGlobalSchemaType=isGlobalSchemaType,exports.isSecuritySchemaType=isSecuritySchemaType,exports.isSecuritySchemeRefType=isSecuritySchemeRefType,exports.isTypeDeclarationType=isTypeDeclarationType,exports.isResponseType=isResponseType,exports.isBodyLikeType=isBodyLikeType,exports.isOverlayType=isOverlayType,exports.isAnnotationTypeType=isAnnotationTypeType,exports.isResourceTypeType=isResourceTypeType,exports.isSchemaStringType=isSchemaStringType,exports.isMethodBaseType=isMethodBaseType,exports.isLibraryType=isLibraryType,exports.isStringTypeType=isStringTypeType,exports.isExampleSpecType=isExampleSpecType,exports.isExtensionType=isExtensionType,exports.isTypeDeclarationTypeOrDescendant=isTypeDeclarationTypeOrDescendant,exports.isDocumentationType=isDocumentationType,exports.isAnnotationRefTypeOrDescendant=isAnnotationRefTypeOrDescendant,exports.isApiSibling=isApiSibling,exports.isLibraryBaseSibling=isLibraryBaseSibling,exports.isResourceBaseSibling=isResourceBaseSibling,exports.isObjectTypeDeclarationSibling=isObjectTypeDeclarationSibling,exports.isTypeDeclarationSibling=isTypeDeclarationSibling,exports.isMethodBaseSibling=isMethodBaseSibling,exports.isSecuritySchemePartType=isSecuritySchemePartType,exports.isMediaTypeProperty=isMediaTypeProperty,exports.isRAML08Type=isRAML08Type,exports.isRAML10Type=isRAML10Type,exports.isRAML08Node=isRAML08Node,exports.isRAML08Attribute=isRAML08Attribute,exports.isRAML10Node=isRAML10Node,exports.isRAML10Attribute=isRAML10Attribute},function(module,exports,__webpack_require__){(function(process){function normalizeArray(parts,allowAboveRoot){for(var up=0,i=parts.length-1;i>=0;i--){var last=parts[i];"."===last?parts.splice(i,1):".."===last?(parts.splice(i,1),up++):up&&(parts.splice(i,1),up--)}if(allowAboveRoot)for(;up--;up)parts.unshift("..");return parts}function filter(xs,f){if(xs.filter)return xs.filter(f);for(var res=[],i=0;i<xs.length;i++)f(xs[i],i,xs)&&res.push(xs[i]);return res}var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,splitPath=function(filename){return splitPathRe.exec(filename).slice(1)};exports.resolve=function(){for(var resolvedPath="",resolvedAbsolute=!1,i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:process.cwd();if("string"!=typeof path)throw new TypeError("Arguments to path.resolve must be strings");path&&(resolvedPath=path+"/"+resolvedPath,resolvedAbsolute="/"===path.charAt(0))}return resolvedPath=normalizeArray(filter(resolvedPath.split("/"),function(p){return!!p}),!resolvedAbsolute).join("/"),(resolvedAbsolute?"/":"")+resolvedPath||"."},exports.normalize=function(path){var isAbsolute=exports.isAbsolute(path),trailingSlash="/"===substr(path,-1);return path=normalizeArray(filter(path.split("/"),function(p){return!!p}),!isAbsolute).join("/"),path||isAbsolute||(path="."),path&&trailingSlash&&(path+="/"),(isAbsolute?"/":"")+path},exports.isAbsolute=function(path){return"/"===path.charAt(0)},exports.join=function(){var paths=Array.prototype.slice.call(arguments,0);return exports.normalize(filter(paths,function(p,index){if("string"!=typeof p)throw new TypeError("Arguments to path.join must be strings");return p}).join("/"))},exports.relative=function(from,to){function trim(arr){for(var start=0;start<arr.length&&""===arr[start];start++);for(var end=arr.length-1;end>=0&&""===arr[end];end--);return start>end?[]:arr.slice(start,end-start+1)}from=exports.resolve(from).substr(1),to=exports.resolve(to).substr(1);for(var fromParts=trim(from.split("/")),toParts=trim(to.split("/")),length=Math.min(fromParts.length,toParts.length),samePartsLength=length,i=0;i<length;i++)if(fromParts[i]!==toParts[i]){samePartsLength=i;break}for(var outputParts=[],i=samePartsLength;i<fromParts.length;i++)outputParts.push("..");return outputParts=outputParts.concat(toParts.slice(samePartsLength)),outputParts.join("/")},exports.sep="/",exports.delimiter=":",exports.dirname=function(path){var result=splitPath(path),root=result[0],dir=result[1];return root||dir?(dir&&(dir=dir.substr(0,dir.length-1)),root+dir):"."},exports.basename=function(path,ext){var f=splitPath(path)[2];return ext&&f.substr(-1*ext.length)===ext&&(f=f.substr(0,f.length-ext.length)),f},exports.extname=function(path){return splitPath(path)[3]};var substr="b"==="ab".substr(-1)?function(str,start,len){return str.substr(start,len)}:function(str,start,len){return start<0&&(start=str.length+start),str.substr(start,len)}}).call(exports,__webpack_require__(59))},function(module,exports,__webpack_require__){"use strict";function qName(x,context){var nm=x.name();if(context.lowLevel()instanceof proxy.LowLevelProxyNode){if(x.lowLevel()instanceof proxy.LowLevelProxyNode)return nm;var rootUnit=context.root().lowLevel().unit(),resolver=rootUnit.project().namespaceResolver(),unit=x.lowLevel().unit(),ns=resolver.resolveNamespace(rootUnit,unit);if(null!=ns)return ns+"."+nm}if(x.lowLevel().unit()!=context.lowLevel().unit())for(var root=context;;){if(root.lowLevel().includePath()||null==root.parent()){root.unitMap||(root.unitMap={},root.asElement().elements().forEach(function(x){if(x.definition().key()==universes.Universe10.UsesDeclaration){var mm=x.attr("value");if(mm){var unit=x.root().lowLevel().unit().resolve(mm.value());if(null!=unit){var key=x.attr("key");key&&(root.unitMap[unit.absolutePath()]=key.value())}}}}));var prefix=root.unitMap[x.lowLevel().unit().absolutePath()];if(prefix)return prefix+"."+nm}if(!root.parent())break;root=root.parent()}return nm}function ramlFirstLine(content){return content.match(/^\s*#%RAML\s+(\d\.\d)\s*(\w*)\s*$/m)}function getFragmentDefenitionName(highLevelNode){var contents=highLevelNode.lowLevel()&&highLevelNode.lowLevel().unit()&&highLevelNode.lowLevel().unit().contents();return null==contents?null:getDefinitionSystemType(contents,highLevelNode.lowLevel()).ptype}function fromUnit(l){if(null==l)return null;var contents=l.contents(),ast=l.ast(),__ret=getDefinitionSystemType(contents,ast),ptype=__ret.ptype,localUniverse=__ret.localUniverse,apiType=localUniverse.type(ptype);apiType||(apiType=localUniverse.type("Api"));var api=new ASTNodeImpl(ast,null,apiType,null);return api.setUniverse(localUniverse),api.children(),api}function createBasicValidationAcceptor(errors){var q={accept:function(c){errors.push(c)},begin:function(){},end:function(){},acceptUnique:function(issue){for(var _i=0,errors_1=errors;_i<errors_1.length;_i++){var e=errors_1[_i];if(e.start==issue.start&&e.message==issue.message)return}this.accept(issue)}};return q}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},defs=__webpack_require__(36),hl=__webpack_require__(10),_=__webpack_require__(61),proxy=__webpack_require__(38),def=defs,builder=__webpack_require__(26),search=__webpack_require__(23),mutators=__webpack_require__(39),linter=__webpack_require__(25),expander=__webpack_require__(24),typeBuilder=__webpack_require__(40),universes=__webpack_require__(22),jsyaml=__webpack_require__(27),textutil=__webpack_require__(41),services=def,yaml=__webpack_require__(70),wrapperHelper=__webpack_require__(32),factory10=__webpack_require__(42),factory08=__webpack_require__(43),universeHelpers=__webpack_require__(14),resourceRegistry=__webpack_require__(28),rTypes=defs.rt,contentprovider=__webpack_require__(30);exports.qName=qName;var BasicASTNode=function(){function BasicASTNode(_node,_parent){this._node=_node,this._parent=_parent,this._implicit=!1,this.values={},_node&&_node.setHighLevelParseResult(this)}return BasicASTNode.prototype.getKind=function(){return hl.NodeKind.BASIC},BasicASTNode.prototype.asAttr=function(){return null},BasicASTNode.prototype.asElement=function(){return null},BasicASTNode.prototype.hashkey=function(){return this._hashkey||(this._hashkey=this.parent()?this.parent().hashkey()+"/"+this.name():this.name()),this._hashkey},BasicASTNode.prototype.root=function(){return this.parent()?this.parent().root():this},BasicASTNode.prototype.version=function(){return""},BasicASTNode.prototype.getLowLevelStart=function(){return this.lowLevel().kind()===jsyaml.Kind.SCALAR?this.lowLevel().start():this.lowLevel().keyStart()},BasicASTNode.prototype.getLowLevelEnd=function(){return this.lowLevel().kind()===jsyaml.Kind.SCALAR?this.lowLevel().end():this.lowLevel().keyEnd()},BasicASTNode.prototype.isSameNode=function(n){return!(!n||n.lowLevel().actual()!=this.lowLevel().actual())},BasicASTNode.prototype.checkContextValue=function(name,value,thisObj){var vl=this.computedValue(name);return!(!vl||vl.indexOf(value)==-1)||(value==vl||"false"==value)},BasicASTNode.prototype.printDetails=function(indent){return(indent?indent:"")+"Unkown\n"},BasicASTNode.prototype.testSerialize=function(indent){return(indent?indent:"")+"Unkown\n"},BasicASTNode.prototype.errors=function(){var errors=[],q=createBasicValidationAcceptor(errors);return this.validate(q),errors},BasicASTNode.prototype.markCh=function(){for(var n=this.lowLevel();n instanceof proxy.LowLevelProxyNode;)n=n.originalNode();return n=n._node?n._node:n,!!n.markCh||void(n.markCh=1)},BasicASTNode.prototype.unmarkCh=function(){for(var n=this.lowLevel();n instanceof proxy.LowLevelProxyNode;)n=n.originalNode();n=n._node?n._node:n,delete n.markCh},BasicASTNode.prototype.validate=function(v){linter.validate(this,v)},BasicASTNode.prototype.allowRecursive=function(){return!1},BasicASTNode.prototype.setComputed=function(name,v){this.values[name]=v},BasicASTNode.prototype.computedValue=function(name){var vl=this.values[name];return!vl&&this.parent()?this.parent().computedValue(name):vl},BasicASTNode.prototype.lowLevel=function(){return this._node},BasicASTNode.prototype.name=function(){var c=this.lowLevel().key();return c?c:""},BasicASTNode.prototype.optional=function(){var llNode=this.lowLevel(),ownValue=llNode.optional();if(null!=llNode.key())return ownValue;var p=this.property();if(!p||!p.isMultiValue())return ownValue;for(var llParent=llNode.parent();llParent&&null==llParent.highLevelNode();){if(llParent.kind()==yaml.Kind.MAPPING)return llParent.optional();llParent=llParent.parent()}return ownValue},BasicASTNode.prototype.parent=function(){return this._parent},BasicASTNode.prototype.setParent=function(parent){this._parent=parent},BasicASTNode.prototype.isElement=function(){return!1},BasicASTNode.prototype.directChildren=function(){return this.children()},BasicASTNode.prototype.children=function(){return[]},BasicASTNode.prototype.isAttached=function(){return null!=this.parent()},BasicASTNode.prototype.isImplicit=function(){return this._implicit},BasicASTNode.prototype.isAttr=function(){return!1},BasicASTNode.prototype.isUnknown=function(){return!0},BasicASTNode.prototype.id=function(){var _this=this;if(this.cachedId)return this.cachedId;if(this._parent){var parentId=this.parent().id();parentId+="."+this.name();var sameName=this.parent().directChildren().filter(function(x){return x.name()==_this.name()});if(sameName.length>1){var ind=sameName.indexOf(this);parentId+="["+ind+"]"}return this.cachedId=parentId,parentId}return this.cachedId="",this.cachedId},BasicASTNode.prototype.localId=function(){return this.name()},BasicASTNode.prototype.fullLocalId=function(){var _this=this;if(this.cachedFullId)return this.cachedFullId;if(this._parent){var result="."+this.name(),sameName=this.parent().directChildren().filter(function(x){return x.name()==_this.name()});if(sameName.length>1){var ind=sameName.indexOf(this);result+="["+ind+"]"}return this.cachedFullId=result,result}return this.cachedFullId=this.localId(),this.cachedFullId},BasicASTNode.prototype.property=function(){return null},BasicASTNode}();exports.BasicASTNode=BasicASTNode;var StructuredValue=function(){function StructuredValue(node,_parent,_pr,kv){void 0===kv&&(kv=null),this.node=node,this._parent=_parent,this.kv=kv,this._pr=_pr}return StructuredValue.prototype.valueName=function(){var res=null;return this.kv&&(res=this.kv),res=this.node.key(),this._pr&&this._pr.isAnnotation()&&res&&"("==res.charAt(0)&&(res=res.substring(1,res.length-1)),res},StructuredValue.prototype.children=function(){return this.node.children().map(function(x){return new StructuredValue(x,null,null)})},StructuredValue.prototype.lowLevel=function(){return this.node},StructuredValue.prototype.toHighLevel=function(parent){if(!parent&&this._parent&&(parent=this._parent),this._hl)return this._hl;var vn=this.valueName(),cands=search.referenceTargets(this._pr,parent).filter(function(x){return qName(x,parent)==vn});if(cands&&cands[0]){var tp=cands[0].localType(),node=new ASTNodeImpl(this.node,parent,tp,this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(y){node.setComputed(y.name,y.value)}),this._hl=node,node}return null},StructuredValue.prototype.toHighLevel2=function(parent){!parent&&this._parent&&(parent=this._parent);var vn=this.valueName(),cands=search.referenceTargets(this._pr,parent).filter(function(x){return qName(x,parent)==vn});if(cands&&cands[0]){var tp=cands[0].localType(),node=new ASTNodeImpl(this.node,parent,tp,this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(y){node.setComputed(y.name,y.value)}),node}if(this._pr.range()){var node=new ASTNodeImpl(this.node.parent(),parent,this._pr.range(),this._pr);return this._pr&&this._pr.childRestrictions().forEach(function(y){node.setComputed(y.name,y.value)}),node}return null},StructuredValue}();exports.StructuredValue=StructuredValue;var ASTPropImpl=function(_super){function ASTPropImpl(node,parent,_def,_prop,fromKey){void 0===fromKey&&(fromKey=!1),_super.call(this,node,parent),this._def=_def,this._prop=_prop,this.fromKey=fromKey}return __extends(ASTPropImpl,_super),ASTPropImpl.prototype.definition=function(){return this._def},ASTPropImpl.prototype.asAttr=function(){return this},ASTPropImpl.prototype.errors=function(){var errors=[],q=createBasicValidationAcceptor(errors);return this.parent().validate(q),errors},ASTPropImpl.prototype.isString=function(){return!(!this._def||this._def.key()!==universes.Universe08.StringType&&this._def.key()!=universes.Universe10.StringType)},ASTPropImpl.prototype.isAnnotatedScalar=function(){return!this.property().isAnnotation()&&!this.property().isKey()&&this.lowLevel().isAnnotatedScalar()},ASTPropImpl.prototype.annotations=function(){var ch=this.lowLevel().children(),annotations=[],u=this.definition().universe().type(universes.Universe10.Annotable.name);if(!u)return annotations;for(var pr=u.property("annotations"),i=0;i<ch.length;i++){var child=ch[i],key=child.key();if(null!=key&&"("==key[0]&&")"==key[key.length-1]){var attr=new ASTPropImpl(child,this.parent(),pr.range(),pr);annotations.push(attr)}}return annotations},ASTPropImpl.prototype.getKind=function(){return hl.NodeKind.ATTRIBUTE},ASTPropImpl.prototype.owningWrapper=function(){return{node:this.parent().wrapperNode(),property:this.name()}},ASTPropImpl.prototype.patchType=function(t){this._def=t},ASTPropImpl.prototype.findReferenceDeclaration=function(){var _this=this,targets=search.referenceTargets(this.property(),this.parent()),vl=this.value();if(vl instanceof StructuredValue)var st=vl,nm=st.valueName();else var nm=""+vl;var t=_.find(targets,function(x){return qName(x,_this.parent())==nm});return t},ASTPropImpl.prototype.findReferencedValue=function(){var c=this.findReferenceDeclaration();if(c){var vl=c.attr("value"),ck=c.definition().key();if(ck===universes.Universe08.GlobalSchema){if(vl){var actualValue=vl.value();if(actualValue){var rf=linter.isValid(this._def,this.parent(),actualValue,vl.property());return rf}}return null}}return c},ASTPropImpl.prototype.isElement=function(){return!1},ASTPropImpl.prototype.property=function(){return this._prop},ASTPropImpl.prototype.convertMultivalueToString=function(value){for(var gap=0,pos=2;" "==value[pos];)gap++,pos++;var lines=textutil.splitOnLines(value);return lines=lines.map(function(line){return line.substring(gap,line.length)}),lines.join("")},ASTPropImpl.prototype.overrideValue=function(value){this._value=value},ASTPropImpl.prototype.value=function(){return this._value?this._value:(this._value=this.calcValue(),this._value)},ASTPropImpl.prototype.calcValue=function(){if(this._computed)return this.computedValue(this.property().nameId());if(this.fromKey){var parent=this.parent(),definition=parent.definition();if("RAML08"==definition.universe().version())return this._node.key();
if(universeHelpers.isNameProperty(this.property())&&definition.isAssignableFrom(universes.Universe10.TypeDeclaration.name)){var requiredAttr=parent.attr("required");if(requiredAttr&&null!=requiredAttr.value())return this._node.optional()?this._node.key()+"?":this._node.key()}return this._node.key()}if(this.property().isAnnotation()&&this._node.key()&&"annotations"!=this._node.key())return new StructuredValue(this._node,this.parent(),this._prop);var isString=null!=this.property()&&!(null==this.parent()||null==this.parent().definition()||universeHelpers.isTypeProperty(this.property())&&universeHelpers.isTypeDeclarationSibling(this.parent().definition()))&&universeHelpers.isStringTypeType(this.property().range()),actualValue=this._node.value(isString);if(this.property().isSelfNode()&&(!actualValue||actualValue instanceof jsyaml.ASTNode)&&(actualValue=this._node,0==actualValue.children().length&&(actualValue=null)),actualValue instanceof jsyaml.ASTNode||actualValue instanceof proxy.LowLevelProxyNode){var isAnnotatedScalar=!1;if(this.property().range().hasStructure()||this._node.isAnnotatedScalar()&&this._node.children().forEach(function(x){"value"===x.key()&&(actualValue=x.value(isString),isAnnotatedScalar=!0)}),!isAnnotatedScalar)return this._sval?this._sval:(this._sval=new StructuredValue(actualValue,this.parent(),this._prop),this._sval)}if("string"==typeof actualValue&&textutil.isMultiLineValue(actualValue)){var res=this.convertMultivalueToString(actualValue);return res}return null==actualValue&&this._node.children().length>0&&this.property()&&universeHelpers.isTypeProperty(this.property())&&this.parent()&&universeHelpers.isTypeDeclarationSibling(this.parent().definition())?new StructuredValue(this._node,this.parent(),this._prop):actualValue},ASTPropImpl.prototype.name=function(){return this._prop.nameId()},ASTPropImpl.prototype.printDetails=function(indent){var className=this.definition().nameId(),definitionClassName=this.property().range().nameId(),result=(indent?indent:"")+(this.name()+" : "+className+"["+definitionClassName+"]  =  "+this.value())+(this.property().isKey()&&this.optional()?"?":"")+"\n";if(this.value()instanceof StructuredValue){var structuredHighLevel=this.value().toHighLevel();structuredHighLevel&&structuredHighLevel.printDetails&&(result+=structuredHighLevel.printDetails(indent+"\t"))}return result},ASTPropImpl.prototype.testSerialize=function(indent){var className=this.definition().nameId(),result=(indent?indent:"")+(this.name()+" : "+className+"  =  "+this.value())+"\n";if(this.value()instanceof StructuredValue){var structuredHighLevel=this.value().toHighLevel();if(structuredHighLevel&&structuredHighLevel.testSerialize)result+=structuredHighLevel.testSerialize((indent?indent:"")+"  ");else{var lowLevel=this.value().lowLevel(),dumpObject=lowLevel.dumpToObject(),dump=JSON.stringify(dumpObject),indentedDump="",dumpLines=dump.split("\n");dumpLines.forEach(function(dumpLine){return indentedDump+=(indent?indent:"")+"  "+dumpLine+"\n"}),result+=indentedDump+"\n"}}return result},ASTPropImpl.prototype.isAttr=function(){return!0},ASTPropImpl.prototype.isUnknown=function(){return!1},ASTPropImpl.prototype.setValue=function(value){mutators.setValue(this,value),this._value=null},ASTPropImpl.prototype.setKey=function(value){mutators.setKey(this,value),this._value=null},ASTPropImpl.prototype.children=function(){return[]},ASTPropImpl.prototype.addStringValue=function(value){mutators.addStringValue(this,value),this._value=null},ASTPropImpl.prototype.addStructuredValue=function(sv){mutators.addStructuredValue(this,sv),this._value=null},ASTPropImpl.prototype.addValue=function(value){if(!this.property().isMultiValue())throw new Error("setValue(string) only apply to multi-values properties");"string"==typeof value?this.addStringValue(value):this.addStructuredValue(value),this._value=null},ASTPropImpl.prototype.isEmbedded=function(){var keyname=this.lowLevel().asMapping().key.value;return this.property().canBeValue()&&keyname!=this.property().nameId()},ASTPropImpl.prototype.remove=function(){mutators.removeAttr(this)},ASTPropImpl.prototype.setValues=function(values){mutators.setValues(this,values),this._value=null},ASTPropImpl.prototype.isEmpty=function(){if(!this.property().isMultiValue())throw new Error("isEmpty() only apply to multi-values attributes");var node=this.parent(),attrs=(node.lowLevel(),node.attributes(this.name()));if(0==attrs.length)return!0;if(1==attrs.length){var anode=attrs[0].lowLevel();return!(!anode.isMapping()||null!=anode.value())}return!1},ASTPropImpl.prototype.isFromKey=function(){return this.fromKey},ASTPropImpl}(BasicASTNode);exports.ASTPropImpl=ASTPropImpl;var nodeBuilder=new builder.BasicNodeBuilder;!function(OverlayMergeMode){OverlayMergeMode[OverlayMergeMode.MERGE=0]="MERGE",OverlayMergeMode[OverlayMergeMode.AGGREGATE=1]="AGGREGATE"}(exports.OverlayMergeMode||(exports.OverlayMergeMode={}));var OverlayMergeMode=exports.OverlayMergeMode,LowLevelWrapperForTypeSystem=function(_super){function LowLevelWrapperForTypeSystem(_node,_highLevelRoot){_super.call(this),this._node=_node,this._highLevelRoot=_highLevelRoot;var v=_highLevelRoot.root(),mst=v.getMaster();if(mst&&this._node===_highLevelRoot.lowLevel()){var master=_highLevelRoot.getMasterCounterPart();master&&(this._toMerge=new LowLevelWrapperForTypeSystem(master.lowLevel(),master))}}return __extends(LowLevelWrapperForTypeSystem,_super),LowLevelWrapperForTypeSystem.prototype.contentProvider=function(){var root=this._node&&this._node.includeBaseUnit()&&(this._node.includePath&&this._node.includePath()?this._node.includeBaseUnit().resolve(this._node.includePath()):this._node.includeBaseUnit());return new contentprovider.ContentProvider(root)},LowLevelWrapperForTypeSystem.prototype.key=function(){var vl=this._node.key();return this._node.optional()&&(vl+="?"),vl},LowLevelWrapperForTypeSystem.prototype.value=function(){var vk=this._node.valueKind();if(vk===yaml.Kind.SEQ)return this.children().map(function(x){return x.value()});if(vk===yaml.Kind.MAP||vk===yaml.Kind.ANCHOR_REF){var vl=this._node.dumpToObject(!1);return vl[this.key()]}if(this._node.kind()==yaml.Kind.MAP){var vl=this._node.dumpToObject(!1);return vl}if(vk===yaml.Kind.INCLUDE_REF){var resolved=null,includePath=this._node.includePath();try{resolved=this._node.unit().resolve(includePath)}catch(e){}if(null!=resolved&&resolved.isRAMLUnit()){var includedAST=resolved.ast(),includedWrapper=new LowLevelWrapperForTypeSystem(includedAST,resolved.highLevel().asElement());return includedAST.kind()==yaml.Kind.SEQ?includedWrapper.children().map(function(x){return x.value()}):includedWrapper.value()}}var val=this._node.value();return val},LowLevelWrapperForTypeSystem.prototype.children=function(){var _this=this;if(this._children)return this._children;"uses"!=this.key()||this._node.parent().parent()?this._children=this._node.children().map(function(x){return new LowLevelWrapperForTypeSystem(x,_this._highLevelRoot)}):this._children=this._node.children().map(function(x){return new UsesNodeWrapperFoTypeSystem(x,_this._highLevelRoot)}),this.childByKey={};for(var i=0;i<this._children.length;i++){var c=this._children[i];this.childByKey[c.key()]=c}if(this._toMerge)for(var mrg=this._toMerge.children(),i=0;i<mrg.length;i++){var c=mrg[i],existing=this.childByKey[c.key()];existing?existing._toMerge=c:(this._children.push(c),this.childByKey[c.key()]=c)}return this._children},LowLevelWrapperForTypeSystem.prototype.childWithKey=function(k){return this._children||this.children(),this.childByKey[k]},LowLevelWrapperForTypeSystem.prototype.kind=function(){var vk=this._node.valueKind();if(vk==yaml.Kind.MAPPING||null===vk)return rTypes.NodeKind.MAP;if(vk==yaml.Kind.MAP)return rTypes.NodeKind.MAP;var knd=this._node.kind();return knd==yaml.Kind.MAP?rTypes.NodeKind.MAP:vk==yaml.Kind.SEQ?rTypes.NodeKind.ARRAY:vk==yaml.Kind.INCLUDE_REF&&this._node.children().length>0?rTypes.NodeKind.MAP:rTypes.NodeKind.SCALAR},LowLevelWrapperForTypeSystem.prototype.getSource=function(){if(!this._node)return null;var highLevelNode=this._node.highLevelNode();if(!highLevelNode){var position=this._node.start(),result=search.deepFindNode(this._highLevelRoot,position,position,!0,!1);return result&&(this._node.setHighLevelParseResult(result),result instanceof ASTNodeImpl&&this._node.setHighLevelNode(result)),result}return highLevelNode},LowLevelWrapperForTypeSystem.prototype.node=function(){return this._node},LowLevelWrapperForTypeSystem}(defs.SourceProvider);exports.LowLevelWrapperForTypeSystem=LowLevelWrapperForTypeSystem;var UsesNodeWrapperFoTypeSystem=function(_super){function UsesNodeWrapperFoTypeSystem(){_super.apply(this,arguments)}return __extends(UsesNodeWrapperFoTypeSystem,_super),UsesNodeWrapperFoTypeSystem.prototype.children=function(){var s=this._node.unit().resolve(this.value());return s&&s.isRAMLUnit()?new LowLevelWrapperForTypeSystem(s.ast(),this._highLevelRoot).children():[]},UsesNodeWrapperFoTypeSystem.prototype.anchor=function(){return this._node.actual()},UsesNodeWrapperFoTypeSystem.prototype.childWithKey=function(k){for(var mm=this.children(),i=0;i<mm.length;i++)if(mm[i].key()==k)return mm[i];return null},UsesNodeWrapperFoTypeSystem}(LowLevelWrapperForTypeSystem);exports.UsesNodeWrapperFoTypeSystem=UsesNodeWrapperFoTypeSystem;var ASTNodeImpl=function(_super){function ASTNodeImpl(node,parent,_def,_prop){_super.call(this,node,parent),this._def=_def,this._prop=_prop,this._expanded=!1,this._allowQuestion=!1,this._subTypesCache=null,this._auxChecked=!1,this.overlayMergeMode=OverlayMergeMode.MERGE,node&&node.setHighLevelNode(this),node instanceof proxy.LowLevelProxyNode&&(this._expanded=!0)}return __extends(ASTNodeImpl,_super),ASTNodeImpl.prototype.createIssue=function(error){return linter.toIssue(error,this)},ASTNodeImpl.prototype.validate=function(v){var k=this.definition().key();if((k==universes.Universe10.Api||k==universes.Universe08.Api||k==universes.Universe10.Extension)&&!this.isExpanded()){var nm=expander.expandTraitsAndResourceTypes(this.wrapperNode()),hlnode=nm.highLevel();return hlnode.resetChildren(),hlnode.children(),hlnode._expanded=!0,hlnode.clearTypesCache(),void hlnode.validate(v)}k!=universes.Universe10.Overlay&&k!=universes.Universe10.Extension||this.clearTypesCache(),linter.validate(this,v)},ASTNodeImpl.prototype.clearTypesCache=function(){this._types=null;var c=this.lowLevel().actual();c.types=null},ASTNodeImpl.prototype.types=function(){var _this=this;if(!this._types){if(this.parent()&&this.definition().key()!==universes.Universe10.Library)return this.parent().types();var c=this.lowLevel().actual();if(c.types)return c.types;this._types=rTypes.parseFromAST(new LowLevelWrapperForTypeSystem(this.lowLevel(),this)),this._types.types().forEach(function(x){var convertedType=typeBuilder.convertType(_this,x);convertedType.putExtra(defs.USER_DEFINED_EXTRA,!0)}),c.types=this._types}return this._types},ASTNodeImpl.prototype.setTypes=function(t){this._types=t},ASTNodeImpl.prototype.parsedType=function(){if(!this._ptype){if(this.property()&&this.property().nameId()==universes.Universe10.MethodBase.properties.body.name){var isParametrizedType=this.isParametrizedType();this._ptype=rTypes.parseTypeFromAST(this.name(),new LowLevelWrapperForTypeSystem(this.lowLevel(),this),this.types(),!0,!1,!1,isParametrizedType)}else{var annotation=this.property()&&this.property().nameId()==universes.Universe10.LibraryBase.properties.annotationTypes.name,tl=!this.property()||this.property().nameId()==universes.Universe10.LibraryBase.properties.types.name||this.property().nameId()==universes.Universe10.LibraryBase.properties.schemas.name;if(!annotation&&null==this.parent()){var localUniverse=this.universe();localUniverse&&localUniverse.getOriginalTopLevelText()&&"AnnotationTypeDeclaration"==localUniverse.getOriginalTopLevelText()&&(annotation=!0)}this._ptype=rTypes.parseTypeFromAST(this.name(),new LowLevelWrapperForTypeSystem(this.lowLevel(),this),this.types(),!1,annotation,tl)}this.property()&&universeHelpers.isTypesProperty(this.property())&&this.parent()&&universeHelpers.isApiType(this.parent().definition())&&this._ptype.putExtra&&this._ptype.putExtra(defs.DEFINED_IN_TYPES_EXTRA,!0);var potentialHasExtra=this._ptype;potentialHasExtra.putExtra(defs.USER_DEFINED_EXTRA,!0),this._ptype.putExtra(defs.SOURCE_EXTRA,this)}return this._ptype},ASTNodeImpl.prototype.isParametrizedType=function(){var isParametrizedType=!1,typeAttr=this.attr(universes.Universe10.TypeDeclaration.properties.type.name);if(typeAttr){var typeAttrValue=typeAttr.value();if("string"==typeof typeAttrValue&&typeAttrValue.indexOf("<<")>=0)for(var parent=this.parent();null!=parent;){if(universeHelpers.isResourceTypeType(parent.definition())||universeHelpers.isTraitType(parent.definition())){isParametrizedType=!0;break}parent=parent.parent()}}return isParametrizedType},ASTNodeImpl.prototype.localType=function(){return typeBuilder.typeFromNode(this)},ASTNodeImpl.prototype.patchProp=function(pr){this._prop=pr},ASTNodeImpl.prototype.getKind=function(){return hl.NodeKind.NODE},ASTNodeImpl.prototype.wrapperNode=function(){if(!this._wrapperNode){if(universeHelpers.isExampleSpecType(this.definition())){var typeYamlNode=yaml.newMap([yaml.newMapping(yaml.newScalar("example"),this.lowLevel().actual())]),typesNode=yaml.newMapping(yaml.newScalar("types"),yaml.newMap([yaml.newMapping(yaml.newScalar("__AUX_TYPE__"),typeYamlNode)])),yamlNode=yaml.newMap([typesNode]),llNode=new jsyaml.ASTNode(yamlNode,this.lowLevel().unit(),null,null,null),types=rTypes.parseFromAST(new LowLevelWrapperForTypeSystem(llNode,this)),nominal=rTypes.toNominal(types.types()[0],function(x){return null}),spec=wrapperHelper.examplesFromNominal(nominal,this,!0,!1);return spec[0]}this.children(),this._wrapperNode=this.buildWrapperNode()}return this._wrapperNode},ASTNodeImpl.prototype.asElement=function(){return this},ASTNodeImpl.prototype.buildWrapperNode=function(){var ramlVersion=this.definition().universe().version();return"RAML10"==ramlVersion?factory10.buildWrapperNode(this):"RAML08"==ramlVersion?factory08.buildWrapperNode(this):null},ASTNodeImpl.prototype.propertiesAllowedToUse=function(){var _this=this;return this.definition().allProperties().filter(function(x){return _this.isAllowedToUse(x)})},ASTNodeImpl.prototype.isAllowedToUse=function(p){var _this=this,ok=!0;return!p.getAdapter(services.RAMLPropertyService).isSystem()&&(p.getContextRequirements().forEach(function(y){if(y.name.indexOf("(")!=-1)return!0;var vl=_this.computedValue(y.name);vl?ok=ok&&vl==y.value:y.value&&(ok=!1)}),ok)},ASTNodeImpl.prototype.allowRecursive=function(){return!!this.definition().getAdapter(services.RAMLService).isUserDefined()},ASTNodeImpl.prototype.setWrapperNode=function(node){this._wrapperNode=node},ASTNodeImpl.prototype.setAssociatedType=function(d){this._associatedDef=d},ASTNodeImpl.prototype.associatedType=function(){return this._associatedDef},ASTNodeImpl.prototype.knownIds=function(){return this.isAuxilary(),this._knownIds?this._knownIds:{}},ASTNodeImpl.prototype.findById=function(id){var _this=this,currentRoot=this.root();if(currentRoot!=this)return currentRoot.findById(id);if(!this._knownIds){this._knownIds={};var all=search.allChildren(this);all.forEach(function(x){return _this._knownIds[x.id()]=x})}if(this.isAuxilary()){if(!this._slaveIds){this._slaveIds={};var all=search.allChildren(this);all.forEach(function(x){return _this._slaveIds[x.id()]=x})}var nodeIndexedInSlave=this._slaveIds[id];if(nodeIndexedInSlave)return nodeIndexedInSlave}return this._knownIds[id]},ASTNodeImpl.prototype.isAuxilary=function(){if(this._isAux)return!0;if(this._auxChecked)return!1;this._auxChecked=!0;var masterApi=this.getMaster();return!!masterApi&&(this._isAux=!0,this.initilizeKnownIDs(masterApi),!0)},ASTNodeImpl.prototype.initilizeKnownIDs=function(api){var _this=this;this._knownIds={};var allChildren=search.allChildren(api);allChildren.forEach(function(x){return _this._knownIds[x.id()]=x}),this._knownIds[""]=api},ASTNodeImpl.prototype.getMaster=function(){return this.masterApi?this.masterApi:this.calculateMasterByRef()},ASTNodeImpl.prototype.overrideMaster=function(master){this.masterApi=master,this.resetAuxilaryState()},ASTNodeImpl.prototype.setMergeMode=function(mergeMode){this.overlayMergeMode=mergeMode,this.resetAuxilaryState()},ASTNodeImpl.prototype.getMergeMode=function(){return this.overlayMergeMode},ASTNodeImpl.prototype.calculateMasterByRef=function(){var unit=this.lowLevel().unit();if(!unit)return null;var masterReferenceNode=unit.getMasterReferenceNode();if(!masterReferenceNode||!masterReferenceNode.value())return null;var lc=this.lowLevel();if(lc.master)return lc.master;var masterPath=masterReferenceNode.value(),masterUnit=this.lowLevel().unit().project().resolve(this.lowLevel().unit().path(),masterPath);if(!masterUnit)return null;var result=masterUnit.expandedHighLevel();return result.setMergeMode(this.overlayMergeMode),lc.master=result,result},ASTNodeImpl.prototype.resetAuxilaryState=function(){this._isAux=!1,this._auxChecked=!1,this._knownIds=null,this.clearChildrenCache()},ASTNodeImpl.prototype.printDetails=function(indent){var result="";indent||(indent="");var classname=this.definition().nameId(),definitionClasName=this.property()?this.property().range().nameId():"",parentPropertyName=this.property()?this.property().nameId():"";return result+=indent+classname+"["+definitionClasName+"] <--- "+parentPropertyName+"\n",this.children().forEach(function(child){result+=child.printDetails(indent+"\t")}),result},ASTNodeImpl.prototype.testSerialize=function(indent){var result="";indent||(indent="");var classname=this.definition().nameId(),parentPropertyName=this.property()?this.property().nameId():"";return result+=indent+classname+" <-- "+parentPropertyName+"\n",this.children().forEach(function(child){child.testSerialize&&(result+=child.testSerialize(indent+"  "))}),result},ASTNodeImpl.prototype.getExtractedChildren=function(){var r=this.root();if(r.isAuxilary()){if(r._knownIds){var i=r._knownIds[this.id()];if(i){var v=i.children();return v}}return[]}return[]},ASTNodeImpl.prototype.getMasterCounterPart=function(){var r=this.root();if(r.isAuxilary()){if(r._knownIds){var i=r._knownIds[this.id()];return i}return null}return null},ASTNodeImpl.prototype.getExtractedLowLevelChildren=function(n){var r=this.root();if(r.isAuxilary()){if(r._knownLowLevelIds){var i=r._knownLowLevelIds[this.id()];if(i)return i.children()}return[]}return[]},ASTNodeImpl.prototype.allowsQuestion=function(){return this._allowQuestion||this.definition().getAdapter(services.RAMLService).getAllowQuestion()},ASTNodeImpl.prototype.findReferences=function(){var _this=this,rs=[];search.refFinder(this.root(),this,rs),rs.length>1&&(rs=rs.filter(function(x){return x!=_this&&x.parent()!=_this}));var filteredReferences=[];return rs.forEach(function(ref){_.find(filteredReferences,function(existing){return existing==ref})||filteredReferences.push(ref)}),filteredReferences},ASTNodeImpl.prototype.setNamePatch=function(s){this._patchedName=s},ASTNodeImpl.prototype.isNamePatch=function(){return this._patchedName},ASTNodeImpl.prototype.name=function(){if(this._patchedName)return this._patchedName;var ka=_.find(this.directChildren(),function(x){return x.property()&&x.property().getAdapter(services.RAMLPropertyService).isKey()});if(ka&&ka instanceof ASTPropImpl){var c=null,defClass=this.definition(),ramlVersion=defClass.universe().version();if(defClass&&"RAML10"==ramlVersion&&ka.isFromKey()){var key=this._node.key();c=this._node.optional()?key+"?":key}else c=ka.value();return c}return _super.prototype.name.call(this)},ASTNodeImpl.prototype.findElementAtOffset=function(n){return this._findNode(this,n,n)},ASTNodeImpl.prototype.isElement=function(){return!0},ASTNodeImpl.prototype.universe=function(){return this._universe?this._universe:this.definition().universe()},ASTNodeImpl.prototype.setUniverse=function(u){this._universe=u},ASTNodeImpl.prototype._findNode=function(n,offset,end){var _this=this;if(null==n)return null;if(n.lowLevel()&&n.lowLevel().start()<=offset&&n.lowLevel().end()>=end){var res=n;return n.elements().forEach(function(x){if(x.lowLevel().unit()==n.lowLevel().unit()){var m=_this._findNode(x,offset,end);m&&(res=m)}}),res}return null},ASTNodeImpl.prototype.isStub=function(){return!this.lowLevel().unit()||this.lowLevel().unit().isStubUnit()},ASTNodeImpl.prototype.add=function(node){mutators.addToNode(this,node)},ASTNodeImpl.prototype.remove=function(node){mutators.removeNodeFrom(this,node)},ASTNodeImpl.prototype.dump=function(flavor){return this._node.dump()},ASTNodeImpl.prototype.patchType=function(d){this._def=d;this._associatedDef;this._associatedDef=null,this._children=null,this._mergedChildren=null},ASTNodeImpl.prototype.children=function(){var lowLevel=this.lowLevel();return lowLevel&&lowLevel.isValueInclude&&lowLevel.isValueInclude()&&resourceRegistry.isWaitingFor(lowLevel.includePath())?(this._children=null,[]):this._children?this._mergedChildren?this._mergedChildren:(this._mergedChildren=this.mergeChildren(this._children,this.getExtractedChildren()),this._mergedChildren):this._node?(this._children=nodeBuilder.process(this,this._node.children()),this._children=this._children.filter(function(x){return null!=x}),this.mergeChildren(this._children,this.getExtractedChildren())):[]},ASTNodeImpl.prototype.mergeChildren=function(originalChildren,masterChildren){var _this=this,root=this.root();if(root.overlayMergeMode==OverlayMergeMode.AGGREGATE)return originalChildren.concat(masterChildren);if(root.overlayMergeMode==OverlayMergeMode.MERGE){var result=[];return originalChildren.forEach(function(originalChild){var masterCounterpart=_.find(masterChildren,function(masterChild){return masterChild.fullLocalId()==originalChild.fullLocalId()});masterCounterpart?_this.mergeChild(result,originalChild,masterCounterpart):result.push(originalChild)}),masterChildren.forEach(function(masterChild){var originalCounterpart=_.find(originalChildren,function(originalChild){return masterChild.fullLocalId()==originalChild.fullLocalId()});originalCounterpart||result.push(masterChild)}),result}return null},ASTNodeImpl.prototype.mergeLowLevelChildren=function(originalChildren,masterChildren){var _this=this,root=this.root();if(root.overlayMergeMode==OverlayMergeMode.AGGREGATE)return originalChildren.concat(masterChildren);if(root.overlayMergeMode==OverlayMergeMode.MERGE){var result=[];return originalChildren.forEach(function(originalChild){var masterCounterpart=_.find(masterChildren,function(masterChild){return masterChild.key()==originalChild.key()});masterCounterpart?_this.mergeLowLevelChild(result,originalChild,masterCounterpart):result.push(originalChild)}),masterChildren.forEach(function(masterChild){var originalCounterpart=_.find(originalChildren,function(originalChild){return masterChild.key()==originalChild.key()});originalCounterpart||result.push(masterChild)}),result}return null},ASTNodeImpl.prototype.mergeLowLevelChild=function(result,originalChild,masterChild){return originalChild.kind()!=masterChild.kind()?(result.push(originalChild),void result.push(masterChild)):void result.push(originalChild)},ASTNodeImpl.prototype.mergeChild=function(result,originalChild,masterChild){return originalChild.getKind()!=masterChild.getKind()?(result.push(originalChild),void result.push(masterChild)):originalChild.getKind()==hl.NodeKind.NODE?void result.push(originalChild):originalChild.getKind()==hl.NodeKind.ATTRIBUTE?void result.push(originalChild):originalChild.getKind()==hl.NodeKind.BASIC?(result.push(originalChild),void result.push(masterChild)):void 0},ASTNodeImpl.prototype.directChildren=function(){return this._children?this._children:this._node?(this._children=nodeBuilder.process(this,this._node.children()),this._children):[]},ASTNodeImpl.prototype.resetChildren=function(){this._children=null,this._mergedChildren=null},ASTNodeImpl.prototype.isEmptyRamlFile=function(){var llroot=this.lowLevel().root();return llroot.isScalar()},ASTNodeImpl.prototype.initRamlFile=function(){mutators.initEmptyRAMLFile(this)},ASTNodeImpl.prototype.createAttr=function(n,v){mutators.createAttr(this,n,v)},ASTNodeImpl.prototype.isAttr=function(){return!1},ASTNodeImpl.prototype.isUnknown=function(){return!1},ASTNodeImpl.prototype.value=function(){return this._node.value()},ASTNodeImpl.prototype.valuesOf=function(propName){var pr=this._def.property(propName);return null!=pr?this.elements().filter(function(x){return x.property()==pr}):[]},ASTNodeImpl.prototype.attr=function(n){return _.find(this.attrs(),function(y){return y.name()==n})},ASTNodeImpl.prototype.attrOrCreate=function(name){var a=this.attr(name);return a||this.createAttr(name,""),this.attr(name)},ASTNodeImpl.prototype.attrValue=function(n){var a=this.attr(n);return a?a.value():null},ASTNodeImpl.prototype.attributes=function(n){return _.filter(this.attrs(),function(y){return y.name()==n})},ASTNodeImpl.prototype.attrs=function(){var rs=this.children().filter(function(x){return x.isAttr()});if(this._patchedName){var kp=_.find(this.definition().allProperties(),function(x){return x.getAdapter(services.RAMLPropertyService).isKey()});if(kp){var mm=new ASTPropImpl(this.lowLevel(),this,kp.range(),kp,(!0));return mm._value=this._patchedName,[mm].concat(rs)}}return rs},ASTNodeImpl.prototype.elements=function(){return this.children().filter(function(x){return!x.isAttr()&&!x.isUnknown()})},ASTNodeImpl.prototype.element=function(n){var r=this.elementsOfKind(n);return r.length>0?r[0]:null},ASTNodeImpl.prototype.elementsOfKind=function(n){var r=this.elements().filter(function(x){return x.property().nameId()==n});return r},ASTNodeImpl.prototype.definition=function(){return this._def},ASTNodeImpl.prototype.property=function(){return this._prop},ASTNodeImpl.prototype.isExpanded=function(){return this._expanded},ASTNodeImpl.prototype.copy=function(){return new ASTNodeImpl(this.lowLevel().copy(),this.parent(),this.definition(),this.property())},ASTNodeImpl.prototype.clearChildrenCache=function(){this._children=null,this._mergedChildren=null},ASTNodeImpl.prototype.optionalProperties=function(){var def=this.definition();if(null==def)return[];var result=[],map={},children=this.lowLevel().children();children.forEach(function(x){x.optional()&&(map[x.key()]=!0)});var props=def.allProperties();return props.forEach(function(x){var prop=x;map[prop.nameId()]&&result.push(prop.nameId())}),result},ASTNodeImpl}(BasicASTNode);exports.ASTNodeImpl=ASTNodeImpl,exports.universeProvider=__webpack_require__(34);var getDefinitionSystemType=function(contents,ast){var rfl=ramlFirstLine(contents),spec=rfl&&rfl[1]||"",ptype=rfl&&rfl.length>2&&rfl[2]||"Api",originalPType=rfl&&rfl.length>2&&rfl[2],localUniverse="1.0"==spec?new def.Universe(null,"RAML10",exports.universeProvider("RAML10"),"RAML10"):new def.Universe(null,"RAML08",exports.universeProvider("RAML08"));return"API"==ptype?ptype="Api":"NamedExample"==ptype?ptype="ExampleSpec":"DataType"==ptype?ptype="TypeDeclaration":"SecurityScheme"==ptype?ptype="AbstractSecurityScheme":"AnnotationTypeDeclaration"==ptype&&(ptype="TypeDeclaration"),localUniverse.setOriginalTopLevelText(originalPType),localUniverse.setTopLevel(ptype),localUniverse.setTypedVersion(spec),{ptype:ptype,localUniverse:localUniverse}};exports.ramlFirstLine=ramlFirstLine,exports.getFragmentDefenitionName=getFragmentDefenitionName,exports.fromUnit=fromUnit,exports.createBasicValidationAcceptor=createBasicValidationAcceptor},function(module,exports,__webpack_require__){"use strict";function createStub0(parent,property,key){var p=parent.definition().property(property);if(!p)return null;var nc=p.range(),node=createStubNode(nc,p,key);return node}function genStructuredValue(type,name,mappings,parent){var map=yaml.newMap(mappings.map(function(mapping){return yaml.newMapping(yaml.newScalar(mapping.key),yaml.newScalar(mapping.value))})),node=new jsyaml.ASTNode(map,parent?parent.lowLevel().unit():null,parent?parent.lowLevel():null,null,null);return new hlimpl.StructuredValue(node,parent,parent?parent.definition().property(type):null,name)}function createStub(parent,property,key){var p=parent.definition().property(property);if(!p)return null;var nc=p.range(),su=parent.lowLevel().unit().stub(),node=createStubNode(nc,p,key,su);return node.isInEdit=!0,node.lowLevel()._unit=su,node._parent=parent.copy(),node._parent.lowLevel()._unit=su,node}function createResourceStub(parent,key){return createStub(parent,"resources",key)}function createMethodStub(parent,key){return createStub(parent,"methods",key)}function createResponseStub(parent,key){return createStub(parent,"responses",key)}function createBodyStub(parent,key){return createStub(parent,"body",key)}function createUriParameterStub(parent,key){return createStub(parent,"uriParameters",key)}function createQueryParameterStub(parent,key){return createStub(parent,"queryParameters",key)}function createAttr(_property,val){var lowLevel=jsyaml.createMapping(_property.nameId(),val),nm=new hlimpl.ASTPropImpl(lowLevel,null,_property.range(),_property);return nm}function createStubNode(t,p,key,unit){void 0===key&&(key=null);var lowLevel=jsyaml.createNode(key?key:"key"),nm=new hlimpl.ASTNodeImpl(lowLevel,null,t,p);return lowLevel.unit()||(lowLevel._unit=unit),nm.children(),nm}var jsyaml=__webpack_require__(27),hlimpl=__webpack_require__(16),yaml=__webpack_require__(70);exports.createStub0=createStub0,exports.genStructuredValue=genStructuredValue,exports.createStub=createStub,exports.createResourceStub=createResourceStub,exports.createMethodStub=createMethodStub,exports.createResponseStub=createResponseStub,exports.createBodyStub=createBodyStub,exports.createUriParameterStub=createUriParameterStub,exports.createQueryParameterStub=createQueryParameterStub,exports.createAttr=createAttr,exports.createStubNode=createStubNode},function(module,exports,__webpack_require__){"use strict";var _=__webpack_require__(61),textutil=__webpack_require__(41),wrapper=__webpack_require__(20),SchemaToModelGenerator=function(){function SchemaToModelGenerator(){}return SchemaToModelGenerator.prototype.generateText=function(schema){var _this=this,obj=JSON.parse(schema),items=obj.items;if(!items)return"";var text="",itemsArray=items instanceof Array?items:[items];return text+="types:\n",itemsArray.forEach(function(e){text+="  - "+e.title+":\n",text+=_this.generateObj(e,3)}),text},SchemaToModelGenerator.prototype.generateObj=function(e,lev){var text="";if(text+=textutil.indent(lev,"type: "+e.type)+"\n",e.properties){text+=textutil.indent(lev,"properties:\n");for(var name in e.properties){var p=e.properties[name];text+=textutil.indent(lev+1,name+":\n"),text+="object"==p.type?this.generateObj(p,lev+2):textutil.indent(lev+2,"type: "+p.type)+"\n"}return text}},SchemaToModelGenerator.prototype.generateTo=function(api,schema,title){var _this=this,obj=JSON.parse(schema),items=obj.items;if(items){var itemsArray=items instanceof Array?items:[items],types=[];return itemsArray.forEach(function(e){var type=new wrapper.ObjectTypeDeclarationImpl(e.title);_this.generateObjTo(type,e),new wrapper.BasicSecuritySchemeImpl(api).addToProp(type,"types"),types.push(e.title)}),types}obj.title&&(title=obj.title);var type=new wrapper.ObjectTypeDeclarationImpl(title);return this.generateObjTo(type,obj),new wrapper.BasicSecuritySchemeImpl(api).addToProp(type,"types"),[title]},SchemaToModelGenerator.prototype.generateObjTo=function(type,e){if(type.setType(e.type),e.properties)for(var name in e.properties){var p=e.properties[name],field=this.makeTypeField(name,p);"array"==p.type,type.addToProp(field,"properties")}},SchemaToModelGenerator.prototype.makeTypeField=function(name,p){var field=this.makeType(name,p.type);if(p.type&&field.setType(p.type),"number"==p.type){var n=field;void 0!=p.minimum&&n.setMinimum(p.minimum),void 0!=p.maximum&&n.setMaximum(p.maximum)}if("array"==p.type){var itype=p.items.type;field.setType(itype+"[]");var a=field;void 0!=p.minItems&&a.setMinItems(p.minItems),void 0!=p.maxItems&&a.setMaxItems(p.maxItems),
void 0!=p.uniqueItems&&a.setUniqueItems(p.uniqueItems)}return"object"==p.type&&this.generateObjTo(field,p),field},SchemaToModelGenerator.prototype.makeType=function(name,type){return"number"==type?new wrapper.NumberTypeDeclarationImpl(name):"string"==type?new wrapper.StringTypeDeclarationImpl(name):"array"==type?new wrapper.ArrayTypeDeclarationImpl(name):new wrapper.ObjectTypeDeclarationImpl(name)},SchemaToModelGenerator.prototype.generateItemsTo=function(a,obj){var items=obj.items;if(items){var itemsArray=items instanceof Array?items:[items];itemsArray.forEach(function(item){})}},SchemaToModelGenerator}();exports.SchemaToModelGenerator=SchemaToModelGenerator;var ModelToSchemaGenerator=function(){function ModelToSchemaGenerator(){}return ModelToSchemaGenerator.prototype.generateSchema=function(node){var obj=this.generateType(node);return obj.$schema="http://json-schema.org/draft-04/schema#",obj},ModelToSchemaGenerator.prototype.isSimpleType=function(name){return"string"==name||"number"==name||"boolean"==name||"object"==name},ModelToSchemaGenerator.prototype.generateType=function(type){var typelist=this.allTypes(type),obj={};obj.title=type.attrValue("name");if(type.attrValue("type")){var types=type.attributes("type"),inherited=!1,simple=!1;for(var i in types){var typevalue=types[i].value(),ll=types[i].lowLevel();if(obj.type="",ll.isValueInclude()){var schema=JSON.parse(typevalue);obj.type="object",obj.properties=schema.properties}else if(this.isSimpleType(typevalue)){if(obj.type=typevalue,simple=!0,inherited)throw new Error("couldn't mix user defined and basic types in inheritance")}else{var t=this.resolveType(type,typevalue);if(t){var ppp=this.generateTypeExp(typevalue,typelist);if(obj.properties?_.extend(obj.properties,ppp.properties):obj.properties=ppp.properties,obj.type="object",inherited=!0,simple)throw new Error("couldn't mix user defined and basic types in inheritance")}else{var ppp=this.generateTypeExp(typevalue,typelist);obj.type="object",inherited=!0,ppp.anyOf&&(obj.anyOf=ppp.anyOf)}}}}else obj.type="object";var ownProps=this.generateProperties(type);return obj.properties?_.extend(obj.properties,ownProps):obj.properties=ownProps,obj},ModelToSchemaGenerator.prototype.makeUnion=function(typelist,types){var _this=this,anyof=[];return typelist.forEach(function(t){t=t.trim(),types[t]?anyof.push({type:"object",properties:_this.generateType(types[t]).properties}):anyof.push({type:t})}),anyof},ModelToSchemaGenerator.prototype.generateTypeExp=function(type,types){var obj={};if(textutil.endsWith(type,"[]"))obj.type="array",obj.items={type:type.substring(0,type.length-2)};else if(type.indexOf("|")>0){var typelist=type.split("|");obj.anyOf=this.makeUnion(typelist,types)}else if(types[type]){var schema=this.generateType(types[type]);obj.type="object",obj.properties=schema.properties}else obj.type=type;return obj},ModelToSchemaGenerator.prototype.allTypes=function(node){var api=node.root(),modelTypes=api.elementsOfKind("types"),types={};return modelTypes.forEach(function(type){types[type.name()]=type}),types},ModelToSchemaGenerator.prototype.resolveType=function(node,name){var types=this.allTypes(node);return types[name]},ModelToSchemaGenerator.prototype.generateProperty=function(node,optional){var _this=this,types=this.allTypes(node),obj={},props=node.definition().allProperties();props.forEach(function(p){if("name"!=p.nameId()){var value=node.attrValue(p.nameId());if(null!=value&&void 0!=value&&"undefined"!=value)if("type"==p.nameId()){var t=_this.generateTypeExp(value,types);_.extend(obj,t)}else if("enum"==p.nameId()){var values=node.attributes("enum"),arr=values.map(function(a){return a.value()});obj.enum=arr}else obj[p.nameId()]=value}}),optional&&(obj.required=!1);var properties=(node.elements(),this.generateProperties(node));return Object.getOwnPropertyNames(properties).length>0&&(obj.properties=properties),obj},ModelToSchemaGenerator.prototype.generateProperties=function(node){var _this=this,props={},elements=node.elements(),empty=!0;return elements.forEach(function(p){var name=p.attrValue("name");if("string"==typeof name){name=name.trim();var optional=p.optional();props[name]=_this.generateProperty(p,optional),empty=!1}}),props},ModelToSchemaGenerator}();exports.ModelToSchemaGenerator=ModelToSchemaGenerator},function(module,exports,__webpack_require__){"use strict";function createTypeDeclaration(typeName){return new parser10impl.TypeDeclarationImpl(typeName)}function createObjectTypeDeclaration(typeName){return new parser10impl.ObjectTypeDeclarationImpl(typeName)}function setTypeDeclarationSchema(type,schema){type.setSchema(schema)}function setTypeDeclarationExample(type,example){var examplePropName=(defSys.getUniverse("RAML10").type(defSys.universesInfo.Universe10.ExampleSpec.name),defSys.universesInfo.Universe10.TypeDeclaration.properties.example.name),hlParent=type.highLevel(),llParent=hlParent.lowLevel(),exampleNodes=hlParent.children().filter(function(x){return x.lowLevel().key()==examplePropName}),llNode=jsyaml.createNode(examplePropName);ll.setAttr(llNode,example),exampleNodes.length>0&&(ll.removeNode(llParent,exampleNodes[0].lowLevel()),exampleNodes[0]._node=llNode,ll.insertNode(llParent,llNode)),hlParent.createAttr&&hlParent.createAttr(examplePropName,example)}function addChild(parent,child){parent.add(child)}var parser10impl=__webpack_require__(20),defSys=__webpack_require__(36),jsyaml=__webpack_require__(27),ll=__webpack_require__(11);exports.createTypeDeclaration=createTypeDeclaration,exports.createObjectTypeDeclaration=createObjectTypeDeclaration,exports.setTypeDeclarationSchema=setTypeDeclarationSchema,exports.setTypeDeclarationExample=setTypeDeclarationExample,exports.addChild=addChild},function(module,exports,__webpack_require__){"use strict";function createApi(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Api"),node=stubs.createStubNode(nc,null,key);return node}function createLibraryBase(key){var universe=def.getUniverse("RAML10"),nc=universe.type("LibraryBase"),node=stubs.createStubNode(nc,null,key);return node}function createFragmentDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("FragmentDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createTrait(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Trait"),node=stubs.createStubNode(nc,null,key);return node}function createMethodBase(key){var universe=def.getUniverse("RAML10"),nc=universe.type("MethodBase"),node=stubs.createStubNode(nc,null,key);return node}function createOperation(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Operation"),node=stubs.createStubNode(nc,null,key);return node}function createTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("TypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createUsesDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("UsesDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createXMLFacetInfo(key){var universe=def.getUniverse("RAML10"),nc=universe.type("XMLFacetInfo"),node=stubs.createStubNode(nc,null,key);return node}function createArrayTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("ArrayTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createUnionTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("UnionTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createObjectTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("ObjectTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createStringTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("StringTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createBooleanTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("BooleanTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createNumberTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("NumberTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createIntegerTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("IntegerTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createDateOnlyTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DateOnlyTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createTimeOnlyTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("TimeOnlyTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createDateTimeOnlyTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DateTimeOnlyTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createDateTimeTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DateTimeTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createDateTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DateTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createFileTypeDeclaration(key){var universe=def.getUniverse("RAML10"),nc=universe.type("FileTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createResponse(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Response"),node=stubs.createStubNode(nc,null,key);return node}function createSecuritySchemePart(key){var universe=def.getUniverse("RAML10"),nc=universe.type("SecuritySchemePart"),node=stubs.createStubNode(nc,null,key);return node}function createAbstractSecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("AbstractSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createSecuritySchemeSettings(key){var universe=def.getUniverse("RAML10"),nc=universe.type("SecuritySchemeSettings"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth1SecuritySchemeSettings(key){var universe=def.getUniverse("RAML10"),nc=universe.type("OAuth1SecuritySchemeSettings"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth2SecuritySchemeSettings(key){var universe=def.getUniverse("RAML10"),nc=universe.type("OAuth2SecuritySchemeSettings"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth2SecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("OAuth2SecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth1SecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("OAuth1SecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createPassThroughSecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("PassThroughSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createBasicSecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("BasicSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createDigestSecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DigestSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createCustomSecurityScheme(key){var universe=def.getUniverse("RAML10"),nc=universe.type("CustomSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createMethod(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Method"),node=stubs.createStubNode(nc,null,key);return node}function createResourceType(key){var universe=def.getUniverse("RAML10"),nc=universe.type("ResourceType"),node=stubs.createStubNode(nc,null,key);return node}function createResourceBase(key){var universe=def.getUniverse("RAML10"),nc=universe.type("ResourceBase"),node=stubs.createStubNode(nc,null,key);return node}function createResource(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Resource"),node=stubs.createStubNode(nc,null,key);return node}function createDocumentationItem(key){var universe=def.getUniverse("RAML10"),nc=universe.type("DocumentationItem"),node=stubs.createStubNode(nc,null,key);return node}function createLibrary(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Library"),node=stubs.createStubNode(nc,null,key);return node}function createOverlay(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Overlay"),node=stubs.createStubNode(nc,null,key);return node}function createExtension(key){var universe=def.getUniverse("RAML10"),nc=universe.type("Extension"),node=stubs.createStubNode(nc,null,key);return node}function loadApiSync(apiPath,arg1,arg2){return apiLoader.loadApi(apiPath,arg1,arg2).getOrElse(null)}function loadRAMLSync(ramlPath,arg1,arg2){return apiLoader.loadApi(ramlPath,arg1,arg2).getOrElse(null)}function loadApi(apiPath,arg1,arg2){return apiLoader.loadApiAsync(apiPath,arg1,arg2)}function loadRAML(ramlPath,arg1,arg2){return apiLoader.loadRAMLAsync(ramlPath,arg1,arg2)}function getLanguageElementByRuntimeType(runtimeType){return apiLoader.getLanguageElementByRuntimeType(runtimeType)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},stubs=__webpack_require__(17),def=__webpack_require__(36),core=__webpack_require__(45),apiLoader=__webpack_require__(9),helper=__webpack_require__(32),AnnotableImpl=function(_super){function AnnotableImpl(){_super.apply(this,arguments)}return __extends(AnnotableImpl,_super),AnnotableImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},AnnotableImpl.prototype.wrapperClassName=function(){return"AnnotableImpl"},AnnotableImpl.prototype.kind=function(){return"Annotable"},AnnotableImpl.prototype.RAMLVersion=function(){return"RAML10"},AnnotableImpl.prototype.scalarsAnnotations=function(){return new AnnotableScalarsAnnotationsImpl(this.highLevel())},AnnotableImpl}(core.BasicNodeImpl);exports.AnnotableImpl=AnnotableImpl;var ValueTypeImpl=function(_super){function ValueTypeImpl(){_super.apply(this,arguments)}return __extends(ValueTypeImpl,_super),ValueTypeImpl.prototype.wrapperClassName=function(){return"ValueTypeImpl"},ValueTypeImpl.prototype.kind=function(){return"ValueType"},ValueTypeImpl.prototype.RAMLVersion=function(){return"undefined"},ValueTypeImpl.prototype.value=function(){return this.attr.value()},ValueTypeImpl}(core.AttributeNodeImpl);exports.ValueTypeImpl=ValueTypeImpl;var StringTypeImpl=function(_super){function StringTypeImpl(){_super.apply(this,arguments)}return __extends(StringTypeImpl,_super),StringTypeImpl.prototype.wrapperClassName=function(){return"StringTypeImpl"},StringTypeImpl.prototype.kind=function(){return"StringType"},StringTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},StringTypeImpl.prototype.value=function(){return this.attr.value()},StringTypeImpl}(ValueTypeImpl);exports.StringTypeImpl=StringTypeImpl;var UriTemplateImpl=function(_super){function UriTemplateImpl(){_super.apply(this,arguments)}return __extends(UriTemplateImpl,_super),UriTemplateImpl.prototype.wrapperClassName=function(){return"UriTemplateImpl"},UriTemplateImpl.prototype.kind=function(){return"UriTemplate"},UriTemplateImpl.prototype.RAMLVersion=function(){return"RAML10"},UriTemplateImpl}(StringTypeImpl);exports.UriTemplateImpl=UriTemplateImpl;var RelativeUriStringImpl=function(_super){function RelativeUriStringImpl(){_super.apply(this,arguments)}return __extends(RelativeUriStringImpl,_super),RelativeUriStringImpl.prototype.wrapperClassName=function(){return"RelativeUriStringImpl"},RelativeUriStringImpl.prototype.kind=function(){return"RelativeUriString"},RelativeUriStringImpl.prototype.RAMLVersion=function(){return"RAML10"},RelativeUriStringImpl}(UriTemplateImpl);exports.RelativeUriStringImpl=RelativeUriStringImpl;var FullUriTemplateStringImpl=function(_super){function FullUriTemplateStringImpl(){_super.apply(this,arguments)}return __extends(FullUriTemplateStringImpl,_super),FullUriTemplateStringImpl.prototype.wrapperClassName=function(){return"FullUriTemplateStringImpl"},FullUriTemplateStringImpl.prototype.kind=function(){return"FullUriTemplateString"},FullUriTemplateStringImpl.prototype.RAMLVersion=function(){return"RAML10"},FullUriTemplateStringImpl}(UriTemplateImpl);exports.FullUriTemplateStringImpl=FullUriTemplateStringImpl;var StatusCodeStringImpl=function(_super){function StatusCodeStringImpl(){_super.apply(this,arguments)}return __extends(StatusCodeStringImpl,_super),StatusCodeStringImpl.prototype.wrapperClassName=function(){return"StatusCodeStringImpl"},StatusCodeStringImpl.prototype.kind=function(){return"StatusCodeString"},StatusCodeStringImpl.prototype.RAMLVersion=function(){return"RAML10"},StatusCodeStringImpl}(StringTypeImpl);exports.StatusCodeStringImpl=StatusCodeStringImpl;var FixedUriStringImpl=function(_super){function FixedUriStringImpl(){_super.apply(this,arguments)}return __extends(FixedUriStringImpl,_super),FixedUriStringImpl.prototype.wrapperClassName=function(){return"FixedUriStringImpl"},FixedUriStringImpl.prototype.kind=function(){return"FixedUriString"},FixedUriStringImpl.prototype.RAMLVersion=function(){return"RAML10"},FixedUriStringImpl}(StringTypeImpl);exports.FixedUriStringImpl=FixedUriStringImpl;var ContentTypeImpl=function(_super){function ContentTypeImpl(){_super.apply(this,arguments)}return __extends(ContentTypeImpl,_super),ContentTypeImpl.prototype.wrapperClassName=function(){return"ContentTypeImpl"},ContentTypeImpl.prototype.kind=function(){return"ContentType"},ContentTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},ContentTypeImpl}(StringTypeImpl);exports.ContentTypeImpl=ContentTypeImpl;var MarkdownStringImpl=function(_super){function MarkdownStringImpl(){_super.apply(this,arguments)}return __extends(MarkdownStringImpl,_super),MarkdownStringImpl.prototype.wrapperClassName=function(){return"MarkdownStringImpl"},MarkdownStringImpl.prototype.kind=function(){return"MarkdownString"},MarkdownStringImpl.prototype.RAMLVersion=function(){return"RAML10"},MarkdownStringImpl}(StringTypeImpl);exports.MarkdownStringImpl=MarkdownStringImpl;var SchemaStringImpl=function(_super){function SchemaStringImpl(){_super.apply(this,arguments)}return __extends(SchemaStringImpl,_super),SchemaStringImpl.prototype.wrapperClassName=function(){return"SchemaStringImpl"},SchemaStringImpl.prototype.kind=function(){return"SchemaString"},SchemaStringImpl.prototype.RAMLVersion=function(){return"RAML10"},SchemaStringImpl}(StringTypeImpl);exports.SchemaStringImpl=SchemaStringImpl;var MimeTypeImpl=function(_super){function MimeTypeImpl(){_super.apply(this,arguments)}return __extends(MimeTypeImpl,_super),MimeTypeImpl.prototype.wrapperClassName=function(){return"MimeTypeImpl"},MimeTypeImpl.prototype.kind=function(){return"MimeType"},MimeTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},MimeTypeImpl}(StringTypeImpl);exports.MimeTypeImpl=MimeTypeImpl;var AnyTypeImpl=function(_super){function AnyTypeImpl(){_super.apply(this,arguments)}return __extends(AnyTypeImpl,_super),AnyTypeImpl.prototype.wrapperClassName=function(){return"AnyTypeImpl"},AnyTypeImpl.prototype.kind=function(){return"AnyType"},AnyTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},AnyTypeImpl}(ValueTypeImpl);exports.AnyTypeImpl=AnyTypeImpl;var NumberTypeImpl=function(_super){function NumberTypeImpl(){_super.apply(this,arguments)}return __extends(NumberTypeImpl,_super),NumberTypeImpl.prototype.wrapperClassName=function(){return"NumberTypeImpl"},NumberTypeImpl.prototype.kind=function(){return"NumberType"},NumberTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},NumberTypeImpl.prototype.value=function(){return this.attr.value()},NumberTypeImpl}(ValueTypeImpl);exports.NumberTypeImpl=NumberTypeImpl;var IntegerTypeImpl=function(_super){function IntegerTypeImpl(){_super.apply(this,arguments)}return __extends(IntegerTypeImpl,_super),IntegerTypeImpl.prototype.wrapperClassName=function(){return"IntegerTypeImpl"},IntegerTypeImpl.prototype.kind=function(){return"IntegerType"},IntegerTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},IntegerTypeImpl}(ValueTypeImpl);exports.IntegerTypeImpl=IntegerTypeImpl;var NullTypeImpl=function(_super){function NullTypeImpl(){_super.apply(this,arguments)}return __extends(NullTypeImpl,_super),NullTypeImpl.prototype.wrapperClassName=function(){return"NullTypeImpl"},NullTypeImpl.prototype.kind=function(){return"NullType"},NullTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},NullTypeImpl}(ValueTypeImpl);exports.NullTypeImpl=NullTypeImpl;var TimeOnlyTypeImpl=function(_super){function TimeOnlyTypeImpl(){_super.apply(this,arguments)}return __extends(TimeOnlyTypeImpl,_super),TimeOnlyTypeImpl.prototype.wrapperClassName=function(){return"TimeOnlyTypeImpl"},TimeOnlyTypeImpl.prototype.kind=function(){return"TimeOnlyType"},TimeOnlyTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},TimeOnlyTypeImpl}(ValueTypeImpl);exports.TimeOnlyTypeImpl=TimeOnlyTypeImpl;var DateOnlyTypeImpl=function(_super){function DateOnlyTypeImpl(){_super.apply(this,arguments)}return __extends(DateOnlyTypeImpl,_super),DateOnlyTypeImpl.prototype.wrapperClassName=function(){return"DateOnlyTypeImpl"},DateOnlyTypeImpl.prototype.kind=function(){return"DateOnlyType"},DateOnlyTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},DateOnlyTypeImpl}(ValueTypeImpl);exports.DateOnlyTypeImpl=DateOnlyTypeImpl;var DateTimeOnlyTypeImpl=function(_super){function DateTimeOnlyTypeImpl(){_super.apply(this,arguments)}return __extends(DateTimeOnlyTypeImpl,_super),DateTimeOnlyTypeImpl.prototype.wrapperClassName=function(){return"DateTimeOnlyTypeImpl"},DateTimeOnlyTypeImpl.prototype.kind=function(){return"DateTimeOnlyType"},DateTimeOnlyTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},DateTimeOnlyTypeImpl}(ValueTypeImpl);exports.DateTimeOnlyTypeImpl=DateTimeOnlyTypeImpl;var DateTimeTypeImpl=function(_super){function DateTimeTypeImpl(){_super.apply(this,arguments)}return __extends(DateTimeTypeImpl,_super),DateTimeTypeImpl.prototype.wrapperClassName=function(){return"DateTimeTypeImpl"},DateTimeTypeImpl.prototype.kind=function(){return"DateTimeType"},DateTimeTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},DateTimeTypeImpl}(ValueTypeImpl);exports.DateTimeTypeImpl=DateTimeTypeImpl;var FileTypeImpl=function(_super){function FileTypeImpl(){_super.apply(this,arguments)}return __extends(FileTypeImpl,_super),FileTypeImpl.prototype.wrapperClassName=function(){return"FileTypeImpl"},FileTypeImpl.prototype.kind=function(){return"FileType"},FileTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},FileTypeImpl}(ValueTypeImpl);exports.FileTypeImpl=FileTypeImpl;var BooleanTypeImpl=function(_super){function BooleanTypeImpl(){_super.apply(this,arguments)}return __extends(BooleanTypeImpl,_super),BooleanTypeImpl.prototype.wrapperClassName=function(){return"BooleanTypeImpl"},BooleanTypeImpl.prototype.kind=function(){return"BooleanType"},BooleanTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},BooleanTypeImpl.prototype.value=function(){return this.attr.value()},BooleanTypeImpl}(ValueTypeImpl);exports.BooleanTypeImpl=BooleanTypeImpl;var AnnotationTargetImpl=function(_super){function AnnotationTargetImpl(){_super.apply(this,arguments)}return __extends(AnnotationTargetImpl,_super),AnnotationTargetImpl.prototype.wrapperClassName=function(){return"AnnotationTargetImpl"},AnnotationTargetImpl.prototype.kind=function(){return"AnnotationTarget"},AnnotationTargetImpl.prototype.RAMLVersion=function(){return"RAML10"},AnnotationTargetImpl}(ValueTypeImpl);exports.AnnotationTargetImpl=AnnotationTargetImpl;var ReferenceImpl=function(_super){function ReferenceImpl(){_super.apply(this,arguments)}return __extends(ReferenceImpl,_super),ReferenceImpl.prototype.wrapperClassName=function(){return"ReferenceImpl"},ReferenceImpl.prototype.kind=function(){return"Reference"},ReferenceImpl.prototype.RAMLVersion=function(){return"RAML10"},ReferenceImpl.prototype.value=function(){return core.toStructuredValue(this.attr)},ReferenceImpl.prototype.structuredValue=function(){return helper.structuredValue(this)},ReferenceImpl.prototype.name=function(){return helper.referenceName(this)},ReferenceImpl}(core.AttributeNodeImpl);exports.ReferenceImpl=ReferenceImpl;var TraitRefImpl=function(_super){function TraitRefImpl(){_super.apply(this,arguments)}return __extends(TraitRefImpl,_super),TraitRefImpl.prototype.wrapperClassName=function(){return"TraitRefImpl"},TraitRefImpl.prototype.kind=function(){return"TraitRef"},TraitRefImpl.prototype.RAMLVersion=function(){return"RAML10"},TraitRefImpl.prototype.trait=function(){return helper.referencedTrait(this)},TraitRefImpl}(ReferenceImpl);exports.TraitRefImpl=TraitRefImpl;var OperationImpl=function(_super){function OperationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOperation(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OperationImpl,_super),OperationImpl.prototype.queryParameters=function(){return _super.prototype.elements.call(this,"queryParameters")},OperationImpl.prototype.headers=function(){return _super.prototype.elements.call(this,"headers")},OperationImpl.prototype.queryString=function(){return _super.prototype.element.call(this,"queryString")},OperationImpl.prototype.responses=function(){return _super.prototype.elements.call(this,"responses")},OperationImpl.prototype.wrapperClassName=function(){return"OperationImpl"},OperationImpl.prototype.kind=function(){return"Operation"},OperationImpl.prototype.RAMLVersion=function(){return"RAML10"},OperationImpl}(AnnotableImpl);exports.OperationImpl=OperationImpl;var TypeDeclarationImpl=function(_super){function TypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(TypeDeclarationImpl,_super),TypeDeclarationImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},TypeDeclarationImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},TypeDeclarationImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},TypeDeclarationImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},TypeDeclarationImpl.prototype.facets=function(){return _super.prototype.elements.call(this,"facets")},TypeDeclarationImpl.prototype.schema_original=function(){return _super.prototype.attributes.call(this,"schema",this.toString)},TypeDeclarationImpl.prototype.setSchema=function(param){return this.highLevel().attrOrCreate("schema").setValue(""+param),this},TypeDeclarationImpl.prototype.type_original=function(){return _super.prototype.attributes.call(this,"type",this.toString)},TypeDeclarationImpl.prototype.setType=function(param){return this.highLevel().attrOrCreate("type").setValue(""+param),this},TypeDeclarationImpl.prototype.location=function(){return _super.prototype.attribute.call(this,"location",function(attr){return new ModelLocationImpl(attr)})},TypeDeclarationImpl.prototype.locationKind=function(){return _super.prototype.attribute.call(this,"locationKind",function(attr){return new LocationKindImpl(attr)})},TypeDeclarationImpl.prototype.default=function(){return _super.prototype.attribute.call(this,"default",this.toAny)},TypeDeclarationImpl.prototype.setDefault=function(param){return this.highLevel().attrOrCreate("default").setValue(""+param),this},TypeDeclarationImpl.prototype.example_original=function(){return _super.prototype.element.call(this,"example")},TypeDeclarationImpl.prototype.examples_original=function(){return _super.prototype.elements.call(this,"examples")},TypeDeclarationImpl.prototype.required=function(){return _super.prototype.attribute.call(this,"required",this.toBoolean)},TypeDeclarationImpl.prototype.setRequired=function(param){return this.highLevel().attrOrCreate("required").setValue(""+param),this},TypeDeclarationImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},TypeDeclarationImpl.prototype.xml=function(){return _super.prototype.element.call(this,"xml")},TypeDeclarationImpl.prototype.allowedTargets=function(){return _super.prototype.attributes.call(this,"allowedTargets",function(attr){return new AnnotationTargetImpl(attr)})},TypeDeclarationImpl.prototype.isAnnotation=function(){return _super.prototype.attribute.call(this,"isAnnotation",this.toBoolean)},TypeDeclarationImpl.prototype.setIsAnnotation=function(param){return this.highLevel().attrOrCreate("isAnnotation").setValue(""+param),this},TypeDeclarationImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},TypeDeclarationImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},TypeDeclarationImpl.prototype.wrapperClassName=function(){return"TypeDeclarationImpl"},TypeDeclarationImpl.prototype.kind=function(){return"TypeDeclaration"},TypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},TypeDeclarationImpl.prototype.runtimeType=function(){return helper.runtimeType(this)},TypeDeclarationImpl.prototype.validateInstance=function(value){return helper.validateInstance(this,value)},TypeDeclarationImpl.prototype.validateInstanceWithDetailedStatuses=function(value){return helper.validateInstanceWithDetailedStatuses(this,value)},TypeDeclarationImpl.prototype.example=function(){return helper.getTypeExample(this)},TypeDeclarationImpl.prototype.examples=function(){return helper.getTypeExamples(this)},TypeDeclarationImpl.prototype.fixedFacets=function(){return helper.typeFixedFacets(this)},TypeDeclarationImpl.prototype.type=function(){return helper.typeValue(this)},TypeDeclarationImpl.prototype.schema=function(){return helper.schemaValue(this)},TypeDeclarationImpl.prototype.structuredType=function(){return helper.typeStructuredValue(this)},TypeDeclarationImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},TypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new TypeDeclarationScalarsAnnotationsImpl(this.highLevel())},TypeDeclarationImpl}(AnnotableImpl);exports.TypeDeclarationImpl=TypeDeclarationImpl;var ModelLocationImpl=function(){function ModelLocationImpl(attr){this.attr=attr}return ModelLocationImpl.prototype.wrapperClassName=function(){return"ModelLocationImpl"},ModelLocationImpl.prototype.kind=function(){return"ModelLocation"},ModelLocationImpl.prototype.RAMLVersion=function(){return"RAML10"},ModelLocationImpl}();exports.ModelLocationImpl=ModelLocationImpl;var LocationKindImpl=function(){function LocationKindImpl(attr){this.attr=attr}return LocationKindImpl.prototype.wrapperClassName=function(){return"LocationKindImpl"},LocationKindImpl.prototype.kind=function(){return"LocationKind"},LocationKindImpl.prototype.RAMLVersion=function(){return"RAML10"},LocationKindImpl}();exports.LocationKindImpl=LocationKindImpl;var UsesDeclarationImpl=function(_super){function UsesDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createUsesDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(UsesDeclarationImpl,_super),UsesDeclarationImpl.prototype.key=function(){return _super.prototype.attribute.call(this,"key",this.toString)},UsesDeclarationImpl.prototype.setKey=function(param){return this.highLevel().attrOrCreate("key").setValue(""+param),
this},UsesDeclarationImpl.prototype.value=function(){return _super.prototype.attribute.call(this,"value",this.toString)},UsesDeclarationImpl.prototype.setValue=function(param){return this.highLevel().attrOrCreate("value").setValue(""+param),this},UsesDeclarationImpl.prototype.wrapperClassName=function(){return"UsesDeclarationImpl"},UsesDeclarationImpl.prototype.kind=function(){return"UsesDeclaration"},UsesDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},UsesDeclarationImpl.prototype.ast=function(){return helper.referencedNode(this)},UsesDeclarationImpl.prototype.scalarsAnnotations=function(){return new UsesDeclarationScalarsAnnotationsImpl(this.highLevel())},UsesDeclarationImpl}(AnnotableImpl);exports.UsesDeclarationImpl=UsesDeclarationImpl;var AnnotableScalarsAnnotationsImpl=function(){function AnnotableScalarsAnnotationsImpl(node){this.node=node}return AnnotableScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},AnnotableScalarsAnnotationsImpl}();exports.AnnotableScalarsAnnotationsImpl=AnnotableScalarsAnnotationsImpl;var UsesDeclarationScalarsAnnotationsImpl=function(_super){function UsesDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(UsesDeclarationScalarsAnnotationsImpl,_super),UsesDeclarationScalarsAnnotationsImpl.prototype.value=function(){var attr=this.node.attr("value");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},UsesDeclarationScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.UsesDeclarationScalarsAnnotationsImpl=UsesDeclarationScalarsAnnotationsImpl;var XMLFacetInfoImpl=function(_super){function XMLFacetInfoImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createXMLFacetInfo(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(XMLFacetInfoImpl,_super),XMLFacetInfoImpl.prototype.attribute=function(){return _super.prototype.attribute.call(this,"attribute",this.toBoolean)},XMLFacetInfoImpl.prototype.setAttribute=function(param){return this.highLevel().attrOrCreate("attribute").setValue(""+param),this},XMLFacetInfoImpl.prototype.wrapped=function(){return _super.prototype.attribute.call(this,"wrapped",this.toBoolean)},XMLFacetInfoImpl.prototype.setWrapped=function(param){return this.highLevel().attrOrCreate("wrapped").setValue(""+param),this},XMLFacetInfoImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},XMLFacetInfoImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},XMLFacetInfoImpl.prototype.namespace=function(){return _super.prototype.attribute.call(this,"namespace",this.toString)},XMLFacetInfoImpl.prototype.setNamespace=function(param){return this.highLevel().attrOrCreate("namespace").setValue(""+param),this},XMLFacetInfoImpl.prototype.prefix=function(){return _super.prototype.attribute.call(this,"prefix",this.toString)},XMLFacetInfoImpl.prototype.setPrefix=function(param){return this.highLevel().attrOrCreate("prefix").setValue(""+param),this},XMLFacetInfoImpl.prototype.wrapperClassName=function(){return"XMLFacetInfoImpl"},XMLFacetInfoImpl.prototype.kind=function(){return"XMLFacetInfo"},XMLFacetInfoImpl.prototype.RAMLVersion=function(){return"RAML10"},XMLFacetInfoImpl.prototype.scalarsAnnotations=function(){return new XMLFacetInfoScalarsAnnotationsImpl(this.highLevel())},XMLFacetInfoImpl}(AnnotableImpl);exports.XMLFacetInfoImpl=XMLFacetInfoImpl;var XMLFacetInfoScalarsAnnotationsImpl=function(_super){function XMLFacetInfoScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(XMLFacetInfoScalarsAnnotationsImpl,_super),XMLFacetInfoScalarsAnnotationsImpl.prototype.attribute=function(){var attr=this.node.attr("attribute");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},XMLFacetInfoScalarsAnnotationsImpl.prototype.wrapped=function(){var attr=this.node.attr("wrapped");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},XMLFacetInfoScalarsAnnotationsImpl.prototype.name=function(){var attr=this.node.attr("name");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},XMLFacetInfoScalarsAnnotationsImpl.prototype.namespace=function(){var attr=this.node.attr("namespace");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},XMLFacetInfoScalarsAnnotationsImpl.prototype.prefix=function(){var attr=this.node.attr("prefix");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},XMLFacetInfoScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.XMLFacetInfoScalarsAnnotationsImpl=XMLFacetInfoScalarsAnnotationsImpl;var ArrayTypeDeclarationImpl=function(_super){function ArrayTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createArrayTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ArrayTypeDeclarationImpl,_super),ArrayTypeDeclarationImpl.prototype.uniqueItems=function(){return _super.prototype.attribute.call(this,"uniqueItems",this.toBoolean)},ArrayTypeDeclarationImpl.prototype.setUniqueItems=function(param){return this.highLevel().attrOrCreate("uniqueItems").setValue(""+param),this},ArrayTypeDeclarationImpl.prototype.items_original=function(){return _super.prototype.element.call(this,"items")},ArrayTypeDeclarationImpl.prototype.minItems=function(){return _super.prototype.attribute.call(this,"minItems",this.toNumber)},ArrayTypeDeclarationImpl.prototype.setMinItems=function(param){return this.highLevel().attrOrCreate("minItems").setValue(""+param),this},ArrayTypeDeclarationImpl.prototype.maxItems=function(){return _super.prototype.attribute.call(this,"maxItems",this.toNumber)},ArrayTypeDeclarationImpl.prototype.setMaxItems=function(param){return this.highLevel().attrOrCreate("maxItems").setValue(""+param),this},ArrayTypeDeclarationImpl.prototype.wrapperClassName=function(){return"ArrayTypeDeclarationImpl"},ArrayTypeDeclarationImpl.prototype.kind=function(){return"ArrayTypeDeclaration"},ArrayTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},ArrayTypeDeclarationImpl.prototype.items=function(){return helper.getItems(this)},ArrayTypeDeclarationImpl.prototype.findComponentTypeDeclaration=function(){return helper.findComponentTypeDeclaration(this)},ArrayTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new ArrayTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},ArrayTypeDeclarationImpl}(TypeDeclarationImpl);exports.ArrayTypeDeclarationImpl=ArrayTypeDeclarationImpl;var TypeDeclarationScalarsAnnotationsImpl=function(_super){function TypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(TypeDeclarationScalarsAnnotationsImpl,_super),TypeDeclarationScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.schema=function(){var attrs=this.node.attributes("schema");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},TypeDeclarationScalarsAnnotationsImpl.prototype.type=function(){var attrs=this.node.attributes("type");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},TypeDeclarationScalarsAnnotationsImpl.prototype.location=function(){var attr=this.node.attr("location");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.locationKind=function(){var attr=this.node.attr("locationKind");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.default=function(){var attr=this.node.attr("default");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.required=function(){var attr=this.node.attr("required");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.allowedTargets=function(){var attrs=this.node.attributes("allowedTargets");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},TypeDeclarationScalarsAnnotationsImpl.prototype.isAnnotation=function(){var attr=this.node.attr("isAnnotation");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TypeDeclarationScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},TypeDeclarationScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.TypeDeclarationScalarsAnnotationsImpl=TypeDeclarationScalarsAnnotationsImpl;var ArrayTypeDeclarationScalarsAnnotationsImpl=function(_super){function ArrayTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ArrayTypeDeclarationScalarsAnnotationsImpl,_super),ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.uniqueItems=function(){var attr=this.node.attr("uniqueItems");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.minItems=function(){var attr=this.node.attr("minItems");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.maxItems=function(){var attr=this.node.attr("maxItems");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ArrayTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.ArrayTypeDeclarationScalarsAnnotationsImpl=ArrayTypeDeclarationScalarsAnnotationsImpl;var UnionTypeDeclarationImpl=function(_super){function UnionTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createUnionTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(UnionTypeDeclarationImpl,_super),UnionTypeDeclarationImpl.prototype.wrapperClassName=function(){return"UnionTypeDeclarationImpl"},UnionTypeDeclarationImpl.prototype.kind=function(){return"UnionTypeDeclaration"},UnionTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},UnionTypeDeclarationImpl}(TypeDeclarationImpl);exports.UnionTypeDeclarationImpl=UnionTypeDeclarationImpl;var ObjectTypeDeclarationImpl=function(_super){function ObjectTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createObjectTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ObjectTypeDeclarationImpl,_super),ObjectTypeDeclarationImpl.prototype.properties=function(){return _super.prototype.elements.call(this,"properties")},ObjectTypeDeclarationImpl.prototype.minProperties=function(){return _super.prototype.attribute.call(this,"minProperties",this.toNumber)},ObjectTypeDeclarationImpl.prototype.setMinProperties=function(param){return this.highLevel().attrOrCreate("minProperties").setValue(""+param),this},ObjectTypeDeclarationImpl.prototype.maxProperties=function(){return _super.prototype.attribute.call(this,"maxProperties",this.toNumber)},ObjectTypeDeclarationImpl.prototype.setMaxProperties=function(param){return this.highLevel().attrOrCreate("maxProperties").setValue(""+param),this},ObjectTypeDeclarationImpl.prototype.additionalProperties=function(){return _super.prototype.attribute.call(this,"additionalProperties",this.toBoolean)},ObjectTypeDeclarationImpl.prototype.setAdditionalProperties=function(param){return this.highLevel().attrOrCreate("additionalProperties").setValue(""+param),this},ObjectTypeDeclarationImpl.prototype.discriminator=function(){return _super.prototype.attribute.call(this,"discriminator",this.toString)},ObjectTypeDeclarationImpl.prototype.setDiscriminator=function(param){return this.highLevel().attrOrCreate("discriminator").setValue(""+param),this},ObjectTypeDeclarationImpl.prototype.discriminatorValue=function(){return _super.prototype.attribute.call(this,"discriminatorValue",this.toString)},ObjectTypeDeclarationImpl.prototype.setDiscriminatorValue=function(param){return this.highLevel().attrOrCreate("discriminatorValue").setValue(""+param),this},ObjectTypeDeclarationImpl.prototype.wrapperClassName=function(){return"ObjectTypeDeclarationImpl"},ObjectTypeDeclarationImpl.prototype.kind=function(){return"ObjectTypeDeclaration"},ObjectTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},ObjectTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new ObjectTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},ObjectTypeDeclarationImpl}(TypeDeclarationImpl);exports.ObjectTypeDeclarationImpl=ObjectTypeDeclarationImpl;var ObjectTypeDeclarationScalarsAnnotationsImpl=function(_super){function ObjectTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ObjectTypeDeclarationScalarsAnnotationsImpl,_super),ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.minProperties=function(){var attr=this.node.attr("minProperties");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.maxProperties=function(){var attr=this.node.attr("maxProperties");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.additionalProperties=function(){var attr=this.node.attr("additionalProperties");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.discriminator=function(){var attr=this.node.attr("discriminator");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.discriminatorValue=function(){var attr=this.node.attr("discriminatorValue");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ObjectTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.ObjectTypeDeclarationScalarsAnnotationsImpl=ObjectTypeDeclarationScalarsAnnotationsImpl;var StringTypeDeclarationImpl=function(_super){function StringTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createStringTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(StringTypeDeclarationImpl,_super),StringTypeDeclarationImpl.prototype.pattern=function(){return _super.prototype.attribute.call(this,"pattern",this.toString)},StringTypeDeclarationImpl.prototype.setPattern=function(param){return this.highLevel().attrOrCreate("pattern").setValue(""+param),this},StringTypeDeclarationImpl.prototype.minLength=function(){return _super.prototype.attribute.call(this,"minLength",this.toNumber)},StringTypeDeclarationImpl.prototype.setMinLength=function(param){return this.highLevel().attrOrCreate("minLength").setValue(""+param),this},StringTypeDeclarationImpl.prototype.maxLength=function(){return _super.prototype.attribute.call(this,"maxLength",this.toNumber)},StringTypeDeclarationImpl.prototype.setMaxLength=function(param){return this.highLevel().attrOrCreate("maxLength").setValue(""+param),this},StringTypeDeclarationImpl.prototype.enum=function(){return _super.prototype.attributes.call(this,"enum",this.toString)},StringTypeDeclarationImpl.prototype.setEnum=function(param){return this.highLevel().attrOrCreate("enum").setValue(""+param),this},StringTypeDeclarationImpl.prototype.wrapperClassName=function(){return"StringTypeDeclarationImpl"},StringTypeDeclarationImpl.prototype.kind=function(){return"StringTypeDeclaration"},StringTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},StringTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new StringTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},StringTypeDeclarationImpl}(TypeDeclarationImpl);exports.StringTypeDeclarationImpl=StringTypeDeclarationImpl;var StringTypeDeclarationScalarsAnnotationsImpl=function(_super){function StringTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(StringTypeDeclarationScalarsAnnotationsImpl,_super),StringTypeDeclarationScalarsAnnotationsImpl.prototype.pattern=function(){var attr=this.node.attr("pattern");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},StringTypeDeclarationScalarsAnnotationsImpl.prototype.minLength=function(){var attr=this.node.attr("minLength");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},StringTypeDeclarationScalarsAnnotationsImpl.prototype.maxLength=function(){var attr=this.node.attr("maxLength");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},StringTypeDeclarationScalarsAnnotationsImpl.prototype.enum=function(){var attrs=this.node.attributes("enum");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},StringTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.StringTypeDeclarationScalarsAnnotationsImpl=StringTypeDeclarationScalarsAnnotationsImpl;var BooleanTypeDeclarationImpl=function(_super){function BooleanTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createBooleanTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(BooleanTypeDeclarationImpl,_super),BooleanTypeDeclarationImpl.prototype.wrapperClassName=function(){return"BooleanTypeDeclarationImpl"},BooleanTypeDeclarationImpl.prototype.kind=function(){return"BooleanTypeDeclaration"},BooleanTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},BooleanTypeDeclarationImpl}(TypeDeclarationImpl);exports.BooleanTypeDeclarationImpl=BooleanTypeDeclarationImpl;var NumberTypeDeclarationImpl=function(_super){function NumberTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createNumberTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(NumberTypeDeclarationImpl,_super),NumberTypeDeclarationImpl.prototype.minimum=function(){return _super.prototype.attribute.call(this,"minimum",this.toNumber)},NumberTypeDeclarationImpl.prototype.setMinimum=function(param){return this.highLevel().attrOrCreate("minimum").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.maximum=function(){return _super.prototype.attribute.call(this,"maximum",this.toNumber)},NumberTypeDeclarationImpl.prototype.setMaximum=function(param){return this.highLevel().attrOrCreate("maximum").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.enum=function(){return _super.prototype.attributes.call(this,"enum",this.toString)},NumberTypeDeclarationImpl.prototype.setEnum=function(param){return this.highLevel().attrOrCreate("enum").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.format=function(){return _super.prototype.attribute.call(this,"format",this.toString)},NumberTypeDeclarationImpl.prototype.setFormat=function(param){return this.highLevel().attrOrCreate("format").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.multipleOf=function(){return _super.prototype.attribute.call(this,"multipleOf",this.toNumber)},NumberTypeDeclarationImpl.prototype.setMultipleOf=function(param){return this.highLevel().attrOrCreate("multipleOf").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.wrapperClassName=function(){return"NumberTypeDeclarationImpl"},NumberTypeDeclarationImpl.prototype.kind=function(){return"NumberTypeDeclaration"},NumberTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},NumberTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new NumberTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},NumberTypeDeclarationImpl}(TypeDeclarationImpl);exports.NumberTypeDeclarationImpl=NumberTypeDeclarationImpl;var IntegerTypeDeclarationImpl=function(_super){function IntegerTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createIntegerTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(IntegerTypeDeclarationImpl,_super),IntegerTypeDeclarationImpl.prototype.format=function(){return _super.prototype.attribute.call(this,"format",this.toString)},IntegerTypeDeclarationImpl.prototype.setFormat=function(param){return this.highLevel().attrOrCreate("format").setValue(""+param),this},IntegerTypeDeclarationImpl.prototype.wrapperClassName=function(){return"IntegerTypeDeclarationImpl"},IntegerTypeDeclarationImpl.prototype.kind=function(){return"IntegerTypeDeclaration"},IntegerTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},IntegerTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new IntegerTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},IntegerTypeDeclarationImpl}(NumberTypeDeclarationImpl);exports.IntegerTypeDeclarationImpl=IntegerTypeDeclarationImpl;var NumberTypeDeclarationScalarsAnnotationsImpl=function(_super){function NumberTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(NumberTypeDeclarationScalarsAnnotationsImpl,_super),NumberTypeDeclarationScalarsAnnotationsImpl.prototype.minimum=function(){var attr=this.node.attr("minimum");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},NumberTypeDeclarationScalarsAnnotationsImpl.prototype.maximum=function(){var attr=this.node.attr("maximum");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},NumberTypeDeclarationScalarsAnnotationsImpl.prototype.enum=function(){var attrs=this.node.attributes("enum");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},NumberTypeDeclarationScalarsAnnotationsImpl.prototype.format=function(){var attr=this.node.attr("format");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},NumberTypeDeclarationScalarsAnnotationsImpl.prototype.multipleOf=function(){var attr=this.node.attr("multipleOf");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},NumberTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.NumberTypeDeclarationScalarsAnnotationsImpl=NumberTypeDeclarationScalarsAnnotationsImpl;var IntegerTypeDeclarationScalarsAnnotationsImpl=function(_super){function IntegerTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(IntegerTypeDeclarationScalarsAnnotationsImpl,_super),IntegerTypeDeclarationScalarsAnnotationsImpl.prototype.format=function(){var attr=this.node.attr("format");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},IntegerTypeDeclarationScalarsAnnotationsImpl}(NumberTypeDeclarationScalarsAnnotationsImpl);exports.IntegerTypeDeclarationScalarsAnnotationsImpl=IntegerTypeDeclarationScalarsAnnotationsImpl;var DateOnlyTypeDeclarationImpl=function(_super){function DateOnlyTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDateOnlyTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DateOnlyTypeDeclarationImpl,_super),DateOnlyTypeDeclarationImpl.prototype.wrapperClassName=function(){return"DateOnlyTypeDeclarationImpl"},DateOnlyTypeDeclarationImpl.prototype.kind=function(){return"DateOnlyTypeDeclaration"},DateOnlyTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},DateOnlyTypeDeclarationImpl}(TypeDeclarationImpl);exports.DateOnlyTypeDeclarationImpl=DateOnlyTypeDeclarationImpl;var TimeOnlyTypeDeclarationImpl=function(_super){function TimeOnlyTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createTimeOnlyTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(TimeOnlyTypeDeclarationImpl,_super),TimeOnlyTypeDeclarationImpl.prototype.wrapperClassName=function(){return"TimeOnlyTypeDeclarationImpl"},TimeOnlyTypeDeclarationImpl.prototype.kind=function(){return"TimeOnlyTypeDeclaration"},TimeOnlyTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},TimeOnlyTypeDeclarationImpl}(TypeDeclarationImpl);exports.TimeOnlyTypeDeclarationImpl=TimeOnlyTypeDeclarationImpl;var DateTimeOnlyTypeDeclarationImpl=function(_super){function DateTimeOnlyTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDateTimeOnlyTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DateTimeOnlyTypeDeclarationImpl,_super),DateTimeOnlyTypeDeclarationImpl.prototype.wrapperClassName=function(){return"DateTimeOnlyTypeDeclarationImpl"},DateTimeOnlyTypeDeclarationImpl.prototype.kind=function(){return"DateTimeOnlyTypeDeclaration"},DateTimeOnlyTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},DateTimeOnlyTypeDeclarationImpl}(TypeDeclarationImpl);exports.DateTimeOnlyTypeDeclarationImpl=DateTimeOnlyTypeDeclarationImpl;var DateTimeTypeDeclarationImpl=function(_super){function DateTimeTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDateTimeTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DateTimeTypeDeclarationImpl,_super),DateTimeTypeDeclarationImpl.prototype.format=function(){return _super.prototype.attribute.call(this,"format",this.toString)},DateTimeTypeDeclarationImpl.prototype.setFormat=function(param){return this.highLevel().attrOrCreate("format").setValue(""+param),this},DateTimeTypeDeclarationImpl.prototype.wrapperClassName=function(){return"DateTimeTypeDeclarationImpl"},DateTimeTypeDeclarationImpl.prototype.kind=function(){return"DateTimeTypeDeclaration"},DateTimeTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},DateTimeTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new DateTimeTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},DateTimeTypeDeclarationImpl}(TypeDeclarationImpl);exports.DateTimeTypeDeclarationImpl=DateTimeTypeDeclarationImpl;var DateTimeTypeDeclarationScalarsAnnotationsImpl=function(_super){function DateTimeTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(DateTimeTypeDeclarationScalarsAnnotationsImpl,_super),DateTimeTypeDeclarationScalarsAnnotationsImpl.prototype.format=function(){var attr=this.node.attr("format");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},DateTimeTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.DateTimeTypeDeclarationScalarsAnnotationsImpl=DateTimeTypeDeclarationScalarsAnnotationsImpl;var DateTypeDeclarationImpl=function(_super){function DateTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDateTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DateTypeDeclarationImpl,_super),DateTypeDeclarationImpl.prototype.wrapperClassName=function(){return"DateTypeDeclarationImpl"},DateTypeDeclarationImpl.prototype.kind=function(){return"DateTypeDeclaration"},DateTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},DateTypeDeclarationImpl}(TypeDeclarationImpl);exports.DateTypeDeclarationImpl=DateTypeDeclarationImpl;var FileTypeDeclarationImpl=function(_super){function FileTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createFileTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(FileTypeDeclarationImpl,_super),FileTypeDeclarationImpl.prototype.fileTypes=function(){return _super.prototype.attributes.call(this,"fileTypes",function(attr){
return new ContentTypeImpl(attr)})},FileTypeDeclarationImpl.prototype.minLength=function(){return _super.prototype.attribute.call(this,"minLength",this.toNumber)},FileTypeDeclarationImpl.prototype.setMinLength=function(param){return this.highLevel().attrOrCreate("minLength").setValue(""+param),this},FileTypeDeclarationImpl.prototype.maxLength=function(){return _super.prototype.attribute.call(this,"maxLength",this.toNumber)},FileTypeDeclarationImpl.prototype.setMaxLength=function(param){return this.highLevel().attrOrCreate("maxLength").setValue(""+param),this},FileTypeDeclarationImpl.prototype.wrapperClassName=function(){return"FileTypeDeclarationImpl"},FileTypeDeclarationImpl.prototype.kind=function(){return"FileTypeDeclaration"},FileTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},FileTypeDeclarationImpl.prototype.scalarsAnnotations=function(){return new FileTypeDeclarationScalarsAnnotationsImpl(this.highLevel())},FileTypeDeclarationImpl}(TypeDeclarationImpl);exports.FileTypeDeclarationImpl=FileTypeDeclarationImpl;var FileTypeDeclarationScalarsAnnotationsImpl=function(_super){function FileTypeDeclarationScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(FileTypeDeclarationScalarsAnnotationsImpl,_super),FileTypeDeclarationScalarsAnnotationsImpl.prototype.fileTypes=function(){var attrs=this.node.attributes("fileTypes");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},FileTypeDeclarationScalarsAnnotationsImpl.prototype.minLength=function(){var attr=this.node.attr("minLength");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},FileTypeDeclarationScalarsAnnotationsImpl.prototype.maxLength=function(){var attr=this.node.attr("maxLength");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},FileTypeDeclarationScalarsAnnotationsImpl}(TypeDeclarationScalarsAnnotationsImpl);exports.FileTypeDeclarationScalarsAnnotationsImpl=FileTypeDeclarationScalarsAnnotationsImpl;var ResponseImpl=function(_super){function ResponseImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createResponse(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ResponseImpl,_super),ResponseImpl.prototype.code=function(){return _super.prototype.attribute.call(this,"code",function(attr){return new StatusCodeStringImpl(attr)})},ResponseImpl.prototype.headers=function(){return _super.prototype.elements.call(this,"headers")},ResponseImpl.prototype.body=function(){return _super.prototype.elements.call(this,"body")},ResponseImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResponseImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},ResponseImpl.prototype.wrapperClassName=function(){return"ResponseImpl"},ResponseImpl.prototype.kind=function(){return"Response"},ResponseImpl.prototype.RAMLVersion=function(){return"RAML10"},ResponseImpl.prototype.isOkRange=function(){return helper.isOkRange(this)},ResponseImpl.prototype.scalarsAnnotations=function(){return new ResponseScalarsAnnotationsImpl(this.highLevel())},ResponseImpl}(AnnotableImpl);exports.ResponseImpl=ResponseImpl;var ResponseScalarsAnnotationsImpl=function(_super){function ResponseScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ResponseScalarsAnnotationsImpl,_super),ResponseScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResponseScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ResponseScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.ResponseScalarsAnnotationsImpl=ResponseScalarsAnnotationsImpl;var SecuritySchemePartImpl=function(_super){function SecuritySchemePartImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createSecuritySchemePart(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(SecuritySchemePartImpl,_super),SecuritySchemePartImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},SecuritySchemePartImpl.prototype.wrapperClassName=function(){return"SecuritySchemePartImpl"},SecuritySchemePartImpl.prototype.kind=function(){return"SecuritySchemePart"},SecuritySchemePartImpl.prototype.RAMLVersion=function(){return"RAML10"},SecuritySchemePartImpl.prototype.scalarsAnnotations=function(){return new SecuritySchemePartScalarsAnnotationsImpl(this.highLevel())},SecuritySchemePartImpl}(OperationImpl);exports.SecuritySchemePartImpl=SecuritySchemePartImpl;var SecuritySchemePartScalarsAnnotationsImpl=function(_super){function SecuritySchemePartScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(SecuritySchemePartScalarsAnnotationsImpl,_super),SecuritySchemePartScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},SecuritySchemePartScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.SecuritySchemePartScalarsAnnotationsImpl=SecuritySchemePartScalarsAnnotationsImpl;var MethodBaseImpl=function(_super){function MethodBaseImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createMethodBase(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(MethodBaseImpl,_super),MethodBaseImpl.prototype.body=function(){return _super.prototype.elements.call(this,"body")},MethodBaseImpl.prototype.protocols=function(){return _super.prototype.attributes.call(this,"protocols",this.toString)},MethodBaseImpl.prototype.setProtocols=function(param){return this.highLevel().attrOrCreate("protocols").setValue(""+param),this},MethodBaseImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},MethodBaseImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},MethodBaseImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},MethodBaseImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},MethodBaseImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},MethodBaseImpl.prototype.wrapperClassName=function(){return"MethodBaseImpl"},MethodBaseImpl.prototype.kind=function(){return"MethodBase"},MethodBaseImpl.prototype.RAMLVersion=function(){return"RAML10"},MethodBaseImpl.prototype.scalarsAnnotations=function(){return new MethodBaseScalarsAnnotationsImpl(this.highLevel())},MethodBaseImpl}(OperationImpl);exports.MethodBaseImpl=MethodBaseImpl;var SecuritySchemeRefImpl=function(_super){function SecuritySchemeRefImpl(){_super.apply(this,arguments)}return __extends(SecuritySchemeRefImpl,_super),SecuritySchemeRefImpl.prototype.wrapperClassName=function(){return"SecuritySchemeRefImpl"},SecuritySchemeRefImpl.prototype.kind=function(){return"SecuritySchemeRef"},SecuritySchemeRefImpl.prototype.RAMLVersion=function(){return"RAML10"},SecuritySchemeRefImpl.prototype.securitySchemeName=function(){return helper.securitySchemeName(this)},SecuritySchemeRefImpl.prototype.securityScheme=function(){return helper.securityScheme(this)},SecuritySchemeRefImpl}(ReferenceImpl);exports.SecuritySchemeRefImpl=SecuritySchemeRefImpl;var AbstractSecuritySchemeImpl=function(_super){function AbstractSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createAbstractSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(AbstractSecuritySchemeImpl,_super),AbstractSecuritySchemeImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},AbstractSecuritySchemeImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},AbstractSecuritySchemeImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",this.toString)},AbstractSecuritySchemeImpl.prototype.setType=function(param){return this.highLevel().attrOrCreate("type").setValue(""+param),this},AbstractSecuritySchemeImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},AbstractSecuritySchemeImpl.prototype.describedBy=function(){return _super.prototype.element.call(this,"describedBy")},AbstractSecuritySchemeImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},AbstractSecuritySchemeImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},AbstractSecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},AbstractSecuritySchemeImpl.prototype.wrapperClassName=function(){return"AbstractSecuritySchemeImpl"},AbstractSecuritySchemeImpl.prototype.kind=function(){return"AbstractSecurityScheme"},AbstractSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},AbstractSecuritySchemeImpl.prototype.scalarsAnnotations=function(){return new AbstractSecuritySchemeScalarsAnnotationsImpl(this.highLevel())},AbstractSecuritySchemeImpl}(AnnotableImpl);exports.AbstractSecuritySchemeImpl=AbstractSecuritySchemeImpl;var SecuritySchemeSettingsImpl=function(_super){function SecuritySchemeSettingsImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createSecuritySchemeSettings(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(SecuritySchemeSettingsImpl,_super),SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"SecuritySchemeSettingsImpl"},SecuritySchemeSettingsImpl.prototype.kind=function(){return"SecuritySchemeSettings"},SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML10"},SecuritySchemeSettingsImpl}(AnnotableImpl);exports.SecuritySchemeSettingsImpl=SecuritySchemeSettingsImpl;var OAuth1SecuritySchemeSettingsImpl=function(_super){function OAuth1SecuritySchemeSettingsImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth1SecuritySchemeSettings(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth1SecuritySchemeSettingsImpl,_super),OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri=function(){return _super.prototype.attribute.call(this,"requestTokenUri",function(attr){return new FixedUriStringImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri=function(){return _super.prototype.attribute.call(this,"authorizationUri",function(attr){return new FixedUriStringImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri=function(){return _super.prototype.attribute.call(this,"tokenCredentialsUri",function(attr){return new FixedUriStringImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.signatures=function(){return _super.prototype.attributes.call(this,"signatures",this.toString)},OAuth1SecuritySchemeSettingsImpl.prototype.setSignatures=function(param){return this.highLevel().attrOrCreate("signatures").setValue(""+param),this},OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeSettingsImpl"},OAuth1SecuritySchemeSettingsImpl.prototype.kind=function(){return"OAuth1SecuritySchemeSettings"},OAuth1SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML10"},OAuth1SecuritySchemeSettingsImpl.prototype.scalarsAnnotations=function(){return new OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl(this.highLevel())},OAuth1SecuritySchemeSettingsImpl}(SecuritySchemeSettingsImpl);exports.OAuth1SecuritySchemeSettingsImpl=OAuth1SecuritySchemeSettingsImpl;var OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl=function(_super){function OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl,_super),OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.requestTokenUri=function(){var attr=this.node.attr("requestTokenUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationUri=function(){var attr=this.node.attr("authorizationUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.tokenCredentialsUri=function(){var attr=this.node.attr("tokenCredentialsUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.signatures=function(){var attrs=this.node.attributes("signatures");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl=OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl;var OAuth2SecuritySchemeSettingsImpl=function(_super){function OAuth2SecuritySchemeSettingsImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth2SecuritySchemeSettings(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth2SecuritySchemeSettingsImpl,_super),OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri=function(){return _super.prototype.attribute.call(this,"accessTokenUri",function(attr){return new FixedUriStringImpl(attr)})},OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri=function(){return _super.prototype.attribute.call(this,"authorizationUri",function(attr){return new FixedUriStringImpl(attr)})},OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants=function(){return _super.prototype.attributes.call(this,"authorizationGrants",this.toString)},OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants=function(param){return this.highLevel().attrOrCreate("authorizationGrants").setValue(""+param),this},OAuth2SecuritySchemeSettingsImpl.prototype.scopes=function(){return _super.prototype.attributes.call(this,"scopes",this.toString)},OAuth2SecuritySchemeSettingsImpl.prototype.setScopes=function(param){return this.highLevel().attrOrCreate("scopes").setValue(""+param),this},OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeSettingsImpl"},OAuth2SecuritySchemeSettingsImpl.prototype.kind=function(){return"OAuth2SecuritySchemeSettings"},OAuth2SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML10"},OAuth2SecuritySchemeSettingsImpl.prototype.scalarsAnnotations=function(){return new OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl(this.highLevel())},OAuth2SecuritySchemeSettingsImpl}(SecuritySchemeSettingsImpl);exports.OAuth2SecuritySchemeSettingsImpl=OAuth2SecuritySchemeSettingsImpl;var OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl=function(_super){function OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl,_super),OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.accessTokenUri=function(){var attr=this.node.attr("accessTokenUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationUri=function(){var attr=this.node.attr("authorizationUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationGrants=function(){var attrs=this.node.attributes("authorizationGrants");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.scopes=function(){var attrs=this.node.attributes("scopes");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl=OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl;var OAuth2SecuritySchemeImpl=function(_super){function OAuth2SecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth2SecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth2SecuritySchemeImpl,_super),OAuth2SecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},OAuth2SecuritySchemeImpl.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeImpl"},OAuth2SecuritySchemeImpl.prototype.kind=function(){return"OAuth2SecurityScheme"},OAuth2SecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},OAuth2SecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.OAuth2SecuritySchemeImpl=OAuth2SecuritySchemeImpl;var OAuth1SecuritySchemeImpl=function(_super){function OAuth1SecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth1SecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth1SecuritySchemeImpl,_super),OAuth1SecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},OAuth1SecuritySchemeImpl.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeImpl"},OAuth1SecuritySchemeImpl.prototype.kind=function(){return"OAuth1SecurityScheme"},OAuth1SecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},OAuth1SecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.OAuth1SecuritySchemeImpl=OAuth1SecuritySchemeImpl;var PassThroughSecuritySchemeImpl=function(_super){function PassThroughSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createPassThroughSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(PassThroughSecuritySchemeImpl,_super),PassThroughSecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},PassThroughSecuritySchemeImpl.prototype.wrapperClassName=function(){return"PassThroughSecuritySchemeImpl"},PassThroughSecuritySchemeImpl.prototype.kind=function(){return"PassThroughSecurityScheme"},PassThroughSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},PassThroughSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.PassThroughSecuritySchemeImpl=PassThroughSecuritySchemeImpl;var BasicSecuritySchemeImpl=function(_super){function BasicSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createBasicSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(BasicSecuritySchemeImpl,_super),BasicSecuritySchemeImpl.prototype.wrapperClassName=function(){return"BasicSecuritySchemeImpl"},BasicSecuritySchemeImpl.prototype.kind=function(){return"BasicSecurityScheme"},BasicSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},BasicSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.BasicSecuritySchemeImpl=BasicSecuritySchemeImpl;var DigestSecuritySchemeImpl=function(_super){function DigestSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDigestSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DigestSecuritySchemeImpl,_super),DigestSecuritySchemeImpl.prototype.wrapperClassName=function(){return"DigestSecuritySchemeImpl"},DigestSecuritySchemeImpl.prototype.kind=function(){return"DigestSecurityScheme"},DigestSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},DigestSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.DigestSecuritySchemeImpl=DigestSecuritySchemeImpl;var CustomSecuritySchemeImpl=function(_super){function CustomSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createCustomSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(CustomSecuritySchemeImpl,_super),CustomSecuritySchemeImpl.prototype.wrapperClassName=function(){return"CustomSecuritySchemeImpl"},CustomSecuritySchemeImpl.prototype.kind=function(){return"CustomSecurityScheme"},CustomSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML10"},CustomSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.CustomSecuritySchemeImpl=CustomSecuritySchemeImpl;var AbstractSecuritySchemeScalarsAnnotationsImpl=function(_super){function AbstractSecuritySchemeScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(AbstractSecuritySchemeScalarsAnnotationsImpl,_super),AbstractSecuritySchemeScalarsAnnotationsImpl.prototype.type=function(){var attr=this.node.attr("type");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},AbstractSecuritySchemeScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},AbstractSecuritySchemeScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},AbstractSecuritySchemeScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.AbstractSecuritySchemeScalarsAnnotationsImpl=AbstractSecuritySchemeScalarsAnnotationsImpl;var MethodImpl=function(_super){function MethodImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createMethod(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(MethodImpl,_super),MethodImpl.prototype.method=function(){return _super.prototype.attribute.call(this,"method",this.toString)},MethodImpl.prototype.setMethod=function(param){return this.highLevel().attrOrCreate("method").setValue(""+param),this},MethodImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},MethodImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},MethodImpl.prototype.wrapperClassName=function(){return"MethodImpl"},MethodImpl.prototype.kind=function(){return"Method"},MethodImpl.prototype.RAMLVersion=function(){return"RAML10"},MethodImpl.prototype.parentResource=function(){return helper.parentResource(this)},MethodImpl.prototype.ownerApi=function(){return helper.ownerApi(this)},MethodImpl.prototype.methodId=function(){return helper.methodId(this)},MethodImpl.prototype.allSecuredBy=function(){return helper.allSecuredBy(this)},MethodImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},MethodImpl.prototype.scalarsAnnotations=function(){return new MethodScalarsAnnotationsImpl(this.highLevel())},MethodImpl}(MethodBaseImpl);exports.MethodImpl=MethodImpl;var MethodBaseScalarsAnnotationsImpl=function(_super){function MethodBaseScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(MethodBaseScalarsAnnotationsImpl,_super),MethodBaseScalarsAnnotationsImpl.prototype.protocols=function(){var attrs=this.node.attributes("protocols");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},MethodBaseScalarsAnnotationsImpl.prototype.is=function(){var attrs=this.node.attributes("is");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},MethodBaseScalarsAnnotationsImpl.prototype.securedBy=function(){var attrs=this.node.attributes("securedBy");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},MethodBaseScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},MethodBaseScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},MethodBaseScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.MethodBaseScalarsAnnotationsImpl=MethodBaseScalarsAnnotationsImpl;var MethodScalarsAnnotationsImpl=function(_super){function MethodScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(MethodScalarsAnnotationsImpl,_super),MethodScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},MethodScalarsAnnotationsImpl}(MethodBaseScalarsAnnotationsImpl);exports.MethodScalarsAnnotationsImpl=MethodScalarsAnnotationsImpl;var TraitImpl=function(_super){function TraitImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createTrait(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(TraitImpl,_super),TraitImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},TraitImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},TraitImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},TraitImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},TraitImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},TraitImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},TraitImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},TraitImpl.prototype.wrapperClassName=function(){return"TraitImpl"},TraitImpl.prototype.kind=function(){return"Trait"},TraitImpl.prototype.RAMLVersion=function(){return"RAML10"},TraitImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},TraitImpl.prototype.scalarsAnnotations=function(){return new TraitScalarsAnnotationsImpl(this.highLevel())},TraitImpl}(MethodBaseImpl);exports.TraitImpl=TraitImpl;var TraitScalarsAnnotationsImpl=function(_super){function TraitScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(TraitScalarsAnnotationsImpl,_super),TraitScalarsAnnotationsImpl.prototype.usage=function(){var attr=this.node.attr("usage");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TraitScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},TraitScalarsAnnotationsImpl}(MethodBaseScalarsAnnotationsImpl);exports.TraitScalarsAnnotationsImpl=TraitScalarsAnnotationsImpl;var ResourceTypeRefImpl=function(_super){function ResourceTypeRefImpl(){_super.apply(this,arguments)}return __extends(ResourceTypeRefImpl,_super),ResourceTypeRefImpl.prototype.wrapperClassName=function(){return"ResourceTypeRefImpl"},ResourceTypeRefImpl.prototype.kind=function(){return"ResourceTypeRef"},ResourceTypeRefImpl.prototype.RAMLVersion=function(){return"RAML10"},ResourceTypeRefImpl.prototype.resourceType=function(){return helper.referencedResourceType(this)},ResourceTypeRefImpl}(ReferenceImpl);exports.ResourceTypeRefImpl=ResourceTypeRefImpl;var ResourceBaseImpl=function(_super){function ResourceBaseImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createResourceBase(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ResourceBaseImpl,_super),ResourceBaseImpl.prototype.methods=function(){return _super.prototype.elements.call(this,"methods")},ResourceBaseImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},ResourceBaseImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",function(attr){return new ResourceTypeRefImpl(attr)})},ResourceBaseImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResourceBaseImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},ResourceBaseImpl.prototype.uriParameters_original=function(){return _super.prototype.elements.call(this,"uriParameters")},ResourceBaseImpl.prototype.wrapperClassName=function(){return"ResourceBaseImpl"},ResourceBaseImpl.prototype.kind=function(){return"ResourceBase"},ResourceBaseImpl.prototype.RAMLVersion=function(){return"RAML10"},ResourceBaseImpl.prototype.uriParameters=function(){
return helper.uriParametersPrimary(this)},ResourceBaseImpl.prototype.allUriParameters=function(){return helper.uriParameters(this)},ResourceBaseImpl.prototype.allSecuredBy=function(){return helper.allSecuredBy(this)},ResourceBaseImpl.prototype.scalarsAnnotations=function(){return new ResourceBaseScalarsAnnotationsImpl(this.highLevel())},ResourceBaseImpl}(AnnotableImpl);exports.ResourceBaseImpl=ResourceBaseImpl;var ResourceImpl=function(_super){function ResourceImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createResource(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ResourceImpl,_super),ResourceImpl.prototype.relativeUri=function(){return _super.prototype.attribute.call(this,"relativeUri",function(attr){return new RelativeUriStringImpl(attr)})},ResourceImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},ResourceImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},ResourceImpl.prototype.resources=function(){return _super.prototype.elements.call(this,"resources")},ResourceImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResourceImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},ResourceImpl.prototype.wrapperClassName=function(){return"ResourceImpl"},ResourceImpl.prototype.kind=function(){return"Resource"},ResourceImpl.prototype.RAMLVersion=function(){return"RAML10"},ResourceImpl.prototype.completeRelativeUri=function(){return helper.completeRelativeUri(this)},ResourceImpl.prototype.absoluteUri=function(){return helper.absoluteUri(this)},ResourceImpl.prototype.parentResource=function(){return helper.parent(this)},ResourceImpl.prototype.childResource=function(relPath){return helper.childResource(this,relPath)},ResourceImpl.prototype.childMethod=function(method){return helper.childMethod(this,method)},ResourceImpl.prototype.ownerApi=function(){return helper.ownerApi(this)},ResourceImpl.prototype.absoluteUriParameters=function(){return helper.absoluteUriParameters(this)},ResourceImpl.prototype.scalarsAnnotations=function(){return new ResourceScalarsAnnotationsImpl(this.highLevel())},ResourceImpl}(ResourceBaseImpl);exports.ResourceImpl=ResourceImpl;var ResourceBaseScalarsAnnotationsImpl=function(_super){function ResourceBaseScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ResourceBaseScalarsAnnotationsImpl,_super),ResourceBaseScalarsAnnotationsImpl.prototype.is=function(){var attrs=this.node.attributes("is");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ResourceBaseScalarsAnnotationsImpl.prototype.type=function(){var attr=this.node.attr("type");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceBaseScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceBaseScalarsAnnotationsImpl.prototype.securedBy=function(){var attrs=this.node.attributes("securedBy");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ResourceBaseScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.ResourceBaseScalarsAnnotationsImpl=ResourceBaseScalarsAnnotationsImpl;var ResourceScalarsAnnotationsImpl=function(_super){function ResourceScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ResourceScalarsAnnotationsImpl,_super),ResourceScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ResourceScalarsAnnotationsImpl}(ResourceBaseScalarsAnnotationsImpl);exports.ResourceScalarsAnnotationsImpl=ResourceScalarsAnnotationsImpl;var ResourceTypeImpl=function(_super){function ResourceTypeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createResourceType(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ResourceTypeImpl,_super),ResourceTypeImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},ResourceTypeImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},ResourceTypeImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},ResourceTypeImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},ResourceTypeImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},ResourceTypeImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},ResourceTypeImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},ResourceTypeImpl.prototype.wrapperClassName=function(){return"ResourceTypeImpl"},ResourceTypeImpl.prototype.kind=function(){return"ResourceType"},ResourceTypeImpl.prototype.RAMLVersion=function(){return"RAML10"},ResourceTypeImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},ResourceTypeImpl.prototype.scalarsAnnotations=function(){return new ResourceTypeScalarsAnnotationsImpl(this.highLevel())},ResourceTypeImpl}(ResourceBaseImpl);exports.ResourceTypeImpl=ResourceTypeImpl;var ResourceTypeScalarsAnnotationsImpl=function(_super){function ResourceTypeScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ResourceTypeScalarsAnnotationsImpl,_super),ResourceTypeScalarsAnnotationsImpl.prototype.displayName=function(){var attr=this.node.attr("displayName");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceTypeScalarsAnnotationsImpl.prototype.usage=function(){var attr=this.node.attr("usage");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ResourceTypeScalarsAnnotationsImpl}(ResourceBaseScalarsAnnotationsImpl);exports.ResourceTypeScalarsAnnotationsImpl=ResourceTypeScalarsAnnotationsImpl;var AnnotationRefImpl=function(_super){function AnnotationRefImpl(){_super.apply(this,arguments)}return __extends(AnnotationRefImpl,_super),AnnotationRefImpl.prototype.wrapperClassName=function(){return"AnnotationRefImpl"},AnnotationRefImpl.prototype.kind=function(){return"AnnotationRef"},AnnotationRefImpl.prototype.RAMLVersion=function(){return"RAML10"},AnnotationRefImpl.prototype.annotation=function(){return helper.referencedAnnotation(this)},AnnotationRefImpl}(ReferenceImpl);exports.AnnotationRefImpl=AnnotationRefImpl;var DocumentationItemImpl=function(_super){function DocumentationItemImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDocumentationItem(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DocumentationItemImpl,_super),DocumentationItemImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},DocumentationItemImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},DocumentationItemImpl.prototype.content=function(){return _super.prototype.attribute.call(this,"content",function(attr){return new MarkdownStringImpl(attr)})},DocumentationItemImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},DocumentationItemImpl.prototype.wrapperClassName=function(){return"DocumentationItemImpl"},DocumentationItemImpl.prototype.kind=function(){return"DocumentationItem"},DocumentationItemImpl.prototype.RAMLVersion=function(){return"RAML10"},DocumentationItemImpl.prototype.scalarsAnnotations=function(){return new DocumentationItemScalarsAnnotationsImpl(this.highLevel())},DocumentationItemImpl}(AnnotableImpl);exports.DocumentationItemImpl=DocumentationItemImpl;var DocumentationItemScalarsAnnotationsImpl=function(_super){function DocumentationItemScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(DocumentationItemScalarsAnnotationsImpl,_super),DocumentationItemScalarsAnnotationsImpl.prototype.title=function(){var attr=this.node.attr("title");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},DocumentationItemScalarsAnnotationsImpl.prototype.content=function(){var attr=this.node.attr("content");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},DocumentationItemScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.DocumentationItemScalarsAnnotationsImpl=DocumentationItemScalarsAnnotationsImpl;var FragmentDeclarationImpl=function(_super){function FragmentDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createFragmentDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(FragmentDeclarationImpl,_super),FragmentDeclarationImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},FragmentDeclarationImpl.prototype.wrapperClassName=function(){return"FragmentDeclarationImpl"},FragmentDeclarationImpl.prototype.kind=function(){return"FragmentDeclaration"},FragmentDeclarationImpl.prototype.RAMLVersion=function(){return"RAML10"},FragmentDeclarationImpl}(AnnotableImpl);exports.FragmentDeclarationImpl=FragmentDeclarationImpl;var LibraryBaseImpl=function(_super){function LibraryBaseImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createLibraryBase(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(LibraryBaseImpl,_super),LibraryBaseImpl.prototype.schemas=function(){return _super.prototype.elements.call(this,"schemas")},LibraryBaseImpl.prototype.types=function(){return _super.prototype.elements.call(this,"types")},LibraryBaseImpl.prototype.traits_original=function(){return _super.prototype.elements.call(this,"traits")},LibraryBaseImpl.prototype.resourceTypes_original=function(){return _super.prototype.elements.call(this,"resourceTypes")},LibraryBaseImpl.prototype.annotationTypes=function(){return _super.prototype.elements.call(this,"annotationTypes")},LibraryBaseImpl.prototype.securitySchemes=function(){return _super.prototype.elements.call(this,"securitySchemes")},LibraryBaseImpl.prototype.wrapperClassName=function(){return"LibraryBaseImpl"},LibraryBaseImpl.prototype.kind=function(){return"LibraryBase"},LibraryBaseImpl.prototype.RAMLVersion=function(){return"RAML10"},LibraryBaseImpl.prototype.traits=function(){return helper.traitsPrimary(this)},LibraryBaseImpl.prototype.allTraits=function(){return helper.allTraits(this)},LibraryBaseImpl.prototype.resourceTypes=function(){return helper.resourceTypesPrimary(this)},LibraryBaseImpl.prototype.allResourceTypes=function(){return helper.allResourceTypes(this)},LibraryBaseImpl}(FragmentDeclarationImpl);exports.LibraryBaseImpl=LibraryBaseImpl;var LibraryImpl=function(_super){function LibraryImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createLibrary(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(LibraryImpl,_super),LibraryImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},LibraryImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},LibraryImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},LibraryImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},LibraryImpl.prototype.wrapperClassName=function(){return"LibraryImpl"},LibraryImpl.prototype.kind=function(){return"Library"},LibraryImpl.prototype.RAMLVersion=function(){return"RAML10"},LibraryImpl.prototype.scalarsAnnotations=function(){return new LibraryScalarsAnnotationsImpl(this.highLevel())},LibraryImpl}(LibraryBaseImpl);exports.LibraryImpl=LibraryImpl;var LibraryScalarsAnnotationsImpl=function(_super){function LibraryScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(LibraryScalarsAnnotationsImpl,_super),LibraryScalarsAnnotationsImpl.prototype.usage=function(){var attr=this.node.attr("usage");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},LibraryScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.LibraryScalarsAnnotationsImpl=LibraryScalarsAnnotationsImpl;var ApiImpl=function(_super){function ApiImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createApi(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ApiImpl,_super),ApiImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},ApiImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},ApiImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ApiImpl.prototype.version=function(){return _super.prototype.attribute.call(this,"version",this.toString)},ApiImpl.prototype.setVersion=function(param){return this.highLevel().attrOrCreate("version").setValue(""+param),this},ApiImpl.prototype.baseUri=function(){return _super.prototype.attribute.call(this,"baseUri",function(attr){return new FullUriTemplateStringImpl(attr)})},ApiImpl.prototype.baseUriParameters_original=function(){return _super.prototype.elements.call(this,"baseUriParameters")},ApiImpl.prototype.protocols=function(){return _super.prototype.attributes.call(this,"protocols",this.toString)},ApiImpl.prototype.setProtocols=function(param){return this.highLevel().attrOrCreate("protocols").setValue(""+param),this},ApiImpl.prototype.mediaType=function(){return _super.prototype.attributes.call(this,"mediaType",function(attr){return new MimeTypeImpl(attr)})},ApiImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},ApiImpl.prototype.resources=function(){return _super.prototype.elements.call(this,"resources")},ApiImpl.prototype.documentation=function(){return _super.prototype.elements.call(this,"documentation")},ApiImpl.prototype.annotations=function(){return _super.prototype.attributes.call(this,"annotations",function(attr){return new AnnotationRefImpl(attr)})},ApiImpl.prototype.wrapperClassName=function(){return"ApiImpl"},ApiImpl.prototype.kind=function(){return"Api"},ApiImpl.prototype.RAMLVersion_original=function(){return"RAML10"},ApiImpl.prototype.expand=function(){return helper.expandTraitsAndResourceTypes(this)},ApiImpl.prototype.childResource=function(relPath){return helper.childResource(this,relPath)},ApiImpl.prototype.allResources=function(){return helper.allResources(this)},ApiImpl.prototype.baseUriParameters=function(){return helper.baseUriParametersPrimary(this)},ApiImpl.prototype.allBaseUriParameters=function(){return helper.baseUriParameters(this)},ApiImpl.prototype.allProtocols=function(){return helper.allProtocols(this)},ApiImpl.prototype.RAMLVersion=function(){return helper.RAMLVersion(this)},ApiImpl.prototype.scalarsAnnotations=function(){return new ApiScalarsAnnotationsImpl(this.highLevel())},ApiImpl}(LibraryBaseImpl);exports.ApiImpl=ApiImpl;var OverlayImpl=function(_super){function OverlayImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOverlay(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OverlayImpl,_super),OverlayImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},OverlayImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},OverlayImpl.prototype.extends=function(){return _super.prototype.attribute.call(this,"extends",this.toString)},OverlayImpl.prototype.setExtends=function(param){return this.highLevel().attrOrCreate("extends").setValue(""+param),this},OverlayImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},OverlayImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},OverlayImpl.prototype.wrapperClassName=function(){return"OverlayImpl"},OverlayImpl.prototype.kind=function(){return"Overlay"},OverlayImpl.prototype.RAMLVersion=function(){return"RAML10"},OverlayImpl.prototype.scalarsAnnotations=function(){return new OverlayScalarsAnnotationsImpl(this.highLevel())},OverlayImpl}(ApiImpl);exports.OverlayImpl=OverlayImpl;var ApiScalarsAnnotationsImpl=function(_super){function ApiScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ApiScalarsAnnotationsImpl,_super),ApiScalarsAnnotationsImpl.prototype.title=function(){var attr=this.node.attr("title");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ApiScalarsAnnotationsImpl.prototype.description=function(){var attr=this.node.attr("description");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ApiScalarsAnnotationsImpl.prototype.version=function(){var attr=this.node.attr("version");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ApiScalarsAnnotationsImpl.prototype.baseUri=function(){var attr=this.node.attr("baseUri");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ApiScalarsAnnotationsImpl.prototype.protocols=function(){var attrs=this.node.attributes("protocols");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ApiScalarsAnnotationsImpl.prototype.mediaType=function(){var attrs=this.node.attributes("mediaType");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ApiScalarsAnnotationsImpl.prototype.securedBy=function(){var attrs=this.node.attributes("securedBy");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ApiScalarsAnnotationsImpl.prototype.annotations=function(){var attrs=this.node.attributes("annotations");return attrs.map(function(x){var annotationAttrs=x.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result})},ApiScalarsAnnotationsImpl}(AnnotableScalarsAnnotationsImpl);exports.ApiScalarsAnnotationsImpl=ApiScalarsAnnotationsImpl;var OverlayScalarsAnnotationsImpl=function(_super){function OverlayScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(OverlayScalarsAnnotationsImpl,_super),OverlayScalarsAnnotationsImpl.prototype.usage=function(){var attr=this.node.attr("usage");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OverlayScalarsAnnotationsImpl.prototype.extends=function(){var attr=this.node.attr("extends");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OverlayScalarsAnnotationsImpl.prototype.title=function(){var attr=this.node.attr("title");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},OverlayScalarsAnnotationsImpl}(ApiScalarsAnnotationsImpl);exports.OverlayScalarsAnnotationsImpl=OverlayScalarsAnnotationsImpl;var ExtensionImpl=function(_super){function ExtensionImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createExtension(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(ExtensionImpl,_super),ExtensionImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},ExtensionImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},ExtensionImpl.prototype.extends=function(){return _super.prototype.attribute.call(this,"extends",this.toString)},ExtensionImpl.prototype.setExtends=function(param){return this.highLevel().attrOrCreate("extends").setValue(""+param),this},ExtensionImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},ExtensionImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},ExtensionImpl.prototype.wrapperClassName=function(){return"ExtensionImpl"},ExtensionImpl.prototype.kind=function(){return"Extension"},ExtensionImpl.prototype.RAMLVersion=function(){return"RAML10"},ExtensionImpl.prototype.scalarsAnnotations=function(){return new ExtensionScalarsAnnotationsImpl(this.highLevel())},ExtensionImpl}(ApiImpl);exports.ExtensionImpl=ExtensionImpl;var ExtensionScalarsAnnotationsImpl=function(_super){function ExtensionScalarsAnnotationsImpl(){_super.apply(this,arguments)}return __extends(ExtensionScalarsAnnotationsImpl,_super),ExtensionScalarsAnnotationsImpl.prototype.usage=function(){var attr=this.node.attr("usage");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ExtensionScalarsAnnotationsImpl.prototype.extends=function(){var attr=this.node.attr("extends");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ExtensionScalarsAnnotationsImpl.prototype.title=function(){var attr=this.node.attr("title");if(null==attr)return[];var annotationAttrs=attr.annotations(),result=core.attributesToValues(annotationAttrs,function(a){return new AnnotationRefImpl(a)});return result},ExtensionScalarsAnnotationsImpl}(ApiScalarsAnnotationsImpl);exports.ExtensionScalarsAnnotationsImpl=ExtensionScalarsAnnotationsImpl,exports.loadApiSync=loadApiSync,exports.loadRAMLSync=loadRAMLSync,exports.loadApi=loadApi,exports.loadRAML=loadRAML,exports.getLanguageElementByRuntimeType=getLanguageElementByRuntimeType},function(module,exports,__webpack_require__){"use strict";var globalEmptyOpt,invariant=__webpack_require__(67),exists=function(v){return null!=v},Opt=function(){function Opt(_value){var _this=this;this._value=_value,this._isDefined=!1,this._isEmpty=!0,this._arr=void 0,this.getOrThrow=function(){return invariant(_this._isDefined,"Opt is empty. Use `Opt#getOrElse` or check `Opt#isDefined`."),_this._value},this.value=function(){return _this._value},this.isDefined=function(){return _this._isDefined},this.isEmpty=function(){return _this._isEmpty},this.toArray=function(){return _this._arr||(_this._arr=_this._isDefined?[_this._value]:[])},this.getOrElse=function(v){return _this._isDefined?_this._value:v},this.getOrElseF=function(v){return _this._isDefined?_this._value:v()},this.map=function(f){return _this._isEmpty?Opt.empty():new Opt(f(_this._value))},this.flatMap=function(f){return _this.map(f).getOrElse(Opt.empty())},this.equals=function(other){return invariant(other instanceof Opt,"Expected other to be an `Opt`, but got `%s`",typeof other),_this._isDefined===other.isDefined()&&_this._value===other.value()},exists(this._value)&&(this._isDefined=!0,this._isEmpty=!1)}return Opt.prototype.forEach=function(fn){this.isDefined()&&fn(this._value)},Opt.empty=function(){return globalEmptyOpt||(globalEmptyOpt=new Opt)},Opt}();module.exports=Opt},function(module,exports,__webpack_require__){"use strict";var ramlDs=__webpack_require__(36);module.exports=ramlDs.universesInfo},function(module,exports,__webpack_require__){"use strict";function globalDeclarations(h){for(var result=[],visitedUnits={};null!=h.parent();)h.lowLevel().includePath()&&(result=result.concat(findDeclarations(h,visitedUnits))),h=h.parent();return result=result.concat(findDeclarations(h,visitedUnits))}function getUserDefinedPropertySource(property){var result=property.node();if(result&&hl.isParseResult(result))return result;var sourceProvider=sourceFinder.getNominalPropertySource2(property);return sourceProvider?sourceProvider.getSource():null}function findDeclarations(h,visitedUnits,rs){void 0===visitedUnits&&(visitedUnits={}),void 0===rs&&(rs=[]);var aPath=h.lowLevel().unit().absolutePath();if(visitedUnits[aPath]=!0,!(h instanceof hlimpl.ASTNodeImpl))return rs;var skipAll=!1;return h.elements().forEach(function(x){if(x.definition().key()==universes.Universe10.UsesDeclaration){if(skipAll)return;var mm=x.attr("value");if(mm){var unit=x.root().lowLevel().unit().resolve(mm.value());if(unit&&resourceRegistry.isWaitingFor(unit.absolutePath()))return void(skipAll=!0);null!=unit&&unit.isRAMLUnit()&&!visitedUnits[unit.absolutePath()]&&unit.highLevel().isElement()&&findDeclarations(unit.highLevel().asElement(),visitedUnits,rs)}}else rs.push(x)}),rs}function getIndent2(offset,text){for(var spaces="",i=offset-1;i>=0;i--){var c=text.charAt(i);if(" "==c||"\t"==c)spaces?spaces+=c:spaces=c;else if("\r"==c||"\n"==c)return spaces}}function deepFindNode(n,offset,end,goToOtherUnits,returnAttrs){if(void 0===goToOtherUnits&&(goToOtherUnits=!0),void 0===returnAttrs&&(returnAttrs=!0),null==n)return null;if(n.lowLevel()&&n.lowLevel().start()<=offset&&n.lowLevel().end()>=end){if(n instanceof hlimpl.ASTNodeImpl){for(var hn=n,all=goToOtherUnits?hn.children():hn.directChildren(),i=0;i<all.length;i++)if(goToOtherUnits||all[i].lowLevel().unit()==n.lowLevel().unit()){var node=deepFindNode(all[i],offset,end,goToOtherUnits);if(node)return!returnAttrs&&node instanceof hlimpl.ASTPropImpl&&(node=node.parent()),node}return n}if(n instanceof hlimpl.ASTPropImpl){var attr=n;if(!attr.property().isKey()){var vl=attr.value();if(vl instanceof hlimpl.StructuredValue){var st=vl,hl=st.toHighLevel2();if(hl&&!goToOtherUnits&&hl.lowLevel().unit()!=n.lowLevel().unit())return null;var node=deepFindNode(hl,offset,end,goToOtherUnits);if(node)return!returnAttrs&&node instanceof hlimpl.ASTPropImpl&&(node=node.parent()),node}return returnAttrs?attr:attr.parent()}return null}return null}return null}function getValueAt(text,offset){for(var sp=-1,i=offset-1;i>=0;i--){var c=text.charAt(i);if("\r"==c||"\n"==c||" "==c||"\t"==c||'"'==c||"'"==c||":"==c){sp=i+1;break}}for(var ep=-1,i=offset;i<text.length;i++){var c=text.charAt(i);if("\r"==c||"\n"==c||" "==c||"\t"==c||'"'==c||"'"==c||":"==c){ep=i;break}}return sp!=-1&&ep!=-1?text.substring(sp,ep):""}function extractName(cleaned,offset){for(var txt="",i=offset;i>=0;i--){var c=cleaned[i];if(" "==c||"\r"==c||"\n"==c||"|"==c||"["==c||"]"==c||":"==c||"("==c||")"==c)break;txt=c+txt}for(var i=offset+1;i<cleaned.length;i++){var c=cleaned[i];if(" "==c||"\r"==c||"\n"==c||"|"==c||"["==c||"]"==c||":"==c||"("==c||")"==c)break;txt+=c}return txt}function findUsages(unit,offset){var decl=findDeclaration(unit,offset);if(decl){if(decl instanceof hlimpl.ASTNodeImpl){var hnode=decl;return{node:hnode,results:hnode.findReferences()}}decl instanceof hlimpl.ASTPropImpl}var node=deepFindNode(hlimpl.fromUnit(unit),offset,offset,!1);if(node instanceof hlimpl.ASTNodeImpl)return{node:node,results:node.findReferences()};if(node instanceof hlimpl.ASTPropImpl){var prop=node;if(prop.property().canBeValue())return{node:prop.parent(),results:prop.parent().findReferences()}}return{node:null,results:[]}}function referenceTargets(p0,c){var p=p0;if(p.getAdapter(ramlServices.RAMLPropertyService).isTypeExpr()){var definitionNodes=globalDeclarations(c).filter(function(node){var nc=node.definition().key();return nc===universes.Universe08.GlobalSchema||node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)});return definitionNodes}if(p.getAdapter(ramlServices.RAMLPropertyService).isDescriminating()){var subTypes=nodesDeclaringType(p.range(),c);return subTypes}if(p.isReference()){var rt=p.referencesTo(),subTypes=nodesDeclaringType(rt,c);return subTypes}if(p.range().hasValueTypeInHierarchy()){var vt=p.range().getAdapter(ramlServices.RAMLService);if(vt.globallyDeclaredBy().length>0){var definitionNodes=globalDeclarations(c).filter(function(z){return null!=_.find(vt.globallyDeclaredBy(),function(x){return x==z.definition()})});return definitionNodes}}return[]}function enumValues(p,c){if(c){var rs=[];if(p.getAdapter(ramlServices.RAMLPropertyService).isTypeExpr()){var definitionNodes=globalDeclarations(c).filter(function(node){var nc=node.definition().key();return nc===universes.Universe08.GlobalSchema||node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)});rs=definitionNodes.map(function(x){return hlimpl.qName(x,c)});var de=c.definition().universe().type(universes.Universe10.TypeDeclaration.name);if(de){var subTypes=de.allSubTypes();rs=rs.concat(subTypes.map(function(x){return x.getAdapter(ramlServices.RAMLService).descriminatorValue()}))}return rs}var rangeKey=p.range().key();if((rangeKey==universes.Universe08.SchemaString||rangeKey==universes.Universe10.SchemaString)&&"RAML10"==p.range().universe().version()&&p.range().hasValueTypeInHierarchy()){var definitionNodes=globalDeclarations(c).filter(function(node){return node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)});rs=definitionNodes.map(function(x){return hlimpl.qName(x,c)})}if(p.getAdapter(ramlServices.RAMLPropertyService).isDescriminating()){var subTypes=subTypesWithLocals(p.domain(),c);rs=rs.concat(subTypes.map(function(x){return x.getAdapter(ramlServices.RAMLService).descriminatorValue();
}))}else if(p.isReference())rs=nodesDeclaringType(p.referencesTo(),c).map(function(x){return hlimpl.qName(x,c)});else if(p.range().hasValueTypeInHierarchy()){var vt=p.range().getAdapter(ramlServices.RAMLService);if(vt.globallyDeclaredBy().length>0){var definitionNodes=globalDeclarations(c).filter(function(z){return null!=_.find(vt.globallyDeclaredBy(),function(x){return x==z.definition()})});rs=rs.concat(definitionNodes.map(function(x){return hlimpl.qName(x,c)}))}}return p.isAllowNull()&&rs.push("null"),p.enumOptions()&&(rs=rs.concat(p.enumOptions())),rs}return p.enumOptions()&&"string"==typeof p.enumOptions()?[p.enumOptions()+""]:p.enumOptions()}function getLibraryName(node){return node.isElement()&&node.asElement().definition().key()!=universes.Universe10.Library?null:node.asElement().attrValue("name")}function findDeclarationByNode(node,nodePart){var unit=node.lowLevel().unit();if(!unit)return null;var start=node.lowLevel().start(),end=node.lowLevel().end();if(nodePart&&nodePart==LocationKind.KEY_COMPLETION?(start=node.lowLevel().keyStart(),end=node.lowLevel().keyEnd()):nodePart&&nodePart==LocationKind.VALUE_COMPLETION&&(start=node.lowLevel().valueStart(),end=node.lowLevel().valueEnd()),start==-1||end==-1)return null;var offset=Math.floor((start+end)/2);return findDeclaration(unit,offset,nodePart)}function findDeclaration(unit,offset,nodePart){var node=deepFindNode(hlimpl.fromUnit(unit),offset,offset,!1),result=null;if(node.isElement()&&node.asElement().definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&node.asElement().directChildren().forEach(function(x){if(x.isUnknown()&&x.getLowLevelStart()<offset&&x.getLowLevelEnd()>offset){var tp=node.asElement().localType();tp.allFacets().forEach(function(f){if(f.nameId()==x.lowLevel().key()&&f instanceof def.UserDefinedProp){var up=getUserDefinedPropertySource(f);result=up}})}}),!node.property())return node;if("example"==node.property().nameId()){node.parent().localType();node.lowLevel().children().forEach(function(y){"example"==y.key()&&y.children().forEach(function(x){if(x.start()<offset&&x.end()>offset){var tp=node.parent().asElement().localType();tp.allProperties().forEach(function(f){if(f.nameId()==x.key()&&f instanceof def.UserDefinedProp){var up=getUserDefinedPropertySource(f);result=up}})}})})}if(result)return result;var kind=null!=nodePart?nodePart:determineCompletionKind(unit.contents(),offset);if(kind==LocationKind.VALUE_COMPLETION){var hlnode=node;if(node instanceof hlimpl.ASTPropImpl){var attr=node;if(attr&&attr.value()){if(!(attr.value()instanceof hlimpl.StructuredValue))return searchInTheValue(offset,unit.contents(),attr,hlnode);var sval=attr.value(),hlvalue=sval.toHighLevel();if(hlvalue){var newAttr=_.find(hlvalue.attrs(),function(x){return x.lowLevel().start()<offset&&x.lowLevel().end()>=offset});if(newAttr)return searchInTheValue(offset,unit.contents(),newAttr,hlvalue,attr.property())}}}else{var nodeProperty=hlnode.property();if(nodeProperty)return searchInTheValue(offset,unit.contents(),null,hlnode,nodeProperty)}}if(kind==LocationKind.KEY_COMPLETION||kind==LocationKind.SEQUENCE_KEY_COPLETION){var hlnode=node,pp=node.property();if(pp instanceof defs.UserDefinedProp){var up=pp;return getUserDefinedPropertySource(up)}if(node instanceof hlimpl.ASTNodeImpl&&hlnode.definition()instanceof defs.UserDefinedClass){var uc=hlnode.definition();return uc.isAssignableFrom("TypeDeclaration")?node:uc.getAdapter(ramlServices.RAMLService).getDeclaringNode()}if(node instanceof hlimpl.ASTPropImpl){var pr=node;if(isExampleNodeContent(pr)){var contentType=findExampleContentType(pr);if(contentType){var documentationRoot=parseDocumentationContent(pr,contentType);if(documentationRoot){var node=deepFindNode(documentationRoot,offset,offset);if(pp=node.property(),pp instanceof defs.UserDefinedProp){var up=pp;return getUserDefinedPropertySource(up)}if(node instanceof hlimpl.ASTNodeImpl&&hlnode.definition()instanceof defs.UserDefinedClass){var uc=hlnode.definition();return uc.getAdapter(ramlServices.RAMLService).getDeclaringNode()}}}}}}if(kind==LocationKind.PATH_COMPLETION){var inclpath=getValueAt(unit.contents(),offset);if(inclpath){var ap=unit.resolve(inclpath);return ap}}}function findExampleContentType(node){var potentialTypeNode=null;if(node.isElement()?potentialTypeNode=node:node.isAttr()&&(potentialTypeNode=node.parent()),!potentialTypeNode.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)){var parent=potentialTypeNode.parent();if(!parent)return null;if(parent.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name))potentialTypeNode=parent;else{if(parent=parent.parent(),null==parent)return null;if(!parent.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name))return null;potentialTypeNode=parent}}return potentialTypeNode.localType()}function parseDocumentationContent(attribute,type){return attribute.value()instanceof hlimpl.StructuredValue?new hlimpl.ASTNodeImpl(attribute.value().lowLevel(),attribute.parent(),type,attribute.property()):null}function parseStructuredExample(exampleNode,type){return new hlimpl.ASTNodeImpl(exampleNode.lowLevel(),exampleNode,type,exampleNode.property())}function isExampleNode(node){return node.definition().key()==universes.Universe10.ExampleSpec}function isExampleNodeContent(node){var typeExampleName10=universes.Universe10.TypeDeclaration.properties.example.name,objectName10=universes.Universe10.ObjectTypeDeclaration.name;if(!(node instanceof hlimpl.ASTPropImpl))return!1;var property=node,parent=property.parent(),parentProperty=parent&&parent.property();parentProperty&&parentProperty.nameId();return!!(typeExampleName10===property.name()&&property.isString()&&parent instanceof hlimpl.ASTNodeImpl&&parent.definition().isAssignableFrom(objectName10))}function determineCompletionKind(text,offset){for(var hasIn=!1,hasSeq=!1,canBeAnnotation=!1,i=offset-1;i>=0;i--){var c=text.charAt(i);if("("==c)canBeAnnotation=!0;else{if(canBeAnnotation){if("\r"==c||"\n"==c){for(var hasClosing=!1,j=offset-1;j<text.length;j++){var ch=text[j];if(")"==ch&&(hasClosing=!0),"\r"==ch||"\n"==ch)break;if(":"==ch){canBeAnnotation=!1;break}}if(canBeAnnotation&&hasClosing)return LocationKind.ANNOTATION_COMPLETION;break}if(" "==c||"\t"==c)continue;break}if("\r"==c||"\n"==c)break;if(":"==c)break}}for(var i=offset-1;i>=0;i--){var c=text.charAt(i);if("#"==c){if(0==i)return LocationKind.VERSION_COMPLETION;for(var j=i-1;j>=0;j--){var currentChar=text.charAt(j);if("\r"==currentChar||"\n"==currentChar)break;if("!"==currentChar&&text.indexOf("!include",j)==j)return LocationKind.PATH_COMPLETION}return LocationKind.INCOMMENT}if(":"==c)return hasIn?LocationKind.DIRECTIVE_COMPLETION:LocationKind.VALUE_COMPLETION;if("\r"==c||"\n"==c){for(var insideOfMultiline=!1,ind=getIndent2(offset,text),a=i;a>0;a--){if(c=text.charAt(a),":"==c){if(insideOfMultiline){var ll=getIndent2(a,text);if(ll.length<ind.length)return LocationKind.VALUE_COMPLETION}break}"|"!=c?("\r"!=c&&"\n"!=c||(insideOfMultiline=!1)," "!=c&&"\t"!=c&&(insideOfMultiline=!1)):insideOfMultiline=!0}return hasSeq?LocationKind.SEQUENCE_KEY_COPLETION:LocationKind.KEY_COMPLETION}if("-"==c&&(hasSeq=!0),"!"==c){if(text.indexOf("!include",i)==i)return LocationKind.PATH_COMPLETION;text.indexOf("!i",i)==i&&(hasIn=!0)}}}function resolveReference(point,path){if(!path)return null;for(var sp=path.split("/"),result=point,i=0;i<sp.length;i++)if("#"!=sp[i]){if(result=_.find(result.children(),function(x){return x.key()==sp[i]}),!result)return null}else result=point.unit().ast();return result}function subTypesWithLocals(range,parentNode){if(null==range)return[];var name=range.nameId();parentNode=exports.declRoot(parentNode);var actual=parentNode;if(actual._subTypesCache){var cached=actual._subTypesCache[name];if(cached)return cached}else actual._subTypesCache={};var result=range.allSubTypes();if(range.getAdapter(ramlServices.RAMLService).getRuntimeExtenders().length>0&&parentNode){var decls=globalDeclarations(parentNode),extenders=range.getAdapter(ramlServices.RAMLService).getRuntimeExtenders();parentNode.root();extenders.forEach(function(x){var definitionNodes=decls.filter(function(z){var def=z.definition().allSuperTypes();def.push(z.definition());var rr=z.definition()==x||null!=_.find(def,function(d){return d==x})||null!=_.find(def,function(d){return d==range});return rr});result=result.concat(definitionNodes.map(function(x){return x.localType()}))})}return result=_.unique(result),actual._subTypesCache[name]=result,result}function subTypesWithName(tname,parentNode,backup){parentNode=exports.declRoot(parentNode);var decls=globalDeclarations(parentNode),declNode=_.find(decls,function(x){return hlimpl.qName(x,parentNode)==tname&&x.property()&&x.property().nameId()==universes.Universe10.LibraryBase.properties.types.name});return declNode.localType()}function schemasWithName(tname,parentNode,backup){parentNode=exports.declRoot(parentNode);var decls=globalDeclarations(parentNode),declNode=_.find(decls,function(x){return hlimpl.qName(x,parentNode)==tname&&x.property()&&x.property().nameId()==universes.Universe10.LibraryBase.properties.schemas.name});return declNode.localType()}function nodesDeclaringType(range,n){var result=[],extenders=[range].concat(range.getAdapter(ramlServices.RAMLService).getRuntimeExtenders());if(n){var root=n;extenders.forEach(function(x){var definitionNodes=globalDeclarations(root).filter(function(z){return z.definition().isAssignableFrom(x.nameId())});result=result.concat(definitionNodes)})}var isElementType=!range.hasValueTypeInHierarchy();if(isElementType&&range.getAdapter(ramlServices.RAMLService).isInlinedTemplates()&&n){var root=n,definitionNodes=globalDeclarations(root).filter(function(z){return z.definition()==range});result=result.concat(definitionNodes)}else{var root=n,q={};range.allSubTypes().forEach(function(x){return q[x.nameId()]=!0}),q[range.nameId()]=!0;var definitionNodes=globalDeclarations(root).filter(function(z){return q[z.definition().nameId()]});result=result.concat(definitionNodes)}return result}function findAllSubTypes(p,n){var range=p.range();return subTypesWithLocals(range,n)}function possibleNodes(p,c){if(c){if(p.isDescriminator()){var range=p.range(),extenders=range.getAdapter(ramlServices.RAMLService).getRuntimeExtenders();if(extenders.length>0&&c){var result=[];return extenders.forEach(function(x){var definitionNodes=globalDeclarations(c).filter(function(z){return z.definition()==x});result=result.concat(definitionNodes)}),result}return[]}if(p.isReference())return nodesDeclaringType(p.referencesTo(),c);if(p.range().hasValueTypeInHierarchy()){var vt=p.range().getAdapter(ramlServices.RAMLService);if(vt.globallyDeclaredBy&&vt.globallyDeclaredBy().length>0){var definitionNodes=globalDeclarations(c).filter(function(z){return null!=_.find(vt.globallyDeclaredBy(),function(x){return x==z.definition()})});return definitionNodes}}}return[]}function allChildren(node){var res=[];return gather(node,res),res}function gather(node,result){node.children().forEach(function(x){result.push(x),gather(x,result)})}function refFinder(root,node,result){root.elements().forEach(function(x){refFinder(x,node,result);x.definition()}),root.attrs().forEach(function(a){var pr=a.property(),vl=a.value();if(pr instanceof defs.UserDefinedProp){var up=pr.node();up==node?result.push(a):up.lowLevel().start()==node.lowLevel().start()&&up.lowLevel().unit()==node.lowLevel().unit()&&result.push(a)}if(isExampleNodeContent(a)){var contentType=findExampleContentType(a);if(contentType){var documentationRoot=parseDocumentationContent(a,contentType);documentationRoot&&refFinder(documentationRoot,node,result)}}else if(pr.getAdapter(ramlServices.RAMLPropertyService).isTypeExpr()&&"string"==typeof vl){var tpa=root.localType();testUsage(tpa,a,node,result);var libraryName=getLibraryName(node);if(libraryName&&vl.indexOf(libraryName)!=-1){var referencingLibrary=getLibraryDefiningNode(a);referencingLibrary&&referencingLibrary.lowLevel().start()==node.lowLevel().start()&&result.push(a)}}if(pr.isReference()||pr.isDescriminator())if("string"==typeof vl){var pn=possibleNodes(pr,root);_.find(pn,function(x){return x.name()==vl&&x==node})&&result.push(a);var libraryName=getLibraryName(node);if(libraryName&&vl.indexOf(libraryName)!=-1){var referencingLibrary=getLibraryDefiningNode(a);referencingLibrary&&referencingLibrary.lowLevel().start()==node.lowLevel().start()&&result.push(a)}}else{var st=vl;if(st){var vn=st.valueName(),pn=possibleNodes(pr,root);_.find(pn,function(x){return x.name()==vn&&x==node})&&result.push(a);var hnode=st.toHighLevel();hnode&&refFinder(hnode,node,result);var libraryName=getLibraryName(node);if(libraryName&&vn.indexOf(libraryName)!=-1){var referencingLibrary=getLibraryDefiningNode(hnode);referencingLibrary&&referencingLibrary.lowLevel().start()==node.lowLevel().start()&&result.push(a)}}}else{var pn=possibleNodes(pr,root);_.find(pn,function(x){return x.name()==vl&&x==node})&&result.push(a)}})}function getLibraryDefiningNode(nodeToCheck){if(!nodeToCheck.lowLevel)return null;var lowLevelNode=nodeToCheck.lowLevel();if(!lowLevelNode)return null;if(lowLevelNode.key()){var offset=Math.floor((lowLevelNode.keyEnd()+lowLevelNode.keyStart())/2),result=getLibraryDefiningNodeByOffset(lowLevelNode.unit(),offset);if(result)return result}if(lowLevelNode.value()){var offset=Math.floor((lowLevelNode.valueEnd()+lowLevelNode.valueStart())/2),result=getLibraryDefiningNodeByOffset(lowLevelNode.unit(),offset);if(result)return result}return null}function getLibraryDefiningNodeByOffset(unit,offset){var declaration=findDeclaration(unit,offset);if(declaration&&declaration.isElement&&declaration.isElement())for(var declarationNode=declaration.asElement(),parent=declarationNode;parent;){if(parent.definition().key()==universes.Universe10.Library)return parent;parent=parent.parent()}return null}var defs=__webpack_require__(36),hl=__webpack_require__(10),_=__webpack_require__(61),def=__webpack_require__(36),hlimpl=__webpack_require__(16),universes=__webpack_require__(22),ramlServices=def,sourceFinder=__webpack_require__(46),resourceRegistry=__webpack_require__(28);exports.declRoot=function(h){for(var declRoot=h;;){if(declRoot.definition().key()==universes.Universe10.Library)break;var np=declRoot.parent();if(!np)break;declRoot=np}return declRoot},exports.globalDeclarations=globalDeclarations,exports.findDeclarations=findDeclarations,exports.deepFindNode=deepFindNode,exports.extractName=extractName;var searchInTheValue=function(offset,content,attr,hlnode,p){void 0===p&&(p=attr.property());var targets=referenceTargets(p,hlnode),txt=extractName(content,offset),t=_.find(targets,function(x){return hlimpl.qName(x,hlnode)==txt});if(t)return t;if(p instanceof defs.UserDefinedProp){var up=p;return getUserDefinedPropertySource(up)}return null};exports.findUsages=findUsages,exports.referenceTargets=referenceTargets,exports.enumValues=enumValues,exports.findDeclarationByNode=findDeclarationByNode,exports.findDeclaration=findDeclaration,exports.findExampleContentType=findExampleContentType,exports.parseDocumentationContent=parseDocumentationContent,exports.parseStructuredExample=parseStructuredExample,exports.isExampleNode=isExampleNode,exports.isExampleNodeContent=isExampleNodeContent,exports.determineCompletionKind=determineCompletionKind,function(LocationKind){LocationKind[LocationKind.VALUE_COMPLETION=0]="VALUE_COMPLETION",LocationKind[LocationKind.KEY_COMPLETION=1]="KEY_COMPLETION",LocationKind[LocationKind.PATH_COMPLETION=2]="PATH_COMPLETION",LocationKind[LocationKind.DIRECTIVE_COMPLETION=3]="DIRECTIVE_COMPLETION",LocationKind[LocationKind.VERSION_COMPLETION=4]="VERSION_COMPLETION",LocationKind[LocationKind.ANNOTATION_COMPLETION=5]="ANNOTATION_COMPLETION",LocationKind[LocationKind.SEQUENCE_KEY_COPLETION=6]="SEQUENCE_KEY_COPLETION",LocationKind[LocationKind.INCOMMENT=7]="INCOMMENT"}(exports.LocationKind||(exports.LocationKind={}));var LocationKind=exports.LocationKind;exports.resolveReference=resolveReference,exports.subTypesWithLocals=subTypesWithLocals,exports.subTypesWithName=subTypesWithName,exports.schemasWithName=schemasWithName,exports.nodesDeclaringType=nodesDeclaringType,exports.findAllSubTypes=findAllSubTypes,exports.allChildren=allChildren;var testUsage=function(ck,x,node,result){var tp=ck.getAdapter(ramlServices.RAMLService).getDeclaringNode();if(tp&&node.isSameNode(tp))return void result.push(x);if(ck.isArray()&&testUsage(ck.array().componentType(),x,node,result),ck.isUnion()){var uni=ck.union();testUsage(uni.leftType(),x,node,result),testUsage(uni.rightType(),x,node,result)}ck.superTypes().some(function(x){return x.nameId()==node.name()})&&result.push(x)};exports.refFinder=refFinder},function(module,exports,__webpack_require__){"use strict";function expandTraitsAndResourceTypes(api){return api instanceof RamlWrapperImpl.ApiImpl||api instanceof RamlWrapper08Impl.ApiImpl?(new TraitsAndResourceTypesExpander).expandTraitsAndResourceTypes(api):null}function mergeAPIs(masterUnit,extensionsAndOverlays,mergeMode){var masterApi=hlimpl.fromUnit(masterUnit);if(!masterApi)throw new Error("couldn't load api from "+masterUnit.absolutePath());if(!extensionsAndOverlays||0==extensionsAndOverlays.length)return masterApi;for(var highLevelNodes=[],i=0;i<extensionsAndOverlays.length;i++){var unit=extensionsAndOverlays[i],hlNode=hlimpl.fromUnit(unit);if(!hlNode)throw new Error("couldn't load api from "+unit.absolutePath());highLevelNodes.push(hlNode)}var lastExtensionOrOverlay=mergeHighLevelNodes(masterApi,highLevelNodes,mergeMode);return lastExtensionOrOverlay}function mergeHighLevelNodes(masterApi,highLevelNodes,mergeMode){var currentMaster=masterApi;return highLevelNodes.forEach(function(currentApi){currentApi.overrideMaster(currentMaster),currentApi.setMergeMode(mergeMode),currentMaster=currentApi}),currentMaster}function toUnits1(nodes){for(var result=[],_i=0,nodes_1=nodes;_i<nodes_1.length;_i++){var n=nodes_1[_i];toUnits2(result,n,!0)}return result}function toUnits2(chainStart,node,append){void 0===append&&(append=!1);var result=append?chainStart:chainStart.concat([]),unit=node.lowLevel().unit();if(null==unit)return result;if(0==result.length)result.push(unit);else{var prevPath=result[result.length-1].absolutePath();unit.absolutePath()!=prevPath&&result.push(unit)}return result}function toUnits(node){for(var nodes=[];node;)nodes.push(node),node=node.parent();return toUnits1(nodes)}function getTransformNames(){return transformers.map(function(transformer){return transformer.name})}function getTransformerForOccurence(occurence){for(var result,i=0;i<transformers.length;i++)if(occurence.match(transformers[i].regexp)){result=transformers[i].transformer;break}return result}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},hl=__webpack_require__(10),hlimpl=__webpack_require__(16),yaml=__webpack_require__(70),util=__webpack_require__(31),proxy=__webpack_require__(38),RamlWrapperImpl=__webpack_require__(20),RamlWrapper08Impl=__webpack_require__(47),wrapperHelper=__webpack_require__(32),wrapperHelper08=__webpack_require__(48),pluralize=__webpack_require__(72),universeDef=__webpack_require__(22),_=__webpack_require__(61),referencePatcher=__webpack_require__(49),changeCase=__webpack_require__(71);exports.expandTraitsAndResourceTypes=expandTraitsAndResourceTypes,exports.mergeAPIs=mergeAPIs;var TraitsAndResourceTypesExpander=function(){function TraitsAndResourceTypesExpander(){}return TraitsAndResourceTypesExpander.prototype.expandTraitsAndResourceTypes=function(api){var _this=this;if(api.definition().key()==universeDef.Universe10.Overlay)return api;this.ramlVersion=api.highLevel().definition().universe().version();var isRAML1=api instanceof RamlWrapperImpl.ApiImpl;this.globalTraits="RAML10"==this.ramlVersion?wrapperHelper.allTraits(api):wrapperHelper08.allTraits(api),this.globalResourceTypes="RAML10"==this.ramlVersion?wrapperHelper.allResourceTypes(api):wrapperHelper08.allResourceTypes(api);var unit=api.highLevel().lowLevel().unit(),hasFragments=unit.project().namespaceResolver().hasFragments(unit),hasTemplates=0!=this.globalTraits.length||0!=this.globalResourceTypes.length;if(!hasTemplates&&!hasFragments)return api;var hlNode=this.createHighLevelNode(api.highLevel()),result=hlNode.wrapperNode();result.setAttributeDefaults(api.getDefaultsCalculator().isEnabled()),this.traitMap={},this.resourceTypeMap={},result.highLevel().setMergeMode(api.highLevel().getMergeMode());var resources=result.resources();return resources.forEach(function(x){return _this.processResource(x)}),isRAML1&&(new referencePatcher.ReferencePatcher).process(hlNode),result},TraitsAndResourceTypesExpander.prototype.getTemplate=function(name,context,cache,globalList){var unitPath=context.lowLevel().unit().path(),unitCache=cache[unitPath];unitCache||(unitCache={},cache[unitPath]=unitCache);var val=unitCache[name];return void 0!==val?val:(val=null,val=_.find(globalList,function(x){return hlimpl.qName(x.highLevel(),context)==name}),val||(val=null),unitCache[name]=val,val)},TraitsAndResourceTypesExpander.prototype.createHighLevelNode=function(_api,merge){void 0===merge&&(merge=!0);for(var api=_api,highLevelNodes=[],node=api;node;){var llNode=node.lowLevel(),topComposite=new proxy.LowLevelCompositeNode(llNode,null,null,this.ramlVersion),nodeType=node.definition(),newNode=new hlimpl.ASTNodeImpl(topComposite,null,nodeType,null);if(highLevelNodes.push(newNode),!merge)break;node=node.getMaster()}var masterApi=highLevelNodes.pop();highLevelNodes=highLevelNodes.reverse();var mergeMode=api.getMergeMode();return mergeHighLevelNodes(masterApi,highLevelNodes,mergeMode)},TraitsAndResourceTypesExpander.prototype.processResource=function(resource){var _this=this,resourceData=this.collectResourceData(resource,resource),resourceLowLevel=resource.highLevel().lowLevel();resourceData.filter(function(x){return null!=x.resourceType}).forEach(function(x){var resourceTypeLowLevel=x.resourceType.node.highLevel().lowLevel(),resourceTypeTransformer=x.resourceType.transformer;resourceTypeTransformer.owner=resource,resourceLowLevel.adopt(resourceTypeLowLevel,resourceTypeTransformer)});var methods=resource.methods();methods.forEach(function(m){var methodLowLevel=m.highLevel().lowLevel(),name=m.method(),allTraits=[];resourceData.forEach(function(x){var methodTraits=x.methodTraits[name];methodTraits&&(allTraits=allTraits.concat(methodTraits),methodTraits.forEach(function(x){var traitLowLevel=x.node.highLevel().lowLevel(),traitTransformer=x.transformer;traitTransformer.owner=m,methodLowLevel.adopt(traitLowLevel,traitTransformer)}));var resourceTraits=x.traits;resourceTraits&&(allTraits=allTraits.concat(resourceTraits),resourceTraits.forEach(function(x){var traitLowLevel=x.node.highLevel().lowLevel(),traitTransformer=x.transformer;traitTransformer.owner=m,methodLowLevel.adopt(traitLowLevel,traitTransformer)}))})});var resources=resource.resources();resources.forEach(function(x){return _this.processResource(x)})},TraitsAndResourceTypesExpander.prototype.collectResourceData=function(original,obj,arr,transformer,nodesChain,occuredResourceTypes){var _this=this;void 0===arr&&(arr=[]),void 0===nodesChain&&(nodesChain=[]),void 0===occuredResourceTypes&&(occuredResourceTypes={}),nodesChain=nodesChain.concat([obj.highLevel()]);var ownTraits=this.extractTraits(obj,transformer,nodesChain),methodTraitsMap={},methods=obj.methods();methods.forEach(function(x){var methodTraits=_this.extractTraits(x,transformer,nodesChain);methodTraits&&methodTraits.length>0&&(methodTraitsMap[x.method()]=methodTraits)});var rtData,rtRef=obj.type();if(null!=rtRef){var units=toUnits1(nodesChain);rtData=this.readGenerictData(original,rtRef,obj.highLevel(),this.resourceTypeMap,this.globalResourceTypes,"resource type",transformer,units)}var result={resourceType:rtData,traits:ownTraits,methodTraits:methodTraitsMap};if(arr.push(result),rtData){var rt=rtData.node,qName=hlimpl.qName(rt.highLevel(),original.highLevel());occuredResourceTypes[qName]?result.resourceType=null:(occuredResourceTypes[qName]=!0,this.collectResourceData(original,rt,arr,rtData.transformer,nodesChain,occuredResourceTypes))}return arr},TraitsAndResourceTypesExpander.prototype.extractTraits=function(obj,_transformer,nodesChain,occuredTraits){var _this=this;void 0===occuredTraits&&(occuredTraits={}),nodesChain=nodesChain.concat([obj.highLevel()]);for(var arr=[],i=-1;i<arr.length;i++){var gd=i<0?null:arr[i],_obj=gd?gd.node:obj,units=gd?gd.unitsChain:toUnits1(nodesChain),transformer=gd?gd.transformer:_transformer;_obj.is&&_obj.is().forEach(function(x){var unitsChain=toUnits2(units,x.highLevel()),traitData=_this.readGenerictData(obj,x,_obj.highLevel(),_this.traitMap,_this.globalTraits,"trait",transformer,unitsChain);if(traitData){var name=traitData.name;occuredTraits[name]=!0,arr.push(traitData)}})}return arr},TraitsAndResourceTypesExpander.prototype.readGenerictData=function(r,obj,context,cache,globalList,template,transformer,unitsChain){void 0===unitsChain&&(unitsChain=[]);var value=obj.value();if("string"==typeof value){transformer&&(value=transformer.transform(value).value);var node=this.getTemplate(value,context,cache,globalList);if(node)return{name:value,transformer:null,parentTransformer:transformer,node:node,ref:obj,unitsChain:unitsChain}}else if(value instanceof hlimpl.StructuredValue){var sv=value,name=sv.valueName();transformer&&(name=transformer.transform(name).value);var scalarParams={},structuredParams={},node=this.getTemplate(name,context,cache,globalList);if(node){"RAML08"==this.ramlVersion?sv.children().forEach(function(x){return scalarParams[x.valueName()]=x.lowLevel().value()}):sv.children().forEach(function(x){var llNode=x.lowLevel();llNode.valueKind()==yaml.Kind.SCALAR?scalarParams[x.valueName()]=llNode.value():structuredParams[x.valueName()]=llNode});var ds=new DefaultTransformer(r,null,unitsChain);Object.keys(scalarParams).forEach(function(x){var q=ds.transform(scalarParams[x]);q&&"object"!=typeof q&&(scalarParams[x]=q)});var valTransformer=new ValueTransformer(template,name,unitsChain,scalarParams,structuredParams,transformer),resourceTypeTransformer=new DefaultTransformer(null,valTransformer,unitsChain);return{name:name,transformer:resourceTypeTransformer,parentTransformer:transformer,node:node,ref:obj,unitsChain:unitsChain}}}return null},TraitsAndResourceTypesExpander.prototype.appendTraitReferences=function(m,traits){if(0!=traits.length){var traitsData=traits.map(function(x){return{node:x.ref.highLevel().lowLevel(),transformer:x.parentTransformer}});referencePatcher.patchMethodIs(m.highLevel(),traitsData)}},TraitsAndResourceTypesExpander}();exports.TraitsAndResourceTypesExpander=TraitsAndResourceTypesExpander,exports.toUnits=toUnits;var TransformMatches=function(){function TransformMatches(name,transformer){this.name=name,this.regexp=new RegExp(TransformMatches.leftTransformRegexp.source+name+TransformMatches.rightTransformRegexp.source),this.transformer=transformer}return TransformMatches.leftTransformRegexp=/\|\s*!\s*/,TransformMatches.rightTransformRegexp=/\s*$/,TransformMatches}(),transformers=[new TransformMatches("singularize",function(arg){return pluralize.singular(arg)}),new TransformMatches("pluralize",function(arg){return pluralize.plural(arg)}),new TransformMatches("uppercase",function(arg){return arg?arg.toUpperCase():arg}),new TransformMatches("lowercase",function(arg){return arg?arg.toLowerCase():arg}),new TransformMatches("lowercamelcase",function(arg){return arg?changeCase.camelCase(arg):arg}),new TransformMatches("uppercamelcase",function(arg){if(!arg)return arg;var lowerCamelCase=changeCase.camelCase(arg);return lowerCamelCase[0].toUpperCase()+lowerCamelCase.substring(1,lowerCamelCase.length)}),new TransformMatches("lowerunderscorecase",function(arg){if(!arg)return arg;var snakeCase=changeCase.snake(arg);return snakeCase.toLowerCase()}),new TransformMatches("upperunderscorecase",function(arg){if(!arg)return arg;var snakeCase=changeCase.snake(arg);return snakeCase.toUpperCase()}),new TransformMatches("lowerhyphencase",function(arg){if(!arg)return arg;var paramCase=changeCase.param(arg);return paramCase.toLowerCase()}),new TransformMatches("upperhyphencase",function(arg){if(!arg)return arg;var paramCase=changeCase.param(arg);return paramCase.toUpperCase()})];exports.getTransformNames=getTransformNames,exports.getTransformerForOccurence=getTransformerForOccurence;var TransformationBuffer=function(){function TransformationBuffer(){this.buf=null}return TransformationBuffer.prototype.append=function(value){""!==value&&(null!=this.buf?null!=value&&("string"!=typeof this.buf&&(this.buf=""+this.buf),this.buf+=value):""!==value&&(this.buf=value))},TransformationBuffer.prototype.value=function(){return null!=this.buf?this.buf:""},TransformationBuffer}(),ValueTransformer=function(){function ValueTransformer(templateKind,templateName,unitsChain,params,structuredParams,vDelegate){this.templateKind=templateKind,this.templateName=templateName,this.unitsChain=unitsChain,this.params=params,this.structuredParams=structuredParams,this.vDelegate=vDelegate}return ValueTransformer.prototype.transform=function(obj,toString,doBreak,callback){var undefParams={},errors=[];if("string"==typeof obj){if(this.structuredParams&&util.stringStartsWith(obj,"<<")&&util.stringEndsWith(obj,">>")){var paramName=obj.substring(2,obj.length-2),structuredValue=this.structuredParams[paramName];if(null!=structuredValue)return{value:structuredValue.value(toString),errors:errors}}for(var str=obj,buf=new TransformationBuffer,prev=0,i=str.indexOf("<<");i>=0;i=str.indexOf("<<",prev)){buf.append(str.substring(prev,i));var i0=i;if(i+="<<".length,prev=this.paramUpperBound(str,i),prev==-1)break;var paramOccurence=str.substring(i,prev);prev+=">>".length;var val,paramName,originalString=str.substring(i0,prev),transformer=getTransformerForOccurence(paramOccurence);if(transformer){var ind=paramOccurence.lastIndexOf("|");paramName=paramOccurence.substring(0,ind).trim(),val=this.params[paramName],val&&"string"==typeof val&&val.indexOf("<<")>=0&&this.vDelegate&&(val=this.vDelegate.transform(val,toString,doBreak,callback).value),val&&(val=transformer(val))}else paramName=paramOccurence.trim(),val=this.params[paramName],val&&"string"==typeof val&&val.indexOf("<<")>=0&&this.vDelegate&&(val=this.vDelegate.transform(val,toString,doBreak,callback).value);null!==val&&void 0!==val||(undefParams[paramName]=!0,val=originalString),buf.append(val)}var upArr=Object.keys(undefParams);if(upArr.length>0){var errStr=upArr.join(", ").trim(),message="Undefined "+this.templateKind+" parameter"+(upArr.length>1?"s":"")+": "+errStr,error={code:hl.IssueCode.MISSING_REQUIRED_PROPERTY,isWarning:!1,message:message,node:null,start:-1,end:-1,path:null};errors.push(error)}return buf.append(str.substring(prev,str.length)),{value:buf.value(),errors:errors}}return{value:obj,errors:errors}},ValueTransformer.prototype.paramUpperBound=function(str,pos){for(var count=0,i=pos;i<str.length;i++)if(util.stringStartsWith(str,"<<",i))count++,i++;else if(util.stringStartsWith(str,">>",i)){if(0==count)return i;count--,i++}return str.length},ValueTransformer.prototype.children=function(node){var substitution=this.substitutionNode(node);return substitution?substitution.children():null},ValueTransformer.prototype.valueKind=function(node){var substitution=this.substitutionNode(node);return substitution?substitution.valueKind():null},ValueTransformer.prototype.substitutionNode=function(node){var paramName=this.paramName(node);return paramName&&this.structuredParams[paramName]},ValueTransformer.prototype.paramName=function(node){var paramName=null;if(node.valueKind()==yaml.Kind.SCALAR){var val=(""+node.value()).trim();util.stringStartsWith(val,"<<")&&util.stringEndsWith(val,">>")&&(paramName=val.substring(2,val.length-2))}return paramName},ValueTransformer;
}();exports.ValueTransformer=ValueTransformer;var DefaultTransformer=function(_super){function DefaultTransformer(owner,delegate,unitsChain){_super.call(this,null!=delegate?delegate.templateKind:"",null!=delegate?delegate.templateName:"",unitsChain),this.owner=owner,this.delegate=delegate}return __extends(DefaultTransformer,_super),DefaultTransformer.prototype.transform=function(obj,toString,doContinue,callback){if(null==obj||null!=doContinue&&!doContinue())return{value:obj,errors:[]};var ownResult={value:obj,errors:[]},gotDefaultParam=!1;defaultParameters.forEach(function(x){return gotDefaultParam=gotDefaultParam||obj.toString().indexOf("<<"+x)>=0}),gotDefaultParam&&(this.initParams(),ownResult=_super.prototype.transform.call(this,obj,toString,doContinue,callback));var result=null!=this.delegate?this.delegate.transform(ownResult.value,toString,doContinue,callback):ownResult.value;return null!=doContinue&&doContinue()&&null!=callback&&(result.value=callback(result.value,this)),result},DefaultTransformer.prototype.initParams=function(){for(var methodName,resourcePathName,resourcePath="",ll=this.owner.highLevel().lowLevel(),node=ll instanceof proxy.LowLevelProxyNode?ll.originalNode().originalNode():ll,last=null;node;){var key=node.key();if(null!=key)if(util.stringStartsWith(key,"/")){if(!resourcePathName)for(var arr=key.split("/"),i=arr.length-1;i>=0;i--){var seg=arr[i];if(seg.indexOf("{")==-1){resourcePathName=arr[i];break}seg.length>0&&(last=seg)}resourcePath=key+resourcePath}else methodName=key;node=node.parent()}resourcePathName||last&&(resourcePathName=""),this.params={resourcePath:resourcePath,resourcePathName:resourcePathName},methodName&&(this.params.methodName=methodName)},DefaultTransformer.prototype.children=function(node){return null!=this.delegate?this.delegate.children(node):null},DefaultTransformer.prototype.valueKind=function(node){return null!=this.delegate?this.delegate.valueKind(node):null},DefaultTransformer}(ValueTransformer);exports.DefaultTransformer=DefaultTransformer;var defaultParameters=["resourcePath","resourcePathName","methodName"]},function(module,exports,__webpack_require__){(function(process){"use strict";function evalInSandbox(code,thisArg,args){return new loophole.Function(code).call(thisArg,args)}function checkPropertyQuard(n,v){var pr=n.property();return pr&&pr.getContextRequirements().forEach(function(x){n.checkContextValue(x.name,x.value,x.value)||v.accept(createIssue(hl.IssueCode.MISSED_CONTEXT_REQUIREMENT,x.name+" should be "+x.value+" to use property "+pr.nameId(),n))}),pr}function lintNode(astNode,acceptor){var fsEnabled;try{fsEnabled=astNode.lowLevel().unit().project().fsEnabled()}catch(exception){fsEnabled=!0}if(fsEnabled&&"undefined"!=typeof fs&&fs){for(var fsMethods=["exists","readFile","writeFile","readdir","existsSync","readFileSync","writeFileSync","readdirSync"],i=(Object.keys(fs),0);i<fsMethods.length;i++)if(!fs[fsMethods[i]])return;var ps=astNode.lowLevel().unit().absolutePath(),dr=path.dirname(ps),customLinter=path.resolve(dr,"raml-lint.js");lintWithFile(customLinter,acceptor,astNode);var dir=path.resolve(dr,".raml");if(fs.existsSync(dir)){var st=fs.statSync(dir);if(st.isDirectory()){var files=fs.readdirSync(dir);files.forEach(function(x){x.indexOf("-lint.js")!=-1&&lintWithFile(path.resolve(dir,x),acceptor,astNode)})}}}}function isTypeOrSchema(d){return d.nameId()==universes.Universe10.TypeDeclaration.properties.type.name||d.nameId()==universes.Universe10.TypeDeclaration.properties.schema.name}function isDefaultValueProp(d){return!!checkIfDomainIsUserDefined(d)&&d.nameId()==universes.Universe10.TypeDeclaration.properties.default.name}function isExampleProp(d){return!!checkIfDomainIsUserDefined(d)&&d.nameId()==universes.Universe10.TypeDeclaration.properties.example.name}function checkIfDomainIsUserDefined(d){return!!d.domain()&&!d.domain().getAdapter(services.RAMLService).isUserDefined()}function isSecuredBy(d){return!!checkIfDomainIsUserDefined(d)&&d.nameId()==universes.Universe08.MethodBase.properties.securedBy.name}function typeOfContainingTemplate(h){for(var declRoot=h;;){if(declRoot.definition().getAdapter(services.RAMLService).isInlinedTemplates())return declRoot.definition().nameId();var np=declRoot.parent();if(!np)break;declRoot=np}return null}function restrictUnknownNodeError(node){var parentNode=node.parent(),issue=null,parentDef=parentNode.definition();if(parentNode&&parentDef instanceof def.UserDefinedClass){var parentProperty=parentNode.property();if(universeHelpers.isIsProperty(parentProperty)||universeHelpers.isTypeProperty(parentProperty)){var paramName=node.name();issue=null!=exports.RESERVED_TEMPLATE_PARAMETERS[paramName]?createIssue(hl.IssueCode.INVALID_PROPERTY,"Invalid parameter name: "+paramName+" is reserved",node):createIssue(hl.IssueCode.UNKNOWN_NODE,"Unused parameter: "+paramName,node)}}if(!issue){var propName=node.name(),universe08=universeProvider("RAML08"),isRAML08=parentDef.universe().version()==universe08.version();if(isRAML08){var parameterTypeName=universes.Universe08.Parameter.name;universes.Universe10.TypeDeclaration.name;if(isRAML08&&parentDef.isAssignableFrom(parameterTypeName)){for(var possibleDefs=universe08.type(parameterTypeName).allSubTypes().filter(function(x){return null!=universes.Universe08[x.nameId()].properties[propName]}),possibleDefsMap={},i=0;i<possibleDefs.length;i++){var x=possibleDefs[i];if(!possibleDefsMap[x.nameId()]){var valueRequirements=x.valueRequirements();if(valueRequirements&&0!=valueRequirements.length){var typeRquirements=valueRequirements.filter(function(x){return"type"==x.name}).map(function(x){return x.value});if(0!=typeRquirements.length){var runtimeName=typeRquirements[0];possibleDefsMap[x.nameId()]=runtimeName,x.allSubTypes().forEach(function(y){return possibleDefs.push(y)})}}}}var runtimeNames=Object.keys(possibleDefsMap).map(function(x){return possibleDefsMap[x]}).sort();if(runtimeNames.length>0){var namesStr=runtimeNames.map(function(x,i){var x1="'"+x+"'";return i==runtimeNames.length-1?x1:i==runtimeNames.length-2?x1+" or ":x1+", "}).join(""),message="Property '"+propName+"' can only be used if type is "+namesStr;issue=createIssue(hl.IssueCode.ILLEGAL_PROPERTY,message,node)}}}}return issue}function validateBasic(node,v,requiredOnly){void 0===requiredOnly&&(requiredOnly=!1);var parentNode=node.parent(),llValue=node.lowLevel().value();if(node.lowLevel()){if(node.lowLevel().keyKind()==yaml.Kind.MAP&&v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"Node key can not be map",node)),node.lowLevel().keyKind()==yaml.Kind.SEQ&&null==llValue){var isPattern=!1;node.isElement()&&node.asElement().definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&(isPattern=!0),isPattern||v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"Node key can not be sequence",node))}null==parentNode&&node.lowLevel().errors().forEach(function(x){var ps=x.mark?x.mark.position:0,em={code:hl.IssueCode.YAML_ERROR,message:x.message,node:null,start:ps,end:ps+1,isWarning:!1,path:node.lowLevel().unit()==node.root().lowLevel().unit()?null:node.lowLevel().unit().path(),unit:node.lowLevel().unit()};v.accept(em)})}if(node.isUnknown()){if(node.name().indexOf("<<")!=-1&&null!=typeOfContainingTemplate(parentNode))return void(new TraitVariablesValidator).validateName(node,v);if(node.needSequence&&v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"node: "+node.name()+" should be wrapped in sequence",node)),node.needMap)return void v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,(node.knownProperty?node.knownProperty.nameId():"")+" should be a map in RAML 1.0",node));if(node.unresolvedRef&&v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"reference: "+llValue+" can not be resolved",node)),node.knownProperty){if(0==node.lowLevel().includeErrors().length){if(typeOfContainingTemplate(parentNode)&&util.startsWith(llValue,"<<")&&util.endsWith(llValue,">>"))return;if("body"==node.name()&&node.computedValue("mediaType"))return;"~"!=node.lowLevel().value()&&v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"property "+node.name()+" can not have scalar value",node))}}else{var issue=restrictUnknownNodeError(node);issue||(issue=createIssue(hl.IssueCode.UNKNOWN_NODE,"Unknown node: "+node.name(),node)),v.accept(issue)}}if(node.markCh()&&!node.allowRecursive()){if(!node.property())return;return void v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"Recursive definition: "+node.name(),node))}if(node.definition&&node.definition().isAssignableFrom(universes.Universe10.Operation.name)){var queryStringNode=node.element(universes.Universe10.Operation.properties.queryString.name),queryParamsNode=node.lowLevel&&_.find(node.lowLevel().children(),function(child){return child.key&&child.key()===universes.Universe10.Operation.properties.queryParameters.name});queryStringNode&&queryParamsNode&&(v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,universes.Universe10.Operation.properties.queryParameters.name+" already specified.",queryStringNode)),v.accept(createLLIssue(hl.IssueCode.UNKNOWN_NODE,universes.Universe10.Operation.properties.queryString.name+" already specified.",queryParamsNode,node)))}try{var isOverlay=node.definition&&node.definition()&&node.definition().key()===universes.Universe10.Overlay,children=isOverlay?node.children():node.directChildren();children.filter(function(child){return!requiredOnly||child.property&&child.property()&&child.property().isRequired()}).forEach(function(x){return x&&x.errorMessage?void v.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,x.errorMessage,x.name()?x:node)):void x.validate(v)})}finally{node.unmarkCh()}}function hasTemplateArgs(node){var vl=node.value();if("string"==typeof vl&&vl.indexOf("<<")!=-1)return!0;for(var x=node.children(),i=0;i<x.length;i++)if(hasTemplateArgs(x[i]))return!0;return!1}function validate(node,v){if(!node.parent())try{validateIncludes(node,v)}finally{cleanupIncludesFlag(node,v)}if(node.isAttr())(new CompositePropertyValidator).validate(node,v);else if(node.isElement()){if(node.invalidSequence){var pName=node.property().nameId(),msg=changeCase.sentenceCase(pluralize.singular(pName));msg="In RAML 1.0 "+msg+" is not allowed to have sequence as definition",v.acceptUnique(createLLIssue(hl.IssueCode.UNKNOWN_NODE,msg,node.lowLevel().parent().parent(),node,!1))}var highLevelNode=node.asElement();if(universeHelpers.isExampleSpecType(highLevelNode.definition())){var hlChildren=highLevelNode.children();if(0==hlChildren.length)return void validateBasic(node,v,!0);var content=hlChildren.filter(function(x){var propName=x.lowLevel().key();return!propName||("("!=propName.charAt(0)||")"!=propName.charAt(propName.length-1))&&null==highLevelNode.definition().property(propName)});if(content.length>0)return void validateBasic(node,v,!0)}if(highLevelNode.definition().isAnnotationType()||highLevelNode.property()&&"annotations"==highLevelNode.property().nameId())return void(new FixedFacetsValidator).validate(highLevelNode,v);if(highLevelNode.definition().isAssignableFrom(universes.Universe10.UsesDeclaration.name)){var vn=highLevelNode.attr(universes.Universe10.UsesDeclaration.properties.value.name);if(vn&&vn.value()){var rs=highLevelNode.lowLevel().unit().resolve(vn.value());if(rs){if(!resourceRegistry.isWaitingFor(vn.value())){var issues=[];if(rs.highLevel().validate(hlimpl.createBasicValidationAcceptor(issues)),issues.length>0){var brand=createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,"Issues in the used library:"+vn.value(),highLevelNode,!1);issues.forEach(function(x){x.unit=rs,x.path=rs.absolutePath()}),brand.extras=issues,v.accept(brand)}}}else v.accept(createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,"Can not resolve library from path:"+vn.value(),highLevelNode,!1))}}if(highLevelNode.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)){if(typeOfContainingTemplate(highLevelNode)&&hasTemplateArgs(highLevelNode.lowLevel()))return;return highLevelNode.attrs().forEach(function(a){var range=a.property().range().key();if(range==universes.Universe08.RelativeUriString||range==universes.Universe10.RelativeUriString)return void(new UriValidator).validate(a,v);if(range==universes.Universe08.FullUriTemplateString||range==universes.Universe10.FullUriTemplateString)return void(new UriValidator).validate(a,v);if(a.property().getAdapter(services.RAMLPropertyService).isKey()){var nameId=node.property()&&node.property().nameId();if(nameId==universes.Universe08.Resource.properties.uriParameters.name||nameId==universes.Universe08.Resource.properties.baseUriParameters.name)return;if(highLevelNode.property()&&highLevelNode.property().nameId()==universes.Universe10.MethodBase.properties.body.name)return void(new MediaTypeValidator).validate(a,v)}}),highLevelNode.parent()&&!highLevelNode.parent().parent()&&rtypes.builtInTypes().get(highLevelNode.name())&&v.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"redefining a built in type:"+highLevelNode.name(),highLevelNode)),(new RecurrentOverlayValidator).validate(highLevelNode,v),(new RecurrentValidateChildrenKeys).validate(highLevelNode,v),(new NodeSpecificValidator).validate(highLevelNode,v),void(new TypeDeclarationValidator).validate(highLevelNode,v)}if(highLevelNode.definition().isAssignableFrom(universes.Universe10.LibraryBase.name)){var vv,hasSchemas=!1,hasTypes=!1;highLevelNode.lowLevel().children().forEach(function(x){"schemas"==x.key()&&(hasSchemas=!0,vv=x),"types"==x.key()&&(hasTypes=!0)}),hasSchemas&&hasTypes&&v.accept(localLowLevelError(vv,highLevelNode,hl.IssueCode.ILLEGAL_PROPERTY_VALUE,!1,"types and schemas are mutually exclusive",!1))}var hasRequireds=highLevelNode.definition().requiredProperties()&&highLevelNode.definition().requiredProperties().length>0,isAllowAny=highLevelNode.definition().getAdapter(services.RAMLService).getAllowAny();isAllowAny?hasRequireds&&validateBasic(node,v,!0):validateBasic(node,v),(new UriParametersValidator).validate(highLevelNode,v),(new CompositeNodeValidator).validate(highLevelNode,v),(new TemplateCyclesDetector).validate(highLevelNode,v)}else validateBasic(node,v);(new OptionalPropertiesValidator).validate(node,v)}function cleanupIncludesFlag(node,v){var val=node.lowLevel().actual();delete val._inc,node.children().forEach(function(x){return cleanupIncludesFlag(x,v)})}function validateIncludes(node,v){var llNode=node.lowLevel(),val=llNode.actual();if(!val._inc){if(node.isElement()){var vl=node.name();"string"==typeof vl&&null!=vl&&vl.indexOf(" ")!=-1&&v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Keys should not have spaces '"+vl+"'",node,!0))}if(val._inc=!0,llNode){llNode.includeErrors().forEach(function(x){var isWarn=!1;node.lowLevel().hasInnerIncludeError()&&(isWarn=!0);var em=createIssue(hl.IssueCode.UNABLE_TO_RESOLVE_INCLUDE_FILE,x,node,isWarn);v.accept(em)});var includePath=llNode.includePath();if(null!=includePath&&!path.isAbsolute(includePath)&&!ll.isWebPath(includePath)){var unitPath=llNode.unit().absolutePath(),exceeding=calculateExceeding(path.dirname(unitPath),includePath);if(exceeding>0){var em=createIssue(hl.IssueCode.UNABLE_TO_RESOLVE_INCLUDE_FILE,"Resolved include path exceeds file system root",node,!0);v.accept(em)}}}node.children().forEach(function(x){return validateIncludes(x,v)})}}function calculateExceeding(rootPath,relativePath){for(var rootSegments=actualSegments(rootPath),relativeSegments=actualSegments(relativePath),count=rootSegments.length,result=0,_i=0,relativeSegments_1=relativeSegments;_i<relativeSegments_1.length;_i++){var segment=relativeSegments_1[_i];".."==segment?(count--,count<0&&(result=Math.min(count,result))):count++}return-1*result}function isValid(t,h,value,p,attr){return t.hasArrayInHierarchy()?isValidArray(t,h,value,p,attr):!t.hasValueTypeInHierarchy()||isValidValueType(t,h,value,p,attr)}function isValidArray(t,h,v,p,attr){return!t.arrayInHierarchy().componentType()||isValid(t.arrayInHierarchy().componentType(),h,v,p)}function isValidValueType(t,h,v,p,attr){try{if(t.key()==universes.Universe10.AnnotationRef){var targets=search.referenceTargets(p,h),actualAnnotation=_.find(targets,function(x){return hlimpl.qName(x,h)==v});if(null!=actualAnnotation){var attrs=actualAnnotation.attributes("allowedTargets");if(attrs){var aVals=attrs.map(function(x){return x.value()});if(aVals.length>0){var found=!1,tps=h.definition().allSuperTypes();tps=tps.concat([h.definition()]);var tpNames=tps.map(function(x){return x.nameId()});if(aVals.forEach(function(x){"API"==x&&(x="Api"),"NamedExample"==x&&(x="ExampleSpec"),"SecurityScheme"==x&&(x="AbstractSecurityScheme"),"SecuritySchemeSettings"==x&&(x="SecuritySchemeSettings"),_.find(tpNames,function(y){return y==x})?found=!0:("Parameter"==x&&h.computedValue("location")&&(found=!0),"Field"==x&&h.computedValue("field")&&(found=!0))}),!found)return new Error("annotation "+v+" can not be placed at this location, allowed targets are:"+aVals)}}}return tm}if(t.key()==universes.Universe08.SchemaString||t.key()==universes.Universe10.SchemaString){var tm=su.createSchema(v,contentProvider(h.lowLevel()));return tm instanceof Error&&(tm.canBeRef=!0),tm}if(t.key()==universes.Universe08.StatusCodeString||t.key()==universes.Universe10.StatusCodeString){var err=validateResponseString(v);if(null!=err)return err}if(t.key()==universes.Universe08.BooleanType||t.isAssignableFrom(universes.Universe10.BooleanType.name)){if("true"!==v&&"false"!==v&&v!==!0&&v!==!1)return new Error("'true' or 'false' is expected here");if(attr){var stringValue=attr.lowLevel().value(!0);if("true"!==stringValue&&"false"!==stringValue)return new Error("'true' or 'false' is expected here")}}if(t.key()==universes.Universe08.NumberType||t.isAssignableFrom(universes.Universe10.NumberType.name)){var q=parseFloat(v);if(isNaN(q))return new Error("the value of "+p.nameId()+" must be a number")}if((t.key()==universes.Universe08.StringType||t.isAssignableFrom(universes.Universe10.StringType.name))&&null===v&&h&&p){var highLevelProperty=h.attr(p.nameId());if(highLevelProperty){var lowLevelChildren=highLevelProperty.lowLevel().children();if(lowLevelChildren&&lowLevelChildren.length>0)return new Error(p.nameId()+" must be a string")}}return!0}catch(e){return e.canBeRef=!0,e}}function getHumanReadableNodeName(astNode){if(!astNode)return null;if(astNode.isElement()){var element=astNode,definition=element.definition();if(definition&&exports.typeToName.hasOwnProperty(definition.nameId()))return exports.typeToName[definition.nameId()];if(definition.isAssignableFrom(universes.Universe10.TypeDeclaration.name)||definition.isAssignableFrom(universes.Universe08.Parameter.name)){if(element.property()&&exports.parameterPropertyToName.hasOwnProperty(element.property().nameId()))return exports.parameterPropertyToName[element.property().nameId()];if(element.property()&&element.parent()&&element.property().nameId()==universes.Universe10.LibraryBase.properties.types.name&&element.parent().definition()&&element.parent().definition().isAssignableFrom(universes.Universe10.LibraryBase.name))return"type";if(element.property()&&element.parent()&&element.property().nameId()==universes.Universe10.LibraryBase.properties.securitySchemes.name&&element.parent().definition()&&element.parent().definition().isAssignableFrom(universes.Universe10.LibraryBase.name))return"security scheme"}}return null}function isValidPropertyValue(pr,vl,c){var node=search.declRoot(c);node._cach||(node._cach={});var id=pr.id();if(pr.domain()&&(id+=pr.domain().nameId()),id){var cached=node._cach[id];if(cached)return null!=cached[vl]}var vls=search.enumValues(pr,c),mm={};return vls.forEach(function(x){return mm[x]=1}),pr.id()&&(node._cach[id]=mm),null!=mm[vl]}function checkReference(pr,astNode,vl,cb){if(checkTraitReference(pr,astNode,cb),checkResourceTypeReference(pr,astNode,cb),vl&&("null"!=vl||!pr.isAllowNull())){var adapter=pr.getAdapter(services.RAMLPropertyService),valid=isValidPropertyValue(pr,vl,astNode.parent());if(valid||astNode.lowLevel().unit().absolutePath()===astNode.parent().lowLevel().unit().absolutePath()||(valid=isValidPropertyValue(pr,vl,hlimpl.fromUnit(astNode.lowLevel().unit()))),!valid){if("string"==typeof vl&&0==vl.indexOf("x-")&&pr.nameId()==universes.Universe10.TypeDeclaration.properties.type.name)return!0;var expected=adapter.isReference&&adapter.isReference()&&adapter.referencesTo&&adapter.referencesTo()&&adapter.referencesTo().nameId&&adapter.referencesTo().nameId(),referencedToName=exports.typeToName[expected]||nameForNonReference(astNode),message=referencedToName?"Unrecognized "+referencedToName+" '"+vl+"'.":"Unresolved reference: "+vl,spesializedMessage=specializeReferenceError(message,pr,astNode);return cb.accept(createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,spesializedMessage,astNode,pr.range().key()===universes.Universe08.SchemaString)),!0}if(isDuplicateSibling(astNode)&&universeHelpers.isTraitRefType(astNode.definition())){var message="Duplicate trait reference '"+vl+"'.",spesializedMessage=specializeReferenceError(message,pr,astNode);return cb.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,spesializedMessage,astNode)),!0}return!1}}function isDuplicateSibling(attr){var siblingName,ramlVersion=attr.property().domain().universe().version();if(siblingName="RAML10"==ramlVersion?stringify(json.serialize(attr.lowLevel())):attr.value()&&attr.value().valueName&&attr.value().valueName(),!siblingName)return!1;var parent=attr.parent&&attr.parent();if(!parent)return!1;var propertyName=attr.name&&attr.name();if(!propertyName)return!1;var siblings=parent.attributes&&parent.attributes(propertyName);if(!siblings)return!1;if(0===siblings.length)return!1;var count=0;return siblings.forEach(function(sibling){var name;"RAML10"==ramlVersion?siblingName=stringify(json.serialize(sibling.lowLevel())):name=sibling.value&&sibling.value()&&sibling.value().valueName&&sibling.value().valueName(),name===siblingName&&count++}),count>1}function checkTraitReference(property,astNode,acceptor){if(universeHelpers.isIsProperty(property)){var lowLevel=astNode.lowLevel();if(null!=lowLevel){var isMappingNode=null,lowLevelParent=lowLevel.parent(),lowLevelParentParent=null!=lowLevelParent?lowLevelParent.parent():null;if(lowLevel.kind()==yaml.Kind.MAPPING&&lowLevel.key()&&"is"==lowLevel.key()?isMappingNode=lowLevel:null!=lowLevelParent&&lowLevelParent.kind()==yaml.Kind.MAPPING&&lowLevelParent.key()&&"is"==lowLevelParent.key()?isMappingNode=lowLevelParent:null!=lowLevelParentParent&&lowLevelParentParent.kind()==yaml.Kind.MAPPING&&lowLevelParentParent.key()&&"is"==lowLevelParentParent.key()&&(isMappingNode=lowLevelParentParent),null!=isMappingNode){null==isMappingNode.value()||isMappingNode.children()&&0!=isMappingNode.children().length||acceptor.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"property 'is' must be an array",astNode));var illegalChildFound=!1;isMappingNode.children().forEach(function(child){child.kind()!=yaml.Kind.SCALAR&&child.kind()!=yaml.Kind.MAP&&(illegalChildFound=!0)}),illegalChildFound&&acceptor.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"property 'is' must be an array",astNode))}}}}function checkResourceTypeReference(property,astNode,acceptor){if(universeHelpers.isTypeProperty(property)&&universeHelpers.isResourceTypeRefType(astNode.definition())){var lowLevel=astNode.lowLevel();null==astNode.value()&&lowLevel&&lowLevel.children()&&0==lowLevel.children().length?lowLevel.kind()==yaml.Kind.MAPPING&&null!=lowLevel.valueKind()&&acceptor.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"resource type name must be provided",astNode)):null==astNode.value()&&lowLevel&&lowLevel.children()&&lowLevel.children().length>1&&acceptor.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"a resource or resourceType can inherit from a single resourceType",astNode))}}function specializeReferenceError(originalMessage,property,astNode){return"type"==property.nameId()&&"RAML08"==property.domain().universe().version()&&property.domain().isAssignableFrom(universes.Universe08.Parameter.name)?"type can be either of: string, number, integer, file, date or boolean":null!=astNode.parent()&&universeHelpers.isSecuritySchemaType(astNode.parent().definition())?originalMessage+" Allowed values are:OAuth 1.0,OAuth 2.0,Basic Authentication,DigestSecurityScheme Authentication,x-{other}":originalMessage}function nameForNonReference(astNode){var propertyName=astNode&&astNode.lowLevel()&&astNode.lowLevel().key();if(propertyName===universes.Universe10.AbstractSecurityScheme.properties.type.name){var domain=astNode.parent()&&astNode.parent().definition()&&astNode.parent().definition().nameId();if(domain===universes.Universe10.AbstractSecurityScheme.name)return"security scheme type"}else if(propertyName===universes.Universe08.BodyLike.properties.schema.name){var domain=astNode.parent()&&astNode.parent().definition()&&astNode.parent().definition().nameId();if(domain===universes.Universe08.BodyLike.name)return"schema"}}function mapPath(node,e){var src=e.getValidationPath();return findElementAtPath(node,src)}function extractLowLevelNode(e){var pn=e.getExtra(rtypes.SOURCE_EXTRA);return pn instanceof hlimpl.LowLevelWrapperForTypeSystem?pn.node():null}function findElementAtPath(n,p){if(!p)return n;for(var chld=n.children(),i=0;i<chld.length;i++)if(chld[i].name()===p.name)return findElementAtPath(chld[i],p.child);if(!n.lowLevel())return n;for(var lchld=n.lowLevel().children(),i=0;i<lchld.length;i++)if(lchld[i].key()===p.name){var nn=new hlimpl.BasicASTNode(lchld[i],n);return findElementAtPath(nn,p.child)}if(!isNaN(p.name)&&lchld[p.name]){var node=lchld[p.name],nn=new hlimpl.BasicASTNode(node,n);return findElementAtPath(nn,p.child)}return n}function contentProvider(lowLevel){var root=lowLevel&&lowLevel.includeBaseUnit()&&(lowLevel.includePath&&lowLevel.includePath()?lowLevel.includeBaseUnit().resolve(lowLevel.includePath()):lowLevel.includeBaseUnit());return new contentprovider.ContentProvider(root)}function isJson(s){return s.indexOf("json")!=-1}function isXML(s){return s.indexOf("xml")!=-1}function getMediaType(node){var vl=getMediaType2(node);if("body"==vl){var rootMedia=node.root().attr("mediaType");return rootMedia?rootMedia.value():null}return vl}function getMediaType2(node){if(node.parent()){var pc=node.parent().definition();if(pc.key()==universes.Universe08.BodyLike)return node.parent().name();if(node.parent().parent()){var ppc=node.parent().parent().definition().key();if(ppc==universes.Universe08.Response||ppc==universes.Universe10.Response)return node.parent().property().nameId()==universes.Universe08.Response.properties.headers.name?null:node.parent().name();if(ppc==universes.Universe08.Method||ppc==universes.Universe10.Method)return node.parent().property().nameId()==universes.Universe10.MethodBase.properties.queryParameters.name||node.parent().property().nameId()==universes.Universe10.MethodBase.properties.headers.name?null:node.parent().name()}}return null}function toIssue(error,node){return createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,error.getMessage(),mapPath(node,error),error.isWarning())}function createIssue(c,message,node,w){void 0===w&&(w=!1);var original=null,pr=null;if(node.lowLevel()instanceof proxy.LowLevelProxyNode)for(var proxyNode=node.lowLevel();!proxyNode.primaryNode();)original||(original=localError(node,c,w,message,!0,pr)),node=node.parent(),proxyNode=node.lowLevel();if(node&&(pr=node.property(),node.lowLevel().unit()!=node.root().lowLevel().unit())){original=localError(node,c,w,message,!0,pr);for(node.lowLevel().unit();node.lowLevel().unit()!=node.root().lowLevel().unit();)pr=node.property(),node=node.parent()}original&&node.property()&&node.property().nameId()==universes.Universe10.FragmentDeclaration.properties.uses.name&&null!=node.parent()&&(pr=node.property(),node=node.parent());var error=localError(node,c,w,message,!1,pr);return original&&error.extras.push(original),error}function createLLIssue(issueCode,message,node,rootCalculationAnchor,isWarning){void 0===isWarning&&(isWarning=!1);var original=null;if(node&&rootCalculationAnchor.lowLevel().unit()!=rootCalculationAnchor.root().lowLevel().unit()){original=localLowLevelError(node,rootCalculationAnchor,issueCode,isWarning,message,!0);var v=rootCalculationAnchor.lowLevel().unit();for(v&&(message=message+" "+v.path());rootCalculationAnchor.lowLevel().unit()!=rootCalculationAnchor.root().lowLevel().unit();)rootCalculationAnchor=rootCalculationAnchor.parent()}original&&rootCalculationAnchor.property()&&rootCalculationAnchor.property().nameId()==universes.Universe10.FragmentDeclaration.properties.uses.name&&null!=rootCalculationAnchor.parent()&&(rootCalculationAnchor=rootCalculationAnchor.parent());var error=localLowLevelError(node,rootCalculationAnchor,issueCode,isWarning,message,!1);return original&&error.extras.push(original),error}function validateResponseString(v){if(3!=v.length)return new Error("Status code should be 3 digits number.");for(var i=0;i<v.length;i++){var c=v[i];if(!_.find(["0","1","2","3","4","5","6","7","8","9"],function(x){return x==c}))return new Error("Status code should be 3 digits number.")}return null}var jsyaml=__webpack_require__(27),json=__webpack_require__(50),stringify=__webpack_require__(62),proxy=__webpack_require__(38),hl=__webpack_require__(10),ll=__webpack_require__(11),_=__webpack_require__(61),yaml=__webpack_require__(70),def=__webpack_require__(36),hlimpl=__webpack_require__(16),path=__webpack_require__(15),fs=__webpack_require__(44),universes=__webpack_require__(22),universeHelpers=__webpack_require__(14),universeProvider=__webpack_require__(34),services=def,OverloadingValidator=__webpack_require__(51),expander=__webpack_require__(24),search=__webpack_require__(23),rtypes=def.rt,util=__webpack_require__(41),contentprovider=__webpack_require__(30),resourceRegistry=__webpack_require__(28),su=def.getSchemaUtils(),mediaTypeParser=__webpack_require__(63),xmlutil=__webpack_require__(52),changeCase=__webpack_require__(71),pluralize=__webpack_require__(72),LinterSettings=function(){function LinterSettings(){this.validateNotStrictExamples=!0}return LinterSettings}(),settings=new LinterSettings,loophole=__webpack_require__(78);exports.RESERVED_TEMPLATE_PARAMETERS={resourcePathName:'Part of the resource path following the rightmost "/"',methodName:"Method name",resourcePath:"Path of the resource"};var lintWithFile=function(customLinter,acceptor,astNode){if(fs.existsSync(customLinter))try{var content=fs.readFileSync(customLinter).toString(),factr=new LinterExtensionsImpl(acceptor);evalInSandbox(content,factr,null),factr.visit(astNode)}catch(e){console.log("Error in custom linter"),console.log(e)}},LinterExtensionsImpl=function(){function LinterExtensionsImpl(acceptor){this.acceptor=acceptor,this.nodes={}}return LinterExtensionsImpl.prototype.error=function(w,message){this.acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,message,w.highLevel()))},LinterExtensionsImpl.prototype.errorOnProperty=function(w,property,message){var pr=w.highLevel().attr(property);this.acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,message,pr))},LinterExtensionsImpl.prototype.warningOnProperty=function(w,property,message){var pr=w.highLevel().attr(property);this.acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,message,pr,!0))},LinterExtensionsImpl.prototype.warning=function(w,message){this.acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,message,w.highLevel(),!0))},LinterExtensionsImpl.prototype.registerRule=function(nodeType,rule){var q=this.nodes[nodeType];q||(q=[],this.nodes[nodeType]=q),q.push(rule)},LinterExtensionsImpl.prototype.visit=function(h){var _this=this,nd=h.definition();this.process(nd,h),nd.allSuperTypes().forEach(function(x){return _this.process(x,h)}),h.elements().forEach(function(y){return _this.visit(y)})},LinterExtensionsImpl.prototype.process=function(d,h){var _this=this;if(d instanceof def.NodeClass&&!d.getAdapter(services.RAMLService).getDeclaringNode()){var rules=this.nodes[d.nameId()];rules&&rules.forEach(function(x){return x(h.wrapperNode(),_this)})}},LinterExtensionsImpl;
}();(function(){function StackNode(){}return StackNode.prototype.toString=function(){return this.prev?this.value+"."+this.prev.toString():this.value},StackNode.prototype.last=function(){return this.prev?this.prev.last():this},StackNode})();exports.validateBasic=validateBasic,exports.validate=validate;var actualSegments=function(rootPath){rootPath=rootPath.replace(/\\/g,"/").trim(),rootPath.length>1&&":"==rootPath.charAt(1)&&/^win/.test(process.platform)&&(rootPath=rootPath.substring(2));var segments=rootPath.split("/");return 0==segments[0].length&&(segments=segments.slice(1)),segments.length>0&&0==segments[segments.length-1].length&&(segments=segments.slice(0,segments.length-1)),segments},validateRegexp=function(cleanedValue,v,node){try{new RegExp(cleanedValue)}catch(Error){v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Illegal pattern "+cleanedValue,node))}},TraitVariablesValidator=function(){function TraitVariablesValidator(){}return TraitVariablesValidator.prototype.validateName=function(node,acceptor){var name=node.name();if(name){var start=node.lowLevel().keyStart();this.check(name,start,node,acceptor)}},TraitVariablesValidator.prototype.validateValue=function(node,acceptor){var value=node.value();if("string"==typeof value){var start=node.lowLevel().valueStart();this.check(value,start,node,acceptor)}},TraitVariablesValidator.prototype.hasTraitOrResourceTypeParent=function(node){for(var parent=node.parent();null!=parent;){if(!parent.definition())return!1;if(universeHelpers.isTraitType(parent.definition())||universeHelpers.isResourceTypeType(parent.definition()))return!0;parent=parent.parent()}return!1},TraitVariablesValidator.prototype.check=function(str,start,node,acceptor){if(!this.hasTraitOrResourceTypeParent(node))return[];for(var errors=[],prev=0,i=str.indexOf("<<");i>=0;i=str.indexOf("<<",prev)){i+="<<".length,prev=str.indexOf(">>",i);var paramOccurence=str.substring(i,prev),ind=paramOccurence.lastIndexOf("|"),paramName=ind>=0?paramOccurence.substring(0,ind):paramOccurence;if(0==paramName.trim().length){var msg="Trait or resource type parameter name must contain non whitespace characters",issue=createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,msg,node,!1);issue.start=start+i,issue.end=start+prev,acceptor.accept(issue)}if(ind!=-1){ind++;var transformerName=paramOccurence.substring(ind).trim(),functionNames=expander.getTransformNames();if(!_.find(functionNames,function(functionName){return transformerName===functionName||transformerName==="!"+functionName})){var msg="Unknown function applied to parameter: "+transformerName,issue=createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,msg,node,!1);issue.start=start+ind,issue.end=start+prev,acceptor.accept(issue)}}prev+=">>".length}return errors},TraitVariablesValidator}(),MethodBodyValidator=function(){function MethodBodyValidator(){}return MethodBodyValidator.prototype.validate=function(node,validationAcceptor){var methodNode=node.parent();if(methodNode&&(methodNode.definition().isAssignableFrom(universes.Universe08.Method.name)||methodNode.definition().isAssignableFrom(universes.Universe10.Method.name))){var hasBody=_.find(methodNode.lowLevel()&&methodNode.lowLevel().children()||[],function(child){var keyValue=child.key();return keyValue&&(universes.Universe08.MethodBase.properties.body.name===keyValue||universes.Universe10.MethodBase.properties.body.name===keyValue)});hasBody&&_.find(MethodBodyValidator.methodsWithoutRequestBody,function(methodDisabled){return methodNode.name()===methodDisabled})&&validationAcceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,'Request body is disabled for "'+methodNode.name()+'" method.',methodNode))}},MethodBodyValidator.methodsWithoutRequestBody=["trace"],MethodBodyValidator}(),CompositePropertyValidator=function(){function CompositePropertyValidator(){}return CompositePropertyValidator.prototype.validate=function(node,v){var pr=checkPropertyQuard(node,v),vl=node.value();if(!node.property().range().hasStructure()){if(vl instanceof hlimpl.StructuredValue&&!node.property().isSelfNode()){if(isTypeOrSchema(node.property())&&node.property().domain().key()==universes.Universe08.BodyLike){var newNode=new hlimpl.ASTNodeImpl(node.lowLevel(),node.parent(),node.parent().definition().universe().type(universes.Universe08.BodyLike.name),node.property());return void newNode.validate(v)}if("RAML10"==node.parent().definition().universe().version()&&null!=typeOfContainingTemplate(node.parent()))return;v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Scalar is expected here",node))}else{var vk=node.lowLevel().valueKind();if(node.lowLevel().valueKind()!=yaml.Kind.INCLUDE_REF&&!node.property().getAdapter(services.RAMLPropertyService).isKey()&&!node.property().isMultiValue()){var k=node.property().range().key();k!=universes.Universe08.StringType&&k!=universes.Universe08.MarkdownString&&k!=universes.Universe08.MimeType||vk!=yaml.Kind.SEQ&&vk!=yaml.Kind.MAPPING&&vk!=yaml.Kind.MAP&&(!node.property().isRequired()&&"mediaType"!=node.property().nameId()||null!=vk&&void 0!==vk)||node.property().domain().getAdapter(services.RAMLService).isInlinedTemplates()||v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"property '"+node.name()+"' must be a string",node))}}if(node.isAnnotatedScalar()){var fvl=new FixedFacetsValidator;node.annotations().forEach(function(x){var vl=x.value(),highLevel=vl.toHighLevel();highLevel?fvl.validate(highLevel,v):v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"unknown annotation "+vl.valueName(),x))})}}var refName;if("string"==typeof vl?refName=vl:vl instanceof hlimpl.StructuredValue&&(refName=vl.valueName()),!(refName&&refName.indexOf("<<")!=-1&&refName.indexOf(">>")>refName.indexOf("<<")&&((new TraitVariablesValidator).validateValue(node,v),null!=typeOfContainingTemplate(node.parent())))){if((new MethodBodyValidator).validate(node,v),node.property().range().key()==universes.Universe08.MimeType||node.property().range().key()==universes.Universe10.MimeType||node.property().nameId()==universes.Universe10.TypeDeclaration.properties.name.name&&node.parent().property().nameId()==universes.Universe10.MethodBase.properties.body.name)return void(new MediaTypeValidator).validate(node,v);if(isExampleProp(node.property())||isDefaultValueProp(node.property())){if("RAML08"==node.definition().universe().version()){node.lowLevel().value();if(node.lowLevel().children().length>0){var valName=isExampleProp(node.property())?"example":"default value";v.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,valName+" should be a string",node,!1))}}(new ExampleAndDefaultValueValidator).validate(node,v)}if(isSecuredBy(node.property())){if("RAML08"==node.definition().universe().version()){var np=node.lowLevel().parent(),ysc=yaml.Kind.SEQ,msg="`securedBy` should be a list in RAML08";node.lowLevel()instanceof proxy.LowLevelProxyNode?np.valueKind()!=ysc&&v.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,msg,node,!1)):np.kind()!=ysc&&v.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,msg,node,!1))}(new ExampleAndDefaultValueValidator).validate(node,v)}if(node.property().nameId()==universes.Universe10.TypeDeclaration.properties.name.name){var nameId=node.parent().property()&&node.parent().property().nameId();if(nameId==universes.Universe08.Resource.properties.uriParameters.name||nameId==universes.Universe08.Resource.properties.baseUriParameters.name)return}var range=node.property().range().key();if(range==universes.Universe08.RelativeUriString||range==universes.Universe10.RelativeUriString)return void(new UriValidator).validate(node,v);if(range==universes.Universe08.FullUriTemplateString||range==universes.Universe10.FullUriTemplateString)return void(new UriValidator).validate(node,v);if("pattern"==node.name()&&universes.Universe10.StringType==node.definition().key()&&node.parent().definition().isAssignableFrom("StringTypeDeclaration")&&validateRegexp(node.value(),v,node),"name"==node.name()&&universes.Universe10.StringType==node.definition().key()&&"string"==typeof node.value()&&0==node.value().indexOf("[")&&node.value().lastIndexOf("]")==node.value().length-1&&node.parent()instanceof hlimpl.ASTNodeImpl&&universes.Universe10.ObjectTypeDeclaration.properties.properties.name==node.parent().property().nameId()&&node.parent().parent()instanceof hlimpl.ASTNodeImpl&&universes.Universe10.ObjectTypeDeclaration==node.parent().parent().definition().key()){var cleanedValue=node.value().substr(1,node.value().length-2);validateRegexp(cleanedValue,v,node)}pr.isReference()||pr.isDescriminator()?(new DescriminatorOrReferenceValidator).validate(node,v):(new NormalValidator).validate(node,v)}},CompositePropertyValidator}();exports.isValid=isValid;var NormalValidator=function(){function NormalValidator(){}return NormalValidator.prototype.validate=function(node,cb){var vl=node.value(),pr=node.property(),range=pr.range(),dnode=range.getAdapter(services.RAMLService).getDeclaringNode();if(dnode&&range.isUserDefined()){var rof=dnode.parsedType(),dp=node.parent().lowLevel().dumpToObject(),tempVal=dp[node.parent().name()],isVal=pr.canBeValue(),val=isVal||null===tempVal||void 0===tempVal?tempVal:tempVal[pr.nameId()],validateObject=rof.validate(val,!0);validateObject.isOk()||validateObject.getErrors().forEach(function(e){return cb.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,e.getMessage(),node,!1))})}var v=cb;if(node.lowLevel().keyKind()!=yaml.Kind.SEQ)var validation=isValid(pr.range(),node.parent(),vl,pr,node);else validation=!0;if(validation instanceof Error&&!validation.canBeRef)return v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,validation.message,node)),void(validation=null);if(!validation||validation instanceof Error)if("value"!=pr.nameId()){if(!checkReference(pr,node,vl,v)){if((pr.nameId()==universes.Universe10.TypeDeclaration.properties.schema.name||universes.Universe10.TypeDeclaration.properties.type.name)&&vl&&vl.trim()&&(pr.domain().key()==universes.Universe08.BodyLike||pr.domain().key()==universes.Universe10.TypeDeclaration)){var testSchema=vl.trim().charAt(0);if("{"!=testSchema&&"<"!=testSchema)return}var decl=node.findReferencedValue();if(decl instanceof Error&&v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,decl.message,node)),!decl){if(vl&&pr.nameId()==universes.Universe10.TypeDeclaration.properties.schema.name){var z=vl.trim();if("{"!=z.charAt(0)&&"<"!=z.charAt(0)&&(vl.indexOf("|")!=-1||vl.indexOf("[]")!=-1||vl.indexOf("(")!=-1))return}if(validation instanceof Error&&vl)return v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,validation.message,node)),void(validation=null);if(node.property().isRequired()&&null==node.value())v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Empty value is not allowed here",node));else{var ck=node.lowLevel().valueKind();ck!=yaml.Kind.MAP&&ck!=yaml.Kind.SEQ&&ck!=yaml.Kind.MAPPING||v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Empty value is not allowed here",node))}}}}else{var vl=node.value(),message="Invalid value schema:"+vl;validation instanceof Error&&(message=validation.message),v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,message,node,pr.range().key()==universes.Universe08.SchemaString))}var values=pr.enumOptions();if(values){if("string"!=typeof vl)return;"string"==typeof values?values!=vl&&(vl&&0==vl.indexOf("x-")&&pr.nameId()==universes.Universe08.AbstractSecurityScheme.properties.type.name||v.accept(createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,"Invalid value:"+vl+" allowed values are:"+values,node))):values.length>0&&(_.find(values,function(x){return x==vl})||vl&&0==vl.indexOf("x-")&&pr.nameId()==universes.Universe08.AbstractSecurityScheme.properties.type.name||v.accept(createIssue(hl.IssueCode.UNRESOLVED_REFERENCE,"Invalid value:"+vl+" allowed values are:"+values.join(","),node)))}},NormalValidator}(),UriValidator=function(){function UriValidator(){}return UriValidator.prototype.validate=function(node,cb){try{var values=(new UrlParameterNameValidator).parseUrl(node.value());if(values.some(function(x){return"version"==x})&&"baseUri"==node.property().nameId()){var version=node.root().attr("version");version||cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"missing version",node,!1))}values.some(function(x){return 0==x.length})&&cb.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"URI parameter must have name specified",node,!1))}catch(e){cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,e.message,node,!1))}},UriValidator}(),MediaTypeValidator=function(){function MediaTypeValidator(){}return MediaTypeValidator.prototype.validate=function(node,cb){try{var v=node.value();if(!v)return;if("*/*"==v)return;if(v.indexOf("/*")==v.length-2&&(v=v.substring(0,v.length-2)+"/xxx"),node.parent()&&node.parent().parent()&&node.parent().parent().definition().isAssignableFrom(universes.Universe10.Trait.name)&&v.indexOf("<<")>=0)return;if("body"==v&&node.parent().parent()){var ppc=node.parent().parent().definition().key();(ppc===universes.Universe08.Response||ppc===universes.Universe10.Response||node.parent().parent().definition().isAssignableFrom(universes.Universe10.MethodBase.name))&&(v=node.parent().computedValue("mediaType"))}var res=mediaTypeParser.parse(v);res.type.match(/[\w\d][\w\d!#\$&\-\^_+\.]*/)||cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Invalid media type '"+res.type+"'",node))}catch(e){cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,""+e.message,node))}(node.value()&&"multipart/form-data"==node.value()||"application/x-www-form-urlencoded"==node.value())&&node.parent()&&node.parent().parent()&&node.parent().parent().property()&&node.parent().parent().property().nameId()==universes.Universe10.MethodBase.properties.responses.name&&cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Form related media types can not be used in responses",node,!0))},MediaTypeValidator}(),UrlParameterNameValidator=function(){function UrlParameterNameValidator(){}return UrlParameterNameValidator.prototype.checkBaseUri=function(node,c,vl,v){var bu=c.root().attr("baseUri");if(bu){var tnv=bu.value();try{var pNames=this.parseUrl(tnv);_.find(pNames,function(x){return x==vl})||v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Unused url parameter",node))}catch(e){}}else v.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Unused url parameter",node))},UrlParameterNameValidator.prototype.parseUrl=function(value){for(var result=[],temp="",inPar=!1,count=0,a=0;a<value.length;a++){var c=value[a];"{"!=c?"}"!=c?inPar&&(temp+=c):(count--,inPar=!1,result.push(temp),temp=""):(count++,inPar=!0)}if(count>0)throw new Error("Invalid resource name: unmatched '{'");if(count<0)throw new Error("Invalid resource name: unmatched '}'");return result},UrlParameterNameValidator.prototype.validate=function(node,cb){var vl=node.value();if(node.parent().property().nameId()==universes.Universe10.Api.properties.baseUri.name){var c=node.parent().parent();return void this.checkBaseUri(node,c,vl,cb)}var c=node.parent().parent(),tn=c.name();if(c.definition().key()===universes.Universe10.Api||c.definition().key()===universes.Universe08.Api)return void this.checkBaseUri(node,c,vl,cb);if(c.definition().key()!=universes.Universe10.ResourceType&&c.definition().key()!=universes.Universe08.ResourceType)try{var pNames=this.parseUrl(tn),foundInLocalParameters=_.find(pNames,function(x){return x==vl});if(!foundInLocalParameters){var baseUri=node.root().attr(universes.Universe10.Api.properties.baseUri.name);if(baseUri&&node.name()===universes.Universe08.Api.properties.baseUriParameters.name){var baseUriValue=baseUri.value();if(baseUriValue&&(pNames=this.parseUrl(baseUriValue),pNames&&pNames.length>0&&_.find(pNames,function(x){return x==vl})))return}cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Unused url parameter '"+vl+"'",node))}}catch(e){}},UrlParameterNameValidator}();exports.UrlParameterNameValidator=UrlParameterNameValidator,exports.typeToName={},exports.typeToName[universes.Universe08.Trait.name]="trait",exports.typeToName[universes.Universe08.ResourceType.name]="resource type",exports.typeToName[universes.Universe10.Trait.name]="trait",exports.typeToName[universes.Universe10.ResourceType.name]="resource type",exports.typeToName[universes.Universe10.AbstractSecurityScheme.name]="security scheme",exports.typeToName[universes.Universe10.Method.name]="method",exports.typeToName[universes.Universe08.Method.name]="method",exports.typeToName[universes.Universe10.Resource.name]="resource",exports.typeToName[universes.Universe08.Resource.name]="resource",exports.typeToName[universes.Universe10.Api.name]="api",exports.typeToName[universes.Universe08.Api.name]="api",exports.typeToName[universes.Universe10.Response.name]="response",exports.typeToName[universes.Universe08.Response.name]="response",exports.typeToName[universes.Universe08.BodyLike.name]="body",exports.parameterPropertyToName={},exports.parameterPropertyToName[universes.Universe08.MethodBase.properties.headers.name]="header",exports.parameterPropertyToName[universes.Universe08.MethodBase.properties.queryParameters.name]="query parameter",exports.parameterPropertyToName[universes.Universe08.Api.properties.uriParameters.name]="uri parameter",exports.parameterPropertyToName[universes.Universe08.Api.properties.baseUriParameters.name]="base uri parameter",exports.parameterPropertyToName[universes.Universe08.BodyLike.properties.formParameters.name]="form parameter",exports.parameterPropertyToName[universes.Universe10.MethodBase.properties.headers.name]="header",exports.parameterPropertyToName[universes.Universe10.MethodBase.properties.queryParameters.name]="query parameter",exports.parameterPropertyToName[universes.Universe10.ResourceBase.properties.uriParameters.name]="uri parameter",exports.parameterPropertyToName[universes.Universe10.Api.properties.baseUriParameters.name]="base uri parameter",exports.parameterPropertyToName[universes.Universe10.MethodBase.properties.body.name]="body",exports.getHumanReadableNodeName=getHumanReadableNodeName;var DescriminatorOrReferenceValidator=function(){function DescriminatorOrReferenceValidator(){}return DescriminatorOrReferenceValidator.prototype.validate=function(node,cb){var vl=node.value(),valueKey=vl,pr=node.property();if("string"==typeof vl){if(checkReference(pr,node,vl,cb),pr.range()instanceof def.ReferenceType){var mockNode=(pr.range(),jsyaml.createNode(""+vl,node.lowLevel().parent()));mockNode._actualNode().startPosition=node.lowLevel().valueStart(),mockNode._actualNode().endPosition=node.lowLevel().valueEnd();var stv=new hlimpl.StructuredValue(mockNode,node.parent(),node.property()),hn=stv.toHighLevel();hn&&hn.validate(cb)}}else if(null!=vl){var st=vl;if(st){valueKey=st.valueName();var vn=st.valueName();if(!checkReference(pr,node,vn,cb)){var hnode=st.toHighLevel();hnode&&hnode.validate(cb)}}else valueKey=null}else node.definition().isAssignableFrom(universes.Universe10.Reference.name)&&checkReference(pr,node,null,cb);if(valueKey){var validation=isValid(pr.range(),node.parent(),valueKey,pr);validation instanceof Error&&(cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,validation.message,node)),validation=null)}},DescriminatorOrReferenceValidator}(),RAMLVersionAndFragmentValidator=function(){function RAMLVersionAndFragmentValidator(){}return RAMLVersionAndFragmentValidator.prototype.validate=function(node,v){var u=node.universe(),tv=u.getTypedVersion();if(tv){if("0.8"!==tv&&"1.0"!==tv){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"Unknown version of RAML expected to see one of '#%RAML 0.8' or '#%RAML 1.0'",node);v.accept(i)}var tl=u.getOriginalTopLevelText();if(tl)if(tl!=node.definition().nameId()){if("Api"==node.definition().nameId()){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"Unknown top level type:"+tl,node);v.accept(i)}}else if("Api"==u.getOriginalTopLevelText()){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"Redundant fragment name:"+tl,node);v.accept(i)}}},RAMLVersionAndFragmentValidator}(),RequiredPropertiesAndContextRequirementsValidator=function(){function RequiredPropertiesAndContextRequirementsValidator(){}return RequiredPropertiesAndContextRequirementsValidator.prototype.validate=function(node,v){var _this=this;node.definition().getAdapter(services.RAMLService).getContextRequirements().forEach(function(x){if(!node.checkContextValue(x.name,x.value,x.value)){var message=x.name+(" should be "+x.value+" to use type "+node.definition().nameId());"location"==x.name&&"ParameterLocation.FORM"==x.value&&(message="file type can be only used in web forms"),v.accept(createIssue(hl.IssueCode.MISSED_CONTEXT_REQUIREMENT,message,node))}});var t,isInlinedTemplate=node.definition().getAdapter(services.RAMLService).isInlinedTemplates();if(isInlinedTemplate){for(var paramsMap={},_i=0,_a=node.lowLevel().children();_i<_a.length;_i++){var ch=_a[_i];paramsMap[ch.key()]=ch.value(!0)}for(var templateKind=node.definition().isAssignableFrom(universes.Universe10.Trait.name)?"trait":"resource type",unitsChain=expander.toUnits(node),vt=new expander.ValueTransformer(templateKind,node.definition().nameId(),unitsChain,paramsMap),parent=node.parent(),def=parent?parent.definition():node.definition();null!=parent&&!universeHelpers.isResourceType(def)&&!universeHelpers.isMethodType(def);)parent=parent.parent();t=new expander.DefaultTransformer(parent,vt,unitsChain)}node.definition().requiredProperties().forEach(function(x){if(isInlinedTemplate){var paths=x.getAdapter(services.RAMLPropertyService).meta("templatePaths");if(paths){for(var parent=node.parent(),hasSufficientChild=!1,_i=0,paths_1=paths;_i<paths_1.length;_i++){var path=paths_1[_i];if(path=path.map(function(x){return t.transform(x).value}),_this.checkPathSufficiency(parent.lowLevel(),path,parent)){hasSufficientChild=!0;break}}if(!hasSufficientChild)return}}var r=x.range();if(r.hasArrayInHierarchy()&&(r=r.arrayInHierarchy().componentType()),r.hasValueTypeInHierarchy()){var nm=node.attr(x.nameId()),gotValue=!1;if(null!=nm&&(nm.lowLevel().kind()==yaml.Kind.SCALAR||nm.lowLevel().valueKind()==yaml.Kind.SCALAR||nm.lowLevel().kind()==yaml.Kind.INCLUDE_REF||nm.lowLevel().valueKind()==yaml.Kind.INCLUDE_REF||null===nm.lowLevel().valueKind()&&!isInlinedTemplate?gotValue=!0:0!=nm.lowLevel().children().length&&(gotValue=!0)),!gotValue){var msg="Missing required property "+x.nameId();isInlinedTemplate&&(msg="value was not provided for parameter: "+x.nameId());var i=createIssue(hl.IssueCode.MISSING_REQUIRED_PROPERTY,msg,node);v.accept(i)}}else{var el=node.elementsOfKind(x.nameId());if(!el||0==el.length){var i=createIssue(hl.IssueCode.MISSING_REQUIRED_PROPERTY,"Missing required property "+x.nameId(),node);v.accept(i)}}})},RequiredPropertiesAndContextRequirementsValidator.prototype.checkPathSufficiency=function(node,path,hlParent){if(null==hlParent||null==hlParent.definition())return!1;var definition=hlParent.definition();if(universeHelpers.isResourceTypeType(definition)||universeHelpers.isTraitType(definition))return!0;if(0==path.length)return!1;if(null==node)return!1;var segment=path[0];if(null==segment)return!1;if("/"==segment)return this.checkPathSufficiency(node,path.slice(1),hlParent);if(0==segment.length)return!0;var children=node.children().filter(function(x){return x.key()==segment});0==children.length&&path.indexOf("/")<0;var lowLevel=children[0];if(lowLevel instanceof proxy.LowLevelCompositeNode&&(lowLevel=lowLevel.primaryNode()),null==lowLevel)return path.indexOf("/")<0;if("type"==lowLevel.key())return!0;if(1==path.length)return null==lowLevel||null==lowLevel.value();var path1=path.slice(1);return this.checkPathSufficiency(lowLevel,path1,hlParent)},RequiredPropertiesAndContextRequirementsValidator}(),ScalarQuoteValidator=function(){function ScalarQuoteValidator(){}return ScalarQuoteValidator.prototype.validate=function(node,v){var r=node.lowLevel().unit();node.lowLevel().visit(function(x){if(x.unit()!=r)return!1;if(x.value()&&x._node&&x._node.value&&x._node.value.doubleQuoted){var ind=(x.value()+"").indexOf(":"),nl=(x.value()+"").indexOf("\n");if(ind!=-1&&nl!=-1&&(!x.includePath()||0==x.includePath().length)){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,'Suspicious double quoted multiline scalar, it is likely that you forgot closing " '+x.value(),node,!0);i.start=x._node.value.startPosition,i.end=x._node.value.endPosition,i.start==i.end&&i.end++,v.accept(i)}}return!0})},ScalarQuoteValidator}(),FixedFacetsValidator=function(){function FixedFacetsValidator(){}return FixedFacetsValidator.prototype.validate=function(node,v){var nc=node.definition(),dnode=nc.getAdapter(services.RAMLService).getDeclaringNode();if(dnode){var rof=dnode.parsedType(),dp=node.lowLevel().dumpToObject(!0);dp&&(dp=dp[Object.keys(dp)[0]]);var validateObject=rof.validate(dp,!1,!1);validateObject.isOk()||validateObject.getErrors().forEach(function(e){return v.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,e.getMessage(),mapPath(node,e),!1))})}},FixedFacetsValidator}(),TypeDeclarationValidator=function(){function TypeDeclarationValidator(){}return TypeDeclarationValidator.prototype.validate=function(node,v){var rof=(node.definition(),node.parsedType()),validateObject=rof.validateType(node.types().getAnnotationTypeRegistry());if(!validateObject.isOk())for(var _i=0,_a=validateObject.getErrors();_i<_a.length;_i++){var issue,e=_a[_i],n=extractLowLevelNode(e);issue=n?createLLIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,e.getMessage(),n,mapPath(node,e),e.isWarning()):createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,e.getMessage(),mapPath(node,e),e.isWarning()),v.accept(issue)}var examplesLowLevel=node.lowLevel()&&node.lowLevel().find&&node.lowLevel().find("examples");examplesLowLevel&&examplesLowLevel.valueKind&&examplesLowLevel.valueKind()===yaml.Kind.SEQ&&(issue=createLLIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,"map is expected here.",examplesLowLevel,node,!1),v.accept(issue))},TypeDeclarationValidator}(),CompositeNodeValidator=function(){function CompositeNodeValidator(){}return CompositeNodeValidator.prototype.validate=function(node,acceptor){if(!node.definition().isAnnotationType()){if(node.lowLevel().keyKind()==yaml.Kind.SEQ){var isPattern=node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name);isPattern||acceptor.accept(createIssue(hl.IssueCode.UNKNOWN_NODE,"Node key can not be sequence",node))}if(node.definition().key()==universes.Universe08.GlobalSchema&&node.lowLevel().valueKind()!=yaml.Kind.SCALAR){var isString=!1;if(node.lowLevel().valueKind()==yaml.Kind.ANCHOR_REF||node.lowLevel().valueKind()==yaml.Kind.INCLUDE_REF){var vl=node.lowLevel().value();"string"==typeof vl&&(isString=!0)}isString||acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"schema "+node.name()+" must be a string",node))}node.parent()||((new RAMLVersionAndFragmentValidator).validate(node,acceptor),node.definition().key()!=universes.Universe08.Api&&node.definition().key()!=universes.Universe10.Api||(new OverloadingValidator).validateApi(node.wrapperNode(),acceptor),(new ScalarQuoteValidator).validate(node,acceptor),lintNode(node,acceptor)),(new OverlayNodesValidator).validate(node,acceptor);var nc=node.definition();if(nc.key()==universes.Universe08.BodyLike&&node.lowLevel().children().map(function(x){return x.key()}).some(function(x){return"formParameters"===x}))if(node.parent()&&node.parent().definition().key()==universes.Universe08.Response){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"form parameters can not be used in response",node);acceptor.accept(i)}else if(node.lowLevel().children().map(function(x){return x.key()}).some(function(x){return"schema"===x||"example"===x})){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"formParameters cannot be used together with the example or schema properties",node);acceptor.accept(i)}if(nc.key()==universes.Universe10.OAuth2SecuritySchemeSettings){var requireUrl=!1;if(node.attributes("authorizationGrants").forEach(function(x){var vl=x.value();if("authorization_code"===vl||"implicit"===vl)requireUrl=!0;else if("password"!==vl&&"client_credentials"!==vl&&vl&&"string"==typeof vl&&vl.indexOf("://")==-1&&vl.indexOf(":")==-1){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"authorizationGrants should be one of authorization_code,implicit,password,client_credentials or to be an abolute URI",x);acceptor.accept(i)}}),requireUrl&&!node.attr("authorizationUri")){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"authorizationUri is required when `authorization_code` or `implicit` grant type are used ",node);acceptor.accept(i)}}if(node.definition().isAssignableFrom(universes.Universe08.Parameter.name)||node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)){var vls=node.attributes("enum").map(function(x){return x.value()});if(vls.length!=_.uniq(vls).length){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"enum contains duplicated values",node);acceptor.accept(i)}if(node.definition().isAssignableFrom(universes.Universe08.NumberTypeDeclaration.name)||node.definition().isAssignableFrom(universes.Universe10.NumberTypeDeclaration.name)){var isInteger=node.definition().isAssignableFrom(universes.Universe08.IntegerTypeDeclaration.name)||node.definition().isAssignableFrom(universes.Universe10.IntegerTypeDeclaration.name);node.attributes("enum").forEach(function(attribute){var value=isInteger?parseInt(attribute.value()):parseFloat(attribute.value()),isValid=isInteger?!isNaN(value)&&attribute.value().indexOf(".")===-1:!isNaN(value);if(!isValid){var issue=createIssue(hl.IssueCode.NODE_HAS_VALUE,(isInteger?"Integer":"Number")+" is expected",attribute);acceptor.accept(issue)}})}}universeHelpers.isResourceTypeType(node.definition())&&null==node.value()&&"null"===node.lowLevel().value(!0)&&acceptor.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Resource type can not be null",node)),checkPropertyQuard(node,acceptor);var nodeValue=node.value();if(("string"==typeof nodeValue||"number"==typeof nodeValue||"boolean"==typeof nodeValue)&&!node.definition().getAdapter(services.RAMLService).allowValue()&&node.parent()&&"~"!=nodeValue){var i=createIssue(hl.IssueCode.NODE_HAS_VALUE,"node "+node.name()+" can not be a scalar",node);acceptor.accept(i)}(new RequiredPropertiesAndContextRequirementsValidator).validate(node,acceptor),(new ValidateChildrenKeys).validate(node,acceptor),(new NodeSpecificValidator).validate(node,acceptor)}},CompositeNodeValidator}(),BaseUriParameterValidator=function(){function BaseUriParameterValidator(){}return BaseUriParameterValidator.prototype.validate=function(node,acceptor){var nameAttributeValue=node.attrValue(universes.Universe10.TypeDeclaration.properties.name.name);"version"==nameAttributeValue&&acceptor.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY,"version parameter not allowed here",node))},BaseUriParameterValidator}(),NodeSpecificValidatorRegistryEntry=function(){function NodeSpecificValidatorRegistryEntry(definitions,propertyName,validator,assignableFrom){void 0===assignableFrom&&(assignableFrom=!1),this.definitions=definitions,this.propertyName=propertyName,this.assignableFrom=assignableFrom,this.validator=validator}return NodeSpecificValidatorRegistryEntry.prototype.validate=function(node,acceptor){var nodeDefinition=node.definition();if(null!=nodeDefinition){var definitionMatched=!1;if(definitionMatched=this.assignableFrom?this.definitions.some(function(currentDefinition){return nodeDefinition.isAssignableFrom(currentDefinition.name)}):this.definitions.some(function(currentDefinition){return currentDefinition===nodeDefinition})){if(null!=this.propertyName){if(null==node.property())return;if(node.property().nameId()!=this.propertyName)return}this.validator.validate(node,acceptor)}}},NodeSpecificValidatorRegistryEntry}(),NodeSpecificValidator=function(){function NodeSpecificValidator(){}return NodeSpecificValidator.createRegistry=function(){var result=[];return NodeSpecificValidator.registerValidator(result,[universes.Universe10.TypeDeclaration,universes.Universe08.Parameter],universes.Universe10.Api.properties.baseUriParameters.name,new BaseUriParameterValidator,!0),
result},NodeSpecificValidator.registerValidator=function(listToAddTo,definitions,propertyName,validator,assignableFrom){void 0===assignableFrom&&(assignableFrom=!1);var entry=new NodeSpecificValidatorRegistryEntry(definitions,propertyName,validator,assignableFrom);listToAddTo.push(entry)},NodeSpecificValidator.prototype.validate=function(node,acceptor){NodeSpecificValidator.entries.forEach(function(entry){return entry.validate(node,acceptor)})},NodeSpecificValidator.entries=NodeSpecificValidator.createRegistry(),NodeSpecificValidator}(),OverlayNodesValidator=function(){function OverlayNodesValidator(){}return OverlayNodesValidator.prototype.allowsAnyChildren=function(node,root){var property=node.property(),definition=node.definition();return!(!universeHelpers.isAnnotationTypeType(definition)&&!universeHelpers.isTypeDeclarationTypeOrDescendant(definition)||!universeHelpers.isAnnotationTypesProperty(property))||(!(node.parent()!=root||!universeHelpers.isTypesProperty(property)||!universeHelpers.isTypeDeclarationTypeOrDescendant(definition))||(!(!universeHelpers.isSchemasProperty(property)||!universeHelpers.isTypeDeclarationTypeOrDescendant(definition))||(!(node.parent()!=root||!universeHelpers.isDocumentationProperty(property)||!universeHelpers.isDocumentationType(definition))||(!!universeHelpers.isAnnotationsProperty(property)||(!!universeHelpers.isUsesProperty(property)||!!universeHelpers.isExamplesProperty(property))))))},OverlayNodesValidator.prototype.nodeAllowedDueToParent=function(node,root){for(var currentNode=node;currentNode!=root&&null!=currentNode;){if(this.allowsAnyChildren(currentNode,root))return!0;currentNode=currentNode.parent()}return!1},OverlayNodesValidator.prototype.validate=function(node,v){var root=node.root();node.property(),node.definition();if(universeHelpers.isOverlayType(root.definition())){if(node==root)return void this.validateProperties(node,v);if(!this.nodeAllowedDueToParent(node,root)){var overrides=root.knownIds();if(overrides){var override=overrides.hasOwnProperty(node.id());return override?void this.validateProperties(node,v):void v.accept(createIssue(hl.IssueCode.ONLY_OVERRIDE_ALLOWED,"The '"+node.id()+"' node does not match any node of the master api.",node))}}}},OverlayNodesValidator.prototype.validateProperties=function(node,acceptor){node.attrs().forEach(function(attribute){if(!(attribute.property().getAdapter(services.RAMLPropertyService).isKey()||attribute.parent()!=node||attribute.isElement()||universeHelpers.isTitlePropertyName(attribute.name())||universeHelpers.isDescriptionPropertyName(attribute.name())||universeHelpers.isDisplayNamePropertyName(attribute.name())||universeHelpers.isUsagePropertyName(attribute.name())||universeHelpers.isExampleProperty(attribute.property())||universeHelpers.isMasterRefProperty(attribute.property())||universeHelpers.isAnnotationsProperty(attribute.property())||universeHelpers.isUsesProperty(attribute.property()))){var message="Property "+attribute.name()+" is not allowed to be overriden or added in overlays";acceptor.accept(createIssue(hl.IssueCode.ONLY_OVERRIDE_ALLOWED,message,attribute))}})},OverlayNodesValidator}(),RecurrentOverlayValidator=function(){function RecurrentOverlayValidator(){}return RecurrentOverlayValidator.prototype.validate=function(node,v){var _this=this,z=new OverlayNodesValidator;z.validate(node,v),node.directChildren().forEach(function(x){x.isElement()&&_this.validate(x.asElement(),v)})},RecurrentOverlayValidator}(),RecurrentValidateChildrenKeys=function(){function RecurrentValidateChildrenKeys(){}return RecurrentValidateChildrenKeys.prototype.val=function(node,v,p){var _this=this;if(node.kind()==yaml.Kind.MAP||node.kind()==yaml.Kind.MAPPING){var ms={};node.children().forEach(function(x){var c=x.key();if(c){if(ms.hasOwnProperty(c)){var issue=createIssue(hl.IssueCode.KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT,"keys should be unique",p,!1);x.unit()==p.lowLevel().unit()&&(issue.start=x.keyStart(),issue.end=x.keyEnd()),v.accept(issue)}ms[c]=1}})}node.children().forEach(function(x){_this.val(x,v,p)})},RecurrentValidateChildrenKeys.prototype.validate=function(node,v){this.val(node.lowLevel(),v,node)},RecurrentValidateChildrenKeys}(),ValidateChildrenKeys=function(){function ValidateChildrenKeys(){}return ValidateChildrenKeys.prototype.validate=function(node,acceptor){this.validateChildElements(node,acceptor);var lowLevelChildren=node.lowLevel().children(),keyToLowLevelChildren=_.groupBy(lowLevelChildren.filter(function(x){return null!=x.key()}),function(x){return x.key()});this.validateChildAttributes(node,keyToLowLevelChildren,acceptor),this.validateUnrecognizedLowLevelChildren(node,keyToLowLevelChildren,acceptor)},ValidateChildrenKeys.prototype.validateChildElements=function(node,acceptor){var keyToElements={},childElements=node.directChildren().filter(function(x){return x.isElement()});childElements.forEach(function(childNode){var childElement=childNode;if(!childElement._computed&&childElement.name()){var elementKey=childElement.name()+childElement.property().nameId();keyToElements.hasOwnProperty(elementKey)?childElement.isNamePatch()||keyToElements[elementKey].push(childElement):keyToElements[elementKey]=[childElement]}}),Object.keys(keyToElements).forEach(function(key){var childElements=keyToElements[key];!childElements||childElements.length<2||childElements.forEach(function(childElement){var message="",humanReadableName=getHumanReadableNodeName(childElement);if(humanReadableName)var capitalized=humanReadableName.charAt(0).toUpperCase()+humanReadableName.slice(1),message=capitalized+" '"+childElement.name()+"' already exists";else message=childElement.name()+" already exists in this context";var issue=createIssue(hl.IssueCode.KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT,message,childElement);acceptor.accept(issue)})})},ValidateChildrenKeys.prototype.validateChildAttributes=function(node,keyToLowLevelChildren,acceptor){var highLevelAttributes=this.getHighLevelAttributes(node),nameToHighLevelAttributes=_.groupBy(highLevelAttributes,function(x){return x.name()}),allowsAnyAndHasRequireds=this.allowsAnyAndHasRequireds(node);Object.keys(nameToHighLevelAttributes).forEach(function(attributeName){if(!(nameToHighLevelAttributes[attributeName].length<2)){var isUnknown=nameToHighLevelAttributes[attributeName][0].isUnknown(),isMultiValue=!isUnknown&&nameToHighLevelAttributes[attributeName][0].property().isMultiValue();isMultiValue&&(node.definition().isAssignableFrom(universes.Universe08.SecuritySchemeSettings.name)||node.definition().isAssignableFrom(universes.Universe10.SecuritySchemeSettings.name))&&(isMultiValue=keyToLowLevelChildren[attributeName]&&1===keyToLowLevelChildren[attributeName].length),(isUnknown&&allowsAnyAndHasRequireds||!isMultiValue||isMultiValue&&null!=keyToLowLevelChildren[attributeName]&&keyToLowLevelChildren[attributeName].length>1)&&nameToHighLevelAttributes[attributeName].forEach(function(attribute){var message="property already used: '"+(attribute.property()?attribute.property().nameId():attribute.name())+"'",humanReadableParent=getHumanReadableNodeName(attribute.parent());if(humanReadableParent){var capitalizedParent=humanReadableParent.charAt(0).toUpperCase()+humanReadableParent.slice(1);message=capitalizedParent+" "+message}var issue=createIssue(hl.IssueCode.PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE,message,attribute);acceptor.accept(issue)})}})},ValidateChildrenKeys.prototype.validateUnrecognizedLowLevelChildren=function(node,keyToLowLevelChildren,acceptor){var highLevelChildren=node.directChildren(),nameToHighLevelChildren=_.groupBy(highLevelChildren,function(x){return x.name()});Object.keys(keyToLowLevelChildren).forEach(function(lowLevelChildKey){if(lowLevelChildKey&&keyToLowLevelChildren[lowLevelChildKey].length>1&&!nameToHighLevelChildren[lowLevelChildKey]){if(node.definition().isAssignableFrom(universes.Universe10.ObjectTypeDeclaration.name))return;var message="property already used: '"+lowLevelChildKey+"'",humanReadableNode=getHumanReadableNodeName(node);if(humanReadableNode){var capitalizedParent=humanReadableNode.charAt(0).toUpperCase()+humanReadableNode.slice(1);message=capitalizedParent+" "+message}keyToLowLevelChildren[lowLevelChildKey].forEach(function(lowLevelChild){var i=createLLIssue(hl.IssueCode.PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE,message,lowLevelChild,node);i.start=lowLevelChild.keyStart(),i.end=lowLevelChild.keyEnd(),acceptor.accept(i)})}})},ValidateChildrenKeys.prototype.filterMultiValueAnnotations=function(node,keyToLowLevelChildren,acceptor){this.getHighLevelAttributes(node);Object.keys(keyToLowLevelChildren).forEach(function(lowLevelChildKey){"("!==lowLevelChildKey.charAt(0)||keyToLowLevelChildren[lowLevelChildKey].length<2})},ValidateChildrenKeys.prototype.getHighLevelAttributes=function(node){var allowsAnyAndHasRequireds=this.allowsAnyAndHasRequireds(node);return node.directChildren().filter(function(x){return x.isAttr()||allowsAnyAndHasRequireds})},ValidateChildrenKeys.prototype.allowsAnyAndHasRequireds=function(node){var requireds=node.definition().requiredProperties(),hasRequireds=requireds&&requireds.length>0,ramlService=node.definition().getAdapter(services.RAMLService),isAllowAny=ramlService&&ramlService.getAllowAny(),anyExceptRequireds=isAllowAny&&hasRequireds;return anyExceptRequireds},ValidateChildrenKeys}(),ExampleAndDefaultValueValidator=function(){function ExampleAndDefaultValueValidator(){}return ExampleAndDefaultValueValidator.prototype.validate=function(node,cb){var strictValidation=this.isStrict(node);if(strictValidation||settings.validateNotStrictExamples){var pObj=this.parseObject(node,cb,strictValidation);if(pObj){var schema=this.aquireSchema(node);schema&&schema.validate(pObj,cb,strictValidation)}}},ExampleAndDefaultValueValidator.prototype.isExampleNode=function(node){return this.isSingleExampleNode(node)||this.isExampleNodeInMultipleDecl(node)},ExampleAndDefaultValueValidator.prototype.isSingleExampleNode=function(node){return node.name()==universes.Universe10.TypeDeclaration.properties.example.name},ExampleAndDefaultValueValidator.prototype.isExampleNodeInMultipleDecl=function(node){var parent=node.parent();return!!parent&&universeHelpers.isExampleSpecType(parent.definition())},ExampleAndDefaultValueValidator.prototype.findParentSchemaOrTypeAttribute=function(node){var attribute=node.parent().attr(universes.Universe10.TypeDeclaration.properties.schema.name);return attribute?attribute:(attribute=node.parent().attr(universes.Universe10.TypeDeclaration.properties.type.name))?attribute:node.parent()?(attribute=node.parent().parent().attr(universes.Universe10.TypeDeclaration.properties.schema.name))?attribute:(attribute=node.parent().parent().attr(universes.Universe10.TypeDeclaration.properties.type.name),attribute?attribute:null):null},ExampleAndDefaultValueValidator.prototype.aquireSchema=function(node){var sp=node.parent().definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name);if(this.isExampleNode(node)){var sampleRoot=node;if(this.isExampleNodeInMultipleDecl(node)&&(sampleRoot=node.parent()),sampleRoot.parent()&&(sampleRoot.parent().definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&null===sampleRoot.parent().parent()?sp=!1:sampleRoot.parent().property().nameId()==universes.Universe10.LibraryBase.properties.types.name&&(sp=!1),sampleRoot.parent().parent())){var ppc=sampleRoot.parent().parent().definition().key();ppc!=universes.Universe08.Method&&ppc!=universes.Universe10.Method||sampleRoot.parent().property().nameId()==universes.Universe10.MethodBase.properties.queryParameters.name||(sp=!0),ppc!=universes.Universe08.Response&&ppc!=universes.Universe10.Response||(sp=!0)}}if(node.parent().definition().key()==universes.Universe08.BodyLike||sp){var sa=this.findParentSchemaOrTypeAttribute(node);if(sa){var val=sa.value();if(val instanceof hlimpl.StructuredValue)return null;var strVal=(""+val).trim(),so=null;if("{"==strVal.charAt(0))try{so=su.getJSONSchema(strVal,contentProvider(sa.lowLevel()))}catch(e){return null}if("<"==strVal.charAt(0))try{so=su.getXMLSchema(strVal)}catch(e){return null}if(so)return{validate:function(pObje,cb,strict){try{if(pObje.__$validated)return;if(so instanceof Error)return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,so.message,node,!strict));so.validateObject(pObje)}catch(e){var illegalRequiredMessageStart="Cannot assign to read only property '__$validated' of ";if(e.message&&0==e.message.indexOf(illegalRequiredMessageStart)){var propertyName=e.message.substr(illegalRequiredMessageStart.length,e.message.length-illegalRequiredMessageStart.length),patchedErrorMessage="Invalid JSON schema. Potentially, required array containing value "+propertyName+" has invalid location";return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,patchedErrorMessage,sa,!strict))}if("Object.keys called on non-object"==e.message)return;return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Example does not conform to schema:"+e.message,node,!strict))}}};if(strVal.length>0){var nodeParent=node.parent(),grandParent=nodeParent&&nodeParent.parent(),owner=nodeParent&&nodeParent.definition()&&nodeParent.definition().isAssignableFrom(universes.Universe10.ObjectTypeDeclaration.name)&&nodeParent;if(owner=owner||grandParent&&grandParent.definition()&&grandParent.definition().isAssignableFrom(universes.Universe10.ObjectTypeDeclaration.name)&&grandParent)return this.typeValidator(owner,node)}}}return this.getSchemaFromModel(node)},ExampleAndDefaultValueValidator.prototype.getSchemaFromModel=function(node){var p=node.parent();return this.typeValidator(p,node)},ExampleAndDefaultValueValidator.prototype.typeValidator=function(p,node){var newVar={validate:function(pObje,cb,strict){var pt=p.parsedType();if(pt&&!pt.isUnknown()){"number"==typeof pObje&&pt.isString()&&(pObje=""+pObje),"boolean"==typeof pObje&&pt.isString()&&(pObje=""+pObje),pt.getExtra("repeat")&&(pObje=[pObje]);var validateObject=pt.validate(pObje,!1);validateObject.isOk()||validateObject.getErrors().forEach(function(e){return cb.accept(createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,e.getMessage(),node,!strict))})}}};return newVar},ExampleAndDefaultValueValidator.prototype.toObject=function(h,v,cb){var res=v.lowLevel().dumpToObject(!0);return this.testDublication(h,v.lowLevel(),cb),res.example?res.example:res.content?res.content:void 0},ExampleAndDefaultValueValidator.prototype.testDublication=function(h,v,cb){var _this=this,map={};v.children().forEach(function(x){x.key()&&(map[x.key()]&&cb.accept(createIssue(hl.IssueCode.KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT,"Keys should be unique",new hlimpl.BasicASTNode(x,h.parent()))),map[x.key()]=x),_this.testDublication(h,x,cb)})},ExampleAndDefaultValueValidator.prototype.parseObject=function(node,cb,strictValidation){var pObj=null,vl=node.value(),mediaType=getMediaType(node);if(vl instanceof hlimpl.StructuredValue)pObj=this.toObject(node,vl,cb);else if(mediaType){if(isJson(mediaType))try{pObj=JSON.parse(vl)}catch(e){return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Can not parse JSON:"+e.message,node,!strictValidation))}if(isXML(mediaType))try{pObj=xmlutil(vl)}catch(e){return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Can not parse XML:"+e.message,node,!strictValidation))}}else try{if(!(vl&&vl.length>0)||"["!=vl.trim().charAt(0)&&"{"!=vl.trim().charAt(0)&&"<"!=vl.trim().charAt(0)){if("true"==vl)return!0;if("false"==vl)return!1;var n=parseFloat(vl);return isNaN(n)?vl:n}pObj=JSON.parse(vl)}catch(e){if(0!=vl.trim().indexOf("<"))return vl;try{pObj=xmlutil(vl)}catch(e){return void cb.accept(createIssue(hl.IssueCode.INVALID_VALUE_SCHEMA,"Can not parse XML:"+e.message,node,!strictValidation))}}return pObj},ExampleAndDefaultValueValidator.prototype.isStrict=function(node){if(universeHelpers.isDefaultValue(node.property()))return!0;if(universeHelpers.isExampleProperty(node.property())&&"RAML08"==node.parent().definition().universe().version())return!1;var strictValidation=!1,strict=node.parent().attr("strict");return strict&&"true"==strict.value()&&(strictValidation=!0),strictValidation},ExampleAndDefaultValueValidator}();exports.ExampleAndDefaultValueValidator=ExampleAndDefaultValueValidator;var toReadableName=function(template,toLowerCase,pluralize_){var templateName=changeCase.sentence(template);return toLowerCase||(templateName=changeCase.ucFirst(templateName)),pluralize_&&(templateName=pluralize.plural(templateName)),templateName},OptionalPropertiesValidator=function(){function OptionalPropertiesValidator(){}return OptionalPropertiesValidator.prototype.validate=function(node,v){if(node.isAttr()){if(!node.optional())return;var attr=node,prop=attr.property();if(prop.isMultiValue()||prop.range().isArray())return;if(!prop.isFromParentKey()){var template=typeOfContainingTemplate(attr.parent());if(template&&prop.isValueProperty()){var templateNamePlural=toReadableName(template,!0,!0),message="Optional scalar properties are not allowed in "+templateNamePlural+" and their descendants: "+attr.name()+"?",issue=createIssue(hl.IssueCode.INVALID_PROPERTY,message,attr,!1);v.accept(issue)}}}else if(node.isElement()){var aNode=node,prop=aNode.property(),allowsQuestion=aNode.allowsQuestion();if(!allowsQuestion){var propName=prop?toReadableName(prop.nameId(),!0,!0):"API root";aNode.optionalProperties().forEach(function(x){aNode.children().forEach(function(y){var message="Optional properties are not allowed in "+propName+": "+y.lowLevel().key()+"?",issue=createIssue(hl.IssueCode.INVALID_PROPERTY,message,node,!1);v.accept(issue)})})}var def=node.asElement().definition();if(node.optional()&&"RAML10"==def.universe().version()){var prop=node.property(),isParam=universeHelpers.isQueryParametersProperty(prop)||universeHelpers.isUriParametersProperty(prop)||universeHelpers.isHeadersProperty(prop);if(!(universeHelpers.isMethodType(def)||universeHelpers.isTypeDeclarationType(def)&&isParam)){var issue=createIssue(hl.IssueCode.MISSED_CONTEXT_REQUIREMENT,"Only method nodes can be optional",node,!1);v.accept(issue)}}}},OptionalPropertiesValidator}(),UriParametersValidator=function(){function UriParametersValidator(){}return UriParametersValidator.prototype.validate=function(node,v){var def=node.definition(),baseUriPropName=universes.Universe10.Api.properties.baseUri.name,baseUriParamsPropName=universes.Universe10.Api.properties.baseUriParameters.name,uriPropName=universes.Universe10.Resource.properties.relativeUri.name,uriParamsPropName=universes.Universe10.ResourceBase.properties.uriParameters.name;if(universeHelpers.isApiSibling(def))this.inspectParameters(node,v,baseUriPropName,baseUriParamsPropName);else if(universeHelpers.isResourceType(def)){var rootNode=node.root();this.inspectParameters(node,v,baseUriPropName,baseUriParamsPropName,rootNode),this.inspectParameters(node,v,uriPropName,uriParamsPropName)}else if(universeHelpers.isResourceTypeType(def)){var rootNode=node.root();this.inspectParameters(node,v,baseUriPropName,baseUriParamsPropName,rootNode)}},UriParametersValidator.prototype.inspectParameters=function(node,v,uriPropName,paramsPropName,rootNode){rootNode=rootNode||node;var uriValue="",uriAttr=rootNode.attr(uriPropName);uriAttr&&(uriValue=uriAttr.value(),uriValue||(uriValue=""));var paramElements=node.elementsOfKind(paramsPropName);paramElements.forEach(function(x){var nameAttr=x.attr(universes.Universe10.TypeDeclaration.properties.name.name);if(nameAttr){var name=nameAttr.value();if(null!=name&&uriValue.indexOf("{"+name+"}")<0){if(universeHelpers.isResourceTypeType(node.definition())&&name.indexOf("<<")>=0)return;var propNameReadable=pluralize.singular(changeCase.sentence(paramsPropName)),message=changeCase.ucFirst(propNameReadable)+" unused",issue=createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,message,x,!0);v.accept(issue)}}})},UriParametersValidator}(),TemplateCyclesDetector=function(){function TemplateCyclesDetector(){this.nameProperty=universes.Universe10.ResourceType.properties.name.name}return TemplateCyclesDetector.prototype.validate=function(node,v){var definition=node.definition();if(universeHelpers.isLibraryBaseSibling(definition)||universeHelpers.isApiType(definition)){var typeProp=(universes.Universe10.LibraryBase.properties.resourceTypes.name,universes.Universe10.ResourceBase.properties.type.name),isProp=(universes.Universe10.LibraryBase.properties.traits.name,universes.Universe10.MethodBase.properties.is.name),allResourceTypes=search.globalDeclarations(node).filter(function(x){return universeHelpers.isResourceTypeType(x.definition())}),alltraits=search.globalDeclarations(node).filter(function(x){return universeHelpers.isTraitType(x.definition())});this.checkCycles(allResourceTypes,typeProp,v),this.checkCycles(alltraits,isProp,v)}},TemplateCyclesDetector.prototype.checkCycles=function(templates,propName,v){var _this=this,templatesMap={};templates.forEach(function(x){var name=_this.templateName(x);templatesMap[name]=x});var templatesWithCycle={};templates.forEach(function(template){var name=_this.templateName(template);templatesWithCycle[name]||_this.findCyclesInDefinition(template,propName,templatesMap).forEach(function(cycle){cycle.forEach(function(x){return templatesWithCycle[x]=!0}),cycle=cycle.reverse();var message=toReadableName(template.definition().nameId())+" definition contains cycle: "+cycle.join(" -> "),issue=createIssue(hl.IssueCode.ILLEGAL_PROPERTY_VALUE,message,template,!1);v.accept(issue)})})},TemplateCyclesDetector.prototype.templateName=function(node){var nameAttribute=node.attr(this.nameProperty);return nameAttribute?nameAttribute.value():null},TemplateCyclesDetector.prototype.findCyclesInDefinition=function(node,propName,templatesMap,occuredTemplates){void 0===occuredTemplates&&(occuredTemplates={});var name=this.templateName(node);if(occuredTemplates[name])return[[name]];var nextOccuredTemplates={};Object.keys(occuredTemplates).forEach(function(x){return nextOccuredTemplates[x]=occuredTemplates[x]}),nextOccuredTemplates[name]=!0;for(var occuredCycles=[],templatesRefs=node.attributes(propName),i=0;i<templatesRefs.length;i++){var ref=templatesRefs[i],val=ref.value();if(val){var refName="string"==typeof val?val:val.valueName(),template=templatesMap[refName];if(null!=template){var newCycles=this.findCyclesInDefinition(template,propName,templatesMap,nextOccuredTemplates);newCycles.forEach(function(x){return occuredCycles.push(x)})}}}return occuredCycles.forEach(function(x){return x.push(name)}),occuredCycles},TemplateCyclesDetector}();exports.isJson=isJson,exports.isXML=isXML,exports.getMediaType=getMediaType;var localError=function(node,c,w,message,p,prop,positionsSource){var llNode=positionsSource?positionsSource:node.lowLevel(),contents=llNode.unit()&&llNode.unit().contents(),contentLength=contents&&contents.length,st=llNode.start(),et=llNode.end();if(contentLength&&contentLength<et&&(et=contentLength-1),llNode.key()&&llNode.keyStart()){var ks=llNode.keyStart();ks>0&&(st=ks);var ke=llNode.keyEnd();ke>0&&(et=ke)}if(et<st&&(et=st+1,node.isElement())){var definition=node.definition();universeHelpers.isApiType(definition)&&(st=0==contentLength?0:contentLength-1,et=st)}if(prop&&!prop.getAdapter(services.RAMLPropertyService).isMerged()&&null==node.parent()){var nm=_.find(llNode.children(),function(x){return x.key()==prop.nameId()});if(nm){var ks=nm.keyStart(),ke=nm.keyEnd();ks>0&&ke>ks&&(st=ks,et=ke)}}return{code:c,isWarning:w,message:message,node:node,start:st,end:et,path:p?llNode.unit()?llNode.unit().path():"":null,extras:[],unit:node?llNode.unit():null}},localLowLevelError=function(node,highLevelAnchor,issueCode,isWarning,message,path){var contents=node.unit()&&node.unit().contents(),contentLength=contents&&contents.length,st=node.start(),et=node.end();if(contentLength&&contentLength>=et&&(et=contentLength-1),node.key()&&node.keyStart()){var ks=node.keyStart();ks>0&&(st=ks);var ke=node.keyEnd();ke>0&&(et=ke)}return{code:issueCode,isWarning:isWarning,message:message,node:highLevelAnchor,start:st,end:et,path:path?node.unit()?node.unit().path():"":null,extras:[],unit:node?node.unit():null}};exports.toIssue=toIssue,exports.createIssue=createIssue,exports.createLLIssue=createLLIssue,exports.validateResponseString=validateResponseString}).call(exports,__webpack_require__(59))},function(module,exports,__webpack_require__){"use strict";function getAllOptions(c,deep){if(void 0===deep&&(deep=0),deep>20)return[];try{var result=[],tp=c.leftType();tp&&result.push(tp);var r=c.rightType();if(r)if(r.hasUnionInHierarchy()){var options=getAllOptions(r.unionInHierarchy(),deep+1);result=result.concat(options)}else result.push(r);return result}finally{}}function getBaseType(node,expression){if(!expression)return node.definition().universe().type(universes.Universe10.StringTypeDeclaration.name);var pt=node.parsedType();return pt.isString()?node.definition().universe().type(universes.Universe10.StringTypeDeclaration.name):pt.isNumber()?pt.isInteger()?node.definition().universe().type(universes.Universe10.IntegerTypeDeclaration.name):node.definition().universe().type(universes.Universe10.NumberTypeDeclaration.name):pt.isBoolean()?node.definition().universe().type(universes.Universe10.BooleanTypeDeclaration.name):pt.isObject()?node.definition().universe().type(universes.Universe10.ObjectTypeDeclaration.name):pt.isArray()?node.definition().universe().type(universes.Universe10.ArrayTypeDeclaration.name):pt.isFile()?node.definition().universe().type(universes.Universe10.FileTypeDeclaration.name):pt.isDateTime()?node.definition().universe().type(universes.Universe10.DateTimeTypeDeclaration.name):pt.isDateTimeOnly()?node.definition().universe().type(universes.Universe10.DateTimeOnlyTypeDeclaration.name):pt.isDateOnly()?node.definition().universe().type(universes.Universe10.DateOnlyTypeDeclaration.name):pt.isTimeOnly()?node.definition().universe().type(universes.Universe10.TimeOnlyTypeDeclaration.name):pt.isUnion()?node.definition().universe().type(universes.Universe10.UnionTypeDeclaration.name):node.definition().universe().type(universes.Universe10.TypeDeclaration.name)}function transform(u){return function(x){var m=u.type(x);if(!m){new defs.UserDefinedClass("",u,null,"","")}return m}}function findFacetInTypeNode(typeNode,facetName){var typeNodeElement=typeNode.asElement();if(null==typeNodeElement)return null;var facets=typeNodeElement.elementsOfKind(universes.Universe10.TypeDeclaration.properties.facets.name);return null==facets||0==facets.length?null:_.find(facets,function(facet){return facetName==facet.attrValue(universes.Universe10.TypeDeclaration.properties.name.name)})}function findFacetDeclaration(facet){var owner=facet.owner();if(null==owner)return null;var facetName=facet.facetName();if(!facetName)return null;var ownerSource=owner.getExtra(ramlTypes.SOURCE_EXTRA);return null==ownerSource?null:def.isSourceProvider(ownerSource)||hl.isParseResult(ownerSource)?{getSource:function(){if(def.isSourceProvider(ownerSource)){var resolvedSource=ownerSource.getSource();if(resolvedSource&&hl.isParseResult(resolvedSource))return findFacetInTypeNode(resolvedSource,facetName)}else if(hl.isParseResult(ownerSource))return findFacetInTypeNode(ownerSource,facetName);return null}}:null}function patchTypeWithFacets(originalType,nodeReferencingType,parentOfReferencingNode){if(null==originalType)return null;var patchedType=new defs.NodeClass(nodeReferencingType.name(),nodeReferencingType.definition().universe(),"",""),parsedRType=nodeReferencingType.parsedType();return parsedRType.allFacets().forEach(function(facet){if(facet.kind()==defs.tsInterfaces.MetaInformationKind.FacetDeclaration){var propertySource=findFacetDeclaration(facet),facetBasedProperty=null;null!=propertySource?(facetBasedProperty=new defs.UserDefinedProp(facet.facetName(),null),facetBasedProperty.setSourceProvider(propertySource)):facetBasedProperty=new defs.Property(facet.facetName(),""),facetBasedProperty.withRange(parentOfReferencingNode.definition().universe().type("StringType")),facetBasedProperty.withDomain(patchedType),facetBasedProperty.withGroupName(facet.facetName()),facetBasedProperty.withRequired(!1),facet.value(),ramlTypes.setPropertyConstructor(function(x){var v=new defs.Property(x,"");return v.unmerge(),v}),facetBasedProperty.withRange(ramlTypes.toNominal(facet.value(),transform(nodeReferencingType.definition().universe())))}}),patchedType._superTypes.push(originalType),patchedType}function desc1(p,parent,x){var tp=x.attr("type");if(tp){var baseType=getBaseType(x,tp.value()),patchedType=patchTypeWithFacets(baseType,x,parent);return patchedType&&0==patchedType.superTypes().length&&patchedType._superTypes.push(x.definition().universe().type(universes.Universe10.TypeDeclaration.name)),patchedType}var propertiesName=universes.Universe10.ObjectTypeDeclaration.properties.properties.name;if(p){if("body"==p.nameId()||_.find(x.lowLevel().children(),function(x){return x.key()===propertiesName}))return x.definition().universe().type(universes.Universe10.ObjectTypeDeclaration.name)}else if(!parent&&x.lowLevel()&&_.find(x.lowLevel().children(),function(x){return x.key()===propertiesName}))return x.definition().universe().type(universes.Universe10.ObjectTypeDeclaration.name);return x.definition().universe().type(universes.Universe10.StringTypeDeclaration.name)}function doDescrimination(node){try{var nodeDefenitionName=node.definition().nameId(),isApi=nodeDefenitionName===universes.Universe10.Api.name||nodeDefenitionName===universes.Universe08.Api.name;if(!isApi&&!node.property()&&!node.parent()&&node.definition().nameId()===hlimpl.getFragmentDefenitionName(node)){if(node.property()&&node.property().nameId()===universes.Universe10.LibraryBase.properties.annotationTypes.name)return descriminate(null,null,node);var result=null,subTypes=node.definition().allSubTypes();return subTypes.forEach(function(subType){!result&&match(subType,node,null)&&(result=subType)}),result}}catch(exception){}return descriminate(node.property(),node.parent(),node)}function descriminate(p,parent,x){var n=x.lowLevel();p&&p.nameId()==universes.Universe10.FragmentDeclaration.properties.uses.name&&p.range().nameId()==universes.Universe10.Library.name;var range=p?p.range().nameId():x.definition().nameId();if(n._node&&n._node.descriminate)return null;n._node&&(n._node.descriminate=1);try{if(range==universes.Universe10.TypeDeclaration.name){var res=desc1(p,parent,x);if(p||!p&&!parent&&x.lowLevel()){if(p&&null!=res&&(p.nameId()==universes.Universe10.MethodBase.properties.body.name||p.nameId()==universes.Universe10.Response.properties.headers.name||p.nameId()==universes.Universe10.MethodBase.properties.queryParameters.name)){var ares=new defs.UserDefinedClass(x.lowLevel().key(),res.universe(),x,x.lowLevel().unit()?x.lowLevel().unit().path():"","");return ares._superTypes.push(res),ares}if(null!=res&&universeHelpers.isAnnotationTypeType(x.definition())){var annotationType=descriminateAnnotationType(res),ares=new defs.UserDefinedClass(x.lowLevel().key(),res.universe(),x,x.lowLevel().unit()?x.lowLevel().unit().path():"","");return ares._superTypes.push(annotationType),ares._superTypes.push(res),ares}}if(res)return res}var rt=null;if(p&&parent){var types=search.findAllSubTypes(p,parent);return types.length>0&&types.forEach(function(y){rt||match(y,x,rt)&&(rt=y)}),rt}}finally{n._node&&delete n._node.descriminate}}function descriminateAnnotationType(type){for(var candidate,arr=[type].concat(type.allSuperTypes()),i=0;i<arr.length;i++){var t=arr[i];if(!t.isUserDefined()){if(t.isUnion()){var ut=t,lt=ut.leftType(),lat=(ut.leftType(),descriminateAnnotationType(lt)),rat=descriminateAnnotationType(lt);if(lat.isAssignableFrom(rat.nameId())&&(null==candidate||lat.isAssignableFrom(candidate.nameId()))){candidate=lat;continue}if(rat.isAssignableFrom(lat.nameId())&&(null==candidate||rat.isAssignableFrom(candidate.nameId()))){candidate=rat;continue}candidate=type.universe().type(universes.Universe10.UnionTypeDeclaration.name);break}if(t.isArray()){candidate=type.universe().type(universes.Universe10.ArrayTypeDeclaration.name);
break}for(var subTypes=t.subTypes(),j=0;j<subTypes.length;j++){var st=subTypes[j];st.isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&(null==candidate?candidate=st:st.isAssignableFrom(candidate.nameId())&&(candidate=st))}}}return null!=candidate?candidate:type.universe().type(universes.Universe10.TypeDeclaration.name)}function match(t,r,alreadyFound){if(r.isAttr()||r.isUnknown())return!1;var el=r,hasSuperType=_.find(t.superTypes(),function(x){var dp=_.find(x.allProperties(),function(x){return x.isDescriminator()});if(dp){var a=el.attr(dp.nameId());if(a&&a.value()==t.nameId())return!0}return!1});if(hasSuperType)return!0;if(0==t.valueRequirements().length)return!1;var matches=!0;return t.valueRequirements().forEach(function(x){var a=el.attr(x.name);if(a)if(a.value()==x.value);else if(t.getAdapter(services.RAMLService).getConsumesRefs()){var vl=a.value(),allSubs=[];t.superTypes().forEach(function(x){return x.allSubTypes().forEach(function(y){allSubs.push(y)})});var allSubNames=[];_.unique(allSubs).forEach(function(x){allSubNames.push(x.nameId()),x.valueRequirements().forEach(function(y){allSubNames.push(y.value)}),x.getAdapter(services.RAMLService).getAliases().forEach(function(y){return allSubNames.push(y)})}),_.find(allSubNames,function(x){return x==vl})&&(matches=!1)}else matches=!1;else{var m=t.getAdapter(services.RAMLService).getDefining(),ms=!1;if(m.forEach(function(x){el.lowLevel().children().forEach(function(y){y.key()==x&&(ms=!0)})}),ms)return void(matches=!0);if(alreadyFound)matches=!1;else{var pr=t.property(x.name);pr&&pr.defaultValue()==x.value||(matches=!1)}}}),matches}var defs=__webpack_require__(36),hl=__webpack_require__(10),yaml=__webpack_require__(70),_=__webpack_require__(61),def=defs,hlimpl=__webpack_require__(16),proxy=__webpack_require__(38),search=__webpack_require__(23),universes=__webpack_require__(22),universeHelpers=__webpack_require__(14),services=defs,ramlTypes=defs.rt,KeyMatcher=function(){function KeyMatcher(_props){this._props=_props,this.parentValue=_.find(_props,function(x){return x.isFromParentValue()}),this.parentKey=_.find(_props,function(x){return x.isFromParentKey()}),this.canBeValue=_.find(_props,function(x){return x.canBeValue()})}return KeyMatcher.prototype.add=function(p){this._props.push(p)},KeyMatcher.prototype.match=function(key){var _this=this,_res=null,lastPref="";return this._props.forEach(function(p){p.getAdapter(services.RAMLPropertyService).isSystem()||p!=_this.parentValue&&p!=_this.parentKey&&p.matchKey(key)&&(null!=p.keyPrefix()?p.keyPrefix().length>=lastPref.length&&(lastPref=p.keyPrefix(),_res=p):(_res=p,lastPref=p.nameId()))}),_res},KeyMatcher}(),ad=0,BasicNodeBuilder=function(){function BasicNodeBuilder(){this.shouldDescriminate=!1}return BasicNodeBuilder.prototype.process=function(node,childrenToAdopt){var _this=this,nn=node.lowLevel(),cv=node;cv._mergedChildren=null;var cha=nn._node?nn._node:nn;try{if(cha.currentChildren)return cha.currentChildren;if(!node.definition())return;if(null==node.parent()&&!this.shouldDescriminate){this.shouldDescriminate=!0;try{var children=this.process(node,childrenToAdopt),ts=node;ts._children=children;var t=doDescrimination(node);t&&ts.patchType(t);var children=this.process(node,childrenToAdopt);ts._children=children}finally{this.shouldDescriminate=!1}}if(node.definition().hasUnionInHierarchy()&&node.parent()&&node.property().nameId()==universes.Universe10.LibraryBase.properties.annotations.name){var optins=getAllOptions(node.definition().unionInHierarchy()),actualResult=null,bestResult=null,bestType=null,bestCount=1e3,llnode=node;if(optins.forEach(function(x){if(!actualResult&&!x.hasUnionInHierarchy()){llnode.patchType(x);if(0==ad){ad++;try{for(var result=_this.process(node,childrenToAdopt),uc=0,i=0;i<result.length;i++)result[i].isUnknown()&&uc++;0==uc&&(actualResult=result),bestCount>uc&&(bestCount=uc,bestResult=result,bestType=x)}finally{ad--}}}}),actualResult)return llnode.patchType(bestType),actualResult;bestResult&&llnode.patchType(bestType)}var km=new KeyMatcher(node.definition().allProperties());if(null==node.parent()||node.lowLevel().includePath()){var u=node.definition().universe();"RAML10"==u.version()&&(node.definition().property("uses")||u.type("FragmentDeclaration").allProperties().forEach(function(x){return km.add(x)}))}var aNode=node,allowsQuestion=aNode._allowQuestion||node.definition().getAdapter(services.RAMLService).getAllowQuestion(),res=[];if(km.parentKey){if(node.lowLevel().key()){var keyAttr=new hlimpl.ASTPropImpl(node.lowLevel(),node,km.parentKey.range(),km.parentKey,(!0));res.push(keyAttr);var isDefaultMediaType=node.property()&&universeHelpers.isBodyProperty(node.property())&&node.lowLevel().key()==node.property().nameId();if(isDefaultMediaType){var isInsideTraitOrResourceType=isInTtraitOrResourceType(aNode);!isInsideTraitOrResourceType&&aNode._computedKey&&keyAttr.overrideValue(aNode._computedKey)}}if(node.lowLevel().valueKind()===yaml.Kind.SEQ){var error=new hlimpl.BasicASTNode(node.lowLevel(),aNode);return error.errorMessage=""+node.definition().nameId()+" definition should be a map",res.push(error),res}}if(null!=node.lowLevel().value(!0))if(km.parentValue)res.push(new hlimpl.ASTPropImpl(node.lowLevel(),node,km.parentValue.range(),km.parentValue));else if(km.canBeValue){var s=node.lowLevel().value();null==s&&(s=node.lowLevel().value(!0)),"string"==typeof s&&s.trim().length>0&&res.push(new hlimpl.ASTPropImpl(node.lowLevel(),node,km.canBeValue.range(),km.canBeValue))}if(aNode._children=res,aNode.definition().getAdapter(services.RAMLService).isUserDefined())res=this.processChildren(childrenToAdopt,aNode,res,allowsQuestion,km);else if(aNode.definition().key()==universes.Universe08.Api||aNode.definition().key()==universes.Universe10.Api){var uses=childrenToAdopt.filter(function(x){return"uses"==x.key()});res=this.processChildren(uses,aNode,res,allowsQuestion,km);var types=childrenToAdopt.filter(function(x){return"types"==x.key()});res=this.processChildren(types,aNode,res,allowsQuestion,km);var other=childrenToAdopt.filter(function(x){return"types"!=x.key()&&"uses"!=x.key()});res=this.processChildren(other,aNode,res,allowsQuestion,km)}else res=this.processChildren(childrenToAdopt,aNode,res,allowsQuestion,km);return aNode._children=res,res}finally{}},BasicNodeBuilder.prototype.isTypeDeclarationShortcut=function(node,property){var isTypeDeclarationType=universeHelpers.isTypeProperty(property),isTypeDeclaration=node.definition()&&universeHelpers.isTypeDeclarationTypeOrDescendant(node.definition());return!!(isTypeDeclaration&&isTypeDeclarationType&&node.lowLevel()&&node.lowLevel().valueKind()===yaml.Kind.SEQ)},BasicNodeBuilder.prototype.processChildren=function(childrenToAdopt,aNode,res,allowsQuestion,km){var _this=this,typeDeclarationName=universes.Universe10.TypeDeclaration.name,typePropertyName=universes.Universe10.TypeDeclaration.properties.type.name;return aNode.definition()&&aNode.definition().isAssignableFrom(typeDeclarationName)&&aNode.lowLevel()&&km.canBeValue&&km.canBeValue.nameId()===typePropertyName&&aNode.lowLevel()._node&&aNode.lowLevel()._node.value&&aNode.lowLevel()._node.value.kind===yaml.Kind.SEQ?(childrenToAdopt.forEach(function(child){var property=new hlimpl.ASTPropImpl(child,aNode,km.canBeValue.range(),km.canBeValue);res.push(property)}),res):(childrenToAdopt.forEach(function(x){if(km.canBeValue&&_this.isTypeDeclarationShortcut(aNode,km.canBeValue))return void res.push(new hlimpl.ASTPropImpl(x,aNode,km.canBeValue.range(),km.canBeValue));var key=x.key(),p=null!=key?km.match(key):null;if(null!=p){var range=p.range();if(p.isAnnotation()&&"annotations"!=key){var pi=new hlimpl.ASTPropImpl(x,aNode,range,p);return void res.push(pi)}var um=!1,multyValue=p.isMultiValue();if(range.isArray()?(multyValue=!0,range=range.array().componentType(),um=!0):range.hasArrayInHierarchy()&&(multyValue=!0,um=!0),range.hasValueTypeInHierarchy()){var ch=x.children(),seq=x.valueKind()==yaml.Kind.SEQ;if((seq&&ch.length>0||ch.length>1)&&multyValue)if(ch.length>1&&universeHelpers.isTypeDeclarationSibling(aNode.definition())&&universeHelpers.isTypeProperty(p)&&x.valueKind()!=yaml.Kind.SEQ){var pi=new hlimpl.ASTPropImpl(x,aNode,range,p);res.push(pi),aNode.setComputed(p.nameId(),pi)}else{var values=[];ch.forEach(function(y){var pi=new hlimpl.ASTPropImpl(y,aNode,range,p);res.push(pi),values.push(y.value())}),p.isInherited()&&aNode.setComputed(p.nameId(),values)}else{p.isInherited()&&aNode.setComputed(p.nameId(),x.value());var attrNode=new hlimpl.ASTPropImpl(x,aNode,range,p);if(seq||x.valueKind()==yaml.Kind.MAP){var rng=p.range().nameId();p.getAdapter(services.RAMLPropertyService).isExampleProperty()||("StringType"==rng&&(rng="string"),"NumberType"==rng&&(rng="number"),"BooleanType"==rng&&(rng="boolean"),"string"!=rng&&"number"!=rng&&"boolean"!=rng||x.isAnnotatedScalar()||(attrNode.errorMessage="property '"+p.groupName()+"' must be a "+rng,0==x.children().length&&"enum"==p.groupName()&&(attrNode.errorMessage="enum is empty",x.valueKind()==yaml.Kind.MAP&&(attrNode.errorMessage="the value of enum must be an array"))))}res.push(attrNode)}return}var rs=[];if(aNode._children=res,null!=x.value()&&("string"==typeof x.value()||"boolean"==typeof x.value()||"number"==typeof x.value())&&(""+x.value()).trim().length>0){var c=p.range();if(!c.allProperties().some(function(x){var srv=x;return!!srv&&(srv.canBeValue()&&srv.isFromParentValue())})){var bnode=new hlimpl.BasicASTNode(x,aNode);bnode.getLowLevelEnd=function(){return-1},bnode.getLowLevelStart=function(){return-1},bnode.knownProperty=p,res.push(bnode)}}if(p.isMerged()){var node=new hlimpl.ASTNodeImpl(x,aNode,range,p);node._allowQuestion=allowsQuestion,rs.push(node)}else if(multyValue)if(p.getAdapter(services.RAMLPropertyService).isEmbedMap()){var chld=x.children(),newChld=[],hasSequenceComposition=!1;if(chld.forEach(function(n){n.kind()==yaml.Kind.INCLUDE_REF&&"RAML08"==aNode.universe().version()?n.children().forEach(function(y){var node=new hlimpl.ASTNodeImpl(y,aNode,range,p);node._allowQuestion=allowsQuestion,rs.push(node),hasSequenceComposition=!0}):newChld.push(n)}),chld=newChld,0==chld.length){if(p.range().key()==universes.Universe08.ResourceType&&!hasSequenceComposition){var error=new hlimpl.BasicASTNode(x,aNode);error.errorMessage="property: '"+p.nameId()+"' must be a map",res.push(error)}if(x.valueKind()==yaml.Kind.SCALAR&&p.range().key()==universes.Universe08.AbstractSecurityScheme){var error=new hlimpl.BasicASTNode(x.parent(),aNode);error.errorMessage="property: '"+p.nameId()+"' must be a map",res.push(error)}}var exit=!1;chld.forEach(function(y){if(!exit){var cld=y.children();if(y.key()||1!=cld.length)if("RAML10"==aNode.universe().version()){var node=new hlimpl.ASTNodeImpl(y,aNode,range,p);node._allowQuestion=allowsQuestion,rs.push(node)}else{var bnode=new hlimpl.BasicASTNode(y,aNode);res.push(bnode),y.key()&&(bnode.needSequence=!0)}else if("RAML10"!=aNode.universe().version()||aNode.parent()){var node=new hlimpl.ASTNodeImpl(cld[0],aNode,range,p);node._allowQuestion=allowsQuestion,rs.push(node)}else{var bnode=new hlimpl.BasicASTNode(x,aNode);res.push(bnode),bnode.needMap=!0,bnode.knownProperty=p,exit=!0}}})}else{var filter={},inherited=[];if(range instanceof defs.NodeClass){var nc=range;nc.getAdapter(services.RAMLService).getCanInherit().length>0&&nc.getAdapter(services.RAMLService).getCanInherit().forEach(function(v){for(var originalValue=aNode.computedValue(v),actualValue=Array.isArray(originalValue)?originalValue:[originalValue],pos=0;pos<actualValue.length;pos++){var vl=actualValue[pos];if(vl&&p.nameId()==universes.Universe10.Response.properties.body.name){var exists=_.find(x.children(),function(x){return x.key()==vl}),pc=aNode.parent().definition().key(),node=new hlimpl.ASTNodeImpl(x,aNode,range,p);node._computedKey=vl,pc!=universes.Universe10.MethodBase&&pc!=universes.Universe08.MethodBase||node.setComputed("form","true");var isInsideTraitOrResourceType=isInTtraitOrResourceType(aNode),t=descriminate(p,aNode,node);t&&(isInsideTraitOrResourceType||t.setName(vl),node.patchType(t));var ch=node.children();node._children=ch.filter(function(x){return!x.isUnknown()}),node._allowQuestion=allowsQuestion,exists||inherited.push(node),node.children().forEach(function(x){if(x.property().getAdapter(services.RAMLPropertyService).isKey()){var atr=x;return void(atr._computed=!0)}if(x.isElement()&&(x.property().getAdapter(services.RAMLPropertyService).isMerged()||(filter[x.property().nameId()]=!0)),x.property().isAnnotation()){var atr=x,vl=atr.value(),strVal="";strVal=vl instanceof hlimpl.StructuredValue?vl.valueName():""+vl,filter["("+strVal+")"]=!0}else filter[x.name()]=!0});var ap=node.definition().allProperties();ap.forEach(function(p){p.getAdapter(services.RAMLPropertyService).isKey()||p.getAdapter(services.RAMLPropertyService).isSystem()||node.lowLevel().children().some(function(x){return x.key()==p.nameId()})&&(filter[p.nameId()]=!0)}),node._computed=!0}}})}var parsed=[];if(0==x.children().length&&x.valueKind()==yaml.Kind.SEQ&&p.range().key()==universes.Universe08.Parameter){var error=new hlimpl.BasicASTNode(x,aNode);error.errorMessage="property: '"+p.nameId()+"' must be a map",res.push(error)}if("documentation"===p.nameId()&&x.valueKind()!==yaml.Kind.SEQ){if(!aNode.definition().getAdapter(services.RAMLService).isUserDefined()){var error=new hlimpl.BasicASTNode(x,aNode);error.errorMessage="property: '"+p.nameId()+"' should be a sequence",res.push(error)}}else x.children().forEach(function(y){if(!filter[y.key()])if(y.valueKind()==yaml.Kind.SEQ){var isRaml1="RAML10"==aNode.definition().universe().version();if(y.children().forEach(function(z){var node=new hlimpl.ASTNodeImpl(z,aNode,range,p);node._allowQuestion=allowsQuestion,node.setNamePatch(y.key()),isRaml1&&(node.invalidSequence=!0),parsed.push(node)}),0==y.children().length){var error=new hlimpl.BasicASTNode(y,aNode);p.range().key()==universes.Universe08.Parameter?error.errorMessage="named parameter needs at least one type":error.errorMessage="node should have at least one member value",res.push(error)}}else{var node=new hlimpl.ASTNodeImpl(y,aNode,range,p),dc=p.domain().key();"body"!=p.nameId()||dc!=universes.Universe08.MethodBase&&dc!=universes.Universe10.MethodBase||node.setComputed("form","true"),node._allowQuestion=allowsQuestion,parsed.push(node)}});parsed.length>0?parsed.forEach(function(x){return rs.push(x)}):inherited.forEach(function(x){return rs.push(x)})}else rs.push(new hlimpl.ASTNodeImpl(x,aNode,range,p));aNode._children=aNode._children.concat(rs),res=res.concat(rs),rs.forEach(function(x){var rt=descriminate(p,aNode,x);rt&&rt!=x.definition()&&x.patchType(rt),x._associatedDef=null,p.childRestrictions().forEach(function(y){x.setComputed(y.name,y.value)});x.definition()})}else x instanceof proxy.LowLevelCompositeNode&&null==x.primaryNode()||res.push(new hlimpl.BasicASTNode(x,aNode))}),res)},BasicNodeBuilder}();exports.BasicNodeBuilder=BasicNodeBuilder,exports.doDescrimination=doDescrimination;var isInTtraitOrResourceType=function(aNode){for(var isInsideTraitOrResourceType=!1,parent_=aNode;parent_;){var pDef=parent_.definition();if(universeHelpers.isTraitType(pDef)||universeHelpers.isResourceTypeType(pDef)){isInsideTraitOrResourceType=!0;break}parent_=parent_.parent()}return isInsideTraitOrResourceType}},function(module,exports,__webpack_require__){"use strict";function buildXHR(){return new XMLHttpRequestWrapper}function copyNode(n){if(null==n)return null;switch(n.kind){case yaml.Kind.SCALAR:return{errors:[],startPosition:n.startPosition,endPosition:n.endPosition,value:n.value,kind:yaml.Kind.SCALAR,parent:n.parent};case yaml.Kind.MAPPING:var map=n;return{errors:[],key:copyNode(map.key),value:copyNode(map.value),startPosition:map.startPosition,endPosition:map.endPosition,kind:yaml.Kind.MAPPING,parent:map.parent};case yaml.Kind.MAP:var ymap=n;return{errors:[],startPosition:n.startPosition,endPosition:n.endPosition,mappings:ymap.mappings.map(function(x){return copyNode(x)}),kind:yaml.Kind.MAP,parent:ymap.parent}}return n}function splitOnLines(text){var lines=text.match(/^.*((\r\n|\n|\r)|$)/gm);return lines}function stripIndent(text,indent){for(var lines=splitOnLines(text),rs=[],i=0;i<lines.length;i++)0==i?rs.push(lines[0]):rs.push(lines[i].substring(indent.length));return rs.join("")}function indent(line){for(var rs="",i=0;i<line.length;i++){var c=line[i];if("\r"!=c&&"\n"!=c){if(" "!=c&&"\t"!=c)break;rs+=c}}return rs}function breaksTheLine(oc,textCommand){var oldText=oc.substr(textCommand.offset,textCommand.replacementLength);return oldText.indexOf("\n")!=-1||(textCommand.text.indexOf("\n")!=-1||void 0)}function tryParseScalar(q){if("null"==q)q=null;else if("~"==q)q=null;else if("true"==q)q=!0;else if("false"==q)q=!1;else{var vl=parseFloat(q);isNaN(vl)||(""+q).match("^[-+]?[0-9]*\\.?[0-9]+$")&&(q=vl)}return q}function createNode(key,parent){var node=yaml.newMapping(yaml.newScalar(key),yaml.newMap());return new ASTNode(node,null,parent,null,null)}function createMap(mappings){var node=yaml.newMap(mappings);return new ASTNode(node,null,null,null,null)}function createScalar(value){var node=yaml.newScalar(value);return new ASTNode(node,null,null,null,null)}function createSeq(sn,parent,unit){return new ASTNode(sn,unit,parent,null,null)}function createSeqNode(key){var node=yaml.newMapping(yaml.newScalar(key),yaml.newItems());return new ASTNode(node,null,null,null,null)}function createMapNode(key){var node=yaml.newMapping(yaml.newScalar(key),yaml.newMap());return new ASTNode(node,null,null,null,null)}function createMapping(key,v){var node=yaml.newMapping(yaml.newScalar(key),yaml.newScalar(v));return new ASTNode(node,null,null,null,null)}function toChildCachingNode(node){if(!(node instanceof ASTNode))return null;var astNode=node,result=new ASTNode(astNode.yamlNode(),astNode.unit(),null,null,null,(!0));return result._errors=astNode._errors,result}function toIncludingNode(node){if(!(node instanceof ASTNode))return null;var astNode=node,result=new ASTNode(astNode.yamlNode(),astNode.unit(),null,null,null,(!1));return result._errors=astNode._errors,result}function getDefinitionForLowLevelNode(node){var hl=node.highLevelNode();if(hl)return hl.definition();var parent=node.parent();if(!parent)return null;var key=node.key();if(!key)return null;var parentDef=parent.nodeDefinition();if(!parentDef)return null;if(!parentDef.property)return null;var prop=parentDef.property(key);return prop?prop.range():null}function fetchMasterReference(unit,map,errors,lMap){if(unit.isOverlayOrExtension()){var masterReferenceNode=unit.getMasterReferenceNode();if(masterReferenceNode){var masterReferenceText=masterReferenceNode.value();if(masterReferenceText){var unitPath=path.dirname(unit.absolutePath()),absIncludePath=lowlevel.toAbsolutePath(unitPath,masterReferenceText);if(!map[absIncludePath]){if(errors[absIncludePath])return void masterReferenceNode.errors().push(new Error(errors[masterReferenceText]));var arr=lMap[absIncludePath];arr||(arr=[],lMap[absIncludePath]=arr),arr.push(masterReferenceNode)}}}}}function fetchIncludesAndMasterAsync(project,apiPath){var map={},errors={},units=[],processUnits=function(ind){for(var refs=[],lMap={};ind<units.length;){var unit=units[ind],unitPath=unit.absolutePath();fetchMasterReference(unit,map,errors,lMap);var includeNodes=unit.getIncludeNodes();includeNodes.forEach(function(x){var ip=x.includePath(),includeReference=refResolvers.getIncludeReference(ip);if(includeReference)return void refs.push(project.resolveAsync(unit.absolutePath(),ip));if(ip){var absIncludePath=lowlevel.buildPath(ip,unitPath,project.getRootPath());if(!map[absIncludePath]){if(errors[absIncludePath]&&x.errors)return void x.errors().push(new Error(errors[ip]));var arr=lMap[absIncludePath];arr||(arr=[],lMap[absIncludePath]=arr),arr.push(x)}}}),ind++}var unitPaths=Object.keys(lMap);if(0==refs.length&&0==unitPaths.length)return Promise.resolve();var promises=refs;return unitPaths.forEach(function(unitPath){promises.push(project.unitAsync(unitPath,!0).then(function(x){map[x.absolutePath()]||(map[x.absolutePath()]=!0,units.push(x))},function(x){var innerError=project.pathToUnit[unitPath];lMap[unitPath].forEach(function(node){innerError||node.errors&&node.errors().push(new Error(x))}),errors[unitPath]=x,project.failedUnits[unitPath]=x,innerError&&(x.inner=!0)}))}),Promise.all(promises).then(function(x){return processUnits(ind)})};return project.unitAsync(apiPath).then(function(x){return units.push(x),map[x.absolutePath()]=!0,processUnits(0)}).then(function(x){return units.length>0?units[0]:null})}var lowlevel=__webpack_require__(11),path=__webpack_require__(15),fs=__webpack_require__(44),yaml=__webpack_require__(70),_=__webpack_require__(61),textutil=__webpack_require__(41),hli=__webpack_require__(16),services=__webpack_require__(33),rr=__webpack_require__(28),util=__webpack_require__(31),refResolvers=__webpack_require__(29),schemes=__webpack_require__(53),universes=__webpack_require__(22),expander=__webpack_require__(24),namespaceResolver=__webpack_require__(54),Error=yaml.YAMLException;exports.Kind={SCALAR:yaml.Kind.SCALAR};var MarkupIndentingBuffer=function(){function MarkupIndentingBuffer(indent){this.text="",this.indent=indent}return MarkupIndentingBuffer.prototype.isLastNL=function(){return this.text.length>0&&"\n"==this.text[this.text.length-1]},MarkupIndentingBuffer.prototype.addWithIndent=function(lev,s){this.isLastNL()&&(this.text+=textutil.indent(lev),this.text+=this.indent),this.text+=s},MarkupIndentingBuffer.prototype.addChar=function(ch){this.isLastNL()&&(this.text+=this.indent),this.text+=ch},MarkupIndentingBuffer.prototype.append=function(s){for(var i=0;i<s.length;i++)this.addChar(s[i])},MarkupIndentingBuffer}();exports.MarkupIndentingBuffer=MarkupIndentingBuffer;var CompilationUnit=function(){function CompilationUnit(_path,_content,_tl,_project,_apath){this._path=_path,this._content=_content,this._tl=_tl,this._project=_project,this._apath=_apath,this._path=null!=this._path?this._path.replace(/\\/g,"/"):null}return CompilationUnit.prototype.highLevel=function(){return this._hl?this._hl:(this._hl=hli.fromUnit(this),this._hl)},CompilationUnit.prototype.isStubUnit=function(){return this.stu},CompilationUnit.prototype.resolveAsync=function(p){var unit=this._project.resolveAsync(this._path,p);return unit},CompilationUnit.prototype.getIncludeNodes=function(){var ast=this.ast(),arr=[];return null==ast?[]:(ast.gatherIncludes(arr),ast.children().forEach(function(x){"uses"==x.key()&&x.children().forEach(function(y){arr.push({includePath:function(){return y.value()}})})}),arr)},CompilationUnit.prototype.cloneToProject=function(p){var newUnit=new CompilationUnit(this._path,this._content,this._tl,p,this._apath);return newUnit},CompilationUnit.prototype.clone=function(){var newUnit=new CompilationUnit(this._path,this._content,this._tl,this.project(),this._apath);return newUnit},CompilationUnit.prototype.stub=function(){var newUnit=new CompilationUnit(this._path,this._content,this._tl,this.project(),this._apath);return newUnit.stu=!0,newUnit},CompilationUnit.prototype.isDirty=function(){return!1},CompilationUnit.prototype.expandedHighLevel=function(){if(this.expanded)return this.expanded;var result=this.highLevel().asElement(),nm=expander.expandTraitsAndResourceTypes(result.wrapperNode()),hlnode=nm.highLevel();return hlnode._expanded=!0,this.expanded=hlnode,hlnode},CompilationUnit.prototype.absolutePath=function(){return this._apath},CompilationUnit.prototype.isRAMLUnit=function(){var en=path.extname(this._path);return".raml"==en||".yaml"==en||".yml"==en},CompilationUnit.prototype.contents=function(){return this._content},CompilationUnit.prototype.resolve=function(p){"string"!=typeof p&&(p=""+p);var unit=this._project.resolve(this._path,p);return unit},CompilationUnit.prototype.path=function(){return this._path},CompilationUnit.prototype.lexerErrors=function(){return null==this.errors&&this.ast(),this.errors},CompilationUnit.prototype.ast=function(){var _this=this;if(this._node)return this._node;try{var result=yaml.load(this._content,{});return this.errors=result.errors,this.errors.forEach(function(x){x.mark&&(x.mark.filePath=_this.absolutePath())}),this._node=new ASTNode(result,this,null,null,null),this._node._errors=this.errors,this._node}catch(e){return this.errors=[],this.errors.push(new Error(e.message)),this._node=null,this._node}},CompilationUnit.prototype.isTopLevel=function(){return this._tl},CompilationUnit.prototype.updateContent=function(n){this._content=n,this.errors=null,this._node=null,this._lineMapper=null},CompilationUnit.prototype.updateContentSafe=function(n){this._content=n,this._lineMapper=null,this._hl=null},CompilationUnit.prototype.project=function(){return this._project},CompilationUnit.prototype.lineMapper=function(){return null==this._lineMapper&&(this._lineMapper=new lowlevel.LineMapperImpl(this.contents(),this.absolutePath())),this._lineMapper},CompilationUnit.prototype.isOverlayOrExtension=function(){for(var contents=this.contents(),spec="",ptype=null,num=0,pt=0,n=0;n<contents.length;n++){var c=contents.charAt(n);if("\r"==c||"\n"==c){spec?ptype=contents.substring(pt,n).trim():spec=contents.substring(0,n).trim();break}" "==c&&(num++,spec||2!=num||(spec=contents.substring(0,n),pt=n))}return"Extension"==ptype||"Overlay"==ptype},CompilationUnit.prototype.getMasterReferenceNode=function(){return _.find(this.ast().children(),function(x){return x.key()==universes.Universe10.Overlay.properties.extends.name})},CompilationUnit}();exports.CompilationUnit=CompilationUnit;var XhrSync=__webpack_require__(60).XMLHttpRequest,XhrAsync=__webpack_require__(60).XMLHttpRequest,XMLHttpRequestWrapper=function(){function XMLHttpRequestWrapper(){}return XMLHttpRequestWrapper.prototype.open=function(method,url,async){this.xhr=async?new XhrAsync:new XhrSync,this.async=async,this.xhr.open(method,url,async)},XMLHttpRequestWrapper.prototype.setRequestHeader=function(name,value){this.xhr.setRequestHeader(name,value)},XMLHttpRequestWrapper.prototype.getResponseHeader=function(name){return this.xhr.getResponseHeader(name)},XMLHttpRequestWrapper.prototype.getAllResponseHeaders=function(){return this.xhr.getAllResponseHeaders()},XMLHttpRequestWrapper.prototype.send=function(content){var _this=this;this.xhr.onload=function(){return _this.onResponse(!1)},this.xhr.onerror=function(){return _this.onResponse(!0)},this.xhr.send(content)},XMLHttpRequestWrapper.prototype.onResponse=function(isError){return this.statusText=this.xhr.statusText,this.responseText=this.xhr.responseText,this.responseType=this.xhr.responseType,this.status=this.xhr.status,isError&&this.onerror?void this.onerror():void(this.onload&&this.onload())},XMLHttpRequestWrapper}();exports.XMLHttpRequestWrapper=XMLHttpRequestWrapper,exports.buildXHR=buildXHR;var SimpleExecutor=function(){function SimpleExecutor(){}return SimpleExecutor.prototype.execute=function(req,doAppendParams){void 0===doAppendParams&&(doAppendParams=!0);var xhr=buildXHR(),url=req.url;doAppendParams&&(url=this.appendParams(req,req.url)),xhr.open(req.method,url,!1),this.doRequest(req,xhr);var status=xhr.status;if(status>300&&status<400){var locHeader=xhr.getResponseHeader("location");if(locHeader)return req.url=locHeader,this.execute(req,!1)}var response={status:status,statusText:xhr.statusText,headers:xhr.getAllResponseHeaders().split("\n").map(function(x){var ind=x.indexOf(":");return{name:x.substring(0,ind).trim(),value:x.substring(ind+1).trim()}}),content:{text:xhr.responseText,mimeType:xhr.responseType}};return response},SimpleExecutor.prototype.appendParams=function(req,url){var gotQueryParams=req.queryString&&req.queryString.length>0;if(gotQueryParams){url+="?";var arr=[];gotQueryParams&&(arr=arr.concat(req.queryString.map(function(q){return encodeURIComponent(q.name)+"="+encodeURIComponent(q.value)}))),url+=arr.join("&")}return url},SimpleExecutor.prototype.log=function(varName,value){},SimpleExecutor.prototype.executeAsync=function(req,doAppendParams){void 0===doAppendParams&&(doAppendParams=!0);var xhr=buildXHR(),url=req.url;doAppendParams&&(url=this.appendParams(req,req.url));var outer=this;return new Promise(function(resolve,reject){xhr.open(req.method,url,!0),xhr.onload=function(){var status=xhr.status,response={status:status,statusText:xhr.statusText,headers:xhr.getAllResponseHeaders().split("\n").map(function(x){var ind=x.indexOf(":");return{name:x.substring(0,ind).trim(),value:x.substring(ind+1).trim()}}),content:{text:xhr.responseText,mimeType:xhr.responseType}};resolve(response)},xhr.onerror=function(){reject(new Error("Network Error"))},outer.doRequest(req,xhr)})},SimpleExecutor.prototype.doRequest=function(req,xhr){if(req.headers&&req.headers.forEach(function(x){return xhr.setRequestHeader(x.name,x.value)}),req.postData)if(req.postData.params){var body=req.postData.params.map(function(p){return encodeURIComponent(p.name)+"="+encodeURIComponent(p.value)}).join("&");xhr.send(body)}else xhr.send(req.postData.text);else xhr.send()},SimpleExecutor}();exports.SimpleExecutor=SimpleExecutor;var HTTPResolverImpl=function(){function HTTPResolverImpl(){this.executor=new SimpleExecutor}return HTTPResolverImpl.prototype.getResource=function(url){if("undefined"!=typeof atom&&null!=atom){var cached=rr.get(url);if(cached)return cached;rr.addNotify(url);try{var resultWithCallback={content:""};return this.getResourceAsync(url).then(function(x){try{x.errorMessage?rr.set(url,{content:null,errorMessage:null}):(x.errorMessage=null,rr.set(url,x))}finally{resultWithCallback.callback&&resultWithCallback.callback(rr.get(url)),rr.removeNotity(url)}},function(e){rr.set(url,{content:null,errorMessage:null}),resultWithCallback.callback&&resultWithCallback.callback(rr.get(url)),rr.removeNotity(url)}),resultWithCallback}catch(e){console.log("Error"),console.log(e)}}var response=this.executor.execute({method:"get",url:url});if(!response)throw new Error("Unable to execute GET "+url);var result=this.toResponse(response,url);return result},HTTPResolverImpl.prototype.getResourceAsync=function(url){var _this=this;return this.executor.executeAsync({method:"get",url:url}).then(function(x){if(!x)return Promise.reject(new Error("Unable to execute GET "+url));var result=_this.toResponse(x,url);return result},function(x){return Promise.reject(new Error("Unable to execute GET "+url))})},HTTPResolverImpl.prototype.toResponse=function(response,url){var msg=null;response.status>=400&&(msg="GET "+url+"\nreturned error: "+response.status,response.statusText&&(msg+=" "+response.statusText));var content=null;response.content&&response.content.text&&(content=response.content.text);var result={content:content,errorMessage:msg};return result},HTTPResolverImpl}();exports.HTTPResolverImpl=HTTPResolverImpl;var FSResolverImpl=function(){function FSResolverImpl(){}return FSResolverImpl.prototype.content=function(path){if("string"!=typeof path&&(path=""+path),!fs.existsSync(path))return null;try{return fs.readFileSync(path).toString()}catch(e){return null}},FSResolverImpl.prototype.list=function(path){return fs.readdirSync(path)},FSResolverImpl.prototype.contentAsync=function(path){return new Promise(function(resolve,reject){fs.readFile(path,function(err,data){if(null!=err)return reject(err);var content=data.toString();resolve(content)})})},FSResolverImpl.prototype.listAsync=function(path){return new Promise(function(reject,resolve){fs.readdir(path,function(err,files){return null!=err?reject(err):void resolve(files)})})},FSResolverImpl}();exports.FSResolverImpl=FSResolverImpl;var innerShift=function(offset,yaNode,shift){if(yaNode&&(yaNode.startPosition>=offset&&(yaNode.startPosition+=shift),yaNode.endPosition>offset&&(yaNode.endPosition+=shift),yaNode.kind==yaml.Kind.MAPPING)){var m=yaNode;innerShift(offset,m.key,shift),innerShift(offset,m.value,shift)}},leadingIndent=function(node,text){for(var leading="",pos=node.start()-1;pos>0;){var ch=text[pos];if(" "!=ch&&"-"!=ch)break;leading=" "+leading,pos--}return leading},Project=function(){
function Project(rootPath,resolver,_httpResolver){this.rootPath=rootPath,this.resolver=resolver,this._httpResolver=_httpResolver,this.listeners=[],this.tlisteners=[],this.pathToUnit={},this.failedUnits={},this._fsEnabled=!0,this._namespaceResolver=new namespaceResolver.NamespaceResolver,null==this.resolver?this.resolver=new FSResolverImpl:this._fsEnabled=!1,null==this._httpResolver&&(this._httpResolver=new HTTPResolverImpl)}return Project.prototype.getRootPath=function(){return this.rootPath},Project.prototype.fsEnabled=function(){return this._fsEnabled},Project.prototype.cloneWithResolver=function(newResolver,httpResolver){void 0===httpResolver&&(httpResolver=null);var newProject=new Project(this.rootPath,newResolver,httpResolver?httpResolver:this._httpResolver);for(var unitPath in this.pathToUnit)newProject.pathToUnit[unitPath]=this.pathToUnit[unitPath].cloneToProject(newProject);return newProject},Project.prototype.setCachedUnitContent=function(pth,cnt,tl){void 0===tl&&(tl=!0);var relPath=pth,apath=lowlevel.toAbsolutePath(this.rootPath,pth),unit=new CompilationUnit(relPath,cnt,tl,this,apath);return this.pathToUnit[apath]=unit,unit},Project.prototype.resolveAsync=function(unitPath,pathInUnit){var _this=this;if(!pathInUnit)return Promise.reject(new Error("Unit path is null"));var includeReference=refResolvers.getIncludeReference(pathInUnit),oldPath=pathInUnit;includeReference&&(pathInUnit=includeReference.getIncludePath());var absPath=lowlevel.buildPath(pathInUnit,unitPath,this.rootPath);if(includeReference){var result,refPath=lowlevel.toAbsolutePath(path.dirname(lowlevel.toAbsolutePath(this.rootPath,unitPath)),includeReference.encodedName());this.pathToUnit[absPath]?Promise.resolve(result).then(function(unit){return _this.pathToUnit[refPath]=new CompilationUnit(includeReference.encodedName(),refResolvers.resolveContents(oldPath,_this.pathToUnit[absPath].contents()),(!1),_this,refPath),_this.pathToUnit[refPath]}):this.unitAsync(absPath,!0).then(function(unit){return _this.pathToUnit[absPath]=unit,_this.pathToUnit[refPath]=new CompilationUnit(includeReference.encodedName(),refResolvers.resolveContents(oldPath,_this.pathToUnit[absPath].contents()),(!1),_this,refPath),_this.pathToUnit[refPath]})}return this.unitAsync(absPath,!0)},Project.prototype.resolve=function(unitPath,pathInUnit){if(!pathInUnit)return null;pathInUnit=pathInUnit.replace(/\\/g,"/");var includeReference=refResolvers.getIncludeReference(pathInUnit),oldPath=pathInUnit;includeReference&&(pathInUnit=includeReference.getIncludePath());var absPath=lowlevel.buildPath(pathInUnit,unitPath,this.rootPath);if(includeReference){this.pathToUnit[absPath]||(this.pathToUnit[absPath]=this.unit(absPath,!0));var wrappedUnit=this.pathToUnit[absPath],refPath=lowlevel.toAbsolutePath(path.dirname(lowlevel.toAbsolutePath(this.rootPath,unitPath)),includeReference.encodedName());return this.pathToUnit[refPath]?this.pathToUnit[refPath]:(this.pathToUnit[refPath]=new CompilationUnit(includeReference.encodedName(),refResolvers.resolveContents(oldPath,wrappedUnit&&wrappedUnit.contents()),(!1),this,refPath),this.pathToUnit[refPath])}return this.unit(absPath,!0)},Project.prototype.units=function(){var _this=this;if(!this.resolver.list)throw new Error("Provided FSResolver is unable to list files. Please, use ExtendedFSResolver.");var names=this.resolver.list(this.rootPath).filter(function(x){return".raml"==path.extname(x)});return names.map(function(x){return _this.unit(x)}).filter(function(y){return y.isTopLevel()})},Project.prototype.unitsAsync=function(){var _this=this;return this.resolver.listAsync?this.resolver.listAsync(this.rootPath).then(function(x){var promises=x.filter(function(x){return".raml"==path.extname(x)}).map(function(x){return _this.unitAsync(x).then(function(x){return x.isTopLevel()?x:null},function(x){return null})});return Promise.all(promises).then(function(arr){return arr.filter(function(x){return null!=x})})}):Promise.reject(new Error("Provided FSResolver is unable to list files. Please, use ExtendedFSResolver."))},Project.prototype.lexerErrors=function(){var results=[];return this.units().forEach(function(x){results=results.concat(x.lexerErrors())}),results},Project.prototype.deleteUnit=function(p,absolute){void 0===absolute&&(absolute=!1);var apath=null;apath=lowlevel.isWebPath(p)?p:absolute?p:lowlevel.toAbsolutePath(this.rootPath,p),delete this.pathToUnit[apath]},Project.prototype.unit=function(p,absolute){if(void 0===absolute&&(absolute=!1),absolute||lowlevel.isWebPath(p)){if(null!=this.failedUnits[p]&&!this.failedUnits[p].inner)return null}else{var ap=lowlevel.toAbsolutePath(this.rootPath,p);if(this.failedUnits[ap]&&!this.failedUnits[p].inner)return null}var response,cnt=null,apath=p;if(lowlevel.isWebPath(p)){if(this.pathToUnit[apath])return this.pathToUnit[apath];if(this._httpResolver){if(response=this._httpResolver.getResource(p),response&&response.errorMessage)throw new Error(response.errorMessage);cnt=response?response.content:null}else response=(new HTTPResolverImpl).getResource(apath),cnt=response?response.content:null}else{"/"!=p.charAt(0)||absolute||(p=p.substr(1));var apath=lowlevel.toAbsolutePath(this.rootPath,p);if(this.pathToUnit[apath])return this.pathToUnit[apath];if(lowlevel.isWebPath(apath))if(this._httpResolver){var resp=this._httpResolver.getResource(apath);if(resp&&resp.errorMessage)throw new Error(resp.errorMessage);cnt=resp?resp.content:null}else{var resourceResponse=(new HTTPResolverImpl).getResource(apath);cnt=resourceResponse?resourceResponse.content:null}else cnt=this.resolver.content(apath)}if(null==cnt)return null;var tl=util.stringStartsWith(cnt,"#%RAML"),relPath=lowlevel.isWebPath(this.rootPath)==lowlevel.isWebPath(apath)?path.relative(this.rootPath,apath):apath,unit=new CompilationUnit(relPath,cnt,tl,this,apath);return this.pathToUnit[apath]=unit,response&&(response.callback=function(contentHolder){unit.updateContent(contentHolder&&contentHolder.content)}),unit},Project.prototype.unitAsync=function(p,absolute){var _this=this;void 0===absolute&&(absolute=!1);var cnt=null,apath=p;if(lowlevel.isWebPath(p)){if(this.pathToUnit[apath])return Promise.resolve(this.pathToUnit[apath]);if(this._httpResolver){var resp=this._httpResolver.getResourceAsync(apath);cnt=resp.then(function(x){return x.errorMessage?Promise.reject(new Error(x.errorMessage)):x.content})}else cnt=(new HTTPResolverImpl).getResourceAsync(apath)}else{if("/"!=p.charAt(0)||absolute||(p=p.substr(1)),apath=absolute?p:lowlevel.toAbsolutePath(this.rootPath,p),this.pathToUnit[apath])return Promise.resolve(this.pathToUnit[apath]);if(lowlevel.isWebPath(apath))if(this._httpResolver){var resp=this._httpResolver.getResourceAsync(apath);cnt=resp.then(function(x){return x.errorMessage?Promise.reject(new Error(x.errorMessage)):x.content})}else cnt=(new HTTPResolverImpl).getResourceAsync(apath);else cnt=this.resolver.contentAsync(apath)}if(null==cnt)return Promise.resolve(null);var relPath=lowlevel.isWebPath(this.rootPath)==lowlevel.isWebPath(apath)?path.relative(this.rootPath,apath):apath;return cnt.then(function(x){if(null==x)return Promise.reject(new Error("Can note resolve "+apath));var tl=util.stringStartsWith(x,"#%RAML"),unit=new CompilationUnit(relPath,x,tl,_this,apath);return _this.pathToUnit[apath]=unit,unit},function(err){return"object"==typeof err&&err instanceof Error?Promise.reject(err):Promise.reject(new Error(err.toString()))}).then(function(unit){return unit.isRAMLUnit()?unit:schemes.isScheme(unit.contents())?schemes.startDownloadingReferencesAsync(unit.contents(),unit):unit})},Project.prototype.visualizeNewlines=function(s){for(var res="",i=0;i<s.length;i++){var ch=s[i];"\r"==ch&&(ch="\\r"),"\n"==ch&&(ch="\\n"),res+=ch}return res},Project.prototype.indent=function(node){var text=node.unit().contents();if(node==node.root())return"";var leading=leadingIndent(node,text),dmp=splitOnLines(node.dump());if(dmp.length>1&&dmp[1].trim().length>0){var extra=indent(dmp[1]);return leading+extra}return leading+"  "},Project.prototype.startIndent=function(node){node.unit().contents();if(node==node.root())return"";var dmp=splitOnLines(node.dump());if(dmp.length>0){console.log("FIRST: "+dmp[0]);var extra=indent(dmp[0]);return extra+"  "}return""},Project.prototype.canWriteInOneLine=function(node){return!1},Project.prototype.isOneLine=function(node){return node.text().indexOf("\n")<0},Project.prototype.recalcPositionsUp=function(target){for(var np=target;np;)np.recalcEndPositionFromChilds(),np=np.parent()},Project.prototype.add2=function(target,node,toSeq,ipoint,json){void 0===json&&(json=!1);var unit=target.unit(),point=(target.root(),null);if(ipoint&&(ipoint instanceof ASTNode&&(point=ipoint),ipoint instanceof InsertionPoint&&(point=ipoint.point)),target.isValueInclude()){var childs=target.children();if(0==childs.length)throw new Error("not implemented: insert into empty include ref");var parent=childs[0].parent();return void this.add2(parent,node,toSeq,point,json)}var unitText=(new textutil.TextRange(unit.contents(),node.start(),node.end()),new textutil.TextRange(unit.contents(),target.start(),target.end()),target.unit().contents());target.valueKind()==yaml.Kind.SEQ&&(target=createSeq(target.valueAsSeq(),target,target.unit()));var json=this.isJson(target),originalIndent=json?"":this.indent(target.isSeq()?target.parent():target),xindent=originalIndent,indentLength=originalIndent.length,isTargetSeq=target.isSeq()||target.isMapping()&&(target.isValueSeq()||target.isValueScalar()||!target.asMapping().value);toSeq=toSeq,toSeq&&(json||isTargetSeq&&(xindent+="  ",indentLength+=2));var buf=new MarkupIndentingBuffer(xindent);node.markupNode(buf,node._actualNode(),0,json);var text=buf.text;if(toSeq){var trimText=textutil.trimEnd(text),trimLen=text.length-trimText.length;if(trimLen>0){var textlen=text.length;text=text.substring(0,textlen-trimLen),node.shiftNodes(textlen-trimLen,-trimLen)}}toSeq&&!json?(node.highLevelNode(),target.isMapping(),text=target.isSeq()||target.isMapping()&&(target.isValueSeq()||target.isValueScalar()||!target.asMapping().value)?originalIndent+"- "+text:originalIndent+text):text=originalIndent+text;var pos=target.end();if(point)point!=target?pos=point.end():json&&toSeq||(pos=target.keyEnd()+1,pos=new textutil.TextRange(unitText,pos,pos).extendAnyUntilNewLines().endpos());else if(json&&toSeq){var seq=target.asSeq();seq&&(pos=seq.items.length>0?seq.items[seq.items.length-1].endPosition:seq.endPosition-1)}else if(ipoint&&ipoint instanceof InsertionPoint){var ip=ipoint;ip.type==InsertionPointType.START&&(pos=target.keyEnd()+1,pos=new textutil.TextRange(unitText,pos,pos).extendAnyUntilNewLines().endpos())}var insertionRange=new textutil.TextRange(unitText,0,pos);if(pos=insertionRange.extendToNewlines().reduceSpaces().endpos(),json&&target.isSeq()){var seq=target.asSeq();seq.items.length>0&&(text=", "+text,indentLength+=2)}else pos>0&&"\n"!=unitText[pos-1]&&(text="\n"+text,indentLength++);var suffixLen=0;toSeq&&!json&&(text+="\n",suffixLen++);var newtext=unitText.substring(0,pos)+text+unitText.substring(pos,unitText.length),cu=unit;if(cu.updateContentSafe(newtext),this.executeReplace(new textutil.TextRange(unitText,pos,pos),text,cu),target.root().shiftNodes(pos,indentLength+(node.end()-node.start())+suffixLen),point){for(var childs=target.children(),index=-1,i=0;i<childs.length;i++){var x=childs[i];if(x.start()==point.start()&&x.end()==point.end()){index=i;break}}index>=0?target.addChild(node,index+1):target.addChild(node)}else target.addChild(node);node.shiftNodes(0,pos+indentLength),this.recalcPositionsUp(target),node.setUnit(target.unit()),node.visit(function(n){var node=n;return node.setUnit(target.unit()),!0})},Project.prototype.isJsonMap=function(node){if(!node.isMap())return!1;var text=node.text().trim();return text.length>=2&&"{"==text[0]&&"}"==text[text.length-1]},Project.prototype.isJsonSeq=function(node){if(!node.isSeq())return!1;var text=node.text().trim();return text.length>=2&&"["==text[0]&&"]"==text[text.length-1]},Project.prototype.isJson=function(node){return this.isJsonMap(node)||this.isJsonSeq(node)},Project.prototype.remove=function(unit,target,node){var parent=node.parent();if(node._oldText=node.dump(),this.isOneLine(node)&&node.isMapping()&&node.parent().isMap()){var mapnode=node.parent();if(1==mapnode.asMap().mappings.length&&null!=mapnode.parent())return void this.remove(unit,mapnode.parent(),mapnode)}if(this.isOneLine(node)&&node.isScalar()&&node.parent().isSeq()){var seqnode=node.parent(),seqn=seqnode.asSeq();if(1==seqn.items.length)return void this.remove(unit,seqnode.parent(),seqnode)}if(target.isMapping()&&node.isSeq()){var map=target.parent();return void this.remove(unit,map,target)}var range=new textutil.TextRange(unit.contents(),node.start(),node.end()),originalStartPos=(new textutil.TextRange(unit.contents(),target.start(),target.end()),new textutil.TextRange(unit.contents(),parent.start(),parent.end()),range.startpos());if(target.isSeq()){var seq=node.isSeq()?node:node.parentOfKind(yaml.Kind.SEQ);range=seq&&this.isJson(seq)?range.extendSpaces().extendCharIfAny(",").extendSpaces():range.extendToStartOfLine().extendAnyUntilNewLines().extendToNewlines()}target.isMap()&&(range=range.trimEnd().extendAnyUntilNewLines().extendToNewlines(),range=range.extendToStartOfLine().extendUntilNewlinesBack()),target.kind()==yaml.Kind.MAPPING&&(this.isJson(node)&&this.isOneLine(node)||(range=range.extendSpacesUntilNewLines(),range=range.extendToNewlines(),range=range.extendToStartOfLine().extendUntilNewlinesBack())),node.isSeq()&&(range=range.reduceSpaces());var cu=unit;cu.updateContentSafe(range.remove()),this.executeReplace(range,"",cu),node.parent().removeChild(node);var shift=-range.len();target.root().shiftNodes(originalStartPos,shift),this.recalcPositionsUp(target)},Project.prototype.changeKey=function(unit,attr,newval){var range=new textutil.TextRange(attr.unit().contents(),attr.keyStart(),attr.keyEnd());if(attr.kind()==yaml.Kind.MAPPING){var sc=attr._actualNode().key;sc.value=newval,sc.endPosition=sc.startPosition+newval.length}var cu=unit;this.executeReplace(range,newval,cu);var shift=newval.length-range.len();attr.root().shiftNodes(range.startpos(),shift,attr),this.recalcPositionsUp(attr)},Project.prototype.executeReplace=function(r,txt,unit){var command=new lowlevel.TextChangeCommand(r.startpos(),r.endpos()-r.startpos(),txt,unit);unit.project();try{this.tlisteners.forEach(function(x){return x(command)})}catch(e){return!1}var newtext=r.replace(txt);return unit.updateContentSafe(newtext),!0},Project.prototype.changeValue=function(unit,attr,newval){var newNodeText,range=new textutil.TextRange(attr.unit().contents(),attr.start(),attr.end()),prefix=0,delta=0,replacer=null,mapping=null;if(attr.kind()==yaml.Kind.SCALAR){if("string"!=typeof newval)throw new Error("not implemented");attr.asScalar().value=newval,newNodeText=newval}else if(attr.kind()==yaml.Kind.MAPPING){if(mapping=attr.asMapping(),attr.isValueInclude()){var inc=attr.valueAsInclude(),includeString=inc.value,includePath=includeString,resolved=attr.unit().resolve(includePath);if(null==resolved)return void console.log("attr.setValue: couldn't resolve: "+includePath);if(resolved.isRAMLUnit())return;return void(refResolvers.getIncludeReference(includeString)||resolved.updateContent(newval))}if(range=mapping.value?range.withStart(attr.valueStart()).withEnd(attr.valueEnd()):range.withStart(attr.keyEnd()+1).withEnd(attr.keyEnd()+1),range=range.reduceNewlinesEnd(),null==newval)newNodeText="",mapping.value=null;else if("string"==typeof newval||null==newval){var newstr=newval,ind=this.indent(attr);if(newstr&&textutil.isMultiLine(newstr)&&(newstr=""+textutil.makeMutiLine(newstr,ind.length/2)),newNodeText=newstr,mapping.value){if(mapping.value.kind==yaml.Kind.SEQ){console.log("seq value");mapping.value.items[0];throw"assign value!!!"}if(mapping.value.kind==yaml.Kind.SCALAR){var sc=mapping.value,oldtext=sc.value||"";sc.value=newstr,mapping.value.endPosition=mapping.value.startPosition+newstr.length,mapping.endPosition=mapping.value.endPosition,delta+=newstr.length-oldtext.length}}else if(console.log("no value"),mapping.value=yaml.newScalar(newstr),mapping.value.startPosition=attr.keyEnd()+1,mapping.value.endPosition=mapping.value.startPosition+newstr.length,mapping.endPosition=mapping.value.endPosition,unit.contents().length>attr.keyEnd()+1){var vlPos=attr.keyEnd()+1;":"==unit.contents()[vlPos-1]&&(newNodeText=" "+newNodeText,mapping.value.startPosition++,mapping.value.endPosition++,mapping.endPosition++,delta++)}}else{var n=newval;if(n.isMapping())newval=createMap([n.asMapping()]),n=newval;else if(!n.isMap())throw new Error("only MAP/MAPPING nodes allowed as values");var buf=new MarkupIndentingBuffer("");n.markupNode(buf,n._actualNode(),0,!0),newNodeText=""+buf.text,n.shiftNodes(0,range.startpos()+delta),replacer=n}}else console.log("Unsupported change value case: "+attr.kindName());var cu=unit;this.executeReplace(range,newNodeText,cu);var shift=newNodeText.length-range.len();attr.root().shiftNodes(range.endpos()+prefix,shift,attr),replacer&&(mapping.value=replacer._actualNode()),this.recalcPositionsUp(attr)},Project.prototype.initWithRoot=function(root,newroot){var shift=root.end();newroot.markup(!1),newroot._actualNode().startPosition=shift,newroot._actualNode().endPosition=shift,newroot.setUnit(root.unit())},Project.prototype.execute=function(cmd){var _this=this;cmd.commands.forEach(function(x){switch(x.kind){case lowlevel.CommandKind.CHANGE_VALUE:var attr=x.target,curval=attr.value();curval||(curval="");var newval=x.value;if(console.log("set value: "+typeof curval+" ==> "+typeof newval),"string"!=typeof curval&&"number"!=typeof curval&&"boolean"!=typeof curval||"string"!=typeof newval)if("string"!=typeof curval&&"number"!=typeof curval&&"boolean"!=typeof curval||"string"==typeof newval)if("string"!=typeof curval&&"string"==typeof newval){var newstr=x.value;if(curval.kind()!=yaml.Kind.MAPPING)throw new Error("unsupported case: attribute value conversion: "+typeof curval+" ==> "+typeof newval+" not supported");textutil.isMultiLine(newstr)?(attr.children().forEach(function(n){_this.remove(attr.unit(),attr,n)}),_this.changeValue(attr.unit(),attr,newstr)):_this.changeKey(attr.unit(),curval,newstr)}else{if("string"==typeof curval||"string"==typeof newval)throw new Error("shouldn't be this case: attribute value conversion "+typeof curval+" ==> "+typeof newval+" not supported");var newvalnode=newval;if(newvalnode.isMapping()&&(newval=createMap([newvalnode.asMapping()])),curval==newval)break;var node=newval;node.asMap();attr.children().forEach(function(n){_this.remove(attr.unit(),attr,n)}),node.children().forEach(function(m){}),_this.changeValue(attr.unit(),attr,newval)}else _this.changeValue(attr.unit(),attr,newval);else curval!=newval&&_this.changeValue(attr.unit(),attr,newval);return;case lowlevel.CommandKind.CHANGE_KEY:var attr=x.target;return void _this.changeKey(attr.unit(),attr,x.value);case lowlevel.CommandKind.ADD_CHILD:var attr=x.target,newValueNode=x.value;return void _this.add2(attr,newValueNode,x.toSeq,x.insertionPoint);case lowlevel.CommandKind.REMOVE_CHILD:var target=x.target,node=x.value;return void _this.remove(target.unit(),target,node);case lowlevel.CommandKind.INIT_RAML_FILE:var root=x.target,newroot=x.value;return void _this.initWithRoot(root,newroot);default:return void console.log("UNSUPPORTED COMMAND: "+lowlevel.CommandKind[x.kind])}})},Project.prototype.replaceYamlNode=function(target,newNodeContent,offset,shift,unit){var newYamlNode=yaml.load(newNodeContent,{});this.updatePositions(target.start(),newYamlNode),target.root().shiftNodes(offset,shift);var targetParent=target.parent(),targetYamlNode=target._actualNode(),parent=targetYamlNode.parent;if(newYamlNode.parent=parent,targetParent&&targetParent.kind()==yaml.Kind.MAP){var targetParentMapNode=targetParent._actualNode();targetParentMapNode.mappings=targetParentMapNode.mappings.map(function(x){return x!=targetYamlNode?x:newYamlNode})}target.updateFrom(newYamlNode),this.recalcPositionsUp(target)},Project.prototype.executeTextChange2=function(textCommand){var cu=textCommand.unit,unitText=cu.contents(),target=textCommand.target;if(target){var cnt=unitText.substring(target.start(),target.end());unitText=unitText.substr(0,textCommand.offset)+textCommand.text+unitText.substr(textCommand.offset+textCommand.replacementLength);var newNodeContent=cnt.substr(0,textCommand.offset-target.start())+textCommand.text+cnt.substr(textCommand.offset-target.start()+textCommand.replacementLength);if(cu.updateContentSafe(unitText),textCommand.offset>target.start())try{var shift=textCommand.text.length-textCommand.replacementLength,offset=textCommand.offset;target.unit().project().replaceYamlNode(target,newNodeContent,offset,shift,textCommand.unit)}catch(e){console.log("New node contents (causes error below): \n"+newNodeContent),console.log("Reparse error: "+e.stack)}}else unitText=unitText.substr(0,textCommand.offset)+textCommand.text+unitText.substr(textCommand.offset+textCommand.replacementLength);cu.updateContent(unitText),this.listeners.forEach(function(x){x(null)}),this.tlisteners.forEach(function(x){x(textCommand)})},Project.prototype.executeTextChange=function(textCommand){(new Date).getTime();try{var oc=textCommand.unit.contents(),target=textCommand.target;null==target&&(target=this.findNode(textCommand.unit.ast(),textCommand.offset,textCommand.offset+textCommand.replacementLength));var cu=textCommand.unit;if(target){var cnt=oc.substring(target.start(),target.end()),original=oc;oc=oc.substr(0,textCommand.offset)+textCommand.text+oc.substr(textCommand.offset+textCommand.replacementLength);var newNodeContent=cnt.substr(0,textCommand.offset-target.start())+textCommand.text+cnt.substr(textCommand.offset-target.start()+textCommand.replacementLength);cu.updateContentSafe(oc);breaksTheLine(original,textCommand);if(textCommand.offset>target.start())try{var newYamlNode=yaml.load(newNodeContent,{});this.updatePositions(target.start(),newYamlNode);var shift=textCommand.text.length-textCommand.replacementLength;if(textCommand.unit.ast().shiftNodes(textCommand.offset,shift),null!=newYamlNode&&newYamlNode.kind==yaml.Kind.MAP){var actualResult=newYamlNode.mappings[0],targetYamlNode=target._actualNode(),parent=targetYamlNode.parent,cmd=new lowlevel.ASTDelta,unit=textCommand.unit;if(cmd.commands=[new lowlevel.ASTChangeCommand(lowlevel.CommandKind.CHANGE_VALUE,new ASTNode(copyNode(targetYamlNode),unit,null,null,null),new ASTNode(actualResult,unit,null,null,null),0)],parent&&parent.kind==yaml.Kind.MAP){var map=parent;map.mappings=map.mappings.map(function(x){return x!=targetYamlNode?x:actualResult})}return actualResult.parent=parent,this.recalcPositionsUp(target),target.updateFrom(actualResult),this.listeners.forEach(function(x){x(cmd)}),void this.tlisteners.forEach(function(x){x(textCommand)})}}catch(e){console.log("New node contents (causes error below): \n"+newNodeContent),console.log("Reparse error: "+e.stack)}}else oc=oc.substr(0,textCommand.offset)+textCommand.text+oc.substr(textCommand.offset+textCommand.replacementLength);(new Date).getTime();cu.updateContent(oc),this.listeners.forEach(function(x){x(null)}),this.tlisteners.forEach(function(x){x(textCommand)})}finally{(new Date).getTime()}},Project.prototype.updatePositions=function(offset,n){var _this=this;if(null!=n)switch(n.startPosition==-1?n.startPosition=offset:n.startPosition=offset+n.startPosition,n.endPosition=offset+n.endPosition,n.kind){case yaml.Kind.MAP:var m=n;m.mappings.forEach(function(x){return _this.updatePositions(offset,x)});break;case yaml.Kind.MAPPING:var ma=n;this.updatePositions(offset,ma.key),this.updatePositions(offset,ma.value);break;case yaml.Kind.SCALAR:break;case yaml.Kind.SEQ:var s=n;s.items.forEach(function(x){return _this.updatePositions(offset,x)})}},Project.prototype.findNode=function(n,offset,end){var _this=this;if(null==n)return null;var node=n;if(n.start()<=offset&&n.end()>=end){var res=n;return node.directChildren().forEach(function(x){var m=_this.findNode(x,offset,end);m&&(res=m)}),res}return null},Project.prototype.addTextChangeListener=function(listener){this.tlisteners.push(listener)},Project.prototype.removeTextChangeListener=function(listener){this.tlisteners=this.tlisteners.filter(function(x){return x!=listener})},Project.prototype.addListener=function(listener){this.listeners.push(listener)},Project.prototype.removeListener=function(listener){this.listeners=this.listeners.filter(function(x){return x!=listener})},Project.prototype.namespaceResolver=function(){return this._namespaceResolver},Project}();exports.Project=Project;var ASTNode=function(){function ASTNode(_node,_unit,_parent,_anchor,_include,cacheChildren,_includesContents){void 0===cacheChildren&&(cacheChildren=!1),void 0===_includesContents&&(_includesContents=!1),this._node=_node,this._unit=_unit,this._parent=_parent,this._anchor=_anchor,this._include=_include,this.cacheChildren=cacheChildren,this._includesContents=_includesContents,this._errors=[],null==_node&&console.log("null")}return ASTNode.prototype.actual=function(){return this._node},ASTNode.prototype.yamlNode=function(){return this._node},ASTNode.prototype.includesContents=function(){return this._includesContents},ASTNode.prototype.setIncludesContents=function(includesContents){this._includesContents=includesContents},ASTNode.prototype.gatherIncludes=function(s,inc,anc,inOneMemberMap){var _this=this;if(void 0===s&&(s=[]),void 0===inc&&(inc=null),void 0===anc&&(anc=null),void 0===inOneMemberMap&&(inOneMemberMap=!0),null!=this._node){var kind=this._node.kind;if(kind!=yaml.Kind.SCALAR)if(kind==yaml.Kind.MAP){var map=this._node;1!=map.mappings.length||inOneMemberMap?map.mappings.map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include,_this.cacheChildren)}).forEach(function(x){return x.gatherIncludes(s)}):new ASTNode(map.mappings[0].value,this._unit,this,inc,anc,this.cacheChildren).gatherIncludes(s)}else if(kind==yaml.Kind.MAPPING){var mapping=this._node;null==mapping.value||new ASTNode(mapping.value,this._unit,this,anc?anc:this._anchor,inc?inc:this._include,this.cacheChildren).gatherIncludes(s)}else if(kind==yaml.Kind.SEQ){var seq=this._node;seq.items.filter(function(x){return null!=x}).map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include,_this.cacheChildren)}).forEach(function(x){return x.gatherIncludes(s)})}else kind==yaml.Kind.INCLUDE_REF&&this._unit&&s.push(this);else if(schemes.isScheme(this._node.value)){var references=schemes.getReferences(this._node.value,this.unit());references.forEach(function(reference){var includeNode=yaml.newScalar(reference);includeNode.kind=yaml.Kind.INCLUDE_REF;var includeAST=new ASTNode(includeNode,_this.unit(),null,null,null);s.push(includeAST)})}}},ASTNode.prototype.setHighLevelParseResult=function(highLevelParseResult){this._highLevelParseResult=highLevelParseResult},ASTNode.prototype.highLevelParseResult=function(){return this._highLevelParseResult},ASTNode.prototype.setHighLevelNode=function(highLevel){this._highLevelNode=highLevel},ASTNode.prototype.highLevelNode=function(){return this._highLevelNode},ASTNode.prototype.start=function(){return this._node.startPosition},ASTNode.prototype.errors=function(){return this._errors},ASTNode.prototype.addIncludeError=function(error){this._errors.push(error),this._node.includeErrors||(this._node.includeErrors=[]),this._node.includeErrors.push(error)},ASTNode.prototype.parent=function(){return this._parent},ASTNode.prototype.recalcEndPositionFromChilds=function(){var first=(this.children(),this.children()[0]),last=this.children()[this.children().length-1];if(this.isMapping()){var mapping=this.asMapping();if(mapping.value)if(mapping.value.kind==yaml.Kind.MAP){var map=mapping.value;map.startPosition<0&&first&&(map.startPosition=first.start()),last&&(this._node.endPosition=last._node.endPosition),this._node.endPosition=Math.max(this._node.endPosition,mapping.value.endPosition)}else if(mapping.value.kind==yaml.Kind.SEQ){var seq=mapping.value;if(seq.startPosition<0&&seq.items.length>0){var pos=seq.items[0].startPosition,range=new textutil.TextRange(this.unit().contents(),pos,pos);range=range.extendSpacesBack().extendCharIfAnyBack("-"),seq.startPosition=range.startpos()}if(seq.items.length>0){var ilast=seq.items[seq.items.length-1];this._node.endPosition=Math.max(this._node.endPosition,seq.endPosition,ilast.endPosition),seq.endPosition=Math.max(this._node.endPosition,seq.endPosition,ilast.endPosition)}}else mapping.value.kind==yaml.Kind.SCALAR||last&&(this._node.endPosition=last._node.endPosition)}else last&&(this._node.endPosition=last._node.endPosition)},ASTNode.prototype.isValueLocal=function(){if(this._node.kind==yaml.Kind.MAPPING){var knd=this._node.value.kind;return knd!=yaml.Kind.INCLUDE_REF&&knd!=yaml.Kind.ANCHOR_REF}return!0},ASTNode.prototype.keyStart=function(){return this._node.kind==yaml.Kind.MAPPING?this._node.key.startPosition:-1},ASTNode.prototype.keyEnd=function(){return this._node.kind==yaml.Kind.MAPPING?this._node.key.endPosition:-1},ASTNode.prototype.valueStart=function(){if(this._node.kind==yaml.Kind.MAPPING){var mapping=this.asMapping();return mapping.value?mapping.value.startPosition:mapping.endPosition}return-1},ASTNode.prototype.valueEnd=function(){if(this._node.kind==yaml.Kind.MAPPING){var mapping=this.asMapping();return mapping.value?mapping.value.endPosition:mapping.endPosition}return-1},ASTNode.prototype.end=function(){return this._node.endPosition},ASTNode.prototype.dump=function(){if(this._oldText)return this._oldText;if(this._unit&&this._node.startPosition>0&&this._node.endPosition>0){var originalText=this._unit.contents().substring(this._node.startPosition,this._node.endPosition);return originalText=stripIndent(originalText,leadingIndent(this,this._unit.contents()))}return yaml.dump(this.dumpToObject(),{})},ASTNode.prototype.dumpToObject=function(full){return void 0===full&&(full=!1),this.dumpNode(this._node,full)},ASTNode.prototype.dumpNode=function(n,full){var _this=this;if(void 0===full&&(full=!1),!n)return null;if(n.kind==yaml.Kind.INCLUDE_REF){if(this._unit){var s=n,includePath=s.value,resolved=null;try{resolved=this._unit.resolve(includePath)}catch(Error){}if(null==resolved)return null;if(resolved.isRAMLUnit()&&this.canInclude(resolved)){var ast=resolved.ast();if(ast)return ast.dumpToObject(full)}}return null}if(n.kind==yaml.Kind.SEQ){var seq=n,arr=[];return seq.items.forEach(function(x){return arr.push(_this.dumpNode(x,full))}),arr}if(n.kind==yaml.Kind.ANCHOR_REF){var aref=n;return this.dumpNode(aref.value,full)}if(n.kind==yaml.Kind.MAPPING){var c=n,v={},val=c.value,mm=this.dumpNode(val,full);return v[""+this.dumpNode(c.key,full)]=mm,v}if(n.kind==yaml.Kind.SCALAR){var s=n,q=s.value;return s.plainScalar&&(q=tryParseScalar(q)),q}if(n.kind==yaml.Kind.MAP){var map=n,res={};return map.mappings&&map.mappings.forEach(function(x){var ms=_this.dumpNode(x.value,full);null==ms&&(ms=full?"!$$$novalue":ms),res[_this.dumpNode(x.key,full)+""]=ms}),res}},ASTNode.prototype.keyKind=function(){return this._node.key?this._node.key.kind:null},ASTNode.prototype._actualNode=function(){return this._node},ASTNode.prototype.execute=function(cmd){this.unit()?this.unit().project().execute(cmd):cmd.commands.forEach(function(x){switch(x.kind){case lowlevel.CommandKind.CHANGE_VALUE:var attr=x.target,newValue=x.value,va=attr._actualNode();attr.start();return void(va.kind==yaml.Kind.MAPPING&&(va.value=yaml.newScalar(""+newValue)));case lowlevel.CommandKind.CHANGE_KEY:var attr=x.target,newValue=x.value,va=attr._actualNode();if(va.kind==yaml.Kind.MAPPING){var sc=va.key;sc.value=newValue}return}})},ASTNode.prototype.updateFrom=function(n){this._node=n},ASTNode.prototype.isAnnotatedScalar=function(){if(this.kind()==yaml.Kind.MAPPING&&this.unit()&&this.valueKind()==yaml.Kind.MAP&&this._node.value.mappings){var isScalar=this._node.value.mappings.length>0;
return this._node.value.mappings.forEach(function(x){"value"!==x.key.value&&(x.key.value&&"("==x.key.value.charAt(0)&&")"==x.key.value.charAt(x.key.value.length-1)||(isScalar=!1))}),isScalar}return!1},ASTNode.prototype.value=function(toString){if(!this._node)return"";if(this._node.kind==yaml.Kind.SCALAR){if("~"===this._node.value&&null===this._node.valueObject)return toString?"null":null;if(!toString&&""+this._node.valueObject===this._node.value)return this._node.valueObject;var q=this._node.value;return toString||this._node.plainScalar&&(q=tryParseScalar(q)),q}if(this._node.kind==yaml.Kind.ANCHOR_REF){var ref=this._node;return new ASTNode(ref.value,this._unit,this,null,null).value(toString)}if(this._node.kind==yaml.Kind.MAPPING){var map=this._node;if(null==map.value)return null;if(this.isAnnotatedScalar())for(var child=new ASTNode(map.value,this._unit,this,null,null),ch=child.children(),i=0;i<ch.length;i++)if("value"===ch[i].key())return ch[i].value();return new ASTNode(map.value,this._unit,this,null,null).value(toString)}if(this._node.kind==yaml.Kind.INCLUDE_REF){var includeString=this._node.value,includePath=includeString,resolved=null;try{resolved=this._unit.resolve(includePath)}catch(Error){return"can not resolve "+includePath+" due to: "+Error.message}if(null==resolved)return"can not resolve "+includePath;if(resolved.isRAMLUnit()){var ast=resolved.ast();return ast?ast.value():"can not resolve "+includePath+" due to: file is empty"}var text=resolved.contents();return textutil.isMultiLineValue(text)&&(text=textutil.fromMutiLine(text)),text}if(this._node.kind==yaml.Kind.MAP){var amap=this._node;if(1==amap.mappings.length)return new ASTNode(amap.mappings[0],this._unit,this,null,null)}if(this._node.kind==yaml.Kind.SEQ){var aseq=this._node;if(1==aseq.items.length)return new ASTNode(aseq.items[0],this._unit,this,null,null).value(toString)}return null},ASTNode.prototype.printDetails=function(indent){var result="";indent||(indent="");var typeName=this.kindName();return this.kind()==yaml.Kind.SCALAR?result+=indent+"["+typeName+"] "+this.value()+"\n":this.kind()==yaml.Kind.MAPPING&&this._node.value&&this._node.value.kind==yaml.Kind.SCALAR?result+=indent+"["+typeName+"] "+this.key()+" = "+this.value()+"\n":this.kind()==yaml.Kind.MAPPING?(result+=indent+"["+typeName+"] "+this.key()+" = :\n",this.children().forEach(function(child){result+=child.printDetails(indent+"\t")})):(result+=indent+"["+typeName+"] :\n",this.children().forEach(function(child){result+=child.printDetails(indent+"\t")})),result},ASTNode.prototype.visit=function(v){this.children().forEach(function(x){v(x)&&x.visit(v)})},ASTNode.prototype.rawKey=function(){if(!this._node)return"";if(this._node.kind==yaml.Kind.MAPPING){var map=this._node;if(map.key.kind==yaml.Kind.SEQ){var items=map.key,mn="[";return items.items.forEach(function(x){return mn+=x.value}),mn+"]"}return map.key.value}if(this._node.kind==yaml.Kind.INCLUDE_REF){var m=this.children();if(1==m.length)return m[0].key()}return null},ASTNode.prototype.key=function(){var key=this.rawKey();return null!=key&&util.stringEndsWith(key,"?")&&(key=key.substring(0,key.length-1)),key},ASTNode.prototype.optional=function(){var key=this.rawKey();return null!=key&&util.stringEndsWith(key,"?")},ASTNode.prototype.addChild=function(n,pos){void 0===pos&&(pos=-1);var node=n;if(node._parent=this,this._oldText=null,this.isMap()){var map=this.asMap();null!=map.mappings&&void 0!=map.mappings||(map.mappings=[]),pos>=0?map.mappings.splice(pos,0,node.asMapping()):map.mappings.push(node.asMapping())}else if(this.isMapping()){var mapping=this.asMapping(),val=mapping.value;if(!mapping.value&&node.isMap())return void(mapping.value=node._actualNode());if(mapping.value&&mapping.value.kind==yaml.Kind.SCALAR&&(mapping.value=null,val=null),val||(val=node.isScalar()||node.highLevelNode()&&node.highLevelNode().property().getAdapter(services.RAMLPropertyParserService).isEmbedMap()?yaml.newSeq():yaml.newMap(),mapping.value=val),val.kind==yaml.Kind.MAP){var map=val;null!=map.mappings&&void 0!=map.mappings||(map.mappings=[]),node.isScalar(),pos>=0?map.mappings.splice(pos,0,node.asMapping()):map.mappings.push(node.asMapping())}else{if(val.kind!=yaml.Kind.SEQ)throw new Error("Insert into mapping with "+yaml.Kind[mapping.value.kind]+" value not supported");var seq=val;pos>=0?seq.items.splice(pos,0,node._actualNode()):seq.items.push(node._actualNode())}}else{if(!this.isSeq())throw new Error("Insert into "+this.kindName()+" not supported");var seq=this.asSeq();pos>=0?seq.items.splice(pos,0,node._actualNode()):seq.items.push(node._actualNode())}},ASTNode.prototype.removeChild=function(n){this._oldText=null;var ynode,index,node=n;if(this.kind()==yaml.Kind.SEQ){var seq=this.asSeq();ynode=node._node,index=seq.items.indexOf(ynode),index>-1&&seq.items.splice(index,1)}else if(this.kind()==yaml.Kind.MAP){var map=this.asMap();ynode=node.asMapping(),index=map.mappings.indexOf(ynode),index>-1&&map.mappings.splice(index,1)}else{if(this.kind()!=yaml.Kind.MAPPING)throw new Error("Delete from "+yaml.Kind[this.kind()]+" unsupported");var mapping=this.asMapping();if(node._actualNode()==mapping.value)mapping.value=null;else{var map=mapping.value;ynode=node.asMapping(),map&&map.mappings&&(index=map.mappings.indexOf(ynode),index>-1&&map.mappings.splice(index,1))}}},ASTNode.prototype.hasInnerIncludeError=function(){return this.innerIncludeErrors},ASTNode.prototype.includeErrors=function(){if(this._node.kind==yaml.Kind.MAPPING){var mapping=this._node;if(null==mapping.value)return[];var node=new ASTNode(mapping.value,this._unit,this,this._anchor,this._include),res=node.includeErrors();return this.innerIncludeErrors=node.hasInnerIncludeError(),res}var rs=[];if(this._node.kind==yaml.Kind.INCLUDE_REF){var mapping=this._node;if(null==mapping.value)return[];var includePath=this.includePath(),resolved=null;try{resolved=this._unit.resolve(includePath)}catch(Error){this.innerIncludeErrors=Error.inner;var s="Can not resolve "+includePath+" due to: "+Error.message;return rs.push(s),rs}var innerIncludeErrors=this._node.includeErrors;if(innerIncludeErrors&&innerIncludeErrors.length>0)return this.innerIncludeErrors=!0,rs=innerIncludeErrors.map(function(innerError){return"object"==typeof innerError&&innerError instanceof Error?innerError.message:innerError.toString()});if(null==resolved)return rs.push("Can not resolve "+includePath),rs;if(resolved.isRAMLUnit()){var ast=resolved.ast();if(ast)return[];rs.push(""+includePath+" can not be parsed")}}return rs},ASTNode.prototype.children=function(inc,anc,inOneMemberMap){var _this=this;if(void 0===inc&&(inc=null),void 0===anc&&(anc=null),void 0===inOneMemberMap&&(inOneMemberMap=!0),null==this._node)return[];if(this.cacheChildren&&this._children)return this._children;var result,kind=this._node.kind;if(kind==yaml.Kind.SCALAR)result=[];else if(kind==yaml.Kind.MAP){var map=this._node;result=1!=map.mappings.length||inOneMemberMap?map.mappings.map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include,_this.cacheChildren)}):new ASTNode(map.mappings[0].value,this._unit,this,inc,anc,this.cacheChildren).children(null,null,!0)}else if(kind==yaml.Kind.MAPPING){var mapping=this._node;if(null==mapping.value)result=[];else{var proxy=new ASTNode(mapping.value,this._unit,this,anc?anc:this._anchor,inc?inc:this._include,this.cacheChildren);result=proxy.children(),proxy.includesContents()&&this.setIncludesContents(!0)}}else if(kind==yaml.Kind.SEQ){var seq=this._node;result=seq.items.filter(function(x){return null!=x}).map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include,_this.cacheChildren)})}else if(kind==yaml.Kind.INCLUDE_REF){if(this._unit){var includePath=this.includePath(),resolved=null;try{resolved=this._unit.resolve(includePath)}catch(Error){}if(null==resolved)result=[];else if(resolved.isRAMLUnit()&&this.canInclude(resolved)){var ast=resolved.ast();ast&&(this.cacheChildren&&(ast=toChildCachingNode(ast)),result=resolved.ast().children(this,null),this.setIncludesContents(!0))}}result||(result=[])}else{if(kind!=yaml.Kind.ANCHOR_REF)throw new Error("Should never happen; kind : "+yaml.Kind[this._node.kind]);var ref=this._node;result=new ASTNode(ref.value,this._unit,this,null,null,this.cacheChildren).children()}return this.cacheChildren&&(this._children=result),result},ASTNode.prototype.canInclude=function(unit){for(var includedFrom=this.includedFrom();null!=includedFrom;){if(includedFrom.unit().absolutePath()==unit.absolutePath())return!1;includedFrom=includedFrom.includedFrom()}return!0},ASTNode.prototype.directChildren=function(inc,anc,inOneMemberMap){var _this=this;if(void 0===inc&&(inc=null),void 0===anc&&(anc=null),void 0===inOneMemberMap&&(inOneMemberMap=!0),this._node){switch(this._node.kind){case yaml.Kind.SCALAR:return[];case yaml.Kind.MAP:var map=this._node;return 1!=map.mappings.length||inOneMemberMap?map.mappings.map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include)}):new ASTNode(map.mappings[0].value,this._unit,this,inc,anc).directChildren(null,null,!0);case yaml.Kind.MAPPING:var mapping=this._node;return null==mapping.value?[]:new ASTNode(mapping.value,this._unit,this,anc?anc:this._anchor,inc?inc:this._include).directChildren();case yaml.Kind.SEQ:var seq=this._node;return seq.items.filter(function(x){return null!=x}).map(function(x){return new ASTNode(x,_this._unit,_this,anc?anc:_this._anchor,inc?inc:_this._include)});case yaml.Kind.INCLUDE_REF:return[];case yaml.Kind.ANCHOR_REF:return[]}throw new Error("Should never happen; kind : "+yaml.Kind[this._node.kind])}return[]},ASTNode.prototype.anchorId=function(){return this._node.anchorId},ASTNode.prototype.unit=function(){return this._unit},ASTNode.prototype.includeBaseUnit=function(){return this._unit},ASTNode.prototype.setUnit=function(unit){this._unit=unit},ASTNode.prototype.includePath=function(){var includeString=this.getIncludeString();return includeString?includeString:null},ASTNode.prototype.includeReference=function(){var includeString=this.getIncludeString();return includeString?refResolvers.getIncludeReference(includeString):null},ASTNode.prototype.getIncludeString=function(){if(this._node.kind==yaml.Kind.INCLUDE_REF){var includePath=this._node.value;return includePath}if(this._node.kind==yaml.Kind.MAPPING){var mapping=this._node;return null==mapping.value?null:new ASTNode(mapping.value,this._unit,this,null,null).getIncludeString()}return null},ASTNode.prototype.anchoredFrom=function(){return this._anchor},ASTNode.prototype.includedFrom=function(){return this._include},ASTNode.prototype.kind=function(){return this._actualNode().kind},ASTNode.prototype.valueKind=function(){if(this._node.kind!=yaml.Kind.MAPPING)return null;var map=this._node;return map.value?map.value.kind:null},ASTNode.prototype.valueKindName=function(){var kind=this.valueKind();return void 0!=kind?yaml.Kind[kind]:null},ASTNode.prototype.kindName=function(){return yaml.Kind[this.kind()]},ASTNode.prototype.indent=function(lev,str){void 0===str&&(str="");for(var leading="",i=0;i<lev;i++)leading+="  ";return leading+str},ASTNode.prototype.replaceNewlines=function(s,rep){void 0===rep&&(rep=null);for(var res="",i=0;i<s.length;i++){var ch=s[i];"\r"==ch&&(ch=null==rep?"\\r":rep),"\n"==ch&&(ch=null==rep?"\\n":rep),res+=ch}return res},ASTNode.prototype.shortText=function(unittext,maxlen){void 0===maxlen&&(maxlen=50);var elen=this.end()-this.start(),len=elen,unit=this.unit();!unittext&&unit&&(unittext=unit.contents());var text;if(unittext){var s=unittext;text=s?s.substring(this.start(),this.end()):"[no-text]"}else text="[no-unit]";return text="["+this.start()+".."+this.end()+"] "+elen+" // "+text+" //",len<elen&&(text+="..."),text=this.replaceNewlines(text)},ASTNode.prototype.nodeShortText=function(node,unittext,maxlen){void 0===maxlen&&(maxlen=50);var elen=node.endPosition-node.startPosition,len=elen,unit=this.unit();!unittext&&unit&&(unittext=unit.contents());var text;if(unittext){var s=unittext;text=s?s.substring(node.startPosition,node.endPosition):"[no-text]"}else text="[no-unit]";return text="["+node.startPosition+".."+node.endPosition+"] "+elen+" // "+text+" //",len<elen&&(text+="..."),text=this.replaceNewlines(text)},ASTNode.prototype.show=function(message,lev,text){void 0===message&&(message=null),void 0===lev&&(lev=0),void 0===text&&(text=null),message&&0==lev&&console.log(message);var children=this.children(),desc=this.kindName(),val=this._actualNode().value;this.kind()==yaml.Kind.MAPPING&&(desc+="["+this._actualNode().key.value+"]"),desc+=val?"/"+yaml.Kind[val.kind]:"",0==children.length?(console.log(this.indent(lev)+desc+" // "+this.shortText(text)),this.isMapping()&&this.asMapping().value&&console.log(this.indent(lev+1)+"// "+this.valueKindName()+": "+this.nodeShortText(this.asMapping().value,text))):(console.log(this.indent(lev)+desc+" { // "+this.shortText(text)),this.isMapping()&&this.asMapping().value&&console.log(this.indent(lev+1)+"// "+this.valueKindName()+": "+this.nodeShortText(this.asMapping().value,text)),children.forEach(function(node){var n=node;n.show(null,lev+1,text)}),console.log(this.indent(lev)+"}"))},ASTNode.prototype.showParents=function(message,lev){void 0===lev&&(lev=0),message&&0==lev&&console.log(message);var depth=0;if(this.parent()){var n=this.parent();depth=n.showParents(null,lev+1)}var desc=this.kindName(),val=this._actualNode().value;return desc+=val?"/"+yaml.Kind[val.kind]:"/null",console.log(this.indent(depth)+desc+" // "+this.shortText(null)),depth+1},ASTNode.prototype.inlined=function(kind){return kind==yaml.Kind.SCALAR||kind==yaml.Kind.INCLUDE_REF},ASTNode.prototype.markupNode=function(xbuf,node,lev,json){void 0===json&&(json=!1);var start=xbuf.text.length;switch(node.kind){case yaml.Kind.MAP:json&&xbuf.append("{");for(var mappings=node.mappings,i=0;i<mappings.length;i++)json&&i>0&&xbuf.append(", "),this.markupNode(xbuf,mappings[i],lev,json);json&&xbuf.append("}");break;case yaml.Kind.SEQ:for(var items=node.items,i=0;i<items.length;i++)xbuf.append(this.indent(lev,"- ")),this.markupNode(xbuf,items[i],lev+1,json);break;case yaml.Kind.MAPPING:var mapping=node,val=mapping.value;if(json){if(!val){xbuf.append("\n");break}if(xbuf.append(mapping.key.value),xbuf.append(": "),val.kind==yaml.Kind.SCALAR){var sc=val;xbuf.append(sc.value)}else{if(val.kind!=yaml.Kind.MAP)throw new Error("markup not implemented: "+yaml.Kind[val.kind]);this.markupNode(xbuf,mapping.value,lev+1,json)}break}if(xbuf.addWithIndent(lev,mapping.key.value+":"),!val){xbuf.append("\n");break}if(val.kind==yaml.Kind.SCALAR)var sc=val;mapping.value?(xbuf.append(this.inlined(mapping.value.kind)?" ":"\n"),this.markupNode(xbuf,mapping.value,lev+1,json)):xbuf.append("\n");break;case yaml.Kind.SCALAR:var sc=node;if(textutil.isMultiLine(sc.value)){xbuf.append("|\n");for(var lines=splitOnLines(sc.value),i=0;i<lines.length;i++)xbuf.append(this.indent(lev,lines[i]));xbuf.append("\n")}else xbuf.append(sc.value+"\n");break;case yaml.Kind.INCLUDE_REF:var ref=node;xbuf.append("!include "+ref.value+"\n");break;default:throw new Error("Unknown node kind: "+yaml.Kind[node.kind])}for(;start<xbuf.text.length&&" "==xbuf.text[start];)start++;node.startPosition=start,node.endPosition=xbuf.text.length},ASTNode.prototype.markup=function(json){void 0===json&&(json=!1);var buf=new MarkupIndentingBuffer("");return this.markupNode(buf,this._actualNode(),0,json),buf.text},ASTNode.prototype.root=function(){for(var node=this;node.parent();){var p=node.parent();node=p}return node},ASTNode.prototype.parentOfKind=function(kind){for(var p=this.parent();p;){if(p.kind()==kind)return p;p=p.parent()}return null},ASTNode.prototype.find=function(name){var found=null;return this.directChildren().forEach(function(y){y.key()&&y.key()==name&&(found||(found=y))}),found},ASTNode.prototype.shiftNodes=function(offset,shift,exclude){if(this.directChildren().forEach(function(x){if(exclude&&exclude.start()==x.start()&&exclude.end()==x.end());else{x.shiftNodes(offset,shift,exclude)}}),exclude&&exclude.start()==this.start()&&exclude.end()==this.end());else{var yaNode=this._actualNode();yaNode&&innerShift(offset,yaNode,shift)}return null},ASTNode.prototype.isMap=function(){return this.kind()==yaml.Kind.MAP},ASTNode.prototype.isMapping=function(){return this.kind()==yaml.Kind.MAPPING},ASTNode.prototype.isSeq=function(){return this.kind()==yaml.Kind.SEQ},ASTNode.prototype.isScalar=function(){return this.kind()==yaml.Kind.SCALAR},ASTNode.prototype.asMap=function(){if(!this.isMap())throw new Error("map expected instead of "+this.kindName());return this._actualNode()},ASTNode.prototype.asMapping=function(){if(!this.isMapping())throw new Error("maping expected instead of "+this.kindName());return this._actualNode()},ASTNode.prototype.asSeq=function(){if(!this.isSeq())throw new Error("seq expected instead of "+this.kindName());return this._actualNode()},ASTNode.prototype.asScalar=function(){if(!this.isScalar())throw new Error("scalar expected instead of "+this.kindName());return this._actualNode()},ASTNode.prototype.isValueSeq=function(){return this.valueKind()==yaml.Kind.SEQ},ASTNode.prototype.isValueMap=function(){return this.valueKind()==yaml.Kind.MAP},ASTNode.prototype.isValueInclude=function(){return this.valueKind()==yaml.Kind.INCLUDE_REF},ASTNode.prototype.isValueScalar=function(){return this.valueKind()==yaml.Kind.SCALAR},ASTNode.prototype.valueAsSeq=function(){if(!this.isMapping())throw new Error("mapping expected instead of "+this.kindName());if(this.valueKind()!=yaml.Kind.SEQ)throw new Error("mappng/seq expected instead of mapping/"+this.kindName());return this.asMapping().value},ASTNode.prototype.valueAsMap=function(){if(!this.isMapping())throw new Error("mapping expected instead of "+this.kindName());if(this.valueKind()!=yaml.Kind.MAP)throw new Error("mappng/map expected instead of mapping/"+this.kindName());return this.asMapping().value},ASTNode.prototype.valueAsScalar=function(){if(!this.isMapping())throw new Error("mapping expected instead of "+this.kindName());if(this.valueKind()!=yaml.Kind.SCALAR)throw new Error("mappng/scalar expected instead of mapping/"+this.kindName());return this.asMapping().value},ASTNode.prototype.valueAsInclude=function(){if(!this.isMapping())throw new Error("mapping expected instead of "+this.kindName());if(this.valueKind()!=yaml.Kind.INCLUDE_REF)throw new Error("mappng/include expected instead of mapping/"+this.kindName());return this.asMapping().value},ASTNode.prototype.text=function(unitText){if(void 0===unitText&&(unitText=null),!unitText){if(!this.unit())return"[no-text]";unitText=this.unit().contents()}return unitText.substring(this.start(),this.end())},ASTNode.prototype.copy=function(){var yn=copyNode(this._actualNode());return new ASTNode(yn,this._unit,this._parent,this._anchor,this._include,this._includesContents)},ASTNode.prototype.nodeDefinition=function(){return getDefinitionForLowLevelNode(this)},ASTNode}();exports.ASTNode=ASTNode,function(InsertionPointType){InsertionPointType[InsertionPointType.NONE=0]="NONE",InsertionPointType[InsertionPointType.START=1]="START",InsertionPointType[InsertionPointType.END=2]="END",InsertionPointType[InsertionPointType.POINT=3]="POINT"}(exports.InsertionPointType||(exports.InsertionPointType={}));var InsertionPointType=exports.InsertionPointType,InsertionPoint=function(){function InsertionPoint(type,point){void 0===point&&(point=null),this.type=type,this.point=point}return InsertionPoint.after=function(point){return new InsertionPoint(InsertionPointType.POINT,point)},InsertionPoint.atStart=function(){return new InsertionPoint(InsertionPointType.START)},InsertionPoint.atEnd=function(){return new InsertionPoint(InsertionPointType.END)},InsertionPoint.node=function(){return new InsertionPoint(InsertionPointType.NONE)},InsertionPoint.prototype.show=function(msg){msg?(console.log(msg),console.log("  insertion point type: "+InsertionPointType[this.type])):console.log("insertion point type: "+InsertionPointType[this.type]),this.type==InsertionPointType.POINT&&this.point&&this.point.show()},InsertionPoint}();exports.InsertionPoint=InsertionPoint,exports.createNode=createNode,exports.createMap=createMap,exports.createScalar=createScalar,exports.createSeq=createSeq,exports.createSeqNode=createSeqNode,exports.createMapNode=createMapNode,exports.createMapping=createMapping,exports.toChildCachingNode=toChildCachingNode,exports.toIncludingNode=toIncludingNode,exports.getDefinitionForLowLevelNode=getDefinitionForLowLevelNode,exports.fetchIncludesAndMasterAsync=fetchIncludesAndMasterAsync},function(module,exports,__webpack_require__){"use strict";function hasAsyncRequests(){return Object.keys(notifies).length>0}function addLoadCallback(listener){nlisteners.push(listener)}function addNotify(url){notifies[url]=!0}function removeNotity(url){delete notifies[url],nlisteners.forEach(function(x){return x(url)})}function isWaitingFor(url){return!!notifies[url]}function set(url,content){globalCache.set(url,content)}function get(url){return globalCache.get(url)}__webpack_require__(64);__webpack_require__(65),__webpack_require__(74);var lru=__webpack_require__(73),globalCache=lru(50);exports.hasAsyncRequests=hasAsyncRequests,exports.addLoadCallback=addLoadCallback;var nlisteners=[],notifies={};exports.addNotify=addNotify,exports.removeNotity=removeNotity,exports.isWaitingFor=isWaitingFor,exports.set=set,exports.get=get},function(module,exports,__webpack_require__){"use strict";function getIncludePath(includeString){if(!includeString)return includeString;var index=includeString.indexOf("#");return index==-1?includeString:includeString.substring(0,index)}function getIncludeReference(includeString){if(!includeString)return null;"string"!=typeof includeString&&(includeString=""+includeString);var index=includeString.indexOf("#");if(index==-1)return null;var referenceString=index==includeString.length-1?"":includeString.substring(index+1,includeString.length),segments=referenceString.split("/");return 0==segments.length?null:(""==segments[0].trim()&&segments.splice(0,1),new IncludeReferenceImpl(referenceString,getIncludePath(includeString),segments))}function getIncludeReferenceResolvers(){return[new JSONResolver,new XMLResolver]}function resolveContents(includeString,content){if(!includeString)return content;var reference=getIncludeReference(includeString);if(!reference)return content;var includePath=getIncludePath(includeString);return resolve(includePath,reference,content).content}function resolve(includePath,includeReference,content){var resolver=_.find(getIncludeReferenceResolvers(),function(currentResolver){return currentResolver.isApplicable(includePath,content)});return resolver?resolver.resolveReference(content,includeReference):{content:content,validation:[]}}function completeReference(includePath,includeReference,content){if(!content)return[];var resolver=_.find(getIncludeReferenceResolvers(),function(currentResolver){return currentResolver.isApplicable(includePath,content)});return resolver?resolver.completeReference(content,includeReference):[]}function endsWith(input,ends){return!!input&&(!!ends&&input.lastIndexOf(ends)===input.length-ends.length)}function elementChildrenByName(parent,tagName){for(var elements=parent.getElementsByTagName(tagName),result=[],i=0;i<elements.length;i++){var child=elements[i];child.parentNode===parent&&result.push(child)}return result}var _=__webpack_require__(61),DOMParser=__webpack_require__(75).DOMParser,base64=__webpack_require__(66);exports.getIncludePath=getIncludePath,exports.getIncludeReference=getIncludeReference,exports.getIncludeReferenceResolvers=getIncludeReferenceResolvers,exports.resolveContents=resolveContents,exports.resolve=resolve,exports.completeReference=completeReference;var IncludeReferenceImpl=function(){function IncludeReferenceImpl(originalString,includePath,segments){this.includePath=includePath,this.segments=segments,this.originalString=originalString}return IncludeReferenceImpl.prototype.getIncludePath=function(){return this.includePath},IncludeReferenceImpl.prototype.getFragments=function(){return this.segments},IncludeReferenceImpl.prototype.asString=function(){return this.originalString},IncludeReferenceImpl.prototype.encodedName=function(withExtention){return void 0===withExtention&&(withExtention=!0),base64(this.includePath+"/"+this.asString())+(withExtention?this.includePath.substring(this.includePath.lastIndexOf(".")):"")},IncludeReferenceImpl}(),JSONResolver=function(){function JSONResolver(){}return JSONResolver.prototype.isApplicable=function(includePath,content){return includePath&&(endsWith(includePath.trim(),".js")||endsWith(includePath.trim(),".json"))},JSONResolver.prototype.resolveReference=function(content,reference){try{var resultJson={};return resultJson.$ref=reference.getIncludePath()+"#"+reference.asString(),{content:JSON.stringify(resultJson,null,2),validation:[]}}catch(Error){console.log(Error)}return{content:content,validation:[]}},JSONResolver.prototype.completeReference=function(content,reference){try{var jsonRoot=JSON.parse(content),fragments=reference.getFragments();if(!fragments||0==fragments.length)return this.getChildren(jsonRoot);for(var currentJSON=jsonRoot,emptyPrefixCompletion=reference.asString().lastIndexOf("/")==reference.asString().length-1,i=(emptyPrefixCompletion?fragments.length:fragments.length-1,0);i<fragments.length-1;i++){var fragment=fragments[i];if(currentJSON=this.findChild(currentJSON,fragment),!currentJSON)return[]}if(emptyPrefixCompletion)return this.getChildren(currentJSON);var lastPrefix=fragments[fragments.length-1],result=[];return this.getChildren(currentJSON).forEach(function(child){0==child.indexOf(lastPrefix)&&result.push(child)}),result}catch(Error){console.log(Error)}return[]},JSONResolver.prototype.findChild=function(jsonObject,fragment){var decoded=fragment.replace("~1","/");return decoded=fragment.replace("~0","~"),jsonObject[decoded]},JSONResolver.prototype.getChildren=function(jsonObject){return Object.keys(jsonObject)},JSONResolver}(),XMLResolver=function(){function XMLResolver(){}return XMLResolver.prototype.isApplicable=function(includePath,content){return includePath&&(endsWith(includePath.trim(),".xml")||endsWith(includePath.trim(),".xsd"))},XMLResolver.prototype.resolveReference=function(content,reference){try{var doc=(new DOMParser).parseFromString(content),requestedName=reference.asString(),uniqueName=reference.encodedName(!1),schema=elementChildrenByName(doc,"xs:schema")[0],elements=elementChildrenByName(schema,"xs:element"),types=elementChildrenByName(schema,"xs:complexType"),canBeElement=_.find(elements,function(element){return element.getAttribute("name")===requestedName}),canBeType=canBeElement?_.find(types,function(type){return type.getAttribute("name")===canBeElement.getAttribute("type")}):_.find(types,function(type){return type.getAttribute("name")===requestedName}),element=doc.createElement("xs:element");return element.setAttribute("name",uniqueName),canBeType&&element.setAttribute("type",canBeType.getAttribute("name")),canBeElement&&element.setAttribute("originalname",canBeElement.getAttribute("name")),element.setAttribute("requestedname",requestedName),element.setAttribute("extraelement","true"),schema.appendChild(element),{content:doc.toString(),validation:[]}}catch(throwable){console.log(throwable)}return{content:content,validation:[]}},XMLResolver.prototype.completeReference=function(content,reference){try{var doc=(new DOMParser).parseFromString(content),result=[],schema=elementChildrenByName(doc,"xs:schema")[0],elements=elementChildrenByName(schema,"xs:element"),types=elementChildrenByName(schema,"xs:complexType");elements.forEach(function(element){return result.push(element.getAttribute("name"))}),types.forEach(function(type){return result.push(type.getAttribute("name"))});var emptyPrefixCompletion=0===reference.asString().trim().length;return emptyPrefixCompletion?result:result.filter(function(value){return 0===value.indexOf(reference.asString())})}catch(exception){return[]}},XMLResolver}()},function(module,exports,__webpack_require__){"use strict";function isWebPath(str){return ll.isWebPath(str)}var path=__webpack_require__(15),ll=__webpack_require__(11),resourceRegistry=__webpack_require__(28),ContentProvider=function(){function ContentProvider(unit){this.unit=unit}return ContentProvider.prototype.contextPath=function(){if(!this.unit)return"";var rootPath=this.unit.absolutePath();return rootPath||""},ContentProvider.prototype.normalizePath=function(url){if(!url)return url;var result;if(isWebPath(url)){var prefix=0===url.toLowerCase().indexOf("https")?"https://":"http://";result=prefix+path.normalize(url.substring(prefix.length)).replace(/\\/g,"/")}else result=path.normalize(url).replace(/\\/g,"/");return result},ContentProvider.prototype.content=function(reference){var normalized=this.normalizePath(reference),unitPath=this.toRelativeIfNeeded(normalized),unit=this.unit.resolve(unitPath);return unit?unit.contents()||"":""},ContentProvider.prototype.contentAsync=function(reference){var normaized=this.normalizePath(reference),unitPath=this.toRelativeIfNeeded(normaized),unitPromise=this.unit.resolveAsync(unitPath);if(!unitPromise)return Promise.resolve("");var result=unitPromise.then(function(unit){return unit&&unit.contents()||""});return result},ContentProvider.prototype.toRelativeIfNeeded=function(normaized){var unitPath=normaized;return path.isAbsolute(normaized)&&!isWebPath(normaized)&&(unitPath=path.relative(path.dirname(this.unit.absolutePath()),normaized)),unitPath},ContentProvider.prototype.hasAsyncRequests=function(){return resourceRegistry.hasAsyncRequests()},ContentProvider.prototype.resolvePath=function(context,relativePath){return ll.buildPath(relativePath,context,this.unit.project().getRootPath())},ContentProvider.prototype.isAbsolutePath=function(uri){return!!uri&&(!!isWebPath(uri)||path.isAbsolute(uri))},ContentProvider.prototype.promiseResolve=function(arg){return Promise.resolve(arg)},ContentProvider}();exports.ContentProvider=ContentProvider},function(module,exports,__webpack_require__){"use strict";function flattenArrayOfObjects(x){var res={};return x.forEach(function(v){return Object.keys(v).forEach(function(k){return res[k]=v[k]})}),res}function find(xs,f){return new Opt(_.find(xs||[],f))}function toTuples(map){return Object.keys(map).map(function(k){return[k,map[k]]})}function fromTuples(tuples){var obj={};return tuples.forEach(function(x){return obj[x[0]]=x[1]}),obj}function tap(v,f){return f(v),v}function kv(obj,iter){"object"==typeof obj&&Object.keys(obj).forEach(function(k){return iter(k,obj[k])})}function indexed(objects,key,delKey){void 0===delKey&&(delKey=!1);var obj={};return objects.forEach(function(original){var copy=exports.shallowCopy(original);delKey&&delete copy[key],obj[original[key]]=copy}),obj}function stringEndsWith(str,search){var dif=str.length-search.length;return dif>=0&&str.lastIndexOf(search)===dif}function stringStartsWith(str,search,ind){return void 0===ind&&(ind=0),str.length-search.length>=ind&&str.substring(ind,ind+search.length)===search}function lazypropkeyfilter(k){return"_"==k[k.length-1]}function lazyprop(obj,key,func){var result,ready=!1;obj[key]=function(){return ready||(ready=!0,result=func.apply(obj)),result}}function lazyprops(obj,keyfilter){void 0===keyfilter&&(keyfilter=lazypropkeyfilter);for(var k in obj)keyfilter(k)&&exports.ifInstanceOf(obj[k],Function,function(vf){return 0===vf.length?lazyprop(obj,k,vf):null})}function iff(v,f){void 0!==v&&f(v)}function isRAMLUrl(str){return"string"==typeof str&&""!=str&&stringEndsWith(str,".raml")}function getAllRequiredExternalModulesFromCode(code){for(var match,mods=[],r1=new RegExp("require\\('([^']+)'\\)","gi");match=r1.exec(code);)mods.push(match[1]);for(var r2=new RegExp('require\\("([^"]+)"\\)',"gi");match=r2.exec(code);)mods.push(match[1]);return mods=_.unique(mods).filter(function(x){return""!=x;
}),mods.sort(),mods}function isEssential(arg){return"undefined"!=typeof arg&&null!=arg}function firstToUpper(q){return 0==q.length?q:q.charAt(0).toUpperCase()+q.substr(1)}function updateObject(source,target,addNewFields){void 0===addNewFields&&(addNewFields=!1);var keySet=Object.keys(target);if(addNewFields){var map={};keySet.forEach(function(x){return map[x]=!0}),Object.keys(source).forEach(function(x){return map[x]=!0}),keySet=Object.keys(map)}keySet.forEach(function(x){var value=source[x];value instanceof Object?(target[x]||(target[x]={}),updateObject(value,target[x],!0)):void 0!=value&&(target[x]=source[x])})}function replaceMap(str,map){return Object.keys(map).forEach(function(x){return str=replace(str,x,map[x])}),str}function replace(str,x,r){for(var result="",prev=0,i=str.indexOf(x);i<str.length&&i>=0;i=str.indexOf(x,prev))result+=str.substring(prev,i),result+=r,prev=i+x.length;return result+=str.substring(prev,str.length)}var _=__webpack_require__(61),Opt=__webpack_require__(21);exports.defined=function(x){return null!==x&&void 0!==x},exports.flattenArrayOfObjects=flattenArrayOfObjects,exports.find=find,exports.isInstance=function(v,C){return v instanceof C?[v]:[]},exports.ifInstanceOf=function(v,C,f){return v instanceof C?f(v):null},exports.toTuples=toTuples,exports.fromTuples=fromTuples,exports.collectInstancesOf=function(xs,C){return tap([],function(res){return xs.forEach(function(v){return exports.ifInstanceOf(v,C,function(x){return res.push(x)})})})},exports.collectInstancesOfInMap=function(map,C){return Object.keys(map).map(function(k){return[k,map[k]]}).filter(function(x){return x[1]instanceof C}).map(function(x){return x})},exports.asArray=function(v){return exports.defined(v)?v instanceof Array?v:[v]:[]},exports.shallowCopy=function(obj){return tap({},function(copy){return Object.keys(obj).forEach(function(k){return copy[k]=obj[k]})})},exports.flatMap=function(xs,f){return exports.flatten(xs.map(f))},exports.flatten=function(xss){return Array.prototype.concat.apply([],xss)},exports.takeWhile=function(xs,f){return tap([],function(res){for(var i=0;i<xs.length&&f(xs[i]);i++)res.push(xs[i])})},exports.tap=tap,exports.kv=kv,exports.indexed=indexed,exports.stringEndsWith=stringEndsWith,exports.stringStartsWith=stringStartsWith,exports.lazypropkeyfilter=lazypropkeyfilter,exports.lazyprops=lazyprops,exports.iff=iff,exports.isRAMLUrl=isRAMLUrl,exports.getAllRequiredExternalModulesFromCode=getAllRequiredExternalModulesFromCode,exports.serial=function(){var i=0;return function(){return i++}}(),exports.isEssential=isEssential,exports.firstToUpper=firstToUpper,exports.updateObject=updateObject,exports.replaceMap=replaceMap,exports.replace=replace},function(module,exports,__webpack_require__){"use strict";function resolveType(p){return p.highLevel().localType()}function runtimeType(p){return p.highLevel().localType()}function load(pth){var m=new ll.Project(path.dirname(pth)),unit=m.unit(path.basename(pth));return unit&&unit.isRAMLUnit()?hlimpl.fromUnit(unit).wrapperNode():null}function completeRelativeUri(res){var uri="",parent=res;do res=parent,uri=res.relativeUri().value()+uri,parent=res.parent();while(parent.definition().key().name==universes.Universe10.Resource.name);return uri}function expandTraitsAndResourceTypes(api){var lowLevelNode=api.highLevel().lowLevel();return lowLevelNode instanceof lowLevelProxy.LowLevelProxyNode?api:expander.expandTraitsAndResourceTypes(api)}function absoluteUri(res){var uri="",parent=res;do res=parent,uri=res.relativeUri().value()+uri,parent=res.parent();while(parent.definition().key().name==universes.Universe10.Resource.name);uri=uri.replace(/\/\//g,"/");var buri=parent.baseUri(),base=buri?buri.value():"";return base=base?base:"",util.stringEndsWith(base,"/")&&(uri=uri.substring(1)),uri=base+uri}function validateInstance(res,value){return res.runtimeType().validate(value).map(function(x){return x.getMessage()})}function validateInstanceWithDetailedStatuses(res,value){return res.runtimeType().validate(value)}function traitsPrimary(a){return allTraits(a)}function allTraits(a){return findTemplates(a,function(d){return universeHelpers.isTraitType(d)})}function resourceTypesPrimary(a){return allResourceTypes(a)}function allResourceTypes(a){return findTemplates(a,function(d){return universeHelpers.isResourceTypeType(d)})}function findTemplates(a,filter){var arr=search.globalDeclarations(a.highLevel()).filter(function(x){return filter(x.definition())}),ll=a.highLevel().lowLevel(),nodePath=ll.includePath();nodePath||(nodePath=ll.unit().path());var isProxy=a.highLevel().lowLevel()instanceof proxy.LowLevelProxyNode,exp=isProxy?new expander.TraitsAndResourceTypesExpander:null,topLevelArr=arr.map(function(x){var topLevelNode,p=x.lowLevel().unit().path();return isProxy&&(x.lowLevel()instanceof proxy.LowLevelProxyNode||(x=exp.createHighLevelNode(x,!1)),(new referencePatcher.ReferencePatcher).process(x,a.highLevel(),!0,!0)),p!=nodePath?(topLevelNode=factory.buildWrapperNode(x,!1),topLevelNode.meta().setCalculated()):topLevelNode=x.wrapperNode(),topLevelNode});return topLevelArr}function relativeUriSegments(res){var result=[],parent=res;do res=parent,result.push(res.relativeUri().value()),parent=res.parent();while(parent.definition().key().name==universes.Universe10.Resource.name);return result.reverse()}function parentResource(method){return method.parent()instanceof RamlWrapperImpl.ResourceImpl?method.parent():null}function parent(resource){var parent=resource.parent();return parent.definition().key().name==universes.Universe10.Resource.name?parent:null}function childResource(container,relPath){if(null==container)return null;var resources=container.resources();return resources?(resources=resources.filter(function(x){return x.relativeUri().value()==relPath}),0==resources.length?null:resources[0]):null}function getResource(container,path){if(!container)return null;for(var res=null,i=0;i<path.length;i++){if(res=childResource(container,path[i]),!res)return null;container=res}return res}function childMethod(resource,method){return resource?resource.methods().filter(function(x){return x.method()==method}):null}function getMethod(container,path,method){var resource=getResource(container,path);return resource?childMethod(resource,method):null}function isApi(obj){return universeHelpers.isApiSibling(obj.definition())}function ownerApi(method){for(var obj=method;!isApi(obj);)obj=obj.parent();return obj}function methodId(method){var parent=method.parent();if(parent instanceof RamlWrapperImpl.ResourceImpl)return completeRelativeUri(parent)+" "+method.method().toLowerCase();if(parent instanceof RamlWrapperImpl.ResourceTypeImpl)return parent.name()+" "+method.method().toLowerCase();throw new Error("Method is supposed to be owned by Resource or ResourceType.\nHere the method is owned by "+method.definition().key().name)}function isOkRange(response){var str=response.code().value(),err=linter.validateResponseString(str);if(null!=err)return!1;try{if(parseInt(str.charAt(0))<4)return!0}catch(e){}return!1}function allResources(api){var resources=[],visitor=function(res){resources.push(res),res.resources().forEach(function(x){return visitor(x)})};return api.resources().forEach(function(x){return visitor(x)}),resources}function matchUri(apiRootRelativeUri,resource){for(var allParameters={};null!=resource;)uriParameters(resource).forEach(function(x){return allParameters[x.name()]=new ParamWrapper(x)}),resource=parent(resource);var result=ramlPathMatch.ramlPathMatch(completeRelativeUri(resource),allParameters,{})(apiRootRelativeUri);return result?new Opt(Object.keys(result.params).map(function(x){return new ParamValue(x,result.params[x])})):Opt.empty()}function uriParametersPrimary(resource){return uriParameters(resource)}function uriParameters(resource){var params=resource.uriParameters_original();if(!(resource instanceof RamlWrapperImpl.ResourceImpl))return params;var uri=resource.relativeUri().value(),propName=universes.Universe10.ResourceBase.properties.uriParameters.name;return extractParams(params,uri,resource,propName)}function baseUriParametersPrimary(api){return baseUriParameters(api)}function baseUriParameters(api){var uri=api.baseUri()?api.baseUri().value():"",params=api.baseUriParameters_original(),propName=universes.Universe10.Api.properties.baseUriParameters.name;return extractParams(params,uri,api,propName)}function absoluteUriParameters(res){var params=[],parent=res;do res=parent,params=uriParameters(res).concat(params),parent=res.parent();while(parent.definition().key().name==universes.Universe10.Resource.name);var api=parent;api.baseUriParameters();return params=baseUriParameters(api).concat(params)}function protocolsPrimary(api){return allProtocols(api)}function allProtocols(api){return api.protocols().map(function(x){return x.toUpperCase()})}function securedByPrimary(resourceOrMethod){return allSecuredBy(resourceOrMethod)}function allSecuredBy(resourceOrMethod){return resourceOrMethod.securedBy()}function securitySchemeName(schemeReference){var highLevel=schemeReference.highLevel();if(!highLevel)return"";var attributeValue=highLevel.value();return attributeValue?attributeValue.toString():""}function securityScheme(schemeReference){var highLevel=schemeReference.highLevel();if(!highLevel)return null;var declaration=search.findDeclarationByNode(highLevel,search.LocationKind.VALUE_COMPLETION);if(!declaration)return null;if(!declaration.getKind||declaration.getKind()!=hl.NodeKind.NODE)return null;var result=declaration.wrapperNode();return result instanceof RamlWrapperImpl.AbstractSecuritySchemeImpl?result:null}function RAMLVersion(api){return api.highLevel().definition().universe().version()}function structuredValue(reference){var llNode=reference.value().lowLevel(),type=null,hlNode=llNode.highLevelParseResult();if(hlNode){var types=null,isAnnotations=!1;if(hlNode.isAttr()?(isAnnotations=universeHelpers.isAnnotationsProperty(hlNode.property()),types=hlNode.parent().types()):hlNode.isElement()&&(types=hlNode.asElement().types()),types){var refName=reference.name(),fromLib=refName.indexOf(".")>=0;if(fromLib){var reg=isAnnotations?types.getAnnotationTypeRegistry():types.getTypeRegistry();type=reg.get(refName)}else type=isAnnotations?types.getAnnotationType(refName):types.getType(refName)}}return new core.TypeInstanceImpl(llNode,type)}function referenceName(reference){var val=reference.highLevel().value();return"string"==typeof val||null==val?val:val.valueName()}function referencedTrait(ref){return referencedObject(ref)}function referencedAnnotation(ref){return referencedObject(ref)}function referencedResourceType(ref){return referencedObject(ref)}function referencedObject(ref){var attr=ref.highLevel(),parent=attr.parent(),vn=ref.name(),cands=search.referenceTargets(attr.property(),parent).filter(function(x){return hlimpl.qName(x,parent)==vn});return 0==cands.length?null:cands[0].wrapperNode()}function examplesFromNominal(runtimeDefinition,hlParent,isSingle,patchHL){void 0===patchHL&&(patchHL=!0);var llParent=hlParent.lowLevel(),property=hlParent.definition().property(isSingle?"example":"examples"),universe=defs.getUniverse("RAML10"),definition=universe.type(universeDef.Universe10.ExampleSpec.name),expandables=runtimeDefinition.examples().filter(function(x){return!x.isEmpty()&&x.isSingle()==isSingle});return expandables.map(function(x){var obj=x.asJSON(),key=x.isSingle()?"example":null,jsonNode=new json.AstNode(llParent.unit(),obj,llParent,null,key),hlNode=patchHL?new hlimpl.ASTNodeImpl(jsonNode,hlParent,definition,property):hlParent,wrapperAnnotations=[],annotations=x.annotations();if(annotations)for(var aProp=universe.type("Annotable").property("annotations"),_i=0,_a=Object.keys(annotations);_i<_a.length;_i++){var aName=_a[_i],aObj=annotations[aName],aJson=new json.AstNode(llParent.unit(),aObj,jsonNode,null,"("+aName+")"),aHlNode=new hlimpl.ASTPropImpl(aJson,hlNode,aProp.range(),aProp),wAnnotation=new RamlWrapperImpl.AnnotationRefImpl(aHlNode);wrapperAnnotations.push(wAnnotation)}return new ExampleSpecImpl(hlNode,x,wrapperAnnotations)})}function getExpandableExamples(node,isSingle){void 0===isSingle&&(isSingle=!1);var runtimeDefinition=node.runtimeDefinition();if(!runtimeDefinition)return[];var hlParent=node.highLevel();return examplesFromNominal(runtimeDefinition,hlParent,isSingle)}function getTypeExample(td){var examples=getExpandableExamples(td,!0);return examples.length>0?examples[0]:null}function getTypeExamples(td){return getExpandableExamples(td)}function typeFixedFacets(td){var rDef=td.runtimeDefinition(),obj=rDef.getFixedFacets(),keys=Object.keys(obj);if(td.kind()!=universeDef.Universe10.UnionTypeDeclaration.name)for(var _i=0,keys_1=keys;_i<keys_1.length;_i++){var key=keys_1[_i];null==rDef.facet(key)&&delete obj[key]}if(0==Object.keys(obj).length)return null;var node=new json.AstNode(null,obj);return new core.TypeInstanceImpl(node)}function typeValue(typeDeclaration){var attrs=typeDeclaration.highLevel().attributes(defs.universesInfo.Universe10.TypeDeclaration.properties.type.name),structuredAttrs=attrs.filter(function(x){return x.value()instanceof hlimpl.StructuredValue});if(0==structuredAttrs.length)return typeDeclaration.type_original().map(function(x){return null===x||"NULL"===x||"Null"===x?"string":x});var nullify=!1,values=attrs.map(function(x){var val=x.value();return null==val?null:"string"==typeof val?val:(val instanceof hlimpl.StructuredValue&&(nullify=!0),val.toString())});return nullify?null:values}function schemaValue(typeDeclaration){var nullify=!1,attrs=typeDeclaration.highLevel().attributes(defs.universesInfo.Universe10.TypeDeclaration.properties.schema.name);if(nullify)return null;var structuredAttrs=attrs.filter(function(x){return x.value()instanceof hlimpl.StructuredValue});if(0==structuredAttrs.length)return typeDeclaration.schema_original();var values=attrs.map(function(x){var val=x.value();return"string"==typeof val?val:(val instanceof hlimpl.StructuredValue&&(nullify=!0),val.toString())});return nullify?null:values}function typeStructuredValue(typeDeclaration){var attrs=typeDeclaration.highLevel().attributes(defs.universesInfo.Universe10.TypeDeclaration.properties.type.name);attrs=attrs.concat(typeDeclaration.highLevel().attributes(defs.universesInfo.Universe10.TypeDeclaration.properties.schema.name));for(var values=attrs.map(function(x){return x.value()}),_i=0,values_1=values;_i<values_1.length;_i++){var val=values_1[_i];if(val instanceof hlimpl.StructuredValue){var typeInstance=new core.TypeInstanceImpl(val.lowLevel());return typeInstance}}return null}function referencedNode(usesDecl){var ref=usesDecl.value(),unit=usesDecl.highLevel().lowLevel().unit().resolve(ref),hlNode=unit.highLevel(),hlElement=hlNode.asElement();if(hlElement){var wrapperNode=hlElement.wrapperNode();return RamlWrapper.isLibrary(wrapperNode)?(wrapperNode.setAttributeDefaults(usesDecl.attributeDefaults()),wrapperNode):null}return null}function getItems(arrayTypeDecl){return arrayTypeDecl.items_original()}function findComponentTypeDeclBySearch(arrayTypeDecl){var typeHighLevel=arrayTypeDecl.highLevel();if(!typeHighLevel)return null;var attrType=typeHighLevel.attr(universes.Universe10.TypeDeclaration.properties.type.name);if(null==attrType)return null;var attrTypeLowLevel=attrType.lowLevel();if(null==attrTypeLowLevel)return null;var attrTypeValue=attrType.value();if(!attrTypeValue||"string"!=typeof attrTypeValue)return null;var offset=attrTypeLowLevel.end()-attrTypeValue.length+1,unit=attrType.lowLevel().unit();if(!unit)return null;var declaration=search.findDeclaration(unit,offset);return declaration&&declaration.getKind&&declaration.getKind()==hl.NodeKind.NODE&&universeHelpers.isTypeDeclarationSibling(declaration.definition())?declaration.wrapperNode():null}function findComponentTypeDeclByRuntimeType(arrayTypeDecl){var runtimeType=arrayTypeDecl.runtimeType();if(!runtimeType)return null;if(!runtimeType.isArray()||!runtimeType.componentType)return null;var runtimeArrayType=runtimeType,componentType=runtimeArrayType.componentType();if(!componentType)return null;var componentTypeHLSourceProvider=sourceFinder.getNominalTypeSource(componentType);if(!componentTypeHLSourceProvider)return null;var componentTypeSource=componentTypeHLSourceProvider.getSource();if(!componentTypeSource)return null;if(!componentTypeSource.isElement())return null;if(!universeHelpers.isTypeDeclarationSibling(componentTypeSource.definition()))return null;var basicNodeSource=componentTypeSource.wrapperNode();return basicNodeSource}function findComponentTypeDeclaration(arrayTypeDecl){var original=arrayTypeDecl.items_original();if(original)return original;var foundByRuntimeType=findComponentTypeDeclByRuntimeType(arrayTypeDecl);return foundByRuntimeType?foundByRuntimeType:findComponentTypeDeclBySearch(arrayTypeDecl)}function extractParams(params,uri,owner,propName){var ownerHl=owner.highLevel(),definition=ownerHl.definition(),prop=definition.property(propName);if(!uri)return[];var describedParams={};params.forEach(function(x){var arr=describedParams[x.name()];arr||(arr=[],describedParams[x.name()]=arr),arr.push(x)});for(var allParams=[],prev=0,mentionedParams={},i=uri.indexOf("{");i>=0&&(prev=uri.indexOf("}",++i),!(prev<0));i=uri.indexOf("{",prev)){var paramName=uri.substring(i,prev);if(mentionedParams[paramName]=!0,describedParams[paramName])describedParams[paramName].forEach(function(x){return allParams.push(x)});else{var universe=definition.universe(),nc=universe.type(universeDef.Universe10.StringTypeDeclaration.name),node=stubs.createStubNode(nc,null,paramName),uriParameter=factory.buildWrapperNode(node),hlNode=uriParameter.highLevel();hlNode.setParent(ownerHl),uriParameter.meta().setCalculated(),uriParameter.setName(paramName),hlNode.patchProp(prop),allParams.push(uriParameter)}}return Object.keys(describedParams).filter(function(x){return!mentionedParams[x]}).forEach(function(x){return describedParams[x].forEach(function(y){return allParams.push(y)})}),allParams}function getTemplateParametrizedProperties(node){if(node.kind()==universeDef.Universe10.Method.name||universeHelpers.isTypeDeclarationSibling(node.definition())){for(var isInsideTemplate=!1,parent=node.highLevel().parent();null!=parent;){var pDef=parent.definition();if(universeHelpers.isResourceTypeType(pDef)||universeHelpers.isTraitType(pDef)){isInsideTemplate=!0;break}parent=parent.parent()}if(!isInsideTemplate)return null}var highLevelNode=node.highLevel();if(null==highLevelNode)return null;var lowLevelNode=highLevelNode.lowLevel();if(null==lowLevelNode)return null;var children=lowLevelNode.children().filter(function(x){var key=x.key();return!!key&&(("("!=key.charAt(0)||")"!=key.charAt(key.length-1))&&key.indexOf("<<")>=0)});if(0==children.length)return null;var result=new core.TypeInstanceImpl(children);return result}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},RamlWrapper=__webpack_require__(12),RamlWrapperImpl=__webpack_require__(20),factory=__webpack_require__(42),core=__webpack_require__(45),ramlPathMatch=__webpack_require__(55),hl=__webpack_require__(10),hlimpl=__webpack_require__(16),linter=__webpack_require__(25),stubs=__webpack_require__(17),defs=__webpack_require__(36),universeDef=__webpack_require__(22),universes=__webpack_require__(22),Opt=__webpack_require__(21),util=__webpack_require__(31),expander=__webpack_require__(24),proxy=__webpack_require__(38),referencePatcher=__webpack_require__(49),lowLevelProxy=__webpack_require__(38),search=__webpack_require__(23),ll=__webpack_require__(27),json=__webpack_require__(50),path=__webpack_require__(15),universeHelpers=__webpack_require__(14),sourceFinder=__webpack_require__(46);exports.resolveType=resolveType,exports.runtimeType=runtimeType,exports.load=load,exports.completeRelativeUri=completeRelativeUri,exports.expandTraitsAndResourceTypes=expandTraitsAndResourceTypes,exports.absoluteUri=absoluteUri,exports.validateInstance=validateInstance,exports.validateInstanceWithDetailedStatuses=validateInstanceWithDetailedStatuses,exports.traitsPrimary=traitsPrimary,exports.allTraits=allTraits,exports.resourceTypesPrimary=resourceTypesPrimary,exports.allResourceTypes=allResourceTypes,exports.relativeUriSegments=relativeUriSegments,exports.parentResource=parentResource,exports.parent=parent,exports.childResource=childResource,exports.getResource=getResource,exports.childMethod=childMethod,exports.getMethod=getMethod,exports.ownerApi=ownerApi,exports.methodId=methodId,exports.isOkRange=isOkRange,exports.allResources=allResources,exports.matchUri=matchUri;exports.uriParametersPrimary=uriParametersPrimary,exports.uriParameters=uriParameters,exports.baseUriParametersPrimary=baseUriParametersPrimary,exports.baseUriParameters=baseUriParameters,exports.absoluteUriParameters=absoluteUriParameters,exports.protocolsPrimary=protocolsPrimary,exports.allProtocols=allProtocols,exports.securedByPrimary=securedByPrimary,exports.allSecuredBy=allSecuredBy,exports.securitySchemeName=securitySchemeName,exports.securityScheme=securityScheme,exports.RAMLVersion=RAMLVersion,exports.structuredValue=structuredValue,exports.referenceName=referenceName,exports.referencedTrait=referencedTrait,exports.referencedAnnotation=referencedAnnotation,exports.referencedResourceType=referencedResourceType,exports.examplesFromNominal=examplesFromNominal,exports.getTypeExample=getTypeExample,exports.getTypeExamples=getTypeExamples,exports.typeFixedFacets=typeFixedFacets,exports.typeValue=typeValue,exports.schemaValue=schemaValue,exports.typeStructuredValue=typeStructuredValue,exports.referencedNode=referencedNode,exports.getItems=getItems,exports.findComponentTypeDeclaration=findComponentTypeDeclaration,exports.getTemplateParametrizedProperties=getTemplateParametrizedProperties;var SchemaDef=function(){function SchemaDef(_content,_name){this._content=_content,this._name=_name}return SchemaDef.prototype.name=function(){return this._name},SchemaDef.prototype.content=function(){return this._content},SchemaDef}();exports.SchemaDef=SchemaDef;var ParamValue=function(){function ParamValue(key,value){this.key=key,this.value=value}return ParamValue}();exports.ParamValue=ParamValue;var ParamWrapper=function(){function ParamWrapper(_param){this._param=_param,this.description=_param.description()?_param.description().value():this.description,this.displayName=_param.displayName(),this.type=_param.type().length>0?_param.type()[0]:"string",this.example=_param.example(),this.required=_param.required(),this.default=_param.default()}return ParamWrapper}(),ExampleSpecImpl=function(_super){function ExampleSpecImpl(hlNode,expandable,_annotations){_super.call(this,hlNode),this.expandable=expandable,this._annotations=_annotations}return __extends(ExampleSpecImpl,_super),ExampleSpecImpl.prototype.value=function(){return this.expandable.asString()},ExampleSpecImpl.prototype.structuredValue=function(){var obj;obj=this.expandable.isJSONString()||this.expandable.isYAML()?this.expandable.asJSON():this.expandable.original();var llParent=this._node.lowLevel(),key=this.expandable.isSingle()?"example":null,jsonNode=new json.AstNode(llParent.unit(),obj,llParent,null,key);return new core.TypeInstanceImpl(jsonNode)},ExampleSpecImpl.prototype.strict=function(){return this.expandable.strict()},ExampleSpecImpl.prototype.description=function(){var descriptionValue=this.expandable.description();if(null==descriptionValue&&null!==descriptionValue)return null;var attr=stubs.createAttr(this._node.definition().property(universeDef.Universe10.ExampleSpec.properties.description.name),descriptionValue),result=new RamlWrapperImpl.MarkdownStringImpl(attr);return result},ExampleSpecImpl.prototype.name=function(){return this.expandable.name()},ExampleSpecImpl.prototype.displayName=function(){return this.expandable.displayName()},ExampleSpecImpl.prototype.annotations=function(){return this._annotations},ExampleSpecImpl.prototype.scalarsAnnotations=function(){return{}},ExampleSpecImpl.prototype.uses=function(){return _super.prototype.elements.call(this,"uses")},ExampleSpecImpl}(core.BasicNodeImpl);exports.ExampleSpecImpl=ExampleSpecImpl},function(module,exports,__webpack_require__){"use strict";var serv=__webpack_require__(36);module.exports=serv},function(module,exports,__webpack_require__){"use strict";var ramlDS=__webpack_require__(36);module.exports=ramlDS.getUniverse},function(module,exports,__webpack_require__){!function(root){function noop(){}function bind(fn,thisArg){return function(){fn.apply(thisArg,arguments)}}function Promise(fn){if("object"!=typeof this)throw new TypeError("Promises must be constructed via new");if("function"!=typeof fn)throw new TypeError("not a function");this._state=0,this._handled=!1,this._value=void 0,this._deferreds=[],doResolve(fn,this)}function handle(self,deferred){for(;3===self._state;)self=self._value;return 0===self._state?void self._deferreds.push(deferred):(self._handled=!0,void asap(function(){var cb=1===self._state?deferred.onFulfilled:deferred.onRejected;if(null===cb)return void(1===self._state?resolve:reject)(deferred.promise,self._value);var ret;try{ret=cb(self._value)}catch(e){return void reject(deferred.promise,e)}resolve(deferred.promise,ret)}))}function resolve(self,newValue){try{if(newValue===self)throw new TypeError("A promise cannot be resolved with itself.");if(newValue&&("object"==typeof newValue||"function"==typeof newValue)){var then=newValue.then;if(newValue instanceof Promise)return self._state=3,self._value=newValue,void finale(self);if("function"==typeof then)return void doResolve(bind(then,newValue),self)}self._state=1,self._value=newValue,finale(self)}catch(e){reject(self,e)}}function reject(self,newValue){self._state=2,self._value=newValue,finale(self)}function finale(self){2===self._state&&0===self._deferreds.length&&asap(function(){self._handled||onUnhandledRejection(self._value)},1);for(var i=0,len=self._deferreds.length;i<len;i++)handle(self,self._deferreds[i]);self._deferreds=null}function Handler(onFulfilled,onRejected,promise){this.onFulfilled="function"==typeof onFulfilled?onFulfilled:null,this.onRejected="function"==typeof onRejected?onRejected:null,this.promise=promise}function doResolve(fn,self){var done=!1;try{fn(function(value){done||(done=!0,resolve(self,value))},function(reason){done||(done=!0,reject(self,reason))})}catch(ex){if(done)return;done=!0,reject(self,ex)}}var setTimeoutFunc=setTimeout,asap="function"==typeof setImmediate&&setImmediate||function(fn){setTimeoutFunc(fn,1)},onUnhandledRejection=function(err){"undefined"!=typeof console&&console&&console.warn("Possible Unhandled Promise Rejection:",err)};Promise.prototype.catch=function(onRejected){return this.then(null,onRejected)},Promise.prototype.then=function(onFulfilled,onRejected){var prom=new Promise(noop);return handle(this,new Handler(onFulfilled,onRejected,prom)),prom},Promise.all=function(arr){var args=Array.prototype.slice.call(arr);return new Promise(function(resolve,reject){function res(i,val){try{if(val&&("object"==typeof val||"function"==typeof val)){var then=val.then;if("function"==typeof then)return void then.call(val,function(val){res(i,val)},reject)}args[i]=val,0===--remaining&&resolve(args)}catch(ex){reject(ex)}}if(0===args.length)return resolve([]);for(var remaining=args.length,i=0;i<args.length;i++)res(i,args[i])})},Promise.resolve=function(value){return value&&"object"==typeof value&&value.constructor===Promise?value:new Promise(function(resolve){resolve(value)})},Promise.reject=function(value){return new Promise(function(resolve,reject){reject(value)})},Promise.race=function(values){return new Promise(function(resolve,reject){for(var i=0,len=values.length;i<len;i++)values[i].then(resolve,reject)})},Promise._setImmediateFn=function(fn){asap=fn},Promise._setUnhandledRejectionFn=function(fn){onUnhandledRejection=fn},"undefined"!=typeof module&&module.exports?module.exports=Promise:root.Promise||(root.Promise=Promise)}(this)},function(module,exports,__webpack_require__){"use strict";function getSchemaUtils(){return exports.rt.getSchemaUtils()}function registerAdapters(a){a.isUnion?a.addAdapter(new RAMLService(a)):a.range&&a.addAdapter(new RAMLPropertyService(a))}function isSourceProvider(object){return object.getSource&&"function"==typeof object.getSource}function prop(name,desc,domain,range,custom){var prop=new Property(name,desc);return prop.withDomain(domain,custom).withRange(range)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)};exports.rt=__webpack_require__(84);var typeSystem=exports.rt.nominalTypes;exports.getSchemaUtils=getSchemaUtils,exports.TOP_LEVEL_EXTRA=exports.rt.TOP_LEVEL_EXTRA,exports.DEFINED_IN_TYPES_EXTRA=exports.rt.DEFINED_IN_TYPES_EXTRA,exports.USER_DEFINED_EXTRA=exports.rt.USER_DEFINED_EXTRA,exports.SOURCE_EXTRA=exports.rt.SOURCE_EXTRA,exports.tsInterfaces=exports.rt.tsInterfaces,exports.injector={inject:function(a){registerAdapters(a)}},typeSystem.registerInjector(exports.injector);var AbstractType=function(_super){function AbstractType(){_super.apply(this,arguments)}return __extends(AbstractType,_super),AbstractType}(typeSystem.AbstractType);exports.AbstractType=AbstractType;var ValueType=function(_super){function ValueType(){_super.apply(this,arguments)}return __extends(ValueType,_super),ValueType}(typeSystem.ValueType);exports.ValueType=ValueType;var SourceProvider=function(){function SourceProvider(){}return SourceProvider.prototype.getSource=function(){return null},SourceProvider}();exports.SourceProvider=SourceProvider,exports.isSourceProvider=isSourceProvider;var EnumType=function(_super){function EnumType(){_super.apply(this,arguments),this.values=[]}return __extends(EnumType,_super),EnumType}(ValueType);exports.EnumType=EnumType;var ReferenceType=function(_super){function ReferenceType(name,path,referenceTo,_universe){_super.call(this,name,_universe,path),this.referenceTo=referenceTo}return __extends(ReferenceType,_super),ReferenceType.prototype.getReferencedType=function(){return this.universe().type(this.referenceTo)},ReferenceType.prototype.hasStructure=function(){return!0},ReferenceType}(ValueType);exports.ReferenceType=ReferenceType;var NodeClass=function(_super){function NodeClass(_name,universe,path,_description){void 0===_description&&(_description=""),_super.call(this,_name,universe,path)}return __extends(NodeClass,_super),NodeClass.prototype.allProperties=function(v){return void 0===v&&(v={}),_super.prototype.allProperties.call(this,v)},NodeClass}(typeSystem.StructuredType);exports.NodeClass=NodeClass;var UserDefinedClass=function(_super){function UserDefinedClass(name,universe,hl,path,description){_super.call(this,name,universe,path,description),this.getAdapter(RAMLService).setDeclaringNode(hl)}return __extends(UserDefinedClass,_super),UserDefinedClass.prototype.key=function(){return null},UserDefinedClass.prototype.isUserDefined=function(){return!0},UserDefinedClass.prototype.typeId=function(){var rs=this.nameId(),node=this.getAdapter(RAMLService).getDeclaringNode();if(node){rs+=node.lowLevel().start();var unit=node.lowLevel().unit();unit&&(rs+=unit.absolutePath())}return rs},UserDefinedClass.prototype.hasValueTypeInHierarchy=function(){return!!this._value||(this.isAssignableFrom("ObjectTypeDeclaration"),!1)},UserDefinedClass.prototype.isGenuineUserDefinedType=function(){return null!=this.genuineUserDefinedType()},UserDefinedClass.prototype.genuineUserDefinedType=function(){var declaringNode=this.getAdapter(RAMLService).getDeclaringNode();return declaringNode?this:null},UserDefinedClass}(NodeClass);exports.UserDefinedClass=UserDefinedClass;var AnnotationType=function(_super){function AnnotationType(){_super.apply(this,arguments)}return __extends(AnnotationType,_super),AnnotationType.prototype.allProperties=function(ps){
void 0===ps&&(ps={});var rs=this.superTypes()[0].allProperties();if(0==rs.length){var node=this.getAdapter(RAMLService).getDeclaringNode(),up=new UserDefinedProp("value",node);up.withDomain(this),up.withCanBeValue(),up.withRequired(!1);this.superTypes()[0];rs=[],up.withRange(up.node().asElement().definition().universe().type("string")),rs.push(up)}return rs},AnnotationType.prototype.isAnnotationType=function(){return!0},AnnotationType}(UserDefinedClass);exports.AnnotationType=AnnotationType;var Universe=function(_super){function Universe(dec,name,_parent,v){void 0===name&&(name=""),void 0===_parent&&(_parent=null),void 0===v&&(v="RAML08"),_super.call(this,name),this._parent=_parent,this._classes=[],this._uversion="RAML08",this.aMap={},this.matchedObjects=dec,this._uversion=v}return __extends(Universe,_super),Universe.prototype.matched=function(){return this.matchedObjects?this.matchedObjects:this._parent?this._parent.matched():void 0},Universe.prototype.setTopLevel=function(t){this._topLevel=t},Universe.prototype.getTopLevel=function(){return this._topLevel},Universe.prototype.setOriginalTopLevelText=function(t){this._originalTopLevelText=t},Universe.prototype.getOriginalTopLevelText=function(){return this._originalTopLevelText},Universe.prototype.setTypedVersion=function(tv){this._typedVersion=tv},Universe.prototype.getTypedVersion=function(){return this._typedVersion},Universe.prototype.version=function(){return this._uversion},Universe.prototype.setUniverseVersion=function(version){this._uversion=version},Universe.prototype.types=function(){var result=[].concat(this._classes);return null!=this._parent&&(result=result.concat(this._parent.types())),result},Universe.prototype.type=function(name){if(this.aMap[name])return this.aMap[name];for(var tp,i=0;i<this._classes.length;i++)if(this._classes[i].nameId()==name){tp=this._classes[i];break}if(null==tp&&this._parent){var tp=this._parent.type(name);if(tp instanceof AbstractType){var at=tp;at._universe=this}}return tp},Universe.prototype.register=function(t){return this._classes.push(t),t instanceof NodeClass&&this._classes.forEach(function(x){if(x instanceof NodeClass){var nc=x;nc.getAdapter(RAMLService).getExtendedType()==t&&t.getAdapter(RAMLService).getRuntimeExtenders().push(x)}}),this},Universe.prototype.registerAlias=function(a,t){this.aMap[a]=t},Universe.prototype.unregister=function(t){this._classes=this._classes.filter(function(x){return x!=t});var st=t.superTypes();return st.forEach(function(x){var a=x;a._superTypes=a._superTypes.filter(function(x){return x!=t})}),st=t.subTypes(),st.forEach(function(x){var a=x;a._subTypes=a._subTypes.filter(function(x){return x!=t})}),this},Universe.prototype.registerSuperClass=function(t0,t1){var a0=t0,a1=t1;a0._superTypes.push(t1),a1._subTypes.push(t0)},Universe}(typeSystem.Described);exports.Universe=Universe,exports.prop=prop;var ChildValueConstraint=function(){function ChildValueConstraint(name,value){this.name=name,this.value=value}return ChildValueConstraint}();exports.ChildValueConstraint=ChildValueConstraint;var Property=function(_super){function Property(){_super.apply(this,arguments),this._isFromParentValue=!1,this._isFromParentKey=!1,this._key=!1,this._declaresFields=!1,this._describes=null,this._canBeDuplicator=!1,this._allowsNull=!1,this._canBeValue=!1,this._isInherited=!1,this._selfNode=!1,this._noDirectParse=!1,this._contextReq=[],this.determinesChildValues=[]}return __extends(Property,_super),Property.prototype.isPrimitive=function(){return this.range().isValueType()&&!(this.range()instanceof ReferenceType)},Property.prototype.withNoDirectParse=function(){this._noDirectParse=!0},Property.prototype.isNoDirectParse=function(){return this._noDirectParse},Property.prototype.withSelfNode=function(){this._selfNode=!0},Property.prototype.isSelfNode=function(){return this._selfNode},Property.prototype.matchKey=function(k){return null!=this._groupName?this.isAnnotation()?"("==k.charAt(0)&&")"==k.charAt(k.length-1):this._groupName==k:_super.prototype.matchKey.call(this,k)},Property.prototype.valueDocProvider=function(){return this._vprovider},Property.prototype.setValueDocProvider=function(v){return this._vprovider=v,this},Property.prototype.suggester=function(){return this._suggester},Property.prototype.setValueSuggester=function(s){this._suggester=s},Property.prototype.enumOptions=function(){return this._enumOptions&&"string"==typeof this._enumOptions?[this._enumOptions+""]:this._enumOptions},Property.prototype.getOftenKeys=function(){return this._oftenKeys},Property.prototype.withOftenKeys=function(keys){return this._oftenKeys=keys,this},Property.prototype.withCanBeValue=function(){return this._canBeValue=!0,this},Property.prototype.withInherited=function(w){this._isInherited=w},Property.prototype.isInherited=function(){return this._isInherited},Property.prototype.isAllowNull=function(){return this._allowsNull},Property.prototype.withAllowNull=function(){this._allowsNull=!0},Property.prototype.getCanBeDuplicator=function(){return this._canBeDuplicator},Property.prototype.canBeValue=function(){return this._canBeValue},Property.prototype.setCanBeDuplicator=function(){return this._canBeDuplicator=!0,!0},Property.prototype.inheritedContextValue=function(){return this._inheritsValueFromContext},Property.prototype.withInheritedContextValue=function(v){return this._inheritsValueFromContext=v,this},Property.prototype.withContextRequirement=function(name,value){this._contextReq.push({name:name,value:value})},Property.prototype.getContextRequirements=function(){return this._contextReq},Property.prototype.withDescribes=function(a){return this._describes=a,this},Property.prototype.describesAnnotation=function(){return null!=this._describes},Property.prototype.describedAnnotation=function(){return this._describes},Property.prototype.isReference=function(){return this.range()instanceof ReferenceType},Property.prototype.referencesTo=function(){return this.range().getReferencedType()},Property.prototype.newInstanceName=function(){return this._newInstanceName?this._newInstanceName:this.range().nameId()},Property.prototype.withThisPropertyDeclaresFields=function(b){return void 0===b&&(b=!0),this._declaresFields=b,this},Property.prototype.isThisPropertyDeclaresTypeFields=function(){return this._declaresFields},Property.prototype.withNewInstanceName=function(name){return this._newInstanceName=name,this},Property.prototype.addChildValueConstraint=function(c){this.determinesChildValues.push(c)},Property.prototype.getChildValueConstraints=function(){return this.determinesChildValues},Property.prototype.childRestrictions=function(){return this.determinesChildValues},Property.prototype.id=function(){return this._id?this._id:this._groupName?this.domain().getAdapter(RAMLService).getDeclaringNode()?null:(this._id=this._groupName+this.domain().nameId(),this._id):null},Property.prototype.isAnnotation=function(){return"annotations"==this._groupName&&this.domain()&&!this.domain().isUserDefined()},Property.prototype.withFromParentValue=function(v){return void 0===v&&(v=!0),this._isFromParentValue=v,this},Property.prototype.withFromParentKey=function(v){return void 0===v&&(v=!0),this._isFromParentKey=v,this},Property.prototype.isFromParentKey=function(){return this._isFromParentKey},Property.prototype.isFromParentValue=function(){return this._isFromParentValue},Property.prototype.withGroupName=function(gname){return this._groupName=gname,this},Property.prototype.unmerge=function(){return this._groupName=this.nameId(),this},Property.prototype.merge=function(){return this._groupName=null,this},Property.prototype.withKey=function(isKey){return this._key=isKey,this},Property.prototype.isKey=function(){return this._key},Property.prototype.isMerged=function(){return null==this._groupName},Property.prototype.groupName=function(){return this._groupName},Property.prototype.key=function(){return null},Property}(typeSystem.Property);exports.Property=Property;var UserDefinedProp=function(_super){function UserDefinedProp(name,source){_super.call(this,name),this._node=source}return __extends(UserDefinedProp,_super),UserDefinedProp.prototype.withDisplayName=function(name){this._displayName=name},UserDefinedProp.prototype.getDisplayName=function(){return this._displayName},UserDefinedProp.prototype.node=function(){return this._node||null==this.sourceProvider||(this._node=this.sourceProvider.getSource()),this._node},UserDefinedProp.prototype.setSourceProvider=function(sourceProvider){this.sourceProvider=sourceProvider},UserDefinedProp}(Property);exports.UserDefinedProp=UserDefinedProp;var RAMLPropertyDocumentationService=function(){function RAMLPropertyDocumentationService(){}return RAMLPropertyDocumentationService.prototype.setDocTableName=function(val){this._documentationTableName=val},RAMLPropertyDocumentationService.prototype.docTableName=function(){return this._documentationTableName},RAMLPropertyDocumentationService.prototype.setHidden=function(val){this._isHidden=val},RAMLPropertyDocumentationService.prototype.isHidden=function(){return this._isHidden},RAMLPropertyDocumentationService.prototype.setMarkdownDescription=function(val){this._markdownDescription=val},RAMLPropertyDocumentationService.prototype.markdownDescription=function(){return this._markdownDescription},RAMLPropertyDocumentationService.prototype.setValueDescription=function(val){this._valueDescription=val},RAMLPropertyDocumentationService.prototype.valueDescription=function(){return this._valueDescription},RAMLPropertyDocumentationService}();exports.RAMLPropertyDocumentationService=RAMLPropertyDocumentationService;var RAMLPropertyParserService=function(_super){function RAMLPropertyParserService(){_super.apply(this,arguments)}return __extends(RAMLPropertyParserService,_super),RAMLPropertyParserService.prototype.isSystem=function(){return this._isSystemProperty},RAMLPropertyParserService.prototype.withSystem=function(s){return this._isSystemProperty=s,this},RAMLPropertyParserService.prototype.isEmbedMap=function(){return this._isEmbededMap},RAMLPropertyParserService.prototype.withEmbedMap=function(){return this._isEmbededMap=!0,this},RAMLPropertyParserService}(RAMLPropertyDocumentationService);exports.RAMLPropertyParserService=RAMLPropertyParserService;var RAMLPropertyService=function(_super){function RAMLPropertyService(_property){if(_super.call(this),this._property=_property,this._meta={},!_property)throw new Error;_super.call(this)}return __extends(RAMLPropertyService,_super),RAMLPropertyService.prototype.valueDocProvider=function(){return this._property.valueDocProvider()},RAMLPropertyService.prototype.withPropertyGrammarType=function(pt){this._propertyGrammarType=pt},RAMLPropertyService.prototype.getPropertyGrammarType=function(){return this._propertyGrammarType},RAMLPropertyService.prototype.id=function(){return this._property.nameId()},RAMLPropertyService.prototype.range=function(){return this._property.range()},RAMLPropertyService.prototype.domain=function(){return this._property.domain()},RAMLPropertyService.prototype.isAllowNull=function(){return this._property.isAllowNull()},RAMLPropertyService.prototype.referencesTo=function(){return this._property.referencesTo()},RAMLPropertyService.prototype.isReference=function(){return this._property.isReference()},RAMLPropertyService.prototype.nameId=function(){return this._property.nameId()},RAMLPropertyService.prototype.priority=function(){return this.isKey()?128:this.isReference()?64:this.isTypeExpr()?32:"example"==this.nameId()?0:-1024},RAMLPropertyService.prototype.isKey=function(){return this._property instanceof Property&&this._property.isKey()},RAMLPropertyService.prototype.isMerged=function(){return this._property instanceof Property&&this._property.isMerged()},RAMLPropertyService.prototype.isTypeExpr=function(){return this.texpr},RAMLPropertyService.prototype.isExampleProperty=function(){return this.example},RAMLPropertyService.prototype.setExample=function(e){this.example=e},RAMLPropertyService.prototype.setTypeExpression=function(e){this.texpr=e},RAMLPropertyService.prototype.isDescriminating=function(){return this._property.isDescriminator()},RAMLPropertyService.prototype.putMeta=function(key,value){this._meta[key]=value},RAMLPropertyService.prototype.meta=function(key){return this._meta[key]},RAMLPropertyService}(RAMLPropertyParserService);exports.RAMLPropertyService=RAMLPropertyService;var RAMLService=function(){function RAMLService(d){this._allowsOptionalProperties=!1,this._possibleInterfaces=[],this._canInherit=[],this._declaredBy=[],this._aliases=[],this._defining=[],this._runtimeExtenders=[],this._declaresType=null,this._isTemplate=!1,this._contextRequirements=[],this._type=d}return RAMLService.prototype.withAllowQuestion=function(){this._allowsOptionalProperties=!0},RAMLService.prototype.getAllowQuestion=function(){return this._allowsOptionalProperties},RAMLService.prototype.withCanInherit=function(clazz){this._canInherit.push(clazz)},RAMLService.prototype.getReferenceIs=function(){return this._referenceIs},RAMLService.prototype.withReferenceIs=function(fname){this._referenceIs=fname},RAMLService.prototype.descriminatorValue=function(){return 0==this.valueRequirements().length?this.nameId():this.valueRequirements()[0].value},RAMLService.prototype.getCanInherit=function(){return this._canInherit},RAMLService.prototype.withAllowAny=function(){this._allowsAnyChildren=!0},RAMLService.prototype.getAllowAny=function(){return this._allowsAnyChildren||this._type.isExternal()},RAMLService.prototype.globallyDeclaredBy=function(){return this._declaredBy},RAMLService.prototype.setGloballyDeclaredBy=function(c){this._declaredBy.push(c)},RAMLService.prototype.setDeclaringNode=function(n){this._node=n},RAMLService.prototype.nameId=function(){return this._type.nameId()},RAMLService.prototype.universe=function(){return this._type.universe()},RAMLService.prototype.isAssignableFrom=function(name){return this._type.isAssignableFrom(name)},RAMLService.prototype.setConsumesRefs=function(b){this._consumesRef=b},RAMLService.prototype.definingPropertyIsEnough=function(v){this._defining.push(v)},RAMLService.prototype.getDefining=function(){return this._defining},RAMLService.prototype.getConsumesRefs=function(){return this._consumesRef},RAMLService.prototype.addAlias=function(al){this._aliases.push(al)},RAMLService.prototype.getAliases=function(){return this._aliases},RAMLService.prototype.valueRequirements=function(){return this._type.valueRequirements()},RAMLService.prototype.isAnnotation=function(){return this._annotationChecked?this._isAnnotation:(this._annotationChecked=!0,this._isAnnotation=this._type.allSuperTypes().some(function(x){return x.key()&&"AnnotationRef"==x.key().name}),this._isAnnotation)},RAMLService.prototype.allowValue=function(){return this._allowsValueSet?this._allowsValue:this._type.allProperties().some(function(x){return x.isFromParentValue()||x.canBeValue()})?(this._allowsValue=!0,this._allowsValueSet=!0,!0):(this._allowsValueSet=!0,!1)},RAMLService.prototype.key=function(){return this._type.key()},RAMLService.prototype.getRepresentationOf=function(){return this._representationOf},RAMLService.prototype.getPath=function(){return""},RAMLService.prototype.isDeclaration=function(){return!!this._isTemplate||(!!this._convertsToGlobal||(!!this._declaresType||!(!this.key()||"Library"!==this.key().name)))},RAMLService.prototype.isGlobalDeclaration=function(){return!!this._actuallyExports||(!!this._isTemplate||!!this._declaresType)},RAMLService.prototype.isTypeSystemMember=function(){return null!=this._declaresType},RAMLService.prototype.getExtendedType=function(){return this.universe().type(this._declaresType)},RAMLService.prototype.setInlinedTemplates=function(b){return this._isTemplate=b,this},RAMLService.prototype.getRuntimeExtenders=function(){return this._runtimeExtenders},RAMLService.prototype.isInlinedTemplates=function(){return this._isTemplate},RAMLService.prototype.setExtendedTypeName=function(name){this._declaresType=name;var tp=this.universe().type(name);if(tp instanceof NodeClass){var nc=tp;nc.getAdapter(RAMLService)._runtimeExtenders.push(this._type)}},RAMLService.prototype.getKeyProp=function(){for(var c=this._type.allProperties(),i=0;i<c.length;i++)if(c[i].getAdapter(RAMLPropertyService).isKey())return c[i];return null},RAMLService.prototype.withActuallyExports=function(pname){this._actuallyExports=pname},RAMLService.prototype.withConvertsToGlobal=function(pname){this._convertsToGlobal=pname},RAMLService.prototype.getConvertsToGlobal=function(){return this._convertsToGlobal},RAMLService.prototype.getActuallyExports=function(){return this._actuallyExports},RAMLService.prototype.isUserDefined=function(){return this._type instanceof NodeClass?this._type.isUserDefined():this._type instanceof AbstractType&&this._type.isUserDefined()},RAMLService.prototype.withContextRequirement=function(name,value){this._contextRequirements.push({name:name,value:value})},RAMLService.prototype.getContextRequirements=function(){return this._contextRequirements},RAMLService.prototype.findMembersDeterminer=function(){for(var c=this._type.allProperties(),i=0;i<c.length;i++)if(c[i].isThisPropertyDeclaresTypeFields())return c[i];return null},RAMLService.prototype.getDeclaringNode=function(){if(this._node)return this._node;if(this._type){var sourceNode=this._type.getExtra(exports.SOURCE_EXTRA);return sourceNode?sourceNode instanceof SourceProvider||sourceNode.getSource&&"function"==typeof sourceNode.getSource?sourceNode.getSource():sourceNode:null}return null},RAMLService.prototype.registerSupertypes=function(classNames){var _this=this,universe=this._type.universe();classNames.forEach(function(x){var supertype=universe.type(x);supertype&&_this._type.addSuperType(supertype)})},RAMLService.prototype.registerPossibleInterfaces=function(classNames){for(var universe=this._type.universe(),_i=0,classNames_1=classNames;_i<classNames_1.length;_i++){var x=classNames_1[_i],supertype=universe.type(x);if(!supertype)return;this._possibleInterfaces.push(supertype)}},RAMLService.prototype.possibleInterfaces=function(){return this._possibleInterfaces},RAMLService}();exports.RAMLService=RAMLService;var universes={},ramlDS=__webpack_require__(56),jsonDefinitions=ramlDS.universeDumps,ts2def=__webpack_require__(57),unDesc=__webpack_require__(58);exports.universesInfo=unDesc,exports.getUniverse=function(){var x=function(key){if(universes[key])return universes[key];var src=jsonDefinitions[key],universe=ts2def.toDefSystem(src,"RAML08"==key?unDesc.Universe08:unDesc.Universe10);return universe&&(universe.setUniverseVersion(key),universes[key]=universe),universe};return x.availableUniverses=function(){return Object.keys(jsonDefinitions)},x}()},function(module,exports,__webpack_require__){function Url(){this.protocol=null,this.slashes=null,this.auth=null,this.host=null,this.port=null,this.hostname=null,this.hash=null,this.search=null,this.query=null,this.pathname=null,this.path=null,this.href=null}function urlParse(url,parseQueryString,slashesDenoteHost){if(url&&isObject(url)&&url instanceof Url)return url;var u=new Url;return u.parse(url,parseQueryString,slashesDenoteHost),u}function urlFormat(obj){return isString(obj)&&(obj=urlParse(obj)),obj instanceof Url?obj.format():Url.prototype.format.call(obj)}function urlResolve(source,relative){return urlParse(source,!1,!0).resolve(relative)}function urlResolveObject(source,relative){return source?urlParse(source,!1,!0).resolveObject(relative):relative}function isString(arg){return"string"==typeof arg}function isObject(arg){return"object"==typeof arg&&null!==arg}function isNull(arg){return null===arg}function isNullOrUndefined(arg){return null==arg}var punycode=__webpack_require__(81);exports.parse=urlParse,exports.resolve=urlResolve,exports.resolveObject=urlResolveObject,exports.format=urlFormat,exports.Url=Url;var protocolPattern=/^([a-z0-9.+-]+:)/i,portPattern=/:[0-9]*$/,delims=["<",">",'"',"`"," ","\r","\n","\t"],unwise=["{","}","|","\\","^","`"].concat(delims),autoEscape=["'"].concat(unwise),nonHostChars=["%","/","?",";","#"].concat(autoEscape),hostEndingChars=["/","?","#"],hostnameMaxLen=255,hostnamePartPattern=/^[a-z0-9A-Z_-]{0,63}$/,hostnamePartStart=/^([a-z0-9A-Z_-]{0,63})(.*)$/,unsafeProtocol={javascript:!0,"javascript:":!0},hostlessProtocol={javascript:!0,"javascript:":!0},slashedProtocol={http:!0,https:!0,ftp:!0,gopher:!0,file:!0,"http:":!0,"https:":!0,"ftp:":!0,"gopher:":!0,"file:":!0},querystring=__webpack_require__(80);Url.prototype.parse=function(url,parseQueryString,slashesDenoteHost){if(!isString(url))throw new TypeError("Parameter 'url' must be a string, not "+typeof url);var rest=url;rest=rest.trim();var proto=protocolPattern.exec(rest);if(proto){proto=proto[0];var lowerProto=proto.toLowerCase();this.protocol=lowerProto,rest=rest.substr(proto.length)}if(slashesDenoteHost||proto||rest.match(/^\/\/[^@\/]+@[^@\/]+/)){var slashes="//"===rest.substr(0,2);!slashes||proto&&hostlessProtocol[proto]||(rest=rest.substr(2),this.slashes=!0)}if(!hostlessProtocol[proto]&&(slashes||proto&&!slashedProtocol[proto])){for(var hostEnd=-1,i=0;i<hostEndingChars.length;i++){var hec=rest.indexOf(hostEndingChars[i]);hec!==-1&&(hostEnd===-1||hec<hostEnd)&&(hostEnd=hec)}var auth,atSign;atSign=hostEnd===-1?rest.lastIndexOf("@"):rest.lastIndexOf("@",hostEnd),atSign!==-1&&(auth=rest.slice(0,atSign),rest=rest.slice(atSign+1),this.auth=decodeURIComponent(auth)),hostEnd=-1;for(var i=0;i<nonHostChars.length;i++){var hec=rest.indexOf(nonHostChars[i]);hec!==-1&&(hostEnd===-1||hec<hostEnd)&&(hostEnd=hec)}hostEnd===-1&&(hostEnd=rest.length),this.host=rest.slice(0,hostEnd),rest=rest.slice(hostEnd),this.parseHost(),this.hostname=this.hostname||"";var ipv6Hostname="["===this.hostname[0]&&"]"===this.hostname[this.hostname.length-1];if(!ipv6Hostname)for(var hostparts=this.hostname.split(/\./),i=0,l=hostparts.length;i<l;i++){var part=hostparts[i];if(part&&!part.match(hostnamePartPattern)){for(var newpart="",j=0,k=part.length;j<k;j++)newpart+=part.charCodeAt(j)>127?"x":part[j];if(!newpart.match(hostnamePartPattern)){var validParts=hostparts.slice(0,i),notHost=hostparts.slice(i+1),bit=part.match(hostnamePartStart);bit&&(validParts.push(bit[1]),notHost.unshift(bit[2])),notHost.length&&(rest="/"+notHost.join(".")+rest),this.hostname=validParts.join(".");break}}}if(this.hostname.length>hostnameMaxLen?this.hostname="":this.hostname=this.hostname.toLowerCase(),!ipv6Hostname){for(var domainArray=this.hostname.split("."),newOut=[],i=0;i<domainArray.length;++i){var s=domainArray[i];newOut.push(s.match(/[^A-Za-z0-9_-]/)?"xn--"+punycode.encode(s):s)}this.hostname=newOut.join(".")}var p=this.port?":"+this.port:"",h=this.hostname||"";this.host=h+p,this.href+=this.host,ipv6Hostname&&(this.hostname=this.hostname.substr(1,this.hostname.length-2),"/"!==rest[0]&&(rest="/"+rest))}if(!unsafeProtocol[lowerProto])for(var i=0,l=autoEscape.length;i<l;i++){var ae=autoEscape[i],esc=encodeURIComponent(ae);esc===ae&&(esc=escape(ae)),rest=rest.split(ae).join(esc)}var hash=rest.indexOf("#");hash!==-1&&(this.hash=rest.substr(hash),rest=rest.slice(0,hash));var qm=rest.indexOf("?");if(qm!==-1?(this.search=rest.substr(qm),this.query=rest.substr(qm+1),parseQueryString&&(this.query=querystring.parse(this.query)),rest=rest.slice(0,qm)):parseQueryString&&(this.search="",this.query={}),rest&&(this.pathname=rest),slashedProtocol[lowerProto]&&this.hostname&&!this.pathname&&(this.pathname="/"),this.pathname||this.search){var p=this.pathname||"",s=this.search||"";this.path=p+s}return this.href=this.format(),this},Url.prototype.format=function(){var auth=this.auth||"";auth&&(auth=encodeURIComponent(auth),auth=auth.replace(/%3A/i,":"),auth+="@");var protocol=this.protocol||"",pathname=this.pathname||"",hash=this.hash||"",host=!1,query="";this.host?host=auth+this.host:this.hostname&&(host=auth+(this.hostname.indexOf(":")===-1?this.hostname:"["+this.hostname+"]"),this.port&&(host+=":"+this.port)),this.query&&isObject(this.query)&&Object.keys(this.query).length&&(query=querystring.stringify(this.query));var search=this.search||query&&"?"+query||"";return protocol&&":"!==protocol.substr(-1)&&(protocol+=":"),this.slashes||(!protocol||slashedProtocol[protocol])&&host!==!1?(host="//"+(host||""),pathname&&"/"!==pathname.charAt(0)&&(pathname="/"+pathname)):host||(host=""),hash&&"#"!==hash.charAt(0)&&(hash="#"+hash),search&&"?"!==search.charAt(0)&&(search="?"+search),pathname=pathname.replace(/[?#]/g,function(match){return encodeURIComponent(match)}),search=search.replace("#","%23"),protocol+host+pathname+search+hash},Url.prototype.resolve=function(relative){return this.resolveObject(urlParse(relative,!1,!0)).format()},Url.prototype.resolveObject=function(relative){if(isString(relative)){var rel=new Url;rel.parse(relative,!1,!0),relative=rel}var result=new Url;if(Object.keys(this).forEach(function(k){result[k]=this[k]},this),result.hash=relative.hash,""===relative.href)return result.href=result.format(),result;if(relative.slashes&&!relative.protocol)return Object.keys(relative).forEach(function(k){"protocol"!==k&&(result[k]=relative[k])}),slashedProtocol[result.protocol]&&result.hostname&&!result.pathname&&(result.path=result.pathname="/"),result.href=result.format(),result;if(relative.protocol&&relative.protocol!==result.protocol){if(!slashedProtocol[relative.protocol])return Object.keys(relative).forEach(function(k){result[k]=relative[k]}),result.href=result.format(),result;if(result.protocol=relative.protocol,relative.host||hostlessProtocol[relative.protocol])result.pathname=relative.pathname;else{for(var relPath=(relative.pathname||"").split("/");relPath.length&&!(relative.host=relPath.shift()););relative.host||(relative.host=""),relative.hostname||(relative.hostname=""),""!==relPath[0]&&relPath.unshift(""),relPath.length<2&&relPath.unshift(""),result.pathname=relPath.join("/")}if(result.search=relative.search,result.query=relative.query,result.host=relative.host||"",result.auth=relative.auth,result.hostname=relative.hostname||relative.host,result.port=relative.port,result.pathname||result.search){var p=result.pathname||"",s=result.search||"";result.path=p+s}return result.slashes=result.slashes||relative.slashes,result.href=result.format(),result}var isSourceAbs=result.pathname&&"/"===result.pathname.charAt(0),isRelAbs=relative.host||relative.pathname&&"/"===relative.pathname.charAt(0),mustEndAbs=isRelAbs||isSourceAbs||result.host&&relative.pathname,removeAllDots=mustEndAbs,srcPath=result.pathname&&result.pathname.split("/")||[],relPath=relative.pathname&&relative.pathname.split("/")||[],psychotic=result.protocol&&!slashedProtocol[result.protocol];if(psychotic&&(result.hostname="",result.port=null,result.host&&(""===srcPath[0]?srcPath[0]=result.host:srcPath.unshift(result.host)),result.host="",relative.protocol&&(relative.hostname=null,relative.port=null,relative.host&&(""===relPath[0]?relPath[0]=relative.host:relPath.unshift(relative.host)),relative.host=null),mustEndAbs=mustEndAbs&&(""===relPath[0]||""===srcPath[0])),isRelAbs)result.host=relative.host||""===relative.host?relative.host:result.host,result.hostname=relative.hostname||""===relative.hostname?relative.hostname:result.hostname,result.search=relative.search,result.query=relative.query,srcPath=relPath;else if(relPath.length)srcPath||(srcPath=[]),srcPath.pop(),srcPath=srcPath.concat(relPath),result.search=relative.search,result.query=relative.query;else if(!isNullOrUndefined(relative.search)){if(psychotic){result.hostname=result.host=srcPath.shift();var authInHost=!!(result.host&&result.host.indexOf("@")>0)&&result.host.split("@");authInHost&&(result.auth=authInHost.shift(),result.host=result.hostname=authInHost.shift())}return result.search=relative.search,result.query=relative.query,isNull(result.pathname)&&isNull(result.search)||(result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")),result.href=result.format(),result}if(!srcPath.length)return result.pathname=null,result.search?result.path="/"+result.search:result.path=null,result.href=result.format(),result;for(var last=srcPath.slice(-1)[0],hasTrailingSlash=(result.host||relative.host)&&("."===last||".."===last)||""===last,up=0,i=srcPath.length;i>=0;i--)last=srcPath[i],"."==last?srcPath.splice(i,1):".."===last?(srcPath.splice(i,1),up++):up&&(srcPath.splice(i,1),up--);if(!mustEndAbs&&!removeAllDots)for(;up--;up)srcPath.unshift("..");!mustEndAbs||""===srcPath[0]||srcPath[0]&&"/"===srcPath[0].charAt(0)||srcPath.unshift(""),hasTrailingSlash&&"/"!==srcPath.join("/").substr(-1)&&srcPath.push("");var isAbsolute=""===srcPath[0]||srcPath[0]&&"/"===srcPath[0].charAt(0);if(psychotic){result.hostname=result.host=isAbsolute?"":srcPath.length?srcPath.shift():"";var authInHost=!!(result.host&&result.host.indexOf("@")>0)&&result.host.split("@");authInHost&&(result.auth=authInHost.shift(),result.host=result.hostname=authInHost.shift())}return mustEndAbs=mustEndAbs||result.host&&srcPath.length,mustEndAbs&&!isAbsolute&&srcPath.unshift(""),srcPath.length?result.pathname=srcPath.join("/"):(result.pathname=null,result.path=null),isNull(result.pathname)&&isNull(result.search)||(result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")),result.auth=relative.auth||result.auth,result.slashes=result.slashes||relative.slashes,result.href=result.format(),result},Url.prototype.parseHost=function(){var host=this.host,port=portPattern.exec(host);port&&(port=port[0],":"!==port&&(this.port=port.substr(1)),host=host.substr(0,host.length-port.length)),host&&(this.hostname=host)}},function(module,exports,__webpack_require__){"use strict";var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},yaml=__webpack_require__(70),json=__webpack_require__(50),stringify=__webpack_require__(62),impl=__webpack_require__(27),util=__webpack_require__(31),universes=__webpack_require__(22),def=__webpack_require__(36),universeHelpers=__webpack_require__(14),_=__webpack_require__(61),LowLevelProxyNode=function(){function LowLevelProxyNode(_parent,_transformer,ramlVersion){this._parent=_parent,this._transformer=_transformer,this.ramlVersion=ramlVersion}return LowLevelProxyNode.prototype.hasInnerIncludeError=function(){return this._originalNode.hasInnerIncludeError()},LowLevelProxyNode.prototype.keyKind=function(){return this._originalNode.keyKind()},LowLevelProxyNode.prototype.primaryNode=function(){return null},LowLevelProxyNode.prototype.isAnnotatedScalar=function(){return this._originalNode.isAnnotatedScalar()},LowLevelProxyNode.prototype.actual=function(){return this._originalNode?this._originalNode.actual():this},LowLevelProxyNode.prototype.transformer=function(){return this._transformer},LowLevelProxyNode.prototype.originalNode=function(){return this._originalNode},LowLevelProxyNode.prototype.start=function(){return this._originalNode.start()},LowLevelProxyNode.prototype.end=function(){return this._originalNode.end()},LowLevelProxyNode.prototype.value=function(toString){throw new Error("The method must be overridden")},LowLevelProxyNode.prototype.includeErrors=function(){return this._originalNode.includeErrors()},LowLevelProxyNode.prototype.includePath=function(){return this._originalNode.includePath()},LowLevelProxyNode.prototype.includeReference=function(){return this._originalNode.includeReference()},LowLevelProxyNode.prototype.setKeyOverride=function(_key){this._keyOverride=_key},LowLevelProxyNode.prototype.setValueOverride=function(value){this._valueOverride=value},LowLevelProxyNode.prototype.key=function(){return this._keyOverride?this._keyOverride:this._originalNode.key()},LowLevelProxyNode.prototype.optional=function(){return this.originalNode().optional()},LowLevelProxyNode.prototype.children=function(){throw new Error("The method must be overridden")},LowLevelProxyNode.prototype.parent=function(){return this._parent;
},LowLevelProxyNode.prototype.unit=function(){return this._originalNode.unit()},LowLevelProxyNode.prototype.includeBaseUnit=function(){return this._originalNode.unit()},LowLevelProxyNode.prototype.anchorId=function(){return this._originalNode.anchorId()},LowLevelProxyNode.prototype.errors=function(){return this._originalNode.errors()},LowLevelProxyNode.prototype.anchoredFrom=function(){return this._originalNode.anchoredFrom()},LowLevelProxyNode.prototype.includedFrom=function(){return this._originalNode.includedFrom()},LowLevelProxyNode.prototype.visit=function(v){v(this)&&this.children().forEach(function(x){return x.visit(v)})},LowLevelProxyNode.prototype.addChild=function(n){},LowLevelProxyNode.prototype.execute=function(cmd){},LowLevelProxyNode.prototype.dump=function(){return null},LowLevelProxyNode.prototype.dumpToObject=function(){var serialized=json.serialize(this);if(this.kind()==yaml.Kind.MAPPING){var obj={};return obj[this.key()]=serialized,obj}return serialized},LowLevelProxyNode.prototype.keyStart=function(){return this._originalNode.keyStart()},LowLevelProxyNode.prototype.keyEnd=function(){return this._originalNode.keyEnd()},LowLevelProxyNode.prototype.valueStart=function(){return this._originalNode.valueStart()},LowLevelProxyNode.prototype.valueEnd=function(){return this._originalNode.valueEnd()},LowLevelProxyNode.prototype.isValueLocal=function(){return this._originalNode.isValueLocal()},LowLevelProxyNode.prototype.kind=function(){return this._originalNode.kind()},LowLevelProxyNode.prototype.valueKind=function(){return this._originalNode.valueKind()},LowLevelProxyNode.prototype.show=function(msg){this._originalNode.show(msg)},LowLevelProxyNode.prototype.setHighLevelParseResult=function(highLevelParseResult){this._highLevelParseResult=highLevelParseResult},LowLevelProxyNode.prototype.highLevelParseResult=function(){return this._highLevelParseResult},LowLevelProxyNode.prototype.setHighLevelNode=function(highLevel){this._highLevelNode=highLevel},LowLevelProxyNode.prototype.highLevelNode=function(){return this._highLevelNode?this._highLevelNode:this._originalNode.highLevelNode()},LowLevelProxyNode.prototype.text=function(unitText){throw new Error("not implemented")},LowLevelProxyNode.prototype.copy=function(){throw new Error("not implemented")},LowLevelProxyNode.prototype.markup=function(json){throw new Error("not implemented")},LowLevelProxyNode.prototype.nodeDefinition=function(){return impl.getDefinitionForLowLevelNode(this)},LowLevelProxyNode.prototype.includesContents=function(){return this._originalNode.includesContents()},LowLevelProxyNode}();exports.LowLevelProxyNode=LowLevelProxyNode;var LowLevelCompositeNode=function(_super){function LowLevelCompositeNode(node,parent,transformer,ramlVersion,isPrimary){void 0===isPrimary&&(isPrimary=!0),_super.call(this,parent,transformer,ramlVersion),this.isPrimary=isPrimary,this._adoptedNodes=[],this._preserveAnnotations=!1;var originalParent=this.parent()?this.parent().originalNode():null;node instanceof LowLevelValueTransformingNode?this._originalNode=node:this._originalNode=new LowLevelValueTransformingNode(node,originalParent,transformer,this.ramlVersion),this._adoptedNodes.push(this._originalNode)}return __extends(LowLevelCompositeNode,_super),LowLevelCompositeNode.prototype.adoptedNodes=function(){return this._adoptedNodes},LowLevelCompositeNode.prototype.primaryNode=function(){return this.isPrimary?this._originalNode:null},LowLevelCompositeNode.prototype.parent=function(){return this._parent},LowLevelCompositeNode.prototype.adopt=function(node,transformer){transformer||(transformer=this._transformer);var originalParent=this.parent()?this.parent().originalNode():null,tNode=new LowLevelValueTransformingNode(node,originalParent,transformer,this.ramlVersion);this._adoptedNodes.push(tNode),this._children&&this._children.forEach(function(x){return x._parent=null}),this._children=null,this.highLevelNode()&&this.highLevelNode().resetChildren()},LowLevelCompositeNode.prototype.value=function(toString){if(this._valueOverride)return this._valueOverride;var val,valuableNodes=this._adoptedNodes.filter(function(x){return null!=x.value()});return val=valuableNodes.length>0?valuableNodes[0].value(toString):this._originalNode.value(toString),val instanceof LowLevelValueTransformingNode&&(this._valueOverride=val),val},LowLevelCompositeNode.prototype.children=function(){var _this=this;if(this._children)return this._children;for(var result=[],canBeMap=!1,canBeSeq=!1,_i=0,_a=this._adoptedNodes;_i<_a.length;_i++){var x=_a[_i],adoptedNodeChildren=x.children();adoptedNodeChildren&&adoptedNodeChildren.length>0&&(canBeSeq=!0,adoptedNodeChildren[0].key()&&this.originalNode().valueKind()!=yaml.Kind.SEQ&&(canBeMap=!0))}if(canBeMap)result=this.collectChildrenWithKeys();else if(canBeSeq){result=this.collectChildrenWithKeys();var map={};this._adoptedNodes.forEach(function(x){return x.children().filter(function(y){return!y.key()}).forEach(function(y){var isPrimary=x==_this.primaryNode(),key=_this.buildKey(y);if(isPrimary||!map[key]){map[key]=!0;var transformer=x.transformer()?x.transformer():_this.transformer(),ch=y instanceof LowLevelValueTransformingNode?y.originalNode():y;result.push(new LowLevelCompositeNode(ch,_this,transformer,_this.ramlVersion,isPrimary))}})})}else result=[];return this._children=result,result},LowLevelCompositeNode.prototype.buildKey=function(y){var obj=json.serialize(y),def=this.nodeDefinition();if(def&&(def.key()==universes.Universe08.TraitRef||def.key()==universes.Universe08.ResourceTypeRef||def.key()==universes.Universe10.TraitRef||def.key()==universes.Universe10.ResourceTypeRef)&&"object"==typeof obj){var keys=Object.keys(obj);keys.length>0&&(obj=keys[0])}return stringify(obj)},LowLevelCompositeNode.prototype.collectChildrenWithKeys=function(){for(var _this=this,result=[],m={},_i=0,_a=this._adoptedNodes;_i<_a.length;_i++)for(var x=_a[_i],isPrimary=x==this.primaryNode(),_b=0,_c=x.children();_b<_c.length;_b++){var y=_c[_b],key=y.originalNode().key();if(key&&x.transformer()){var isAnnotation=null!=key&&(this._preserveAnnotations||this.isResource())&&util.stringStartsWith(key,"(")&&util.stringEndsWith(key,")");isAnnotation||(key=x.transformer().transform(key).value)}if(!this.skipKey(key,isPrimary)&&key){var arr=m[key];arr||(arr=[],m[key]=arr),arr.push({node:y.originalNode(),transformer:x.transformer(),isPrimary:isPrimary})}}var ramlVersion=this.unit().highLevel().root().definition().universe().version(),isResource=this.key()&&"/"==this.key()[0],methodType=def.getUniverse("RAML10").type(universes.Universe10.Method.name),options=methodType.property(universes.Universe10.Method.properties.method.name).enumOptions();return Object.keys(m).forEach(function(key){var arr=m[key],allOptional=!0,hasPrimaryChildren=!1,isMethod=options.indexOf(key)>=0;if(arr.forEach(function(x){var isOpt=x.node.optional()&&("RAML10"!=ramlVersion||isResource&&isMethod);allOptional=allOptional&&isOpt,hasPrimaryChildren=hasPrimaryChildren||x.isPrimary}),hasPrimaryChildren){var primaryChildren=[];arr.filter(function(x){return x.isPrimary}).forEach(function(x){var tr=x.transformer?x.transformer:_this.transformer();primaryChildren.push(new LowLevelCompositeNode(x.node,_this,tr,_this.ramlVersion,(!0)))});var primaryChild=primaryChildren[0];arr.filter(function(x){return!x.isPrimary}).forEach(function(x){primaryChild.adopt(x.node,x.transformer)}),primaryChildren.forEach(function(x){return result.push(x)})}else if(!allOptional){for(var tr=arr[0].transformer?arr[0].transformer:_this.transformer(),primaryChild=new LowLevelCompositeNode(arr[0].node,_this,tr,_this.ramlVersion,(!1)),i=1;i<arr.length;i++)primaryChild.adopt(arr[i].node,arr[i].transformer);result.push(primaryChild)}}),result},LowLevelCompositeNode.prototype.isResource=function(){return this.highLevelNode()&&universeHelpers.isResourceType(this.highLevelNode().definition())},LowLevelCompositeNode.prototype.skipKey=function(key,isPrimary){if(isPrimary)return!1;if("RAML08"!=this.ramlVersion)return!1;universes.Universe08.Method,universes.Universe08.Resource;return!1},LowLevelCompositeNode.prototype.valueKind=function(){if(this._originalNode.kind()!=yaml.Kind.MAPPING)return null;for(var i=0;i<this._adoptedNodes.length;i++){var node=this._adoptedNodes[i],yamlNode=node.originalNode().actual();if(yamlNode&&null!=yamlNode.value)return node.valueKind()}return null},LowLevelCompositeNode.prototype.includePath=function(){for(var i=0;i<this._adoptedNodes.length;i++){var node=this._adoptedNodes[i],includePath=node.includePath();if(null!=includePath)return includePath}return null},LowLevelCompositeNode.prototype.includeBaseUnit=function(){for(var i=0;i<this._adoptedNodes.length;i++){var node=this._adoptedNodes[i],includePath=node.includePath();if(null!=includePath)return node.unit()}return _super.prototype.includeBaseUnit.call(this)},LowLevelCompositeNode.prototype.includeReference=function(){for(var i=0;i<this._adoptedNodes.length;i++){var node=this._adoptedNodes[i];if(null!=node.value())return node.includeReference()}return null},LowLevelCompositeNode.prototype.optional=function(){return _.all(this._adoptedNodes,function(x){return x.optional()})},LowLevelCompositeNode.prototype.replaceChild=function(oldNode,newNode,isPrimary,transformer){void 0===isPrimary&&(isPrimary=!1),void 0===transformer&&(transformer=null),this._children||(this._children=[]);var newCNode=new LowLevelCompositeNode(newNode,this,null,this.ramlVersion);if(null==oldNode)return this._children.push(newCNode),newCNode;var ind=this._children.indexOf(oldNode);return ind>=0?this._children[ind]=newCNode:this._children.push(newCNode),newCNode},LowLevelCompositeNode.prototype.removeChild=function(oldNode){if(this._children&&null!=oldNode){var ind=this._children.indexOf(oldNode);if(ind>=0){for(var i=ind;i<this._children.length-1;i++)this._children[i]=this._children[i+1];this._children.pop()}}},LowLevelCompositeNode.prototype.setChildren=function(nodes){var _this=this;return null==nodes?void(this._children=null):void(this._children=nodes.map(function(x){return x instanceof LowLevelCompositeNode?x:new LowLevelCompositeNode(x,_this,null,_this.ramlVersion)}))},LowLevelCompositeNode.prototype.preserveAnnotations=function(){if(!this._preserveAnnotations){if(void 0===this.isInsideResource&&(this.isInsideResource=!1,!this.isResource()))for(var parent=this._parent;parent;){if(parent.isResource()){this.isInsideResource=!0;break}parent=parent.parent()}this.isInsideResource&&(this._preserveAnnotations=!0,this._children=null)}},LowLevelCompositeNode.prototype.filterChildren=function(){this.children();var map={},filtered=[];this._children.forEach(function(x){if(null!=x.key())return void filtered.push(x);var key=JSON.stringify(json.serialize(x));map[key]||(map[key]=!0,filtered.push(x))}),this._children=filtered},LowLevelCompositeNode}(LowLevelProxyNode);exports.LowLevelCompositeNode=LowLevelCompositeNode;var LowLevelValueTransformingNode=function(_super){function LowLevelValueTransformingNode(node,parent,transformer,ramlVersion){_super.call(this,parent,transformer,ramlVersion),this._originalNode=node}return __extends(LowLevelValueTransformingNode,_super),LowLevelValueTransformingNode.prototype.value=function(toString){var val=this.originalNode().value(toString),t=this.transformer();if(t){var transformationResult=t.transform(val,toString);val=transformationResult.value}return val&&"object"==typeof val?new LowLevelValueTransformingNode(val,this._parent,this._transformer,this.ramlVersion):val},LowLevelValueTransformingNode.prototype.children=function(){var _this=this,childNodes=null,originalNode=this.originalNode();if(null!=this._transformer){var substitution=this._transformer.children(originalNode);null!=substitution&&(childNodes=substitution)}return null==childNodes&&(childNodes=originalNode.children()),childNodes.map(function(x){return new LowLevelValueTransformingNode(x,_this,_this._transformer,_this.ramlVersion)})},LowLevelValueTransformingNode.prototype.valueKind=function(){var kind=this._transformer&&this._transformer.valueKind(this.originalNode());return null!=kind?kind:_super.prototype.valueKind.call(this)},LowLevelValueTransformingNode.prototype.parent=function(){return this._parent},LowLevelValueTransformingNode.prototype.key=function(){var key=_super.prototype.key.call(this);return null!=this.transformer()?this.transformer().transform(key).value:key},LowLevelValueTransformingNode}(LowLevelProxyNode);exports.LowLevelValueTransformingNode=LowLevelValueTransformingNode},function(module,exports,__webpack_require__){"use strict";function findLastAttributeIndex(n){for(var last=-1,children=n.lowLevel().children(),i=0;i<children.length;i++){var node=children[i];if(node.isMapping()){var name=node.asMapping().key.value,property=n.definition().property(name);property&&(property.isFromParentValue()||property.range().hasValueTypeInHierarchy())&&(last=i)}}return last}function findInsertionPointLowLevel(node,llnode,property,attr){var insertionPoint=null,embed=property&&property.getAdapter(services.RAMLPropertyService).isEmbedMap();if(embed&&_.find(node.lowLevel().children(),function(x){return x.key()==property.nameId()})&&(embed=!1),attr||embed){var last=findLastAttribute(node);insertionPoint=last?last:jsyaml.InsertionPoint.atStart()}return insertionPoint}function findInsertionPoint(where,node){where.isStub()||where.clearChildrenCache();var ch=where.children(),embed=node.property()&&node.property().getAdapter(services.RAMLPropertyService).isEmbedMap();embed&&_.find(where.lowLevel().children(),function(x){return x.key()==node.property().nameId()})&&(embed=!1);if(!node.isAttr()&&!embed||universeHelpers.isMethodType(where.definition())&&node.property&&universeHelpers.isIsProperty(node.property())){var pname=node.property().nameId(),cls=where.definition(),pindex=(cls.allProperties(),cls.propertyIndex(pname));if(pindex<0)return null;for(var llchilds=where.lowLevel().children(),i=0;i<llchilds.length;i++){var llch=llchilds[i];if(llch.isMapping()){var cpnme=llch.asMapping().key.value,pi=cls.propertyIndex(cpnme);if(pi>pindex){var lastok=i-1;return lastok<0?null:(console.log("insert to node: "+lastok),llchilds[lastok])}}}return null}for(var toRet=null,i=0;i<ch.length&&ch[i].isAttr();i++)toRet=ch[i].lowLevel();return null==toRet&&(toRet=where.lowLevel()),toRet}function removeNodeFrom(source,node){if(source.isStub()){if(node instanceof hlimpl.ASTNodeImpl){var cm=node;if(cm.isInEdit)return}if(!source._children)return;return void(source._children=source._children.filter(function(x){return x!=node}))}var command=new ll.CompositeCommand;if(node instanceof hlimpl.ASTNodeImpl){var aNode=node;aNode.property().getAdapter(services.RAMLPropertyService).isMerged()?command.commands.push(ll.removeNode(source.lowLevel(),aNode.lowLevel())):1==source.elementsOfKind(aNode.property().nameId()).length?command.commands.push(ll.removeNode(source.lowLevel(),aNode.lowLevel().parent().parent())):command.commands.push(ll.removeNode(source.lowLevel(),aNode.lowLevel()))}else command.commands.push(ll.removeNode(source.lowLevel(),node.lowLevel()));source.lowLevel().execute(command)}function initEmptyRAMLFile(node){var command=(node.lowLevel().root(),new ll.CompositeCommand),newroot=jsyaml.createMap([]);command.commands.push(ll.initRamlFile(node.lowLevel(),newroot)),node.lowLevel().execute(command);var root=node.root();root._node=newroot,root.clearChildrenCache()}function setValue(node,value){if(value!=node.value()){var c=new ll.CompositeCommand;if("string"==typeof value){var val=value;node.property().isFromParentKey()||node.property().isAnnotation()?(node.property().isAnnotation()&&(val="("+val+")"),c.commands.push(ll.setKey(node.lowLevel(),val))):val&&0!=val.length||node.isEmbedded()?(val||(val=""),c.commands.push(ll.setAttr(node.lowLevel(),val))):(c.commands.push(ll.removeNode(node.lowLevel().parent(),node.lowLevel())),node.parent().clearChildrenCache())}else{if(node.property().isFromParentKey())throw new Error("couldn't set structured value to a key: "+node.property().nameId());var sval=value;c.commands.push(ll.setAttrStructured(node.lowLevel(),sval))}node.lowLevel().execute(c)}}function addStringValue(attr,value){var sc=jsyaml.createScalar(value),target=attr.lowLevel();target.isScalar()?target=target.parent():target.isMapping();var command=new ll.CompositeCommand;command.commands.push(ll.insertNode(target,sc,null,!0)),attr.lowLevel().execute(command),attr.parent().clearChildrenCache()}function addStructuredValue(attr,sv){var target=attr.lowLevel();if(target.isScalar())target=target.parent();else if(target.isMapping()){attr.lowLevel()}var command=new ll.CompositeCommand;command.commands.push(ll.insertNode(target,sv.lowLevel(),null,!0)),attr.lowLevel().execute(command),attr.parent().clearChildrenCache()}function removeAttr(attr){var llparent=attr.lowLevel().parent();if(!attr.property().isMultiValue()&&attr.isEmbedded())attr.setValue("");else{var command=new ll.CompositeCommand;command.commands.push(ll.removeNode(llparent,attr.lowLevel())),attr.lowLevel().execute(command),attr.parent().clearChildrenCache()}}function setValues(attr,values){if(!attr.property().isMultiValue())throw new Error("setValue(string[]) only apply to multi-values properties");var node=attr.parent();if(node&&isTypeShortcut(node)){var command=new ll.CompositeCommand;return command.commands.push(ll.setAttr(node.lowLevel(),values[0])),void node.lowLevel().execute(command)}if(attr.isEmpty());else{var attrs=(node.lowLevel(),node.attributes(attr.name()));attrs.forEach(function(attr){return attr.remove()})}1==values.length&&attr.property().isDescriminator()?node.attrOrCreate(attr.name()).setValue(values[0]):values.forEach(function(val){return node.attrOrCreate(attr.name()).addValue(val)})}function setKey(node,value){if(value!=node.name()){var c=new ll.CompositeCommand;c.commands.push(ll.setKey(node.lowLevel(),value)),node.lowLevel().execute(c)}}function isTypeShortcut(node){return!!(node.definition()&&node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&node.lowLevel()&&node.lowLevel().valueKind()===yaml.Kind.SCALAR)}function createAttr(node,n,v){var mapping=jsyaml.createMapping(n,v);if(node.definition()&&node.definition().isAssignableFrom(universes.Universe10.TypeDeclaration.name)&&node.lowLevel()&&(node.lowLevel().valueKind()===yaml.Kind.SCALAR||!node.lowLevel()._node.value)){var typePropertyName=n,typeMapping=jsyaml.createMapping(typePropertyName,node.lowLevel().value()),command=new ll.CompositeCommand;command.commands.push(ll.setAttr(node.lowLevel(),"")),node.lowLevel().execute(command),command=new ll.CompositeCommand;var insertionPoint=findInsertionPointLowLevel(node,typeMapping,node.definition().property(typePropertyName),!0);command.commands.push(ll.insertNode(node.lowLevel(),typeMapping,insertionPoint)),node.lowLevel().execute(command),node.resetChildren();var attribute=node.attr(typePropertyName)&&node.attr(typePropertyName).lowLevel();if(attribute)return command=new ll.CompositeCommand,command.commands.push(ll.setAttr(attribute,v)),attribute.execute(command),void node.clearChildrenCache()}if(node.isStub()){var insertionIndex=findLastAttributeIndex(node);node.lowLevel().addChild(mapping,insertionIndex+1)}else{node.isEmptyRamlFile()&&node.initRamlFile();var command=new ll.CompositeCommand,insertionPoint=findInsertionPointLowLevel(node,mapping,node.definition().property(n),!0);command.commands.push(ll.insertNode(node.lowLevel(),mapping,insertionPoint)),node.lowLevel().execute(command)}node.clearChildrenCache()}function findLastAttribute(node){var childs=node.lowLevel().children(),index=findLastAttributeIndex(node);return index<0?null:childs[index]}function addToNode(target,node){!target.isStub()&&target.isEmptyRamlFile()&&target.initRamlFile();var llnode=node.lowLevel();if(target._children||(target._children=[]),!node.property()){var an=node,allProps=target.definition().allProperties(),cp=null;if(allProps.forEach(function(x){var r=x.range();r==an.definition()&&(cp=x);var isOk=_.find(an.definition().allSuperTypes(),function(x){return x==r});isOk&&(cp=x)}),!cp)throw new Error("Unable to find correct child");an.patchProp(cp)}var insertionPoint=findInsertionPoint(target,node),command=new ll.CompositeCommand,insertionTarget=null;if(node.property().getAdapter(services.RAMLPropertyService).isMerged()||node.property().range().hasValueTypeInHierarchy())command.commands.push(ll.insertNode(target.lowLevel(),node.lowLevel(),insertionPoint)),insertionTarget=target.lowLevel();else{var name=node.property().nameId(),target2=target.lowLevel(),found=target.lowLevel().find(name);if(insertionTarget=found,found){var isEmptyTypes=null===found.value()&&found.key&&found.key()===universes.Universe10.Api.properties.types.name,needSeq=!isEmptyTypes&&node.property().getAdapter(services.RAMLPropertyService).isEmbedMap();command.commands.push(ll.insertNode(found,node.lowLevel(),insertionPoint,needSeq))}else{var nn=null;if(node.property().getAdapter(services.RAMLPropertyService).isEmbedMap()){var v10="RAML10"==target.definition().universe().version();nn=llnode.isValueMap()&&v10?jsyaml.createMapNode(name):jsyaml.createSeqNode(name),nn.addChild(node.lowLevel())}else nn=jsyaml.createNode(name),nn.addChild(node.lowLevel());command.commands.push(ll.insertNode(target2,nn,insertionPoint)),insertionTarget=target2}}if(target.isStub()){var insertionIndex=findLastAttributeIndex(target);return insertionIndex<0?target._children.push(node):target._children.splice(insertionIndex,0,node),void command.commands.forEach(function(x){return insertionTarget.addChild(x.value)})}target.lowLevel().execute(command),target._children.push(node),node.setParent(target)}var jsyaml=__webpack_require__(27),defs=__webpack_require__(36),ll=__webpack_require__(11),_=__webpack_require__(61),yaml=__webpack_require__(70),hlimpl=__webpack_require__(16),universes=__webpack_require__(22),universeHelpers=__webpack_require__(14),services=defs;exports.removeNodeFrom=removeNodeFrom,exports.initEmptyRAMLFile=initEmptyRAMLFile,exports.setValue=setValue,exports.addStringValue=addStringValue,exports.addStructuredValue=addStructuredValue,exports.removeAttr=removeAttr,exports.setValues=setValues,exports.setKey=setKey,exports.createAttr=createAttr,exports.addToNode=addToNode},function(module,exports,__webpack_require__){"use strict";function templateFields(node,d){var u=node.root().definition().universe(),key=node.lowLevel().key();if(key&&handleValue(key,d,null,!0,u),node.children().forEach(function(x){return templateFields(x,d)}),node instanceof hlimpl.ASTPropImpl){var prop=node,v=prop.value();if("string"==typeof v){var strV=v;handleValue(strV,d,prop,!1,u)}else node.lowLevel().visit(function(x){if(x.value()){var strV=x.value()+"";handleValue(strV,d,prop,!0,u)}return!0})}else if(node instanceof hlimpl.BasicASTNode){var v=node.lowLevel().value();if("string"==typeof v){var strV=v;handleValue(strV,d,null,!1,u)}else node.lowLevel().visit(function(x){if(x.value()){var strV=x.value()+"";handleValue(strV,d,null,!0,u)}return!0})}}function fillParamPaths(node,paramPaths,path){void 0===path&&(path=[]),node.optional()&&(path=path.concat("/"));var v=node.value();if("string"==typeof v)for(var strV=v,__ret=extractUsedParamNames(strV),parameterUsages=__ret.parameterUsages,_i=0,parameterUsages_2=parameterUsages;_i<parameterUsages_2.length;_i++){var pu=parameterUsages_2[_i],paths=paramPaths[pu];null==paths&&(paths=[],paramPaths[pu]=paths),paths.push(path)}else for(var _a=0,_b=node.children();_a<_b.length;_a++){var ch=_b[_a];fillParamPaths(ch,paramPaths,path.concat(ch.key()))}}function fillTemplateType(result,node){var usages={},paramPaths={};templateFields(node,usages),fillParamPaths(node.lowLevel(),paramPaths);for(var _i=0,_a=Object.keys(paramPaths);_i<_a.length;_i++){var pu=_a[_i];paramPaths[pu]=_.unique(paramPaths[pu])}result.getAdapter(services.RAMLService).setInlinedTemplates(!0),Object.keys(usages).forEach(function(x){var propSource=null;usages[x].length>0&&(propSource=usages[x][0].attr);var prop=new defs.UserDefinedProp(x,propSource);prop.withDomain(result);var paths=paramPaths[x];prop.getAdapter(services.RAMLPropertyService).putMeta("templatePaths",paths);var defaultType;if("RAML10"==node.definition().universe().version()){var hasString=usages[x].filter(function(y){return universeHelpers.isStringTypeType(y.tp)}).length>0;defaultType=hasString?universes.Universe10.StringType.name:universes.Universe10.AnyType.name}else defaultType=universes.Universe08.StringType.name;var tp=_.unique(usages[x].map(function(x){return x.tp})).filter(function(x){return x&&x.nameId()!=defaultType});prop.withRange(1==tp.length?tp[0]:node.definition().universe().type(defaultType)),prop.withRequired(!0),1==tp.length&&"RAML10"==node.definition().universe().version()&&tp[0].key()==universes.Universe10.SchemaString&&prop.getAdapter(services.RAMLPropertyService).setTypeExpression(!0),prop.unmerge()});var keyProp=new defs.UserDefinedProp("____key",node);return keyProp.withDomain(result),keyProp.withKey(!0),keyProp.withFromParentKey(!0),keyProp.withRange(node.definition().universe().type(universes.Universe08.StringType.name)),result}function fillReferenceType(result,def){"RAML08"==def.universe().version()&&result.getAdapter(services.RAMLService).withAllowAny();var p=def.property(def.getAdapter(services.RAMLService).getReferenceIs());return p&&p.range().properties().forEach(function(x){var prop=new defs.Property(x.nameId());prop.unmerge(),prop.withDomain(result),prop.withRange(x.range()),prop.withMultiValue(x.isMultiValue())}),result}function typeFromNode(node){if(!node)return null;if(node.associatedType())return node.associatedType();var u=node.lowLevel().unit(),upath=u?u.path():"";ramlTypes.setPropertyConstructor(function(x){var propertySource=null,rs=node.elementsOfKind("properties").filter(function(y){return y.name()==x});rs&&(propertySource=rs[0]);var v=new defs.UserDefinedProp(x,propertySource);return v.unmerge(),v});try{var def=node.definition();if(node.property()&&node.property().nameId()==universes.Universe10.LibraryBase.properties.annotationTypes.name){var result=new AnnotationType(node.name(),node.definition().universe(),node,upath,""),st=getSimpleType(node);result._superTypes.push(st),0==node.elementsOfKind(universes.Universe10.ObjectTypeDeclaration.properties.properties.name).length&&result.getAdapter(services.RAMLService).withAllowAny();var extType=def.getAdapter(services.RAMLService).getExtendedType();return extType&&result._superTypes.push(extType),result}var result=new defs.UserDefinedClass(node.name(),node.definition().universe(),node,upath,"");if(node.setAssociatedType(result),def.getAdapter(services.RAMLService).isInlinedTemplates())return fillTemplateType(result,node);if(def.getAdapter(services.RAMLService).getReferenceIs())return fillReferenceType(result,def);var rs=getSimpleType(node);rs.getAdapter(services.RAMLService).setDeclaringNode(node),node.setAssociatedType(rs)}finally{ramlTypes.setPropertyConstructor(null)}return rs}function getSimpleType(node){return ramlTypes.toNominal(node.parsedType(),function(x){var m=node.definition().universe().type(x);if(!m){new defs.UserDefinedClass("",node.definition().universe(),node,"","")}return m})}function transform(u){return function(x){var m=u.type(x);if(!m){new defs.UserDefinedClass("",u,null,"","")}return m}}function convertType(root,t){var node=_.find(root.elementsOfKind("types"),function(x){return x.name()==t.name()});node&&ramlTypes.setPropertyConstructor(function(x){var rs=node.elementsOfKind("properties").filter(function(y){return y.name()==x}),propertySource=null;if(rs&&rs.length>0)propertySource=rs[0];else{var rs=node.elementsOfKind("facets").filter(function(y){return y.name()==x});rs&&rs.length>0&&(propertySource=rs[0])}var v=new defs.UserDefinedProp(x,propertySource);return v.unmerge(),v});var u=transform(root.definition().universe());return ramlTypes.toNominal(t,u)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},defs=__webpack_require__(36),ramlTypes=defs.rt,_=__webpack_require__(61),universes=__webpack_require__(22),hlimpl=__webpack_require__(16),services=defs,linter=__webpack_require__(25),universeHelpers=__webpack_require__(14);ramlTypes.setPropertyConstructor(function(x){var v=new defs.Property(x);return v.unmerge(),v});var extractUsedParamNames=function(strV){for(var parameterUsages=[],ps=0;;){var pos=strV.indexOf("<<",ps);if(pos==-1)break;var end=strV.indexOf(">>",pos),isFull=0==pos&&end==strV.length-2,parameterUsage=strV.substring(pos+2,end);ps=pos+2;var directiveIndex=parameterUsage.indexOf("|");directiveIndex!=-1&&(parameterUsage=parameterUsage.substring(0,directiveIndex)),parameterUsage=parameterUsage.trim(),parameterUsages.push(parameterUsage)}return{parameterUsages:parameterUsages,isFull:isFull}},handleValue=function(strV,d,prop,allwaysString,u){var __ret=extractUsedParamNames(strV),parameterUsages=__ret.parameterUsages,isFull=__ret.isFull,r=prop?prop.property().range():null;prop&&(prop.property().nameId()!=universes.Universe10.TypeDeclaration.properties.type.name&&prop.property().nameId()!=universes.Universe10.TypeDeclaration.properties.schema.name||prop.property().domain().key()==universes.Universe10.TypeDeclaration&&(r=u.type(universes.Universe10.SchemaString.name))),!isFull||allwaysString?r=u.type(universes.Universe10.StringType.name):null==r&&"RAML10"==u.version()&&(r=u.type(universes.Universe10.AnyType.name));for(var _i=0,parameterUsages_1=parameterUsages;_i<parameterUsages_1.length;_i++){var parameterUsage=parameterUsages_1[_i];if(null==linter.RESERVED_TEMPLATE_PARAMETERS[parameterUsage]){var q=d[parameterUsage];q?q.push({tp:r,attr:prop}):d[parameterUsage]=[{tp:r,attr:prop}]}}},AnnotationType=function(_super){function AnnotationType(){_super.apply(this,arguments)}return __extends(AnnotationType,_super),AnnotationType.prototype.allProperties=function(ps){void 0===ps&&(ps={});var rs=this.superTypes()[0].allProperties();if(1==rs.length&&"annotations"==rs[0].nameId()){var propertyNode=this.getAdapter(defs.RAMLService).getDeclaringNode(),property=new defs.UserDefinedProp("value",propertyNode);property.withDomain(this),property.withCanBeValue(),property.withRequired(!1);this.superTypes()[0];rs=[],property.withRange(property.node().asElement().definition().universe().type("string")),rs.push(property)}return rs},AnnotationType.prototype.isAnnotationType=function(){return!0},AnnotationType}(defs.UserDefinedClass);exports.typeFromNode=typeFromNode,exports.convertType=convertType},function(module,exports,__webpack_require__){"use strict";function isMultiLine(s){return s&&s.indexOf("\n")>=0}function isMultiLineValue(s){return isMultiLine(s)&&s.length>2&&"|"==s[0]&&("\n"==s[1]||"\r"==s[1]||"\n"==s[2])}function makeMutiLine(s,lev){var xbuf="";if(isMultiLine(s)){xbuf+="|\n";for(var lines=splitOnLines(s),i=0;i<lines.length;i++)xbuf+=indent(lev,lines[i])}else xbuf+=s;return xbuf}function fromMutiLine(s){if(!isMultiLineValue(s))return s;for(var res=null,lines=splitOnLines(s),i=1;i<lines.length;i++){var line=lines[i],str=line.substring(2);res?res+=str:res=str}return res}function trimStart(s){if(!s)return s;for(var pos=0;pos<s.length;){var ch=s[pos];if("\r"!=ch&&"\n"!=ch&&" "!=ch&&"\t"!=ch)break;pos++}return s.substring(pos,s.length)}function indent(lev,str){void 0===str&&(str="");for(var leading="",i=0;i<lev;i++)leading+="  ";return leading+str}function print(lev,str){void 0===str&&(str=""),console.log(indent(lev,str))}function replaceNewlines(s,rep){void 0===rep&&(rep=null);for(var res="",i=0;i<s.length;i++){var ch=s[i];"\r"==ch&&(ch=null==rep?"\\r":rep),"\n"==ch&&(ch=null==rep?"\\n":rep),res+=ch}return res}function trimEnd(s){for(var pos=s.length;pos>0;){var ch=s[pos-1];if(" "!=ch&&"\t"!=ch&&"\r"!=ch&&"\n"!=ch)break;pos--}return s.substring(0,pos)}function trim(s){return trimStart(trimEnd(s))}function splitOnLines(text){
var lines=text.match(/^.*((\r\n|\n|\r)|$)/gm);return lines}function startsWith(s,suffix){if(!s||!suffix||s.length<suffix.length)return!1;for(var i=0;i<suffix.length;i++)if(s[i]!=suffix[i])return!1;return!0}function endsWith(s,suffix){if(!s||!suffix||s.length<suffix.length)return!1;for(var i=0;i<suffix.length;i++)if(s[s.length-1-i]!=suffix[suffix.length-1-i])return!1;return!0}function capitalize(s){return s.charAt(0).toUpperCase()+s.slice(1)}exports.isMultiLine=isMultiLine,exports.isMultiLineValue=isMultiLineValue,exports.makeMutiLine=makeMutiLine,exports.fromMutiLine=fromMutiLine,exports.trimStart=trimStart,exports.indent=indent,exports.print=print,exports.replaceNewlines=replaceNewlines,exports.trimEnd=trimEnd,exports.trim=trim,exports.splitOnLines=splitOnLines,exports.startsWith=startsWith,exports.endsWith=endsWith,exports.capitalize=capitalize;var TextRange=function(){function TextRange(contents,start,end){this.contents=contents,this.start=start,this.end=end}return TextRange.prototype.text=function(){return this.contents.substring(this.start,this.end)},TextRange.prototype.startpos=function(){return this.start},TextRange.prototype.endpos=function(){return this.end},TextRange.prototype.len=function(){return this.end-this.start},TextRange.prototype.unitText=function(){return this.contents},TextRange.prototype.withStart=function(start){return new TextRange(this.contents,start,this.end)},TextRange.prototype.withEnd=function(end){return new TextRange(this.contents,this.start,end)},TextRange.prototype.sub=function(start,end){return this.contents.substring(start,end)},TextRange.prototype.trimStart=function(){for(var pos=this.start;pos<this.contents.length-1;){var ch=this.contents[pos];if(" "!=ch&&"\t"!=ch)break;pos++}return new TextRange(this.contents,pos,this.end)},TextRange.prototype.trimEnd=function(){for(var pos=this.end;pos>0;){var ch=this.contents[pos-1];if(" "!=ch&&"\t"!=ch)break;pos--}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendToStartOfLine=function(){for(var pos=this.start;pos>0;){var prevchar=this.contents[pos-1];if("\r"==prevchar||"\n"==prevchar)break;pos--}return new TextRange(this.contents,pos,this.end)},TextRange.prototype.extendAnyUntilNewLines=function(){var pos=this.end;if(pos>0){var last=this.contents[pos-1];if("\n"==last)return this}for(;pos<this.contents.length-1;){var nextchar=this.contents[pos];if("\r"==nextchar||"\n"==nextchar)break;pos++}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendSpacesUntilNewLines=function(){var pos=this.end;if(pos>0){var last=this.contents[pos-1];if("\n"==last)return this}for(;pos<this.contents.length-1;){var nextchar=this.contents[pos];if(" "!=nextchar||"\r"==nextchar||"\n"==nextchar)break;pos++}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendSpaces=function(){for(var pos=this.end;pos<this.contents.length-1;){var nextchar=this.contents[pos];if(" "!=nextchar)break;pos++}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendSpacesBack=function(){for(var pos=this.start;pos>0;){var nextchar=this.contents[pos-1];if(" "!=nextchar)break;pos--}return new TextRange(this.contents,pos,this.end)},TextRange.prototype.extendCharIfAny=function(ch){var pos=this.end;return pos<this.contents.length-1&&this.contents[pos]==ch&&pos++,new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendCharIfAnyBack=function(ch){var pos=this.start;return pos>0&&this.contents[pos-1]==ch&&pos--,new TextRange(this.contents,pos,this.end)},TextRange.prototype.extendToNewlines=function(){var pos=this.end;if(pos>0){var last=this.contents[pos-1];if("\n"==last)return this}for(;pos<this.contents.length-1;){var nextchar=this.contents[pos];if("\r"!=nextchar&&"\n"!=nextchar)break;pos++}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.extendUntilNewlinesBack=function(){for(var pos=this.start;pos>0;){var nextchar=this.contents[pos-1];if("\r"==nextchar||"\n"==nextchar)break;pos--}return new TextRange(this.contents,pos,this.end)},TextRange.prototype.reduceNewlinesEnd=function(){for(var pos=this.end;pos>this.start;){var last=this.contents[pos-1];if("\r"!=last&&"\n"!=last)break;pos--}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.reduceSpaces=function(){for(var pos=this.end;pos>this.start;){var last=this.contents[pos-1];if(" "!=last)break;pos--}return new TextRange(this.contents,this.start,pos)},TextRange.prototype.replace=function(text){return this.sub(0,this.start)+text+this.sub(this.end,this.unitText().length)},TextRange.prototype.remove=function(){return this.sub(0,this.start)+this.sub(this.end,this.unitText().length)},TextRange}();exports.TextRange=TextRange},function(module,exports,__webpack_require__){"use strict";function getWrapperConstructor(definition){return definition.isBuiltIn()?classMap[definition.nameId()]:null}function buildWrapperNode(node,setAsTopLevel){void 0===setAsTopLevel&&(setAsTopLevel=!0);var definition=node.definition(),wrapperConstructor=(definition.nameId(),getWrapperConstructor(definition));if(!wrapperConstructor){for(var priorities=determineSuperclassesPriorities(definition),superTypes=definition.allSuperTypes().sort(function(x,y){return priorities[x.nameId()]-priorities[y.nameId()]}),wr=null,i=0;i<superTypes.length;i++){var superTypeName=superTypes[i].nameId();if(wrapperConstructor=getWrapperConstructor(superTypes[i]),"DataElement"!=superTypeName){if("hl.BasicNode"!=superTypeName&&wrapperConstructor)break}else wr=superTypeName}wrapperConstructor||(wr=superTypeName)}return wrapperConstructor||(wrapperConstructor=classMap["hl.BasicNode"]),wrapperConstructor(node,setAsTopLevel)}function determineSuperclassesPriorities(td,priorities,path){void 0===priorities&&(priorities={}),void 0===path&&(path={});var typeName=td.nameId();if(!path[typeName]){path[typeName]=!0;var rank=null!=priorities[typeName]&&priorities[typeName]+1||0,superTypes=td.superTypes();return superTypes.forEach(function(x){var name=x.nameId(),r=priorities[name];(null==r||rank>r)&&(priorities[name]=rank,determineSuperclassesPriorities(x,priorities,path))}),delete path[typeName],priorities}}var RamlWrapper=__webpack_require__(20);exports.buildWrapperNode=buildWrapperNode;var classMap={AbstractSecurityScheme:function(x,y){return new RamlWrapper.AbstractSecuritySchemeImpl(x,y)},Annotable:function(x,y){return new RamlWrapper.AnnotableImpl(x,y)},AnnotationRef:function(x){return new RamlWrapper.AnnotationRefImpl(x)},AnnotationTarget:function(x){return new RamlWrapper.AnnotationTargetImpl(x)},AnyType:function(x){return new RamlWrapper.AnyTypeImpl(x)},Api:function(x,y){return new RamlWrapper.ApiImpl(x,y)},ArrayTypeDeclaration:function(x,y){return new RamlWrapper.ArrayTypeDeclarationImpl(x,y)},BasicSecurityScheme:function(x,y){return new RamlWrapper.BasicSecuritySchemeImpl(x,y)},BooleanType:function(x){return new RamlWrapper.BooleanTypeImpl(x)},BooleanTypeDeclaration:function(x,y){return new RamlWrapper.BooleanTypeDeclarationImpl(x,y)},ContentType:function(x){return new RamlWrapper.ContentTypeImpl(x)},CustomSecurityScheme:function(x,y){return new RamlWrapper.CustomSecuritySchemeImpl(x,y)},DateOnlyType:function(x){return new RamlWrapper.DateOnlyTypeImpl(x)},DateOnlyTypeDeclaration:function(x,y){return new RamlWrapper.DateOnlyTypeDeclarationImpl(x,y)},DateTimeOnlyType:function(x){return new RamlWrapper.DateTimeOnlyTypeImpl(x)},DateTimeOnlyTypeDeclaration:function(x,y){return new RamlWrapper.DateTimeOnlyTypeDeclarationImpl(x,y)},DateTimeType:function(x){return new RamlWrapper.DateTimeTypeImpl(x)},DateTimeTypeDeclaration:function(x,y){return new RamlWrapper.DateTimeTypeDeclarationImpl(x,y)},DateTypeDeclaration:function(x,y){return new RamlWrapper.DateTypeDeclarationImpl(x,y)},DigestSecurityScheme:function(x,y){return new RamlWrapper.DigestSecuritySchemeImpl(x,y)},DocumentationItem:function(x,y){return new RamlWrapper.DocumentationItemImpl(x,y)},Extension:function(x,y){return new RamlWrapper.ExtensionImpl(x,y)},FileType:function(x){return new RamlWrapper.FileTypeImpl(x)},FileTypeDeclaration:function(x,y){return new RamlWrapper.FileTypeDeclarationImpl(x,y)},FixedUriString:function(x){return new RamlWrapper.FixedUriStringImpl(x)},FragmentDeclaration:function(x,y){return new RamlWrapper.FragmentDeclarationImpl(x,y)},FullUriTemplateString:function(x){return new RamlWrapper.FullUriTemplateStringImpl(x)},IntegerType:function(x){return new RamlWrapper.IntegerTypeImpl(x)},IntegerTypeDeclaration:function(x,y){return new RamlWrapper.IntegerTypeDeclarationImpl(x,y)},Library:function(x,y){return new RamlWrapper.LibraryImpl(x,y)},LibraryBase:function(x,y){return new RamlWrapper.LibraryBaseImpl(x,y)},LocationKind:function(x){return new RamlWrapper.LocationKindImpl(x)},MarkdownString:function(x){return new RamlWrapper.MarkdownStringImpl(x)},Method:function(x,y){return new RamlWrapper.MethodImpl(x,y)},MethodBase:function(x,y){return new RamlWrapper.MethodBaseImpl(x,y)},MimeType:function(x){return new RamlWrapper.MimeTypeImpl(x)},ModelLocation:function(x){return new RamlWrapper.ModelLocationImpl(x)},NullType:function(x){return new RamlWrapper.NullTypeImpl(x)},NumberType:function(x){return new RamlWrapper.NumberTypeImpl(x)},NumberTypeDeclaration:function(x,y){return new RamlWrapper.NumberTypeDeclarationImpl(x,y)},OAuth1SecurityScheme:function(x,y){return new RamlWrapper.OAuth1SecuritySchemeImpl(x,y)},OAuth1SecuritySchemeSettings:function(x,y){return new RamlWrapper.OAuth1SecuritySchemeSettingsImpl(x,y)},OAuth2SecurityScheme:function(x,y){return new RamlWrapper.OAuth2SecuritySchemeImpl(x,y)},OAuth2SecuritySchemeSettings:function(x,y){return new RamlWrapper.OAuth2SecuritySchemeSettingsImpl(x,y)},ObjectTypeDeclaration:function(x,y){return new RamlWrapper.ObjectTypeDeclarationImpl(x,y)},Operation:function(x,y){return new RamlWrapper.OperationImpl(x,y)},Overlay:function(x,y){return new RamlWrapper.OverlayImpl(x,y)},PassThroughSecurityScheme:function(x,y){return new RamlWrapper.PassThroughSecuritySchemeImpl(x,y)},Reference:function(x){return new RamlWrapper.ReferenceImpl(x)},RelativeUriString:function(x){return new RamlWrapper.RelativeUriStringImpl(x)},Resource:function(x,y){return new RamlWrapper.ResourceImpl(x,y)},ResourceBase:function(x,y){return new RamlWrapper.ResourceBaseImpl(x,y)},ResourceType:function(x,y){return new RamlWrapper.ResourceTypeImpl(x,y)},ResourceTypeRef:function(x){return new RamlWrapper.ResourceTypeRefImpl(x)},Response:function(x,y){return new RamlWrapper.ResponseImpl(x,y)},SchemaString:function(x){return new RamlWrapper.SchemaStringImpl(x)},SecuritySchemePart:function(x,y){return new RamlWrapper.SecuritySchemePartImpl(x,y)},SecuritySchemeRef:function(x){return new RamlWrapper.SecuritySchemeRefImpl(x)},SecuritySchemeSettings:function(x,y){return new RamlWrapper.SecuritySchemeSettingsImpl(x,y)},StatusCodeString:function(x){return new RamlWrapper.StatusCodeStringImpl(x)},StringType:function(x){return new RamlWrapper.StringTypeImpl(x)},StringTypeDeclaration:function(x,y){return new RamlWrapper.StringTypeDeclarationImpl(x,y)},TimeOnlyType:function(x){return new RamlWrapper.TimeOnlyTypeImpl(x)},TimeOnlyTypeDeclaration:function(x,y){return new RamlWrapper.TimeOnlyTypeDeclarationImpl(x,y)},Trait:function(x,y){return new RamlWrapper.TraitImpl(x,y)},TraitRef:function(x){return new RamlWrapper.TraitRefImpl(x)},TypeDeclaration:function(x,y){return new RamlWrapper.TypeDeclarationImpl(x,y)},UnionTypeDeclaration:function(x,y){return new RamlWrapper.UnionTypeDeclarationImpl(x,y)},UriTemplate:function(x){return new RamlWrapper.UriTemplateImpl(x)},UsesDeclaration:function(x,y){return new RamlWrapper.UsesDeclarationImpl(x,y)},ValueType:function(x){return new RamlWrapper.ValueTypeImpl(x)},XMLFacetInfo:function(x,y){return new RamlWrapper.XMLFacetInfoImpl(x,y)}}},function(module,exports,__webpack_require__){"use strict";function getWrapperConstructor(definition){return definition.isBuiltIn()?classMap[definition.nameId()]:null}function buildWrapperNode(node,setAsTopLevel){void 0===setAsTopLevel&&(setAsTopLevel=!0);var definition=node.definition(),wrapperConstructor=(definition.nameId(),getWrapperConstructor(definition));if(!wrapperConstructor){for(var priorities=determineSuperclassesPriorities(definition),superTypes=definition.allSuperTypes().sort(function(x,y){return priorities[x.nameId()]-priorities[y.nameId()]}),wr=null,i=0;i<superTypes.length;i++){var superTypeName=superTypes[i].nameId();if(wrapperConstructor=getWrapperConstructor(superTypes[i]),"DataElement"!=superTypeName){if("hl.BasicNode"!=superTypeName&&wrapperConstructor)break}else wr=superTypeName}wrapperConstructor||(wr=superTypeName)}return wrapperConstructor||(wrapperConstructor=classMap["hl.BasicNode"]),wrapperConstructor(node,setAsTopLevel)}function determineSuperclassesPriorities(td,priorities,path){void 0===priorities&&(priorities={}),void 0===path&&(path={});var typeName=td.nameId();if(!path[typeName]){path[typeName]=!0;var rank=null!=priorities[typeName]&&priorities[typeName]+1||0,superTypes=td.superTypes();return superTypes.forEach(function(x){var name=x.nameId(),r=priorities[name];(null==r||rank>r)&&(priorities[name]=rank,determineSuperclassesPriorities(x,priorities,path))}),delete path[typeName],priorities}}var RamlWrapper=__webpack_require__(47);exports.buildWrapperNode=buildWrapperNode;var classMap={AbstractSecurityScheme:function(x,y){return new RamlWrapper.AbstractSecuritySchemeImpl(x,y)},AnyType:function(x){return new RamlWrapper.AnyTypeImpl(x)},Api:function(x,y){return new RamlWrapper.ApiImpl(x,y)},BasicSecurityScheme:function(x,y){return new RamlWrapper.BasicSecuritySchemeImpl(x,y)},BodyLike:function(x,y){return new RamlWrapper.BodyLikeImpl(x,y)},BooleanType:function(x){return new RamlWrapper.BooleanTypeImpl(x)},BooleanTypeDeclaration:function(x,y){return new RamlWrapper.BooleanTypeDeclarationImpl(x,y)},CustomSecurityScheme:function(x,y){return new RamlWrapper.CustomSecuritySchemeImpl(x,y)},DateTypeDeclaration:function(x,y){return new RamlWrapper.DateTypeDeclarationImpl(x,y)},DigestSecurityScheme:function(x,y){return new RamlWrapper.DigestSecuritySchemeImpl(x,y)},DocumentationItem:function(x,y){return new RamlWrapper.DocumentationItemImpl(x,y)},ExampleString:function(x){return new RamlWrapper.ExampleStringImpl(x)},FileTypeDeclaration:function(x,y){return new RamlWrapper.FileTypeDeclarationImpl(x,y)},FixedUri:function(x){return new RamlWrapper.FixedUriImpl(x)},FullUriTemplateString:function(x){return new RamlWrapper.FullUriTemplateStringImpl(x)},GlobalSchema:function(x,y){return new RamlWrapper.GlobalSchemaImpl(x,y)},IntegerTypeDeclaration:function(x,y){return new RamlWrapper.IntegerTypeDeclarationImpl(x,y)},JSONBody:function(x,y){return new RamlWrapper.JSONBodyImpl(x,y)},JSONExample:function(x){return new RamlWrapper.JSONExampleImpl(x)},JSonSchemaString:function(x){return new RamlWrapper.JSonSchemaStringImpl(x)},MarkdownString:function(x){return new RamlWrapper.MarkdownStringImpl(x)},Method:function(x,y){return new RamlWrapper.MethodImpl(x,y)},MethodBase:function(x,y){return new RamlWrapper.MethodBaseImpl(x,y)},MimeType:function(x){return new RamlWrapper.MimeTypeImpl(x)},NumberType:function(x){return new RamlWrapper.NumberTypeImpl(x)},NumberTypeDeclaration:function(x,y){return new RamlWrapper.NumberTypeDeclarationImpl(x,y)},OAuth1SecurityScheme:function(x,y){return new RamlWrapper.OAuth1SecuritySchemeImpl(x,y)},OAuth1SecuritySchemeSettings:function(x,y){return new RamlWrapper.OAuth1SecuritySchemeSettingsImpl(x,y)},OAuth2SecurityScheme:function(x,y){return new RamlWrapper.OAuth2SecuritySchemeImpl(x,y)},OAuth2SecuritySchemeSettings:function(x,y){return new RamlWrapper.OAuth2SecuritySchemeSettingsImpl(x,y)},Parameter:function(x,y){return new RamlWrapper.ParameterImpl(x,y)},ParameterLocation:function(x){return new RamlWrapper.ParameterLocationImpl(x)},RAMLSimpleElement:function(x,y){return new RamlWrapper.RAMLSimpleElementImpl(x,y)},Reference:function(x){return new RamlWrapper.ReferenceImpl(x)},RelativeUriString:function(x){return new RamlWrapper.RelativeUriStringImpl(x)},Resource:function(x,y){return new RamlWrapper.ResourceImpl(x,y)},ResourceType:function(x,y){return new RamlWrapper.ResourceTypeImpl(x,y)},ResourceTypeRef:function(x){return new RamlWrapper.ResourceTypeRefImpl(x)},Response:function(x,y){return new RamlWrapper.ResponseImpl(x,y)},SchemaString:function(x){return new RamlWrapper.SchemaStringImpl(x)},SecuritySchemePart:function(x,y){return new RamlWrapper.SecuritySchemePartImpl(x,y)},SecuritySchemeRef:function(x){return new RamlWrapper.SecuritySchemeRefImpl(x)},SecuritySchemeSettings:function(x,y){return new RamlWrapper.SecuritySchemeSettingsImpl(x,y)},StatusCodeString:function(x){return new RamlWrapper.StatusCodeStringImpl(x)},StringType:function(x){return new RamlWrapper.StringTypeImpl(x)},StringTypeDeclaration:function(x,y){return new RamlWrapper.StringTypeDeclarationImpl(x,y)},Trait:function(x,y){return new RamlWrapper.TraitImpl(x,y)},TraitRef:function(x){return new RamlWrapper.TraitRefImpl(x)},UriTemplate:function(x){return new RamlWrapper.UriTemplateImpl(x)},ValueType:function(x){return new RamlWrapper.ValueTypeImpl(x)},XMLBody:function(x,y){return new RamlWrapper.XMLBodyImpl(x,y)},XMLExample:function(x){return new RamlWrapper.XMLExampleImpl(x)},XMLSchemaString:function(x){return new RamlWrapper.XMLSchemaStringImpl(x)}}},function(module,exports,__webpack_require__){module.exports=__WEBPACK_EXTERNAL_MODULE_44__},function(module,exports,__webpack_require__){"use strict";function toStructuredValue(node){var value=node.value();if("string"==typeof value||null==value){var mockNode=jsyaml.createNode(value);mockNode._actualNode().startPosition=node.lowLevel().valueStart(),mockNode._actualNode().endPosition=node.lowLevel().valueEnd();var stv=new hlImpl.StructuredValue(mockNode,node.parent(),node.property());return stv}return value}function fillElementMeta(node){var meta=node._meta;meta.resetPrimitiveValuesMeta();var highLevelNode=node.highLevel();return highLevelNode.definition().allProperties().forEach(function(p){var name=p.nameId(),attrs=highLevelNode.attributes(name),gotValue=!1,optional=!1;if(attrs.forEach(function(a){gotValue=gotValue||null!=a.value(),optional=optional||a.optional()}),!gotValue){var calculator=node.getDefaultsCalculator(),defVal=calculator.attributeDefaultIfEnabled(highLevelNode,p);if(null!=defVal){var insertionKind=calculator.insertionKind(highLevelNode,p);insertionKind==defaultCalculator.InsertionKind.CALCULATED?meta.registerCalculatedValue(name):insertionKind==defaultCalculator.InsertionKind.BY_DEFAULT&&meta.registerInsertedAsDefaultValue(name)}}}),meta}function attributesToValues(attrs,constr){return constr?attrs.map(function(x){return constr(x)}):attrs.map(function(x){return x.value()})}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},hlImpl=__webpack_require__(16),jsyaml=__webpack_require__(27),defaultCalculator=(__webpack_require__(36),__webpack_require__(68)),search=__webpack_require__(23),universeHelpers=__webpack_require__(14),tckDumper=__webpack_require__(69),yaml=__webpack_require__(70),BasicNodeImpl=function(){function BasicNodeImpl(_node,setAsWrapper){void 0===setAsWrapper&&(setAsWrapper=!0),this._node=_node,this._meta=new NodeMetadataImpl((!1),(!1),universeHelpers.isMethodType(this.highLevel().definition())&&this.optional()),setAsWrapper&&_node.setWrapperNode(this)}return BasicNodeImpl.prototype.wrapperClassName=function(){return"BasicNodeImpl"},BasicNodeImpl.prototype.kind=function(){return"BasicNode"},BasicNodeImpl.prototype.parent=function(){var parent=this._node.parent();return parent?parent.wrapperNode():null},BasicNodeImpl.prototype.highLevel=function(){return this._node},BasicNodeImpl.prototype.attributes=function(name,constr){var attrs=this._node.attributes(name);if(!attrs||0==attrs.length){var defaultValue=this.getDefaultsCalculator().attributeDefaultIfEnabled(this._node,this._node.definition().property(name));return null==defaultValue?[]:Array.isArray(defaultValue)?defaultValue:[defaultValue]}return attributesToValues(attrs,constr)},BasicNodeImpl.prototype.attribute=function(name,constr){var attr=this._node.attr(name);if(constr&&constr!=this.toString&&constr!=this.toBoolean&&constr!=this.toNumber&&constr!=this.toAny)return null==attr?null:constr(attr);var attributeValue=attr?attr.value():null;return null==attributeValue&&(attributeValue=this.getDefaultsCalculator().attributeDefaultIfEnabled(this._node,this._node.definition().property(name))),null==attributeValue?null:constr?constr(attributeValue):attributeValue},BasicNodeImpl.prototype.elements=function(name){var elements=this._node.elementsOfKind(name);return elements?elements.map(function(x){return x.wrapperNode()}):null},BasicNodeImpl.prototype.element=function(name){var element=this._node.element(name);return element?element.wrapperNode():null},BasicNodeImpl.prototype.add=function(node){this.highLevel().add(node.highLevel())},BasicNodeImpl.prototype.addToProp=function(node,prop){var hl=node.highLevel(),pr=this.highLevel().definition().property(prop);hl._prop=pr,this.highLevel().add(hl)},BasicNodeImpl.prototype.remove=function(node){this.highLevel().remove(node.highLevel())},BasicNodeImpl.prototype.dump=function(){return this.highLevel().dump("yaml")},BasicNodeImpl.prototype.toString=function(arg){var obj;return obj=arg.lowLevel&&arg.property?arg.value():arg,null!=obj?obj.toString():obj},BasicNodeImpl.prototype.toAny=function(arg){return arg},BasicNodeImpl.prototype.toBoolean=function(arg){var obj;return obj=arg.lowLevel&&arg.property?arg.value():arg,null!=obj?"true"==obj.toString():obj},BasicNodeImpl.prototype.toNumber=function(arg){var obj;if(obj=arg.lowLevel&&arg.property?arg.value():arg,!obj)return obj;try{var nValue=parseFloat(obj.toString());return nValue}catch(e){}return Number.MAX_VALUE},BasicNodeImpl.prototype.errors=function(){var _this=this,issues=[],highLevelErrors=this._node.errors();null!=highLevelErrors&&(issues=issues.concat(highLevelErrors));var lineMapper=this._node.lowLevel().unit().lineMapper(),result=issues.map(function(x){var startPoint=null;try{startPoint=x.node.lowLevel().unit().lineMapper().position(x.start)}catch(e){console.warn(e);try{startPoint=lineMapper.position(x.start)}catch(e1){console.warn(e1)}}var endPoint=null;try{endPoint=lineMapper.position(x.end)}catch(e){console.warn(e)}var path;return path=x.path?x.path:x.node?x.node.lowLevel().unit().path():search.declRoot(_this.highLevel()).lowLevel().unit().path(),{code:x.code,message:x.message,path:path,start:x.start,end:x.end,line:startPoint?startPoint.errorMessage?null:startPoint.line:null,column:startPoint?startPoint.errorMessage?null:startPoint.column:null,range:[startPoint,endPoint],isWarning:x.isWarning}});return result},BasicNodeImpl.prototype.definition=function(){return this.highLevel().definition()},BasicNodeImpl.prototype.runtimeDefinition=function(){return universeHelpers.isTypeDeclarationSibling(this.highLevel().definition())?this.highLevel().localType():null},BasicNodeImpl.prototype.toJSON=function(serializeOptions){var oldDefaults=defaultAttributeDefaultsValue;defaultAttributeDefaultsValue=this.attributeDefaults();try{return new tckDumper.TCKDumper(serializeOptions).dump(this)}finally{defaultAttributeDefaultsValue=oldDefaults}},BasicNodeImpl.prototype.optional=function(){var highLevel=this.highLevel();return null!=highLevel&&highLevel.optional()},BasicNodeImpl.prototype.optionalProperties=function(){return this.highLevel()?this.highLevel().optionalProperties():[]},BasicNodeImpl.prototype.getDefaultsCalculator=function(){return this.defaultsCalculator?this.defaultsCalculator:(this.parent()&&(this.defaultsCalculator=this.parent().getDefaultsCalculator()),this.defaultsCalculator||(this.defaultsCalculator=new defaultCalculator.AttributeDefaultsCalculator(defaultAttributeDefaultsValue)),this.defaultsCalculator)},BasicNodeImpl.prototype.setAttributeDefaults=function(attributeDefaults){this.defaultsCalculator=new defaultCalculator.AttributeDefaultsCalculator(attributeDefaults)},BasicNodeImpl.prototype.attributeDefaults=function(){return this.getDefaultsCalculator()&&this.getDefaultsCalculator().isEnabled()},BasicNodeImpl.prototype.meta=function(){return fillElementMeta(this)},BasicNodeImpl.prototype.RAMLVersion=function(){return this.highLevel().definition().universe().version()},BasicNodeImpl}();exports.BasicNodeImpl=BasicNodeImpl;var defaultAttributeDefaultsValue=!0,AttributeNodeImpl=function(){function AttributeNodeImpl(attr){this._meta=new ValueMetadataImpl,this.attr=attr}return AttributeNodeImpl.prototype.highLevel=function(){return this.attr},AttributeNodeImpl.prototype.wrapperClassName=function(){return"AttributeNodeImpl"},AttributeNodeImpl.prototype.kind=function(){return"AttributeNode"},AttributeNodeImpl.prototype.optional=function(){var highLevel=this.highLevel();return null!=highLevel&&highLevel.optional()},AttributeNodeImpl.prototype.meta=function(){return this._meta},AttributeNodeImpl.prototype.RAMLVersion=function(){return this.highLevel().definition().universe().version()},AttributeNodeImpl.prototype.parent=function(){var parent=this.attr.parent();return parent?parent.wrapperNode():null},AttributeNodeImpl.prototype.toJSON=function(serializeOptions){return new tckDumper.TCKDumper(serializeOptions).dump(this)},AttributeNodeImpl}();exports.AttributeNodeImpl=AttributeNodeImpl,exports.toStructuredValue=toStructuredValue;var TypeInstanceImpl=function(){function TypeInstanceImpl(nodes,type){this.type=type,Array.isArray(nodes)?this.children=nodes:this.node=nodes}return TypeInstanceImpl.prototype.properties=function(){return this.isArray()?[]:this.getChildren().map(function(x){return new TypeInstancePropertyImpl(x)})},TypeInstanceImpl.prototype.getChildren=function(){return this.node&&this.node.children()||this.children},TypeInstanceImpl.prototype.value=function(){return this.node&&this.node.value()},TypeInstanceImpl.prototype.isScalar=function(){return!!this.node&&(0==this.node.children().length&&(!this.type||this.type.isScalar()))},TypeInstanceImpl.prototype.toJSON=function(){return(new tckDumper.TCKDumper).serializeTypeInstance(this)},TypeInstanceImpl.prototype.isArray=function(){return!!this.node&&(this.type?this.type.isArray():this.node&&this.node.valueKind()==yaml.Kind.SEQ)},TypeInstanceImpl.prototype.items=function(){return this.isArray()?this.node.children().map(function(x){return new TypeInstanceImpl(x)}):null},TypeInstanceImpl}();exports.TypeInstanceImpl=TypeInstanceImpl;var TypeInstancePropertyImpl=function(){function TypeInstancePropertyImpl(node){this.node=node}return TypeInstancePropertyImpl.prototype.name=function(){return this.node.optional()?this.node.key()+"?":this.node.key()},TypeInstancePropertyImpl.prototype.value=function(){if(this.isArray()){var children=this.node.children();return children.length>0?new TypeInstanceImpl(children[0]):null}return new TypeInstanceImpl(this.node)},TypeInstancePropertyImpl.prototype.values=function(){return this.isArray()?this.node.children().map(function(x){return new TypeInstanceImpl(x)}):[new TypeInstanceImpl(this.node)]},TypeInstancePropertyImpl.prototype.isArray=function(){var children=this.node.children();if(children.length>0&&null==children[0].key())return!0;var hl=this.node.highLevelNode();if(hl){var prop=hl.property();if(prop){var range=prop.range();if(range)return range.isArray()}}return this.node.valueKind()==yaml.Kind.SEQ},TypeInstancePropertyImpl}();exports.TypeInstancePropertyImpl=TypeInstancePropertyImpl;var ValueMetadataImpl=function(){function ValueMetadataImpl(_insertedAsDefault,_calculated,_optional){void 0===_insertedAsDefault&&(_insertedAsDefault=!1),void 0===_calculated&&(_calculated=!1),void 0===_optional&&(_optional=!1),this._insertedAsDefault=_insertedAsDefault,this._calculated=_calculated,this._optional=_optional}return ValueMetadataImpl.prototype.calculated=function(){return this._calculated},ValueMetadataImpl.prototype.insertedAsDefault=function(){return this._insertedAsDefault},ValueMetadataImpl.prototype.setCalculated=function(){this._calculated=!0},ValueMetadataImpl.prototype.setInsertedAsDefault=function(){this._insertedAsDefault=!0},ValueMetadataImpl.prototype.setOptional=function(){this._optional=!0},ValueMetadataImpl.prototype.optional=function(){return this._optional},ValueMetadataImpl.prototype.isDefault=function(){return!(this._insertedAsDefault||this._calculated||this._optional)},ValueMetadataImpl.prototype.toJSON=function(){var obj={};return this._calculated&&(obj.calculated=!0),this._insertedAsDefault&&(obj.insertedAsDefault=!0),this._optional&&(obj.optional=!0),obj},ValueMetadataImpl}();exports.ValueMetadataImpl=ValueMetadataImpl;var NodeMetadataImpl=function(_super){function NodeMetadataImpl(){_super.apply(this,arguments),this.valuesMeta={}}return __extends(NodeMetadataImpl,_super),NodeMetadataImpl.prototype.primitiveValuesMeta=function(){return this.valuesMeta},NodeMetadataImpl.prototype.registerInsertedAsDefaultValue=function(propName){var pMeta=this.valuesMeta[propName];null==pMeta?this.valuesMeta[propName]=new ValueMetadataImpl((!0)):pMeta.setInsertedAsDefault()},NodeMetadataImpl.prototype.registerCalculatedValue=function(propName){var pMeta=this.valuesMeta[propName];null==pMeta?this.valuesMeta[propName]=new ValueMetadataImpl((!1),(!0)):pMeta.setCalculated()},NodeMetadataImpl.prototype.registerOptionalValue=function(propName){var pMeta=this.valuesMeta[propName];null==pMeta?this.valuesMeta[propName]=new ValueMetadataImpl((!1),(!1),(!0)):pMeta.setOptional()},NodeMetadataImpl.prototype.resetPrimitiveValuesMeta=function(){this.valuesMeta={}},NodeMetadataImpl.prototype.isDefault=function(){return!!_super.prototype.isDefault.call(this)&&0==Object.keys(this.valuesMeta).length},NodeMetadataImpl.prototype.toJSON=function(){var _this=this,obj=_super.prototype.toJSON.call(this),valuesObj={},propKeys=Object.keys(this.valuesMeta);return propKeys.length>0&&(propKeys.forEach(function(x){var childMeta=_this.valuesMeta[x].toJSON();Object.keys(childMeta).length>0&&(valuesObj[x]=childMeta)}),obj.primitiveValuesMeta=valuesObj),obj},NodeMetadataImpl}(ValueMetadataImpl);exports.NodeMetadataImpl=NodeMetadataImpl,exports.fillElementMeta=fillElementMeta,exports.attributesToValues=attributesToValues},function(module,exports,__webpack_require__){"use strict";function getExtraProviderSource(extraProvider){var sourceExtra=extraProvider.getExtra(ramlTypes.SOURCE_EXTRA);return null==sourceExtra?null:def.isSourceProvider(sourceExtra)?sourceExtra:lowLevel.isLowLevelNode(sourceExtra)?{getSource:function(){return sourceExtra.highLevelNode()}}:hl.isParseResult(sourceExtra)?{getSource:function(){return sourceExtra}}:null}function getRTypeSource(rType){return getExtraProviderSource(rType)}function findRTypeByNominal(nominalType){var adapters=nominalType.getAdapters();return adapters?_.find(adapters,function(adapter){return def.rt.isParsedType(adapter)}):null}function getNominalTypeSource(nominalType){if(!nominalType)return null;var sourceExtra=nominalType.getExtra(ramlTypes.SOURCE_EXTRA);if(sourceExtra)return getExtraProviderSource(nominalType);var rType=findRTypeByNominal(nominalType);return rType?getRTypeSource(rType):null}function getNominalPropertySource(type,name){var typeSource=getNominalTypeSource(type);return typeSource?{getSource:function(){var typeNode=typeSource.getSource(),typeNodeElement=typeNode.asElement();if(null==typeNodeElement)return null;var propertyElements=typeNodeElement.elementsOfKind(universes.Universe10.ObjectTypeDeclaration.properties.properties.name);return null==propertyElements||0==propertyElements.length?null:_.find(propertyElements,function(propertyElement){return name==propertyElement.attrValue(universes.Universe10.TypeDeclaration.properties.name.name)})}}:null}function getNominalPropertySource2(property){return getNominalPropertySource(property.domain(),property.nameId());
}var def=__webpack_require__(36),ramlTypes=def.rt,hl=__webpack_require__(10),lowLevel=__webpack_require__(11),universes=__webpack_require__(22),_=__webpack_require__(61);exports.getExtraProviderSource=getExtraProviderSource,exports.getRTypeSource=getRTypeSource,exports.findRTypeByNominal=findRTypeByNominal,exports.getNominalTypeSource=getNominalTypeSource,exports.getNominalPropertySource=getNominalPropertySource,exports.getNominalPropertySource2=getNominalPropertySource2},function(module,exports,__webpack_require__){"use strict";function createMethod(key){var universe=def.getUniverse("RAML08"),nc=universe.type("Method"),node=stubs.createStubNode(nc,null,key);return node}function createStringTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("StringTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createBooleanTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("BooleanTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createNumberTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("NumberTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createIntegerTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("IntegerTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createDateTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("DateTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createFileTypeDeclaration(key){var universe=def.getUniverse("RAML08"),nc=universe.type("FileTypeDeclaration"),node=stubs.createStubNode(nc,null,key);return node}function createXMLBody(key){var universe=def.getUniverse("RAML08"),nc=universe.type("XMLBody"),node=stubs.createStubNode(nc,null,key);return node}function createJSONBody(key){var universe=def.getUniverse("RAML08"),nc=universe.type("JSONBody"),node=stubs.createStubNode(nc,null,key);return node}function createSecuritySchemePart(key){var universe=def.getUniverse("RAML08"),nc=universe.type("SecuritySchemePart"),node=stubs.createStubNode(nc,null,key);return node}function createTrait(key){var universe=def.getUniverse("RAML08"),nc=universe.type("Trait"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth1SecuritySchemeSettings(key){var universe=def.getUniverse("RAML08"),nc=universe.type("OAuth1SecuritySchemeSettings"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth2SecuritySchemeSettings(key){var universe=def.getUniverse("RAML08"),nc=universe.type("OAuth2SecuritySchemeSettings"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth2SecurityScheme(key){var universe=def.getUniverse("RAML08"),nc=universe.type("OAuth2SecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createOAuth1SecurityScheme(key){var universe=def.getUniverse("RAML08"),nc=universe.type("OAuth1SecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createBasicSecurityScheme(key){var universe=def.getUniverse("RAML08"),nc=universe.type("BasicSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createDigestSecurityScheme(key){var universe=def.getUniverse("RAML08"),nc=universe.type("DigestSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createCustomSecurityScheme(key){var universe=def.getUniverse("RAML08"),nc=universe.type("CustomSecurityScheme"),node=stubs.createStubNode(nc,null,key);return node}function createGlobalSchema(key){var universe=def.getUniverse("RAML08"),nc=universe.type("GlobalSchema"),node=stubs.createStubNode(nc,null,key);return node}function createDocumentationItem(key){var universe=def.getUniverse("RAML08"),nc=universe.type("DocumentationItem"),node=stubs.createStubNode(nc,null,key);return node}function loadApiSync(apiPath,arg1,arg2){return apiLoader.loadApi(apiPath,arg1,arg2).getOrElse(null)}function loadRAMLSync(ramlPath,arg1,arg2){return apiLoader.loadApi(ramlPath,arg1,arg2).getOrElse(null)}function loadApi(apiPath,arg1,arg2){return apiLoader.loadApiAsync(apiPath,arg1,arg2)}function loadRAML(ramlPath,arg1,arg2){return apiLoader.loadRAMLAsync(ramlPath,arg1,arg2)}function getLanguageElementByRuntimeType(runtimeType){return apiLoader.getLanguageElementByRuntimeType(runtimeType)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},stubs=__webpack_require__(17),def=__webpack_require__(36),core=__webpack_require__(45),apiLoader=__webpack_require__(9),helper=__webpack_require__(48),ApiImpl=function(_super){function ApiImpl(){_super.apply(this,arguments)}return __extends(ApiImpl,_super),ApiImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},ApiImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},ApiImpl.prototype.version=function(){return _super.prototype.attribute.call(this,"version",this.toString)},ApiImpl.prototype.setVersion=function(param){return this.highLevel().attrOrCreate("version").setValue(""+param),this},ApiImpl.prototype.baseUri=function(){return _super.prototype.attribute.call(this,"baseUri",function(attr){return new FullUriTemplateStringImpl(attr)})},ApiImpl.prototype.baseUriParameters_original=function(){return _super.prototype.elements.call(this,"baseUriParameters")},ApiImpl.prototype.uriParameters=function(){return _super.prototype.elements.call(this,"uriParameters")},ApiImpl.prototype.protocols=function(){return _super.prototype.attributes.call(this,"protocols",this.toString)},ApiImpl.prototype.setProtocols=function(param){return this.highLevel().attrOrCreate("protocols").setValue(""+param),this},ApiImpl.prototype.mediaType=function(){return _super.prototype.attribute.call(this,"mediaType",function(attr){return new MimeTypeImpl(attr)})},ApiImpl.prototype.schemas=function(){return _super.prototype.elements.call(this,"schemas")},ApiImpl.prototype.traits_original=function(){return _super.prototype.elements.call(this,"traits")},ApiImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},ApiImpl.prototype.securitySchemes=function(){return _super.prototype.elements.call(this,"securitySchemes")},ApiImpl.prototype.resourceTypes_original=function(){return _super.prototype.elements.call(this,"resourceTypes")},ApiImpl.prototype.resources=function(){return _super.prototype.elements.call(this,"resources")},ApiImpl.prototype.documentation=function(){return _super.prototype.elements.call(this,"documentation")},ApiImpl.prototype.wrapperClassName=function(){return"ApiImpl"},ApiImpl.prototype.kind=function(){return"Api"},ApiImpl.prototype.RAMLVersion_original=function(){return"RAML08"},ApiImpl.prototype.expand=function(){return helper.expandTraitsAndResourceTypes(this)},ApiImpl.prototype.traits=function(){return helper.traitsPrimary(this)},ApiImpl.prototype.allTraits=function(){return helper.allTraits(this)},ApiImpl.prototype.resourceTypes=function(){return helper.resourceTypesPrimary(this)},ApiImpl.prototype.allResourceTypes=function(){return helper.allResourceTypes(this)},ApiImpl.prototype.childResource=function(relPath){return helper.childResource(this,relPath)},ApiImpl.prototype.allResources=function(){return helper.allResources(this)},ApiImpl.prototype.baseUriParameters=function(){return helper.baseUriParametersPrimary(this)},ApiImpl.prototype.allBaseUriParameters=function(){return helper.baseUriParameters(this)},ApiImpl.prototype.allProtocols=function(){return helper.allProtocols(this)},ApiImpl.prototype.RAMLVersion=function(){return helper.RAMLVersion(this)},ApiImpl}(core.BasicNodeImpl);exports.ApiImpl=ApiImpl;var ValueTypeImpl=function(_super){function ValueTypeImpl(){_super.apply(this,arguments)}return __extends(ValueTypeImpl,_super),ValueTypeImpl.prototype.wrapperClassName=function(){return"ValueTypeImpl"},ValueTypeImpl.prototype.kind=function(){return"ValueType"},ValueTypeImpl.prototype.RAMLVersion=function(){return"undefined"},ValueTypeImpl.prototype.value=function(){return this.attr.value()},ValueTypeImpl}(core.AttributeNodeImpl);exports.ValueTypeImpl=ValueTypeImpl;var AnyTypeImpl=function(_super){function AnyTypeImpl(){_super.apply(this,arguments)}return __extends(AnyTypeImpl,_super),AnyTypeImpl.prototype.wrapperClassName=function(){return"AnyTypeImpl"},AnyTypeImpl.prototype.kind=function(){return"AnyType"},AnyTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},AnyTypeImpl}(ValueTypeImpl);exports.AnyTypeImpl=AnyTypeImpl;var NumberTypeImpl=function(_super){function NumberTypeImpl(){_super.apply(this,arguments)}return __extends(NumberTypeImpl,_super),NumberTypeImpl.prototype.wrapperClassName=function(){return"NumberTypeImpl"},NumberTypeImpl.prototype.kind=function(){return"NumberType"},NumberTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},NumberTypeImpl.prototype.value=function(){return this.attr.value()},NumberTypeImpl}(ValueTypeImpl);exports.NumberTypeImpl=NumberTypeImpl;var BooleanTypeImpl=function(_super){function BooleanTypeImpl(){_super.apply(this,arguments)}return __extends(BooleanTypeImpl,_super),BooleanTypeImpl.prototype.wrapperClassName=function(){return"BooleanTypeImpl"},BooleanTypeImpl.prototype.kind=function(){return"BooleanType"},BooleanTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},BooleanTypeImpl.prototype.value=function(){return this.attr.value()},BooleanTypeImpl}(ValueTypeImpl);exports.BooleanTypeImpl=BooleanTypeImpl;var ReferenceImpl=function(_super){function ReferenceImpl(){_super.apply(this,arguments)}return __extends(ReferenceImpl,_super),ReferenceImpl.prototype.wrapperClassName=function(){return"ReferenceImpl"},ReferenceImpl.prototype.kind=function(){return"Reference"},ReferenceImpl.prototype.RAMLVersion=function(){return"RAML08"},ReferenceImpl.prototype.value=function(){return core.toStructuredValue(this.attr)},ReferenceImpl.prototype.structuredValue=function(){return helper.structuredValue(this)},ReferenceImpl.prototype.name=function(){return helper.referenceName(this)},ReferenceImpl}(core.AttributeNodeImpl);exports.ReferenceImpl=ReferenceImpl;var ResourceTypeRefImpl=function(_super){function ResourceTypeRefImpl(){_super.apply(this,arguments)}return __extends(ResourceTypeRefImpl,_super),ResourceTypeRefImpl.prototype.wrapperClassName=function(){return"ResourceTypeRefImpl"},ResourceTypeRefImpl.prototype.kind=function(){return"ResourceTypeRef"},ResourceTypeRefImpl.prototype.RAMLVersion=function(){return"RAML08"},ResourceTypeRefImpl.prototype.resourceType=function(){return helper.referencedResourceType(this)},ResourceTypeRefImpl}(ReferenceImpl);exports.ResourceTypeRefImpl=ResourceTypeRefImpl;var ResourceTypeImpl=function(_super){function ResourceTypeImpl(){_super.apply(this,arguments)}return __extends(ResourceTypeImpl,_super),ResourceTypeImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},ResourceTypeImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},ResourceTypeImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},ResourceTypeImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},ResourceTypeImpl.prototype.methods=function(){return _super.prototype.elements.call(this,"methods")},ResourceTypeImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},ResourceTypeImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",function(attr){return new ResourceTypeRefImpl(attr)})},ResourceTypeImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},ResourceTypeImpl.prototype.uriParameters=function(){return _super.prototype.elements.call(this,"uriParameters")},ResourceTypeImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},ResourceTypeImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},ResourceTypeImpl.prototype.baseUriParameters=function(){return _super.prototype.elements.call(this,"baseUriParameters")},ResourceTypeImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResourceTypeImpl.prototype.wrapperClassName=function(){return"ResourceTypeImpl"},ResourceTypeImpl.prototype.kind=function(){return"ResourceType"},ResourceTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},ResourceTypeImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},ResourceTypeImpl}(core.BasicNodeImpl);exports.ResourceTypeImpl=ResourceTypeImpl;var MethodBaseImpl=function(_super){function MethodBaseImpl(){_super.apply(this,arguments)}return __extends(MethodBaseImpl,_super),MethodBaseImpl.prototype.responses=function(){return _super.prototype.elements.call(this,"responses")},MethodBaseImpl.prototype.body=function(){return _super.prototype.elements.call(this,"body")},MethodBaseImpl.prototype.protocols=function(){return _super.prototype.attributes.call(this,"protocols",this.toString)},MethodBaseImpl.prototype.setProtocols=function(param){return this.highLevel().attrOrCreate("protocols").setValue(""+param),this},MethodBaseImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},MethodBaseImpl.prototype.baseUriParameters=function(){return _super.prototype.elements.call(this,"baseUriParameters")},MethodBaseImpl.prototype.queryParameters=function(){return _super.prototype.elements.call(this,"queryParameters")},MethodBaseImpl.prototype.headers=function(){return _super.prototype.elements.call(this,"headers")},MethodBaseImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},MethodBaseImpl.prototype.wrapperClassName=function(){return"MethodBaseImpl"},MethodBaseImpl.prototype.kind=function(){return"MethodBase"},MethodBaseImpl.prototype.RAMLVersion=function(){return"RAML08"},MethodBaseImpl}(core.BasicNodeImpl);exports.MethodBaseImpl=MethodBaseImpl;var ResponseImpl=function(_super){function ResponseImpl(){_super.apply(this,arguments)}return __extends(ResponseImpl,_super),ResponseImpl.prototype.code=function(){return _super.prototype.attribute.call(this,"code",function(attr){return new StatusCodeStringImpl(attr)})},ResponseImpl.prototype.headers=function(){return _super.prototype.elements.call(this,"headers")},ResponseImpl.prototype.body=function(){return _super.prototype.elements.call(this,"body")},ResponseImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResponseImpl.prototype.wrapperClassName=function(){return"ResponseImpl"},ResponseImpl.prototype.kind=function(){return"Response"},ResponseImpl.prototype.RAMLVersion=function(){return"RAML08"},ResponseImpl.prototype.isOkRange=function(){return helper.isOkRange(this)},ResponseImpl}(core.BasicNodeImpl);exports.ResponseImpl=ResponseImpl;var StringTypeImpl=function(_super){function StringTypeImpl(){_super.apply(this,arguments)}return __extends(StringTypeImpl,_super),StringTypeImpl.prototype.wrapperClassName=function(){return"StringTypeImpl"},StringTypeImpl.prototype.kind=function(){return"StringType"},StringTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},StringTypeImpl.prototype.value=function(){return this.attr.value()},StringTypeImpl}(ValueTypeImpl);exports.StringTypeImpl=StringTypeImpl;var StatusCodeStringImpl=function(_super){function StatusCodeStringImpl(){_super.apply(this,arguments)}return __extends(StatusCodeStringImpl,_super),StatusCodeStringImpl.prototype.wrapperClassName=function(){return"StatusCodeStringImpl"},StatusCodeStringImpl.prototype.kind=function(){return"StatusCodeString"},StatusCodeStringImpl.prototype.RAMLVersion=function(){return"RAML08"},StatusCodeStringImpl}(StringTypeImpl);exports.StatusCodeStringImpl=StatusCodeStringImpl;var ParameterImpl=function(_super){function ParameterImpl(){_super.apply(this,arguments)}return __extends(ParameterImpl,_super),ParameterImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},ParameterImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},ParameterImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},ParameterImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},ParameterImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",this.toString)},ParameterImpl.prototype.setType=function(param){return this.highLevel().attrOrCreate("type").setValue(""+param),this},ParameterImpl.prototype.location=function(){return _super.prototype.attribute.call(this,"location",function(attr){return new ParameterLocationImpl(attr)})},ParameterImpl.prototype.required=function(){return _super.prototype.attribute.call(this,"required",this.toBoolean)},ParameterImpl.prototype.setRequired=function(param){return this.highLevel().attrOrCreate("required").setValue(""+param),this},ParameterImpl.prototype.default=function(){return _super.prototype.attribute.call(this,"default",this.toAny)},ParameterImpl.prototype.setDefault=function(param){return this.highLevel().attrOrCreate("default").setValue(""+param),this},ParameterImpl.prototype.example=function(){return _super.prototype.attribute.call(this,"example",this.toString)},ParameterImpl.prototype.setExample=function(param){return this.highLevel().attrOrCreate("example").setValue(""+param),this},ParameterImpl.prototype.repeat=function(){return _super.prototype.attribute.call(this,"repeat",this.toBoolean)},ParameterImpl.prototype.setRepeat=function(param){return this.highLevel().attrOrCreate("repeat").setValue(""+param),this},ParameterImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ParameterImpl.prototype.wrapperClassName=function(){return"ParameterImpl"},ParameterImpl.prototype.kind=function(){return"Parameter"},ParameterImpl.prototype.RAMLVersion=function(){return"RAML08"},ParameterImpl}(core.BasicNodeImpl);exports.ParameterImpl=ParameterImpl;var ParameterLocationImpl=function(){function ParameterLocationImpl(attr){this.attr=attr}return ParameterLocationImpl.prototype.wrapperClassName=function(){return"ParameterLocationImpl"},ParameterLocationImpl.prototype.kind=function(){return"ParameterLocation"},ParameterLocationImpl.prototype.RAMLVersion=function(){return"RAML08"},ParameterLocationImpl}();exports.ParameterLocationImpl=ParameterLocationImpl;var MarkdownStringImpl=function(_super){function MarkdownStringImpl(){_super.apply(this,arguments)}return __extends(MarkdownStringImpl,_super),MarkdownStringImpl.prototype.wrapperClassName=function(){return"MarkdownStringImpl"},MarkdownStringImpl.prototype.kind=function(){return"MarkdownString"},MarkdownStringImpl.prototype.RAMLVersion=function(){return"RAML08"},MarkdownStringImpl}(StringTypeImpl);exports.MarkdownStringImpl=MarkdownStringImpl;var StringTypeDeclarationImpl=function(_super){function StringTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createStringTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(StringTypeDeclarationImpl,_super),StringTypeDeclarationImpl.prototype.pattern=function(){return _super.prototype.attribute.call(this,"pattern",this.toString)},StringTypeDeclarationImpl.prototype.setPattern=function(param){return this.highLevel().attrOrCreate("pattern").setValue(""+param),this},StringTypeDeclarationImpl.prototype.enum=function(){return _super.prototype.attributes.call(this,"enum",this.toString)},StringTypeDeclarationImpl.prototype.setEnum=function(param){return this.highLevel().attrOrCreate("enum").setValue(""+param),this},StringTypeDeclarationImpl.prototype.minLength=function(){return _super.prototype.attribute.call(this,"minLength",this.toNumber)},StringTypeDeclarationImpl.prototype.setMinLength=function(param){return this.highLevel().attrOrCreate("minLength").setValue(""+param),this},StringTypeDeclarationImpl.prototype.maxLength=function(){return _super.prototype.attribute.call(this,"maxLength",this.toNumber)},StringTypeDeclarationImpl.prototype.setMaxLength=function(param){return this.highLevel().attrOrCreate("maxLength").setValue(""+param),this},StringTypeDeclarationImpl.prototype.wrapperClassName=function(){return"StringTypeDeclarationImpl"},StringTypeDeclarationImpl.prototype.kind=function(){return"StringTypeDeclaration"},StringTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},StringTypeDeclarationImpl}(ParameterImpl);exports.StringTypeDeclarationImpl=StringTypeDeclarationImpl;var BooleanTypeDeclarationImpl=function(_super){function BooleanTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createBooleanTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(BooleanTypeDeclarationImpl,_super),BooleanTypeDeclarationImpl.prototype.wrapperClassName=function(){return"BooleanTypeDeclarationImpl"},BooleanTypeDeclarationImpl.prototype.kind=function(){return"BooleanTypeDeclaration"},BooleanTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},BooleanTypeDeclarationImpl}(ParameterImpl);exports.BooleanTypeDeclarationImpl=BooleanTypeDeclarationImpl;var NumberTypeDeclarationImpl=function(_super){function NumberTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createNumberTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(NumberTypeDeclarationImpl,_super),NumberTypeDeclarationImpl.prototype.minimum=function(){return _super.prototype.attribute.call(this,"minimum",this.toNumber)},NumberTypeDeclarationImpl.prototype.setMinimum=function(param){return this.highLevel().attrOrCreate("minimum").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.maximum=function(){return _super.prototype.attribute.call(this,"maximum",this.toNumber)},NumberTypeDeclarationImpl.prototype.setMaximum=function(param){return this.highLevel().attrOrCreate("maximum").setValue(""+param),this},NumberTypeDeclarationImpl.prototype.wrapperClassName=function(){return"NumberTypeDeclarationImpl"},NumberTypeDeclarationImpl.prototype.kind=function(){return"NumberTypeDeclaration"},NumberTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},NumberTypeDeclarationImpl}(ParameterImpl);exports.NumberTypeDeclarationImpl=NumberTypeDeclarationImpl;var IntegerTypeDeclarationImpl=function(_super){function IntegerTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createIntegerTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(IntegerTypeDeclarationImpl,_super),IntegerTypeDeclarationImpl.prototype.wrapperClassName=function(){return"IntegerTypeDeclarationImpl"},IntegerTypeDeclarationImpl.prototype.kind=function(){return"IntegerTypeDeclaration"},IntegerTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},IntegerTypeDeclarationImpl}(NumberTypeDeclarationImpl);exports.IntegerTypeDeclarationImpl=IntegerTypeDeclarationImpl;var DateTypeDeclarationImpl=function(_super){function DateTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDateTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DateTypeDeclarationImpl,_super),DateTypeDeclarationImpl.prototype.wrapperClassName=function(){return"DateTypeDeclarationImpl"},DateTypeDeclarationImpl.prototype.kind=function(){return"DateTypeDeclaration"},DateTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},DateTypeDeclarationImpl}(ParameterImpl);exports.DateTypeDeclarationImpl=DateTypeDeclarationImpl;var FileTypeDeclarationImpl=function(_super){function FileTypeDeclarationImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createFileTypeDeclaration(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(FileTypeDeclarationImpl,_super),FileTypeDeclarationImpl.prototype.wrapperClassName=function(){return"FileTypeDeclarationImpl"},FileTypeDeclarationImpl.prototype.kind=function(){return"FileTypeDeclaration"},FileTypeDeclarationImpl.prototype.RAMLVersion=function(){return"RAML08"},FileTypeDeclarationImpl}(ParameterImpl);exports.FileTypeDeclarationImpl=FileTypeDeclarationImpl;var BodyLikeImpl=function(_super){function BodyLikeImpl(){_super.apply(this,arguments)}return __extends(BodyLikeImpl,_super),BodyLikeImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},BodyLikeImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},BodyLikeImpl.prototype.schema=function(){return _super.prototype.attribute.call(this,"schema",function(attr){return new SchemaStringImpl(attr)})},BodyLikeImpl.prototype.example=function(){return _super.prototype.attribute.call(this,"example",function(attr){return new ExampleStringImpl(attr)})},BodyLikeImpl.prototype.formParameters=function(){return _super.prototype.elements.call(this,"formParameters")},BodyLikeImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},BodyLikeImpl.prototype.wrapperClassName=function(){return"BodyLikeImpl"},BodyLikeImpl.prototype.kind=function(){return"BodyLike"},BodyLikeImpl.prototype.RAMLVersion=function(){return"RAML08"},BodyLikeImpl.prototype.schemaContent=function(){return helper.schemaContent(this)},BodyLikeImpl}(core.BasicNodeImpl);exports.BodyLikeImpl=BodyLikeImpl;var SchemaStringImpl=function(_super){function SchemaStringImpl(){_super.apply(this,arguments)}return __extends(SchemaStringImpl,_super),SchemaStringImpl.prototype.wrapperClassName=function(){return"SchemaStringImpl"},SchemaStringImpl.prototype.kind=function(){return"SchemaString"},SchemaStringImpl.prototype.RAMLVersion=function(){return"RAML08"},SchemaStringImpl}(StringTypeImpl);exports.SchemaStringImpl=SchemaStringImpl;var JSonSchemaStringImpl=function(_super){function JSonSchemaStringImpl(){_super.apply(this,arguments)}return __extends(JSonSchemaStringImpl,_super),JSonSchemaStringImpl.prototype.wrapperClassName=function(){return"JSonSchemaStringImpl"},JSonSchemaStringImpl.prototype.kind=function(){return"JSonSchemaString"},JSonSchemaStringImpl.prototype.RAMLVersion=function(){return"RAML08"},JSonSchemaStringImpl}(SchemaStringImpl);exports.JSonSchemaStringImpl=JSonSchemaStringImpl;var XMLSchemaStringImpl=function(_super){function XMLSchemaStringImpl(){_super.apply(this,arguments)}return __extends(XMLSchemaStringImpl,_super),XMLSchemaStringImpl.prototype.wrapperClassName=function(){return"XMLSchemaStringImpl"},XMLSchemaStringImpl.prototype.kind=function(){return"XMLSchemaString"},XMLSchemaStringImpl.prototype.RAMLVersion=function(){return"RAML08"},XMLSchemaStringImpl}(SchemaStringImpl);exports.XMLSchemaStringImpl=XMLSchemaStringImpl;var ExampleStringImpl=function(_super){function ExampleStringImpl(){_super.apply(this,arguments)}return __extends(ExampleStringImpl,_super),ExampleStringImpl.prototype.wrapperClassName=function(){return"ExampleStringImpl"},ExampleStringImpl.prototype.kind=function(){return"ExampleString"},ExampleStringImpl.prototype.RAMLVersion=function(){return"RAML08"},ExampleStringImpl}(StringTypeImpl);exports.ExampleStringImpl=ExampleStringImpl;var JSONExampleImpl=function(_super){function JSONExampleImpl(){_super.apply(this,arguments)}return __extends(JSONExampleImpl,_super),JSONExampleImpl.prototype.wrapperClassName=function(){return"JSONExampleImpl"},JSONExampleImpl.prototype.kind=function(){return"JSONExample"},JSONExampleImpl.prototype.RAMLVersion=function(){return"RAML08"},JSONExampleImpl}(ExampleStringImpl);exports.JSONExampleImpl=JSONExampleImpl;var XMLExampleImpl=function(_super){function XMLExampleImpl(){_super.apply(this,arguments)}return __extends(XMLExampleImpl,_super),XMLExampleImpl.prototype.wrapperClassName=function(){return"XMLExampleImpl"},XMLExampleImpl.prototype.kind=function(){return"XMLExample"},XMLExampleImpl.prototype.RAMLVersion=function(){return"RAML08"},XMLExampleImpl}(ExampleStringImpl);exports.XMLExampleImpl=XMLExampleImpl;var XMLBodyImpl=function(_super){function XMLBodyImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createXMLBody(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(XMLBodyImpl,_super),XMLBodyImpl.prototype.schema=function(){return _super.prototype.attribute.call(this,"schema",function(attr){return new XMLSchemaStringImpl(attr)})},XMLBodyImpl.prototype.wrapperClassName=function(){return"XMLBodyImpl"},XMLBodyImpl.prototype.kind=function(){return"XMLBody"},XMLBodyImpl.prototype.RAMLVersion=function(){return"RAML08"},XMLBodyImpl}(BodyLikeImpl);exports.XMLBodyImpl=XMLBodyImpl;var JSONBodyImpl=function(_super){function JSONBodyImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createJSONBody(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(JSONBodyImpl,_super),JSONBodyImpl.prototype.schema=function(){return _super.prototype.attribute.call(this,"schema",function(attr){return new JSonSchemaStringImpl(attr)})},JSONBodyImpl.prototype.wrapperClassName=function(){return"JSONBodyImpl"},JSONBodyImpl.prototype.kind=function(){return"JSONBody"},JSONBodyImpl.prototype.RAMLVersion=function(){return"RAML08"},JSONBodyImpl}(BodyLikeImpl);exports.JSONBodyImpl=JSONBodyImpl;var SecuritySchemeRefImpl=function(_super){function SecuritySchemeRefImpl(){_super.apply(this,arguments)}return __extends(SecuritySchemeRefImpl,_super),SecuritySchemeRefImpl.prototype.wrapperClassName=function(){return"SecuritySchemeRefImpl"},SecuritySchemeRefImpl.prototype.kind=function(){return"SecuritySchemeRef"},SecuritySchemeRefImpl.prototype.RAMLVersion=function(){return"RAML08"},SecuritySchemeRefImpl.prototype.securitySchemeName=function(){return helper.securitySchemeName(this)},SecuritySchemeRefImpl.prototype.securityScheme=function(){return helper.securityScheme(this)},SecuritySchemeRefImpl}(ReferenceImpl);exports.SecuritySchemeRefImpl=SecuritySchemeRefImpl;var AbstractSecuritySchemeImpl=function(_super){function AbstractSecuritySchemeImpl(){_super.apply(this,arguments)}return __extends(AbstractSecuritySchemeImpl,_super),AbstractSecuritySchemeImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},AbstractSecuritySchemeImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},AbstractSecuritySchemeImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",this.toString)},AbstractSecuritySchemeImpl.prototype.setType=function(param){return this.highLevel().attrOrCreate("type").setValue(""+param),this},AbstractSecuritySchemeImpl.prototype.description=function(){
return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},AbstractSecuritySchemeImpl.prototype.describedBy=function(){return _super.prototype.element.call(this,"describedBy")},AbstractSecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},AbstractSecuritySchemeImpl.prototype.wrapperClassName=function(){return"AbstractSecuritySchemeImpl"},AbstractSecuritySchemeImpl.prototype.kind=function(){return"AbstractSecurityScheme"},AbstractSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},AbstractSecuritySchemeImpl}(core.BasicNodeImpl);exports.AbstractSecuritySchemeImpl=AbstractSecuritySchemeImpl;var SecuritySchemePartImpl=function(_super){function SecuritySchemePartImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createSecuritySchemePart(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(SecuritySchemePartImpl,_super),SecuritySchemePartImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},SecuritySchemePartImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},SecuritySchemePartImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},SecuritySchemePartImpl.prototype.headers=function(){return _super.prototype.elements.call(this,"headers")},SecuritySchemePartImpl.prototype.queryParameters=function(){return _super.prototype.elements.call(this,"queryParameters")},SecuritySchemePartImpl.prototype.responses=function(){return _super.prototype.elements.call(this,"responses")},SecuritySchemePartImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},SecuritySchemePartImpl.prototype.wrapperClassName=function(){return"SecuritySchemePartImpl"},SecuritySchemePartImpl.prototype.kind=function(){return"SecuritySchemePart"},SecuritySchemePartImpl.prototype.RAMLVersion=function(){return"RAML08"},SecuritySchemePartImpl}(MethodBaseImpl);exports.SecuritySchemePartImpl=SecuritySchemePartImpl;var TraitRefImpl=function(_super){function TraitRefImpl(){_super.apply(this,arguments)}return __extends(TraitRefImpl,_super),TraitRefImpl.prototype.wrapperClassName=function(){return"TraitRefImpl"},TraitRefImpl.prototype.kind=function(){return"TraitRef"},TraitRefImpl.prototype.RAMLVersion=function(){return"RAML08"},TraitRefImpl.prototype.trait=function(){return helper.referencedTrait(this)},TraitRefImpl}(ReferenceImpl);exports.TraitRefImpl=TraitRefImpl;var TraitImpl=function(_super){function TraitImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createTrait(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(TraitImpl,_super),TraitImpl.prototype.name=function(){return _super.prototype.attribute.call(this,"name",this.toString)},TraitImpl.prototype.setName=function(param){return this.highLevel().attrOrCreate("name").setValue(""+param),this},TraitImpl.prototype.usage=function(){return _super.prototype.attribute.call(this,"usage",this.toString)},TraitImpl.prototype.setUsage=function(param){return this.highLevel().attrOrCreate("usage").setValue(""+param),this},TraitImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},TraitImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},TraitImpl.prototype.wrapperClassName=function(){return"TraitImpl"},TraitImpl.prototype.kind=function(){return"Trait"},TraitImpl.prototype.RAMLVersion=function(){return"RAML08"},TraitImpl.prototype.parametrizedProperties=function(){return helper.getTemplateParametrizedProperties(this)},TraitImpl}(MethodBaseImpl);exports.TraitImpl=TraitImpl;var SecuritySchemeSettingsImpl=function(_super){function SecuritySchemeSettingsImpl(){_super.apply(this,arguments)}return __extends(SecuritySchemeSettingsImpl,_super),SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"SecuritySchemeSettingsImpl"},SecuritySchemeSettingsImpl.prototype.kind=function(){return"SecuritySchemeSettings"},SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML08"},SecuritySchemeSettingsImpl}(core.BasicNodeImpl);exports.SecuritySchemeSettingsImpl=SecuritySchemeSettingsImpl;var OAuth1SecuritySchemeSettingsImpl=function(_super){function OAuth1SecuritySchemeSettingsImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth1SecuritySchemeSettings(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth1SecuritySchemeSettingsImpl,_super),OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri=function(){return _super.prototype.attribute.call(this,"requestTokenUri",function(attr){return new FixedUriImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri=function(){return _super.prototype.attribute.call(this,"authorizationUri",function(attr){return new FixedUriImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri=function(){return _super.prototype.attribute.call(this,"tokenCredentialsUri",function(attr){return new FixedUriImpl(attr)})},OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeSettingsImpl"},OAuth1SecuritySchemeSettingsImpl.prototype.kind=function(){return"OAuth1SecuritySchemeSettings"},OAuth1SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML08"},OAuth1SecuritySchemeSettingsImpl}(SecuritySchemeSettingsImpl);exports.OAuth1SecuritySchemeSettingsImpl=OAuth1SecuritySchemeSettingsImpl;var FixedUriImpl=function(_super){function FixedUriImpl(){_super.apply(this,arguments)}return __extends(FixedUriImpl,_super),FixedUriImpl.prototype.wrapperClassName=function(){return"FixedUriImpl"},FixedUriImpl.prototype.kind=function(){return"FixedUri"},FixedUriImpl.prototype.RAMLVersion=function(){return"RAML08"},FixedUriImpl}(StringTypeImpl);exports.FixedUriImpl=FixedUriImpl;var OAuth2SecuritySchemeSettingsImpl=function(_super){function OAuth2SecuritySchemeSettingsImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth2SecuritySchemeSettings(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth2SecuritySchemeSettingsImpl,_super),OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri=function(){return _super.prototype.attribute.call(this,"accessTokenUri",function(attr){return new FixedUriImpl(attr)})},OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri=function(){return _super.prototype.attribute.call(this,"authorizationUri",function(attr){return new FixedUriImpl(attr)})},OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants=function(){return _super.prototype.attributes.call(this,"authorizationGrants",this.toString)},OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants=function(param){return this.highLevel().attrOrCreate("authorizationGrants").setValue(""+param),this},OAuth2SecuritySchemeSettingsImpl.prototype.scopes=function(){return _super.prototype.attributes.call(this,"scopes",this.toString)},OAuth2SecuritySchemeSettingsImpl.prototype.setScopes=function(param){return this.highLevel().attrOrCreate("scopes").setValue(""+param),this},OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeSettingsImpl"},OAuth2SecuritySchemeSettingsImpl.prototype.kind=function(){return"OAuth2SecuritySchemeSettings"},OAuth2SecuritySchemeSettingsImpl.prototype.RAMLVersion=function(){return"RAML08"},OAuth2SecuritySchemeSettingsImpl}(SecuritySchemeSettingsImpl);exports.OAuth2SecuritySchemeSettingsImpl=OAuth2SecuritySchemeSettingsImpl;var OAuth2SecuritySchemeImpl=function(_super){function OAuth2SecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth2SecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth2SecuritySchemeImpl,_super),OAuth2SecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},OAuth2SecuritySchemeImpl.prototype.wrapperClassName=function(){return"OAuth2SecuritySchemeImpl"},OAuth2SecuritySchemeImpl.prototype.kind=function(){return"OAuth2SecurityScheme"},OAuth2SecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},OAuth2SecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.OAuth2SecuritySchemeImpl=OAuth2SecuritySchemeImpl;var OAuth1SecuritySchemeImpl=function(_super){function OAuth1SecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createOAuth1SecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(OAuth1SecuritySchemeImpl,_super),OAuth1SecuritySchemeImpl.prototype.settings=function(){return _super.prototype.element.call(this,"settings")},OAuth1SecuritySchemeImpl.prototype.wrapperClassName=function(){return"OAuth1SecuritySchemeImpl"},OAuth1SecuritySchemeImpl.prototype.kind=function(){return"OAuth1SecurityScheme"},OAuth1SecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},OAuth1SecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.OAuth1SecuritySchemeImpl=OAuth1SecuritySchemeImpl;var BasicSecuritySchemeImpl=function(_super){function BasicSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createBasicSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(BasicSecuritySchemeImpl,_super),BasicSecuritySchemeImpl.prototype.wrapperClassName=function(){return"BasicSecuritySchemeImpl"},BasicSecuritySchemeImpl.prototype.kind=function(){return"BasicSecurityScheme"},BasicSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},BasicSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.BasicSecuritySchemeImpl=BasicSecuritySchemeImpl;var DigestSecuritySchemeImpl=function(_super){function DigestSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDigestSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DigestSecuritySchemeImpl,_super),DigestSecuritySchemeImpl.prototype.wrapperClassName=function(){return"DigestSecuritySchemeImpl"},DigestSecuritySchemeImpl.prototype.kind=function(){return"DigestSecurityScheme"},DigestSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},DigestSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.DigestSecuritySchemeImpl=DigestSecuritySchemeImpl;var CustomSecuritySchemeImpl=function(_super){function CustomSecuritySchemeImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createCustomSecurityScheme(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(CustomSecuritySchemeImpl,_super),CustomSecuritySchemeImpl.prototype.wrapperClassName=function(){return"CustomSecuritySchemeImpl"},CustomSecuritySchemeImpl.prototype.kind=function(){return"CustomSecurityScheme"},CustomSecuritySchemeImpl.prototype.RAMLVersion=function(){return"RAML08"},CustomSecuritySchemeImpl}(AbstractSecuritySchemeImpl);exports.CustomSecuritySchemeImpl=CustomSecuritySchemeImpl;var MethodImpl=function(_super){function MethodImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createMethod(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(MethodImpl,_super),MethodImpl.prototype.method=function(){return _super.prototype.attribute.call(this,"method",this.toString)},MethodImpl.prototype.setMethod=function(param){return this.highLevel().attrOrCreate("method").setValue(""+param),this},MethodImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},MethodImpl.prototype.wrapperClassName=function(){return"MethodImpl"},MethodImpl.prototype.kind=function(){return"Method"},MethodImpl.prototype.RAMLVersion=function(){return"RAML08"},MethodImpl.prototype.parentResource=function(){return helper.parentResource(this)},MethodImpl.prototype.ownerApi=function(){return helper.ownerApi(this)},MethodImpl.prototype.methodId=function(){return helper.methodId(this)},MethodImpl.prototype.allSecuredBy=function(){return helper.allSecuredBy(this)},MethodImpl}(MethodBaseImpl);exports.MethodImpl=MethodImpl;var MimeTypeImpl=function(_super){function MimeTypeImpl(){_super.apply(this,arguments)}return __extends(MimeTypeImpl,_super),MimeTypeImpl.prototype.wrapperClassName=function(){return"MimeTypeImpl"},MimeTypeImpl.prototype.kind=function(){return"MimeType"},MimeTypeImpl.prototype.RAMLVersion=function(){return"RAML08"},MimeTypeImpl}(StringTypeImpl);exports.MimeTypeImpl=MimeTypeImpl;var UriTemplateImpl=function(_super){function UriTemplateImpl(){_super.apply(this,arguments)}return __extends(UriTemplateImpl,_super),UriTemplateImpl.prototype.wrapperClassName=function(){return"UriTemplateImpl"},UriTemplateImpl.prototype.kind=function(){return"UriTemplate"},UriTemplateImpl.prototype.RAMLVersion=function(){return"RAML08"},UriTemplateImpl}(StringTypeImpl);exports.UriTemplateImpl=UriTemplateImpl;var RelativeUriStringImpl=function(_super){function RelativeUriStringImpl(){_super.apply(this,arguments)}return __extends(RelativeUriStringImpl,_super),RelativeUriStringImpl.prototype.wrapperClassName=function(){return"RelativeUriStringImpl"},RelativeUriStringImpl.prototype.kind=function(){return"RelativeUriString"},RelativeUriStringImpl.prototype.RAMLVersion=function(){return"RAML08"},RelativeUriStringImpl}(UriTemplateImpl);exports.RelativeUriStringImpl=RelativeUriStringImpl;var FullUriTemplateStringImpl=function(_super){function FullUriTemplateStringImpl(){_super.apply(this,arguments)}return __extends(FullUriTemplateStringImpl,_super),FullUriTemplateStringImpl.prototype.wrapperClassName=function(){return"FullUriTemplateStringImpl"},FullUriTemplateStringImpl.prototype.kind=function(){return"FullUriTemplateString"},FullUriTemplateStringImpl.prototype.RAMLVersion=function(){return"RAML08"},FullUriTemplateStringImpl}(UriTemplateImpl);exports.FullUriTemplateStringImpl=FullUriTemplateStringImpl;var RAMLSimpleElementImpl=function(_super){function RAMLSimpleElementImpl(){_super.apply(this,arguments)}return __extends(RAMLSimpleElementImpl,_super),RAMLSimpleElementImpl.prototype.wrapperClassName=function(){return"RAMLSimpleElementImpl"},RAMLSimpleElementImpl.prototype.kind=function(){return"RAMLSimpleElement"},RAMLSimpleElementImpl.prototype.RAMLVersion=function(){return"RAML08"},RAMLSimpleElementImpl}(core.BasicNodeImpl);exports.RAMLSimpleElementImpl=RAMLSimpleElementImpl;var DocumentationItemImpl=function(_super){function DocumentationItemImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createDocumentationItem(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(DocumentationItemImpl,_super),DocumentationItemImpl.prototype.title=function(){return _super.prototype.attribute.call(this,"title",this.toString)},DocumentationItemImpl.prototype.setTitle=function(param){return this.highLevel().attrOrCreate("title").setValue(""+param),this},DocumentationItemImpl.prototype.content=function(){return _super.prototype.attribute.call(this,"content",function(attr){return new MarkdownStringImpl(attr)})},DocumentationItemImpl.prototype.wrapperClassName=function(){return"DocumentationItemImpl"},DocumentationItemImpl.prototype.kind=function(){return"DocumentationItem"},DocumentationItemImpl.prototype.RAMLVersion=function(){return"RAML08"},DocumentationItemImpl}(RAMLSimpleElementImpl);exports.DocumentationItemImpl=DocumentationItemImpl;var GlobalSchemaImpl=function(_super){function GlobalSchemaImpl(nodeOrKey,setAsTopLevel){_super.call(this,"string"==typeof nodeOrKey?createGlobalSchema(nodeOrKey):nodeOrKey,setAsTopLevel),this.nodeOrKey=nodeOrKey,this.setAsTopLevel=setAsTopLevel}return __extends(GlobalSchemaImpl,_super),GlobalSchemaImpl.prototype.key=function(){return _super.prototype.attribute.call(this,"key",this.toString)},GlobalSchemaImpl.prototype.setKey=function(param){return this.highLevel().attrOrCreate("key").setValue(""+param),this},GlobalSchemaImpl.prototype.value=function(){return _super.prototype.attribute.call(this,"value",function(attr){return new SchemaStringImpl(attr)})},GlobalSchemaImpl.prototype.wrapperClassName=function(){return"GlobalSchemaImpl"},GlobalSchemaImpl.prototype.kind=function(){return"GlobalSchema"},GlobalSchemaImpl.prototype.RAMLVersion=function(){return"RAML08"},GlobalSchemaImpl}(RAMLSimpleElementImpl);exports.GlobalSchemaImpl=GlobalSchemaImpl;var ResourceImpl=function(_super){function ResourceImpl(){_super.apply(this,arguments)}return __extends(ResourceImpl,_super),ResourceImpl.prototype.relativeUri=function(){return _super.prototype.attribute.call(this,"relativeUri",function(attr){return new RelativeUriStringImpl(attr)})},ResourceImpl.prototype.type=function(){return _super.prototype.attribute.call(this,"type",function(attr){return new ResourceTypeRefImpl(attr)})},ResourceImpl.prototype.is=function(){return _super.prototype.attributes.call(this,"is",function(attr){return new TraitRefImpl(attr)})},ResourceImpl.prototype.securedBy=function(){return _super.prototype.attributes.call(this,"securedBy",function(attr){return new SecuritySchemeRefImpl(attr)})},ResourceImpl.prototype.uriParameters_original=function(){return _super.prototype.elements.call(this,"uriParameters")},ResourceImpl.prototype.methods=function(){return _super.prototype.elements.call(this,"methods")},ResourceImpl.prototype.resources=function(){return _super.prototype.elements.call(this,"resources")},ResourceImpl.prototype.displayName=function(){return _super.prototype.attribute.call(this,"displayName",this.toString)},ResourceImpl.prototype.setDisplayName=function(param){return this.highLevel().attrOrCreate("displayName").setValue(""+param),this},ResourceImpl.prototype.baseUriParameters=function(){return _super.prototype.elements.call(this,"baseUriParameters")},ResourceImpl.prototype.description=function(){return _super.prototype.attribute.call(this,"description",function(attr){return new MarkdownStringImpl(attr)})},ResourceImpl.prototype.wrapperClassName=function(){return"ResourceImpl"},ResourceImpl.prototype.kind=function(){return"Resource"},ResourceImpl.prototype.RAMLVersion=function(){return"RAML08"},ResourceImpl.prototype.completeRelativeUri=function(){return helper.completeRelativeUri(this)},ResourceImpl.prototype.absoluteUri=function(){return helper.absoluteUri(this)},ResourceImpl.prototype.parentResource=function(){return helper.parent(this)},ResourceImpl.prototype.childResource=function(relPath){return helper.childResource(this,relPath)},ResourceImpl.prototype.childMethod=function(method){return helper.childMethod(this,method)},ResourceImpl.prototype.ownerApi=function(){return helper.ownerApi(this)},ResourceImpl.prototype.uriParameters=function(){return helper.uriParametersPrimary(this)},ResourceImpl.prototype.allUriParameters=function(){return helper.uriParameters(this)},ResourceImpl.prototype.absoluteUriParameters=function(){return helper.absoluteUriParameters(this)},ResourceImpl.prototype.allSecuredBy=function(){return helper.allSecuredBy(this)},ResourceImpl}(core.BasicNodeImpl);exports.ResourceImpl=ResourceImpl,exports.loadApiSync=loadApiSync,exports.loadRAMLSync=loadRAMLSync,exports.loadApi=loadApi,exports.loadRAML=loadRAML,exports.getLanguageElementByRuntimeType=getLanguageElementByRuntimeType},function(module,exports,__webpack_require__){"use strict";function load(pth){var m=new ll.Project(path.dirname(pth)),unit=m.unit(path.basename(pth));return unit&&unit.isRAMLUnit()?hlimpl.fromUnit(unit).wrapperNode():null}function expandTraitsAndResourceTypes(api){var lowLevelNode=api.highLevel().lowLevel();return lowLevelNode instanceof lowLevelProxy.LowLevelProxyNode?api:expander.expandTraitsAndResourceTypes(api)}function completeRelativeUri(res){var uri="",parent=res;do res=parent,uri=res.relativeUri().value()+uri,parent=res.parent();while(parent.definition().key().name==universes.Universe08.Resource.name);return uri}function absoluteUri(res){var uri="",parent=res;do res=parent,uri=res.relativeUri().value()+uri,parent=res.parent();while(parent.definition().key().name==universes.Universe08.Resource.name);uri=uri.replace(/\/\//g,"/");var buri=parent.baseUri(),base=buri?buri.value():"";return base=base?base:"",util.stringEndsWith(base,"/")&&(uri=uri.substring(1)),uri=base+uri}function qName(c){return hlimpl.qName(c.highLevel(),c.highLevel().root())}function traitsPrimary(a){return allTraits(a)}function allTraits(a){return findTemplates(a,function(d){return universeHelpers.isTraitType(d)})}function resourceTypesPrimary(a){return allResourceTypes(a)}function allResourceTypes(a){return findTemplates(a,function(d){return universeHelpers.isResourceTypeType(d)})}function findTemplates(a,filter){var arr=search.globalDeclarations(a.highLevel()).filter(function(x){return filter(x.definition())}),ll=a.highLevel().lowLevel(),nodePath=ll.includePath();nodePath||(nodePath=ll.unit().path());var topLevelArr=arr.map(function(x){var topLevelNode,p=x.lowLevel().unit().path();return p!=nodePath?(topLevelNode=factory.buildWrapperNode(x,!1),topLevelNode.meta().setCalculated()):topLevelNode=x.wrapperNode(),topLevelNode});return topLevelArr}function relativeUriSegments(res){var result=[],parent=res;do res=parent,result.push(res.relativeUri().value()),parent=res.parent();while(parent.definition().key().name==universes.Universe08.Resource.name);return result.reverse()}function parentResource(method){return method.parent()instanceof RamlWrapperImpl.ResourceImpl?method.parent():null}function parent(resource){var parent=resource.parent();return parent.definition().key().name==universes.Universe08.Resource.name,null}function childResource(container,relPath){if(null==container)return null;var resources=container.resources();return resources?(resources=resources.filter(function(x){return x.relativeUri().value()==relPath}),0==resources.length?null:resources[0]):null}function getResource(container,path){if(!container)return null;for(var res=null,i=0;i<path.length;i++){if(res=childResource(container,path[i]),!res)return null;container=res}return res}function childMethod(resource,method){return resource?resource.methods().filter(function(x){return x.method()==method}):null}function getMethod(container,path,method){var resource=getResource(container,path);return null==resource?null:childMethod(resource,method)}function isApi(obj){return obj.definition().key().name==universes.Universe08.Api.name}function ownerApi(method){for(var obj=method;!isApi(obj);)obj=obj.parent();return obj}function methodId(method){var parent=method.parent();if(parent instanceof RamlWrapperImpl.ResourceImpl)return completeRelativeUri(parent)+" "+method.method().toLowerCase();if(parent instanceof RamlWrapperImpl.ResourceTypeImpl)return parent.name()+" "+method.method().toLowerCase();throw new Error("Method is supposed to be owned by Resource or ResourceType.\nHere the method is owned by "+method.definition().key().name)}function isOkRange(response){var str=response.code().value(),err=linter.validateResponseString(str);if(null!=err)return!1;try{if(parseInt(str.charAt(0))<4)return!0}catch(e){}return!1}function allResources(api){var resources=[],visitor=function(res){resources.push(res),res.resources().forEach(function(x){return visitor(x)})};return api.resources().forEach(function(x){return visitor(x)}),resources}function uriParametersPrimary(resource){return uriParameters(resource)}function uriParameters(resource){var uri=resource.relativeUri().value(),params=resource.uriParameters_original(),propName=universes.Universe08.Resource.properties.uriParameters.name;return extractParams(params,uri,resource,propName)}function baseUriParametersPrimary(api){return baseUriParameters(api)}function baseUriParameters(api){var uri=api.baseUri()?api.baseUri().value():"",params=api.baseUriParameters_original(),propName=universes.Universe08.Api.properties.baseUriParameters.name;return extractParams(params,uri,api,propName)}function absoluteUriParameters(res){var params=[],parent=res;do res=parent,params=uriParameters(res).concat(params),parent=res.parent();while(parent.definition().key().name==universes.Universe10.Resource.name);var api=parent;api.baseUriParameters();return params=baseUriParameters(api).concat(params)}function protocolsPrimary(api){return allProtocols(api)}function allProtocols(api){return api.protocols().map(function(x){return x.toUpperCase()})}function securedByPrimary(resourceOrMethod){return allSecuredBy(resourceOrMethod)}function allSecuredBy(resourceOrMethod){return resourceOrMethod.securedBy()}function securitySchemeName(schemeReference){var highLevel=schemeReference.highLevel();if(!highLevel)return"";var attributeValue=highLevel.value();return attributeValue?attributeValue.toString():""}function securityScheme(schemeReference){var highLevel=schemeReference.highLevel();if(!highLevel)return null;var declaration=search.findDeclarationByNode(highLevel,search.LocationKind.VALUE_COMPLETION);if(!declaration)return null;if(!declaration.getKind||declaration.getKind()!=hl.NodeKind.NODE)return null;var result=declaration.wrapperNode();return result instanceof RamlWrapperImpl.AbstractSecuritySchemeImpl?result:null}function RAMLVersion(api){return api.highLevel().definition().universe().version()}function structuredValue(reference){var hl=reference.value().lowLevel();return new core.TypeInstanceImpl(hl)}function referenceName(reference){var val=reference.highLevel().value();return"string"==typeof val||null==val?val:val.valueName()}function referencedTrait(ref){return referencedObject(ref)}function referencedResourceType(ref){return referencedObject(ref)}function referencedObject(ref){var attr=ref.highLevel(),parent=attr.parent(),vn=ref.name(),cands=search.referenceTargets(attr.property(),parent).filter(function(x){return hlimpl.qName(x,parent)==vn});return 0==cands.length?null:cands[0].wrapperNode()}function extractParams(params,uri,owner,propName){var ownerHl=owner.highLevel(),prop=ownerHl.definition().property(propName);if(!uri)return[];var describedParams={};params.forEach(function(x){var arr=describedParams[x.name()];arr||(arr=[],describedParams[x.name()]=arr),arr.push(x)});for(var allParams=[],prev=0,mentionedParams={},i=uri.indexOf("{");i>=0;i=uri.indexOf("{",prev)){prev=uri.indexOf("}",++i);var paramName=uri.substring(i,prev);if(mentionedParams[paramName]=!0,describedParams[paramName])describedParams[paramName].forEach(function(x){return allParams.push(x)});else{var uriParameter=new RamlWrapperImpl.StringTypeDeclarationImpl(paramName);uriParameter.setName(paramName);var hlNode=uriParameter.highLevel();hlNode.setParent(ownerHl),uriParameter.meta().setCalculated(),hlNode.patchProp(prop),allParams.push(uriParameter)}}return Object.keys(describedParams).filter(function(x){return!mentionedParams[x]}).forEach(function(x){return describedParams[x].forEach(function(y){return allParams.push(y)})}),allParams}function schemaContent(bodyDeclaration){var schemaDecl=bodyDeclaration.schema();if(null==schemaDecl)return null;var schemaString=schemaDecl.value();if(!schemaString)return null;var schemaAttribute=bodyDeclaration.highLevel().attr(universes.Universe08.BodyLike.properties.schema.name);if(!schemaAttribute)return schemaString;var declaration=search.findDeclarationByNode(schemaAttribute,search.LocationKind.VALUE_COMPLETION);if(!declaration)return schemaString;if(!declaration.getKind||declaration.getKind()!=hl.NodeKind.NODE)return schemaString;if(declaration.definition().key()!=universes.Universe08.GlobalSchema)return schemaString;var valueAttribute=declaration.attr(universes.Universe08.GlobalSchema.properties.value.name);return null==valueAttribute?null:valueAttribute.value()}function getTemplateParametrizedProperties(node){var highLevelNode=node.highLevel();if(null==highLevelNode)return null;var lowLevelNode=highLevelNode.lowLevel();if(null==lowLevelNode)return null;var children=lowLevelNode.children().filter(function(x){return x.key().indexOf("<<")>=0});if(0==children.length)return null;var result=new core.TypeInstanceImpl(children);return result}var RamlWrapperImpl=__webpack_require__(47),factory=__webpack_require__(43),core=__webpack_require__(45),hl=__webpack_require__(10),hlimpl=__webpack_require__(16),universes=__webpack_require__(22),expander=__webpack_require__(24),lowLevelProxy=__webpack_require__(38),linter=__webpack_require__(25),util=__webpack_require__(31),search=__webpack_require__(23),universeHelpers=__webpack_require__(14),ll=__webpack_require__(27),path=__webpack_require__(15);exports.load=load,exports.expandTraitsAndResourceTypes=expandTraitsAndResourceTypes,exports.completeRelativeUri=completeRelativeUri,exports.absoluteUri=absoluteUri,exports.qName=qName,exports.traitsPrimary=traitsPrimary,exports.allTraits=allTraits,exports.resourceTypesPrimary=resourceTypesPrimary,exports.allResourceTypes=allResourceTypes,exports.relativeUriSegments=relativeUriSegments,exports.parentResource=parentResource,exports.parent=parent,exports.childResource=childResource,exports.getResource=getResource,exports.childMethod=childMethod,exports.getMethod=getMethod,exports.ownerApi=ownerApi,exports.methodId=methodId,exports.isOkRange=isOkRange,exports.allResources=allResources;exports.uriParametersPrimary=uriParametersPrimary,exports.uriParameters=uriParameters,exports.baseUriParametersPrimary=baseUriParametersPrimary,exports.baseUriParameters=baseUriParameters,exports.absoluteUriParameters=absoluteUriParameters,exports.protocolsPrimary=protocolsPrimary,exports.allProtocols=allProtocols,exports.securedByPrimary=securedByPrimary,exports.allSecuredBy=allSecuredBy,exports.securitySchemeName=securitySchemeName,exports.securityScheme=securityScheme,exports.RAMLVersion=RAMLVersion,exports.structuredValue=structuredValue,exports.referenceName=referenceName,exports.referencedTrait=referencedTrait,exports.referencedResourceType=referencedResourceType,exports.schemaContent=schemaContent,exports.getTemplateParametrizedProperties=getTemplateParametrizedProperties},function(module,exports,__webpack_require__){"use strict";function escapeTemplateParameters(str){if(null==str||"string"!=typeof str)return{status:ParametersEscapingStatus.NOT_REQUIRED};for(var resultingString="",map={},prev=0,i=str.indexOf("<<");i>=0;i=str.indexOf("<<",prev)){if(resultingString+=str.substring(prev,i),prev=str.indexOf(">>",i),prev<0)return{status:ParametersEscapingStatus.ERROR};prev+=">>".length;var paramStr=str.substring(i,prev),substitution=PARAM_OCCURENCE_STR+i+PARAM_OCCURENCE_STR;map[substitution]=paramStr,resultingString+=substitution}return 0==resultingString.length?{status:ParametersEscapingStatus.NOT_REQUIRED}:(resultingString+=str.substring(prev,str.length),{resultingString:resultingString,substitutions:map,status:ParametersEscapingStatus.OK})}function unescapeTemplateParameters(str,substitutions){if(null==str)return{status:ParametersEscapingStatus.NOT_REQUIRED};for(var resultingString="",prev=0,i=str.indexOf(PARAM_OCCURENCE_STR);i>=0;i=str.indexOf(PARAM_OCCURENCE_STR,prev)){if(prev=str.indexOf(PARAM_OCCURENCE_STR,i+1),prev+=PARAM_OCCURENCE_STR.length,prev<0)return{status:ParametersEscapingStatus.ERROR};var substitution=str.substring(i,prev),originalParamOccurence=substitutions[substitution];if(null==originalParamOccurence)return{status:ParametersEscapingStatus.ERROR};resultingString+=originalParamOccurence;
}return 0==resultingString.length?{status:ParametersEscapingStatus.NOT_REQUIRED}:(resultingString+=str.substring(prev,str.length),{resultingString:resultingString,substitutions:substitutions,status:ParametersEscapingStatus.OK})}function checkExpression(value){for(var gotExpression=!1,i=0;i<value.length;i++){var ch=value.charAt(i);if("|"==ch||"("==ch||"["==ch){gotExpression=!0;break}}return gotExpression}function patchMethodIs(node,traits){var llMethod=node.lowLevel(),ramlVersion=node.definition().universe().version(),originalLlMethod=toOriginal(llMethod),isPropertyName=universeDef.Universe10.MethodBase.properties.is.name,isNode=_.find(llMethod.children(),function(x){return x.key()==isPropertyName});if(null==isNode){var newLLIsNode=new jsyaml.ASTNode(yaml.newMapping(yaml.newScalar(isPropertyName),yaml.newItems()),originalLlMethod.unit(),originalLlMethod,null,null);isNode=llMethod.replaceChild(null,newLLIsNode)}var originalIsNode=_.find(originalLlMethod.children(),function(x){return x.key()==isPropertyName}),childrenToPreserve=null!=originalIsNode?originalIsNode.children():[],newTraits=childrenToPreserve.concat(traits.map(function(x){var llChNode=prepareTraitRefNode(x.node,isNode),cNode=new proxy.LowLevelCompositeNode(llChNode,isNode,x.transformer,ramlVersion);return cNode}));return isNode.setChildren(newTraits),isNode.filterChildren(),isNode}function prepareTraitRefNode(llNode,llParent){llParent=toOriginal(llParent),llNode=toOriginal(llNode);var yNode=llNode.actual();llNode.key()==universeDef.Universe10.MethodBase.properties.is.name&&(yNode=llNode.yamlNode().value),yNode.kind==yaml.Kind.SEQ&&(yNode=yNode.items[0]);var result=new jsyaml.ASTNode(yNode,llNode.unit(),llParent,null,null);return result}function toOriginal(node){for(var i=0;i<2&&node instanceof proxy.LowLevelProxyNode;i++)node=node.originalNode();return node}var hlimpl=__webpack_require__(16),yaml=__webpack_require__(70),jsyaml=__webpack_require__(27),proxy=__webpack_require__(38),universeDef=__webpack_require__(22),_=__webpack_require__(61),universeHelpers=__webpack_require__(14),namespaceResolver=__webpack_require__(54),def=__webpack_require__(36),typeExpressions=def.rt.typeExpressions,ReferencePatcher=function(){function ReferencePatcher(){}return ReferencePatcher.prototype.process=function(hlNode,rootNode,removeUses,patchNodeName){void 0===rootNode&&(rootNode=hlNode),void 0===removeUses&&(removeUses=!1),void 0===patchNodeName&&(patchNodeName=!1);var resolver=hlNode.lowLevel().unit().project().namespaceResolver();this.patchReferences(hlNode,rootNode,resolver),patchNodeName&&this.patchNodeName(hlNode,rootNode.lowLevel().unit(),resolver),removeUses?this.removeUses(hlNode.lowLevel()):this.patchUses(hlNode.lowLevel(),resolver),this.resetTypes(hlNode),hlNode.resetChildren()},ReferencePatcher.prototype.patchReferences=function(node,rootNode,resolver,units){void 0===rootNode&&(rootNode=node),void 0===resolver&&(resolver=new namespaceResolver.NamespaceResolver),void 0===units&&(units=[rootNode.lowLevel().unit()]);var isNode;if(null!=node.definition().property(universeDef.Universe10.TypeDeclaration.properties.annotations.name)){var cNode=node.lowLevel(),isPropertyName=universeDef.Universe10.MethodBase.properties.is.name,traitNodes=node.attributes(isPropertyName);cNode.preserveAnnotations(),node.resetChildren(),0!=traitNodes.length&&(isNode=patchMethodIs(node,traitNodes.map(function(x){return x.lowLevel()}).map(function(x){return{node:x,transformer:x.transformer()}})))}for(var attrs=node.attrs(),_i=0,attrs_1=attrs;_i<attrs_1.length;_i++){var attr=attrs_1[_i],appended=this.appendUnitIfNeeded(attr,units);this.patchReferenceAttr(attr,rootNode,resolver,units),this.popUnitIfNeeded(units,appended)}if(universeHelpers.isTypeDeclarationSibling(node.definition())){var appended=this.appendUnitIfNeeded(node,units);this.patchType(node,rootNode,resolver,units),this.popUnitIfNeeded(units,appended)}for(var childNodes=node.elements(),_a=0,childNodes_1=childNodes;_a<childNodes_1.length;_a++){var ch=childNodes_1[_a],appended=this.appendUnitIfNeeded(ch,units);this.patchReferences(ch,rootNode,resolver,units),this.popUnitIfNeeded(units,appended)}isNode&&isNode.filterChildren()},ReferencePatcher.prototype.patchReferenceAttr=function(attr,rootNode,resolver,units){var property=attr.property();if(property.range().isAssignableFrom(universeDef.Universe10.Reference.name)){var value=attr.value();if(null!=value){var llNode=attr.lowLevel(),transformer=llNode.transformer(),isAnnotation=universeHelpers.isAnnotationsProperty(property);if("string"==typeof value){var stringToPatch=value;if(null!=transformer){var actualNode=toOriginal(llNode);stringToPatch=actualNode.value()}isAnnotation&&(stringToPatch=stringToPatch.substring(1,stringToPatch.length-1));var newValue=this.patchTypeName(stringToPatch,rootNode.lowLevel().unit(),units,resolver,transformer,isAnnotation);null!=newValue&&(isAnnotation&&(newValue="("+newValue+")"),attr.lowLevel().setValueOverride(newValue))}else{var sValue=value,key=sValue.lowLevel().key(),stringToPatch=key;if(null!=transformer){var actualNode=toOriginal(sValue.lowLevel());stringToPatch=actualNode.key()}if(null!=key){isAnnotation&&(stringToPatch=stringToPatch.substring(1,stringToPatch.length-1));var newValue=this.patchTypeName(stringToPatch,rootNode.lowLevel().unit(),units,resolver,transformer,isAnnotation);null!=newValue&&(isAnnotation&&(newValue="("+newValue+")"),sValue.lowLevel().setKeyOverride(newValue))}}}}},ReferencePatcher.prototype.patchType=function(node,rootNode,resolver,units){var _this=this;if(!node.localType().isExternal())for(var rootUnit=rootNode.lowLevel().unit(),rootPath=rootUnit.absolutePath(),typeAttributes=node.attributes(universeDef.Universe10.TypeDeclaration.properties.type.name),_i=0,typeAttributes_1=typeAttributes;_i<typeAttributes_1.length;_i++){var typeAttr=typeAttributes_1[_i],localUnit=typeAttr.lowLevel().unit(),localPath=localUnit.absolutePath();if(localPath!=rootPath){var value=typeAttr.value();if("string"==typeof value){var gotExpression=checkExpression(value),llNode=typeAttr.lowLevel(),transformer=llNode.transformer(),stringToPatch=value,escapeData={status:ParametersEscapingStatus.NOT_REQUIRED},additionalUnits=transformer?transformer.unitsChain:null;if(null!=transformer||value.indexOf("<<")>=0){var actualNode=toOriginal(llNode),actualValue=actualNode.value();escapeData=escapeTemplateParameters(actualValue),escapeData.status==ParametersEscapingStatus.OK?stringToPatch=gotExpression?escapeData.resultingString:actualValue:transformer=null}var appendedAdditional;if(additionalUnits){appendedAdditional=[];for(var _a=0,additionalUnits_1=additionalUnits;_a<additionalUnits_1.length;_a++){var u=additionalUnits_1[_a];appendedAdditional.push(this.appendUnitIfNeeded(u,units))}}var newValue,appendedAttrUnit=this.appendUnitIfNeeded(typeAttr,units);if(gotExpression){var expressionPatchFailed=!1,expr=typeExpressions.parse(stringToPatch),gotPatch=!1;typeExpressions.visit(expr,function(x){if("name"==x.type){var unescaped,lit=x,typeName=lit.value,unescapeData={status:ParametersEscapingStatus.NOT_REQUIRED};if(escapeData.status==ParametersEscapingStatus.OK)if(unescaped=escapeData.substitutions[typeName],null==unescaped){if(unescapeData=unescapeTemplateParameters(typeName,escapeData.substitutions),unescapeData.status==ParametersEscapingStatus.OK)typeName=unescapeData.resultingString;else if(unescapeData.status==ParametersEscapingStatus.ERROR)return void(expressionPatchFailed=!0)}else typeName=unescaped;if(null==transformer&&(null!=unescaped||unescapeData.status==ParametersEscapingStatus.OK))return void(lit.value=typeName);var patched=_this.patchTypeName(typeName,rootUnit,units,resolver,transformer);null!=patched&&(lit.value=patched,gotPatch=!0)}}),newValue=gotPatch&&!expressionPatchFailed?typeExpressions.serializeToString(expr):value}else escapeData.status==ParametersEscapingStatus.OK&&null==transformer||(newValue=this.patchTypeName(stringToPatch,rootUnit,units,resolver,transformer));if(null!=newValue&&(typeAttr.lowLevel().setValueOverride(newValue),typeAttr.overrideValue(null)),this.popUnitIfNeeded(units,appendedAttrUnit),appendedAdditional)for(var _b=0,_c=appendedAdditional.reverse();_b<_c.length;_b++){var ap=_c[_b];this.popUnitIfNeeded(units,ap)}}else{var llTypeNode=_.find(node.lowLevel().children(),function(x){return"type"==x.key()});if(llTypeNode){var def=node.definition().universe().type(universeDef.Universe10.TypeDeclaration.name),newNode=new hlimpl.ASTNodeImpl(llTypeNode,null,def,null),appended=this.appendUnitIfNeeded(newNode,units);this.patchReferences(newNode,rootNode,resolver,units),this.popUnitIfNeeded(units,appended)}}}}},ReferencePatcher.prototype.patchTypeName=function(stringToPatch,rootUnit,units,resolver,transformer,isAnnotation){var _this=this;void 0===isAnnotation&&(isAnnotation=!1);var newValue;if(transformer&&stringToPatch&&stringToPatch.indexOf("<<")>=0){var doContinue=!0,types=rootUnit.highLevel().types();newValue=transformer.transform(stringToPatch,!0,function(){return doContinue},function(val,tr){var newVal=_this.patchValue(val,rootUnit,resolver,tr.unitsChain);return null==newVal&&(newVal=val),isAnnotation?null!=types.getAnnotationType(newVal)&&(doContinue=!1):null!=types.getType(newVal)&&(doContinue=!1),newVal}).value}return void 0===newValue&&(newValue=this.patchValue(stringToPatch,rootUnit,resolver,units)),newValue},ReferencePatcher.prototype.patchNodeName=function(hlNode,rootUnit,resolver){var llNode=hlNode.lowLevel(),key=llNode.key(),patched=this.patchValue(key,rootUnit,resolver,[llNode.unit()]);null!=patched&&llNode.setKeyOverride(patched)},ReferencePatcher.prototype.patchValue=function(value,rootUnit,resolver,units){var referencedUnit,plainName,ind=value.lastIndexOf(".");if(ind>=0){var oldNS=value.substring(0,ind);plainName=value.substring(ind+1);for(var i=units.length;i>0;i--){var localUnit=units[i-1],nsMap=resolver.nsMap(localUnit);if(null!=nsMap){var info=nsMap[oldNS];if(null!=info&&(referencedUnit=info.unit,null!=referencedUnit))break}}}else{if(null!=def.rt.builtInTypes().get(value))return null;plainName=value,referencedUnit=units[units.length-1]}var newNS=resolver.resolveNamespace(rootUnit,referencedUnit);if(null==newNS)return null;var newValue=newNS+"."+plainName;return newValue},ReferencePatcher.prototype.patchUses=function(node,resolver){if(node instanceof proxy.LowLevelCompositeNode){var unit=node.unit(),extendedUnitMap=resolver.expandedPathMap(unit);if(null!=extendedUnitMap){var unitMap=resolver.pathMap(unit);unitMap||(unitMap={});for(var cNode=node,originalChildren=node.children(),usesNodes=originalChildren.filter(function(x){return x.key()==universeDef.Universe10.FragmentDeclaration.properties.uses.name}),oNode=toOriginal(node),yamlNode=oNode;yamlNode instanceof proxy.LowLevelProxyNode;)yamlNode=yamlNode.originalNode();var usesInfos=Object.keys(unitMap).map(function(x){return extendedUnitMap[x]}),extendedUsesInfos=Object.keys(extendedUnitMap).map(function(x){return extendedUnitMap[x]}).filter(function(x){return!unitMap[x.absolutePath()]}),u=node.unit(),newUses=(u.absolutePath(),jsyaml.createMapNode("uses"));newUses._parent=yamlNode,newUses.setUnit(yamlNode.unit());for(var _i=0,_a=usesInfos.concat(extendedUsesInfos);_i<_a.length;_i++){var ui=_a[_i],ip=(ui.absolutePath(),ui.includePath),mapping=jsyaml.createMapping(ui.namespace(),ip);mapping.setUnit(yamlNode.unit()),newUses.addChild(mapping)}for(usesNodes.length>0?cNode.replaceChild(usesNodes[0],newUses):cNode.replaceChild(null,newUses);node instanceof proxy.LowLevelProxyNode;)node=node.originalNode()}}},ReferencePatcher.prototype.removeUses=function(node){if(node instanceof proxy.LowLevelCompositeNode){var cNode=node,originalChildren=node.children(),usesNodes=originalChildren.filter(function(x){return x.key()==universeDef.Universe10.FragmentDeclaration.properties.uses.name});usesNodes.length>0&&cNode.removeChild(usesNodes[0])}},ReferencePatcher.prototype.resetTypes=function(hlNode){for(var _i=0,_a=hlNode.elements();_i<_a.length;_i++){var ch=_a[_i];this.resetTypes(ch)}delete hlNode.lowLevel().actual().types,delete hlNode._ptype,delete hlNode._types,hlNode.setAssociatedType(null)},ReferencePatcher.prototype.appendUnitIfNeeded=function(node,units){if(node instanceof jsyaml.CompilationUnit){var unit=node;return unit.absolutePath()!=units[units.length-1].absolutePath()&&(units.push(unit),!0)}var originalNode=toOriginal(node.lowLevel()),originalUnit=originalNode.unit();if(originalNode.valueKind()==yaml.Kind.INCLUDE_REF){var ref=originalNode.includePath(),includedUnit=originalUnit.resolve(ref);return units.push(includedUnit),!0}return originalUnit.absolutePath()!=units[units.length-1].absolutePath()&&(units.push(originalUnit),!0)},ReferencePatcher.prototype.popUnitIfNeeded=function(units,appended){appended&&units.pop()},ReferencePatcher}();exports.ReferencePatcher=ReferencePatcher;var ParametersEscapingStatus;!function(ParametersEscapingStatus){ParametersEscapingStatus[ParametersEscapingStatus.OK=0]="OK",ParametersEscapingStatus[ParametersEscapingStatus.NOT_REQUIRED=1]="NOT_REQUIRED",ParametersEscapingStatus[ParametersEscapingStatus.ERROR=2]="ERROR"}(ParametersEscapingStatus||(ParametersEscapingStatus={}));var PARAM_OCCURENCE_STR="__P_A_R_A_M_E_T_E_R__";exports.patchMethodIs=patchMethodIs,exports.prepareTraitRefNode=prepareTraitRefNode},function(module,exports,__webpack_require__){"use strict";function serialize(node,options){if(void 0===options&&(options={}),0==node.children().length)return node.value();if(node.children()[0].key()){var obj={};if(node.children().forEach(function(x){obj[escapeKey(x.key(),options)]=serialize(x,options)}),options&&options.writeErrors){var errors=collectErrors(node);null!=errors&&errors.length>0&&(obj.__$errors__=errors)}return obj}var arr=[];return node.children().forEach(function(x){arr.push(serialize(x,options))}),arr}function collectErrors(node){var errors=[].concat(node.errors());return node.children().forEach(function(ch){var children=ch.children();return 0==children.length?void ch.errors().forEach(function(e){return errors.push(e)}):void(children[0].key()||children.forEach(function(x){0==x.children().length&&x.errors().forEach(function(e){return errors.push(e)})}))}),errors}function escapeKey(key,options){return options&&key&&options.escapeNumericKeys&&0==key.replace(/\d/g,"").trim().length?"__$EscapedKey$__"+key:key}function unescapeKey(key,options){return key?(options=options||{},options.escapeNumericKeys&&util.stringStartsWith(key,"__$EscapedKey$__")&&0==key.substring("__$EscapedKey$__".length).replace(/\d/g,"").trim().length?key.substring("__$EscapedKey$__".length):key):key}var yaml=__webpack_require__(70),lowlevel=__webpack_require__(11),hlimpl=__webpack_require__(16),util=__webpack_require__(31),llImpl=__webpack_require__(27),Error=yaml.YAMLException,CompilationUnit=function(){function CompilationUnit(_absolutePath,_path,_content,_project,_isTopoLevel,serializeOptions){void 0===serializeOptions&&(serializeOptions={}),this._absolutePath=_absolutePath,this._path=_path,this._content=_content,this._project=_project,this._isTopoLevel=_isTopoLevel,this.serializeOptions=serializeOptions,this._node=new AstNode(this,JSON.parse(this._content),null,serializeOptions)}return CompilationUnit.prototype.highLevel=function(){return hlimpl.fromUnit(this)},CompilationUnit.prototype.absolutePath=function(){return this._absolutePath},CompilationUnit.prototype.clone=function(){return null},CompilationUnit.prototype.contents=function(){return this._content},CompilationUnit.prototype.lexerErrors=function(){return[]},CompilationUnit.prototype.path=function(){return this._content},CompilationUnit.prototype.isTopLevel=function(){return this._isTopoLevel},CompilationUnit.prototype.ast=function(){return this._node},CompilationUnit.prototype.expandedHighLevel=function(){return this.highLevel()},CompilationUnit.prototype.isDirty=function(){return!0},CompilationUnit.prototype.getIncludeNodes=function(){return[]},CompilationUnit.prototype.resolveAsync=function(p){return null},CompilationUnit.prototype.isRAMLUnit=function(){return!0},CompilationUnit.prototype.project=function(){return this._project},CompilationUnit.prototype.updateContent=function(newContent){},CompilationUnit.prototype.ramlVersion=function(){throw new Error("not implemented")},CompilationUnit.prototype.lineMapper=function(){return new lowlevel.LineMapperImpl(this.contents(),this.absolutePath())},CompilationUnit.prototype.resolve=function(p){return null},CompilationUnit.prototype.isOverlayOrExtension=function(){return!1},CompilationUnit.prototype.getMasterReferenceNode=function(){return null},CompilationUnit}();exports.CompilationUnit=CompilationUnit;var AstNode=function(){function AstNode(_unit,_object,_parent,options,_key){var _this=this;void 0===options&&(options={}),this._unit=_unit,this._object=_object,this._parent=_parent,this.options=options,this._key=_key,this._isOptional=!1,this._object instanceof Object&&Object.keys(this._object).forEach(function(x){var u=unescapeKey(x,_this.options);if(u!=x){var val=_this._object[x];delete _this._object[x],_this._object[u]=val}}),this._key&&util.stringEndsWith(this._key,"?")&&(this._isOptional=!0,this._key=this._key.substring(0,this._key.length-1))}return AstNode.prototype.keyKind=function(){return null},AstNode.prototype.isAnnotatedScalar=function(){return!1},AstNode.prototype.hasInnerIncludeError=function(){return!1},AstNode.prototype.start=function(){return-1},AstNode.prototype.end=function(){return-1},AstNode.prototype.value=function(){return this._object},AstNode.prototype.actual=function(){return this._object},AstNode.prototype.includeErrors=function(){return[]},AstNode.prototype.includePath=function(){return null},AstNode.prototype.includeReference=function(){return null},AstNode.prototype.key=function(){return this._key},AstNode.prototype.optional=function(){return this._isOptional},AstNode.prototype.children=function(){var _this=this;return this._object?Array.isArray(this._object)?this._object.map(function(x){return new AstNode(_this._unit,x,_this,_this.options)}):this._object instanceof Object?Object.keys(this._object).map(function(x){return new AstNode(_this._unit,_this._object[x],_this,_this.options,x)}):[]:[]},AstNode.prototype.parent=function(){return this._parent},AstNode.prototype.unit=function(){return this._unit},AstNode.prototype.includeBaseUnit=function(){return this._unit},AstNode.prototype.anchorId=function(){return null},AstNode.prototype.errors=function(){return[]},AstNode.prototype.anchoredFrom=function(){return this},AstNode.prototype.includedFrom=function(){return this},AstNode.prototype.visit=function(v){v(this)&&this.children().forEach(function(x){return x.visit(v)})},AstNode.prototype.dumpToObject=function(){return this._object},AstNode.prototype.addChild=function(n){},AstNode.prototype.execute=function(cmd){},AstNode.prototype.dump=function(){return JSON.stringify(this._object)},AstNode.prototype.keyStart=function(){return-1},AstNode.prototype.keyEnd=function(){return-1},AstNode.prototype.valueStart=function(){return-1},AstNode.prototype.valueEnd=function(){return-1},AstNode.prototype.isValueLocal=function(){return!0},AstNode.prototype.kind=function(){return Array.isArray(this._object)?yaml.Kind.SEQ:this._object instanceof Object?yaml.Kind.MAP:yaml.Kind.SCALAR},AstNode.prototype.valueKind=function(){if(!this._object)return null;var valType=typeof this._object;return Array.isArray(this._object)?yaml.Kind.SEQ:"object"==valType?yaml.Kind.MAP:"string"==valType||"number"==valType||"boolean"==valType?yaml.Kind.SCALAR:null},AstNode.prototype.show=function(msg){},AstNode.prototype.setHighLevelParseResult=function(highLevelParseResult){this._highLevelParseResult=highLevelParseResult},AstNode.prototype.highLevelParseResult=function(){return this._highLevelParseResult},AstNode.prototype.setHighLevelNode=function(highLevel){this._highLevelNode=highLevel},AstNode.prototype.highLevelNode=function(){return this._highLevelNode},AstNode.prototype.text=function(unitText){throw new Error("not implemented")},AstNode.prototype.copy=function(){throw new Error("not implemented")},AstNode.prototype.markup=function(json){throw new Error("not implemented")},AstNode.prototype.nodeDefinition=function(){return llImpl.getDefinitionForLowLevelNode(this)},AstNode.prototype.includesContents=function(){return!1},AstNode}();exports.AstNode=AstNode,exports.serialize=serialize},function(module,exports,__webpack_require__){"use strict";var hl=__webpack_require__(10),linter=__webpack_require__(25),OverloadingValidator=function(){function OverloadingValidator(){this.uriToResources={},this.conflictingUriToResources={}}return OverloadingValidator.prototype.validateApi=function(api,acceptor){var _this=this,resources=api.resources();resources.forEach(function(resource){_this.acceptResource(resource);var subResources=resource.resources();subResources.forEach(function(subResource){return _this.acceptResource(subResource)})});for(var uri in this.conflictingUriToResources){var resources=this.conflictingUriToResources[uri];if(resources.length>1){var idToSimilarResources={};resources.forEach(function(resource){var highLevel=resource.highLevel(),complexId="";null!=highLevel.parent()&&(complexId+=highLevel.parent().id()+"."),complexId+=highLevel.localId();var resourcesWithId=idToSimilarResources[complexId];null==resourcesWithId&&(resourcesWithId=[],idToSimilarResources[complexId]=resourcesWithId),resourcesWithId.push(resource)});var ids=Object.keys(idToSimilarResources);ids.length>1&&resources.forEach(function(resource){acceptor.accept(linter.createIssue(hl.IssueCode.KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT,"Resources share same URI",resource.highLevel(),!1))})}}},OverloadingValidator.prototype.acceptResource=function(resource){var uri=resource.absoluteUri(),resources=this.uriToResources[uri];resources||(resources=[],this.uriToResources[uri]=resources),resources.push(resource),resources.length>1&&(this.conflictingUriToResources[uri]=resources)},OverloadingValidator}();module.exports=OverloadingValidator},function(module,exports,__webpack_require__){"use strict";function xmlToJson(xml){var obj={};if(1==xml.nodeType){if(xml.attributes.length>0)for(var j=0;j<xml.attributes.length;j++){var attribute=xml.attributes.item(j);obj["@"+attribute.nodeName]=attribute.nodeValue}}else 3==xml.nodeType&&(obj=xml.nodeValue);if(xml.hasChildNodes())for(var i=0;i<xml.childNodes.length;i++){var item=xml.childNodes.item(i),nodeName=item.nodeName;if(void 0!=nodeName)if("undefined"==typeof obj[nodeName])obj[nodeName]=xmlToJson(item);else{if("undefined"==typeof obj[nodeName].push){var old=obj[nodeName];obj[nodeName]=[],obj[nodeName].push(old)}obj[nodeName].push(xmlToJson(item))}}return obj}function cleanupText(j){if("object"==typeof j)for(var p in j)if("object"==typeof j[p]){for(var k in j[p])if("#text"==k){var txt=j[p]["#text"];"string"!=typeof txt&&(txt=txt.join("")),txt=txt.trim(),0==txt.length&&delete j[p]["#text"]}cleanupText(j[p])}return j}function cleanupJson(j){if("object"==typeof j)for(var p in j)if("object"==typeof j[p]){var keys=Object.keys(j[p]);1==keys.length&&"#text"==keys[0]&&(j[p]=j[p]["#text"]),cleanupJson(j[p])}return j}function parseXML(value){var v=new DomParser.DOMParser;if(!value||0==value.trim().indexOf("<<"))return null;var parsed=v.parseFromString(value);return cleanupJson(cleanupText(xmlToJson(parsed)))}var DomParser=__webpack_require__(75);module.exports=parseXML},function(module,exports,__webpack_require__){"use strict";function isScheme(content){try{var schemeObject=JSON.parse(content);return schemeObject.$schema}catch(exception){return!1}}function startDownloadingReferencesAsync(schemaContent,unit){var schemaObject=su.getJSONSchema(schemaContent,new contentprovider.ContentProvider(unit)),missedReferences=schemaObject.getMissingReferences([]).map(function(reference){return schemaObject.contentAsync(reference)});if(0===missedReferences.length)return Promise.resolve(unit);var allReferences=Promise.all(missedReferences),result=getRefs(allReferences,schemaObject);return result.then(function(){return unit})}function getReferences(schemaContent,unit){var schemaObject=su.getJSONSchema(schemaContent,new contentprovider.ContentProvider(unit));return schemaObject.getMissingReferences([],!0)}function getRefs(promise,schemaObject){return promise.then(function(references){if(references.length>0){var missedRefs=schemaObject.getMissingReferences(references);if(0===missedRefs.length)return[];var promises=[];return missedRefs.forEach(function(ref){promises.push(schemaObject.contentAsync(ref))}),getRefs(Promise.all(promises.concat(references)),schemaObject)}return Promise.resolve([])})}var contentprovider=__webpack_require__(30),def=__webpack_require__(36),su=def.getSchemaUtils();exports.isScheme=isScheme,exports.startDownloadingReferencesAsync=startDownloadingReferencesAsync,exports.getReferences=getReferences},function(module,exports,__webpack_require__){"use strict";var ll=__webpack_require__(11),path=__webpack_require__(15),universes=__webpack_require__(22),universeHelpers=__webpack_require__(14),resourceRegistry=__webpack_require__(28),NamespaceResolver=function(){function NamespaceResolver(){this.expandedAbsToNsMap={},this.byPathMap={},this.byNsMap={},this._hasFragments={}}return NamespaceResolver.prototype.resolveNamespace=function(from,to){if(null==to)return null;var toPath=to.absolutePath(),unitMap=this.expandedPathMap(from);if(!unitMap)return null;var usesInfo=unitMap[toPath];return null!=usesInfo?usesInfo.namespace():null},NamespaceResolver.prototype.expandedPathMap=function(unit){var fromPath=unit.absolutePath(),unitMap=this.expandedAbsToNsMap[fromPath];return void 0===unitMap&&(unitMap=this.calculateExpandedNamespaces(unit),0==Object.keys(unitMap).length&&(unitMap=null),this.expandedAbsToNsMap[fromPath]=unitMap),unitMap},NamespaceResolver.prototype.calculateExpandedNamespaces=function(_unit){for(var _this=this,rootPath=path.dirname(_unit.absolutePath()),result={},usesInfoArray=[];_unit;){usesInfoArray.push(new UsesInfo([],_unit,""));var u=_unit;_unit=null;var hlNode=u.highLevel();if(hlNode.isElement()){var hlElem=hlNode.asElement(),definition=hlElem.definition();if(universeHelpers.isOverlayType(definition)||universeHelpers.isExtensionType(definition)){var eValue=hlElem.attr(universes.Universe10.Extension.properties.extends.name).value();_unit=u.resolve(eValue),_unit&&resourceRegistry.isWaitingFor(_unit.absolutePath())&&(_unit=null)}}}for(var i=0;i<usesInfoArray.length;i++){var visited={},info=usesInfoArray[i],unit=info.unit,hlPR=unit.highLevel();if(hlPR.isElement()){var steps=info.steps()+1,visit=function(x){var children=x.children();if(null==x.parent()){var nodeUnit=x.unit(),localPath=nodeUnit.absolutePath();if(visited[localPath])return;visited[localPath]=!0,localPath!=unit.absolutePath()&&(_this._hasFragments[unit.absolutePath()]=!0);var map=_this.pathMap(nodeUnit);if(map)for(var _i=0,_a=Object.keys(map);_i<_a.length;_i++){var absPath=_a[_i],childInfo=map[absPath],segments=info.namespaceSegments.concat(childInfo.namespaceSegments),existing=result[absPath];if(existing){if(existing.steps()<steps)continue;if(existing.steps()==steps&&_this.lexLessEq(existing.namespaceSegments,segments))continue}var includePath,childInclude=childInfo.includePath;includePath=path.isAbsolute(info.includePath)||ll.isWebPath(info.includePath)?childInfo.absolutePath():path.isAbsolute(childInclude)||ll.isWebPath(childInclude)?childInfo.absolutePath():path.relative(rootPath,childInfo.absolutePath()),includePath=includePath.replace(/\\/g,"/");var ui=new UsesInfo(segments,childInfo.unit,includePath);result[absPath]=ui,usesInfoArray.push(ui)}}children.forEach(function(y){y.includedFrom()&&(y=y.parent()),visit(y)}),null==x.parent()&&(visited[x.unit().absolutePath()]=!1)};visit(unit.ast())}}for(var namespaces={},_i=0,_a=Object.keys(result);_i<_a.length;_i++){for(var key=_a[_i],info=result[key],ns=info.namespace(),i=0;namespaces[ns];)ns=info.namespace()+i++;ns!=info.namespace()&&(info.namespaceSegments=ns.split(".")),namespaces[ns]=!0}return result},NamespaceResolver.prototype.pathMap=function(unit){var fromPath=unit.absolutePath(),unitMap=this.byPathMap[fromPath];return void 0===unitMap&&(unitMap=this.calculateNamespaces(unit),0==Object.keys(unitMap).length&&(unitMap=null),this.byPathMap[fromPath]=unitMap),unitMap},NamespaceResolver.prototype.nsMap=function(unit){var fromPath=unit.absolutePath(),unitMap=this.byNsMap[fromPath];if(void 0===unitMap){var map=this.pathMap(unit);if(null==map)unitMap=null;else{unitMap={};for(var _i=0,_a=Object.keys(map);_i<_a.length;_i++){var aPath=_a[_i],info=map[aPath];unitMap[info.namespace()]=info}}this.byNsMap[fromPath]=unitMap}return unitMap},NamespaceResolver.prototype.calculateNamespaces=function(unit){var rootPath=path.dirname(unit.absolutePath()),result={},rootNode=unit.ast(),usesNodes=rootNode.children().filter(function(x){return x.key()==universes.Universe10.FragmentDeclaration.properties.uses.name});if(rootNode.actual()&&rootNode.actual().usesNode&&(usesNodes=[rootNode.actual().usesNode]),0==usesNodes.length)return result;for(var usesDeclarationNodes=[],_i=0,usesNodes_1=usesNodes;_i<usesNodes_1.length;_i++){var un=usesNodes_1[_i];usesDeclarationNodes=usesDeclarationNodes.concat(un.children())}if(0==usesDeclarationNodes.length)return result;for(var _a=0,usesDeclarationNodes_1=usesDeclarationNodes;_a<usesDeclarationNodes_1.length;_a++){var un=usesDeclarationNodes_1[_a],key=un.key(),value=un.value(),libUnit=unit.resolve(value);if(null!=libUnit){var includePath,segments=[key],absPath=libUnit.absolutePath();includePath=path.isAbsolute(value)||ll.isWebPath(value)?libUnit.absolutePath():path.relative(rootPath,libUnit.absolutePath()),includePath=includePath.replace(/\\/g,"/");var ui=new UsesInfo(segments,libUnit,includePath);result[absPath]=ui}}var hlNode=unit.highLevel();if(hlNode.isElement()){var hlElem=hlNode.asElement(),definition=hlElem.definition();if(universeHelpers.isOverlayType(definition)||universeHelpers.isExtensionType(definition)){var extendedUnit,eValue=hlElem.attr(universes.Universe10.Extension.properties.extends.name).value();try{extendedUnit=unit.resolve(eValue)}catch(e){}if(extendedUnit){var m=this.pathMap(extendedUnit);if(m)for(var _b=0,_c=Object.keys(m);_b<_c.length;_b++){var k=_c[_b];result[k]=m[k]}}}}return result},NamespaceResolver.prototype.lexLessEq=function(a,b){if(a.length>b.length)return!1;if(a.length<b.length)return!0;for(var i=0;i<a.length;i++){var seg_a=a[i],seg_b=b[i];if(seg_a<seg_b)return!0;if(seg_a>seg_b)return!1}return!0},NamespaceResolver.prototype.hasFragments=function(unit){return this.calculateExpandedNamespaces(unit),!!this._hasFragments[unit.absolutePath()]},NamespaceResolver}();exports.NamespaceResolver=NamespaceResolver;var UsesInfo=function(){function UsesInfo(namespaceSegments,unit,includePath){this.namespaceSegments=namespaceSegments,this.unit=unit,this.includePath=includePath}return UsesInfo.prototype.steps=function(){return this.namespaceSegments.length},UsesInfo.prototype.namespace=function(){return this.namespaceSegments.join(".")},UsesInfo.prototype.absolutePath=function(){return this.unit.absolutePath()},UsesInfo}();exports.UsesInfo=UsesInfo},function(module,exports,__webpack_require__){"use strict";function toRegExp(path,parameters,keys,options){var end=options.end!==!1,strict=options.strict,flags="";options.sensitive||(flags+="i");var route=path.replace(REGEXP_REPLACE,function(match,prefix,key,escape){if(escape)return"\\"+escape;keys.push({name:key,prefix:prefix||"/"}),prefix=prefix?"\\"+prefix:"";var param=parameters[key],capture=param&&REGEXP_MATCH[param.type]||"[^"+(prefix||"\\/")+"]+",optional=param&&param.required===!1;return Array.isArray(param.enum)&&param.enum.length&&(capture="(?:"+param.enum.map(function(value){return String(value).replace(ESCAPE_CHARACTERS,"\\$1")}).join("|")+")"),prefix+"("+capture+")"+(optional?"?":"")}),endsWithSlash="/"===path.charAt(path.length-1);return strict||(route=(endsWithSlash?route.slice(0,-2):route)+"(?:\\/(?=$))?"),
route+=end?"$":strict&&endsWithSlash?"":"(?=\\/|$)",new RegExp("^"+route+(end?"$":""),flags)}function decodeParam(param){try{return decodeURIComponent(param)}catch(_){var err=new Error('Failed to decode param "'+param+'"');throw err.status=400,err}}function ramlPathMatch(path,parameters,options){if(options=options||{},"/"===path&&options.end===!1)return truth;parameters=parameters||{};var keys=[],re=toRegExp(path,parameters,keys,options),sanitize=ramlSanitize.sanitize()(parameters),validate=ramlValidate.validate()(parameters);return function(pathname){var m=re.exec(pathname);if(!m)return!1;if(parameters.mediaTypeExtension&&m.length>1&&!m[m.length-1]){var beforeLast=m[m.length-2],ind=beforeLast.lastIndexOf(".");ind>=0&&(m[m.length-2]=beforeLast.substring(0,ind),m[m.length-1]=beforeLast.substring(ind))}for(var path=m[0],params={},i=1;i<m.length;i++){var key=keys[i-1],param=m[i];params[key.name]=null==param?param:decodeParam(param)}return params=sanitize(params),!!validate(params).valid&&{path:path,params:params}}}function truth(path){return{path:"",params:{}}}var ramlSanitize=__webpack_require__(76),ramlValidate=__webpack_require__(77),REGEXP_MATCH={number:"[-+]?\\d+(?:\\.\\d+)?",integer:"[-+]?\\d+",date:"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} (?:[0-1]\\d|2[0-3]):[0-5]\\d:[0-5]\\d GMT",boolean:"(?:true|false)"},ESCAPE_CHARACTERS=/([.*+?=^!:${}()|[\]\/\\])/g,REGEXP_REPLACE=new RegExp(["([.\\/])?\\{([^}]+)\\}",ESCAPE_CHARACTERS.source].join("|"),"g");exports.ramlPathMatch=ramlPathMatch},function(module,exports,__webpack_require__){"use strict";function toModule(arr){var main=arr[0],map={};return arr.forEach(function(x){return map[x.name]=x}),arr.forEach(function(x){var imports=x.imports;Object.keys(imports).forEach(function(y){var name=imports[y];imports[y]=map[name]})}),main}exports.universeDumps={RAML08:toModule(__webpack_require__(89)),RAML10:toModule(__webpack_require__(90))}},function(module,exports,__webpack_require__){"use strict";function toDefSystem(ts,q){var u=new def.Universe(q,""),c={};return processModule(ts,u,{},c),Object.keys(c).forEach(function(x){registerClasses(c[x],u)}),Object.keys(c).forEach(function(x){registerHierarchy(c[x],u)}),Object.keys(c).forEach(function(x){registerEverything(c[x],u)}),u.types().forEach(function(x){if(x instanceof def.NodeClass){var cl=x;if(cl.properties().forEach(function(y){var t=y.range(),ap=y;t.hasValueTypeInHierarchy()||t.properties().forEach(function(p0){if(p0.getAdapter(services.RAMLPropertyService).isKey()){var kp=p0.keyPrefix();kp&&(ap.withKeyRestriction(kp),ap.merge());var eo=p0.enumOptions();eo&&(ap.withEnumOptions(eo),ap.merge())}})}),cl.getAdapter(services.RAMLService).isGlobalDeclaration()){if(cl.getAdapter(services.RAMLService).getActuallyExports()&&"$self"!=cl.getAdapter(services.RAMLService).getActuallyExports()){var tp=cl.property(cl.getAdapter(services.RAMLService).getActuallyExports()).range();if(tp.hasValueTypeInHierarchy()){var vt=tp.getAdapter(services.RAMLService);vt.setGloballyDeclaredBy(cl)}}if(cl.getAdapter(services.RAMLService).getConvertsToGlobal()){var tp=u.type(cl.getAdapter(services.RAMLService).getConvertsToGlobal());if(tp.hasValueTypeInHierarchy()){var vt=tp.getAdapter(services.RAMLService);vt.setGloballyDeclaredBy(cl)}}}}}),u}function createProp(x,clazz,t,custom,annotations){var p=def.prop(x.name(),"",clazz,t,custom);x.isMultiValue()&&p.withMultiValue(!0),p.unmerge(),t||console.log(x.name()+":"+clazz.nameId()+" has undefined type"),t.hasValueTypeInHierarchy()||t.properties().forEach(function(p0){if(p0.getAdapter(services.RAMLPropertyService).isKey()){var kp=p0.keyPrefix();kp&&(p.withKeyRestriction(kp),p.merge());var eo=p0.enumOptions();eo&&(p.withEnumOptions(eo),p.merge())}}),processAnnotations(x,p,annotations)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},tsModel=__webpack_require__(91),def=__webpack_require__(36),_=__webpack_require__(88),aHandlers=__webpack_require__(79),services=def,FieldWrapper=function(){function FieldWrapper(_field,_clazz){this._field=_field,this._clazz=_clazz}return FieldWrapper.prototype.name=function(){return this._field.name},FieldWrapper.prototype.range=function(){return this._clazz.getModule().typeFor(this._field.type,this._clazz)},FieldWrapper.prototype.isMultiValue=function(){return this._field.type.typeKind==tsModel.TypeKind.ARRAY},FieldWrapper.prototype.isKey=function(){return null!=_.find(this._field.annotations,function(x){return"MetaModel.key"==x.name})},FieldWrapper.prototype.isSimpleValue=function(){return null!=_.find(this._field.annotations,function(x){return"MetaModel.value"==x.name})},FieldWrapper.prototype.annotations=function(){return this._field.annotations},FieldWrapper}(),FieldConstraint=function(){function FieldConstraint(_field,_clazz){this._field=_field,this._clazz=_clazz}return FieldConstraint.prototype.name=function(){return this._field.name},FieldConstraint.prototype.value=function(){return this._field.valueConstraint},FieldConstraint}(),ClassWrapper=function(){function ClassWrapper(_clazz,mw){this._clazz=_clazz,this.mw=mw}return ClassWrapper.prototype.typeMeta=function(){return this._clazz.annotations},ClassWrapper.prototype.path=function(){return this.mw.path()},ClassWrapper.prototype.getModule=function(){return this.mw},ClassWrapper.prototype.typeArgs=function(){return this._clazz.typeParameters},ClassWrapper.prototype.typConstraints=function(){var _this=this;return this._clazz.typeParameterConstraint.map(function(x){return x?_this.mw.classForName(x):null})},ClassWrapper.prototype.methods=function(){return this._clazz.methods},ClassWrapper.prototype.name=function(){return this._clazz.name},ClassWrapper.prototype.members=function(){var _this=this;return this._clazz.fields.filter(function(x){return null==x.valueConstraint}).map(function(x){return new FieldWrapper(x,_this)})},ClassWrapper.prototype.constraints=function(){var _this=this;return this._clazz.fields.filter(function(x){return null!=x.valueConstraint}).map(function(x){return new FieldConstraint(x,_this)})},ClassWrapper.prototype.isSubTypeOf=function(of){if(this==of)return!0;var _res=!1;return this.getAllSuperTypes().forEach(function(x){_res||(_res=_res||x.isSubTypeOf(of))}),_res},ClassWrapper.prototype.getExtendsClauses=function(){return this._clazz.extends},ClassWrapper.prototype.getSuperTypes=function(){var _this=this,result=[];return this._clazz.extends.forEach(function(x){var tp=_this.mw.classForName(x.typeName);tp&&result.push(tp)}),result},ClassWrapper.prototype.getAllSuperTypes=function(){var _this=this,result=[];return this._clazz.extends.forEach(function(x){var tp=_this.mw.classForName(x.typeName);if(tp){var mm=tp.getAllSuperTypes();result.push(tp),result.concat(mm)}}),_.unique(result)},ClassWrapper.prototype.annotationOverridings=function(){return this._clazz.annotationOverridings},ClassWrapper}(),AbstractSimpleWrapper=function(){function AbstractSimpleWrapper(){}return AbstractSimpleWrapper.prototype.members=function(){return[]},AbstractSimpleWrapper.prototype.methods=function(){return[]},AbstractSimpleWrapper.prototype.isSubTypeOf=function(of){return!1},AbstractSimpleWrapper.prototype.getSuperTypes=function(){return[]},AbstractSimpleWrapper.prototype.getAllSuperTypes=function(){return[]},AbstractSimpleWrapper.prototype.name=function(){return null},AbstractSimpleWrapper.prototype.constraints=function(){return[]},AbstractSimpleWrapper.prototype.typeMeta=function(){return[]},AbstractSimpleWrapper.prototype.getModule=function(){throw new Error("Not implemented")},AbstractSimpleWrapper.prototype.annotationOverridings=function(){return{}},AbstractSimpleWrapper}(),EnumWrapper=function(_super){function EnumWrapper(_clazz,mw){_super.call(this),this._clazz=_clazz,this.mw=mw}return __extends(EnumWrapper,_super),EnumWrapper.prototype.getModule=function(){return this.mw},EnumWrapper.prototype.values=function(){return this._clazz.members},EnumWrapper.prototype.name=function(){return this._clazz.name},EnumWrapper}(AbstractSimpleWrapper),UnionWrapper=function(_super){function UnionWrapper(_clazz,mw){_super.call(this),this._clazz=_clazz,this.mw=mw}return __extends(UnionWrapper,_super),UnionWrapper.prototype.elements=function(){return this._clazz},UnionWrapper.prototype.name=function(){return this._clazz.map(function(x){return x.name()}).join("|")},UnionWrapper}(AbstractSimpleWrapper),ModuleWrapper=function(){function ModuleWrapper(_univers){var _this=this;this._univers=_univers,this.name2Class={},this.namespaceToMod={},this._classes=[],_univers.classes.forEach(function(x){var c=new ClassWrapper(x,_this);_this._classes.push(c),_this.name2Class[x.name]=c,x.moduleName&&(_this.name2Class[x.moduleName+"."+x.name]=c)}),_univers.enumDeclarations.forEach(function(x){var c=new EnumWrapper(x,_this);_this._classes.push(c),_this.name2Class[x.name]=c})}return ModuleWrapper.prototype.typeFor=function(t,ow){var _this=this;switch(t.typeKind){case tsModel.TypeKind.BASIC:var bt=t,typeName=bt.typeName;"string"==typeName&&(typeName="StringType"),"number"==typeName&&(typeName="NumberType"),"boolean"==typeName&&(typeName="BooleanType"),"any"==typeName&&(typeName="AnyType");var ti=_.indexOf(ow.typeArgs(),typeName);if(ti!=-1){var cnst=ow.typConstraints()[ti];return cnst?cnst:this.classForName("ValueType")}return this.classForName(typeName);case tsModel.TypeKind.UNION:var ut=t;return new UnionWrapper(ut.options.map(function(x){return _this.typeFor(x,ow)}),this);case tsModel.TypeKind.ARRAY:var at=t;return this.typeFor(at.base,ow)}return null},ModuleWrapper.prototype.path=function(){return this._univers.name},ModuleWrapper.prototype.classForName=function(name,stack){var _this=this;if(void 0===stack&&(stack={}),!name)return null;var result=this.name2Class[name];if(!result&&!stack[this.path()]){stack[this.path()]=this;var nmsp=name.indexOf(".");if(nmsp!=-1){var actualMod=this.namespaceToMod[name.substring(0,nmsp)];if(!actualMod)throw new Error;return actualMod.classForName(name.substring(nmsp+1),stack)}Object.keys(this.namespaceToMod).forEach(function(x){if("MetaModel"!=x){var nm=_this.namespaceToMod[x].classForName(name,stack);nm&&(result=nm)}})}return result},ModuleWrapper.prototype.classes=function(){return this._classes},ModuleWrapper}(),wrapperToType=function(range,u){if(range){var rangeType;if(range instanceof UnionWrapper){throw new Error("Union type support was removed from definition system")}return rangeType=u.type(range.name())}},registerClasses=function(m,u){var valueType=m.classForName("ValueType");m.classes().forEach(function(x){if(x instanceof EnumWrapper){var et=new def.EnumType(x.name(),u,x.getModule().path());return et.values=x.values(),void u.register(et)}if(x.isSubTypeOf(valueType)){var st=x.getAllSuperTypes();st.push(x);var refTo=null;if(st.forEach(function(t){var cs=t.getExtendsClauses();cs.forEach(function(z){if(z.typeKind==tsModel.TypeKind.BASIC){var bas=z;if("Reference"==bas.basicName){var of=bas.typeArguments[0];refTo=of.typeName;var di=refTo.indexOf(".");di!=-1&&(refTo=refTo.substring(di+1))}}})}),refTo){var ref=new def.ReferenceType(x.name(),x.getModule().path(),refTo,u);ref.setBuiltIn(!0),u.register(ref)}else{var vt=new def.ValueType(x.name(),u,x.getModule().path());vt.setBuiltIn(!0),u.register(vt)}}else{var gt=new def.NodeClass(x.name(),u,x.getModule().path());gt.setBuiltIn(!0),u.register(gt)}})},registerHierarchy=function(m,u){m.classes().forEach(function(x){x.getSuperTypes().forEach(function(y){var tp0=u.type(x.name()),tp1=u.type(y.name());if(!tp0||!tp1){var tp0=u.type(x.name()),tp1=u.type(y.name());throw new Error}u.registerSuperClass(tp0,tp1)})})},registerEverything=function(m,u){m.classes().forEach(function(x){var tp=u.type(x.name());x.typeMeta().forEach(function(a){var rangeType=wrapperToType(x,u);aHandlers.handleTypeAnnotation(a,rangeType)}),x.members().forEach(function(x){var range=x.range(),rangeType=wrapperToType(range,u);null==rangeType&&console.log(range+":"+x.name());var custom=x.annotations().map(function(y){return y.name}).indexOf("MetaModel.customHandling")>=0;createProp(x,tp,rangeType,custom)}),Object.keys(x.annotationOverridings()).forEach(function(fName){var arr=[].concat(x.annotationOverridings()[fName]),map={};arr.forEach(function(ann){return map[ann.name]=!0});for(var targetField,stArr=x.getSuperTypes(),stMap={},i=0;i<stArr.length;i++){var st=stArr[i];if(!stMap[st.name()]){stMap[st.name()]=!0,st.getSuperTypes().forEach(function(sst){return stArr.push(sst)});var arr1=st.annotationOverridings()[fName];if(arr1)arr1.filter(function(ann){return!map[ann.name]}).forEach(function(ann){map[ann.name]=!0,arr.push(ann)});else for(var stFields=st.members(),j=0;j<stFields.length;j++){var stField=stFields[j];if(stField.name()==fName){targetField=stField;break}}if(targetField){var arr2=targetField.annotations();arr2.filter(function(ann){return!map[ann.name]}).forEach(function(ann){map[ann.name]=!0,arr.push(ann)});break}}}if(targetField){var range=targetField.range(),rangeType=wrapperToType(range,u);null==rangeType&&console.log(range+":"+x.name()),createProp(targetField,tp,rangeType,!1,arr)}}),x.methods().forEach(function(x){}),x.constraints().forEach(function(x){if(x.value().isCallConstraint)throw new Error;var mm=x.value();tp.addRequirement(x.name(),""+mm.value)})}),u.types().forEach(function(x){var at=x;at.getAdapter(services.RAMLService).getAliases().forEach(function(y){return u.registerAlias(y,at)})})},processModule=function(ts,u,used,declared){if(ts.name.indexOf("metamodel.ts")==-1){if(declared[ts.name])return declared[ts.name];var m=new ModuleWrapper(ts);return used[ts.name]=m,declared[ts.name]=m,Object.keys(ts.imports).forEach(function(x){var pMod=ts.imports[x];if(used[pMod.name])return void(m.namespaceToMod[x]=used[pMod.name]);var vMod=processModule(pMod,u,used,declared);m.namespaceToMod[x]=vMod}),used[ts.name]=null,m}};exports.toDefSystem=toDefSystem;var processAnnotations=function(x,p,annotations){annotations||(annotations=x.annotations()),annotations.forEach(function(x){var nm=x.name.substring(x.name.lastIndexOf(".")+1);aHandlers.annotationHandlers[nm]||console.log("Can not find handler for:"),aHandlers.annotationHandlers[nm](x,p)})}},function(module,exports,__webpack_require__){"use strict";var Universes={Universe08:{GlobalSchema:{name:"GlobalSchema",properties:{key:{name:"key",range:"StringType",domain:"GlobalSchema"},value:{name:"value",range:"SchemaString",domain:"GlobalSchema"}}},Api:{name:"Api",properties:{title:{name:"title",range:"StringType",domain:"Api"},version:{name:"version",range:"StringType",domain:"Api"},baseUri:{name:"baseUri",range:"FullUriTemplateString",domain:"Api"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"Api"},uriParameters:{name:"uriParameters",range:"Parameter",domain:"Api"},protocols:{name:"protocols",range:"StringType",domain:"Api"},mediaType:{name:"mediaType",range:"MimeType",domain:"Api"},schemas:{name:"schemas",range:"GlobalSchema",domain:"Api"},traits:{name:"traits",range:"Trait",domain:"Api"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"Api"},securitySchemes:{name:"securitySchemes",range:"AbstractSecurityScheme",domain:"Api"},resourceTypes:{name:"resourceTypes",range:"ResourceType",domain:"Api"},resources:{name:"resources",range:"Resource",domain:"Api"},documentation:{name:"documentation",range:"DocumentationItem",domain:"Api"},RAMLVersion:{name:"RAMLVersion"}}},DocumentationItem:{name:"DocumentationItem",properties:{title:{name:"title",range:"StringType",domain:"DocumentationItem"},content:{name:"content",range:"MarkdownString",domain:"DocumentationItem"}}},ValueType:{name:"ValueType",properties:{}},StringType:{name:"StringType",properties:{}},AnyType:{name:"AnyType",properties:{}},NumberType:{name:"NumberType",properties:{}},BooleanType:{name:"BooleanType",properties:{}},Referencable:{name:"Referencable",properties:{}},Reference:{name:"Reference",properties:{structuredValue:{name:"structuredValue"},name:{name:"name"}}},DeclaresDynamicType:{name:"DeclaresDynamicType",properties:{}},UriTemplate:{name:"UriTemplate",properties:{}},RelativeUriString:{name:"RelativeUriString",properties:{}},FullUriTemplateString:{name:"FullUriTemplateString",properties:{}},FixedUri:{name:"FixedUri",properties:{}},MarkdownString:{name:"MarkdownString",properties:{}},SchemaString:{name:"SchemaString",properties:{}},JSonSchemaString:{name:"JSonSchemaString",properties:{}},XMLSchemaString:{name:"XMLSchemaString",properties:{}},ExampleString:{name:"ExampleString",properties:{}},StatusCodeString:{name:"StatusCodeString",properties:{}},JSONExample:{name:"JSONExample",properties:{}},XMLExample:{name:"XMLExample",properties:{}},TypeInstance:{name:"TypeInstance",properties:{properties:{name:"properties",range:"TypeInstanceProperty",domain:"TypeInstance"},isScalar:{name:"isScalar",range:"BooleanType",domain:"TypeInstance"},value:{name:"value",range:"AnyType",domain:"TypeInstance"}}},TypeInstanceProperty:{name:"TypeInstanceProperty",properties:{name:{name:"name",range:"StringType",domain:"TypeInstanceProperty"},value:{name:"value",range:"TypeInstance",domain:"TypeInstanceProperty"},values:{name:"values",range:"TypeInstance",domain:"TypeInstanceProperty"},isArray:{name:"isArray",range:"BooleanType",domain:"TypeInstanceProperty"}}},RAMLSimpleElement:{name:"RAMLSimpleElement",properties:{}},Parameter:{name:"Parameter",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"}}},StringTypeDeclaration:{name:"StringTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"},pattern:{name:"pattern",range:"StringType",domain:"StringTypeDeclaration"},enum:{name:"enum",range:"StringType",domain:"StringTypeDeclaration"},minLength:{name:"minLength",range:"NumberType",domain:"StringTypeDeclaration"},maxLength:{name:"maxLength",range:"NumberType",domain:"StringTypeDeclaration"}}},BooleanTypeDeclaration:{name:"BooleanTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"}}},NumberTypeDeclaration:{name:"NumberTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"},minimum:{name:"minimum",range:"NumberType",domain:"NumberTypeDeclaration"},maximum:{name:"maximum",range:"NumberType",domain:"NumberTypeDeclaration"}}},IntegerTypeDeclaration:{name:"IntegerTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"},minimum:{name:"minimum",range:"NumberType",domain:"NumberTypeDeclaration"},maximum:{name:"maximum",range:"NumberType",domain:"NumberTypeDeclaration"}}},DateTypeDeclaration:{name:"DateTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"}}},FileTypeDeclaration:{name:"FileTypeDeclaration",properties:{name:{name:"name",range:"StringType",domain:"Parameter"},displayName:{name:"displayName",range:"StringType",domain:"Parameter"},type:{name:"type",range:"StringType",domain:"Parameter"},location:{name:"location",range:"ParameterLocation",domain:"Parameter"},required:{name:"required",range:"BooleanType",domain:"Parameter"},default:{name:"default",range:"AnyType",domain:"Parameter"},example:{name:"example",range:"StringType",domain:"Parameter"},repeat:{name:"repeat",range:"BooleanType",domain:"Parameter"},description:{name:"description",range:"MarkdownString",domain:"Parameter"}}},ParameterLocation:{name:"ParameterLocation",properties:{}},MimeType:{name:"MimeType",properties:{}},BodyLike:{name:"BodyLike",properties:{name:{name:"name",range:"StringType",domain:"BodyLike"},schema:{name:"schema",range:"SchemaString",domain:"BodyLike"},example:{name:"example",range:"ExampleString",domain:"BodyLike"},formParameters:{name:"formParameters",range:"Parameter",domain:"BodyLike"},description:{name:"description",range:"MarkdownString",domain:"BodyLike"},schemaContent:{name:"schemaContent"}}},XMLBody:{name:"XMLBody",properties:{name:{name:"name",range:"StringType",domain:"BodyLike"},schema:{name:"schema",range:"XMLSchemaString",domain:"XMLBody"},example:{name:"example",range:"ExampleString",domain:"BodyLike"},formParameters:{name:"formParameters",range:"Parameter",domain:"BodyLike"},description:{name:"description",range:"MarkdownString",domain:"BodyLike"}}},JSONBody:{name:"JSONBody",properties:{name:{name:"name",range:"StringType",domain:"BodyLike"},schema:{name:"schema",range:"JSonSchemaString",domain:"JSONBody"},example:{name:"example",range:"ExampleString",domain:"BodyLike"},formParameters:{name:"formParameters",range:"Parameter",domain:"BodyLike"},description:{name:"description",range:"MarkdownString",domain:"BodyLike"}}},Response:{name:"Response",properties:{code:{name:"code",range:"StatusCodeString",domain:"Response"},headers:{name:"headers",range:"Parameter",domain:"Response"},body:{name:"body",range:"BodyLike",domain:"Response"},description:{name:"description",range:"MarkdownString",domain:"Response"}}},Resource:{name:"Resource",properties:{relativeUri:{name:"relativeUri",range:"RelativeUriString",domain:"Resource"},type:{name:"type",range:"ResourceTypeRef",domain:"Resource"},is:{name:"is",range:"TraitRef",domain:"Resource"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"Resource"},uriParameters:{name:"uriParameters",range:"Parameter",domain:"Resource"},methods:{name:"methods",range:"Method",domain:"Resource"},resources:{name:"resources",range:"Resource",domain:"Resource"},displayName:{name:"displayName",range:"StringType",domain:"Resource"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"Resource"},description:{name:"description",range:"MarkdownString",domain:"Resource"}}},ResourceTypeRef:{name:"ResourceTypeRef",properties:{resourceType:{name:"resourceType"}}},ResourceType:{name:"ResourceType",properties:{name:{name:"name",range:"StringType",domain:"ResourceType"},usage:{name:"usage",range:"StringType",domain:"ResourceType"},methods:{name:"methods",range:"Method",domain:"ResourceType"},is:{name:"is",range:"TraitRef",domain:"ResourceType"},type:{name:"type",range:"ResourceTypeRef",domain:"ResourceType"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"ResourceType"},uriParameters:{name:"uriParameters",range:"Parameter",domain:"ResourceType"},displayName:{name:"displayName",range:"StringType",domain:"ResourceType"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"ResourceType"},description:{name:"description",range:"MarkdownString",domain:"ResourceType"},parametrizedProperties:{name:"parametrizedProperties"}}},MethodBase:{name:"MethodBase",properties:{responses:{name:"responses",range:"Response",domain:"MethodBase"},body:{name:"body",range:"BodyLike",domain:"MethodBase"},protocols:{name:"protocols",range:"StringType",domain:"MethodBase"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"MethodBase"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"MethodBase"},queryParameters:{name:"queryParameters",range:"Parameter",domain:"MethodBase"},headers:{name:"headers",range:"Parameter",domain:"MethodBase"},description:{name:"description",range:"MarkdownString",domain:"MethodBase"}}},Method:{name:"Method",properties:{responses:{name:"responses",range:"Response",domain:"MethodBase"},body:{name:"body",range:"BodyLike",domain:"MethodBase"},protocols:{name:"protocols",range:"StringType",domain:"MethodBase"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"MethodBase"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"MethodBase"},queryParameters:{name:"queryParameters",range:"Parameter",domain:"MethodBase"},headers:{name:"headers",range:"Parameter",domain:"MethodBase"},description:{name:"description",range:"MarkdownString",domain:"MethodBase"},method:{name:"method",range:"StringType",domain:"Method"},is:{name:"is",range:"TraitRef",domain:"Method"}}},Trait:{name:"Trait",properties:{responses:{name:"responses",range:"Response",domain:"MethodBase"},body:{name:"body",range:"BodyLike",domain:"MethodBase"},protocols:{name:"protocols",range:"StringType",domain:"MethodBase"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"MethodBase"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"MethodBase"},queryParameters:{name:"queryParameters",range:"Parameter",domain:"MethodBase"},headers:{name:"headers",range:"Parameter",domain:"MethodBase"},description:{name:"description",range:"MarkdownString",domain:"MethodBase"},name:{name:"name",range:"StringType",domain:"Trait"},usage:{name:"usage",range:"StringType",domain:"Trait"},displayName:{name:"displayName",range:"StringType",domain:"Trait"},parametrizedProperties:{name:"parametrizedProperties"}}},TraitRef:{name:"TraitRef",properties:{trait:{name:"trait"}}},SecuritySchemePart:{name:"SecuritySchemePart",properties:{responses:{name:"responses",range:"Response",domain:"SecuritySchemePart"},body:{name:"body",range:"BodyLike",domain:"MethodBase"},protocols:{name:"protocols",range:"StringType",domain:"MethodBase"},securedBy:{name:"securedBy",range:"SecuritySchemeRef",domain:"MethodBase"},baseUriParameters:{name:"baseUriParameters",range:"Parameter",domain:"MethodBase"},queryParameters:{name:"queryParameters",range:"Parameter",domain:"SecuritySchemePart"},headers:{name:"headers",range:"Parameter",domain:"SecuritySchemePart"},description:{name:"description",range:"MarkdownString",domain:"SecuritySchemePart"},displayName:{name:"displayName",range:"StringType",domain:"SecuritySchemePart"},is:{name:"is",range:"TraitRef",domain:"SecuritySchemePart"}}},SecuritySchemeSettings:{name:"SecuritySchemeSettings",properties:{}},AbstractSecurityScheme:{name:"AbstractSecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"SecuritySchemeSettings",domain:"AbstractSecurityScheme"}}},SecuritySchemeRef:{name:"SecuritySchemeRef",properties:{securitySchemeName:{name:"securitySchemeName"},securityScheme:{name:"securityScheme"}}},OAuth1SecuritySchemeSettings:{name:"OAuth1SecuritySchemeSettings",properties:{requestTokenUri:{name:"requestTokenUri",range:"FixedUri",domain:"OAuth1SecuritySchemeSettings"},authorizationUri:{name:"authorizationUri",range:"FixedUri",domain:"OAuth1SecuritySchemeSettings"},tokenCredentialsUri:{name:"tokenCredentialsUri",range:"FixedUri",domain:"OAuth1SecuritySchemeSettings"}}},OAuth2SecuritySchemeSettings:{name:"OAuth2SecuritySchemeSettings",properties:{accessTokenUri:{name:"accessTokenUri",range:"FixedUri",domain:"OAuth2SecuritySchemeSettings"},authorizationUri:{name:"authorizationUri",range:"FixedUri",domain:"OAuth2SecuritySchemeSettings"},authorizationGrants:{name:"authorizationGrants",range:"StringType",domain:"OAuth2SecuritySchemeSettings"},scopes:{name:"scopes",range:"StringType",domain:"OAuth2SecuritySchemeSettings"}}},OAuth2SecurityScheme:{name:"OAuth2SecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"OAuth2SecuritySchemeSettings",domain:"OAuth2SecurityScheme"}}},OAuth1SecurityScheme:{name:"OAuth1SecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"OAuth1SecuritySchemeSettings",domain:"OAuth1SecurityScheme"}}},BasicSecurityScheme:{name:"BasicSecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"SecuritySchemeSettings",domain:"AbstractSecurityScheme"}}},DigestSecurityScheme:{name:"DigestSecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"
},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"SecuritySchemeSettings",domain:"AbstractSecurityScheme"}}},CustomSecurityScheme:{name:"CustomSecurityScheme",properties:{name:{name:"name",range:"StringType",domain:"AbstractSecurityScheme"},type:{name:"type",range:"StringType",domain:"AbstractSecurityScheme"},description:{name:"description",range:"MarkdownString",domain:"AbstractSecurityScheme"},describedBy:{name:"describedBy",range:"SecuritySchemePart",domain:"AbstractSecurityScheme"},settings:{name:"settings",range:"SecuritySchemeSettings",domain:"AbstractSecurityScheme"}}}},Universe10:{Library:{name:"Library",properties:{annotations:{name:"annotations"},uses:{name:"uses"},schemas:{name:"schemas"},types:{name:"types"},traits:{name:"traits"},resourceTypes:{name:"resourceTypes"},annotationTypes:{name:"annotationTypes"},securitySchemes:{name:"securitySchemes"},usage:{name:"usage"},name:{name:"name"}}},LibraryBase:{name:"LibraryBase",properties:{annotations:{name:"annotations"},uses:{name:"uses"},schemas:{name:"schemas"},types:{name:"types"},traits:{name:"traits"},resourceTypes:{name:"resourceTypes"},annotationTypes:{name:"annotationTypes"},securitySchemes:{name:"securitySchemes"}}},Api:{name:"Api",properties:{annotations:{name:"annotations"},uses:{name:"uses"},schemas:{name:"schemas"},types:{name:"types"},traits:{name:"traits"},resourceTypes:{name:"resourceTypes"},annotationTypes:{name:"annotationTypes"},securitySchemes:{name:"securitySchemes"},title:{name:"title"},description:{name:"description"},version:{name:"version"},baseUri:{name:"baseUri"},baseUriParameters:{name:"baseUriParameters"},protocols:{name:"protocols"},mediaType:{name:"mediaType"},securedBy:{name:"securedBy"},resources:{name:"resources"},documentation:{name:"documentation"},RAMLVersion:{name:"RAMLVersion",range:"StringType",domain:"Api"}}},Overlay:{name:"Overlay",properties:{annotations:{name:"annotations"},uses:{name:"uses"},schemas:{name:"schemas"},types:{name:"types"},traits:{name:"traits"},resourceTypes:{name:"resourceTypes"},annotationTypes:{name:"annotationTypes"},securitySchemes:{name:"securitySchemes"},title:{name:"title"},description:{name:"description"},version:{name:"version"},baseUri:{name:"baseUri"},baseUriParameters:{name:"baseUriParameters"},protocols:{name:"protocols"},mediaType:{name:"mediaType"},securedBy:{name:"securedBy"},resources:{name:"resources"},documentation:{name:"documentation"},usage:{name:"usage"},extends:{name:"extends"}}},Extension:{name:"Extension",properties:{annotations:{name:"annotations"},uses:{name:"uses"},schemas:{name:"schemas"},types:{name:"types"},traits:{name:"traits"},resourceTypes:{name:"resourceTypes"},annotationTypes:{name:"annotationTypes"},securitySchemes:{name:"securitySchemes"},title:{name:"title"},description:{name:"description"},version:{name:"version"},baseUri:{name:"baseUri"},baseUriParameters:{name:"baseUriParameters"},protocols:{name:"protocols"},mediaType:{name:"mediaType"},securedBy:{name:"securedBy"},resources:{name:"resources"},documentation:{name:"documentation"},usage:{name:"usage"},extends:{name:"extends"}}},UsesDeclaration:{name:"UsesDeclaration",properties:{annotations:{name:"annotations"},key:{name:"key"},value:{name:"value"}}},FragmentDeclaration:{name:"FragmentDeclaration",properties:{annotations:{name:"annotations"},uses:{name:"uses"}}},DocumentationItem:{name:"DocumentationItem",properties:{annotations:{name:"annotations"},title:{name:"title"},content:{name:"content"}}},ValueType:{name:"ValueType",properties:{annotations:{name:"annotations"}}},StringType:{name:"StringType",properties:{annotations:{name:"annotations"}}},AnyType:{name:"AnyType",properties:{annotations:{name:"annotations"}}},NumberType:{name:"NumberType",properties:{annotations:{name:"annotations"}}},IntegerType:{name:"IntegerType",properties:{annotations:{name:"annotations"}}},NullType:{name:"NullType",properties:{annotations:{name:"annotations"}}},TimeOnlyType:{name:"TimeOnlyType",properties:{annotations:{name:"annotations"}}},DateOnlyType:{name:"DateOnlyType",properties:{annotations:{name:"annotations"}}},DateTimeOnlyType:{name:"DateTimeOnlyType",properties:{annotations:{name:"annotations"}}},DateTimeType:{name:"DateTimeType",properties:{annotations:{name:"annotations"}}},FileType:{name:"FileType",properties:{annotations:{name:"annotations"}}},BooleanType:{name:"BooleanType",properties:{annotations:{name:"annotations"}}},Reference:{name:"Reference",properties:{annotations:{name:"annotations"},structuredValue:{name:"structuredValue",range:"TypeInstance",domain:"Reference"},name:{name:"name",range:"StringType",domain:"Reference"}}},UriTemplate:{name:"UriTemplate",properties:{annotations:{name:"annotations"}}},StatusCodeString:{name:"StatusCodeString",properties:{annotations:{name:"annotations"}}},RelativeUriString:{name:"RelativeUriString",properties:{annotations:{name:"annotations"}}},FullUriTemplateString:{name:"FullUriTemplateString",properties:{annotations:{name:"annotations"}}},FixedUriString:{name:"FixedUriString",properties:{annotations:{name:"annotations"}}},ContentType:{name:"ContentType",properties:{annotations:{name:"annotations"}}},MarkdownString:{name:"MarkdownString",properties:{annotations:{name:"annotations"}}},SchemaString:{name:"SchemaString",properties:{annotations:{name:"annotations"}}},ExampleSpec:{name:"ExampleSpec",properties:{annotations:{name:"annotations"},value:{name:"value"},strict:{name:"strict"},name:{name:"name"},displayName:{name:"displayName"},description:{name:"description"},structuredValue:{name:"structuredValue",range:"TypeInstance",domain:"ExampleSpec"}}},TypeDeclaration:{name:"TypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},fixedFacets:{name:"fixedFacets",range:"TypeInstance",domain:"TypeDeclaration"},structuredType:{name:"structuredType",range:"TypeInstance",domain:"TypeDeclaration"},parametrizedProperties:{name:"parametrizedProperties",range:"TypeInstance",domain:"TypeDeclaration"}}},XMLFacetInfo:{name:"XMLFacetInfo",properties:{annotations:{name:"annotations"},attribute:{name:"attribute"},wrapped:{name:"wrapped"},name:{name:"name"},namespace:{name:"namespace"},prefix:{name:"prefix"}}},ArrayTypeDeclaration:{name:"ArrayTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},uniqueItems:{name:"uniqueItems"},items:{name:"items"},minItems:{name:"minItems"},maxItems:{name:"maxItems"}}},UnionTypeDeclaration:{name:"UnionTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},ObjectTypeDeclaration:{name:"ObjectTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},properties:{name:"properties"},minProperties:{name:"minProperties"},maxProperties:{name:"maxProperties"},additionalProperties:{name:"additionalProperties"},discriminator:{name:"discriminator"},discriminatorValue:{name:"discriminatorValue"}}},StringTypeDeclaration:{name:"StringTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},pattern:{name:"pattern"},minLength:{name:"minLength"},maxLength:{name:"maxLength"},enum:{name:"enum"}}},BooleanTypeDeclaration:{name:"BooleanTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},NumberTypeDeclaration:{name:"NumberTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},minimum:{name:"minimum"},maximum:{name:"maximum"},enum:{name:"enum"},format:{name:"format"},multipleOf:{name:"multipleOf"}}},IntegerTypeDeclaration:{name:"IntegerTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},minimum:{name:"minimum"},maximum:{name:"maximum"},enum:{name:"enum"},format:{name:"format"},multipleOf:{name:"multipleOf"}}},DateOnlyTypeDeclaration:{name:"DateOnlyTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},TimeOnlyTypeDeclaration:{name:"TimeOnlyTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},DateTimeOnlyTypeDeclaration:{name:"DateTimeOnlyTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},DateTimeTypeDeclaration:{name:"DateTimeTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},format:{name:"format"}}},DateTypeDeclaration:{name:"DateTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"}}},TypeInstance:{name:"TypeInstance",properties:{properties:{name:"properties"},isScalar:{name:"isScalar"},value:{name:"value"},isArray:{name:"isArray"},items:{name:"items"}}},TypeInstanceProperty:{name:"TypeInstanceProperty",properties:{name:{name:"name"},value:{name:"value"},values:{name:"values"},isArray:{name:"isArray"}}},ModelLocation:{name:"ModelLocation",properties:{}},LocationKind:{name:"LocationKind",properties:{}},MimeType:{name:"MimeType",properties:{annotations:{name:"annotations"}}},Response:{name:"Response",properties:{annotations:{name:"annotations"},code:{name:"code"},headers:{name:"headers"},body:{name:"body"},description:{name:"description"}}},Annotable:{name:"Annotable",properties:{annotations:{name:"annotations"}}},AnnotationRef:{name:"AnnotationRef",properties:{annotations:{name:"annotations"},annotation:{name:"annotation",range:"TypeDeclaration",domain:"AnnotationRef"}}},AnnotationTarget:{name:"AnnotationTarget",properties:{annotations:{name:"annotations"}}},TraitRef:{name:"TraitRef",properties:{annotations:{name:"annotations"},trait:{name:"trait",range:"Trait",domain:"TraitRef"}}},Trait:{name:"Trait",properties:{annotations:{name:"annotations"},queryParameters:{name:"queryParameters"},headers:{name:"headers"},queryString:{name:"queryString"},responses:{name:"responses"},body:{name:"body"},protocols:{name:"protocols"},is:{name:"is"},securedBy:{name:"securedBy"},description:{name:"description"},displayName:{name:"displayName"},name:{name:"name"},usage:{name:"usage"},parametrizedProperties:{name:"parametrizedProperties",range:"TypeInstance",domain:"Trait"}}},MethodBase:{name:"MethodBase",properties:{annotations:{name:"annotations"},queryParameters:{name:"queryParameters"},headers:{name:"headers"},queryString:{name:"queryString"},responses:{name:"responses"},body:{name:"body"},protocols:{name:"protocols"},is:{name:"is"},securedBy:{name:"securedBy"},description:{name:"description"},displayName:{name:"displayName"}}},Method:{name:"Method",properties:{annotations:{name:"annotations"},queryParameters:{name:"queryParameters"},headers:{name:"headers"},queryString:{name:"queryString"},responses:{name:"responses"},body:{name:"body"},protocols:{name:"protocols"},is:{name:"is"},securedBy:{name:"securedBy"},description:{name:"description"},displayName:{name:"displayName"},method:{name:"method"},parametrizedProperties:{name:"parametrizedProperties",range:"TypeInstance",domain:"Method"}}},Operation:{name:"Operation",properties:{annotations:{name:"annotations"},queryParameters:{name:"queryParameters"},headers:{name:"headers"},queryString:{name:"queryString"},responses:{name:"responses"}}},SecuritySchemePart:{name:"SecuritySchemePart",properties:{annotations:{name:"annotations"},queryParameters:{name:"queryParameters"},headers:{name:"headers"},queryString:{name:"queryString"},responses:{name:"responses"}}},SecuritySchemeSettings:{name:"SecuritySchemeSettings",properties:{annotations:{name:"annotations"}}},OAuth1SecuritySchemeSettings:{name:"OAuth1SecuritySchemeSettings",properties:{annotations:{name:"annotations"},requestTokenUri:{name:"requestTokenUri"},authorizationUri:{name:"authorizationUri"},tokenCredentialsUri:{name:"tokenCredentialsUri"},signatures:{name:"signatures"}}},OAuth2SecuritySchemeSettings:{name:"OAuth2SecuritySchemeSettings",properties:{annotations:{name:"annotations"},accessTokenUri:{name:"accessTokenUri"},authorizationUri:{name:"authorizationUri"},authorizationGrants:{name:"authorizationGrants"},scopes:{name:"scopes"}}},SecuritySchemeRef:{name:"SecuritySchemeRef",properties:{annotations:{name:"annotations"},securitySchemeName:{name:"securitySchemeName",range:"StringType",domain:"SecuritySchemeRef"},securityScheme:{name:"securityScheme",range:"AbstractSecurityScheme",domain:"SecuritySchemeRef"}}},AbstractSecurityScheme:{name:"AbstractSecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},OAuth2SecurityScheme:{name:"OAuth2SecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},OAuth1SecurityScheme:{name:"OAuth1SecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},PassThroughSecurityScheme:{name:"PassThroughSecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},BasicSecurityScheme:{name:"BasicSecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},DigestSecurityScheme:{name:"DigestSecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},CustomSecurityScheme:{name:"CustomSecurityScheme",properties:{annotations:{name:"annotations"},name:{name:"name"},type:{name:"type"},description:{name:"description"},describedBy:{name:"describedBy"},displayName:{name:"displayName"},settings:{name:"settings"}}},ResourceTypeRef:{name:"ResourceTypeRef",properties:{annotations:{name:"annotations"},resourceType:{name:"resourceType",range:"ResourceType",domain:"ResourceTypeRef"}}},ResourceType:{name:"ResourceType",properties:{annotations:{name:"annotations"},methods:{name:"methods"},is:{name:"is"},type:{name:"type"},description:{name:"description"},securedBy:{name:"securedBy"},uriParameters:{name:"uriParameters"},displayName:{name:"displayName"},name:{name:"name"},usage:{name:"usage"},parametrizedProperties:{name:"parametrizedProperties",range:"TypeInstance",domain:"ResourceType"}}},ResourceBase:{name:"ResourceBase",properties:{annotations:{name:"annotations"},methods:{name:"methods"},is:{name:"is"},type:{name:"type"},description:{name:"description"},securedBy:{name:"securedBy"},uriParameters:{name:"uriParameters"}}},Resource:{name:"Resource",properties:{annotations:{name:"annotations"},methods:{name:"methods"},is:{name:"is"},type:{name:"type"},description:{name:"description"},securedBy:{name:"securedBy"},uriParameters:{name:"uriParameters"},relativeUri:{name:"relativeUri"},displayName:{name:"displayName"},resources:{name:"resources"}}},FileTypeDeclaration:{name:"FileTypeDeclaration",properties:{annotations:{name:"annotations"},name:{name:"name"},displayName:{name:"displayName"},facets:{name:"facets"},schema:{name:"schema"},type:{name:"type"},location:{name:"location"},locationKind:{name:"locationKind"},default:{name:"default"},example:{name:"example"},examples:{name:"examples"},required:{name:"required"},description:{name:"description"},xml:{name:"xml"},allowedTargets:{name:"allowedTargets"},isAnnotation:{name:"isAnnotation"},fileTypes:{name:"fileTypes"},minLength:{name:"minLength"},maxLength:{name:"maxLength"}}}}};module.exports=Universes},function(module,exports,__webpack_require__){function drainQueue(){if(!draining){draining=!0;for(var currentQueue,len=queue.length;len;){currentQueue=queue,queue=[];for(var i=-1;++i<len;)currentQueue[i]();len=queue.length}draining=!1}}function noop(){}var process=module.exports={},queue=[],draining=!1;process.nextTick=function(fun){queue.push(fun),draining||setTimeout(drainQueue,0)},process.title="browser",process.browser=!0,process.env={},process.argv=[],process.version="",process.versions={},process.on=noop,process.addListener=noop,process.once=noop,process.off=noop,process.removeListener=noop,process.removeAllListeners=noop,process.emit=noop,process.binding=function(name){throw new Error("process.binding is not supported")},process.cwd=function(){return"/"},process.chdir=function(dir){throw new Error("process.chdir is not supported")},process.umask=function(){return 0}},function(module,exports,__webpack_require__){exports.XMLHttpRequest=XMLHttpRequest},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;(function(){function createReduce(dir){function iterator(obj,iteratee,memo,keys,index,length){for(;index>=0&&index<length;index+=dir){var currentKey=keys?keys[index]:index;memo=iteratee(memo,obj[currentKey],currentKey,obj)}return memo}return function(obj,iteratee,memo,context){iteratee=optimizeCb(iteratee,context,4);var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=dir>0?0:length-1;return arguments.length<3&&(memo=obj[keys?keys[index]:index],index+=dir),iterator(obj,iteratee,memo,keys,index,length)}}function createPredicateIndexFinder(dir){return function(array,predicate,context){predicate=cb(predicate,context);for(var length=getLength(array),index=dir>0?0:length-1;index>=0&&index<length;index+=dir)if(predicate(array[index],index,array))return index;return-1}}function createIndexFinder(dir,predicateFind,sortedIndex){return function(array,item,idx){var i=0,length=getLength(array);if("number"==typeof idx)dir>0?i=idx>=0?idx:Math.max(idx+length,i):length=idx>=0?Math.min(idx+1,length):idx+length+1;else if(sortedIndex&&idx&&length)return idx=sortedIndex(array,item),array[idx]===item?idx:-1;if(item!==item)return idx=predicateFind(slice.call(array,i,length),_.isNaN),idx>=0?idx+i:-1;for(idx=dir>0?i:length-1;idx>=0&&idx<length;idx+=dir)if(array[idx]===item)return idx;return-1}}function collectNonEnumProps(obj,keys){var nonEnumIdx=nonEnumerableProps.length,constructor=obj.constructor,proto=_.isFunction(constructor)&&constructor.prototype||ObjProto,prop="constructor";for(_.has(obj,prop)&&!_.contains(keys,prop)&&keys.push(prop);nonEnumIdx--;)prop=nonEnumerableProps[nonEnumIdx],prop in obj&&obj[prop]!==proto[prop]&&!_.contains(keys,prop)&&keys.push(prop)}var root=this,previousUnderscore=root._,ArrayProto=Array.prototype,ObjProto=Object.prototype,FuncProto=Function.prototype,push=ArrayProto.push,slice=ArrayProto.slice,toString=ObjProto.toString,hasOwnProperty=ObjProto.hasOwnProperty,nativeIsArray=Array.isArray,nativeKeys=Object.keys,nativeBind=FuncProto.bind,nativeCreate=Object.create,Ctor=function(){},_=function(obj){return obj instanceof _?obj:this instanceof _?void(this._wrapped=obj):new _(obj)};"undefined"!=typeof module&&module.exports&&(exports=module.exports=_),exports._=_,_.VERSION="1.8.3";var optimizeCb=function(func,context,argCount){if(void 0===context)return func;switch(null==argCount?3:argCount){case 1:return function(value){return func.call(context,value)};case 2:return function(value,other){return func.call(context,value,other)};case 3:return function(value,index,collection){return func.call(context,value,index,collection)};case 4:return function(accumulator,value,index,collection){return func.call(context,accumulator,value,index,collection)}}return function(){return func.apply(context,arguments)}},cb=function(value,context,argCount){return null==value?_.identity:_.isFunction(value)?optimizeCb(value,context,argCount):_.isObject(value)?_.matcher(value):_.property(value)};_.iteratee=function(value,context){return cb(value,context,1/0)};var createAssigner=function(keysFunc,undefinedOnly){return function(obj){var length=arguments.length;if(length<2||null==obj)return obj;for(var index=1;index<length;index++)for(var source=arguments[index],keys=keysFunc(source),l=keys.length,i=0;i<l;i++){var key=keys[i];undefinedOnly&&void 0!==obj[key]||(obj[key]=source[key])}return obj}},baseCreate=function(prototype){if(!_.isObject(prototype))return{};if(nativeCreate)return nativeCreate(prototype);Ctor.prototype=prototype;var result=new Ctor;return Ctor.prototype=null,result},property=function(key){return function(obj){return null==obj?void 0:obj[key]}},MAX_ARRAY_INDEX=Math.pow(2,53)-1,getLength=property("length"),isArrayLike=function(collection){var length=getLength(collection);return"number"==typeof length&&length>=0&&length<=MAX_ARRAY_INDEX};_.each=_.forEach=function(obj,iteratee,context){iteratee=optimizeCb(iteratee,context);var i,length;if(isArrayLike(obj))for(i=0,length=obj.length;i<length;i++)iteratee(obj[i],i,obj);else{var keys=_.keys(obj);for(i=0,length=keys.length;i<length;i++)iteratee(obj[keys[i]],keys[i],obj)}return obj},_.map=_.collect=function(obj,iteratee,context){iteratee=cb(iteratee,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,results=Array(length),index=0;index<length;index++){var currentKey=keys?keys[index]:index;results[index]=iteratee(obj[currentKey],currentKey,obj)}return results},_.reduce=_.foldl=_.inject=createReduce(1),_.reduceRight=_.foldr=createReduce(-1),_.find=_.detect=function(obj,predicate,context){var key;if(key=isArrayLike(obj)?_.findIndex(obj,predicate,context):_.findKey(obj,predicate,context),void 0!==key&&key!==-1)return obj[key]},_.filter=_.select=function(obj,predicate,context){var results=[];return predicate=cb(predicate,context),_.each(obj,function(value,index,list){predicate(value,index,list)&&results.push(value)}),results},_.reject=function(obj,predicate,context){return _.filter(obj,_.negate(cb(predicate)),context)},_.every=_.all=function(obj,predicate,context){predicate=cb(predicate,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=0;index<length;index++){var currentKey=keys?keys[index]:index;if(!predicate(obj[currentKey],currentKey,obj))return!1}return!0},_.some=_.any=function(obj,predicate,context){predicate=cb(predicate,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=0;index<length;index++){var currentKey=keys?keys[index]:index;if(predicate(obj[currentKey],currentKey,obj))return!0}return!1},_.contains=_.includes=_.include=function(obj,item,fromIndex,guard){return isArrayLike(obj)||(obj=_.values(obj)),("number"!=typeof fromIndex||guard)&&(fromIndex=0),_.indexOf(obj,item,fromIndex)>=0},_.invoke=function(obj,method){var args=slice.call(arguments,2),isFunc=_.isFunction(method);return _.map(obj,function(value){var func=isFunc?method:value[method];return null==func?func:func.apply(value,args)})},_.pluck=function(obj,key){return _.map(obj,_.property(key))},_.where=function(obj,attrs){return _.filter(obj,_.matcher(attrs))},_.findWhere=function(obj,attrs){return _.find(obj,_.matcher(attrs))},_.max=function(obj,iteratee,context){var value,computed,result=-(1/0),lastComputed=-(1/0);if(null==iteratee&&null!=obj){obj=isArrayLike(obj)?obj:_.values(obj);for(var i=0,length=obj.length;i<length;i++)value=obj[i],value>result&&(result=value)}else iteratee=cb(iteratee,context),_.each(obj,function(value,index,list){computed=iteratee(value,index,list),(computed>lastComputed||computed===-(1/0)&&result===-(1/0))&&(result=value,lastComputed=computed)});return result},_.min=function(obj,iteratee,context){var value,computed,result=1/0,lastComputed=1/0;if(null==iteratee&&null!=obj){obj=isArrayLike(obj)?obj:_.values(obj);for(var i=0,length=obj.length;i<length;i++)value=obj[i],value<result&&(result=value)}else iteratee=cb(iteratee,context),_.each(obj,function(value,index,list){computed=iteratee(value,index,list),(computed<lastComputed||computed===1/0&&result===1/0)&&(result=value,lastComputed=computed)});return result},_.shuffle=function(obj){for(var rand,set=isArrayLike(obj)?obj:_.values(obj),length=set.length,shuffled=Array(length),index=0;index<length;index++)rand=_.random(0,index),rand!==index&&(shuffled[index]=shuffled[rand]),shuffled[rand]=set[index];return shuffled},_.sample=function(obj,n,guard){return null==n||guard?(isArrayLike(obj)||(obj=_.values(obj)),obj[_.random(obj.length-1)]):_.shuffle(obj).slice(0,Math.max(0,n))},_.sortBy=function(obj,iteratee,context){return iteratee=cb(iteratee,context),_.pluck(_.map(obj,function(value,index,list){return{value:value,index:index,criteria:iteratee(value,index,list)}}).sort(function(left,right){var a=left.criteria,b=right.criteria;if(a!==b){if(a>b||void 0===a)return 1;if(a<b||void 0===b)return-1}return left.index-right.index}),"value")};var group=function(behavior){return function(obj,iteratee,context){var result={};return iteratee=cb(iteratee,context),_.each(obj,function(value,index){var key=iteratee(value,index,obj);behavior(result,value,key)}),result}};_.groupBy=group(function(result,value,key){_.has(result,key)?result[key].push(value):result[key]=[value]}),_.indexBy=group(function(result,value,key){result[key]=value}),_.countBy=group(function(result,value,key){_.has(result,key)?result[key]++:result[key]=1}),_.toArray=function(obj){return obj?_.isArray(obj)?slice.call(obj):isArrayLike(obj)?_.map(obj,_.identity):_.values(obj):[]},_.size=function(obj){return null==obj?0:isArrayLike(obj)?obj.length:_.keys(obj).length},_.partition=function(obj,predicate,context){predicate=cb(predicate,context);var pass=[],fail=[];return _.each(obj,function(value,key,obj){(predicate(value,key,obj)?pass:fail).push(value)}),[pass,fail]},_.first=_.head=_.take=function(array,n,guard){if(null!=array)return null==n||guard?array[0]:_.initial(array,array.length-n)},_.initial=function(array,n,guard){return slice.call(array,0,Math.max(0,array.length-(null==n||guard?1:n)))},_.last=function(array,n,guard){if(null!=array)return null==n||guard?array[array.length-1]:_.rest(array,Math.max(0,array.length-n))},_.rest=_.tail=_.drop=function(array,n,guard){return slice.call(array,null==n||guard?1:n)},_.compact=function(array){return _.filter(array,_.identity)};var flatten=function(input,shallow,strict,startIndex){for(var output=[],idx=0,i=startIndex||0,length=getLength(input);i<length;i++){var value=input[i];if(isArrayLike(value)&&(_.isArray(value)||_.isArguments(value))){shallow||(value=flatten(value,shallow,strict));var j=0,len=value.length;for(output.length+=len;j<len;)output[idx++]=value[j++]}else strict||(output[idx++]=value)}return output};_.flatten=function(array,shallow){return flatten(array,shallow,!1)},_.without=function(array){return _.difference(array,slice.call(arguments,1))},_.uniq=_.unique=function(array,isSorted,iteratee,context){_.isBoolean(isSorted)||(context=iteratee,iteratee=isSorted,isSorted=!1),null!=iteratee&&(iteratee=cb(iteratee,context));for(var result=[],seen=[],i=0,length=getLength(array);i<length;i++){var value=array[i],computed=iteratee?iteratee(value,i,array):value;
isSorted?(i&&seen===computed||result.push(value),seen=computed):iteratee?_.contains(seen,computed)||(seen.push(computed),result.push(value)):_.contains(result,value)||result.push(value)}return result},_.union=function(){return _.uniq(flatten(arguments,!0,!0))},_.intersection=function(array){for(var result=[],argsLength=arguments.length,i=0,length=getLength(array);i<length;i++){var item=array[i];if(!_.contains(result,item)){for(var j=1;j<argsLength&&_.contains(arguments[j],item);j++);j===argsLength&&result.push(item)}}return result},_.difference=function(array){var rest=flatten(arguments,!0,!0,1);return _.filter(array,function(value){return!_.contains(rest,value)})},_.zip=function(){return _.unzip(arguments)},_.unzip=function(array){for(var length=array&&_.max(array,getLength).length||0,result=Array(length),index=0;index<length;index++)result[index]=_.pluck(array,index);return result},_.object=function(list,values){for(var result={},i=0,length=getLength(list);i<length;i++)values?result[list[i]]=values[i]:result[list[i][0]]=list[i][1];return result},_.findIndex=createPredicateIndexFinder(1),_.findLastIndex=createPredicateIndexFinder(-1),_.sortedIndex=function(array,obj,iteratee,context){iteratee=cb(iteratee,context,1);for(var value=iteratee(obj),low=0,high=getLength(array);low<high;){var mid=Math.floor((low+high)/2);iteratee(array[mid])<value?low=mid+1:high=mid}return low},_.indexOf=createIndexFinder(1,_.findIndex,_.sortedIndex),_.lastIndexOf=createIndexFinder(-1,_.findLastIndex),_.range=function(start,stop,step){null==stop&&(stop=start||0,start=0),step=step||1;for(var length=Math.max(Math.ceil((stop-start)/step),0),range=Array(length),idx=0;idx<length;idx++,start+=step)range[idx]=start;return range};var executeBound=function(sourceFunc,boundFunc,context,callingContext,args){if(!(callingContext instanceof boundFunc))return sourceFunc.apply(context,args);var self=baseCreate(sourceFunc.prototype),result=sourceFunc.apply(self,args);return _.isObject(result)?result:self};_.bind=function(func,context){if(nativeBind&&func.bind===nativeBind)return nativeBind.apply(func,slice.call(arguments,1));if(!_.isFunction(func))throw new TypeError("Bind must be called on a function");var args=slice.call(arguments,2),bound=function(){return executeBound(func,bound,context,this,args.concat(slice.call(arguments)))};return bound},_.partial=function(func){var boundArgs=slice.call(arguments,1),bound=function(){for(var position=0,length=boundArgs.length,args=Array(length),i=0;i<length;i++)args[i]=boundArgs[i]===_?arguments[position++]:boundArgs[i];for(;position<arguments.length;)args.push(arguments[position++]);return executeBound(func,bound,this,this,args)};return bound},_.bindAll=function(obj){var i,key,length=arguments.length;if(length<=1)throw new Error("bindAll must be passed function names");for(i=1;i<length;i++)key=arguments[i],obj[key]=_.bind(obj[key],obj);return obj},_.memoize=function(func,hasher){var memoize=function(key){var cache=memoize.cache,address=""+(hasher?hasher.apply(this,arguments):key);return _.has(cache,address)||(cache[address]=func.apply(this,arguments)),cache[address]};return memoize.cache={},memoize},_.delay=function(func,wait){var args=slice.call(arguments,2);return setTimeout(function(){return func.apply(null,args)},wait)},_.defer=_.partial(_.delay,_,1),_.throttle=function(func,wait,options){var context,args,result,timeout=null,previous=0;options||(options={});var later=function(){previous=options.leading===!1?0:_.now(),timeout=null,result=func.apply(context,args),timeout||(context=args=null)};return function(){var now=_.now();previous||options.leading!==!1||(previous=now);var remaining=wait-(now-previous);return context=this,args=arguments,remaining<=0||remaining>wait?(timeout&&(clearTimeout(timeout),timeout=null),previous=now,result=func.apply(context,args),timeout||(context=args=null)):timeout||options.trailing===!1||(timeout=setTimeout(later,remaining)),result}},_.debounce=function(func,wait,immediate){var timeout,args,context,timestamp,result,later=function(){var last=_.now()-timestamp;last<wait&&last>=0?timeout=setTimeout(later,wait-last):(timeout=null,immediate||(result=func.apply(context,args),timeout||(context=args=null)))};return function(){context=this,args=arguments,timestamp=_.now();var callNow=immediate&&!timeout;return timeout||(timeout=setTimeout(later,wait)),callNow&&(result=func.apply(context,args),context=args=null),result}},_.wrap=function(func,wrapper){return _.partial(wrapper,func)},_.negate=function(predicate){return function(){return!predicate.apply(this,arguments)}},_.compose=function(){var args=arguments,start=args.length-1;return function(){for(var i=start,result=args[start].apply(this,arguments);i--;)result=args[i].call(this,result);return result}},_.after=function(times,func){return function(){if(--times<1)return func.apply(this,arguments)}},_.before=function(times,func){var memo;return function(){return--times>0&&(memo=func.apply(this,arguments)),times<=1&&(func=null),memo}},_.once=_.partial(_.before,2);var hasEnumBug=!{toString:null}.propertyIsEnumerable("toString"),nonEnumerableProps=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"];_.keys=function(obj){if(!_.isObject(obj))return[];if(nativeKeys)return nativeKeys(obj);var keys=[];for(var key in obj)_.has(obj,key)&&keys.push(key);return hasEnumBug&&collectNonEnumProps(obj,keys),keys},_.allKeys=function(obj){if(!_.isObject(obj))return[];var keys=[];for(var key in obj)keys.push(key);return hasEnumBug&&collectNonEnumProps(obj,keys),keys},_.values=function(obj){for(var keys=_.keys(obj),length=keys.length,values=Array(length),i=0;i<length;i++)values[i]=obj[keys[i]];return values},_.mapObject=function(obj,iteratee,context){iteratee=cb(iteratee,context);for(var currentKey,keys=_.keys(obj),length=keys.length,results={},index=0;index<length;index++)currentKey=keys[index],results[currentKey]=iteratee(obj[currentKey],currentKey,obj);return results},_.pairs=function(obj){for(var keys=_.keys(obj),length=keys.length,pairs=Array(length),i=0;i<length;i++)pairs[i]=[keys[i],obj[keys[i]]];return pairs},_.invert=function(obj){for(var result={},keys=_.keys(obj),i=0,length=keys.length;i<length;i++)result[obj[keys[i]]]=keys[i];return result},_.functions=_.methods=function(obj){var names=[];for(var key in obj)_.isFunction(obj[key])&&names.push(key);return names.sort()},_.extend=createAssigner(_.allKeys),_.extendOwn=_.assign=createAssigner(_.keys),_.findKey=function(obj,predicate,context){predicate=cb(predicate,context);for(var key,keys=_.keys(obj),i=0,length=keys.length;i<length;i++)if(key=keys[i],predicate(obj[key],key,obj))return key},_.pick=function(object,oiteratee,context){var iteratee,keys,result={},obj=object;if(null==obj)return result;_.isFunction(oiteratee)?(keys=_.allKeys(obj),iteratee=optimizeCb(oiteratee,context)):(keys=flatten(arguments,!1,!1,1),iteratee=function(value,key,obj){return key in obj},obj=Object(obj));for(var i=0,length=keys.length;i<length;i++){var key=keys[i],value=obj[key];iteratee(value,key,obj)&&(result[key]=value)}return result},_.omit=function(obj,iteratee,context){if(_.isFunction(iteratee))iteratee=_.negate(iteratee);else{var keys=_.map(flatten(arguments,!1,!1,1),String);iteratee=function(value,key){return!_.contains(keys,key)}}return _.pick(obj,iteratee,context)},_.defaults=createAssigner(_.allKeys,!0),_.create=function(prototype,props){var result=baseCreate(prototype);return props&&_.extendOwn(result,props),result},_.clone=function(obj){return _.isObject(obj)?_.isArray(obj)?obj.slice():_.extend({},obj):obj},_.tap=function(obj,interceptor){return interceptor(obj),obj},_.isMatch=function(object,attrs){var keys=_.keys(attrs),length=keys.length;if(null==object)return!length;for(var obj=Object(object),i=0;i<length;i++){var key=keys[i];if(attrs[key]!==obj[key]||!(key in obj))return!1}return!0};var eq=function(a,b,aStack,bStack){if(a===b)return 0!==a||1/a===1/b;if(null==a||null==b)return a===b;a instanceof _&&(a=a._wrapped),b instanceof _&&(b=b._wrapped);var className=toString.call(a);if(className!==toString.call(b))return!1;switch(className){case"[object RegExp]":case"[object String]":return""+a==""+b;case"[object Number]":return+a!==+a?+b!==+b:0===+a?1/+a===1/b:+a===+b;case"[object Date]":case"[object Boolean]":return+a===+b}var areArrays="[object Array]"===className;if(!areArrays){if("object"!=typeof a||"object"!=typeof b)return!1;var aCtor=a.constructor,bCtor=b.constructor;if(aCtor!==bCtor&&!(_.isFunction(aCtor)&&aCtor instanceof aCtor&&_.isFunction(bCtor)&&bCtor instanceof bCtor)&&"constructor"in a&&"constructor"in b)return!1}aStack=aStack||[],bStack=bStack||[];for(var length=aStack.length;length--;)if(aStack[length]===a)return bStack[length]===b;if(aStack.push(a),bStack.push(b),areArrays){if(length=a.length,length!==b.length)return!1;for(;length--;)if(!eq(a[length],b[length],aStack,bStack))return!1}else{var key,keys=_.keys(a);if(length=keys.length,_.keys(b).length!==length)return!1;for(;length--;)if(key=keys[length],!_.has(b,key)||!eq(a[key],b[key],aStack,bStack))return!1}return aStack.pop(),bStack.pop(),!0};_.isEqual=function(a,b){return eq(a,b)},_.isEmpty=function(obj){return null==obj||(isArrayLike(obj)&&(_.isArray(obj)||_.isString(obj)||_.isArguments(obj))?0===obj.length:0===_.keys(obj).length)},_.isElement=function(obj){return!(!obj||1!==obj.nodeType)},_.isArray=nativeIsArray||function(obj){return"[object Array]"===toString.call(obj)},_.isObject=function(obj){var type=typeof obj;return"function"===type||"object"===type&&!!obj},_.each(["Arguments","Function","String","Number","Date","RegExp","Error"],function(name){_["is"+name]=function(obj){return toString.call(obj)==="[object "+name+"]"}}),_.isArguments(arguments)||(_.isArguments=function(obj){return _.has(obj,"callee")}),"function"!=typeof/./&&"object"!=typeof Int8Array&&(_.isFunction=function(obj){return"function"==typeof obj||!1}),_.isFinite=function(obj){return isFinite(obj)&&!isNaN(parseFloat(obj))},_.isNaN=function(obj){return _.isNumber(obj)&&obj!==+obj},_.isBoolean=function(obj){return obj===!0||obj===!1||"[object Boolean]"===toString.call(obj)},_.isNull=function(obj){return null===obj},_.isUndefined=function(obj){return void 0===obj},_.has=function(obj,key){return null!=obj&&hasOwnProperty.call(obj,key)},_.noConflict=function(){return root._=previousUnderscore,this},_.identity=function(value){return value},_.constant=function(value){return function(){return value}},_.noop=function(){},_.property=property,_.propertyOf=function(obj){return null==obj?function(){}:function(key){return obj[key]}},_.matcher=_.matches=function(attrs){return attrs=_.extendOwn({},attrs),function(obj){return _.isMatch(obj,attrs)}},_.times=function(n,iteratee,context){var accum=Array(Math.max(0,n));iteratee=optimizeCb(iteratee,context,1);for(var i=0;i<n;i++)accum[i]=iteratee(i);return accum},_.random=function(min,max){return null==max&&(max=min,min=0),min+Math.floor(Math.random()*(max-min+1))},_.now=Date.now||function(){return(new Date).getTime()};var escapeMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},unescapeMap=_.invert(escapeMap),createEscaper=function(map){var escaper=function(match){return map[match]},source="(?:"+_.keys(map).join("|")+")",testRegexp=RegExp(source),replaceRegexp=RegExp(source,"g");return function(string){return string=null==string?"":""+string,testRegexp.test(string)?string.replace(replaceRegexp,escaper):string}};_.escape=createEscaper(escapeMap),_.unescape=createEscaper(unescapeMap),_.result=function(object,property,fallback){var value=null==object?void 0:object[property];return void 0===value&&(value=fallback),_.isFunction(value)?value.call(object):value};var idCounter=0;_.uniqueId=function(prefix){var id=++idCounter+"";return prefix?prefix+id:id},_.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var noMatch=/(.)^/,escapes={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},escaper=/\\|'|\r|\n|\u2028|\u2029/g,escapeChar=function(match){return"\\"+escapes[match]};_.template=function(text,settings,oldSettings){!settings&&oldSettings&&(settings=oldSettings),settings=_.defaults({},settings,_.templateSettings);var matcher=RegExp([(settings.escape||noMatch).source,(settings.interpolate||noMatch).source,(settings.evaluate||noMatch).source].join("|")+"|$","g"),index=0,source="__p+='";text.replace(matcher,function(match,escape,interpolate,evaluate,offset){return source+=text.slice(index,offset).replace(escaper,escapeChar),index=offset+match.length,escape?source+="'+\n((__t=("+escape+"))==null?'':_.escape(__t))+\n'":interpolate?source+="'+\n((__t=("+interpolate+"))==null?'':__t)+\n'":evaluate&&(source+="';\n"+evaluate+"\n__p+='"),match}),source+="';\n",settings.variable||(source="with(obj||{}){\n"+source+"}\n"),source="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+source+"return __p;\n";try{var render=new Function(settings.variable||"obj","_",source)}catch(e){throw e.source=source,e}var template=function(data){return render.call(this,data,_)},argument=settings.variable||"obj";return template.source="function("+argument+"){\n"+source+"}",template},_.chain=function(obj){var instance=_(obj);return instance._chain=!0,instance};var result=function(instance,obj){return instance._chain?_(obj).chain():obj};_.mixin=function(obj){_.each(_.functions(obj),function(name){var func=_[name]=obj[name];_.prototype[name]=function(){var args=[this._wrapped];return push.apply(args,arguments),result(this,func.apply(_,args))}})},_.mixin(_),_.each(["pop","push","reverse","shift","sort","splice","unshift"],function(name){var method=ArrayProto[name];_.prototype[name]=function(){var obj=this._wrapped;return method.apply(obj,arguments),"shift"!==name&&"splice"!==name||0!==obj.length||delete obj[0],result(this,obj)}}),_.each(["concat","join","slice"],function(name){var method=ArrayProto[name];_.prototype[name]=function(){return result(this,method.apply(this._wrapped,arguments))}}),_.prototype.value=function(){return this._wrapped},_.prototype.valueOf=_.prototype.toJSON=_.prototype.value,_.prototype.toString=function(){return""+this._wrapped},__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return _}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),!(void 0!==__WEBPACK_AMD_DEFINE_RESULT__&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}).call(this)},function(module,exports,__webpack_require__){var json="undefined"!=typeof JSON?JSON:__webpack_require__(95);module.exports=function(obj,opts){opts||(opts={}),"function"==typeof opts&&(opts={cmp:opts});var space=opts.space||"";"number"==typeof space&&(space=Array(space+1).join(" "));var cycles="boolean"==typeof opts.cycles&&opts.cycles,replacer=opts.replacer||function(key,value){return value},cmp=opts.cmp&&function(f){return function(node){return function(a,b){var aobj={key:a,value:node[a]},bobj={key:b,value:node[b]};return f(aobj,bobj)}}}(opts.cmp),seen=[];return function stringify(parent,key,node,level){var indent=space?"\n"+new Array(level+1).join(space):"",colonSeparator=space?": ":":";if(node&&node.toJSON&&"function"==typeof node.toJSON&&(node=node.toJSON()),node=replacer.call(parent,key,node),void 0!==node){if("object"!=typeof node||null===node)return json.stringify(node);if(isArray(node)){for(var out=[],i=0;i<node.length;i++){var item=stringify(node,i,node[i],level+1)||json.stringify(null);out.push(indent+space+item)}return"["+out.join(",")+indent+"]"}if(seen.indexOf(node)!==-1){if(cycles)return json.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}seen.push(node);for(var keys=objectKeys(node).sort(cmp&&cmp(node)),out=[],i=0;i<keys.length;i++){var key=keys[i],value=stringify(node,key,node[key],level+1);if(value){var keyValue=json.stringify(key)+colonSeparator+value;out.push(indent+space+keyValue)}}return seen.splice(seen.indexOf(node),1),"{"+out.join(",")+indent+"}"}}({"":obj},"",obj,0)};var isArray=Array.isArray||function(x){return"[object Array]"==={}.toString.call(x)},objectKeys=Object.keys||function(obj){var has=Object.prototype.hasOwnProperty||function(){return!0},keys=[];for(var key in obj)has.call(obj,key)&&keys.push(key);return keys}},function(module,exports,__webpack_require__){function format(obj){if(!obj||"object"!=typeof obj)throw new TypeError("argument obj is required");var parameters=obj.parameters,subtype=obj.subtype,suffix=obj.suffix,type=obj.type;if(!type||!typeNameRegExp.test(type))throw new TypeError("invalid type");if(!subtype||!subtypeNameRegExp.test(subtype))throw new TypeError("invalid subtype");var string=type+"/"+subtype;if(suffix){if(!typeNameRegExp.test(suffix))throw new TypeError("invalid suffix");string+="+"+suffix}if(parameters&&"object"==typeof parameters)for(var param,params=Object.keys(parameters).sort(),i=0;i<params.length;i++){if(param=params[i],!tokenRegExp.test(param))throw new TypeError("invalid parameter name");string+="; "+param+"="+qstring(parameters[param])}return string}function parse(string){if(!string)throw new TypeError("argument string is required");if("object"==typeof string&&(string=getcontenttype(string)),"string"!=typeof string)throw new TypeError("argument string is required to be a string");var key,match,value,index=string.indexOf(";"),type=index!==-1?string.substr(0,index):string,obj=splitType(type),params={};for(paramRegExp.lastIndex=index;match=paramRegExp.exec(string);){if(match.index!==index)throw new TypeError("invalid parameter format");index+=match[0].length,key=match[1].toLowerCase(),value=match[2],'"'===value[0]&&(value=value.substr(1,value.length-2).replace(qescRegExp,"$1")),params[key]=value}if(index!==-1&&index!==string.length)throw new TypeError("invalid parameter format");return obj.parameters=params,obj}function getcontenttype(obj){return"function"==typeof obj.getHeader?obj.getHeader("content-type"):"object"==typeof obj.headers?obj.headers&&obj.headers["content-type"]:void 0}function qstring(val){var str=String(val);if(tokenRegExp.test(str))return str;if(str.length>0&&!textRegExp.test(str))throw new TypeError("invalid parameter value");return'"'+str.replace(quoteRegExp,"\\$1")+'"'}function splitType(string){var match=typeRegExp.exec(string.toLowerCase());if(!match)throw new TypeError("invalid media type");var suffix,type=match[1],subtype=match[2],index=subtype.lastIndexOf("+");index!==-1&&(suffix=subtype.substr(index+1),subtype=subtype.substr(0,index));var obj={type:type,subtype:subtype,suffix:suffix};return obj}var paramRegExp=/; *([!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+) *= *("(?:[ !\u0023-\u005b\u005d-\u007e\u0080-\u00ff]|\\[\u0020-\u007e])*"|[!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+) */g,textRegExp=/^[\u0020-\u007e\u0080-\u00ff]+$/,tokenRegExp=/^[!#$%&'\*\+\-\.0-9A-Z\^_`a-z\|~]+$/,qescRegExp=/\\([\u0000-\u007f])/g,quoteRegExp=/([\\"])/g,subtypeNameRegExp=/^[A-Za-z0-9][A-Za-z0-9!#$&^_.-]{0,126}$/,typeNameRegExp=/^[A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126}$/,typeRegExp=/^ *([A-Za-z0-9][A-Za-z0-9!#$&^_-]{0,126})\/([A-Za-z0-9][A-Za-z0-9!#$&^_.+-]{0,126}) *$/;exports.format=format,exports.parse=parse},function(module,exports,__webpack_require__){"use strict";function Response(statusCode,headers,body,url){if("number"!=typeof statusCode)throw new TypeError("statusCode must be a number but was "+typeof statusCode);if(null===headers)throw new TypeError("headers cannot be null");if("object"!=typeof headers)throw new TypeError("headers must be an object but was "+typeof headers);this.statusCode=statusCode,this.headers={};for(var key in headers)this.headers[key.toLowerCase()]=headers[key];this.body=body,this.url=url}module.exports=Response,Response.prototype.getBody=function(encoding){if(this.statusCode>=300){var err=new Error("Server responded with status code "+this.statusCode+":\n"+this.body.toString());throw err.statusCode=this.statusCode,err.headers=this.headers,err.body=this.body,err.url=this.url,err}return encoding?this.body.toString(encoding):this.body}},function(module,exports,__webpack_require__){(function(Buffer){function ConcatStream(opts,cb){if(!(this instanceof ConcatStream))return new ConcatStream(opts,cb);"function"==typeof opts&&(cb=opts,opts={}),opts||(opts={});var encoding=opts.encoding,shouldInferEncoding=!1;encoding?(encoding=String(encoding).toLowerCase(),"u8"!==encoding&&"uint8"!==encoding||(encoding="uint8array")):shouldInferEncoding=!0,Writable.call(this,{objectMode:!0}),this.encoding=encoding,this.shouldInferEncoding=shouldInferEncoding,cb&&this.on("finish",function(){cb(this.getBody())}),this.body=[]}function isArrayish(arr){return/Array\]$/.test(Object.prototype.toString.call(arr))}function stringConcat(parts){for(var strings=[],i=0;i<parts.length;i++){var p=parts[i];"string"==typeof p?strings.push(p):Buffer.isBuffer(p)?strings.push(p):strings.push(Buffer(p))}return Buffer.isBuffer(parts[0])?(strings=Buffer.concat(strings),strings=strings.toString("utf8")):strings=strings.join(""),strings}function bufferConcat(parts){for(var bufs=[],i=0;i<parts.length;i++){var p=parts[i];Buffer.isBuffer(p)?bufs.push(p):"string"==typeof p||isArrayish(p)||p&&"function"==typeof p.subarray?bufs.push(Buffer(p)):bufs.push(Buffer(String(p)))}return Buffer.concat(bufs)}function arrayConcat(parts){for(var res=[],i=0;i<parts.length;i++)res.push.apply(res,parts[i]);return res}function u8Concat(parts){for(var len=0,i=0;i<parts.length;i++)"string"==typeof parts[i]&&(parts[i]=Buffer(parts[i])),len+=parts[i].length;for(var u8=new U8(len),i=0,offset=0;i<parts.length;i++)for(var part=parts[i],j=0;j<part.length;j++)u8[offset++]=part[j];return u8}var Writable=__webpack_require__(102).Writable,inherits=__webpack_require__(115);if("undefined"==typeof Uint8Array)var U8=__webpack_require__(96).Uint8Array;else var U8=Uint8Array;module.exports=ConcatStream,inherits(ConcatStream,Writable),ConcatStream.prototype._write=function(chunk,enc,next){this.body.push(chunk),next()},ConcatStream.prototype.inferEncoding=function(buff){var firstBuffer=void 0===buff?this.body[0]:buff;return Buffer.isBuffer(firstBuffer)?"buffer":"undefined"!=typeof Uint8Array&&firstBuffer instanceof Uint8Array?"uint8array":Array.isArray(firstBuffer)?"array":"string"==typeof firstBuffer?"string":"[object Object]"===Object.prototype.toString.call(firstBuffer)?"object":"buffer"},ConcatStream.prototype.getBody=function(){return this.encoding||0!==this.body.length?(this.shouldInferEncoding&&(this.encoding=this.inferEncoding()),"array"===this.encoding?arrayConcat(this.body):"string"===this.encoding?stringConcat(this.body):"buffer"===this.encoding?bufferConcat(this.body):"uint8array"===this.encoding?u8Concat(this.body):this.body):[]};Array.isArray||function(arr){return"[object Array]"==Object.prototype.toString.call(arr)}}).call(exports,__webpack_require__(92).Buffer)},function(module,exports,__webpack_require__){(function(Buffer){function fromBase64(base64string){return base64string.replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}function toBase64(base64UrlString){Buffer.isBuffer(base64UrlString)&&(base64UrlString=base64UrlString.toString());var b64str=padString(base64UrlString).replace(/\-/g,"+").replace(/_/g,"/");return b64str}function padString(string){var segmentLength=4,stringLength=string.length,diff=string.length%segmentLength;if(!diff)return string;var position=stringLength,padLength=segmentLength-diff,paddedStringLength=stringLength+padLength,buffer=Buffer(paddedStringLength);for(buffer.write(string);padLength--;)buffer.write("=",position++);return buffer.toString()}function decodeBase64Url(base64UrlString,encoding){return Buffer(toBase64(base64UrlString),"base64").toString(encoding)}function base64url(stringOrBuffer,encoding){return fromBase64(Buffer(stringOrBuffer,encoding).toString("base64"))}function toBuffer(base64string){return Buffer(toBase64(base64string),"base64")}base64url.toBase64=toBase64,base64url.fromBase64=fromBase64,base64url.decode=decodeBase64Url,base64url.encode=base64url,base64url.toBuffer=toBuffer,module.exports=base64url}).call(exports,__webpack_require__(92).Buffer)},function(module,exports,__webpack_require__){(function(process){"use strict";var invariant=function(condition,format,a,b,c,d,e,f){if("production"!==process.env.NODE_ENV&&void 0===format)throw new Error("invariant requires an error message argument");if(!condition){var error;if(void 0===format)error=new Error("Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings.");else{var args=[a,b,c,d,e,f],argIndex=0;error=new Error(format.replace(/%s/g,function(){return args[argIndex++]})),error.name="Invariant Violation"}throw error.framesToPop=1,error}};module.exports=invariant}).call(exports,__webpack_require__(59))},function(module,exports,__webpack_require__){"use strict";var def=__webpack_require__(36),universes=__webpack_require__(22),universeHelpers=__webpack_require__(14),services=def,search=__webpack_require__(23),AttributeDefaultsCalculator=function(){function AttributeDefaultsCalculator(enabled){this.enabled=enabled,this.valueCalculators=[new RequiredPropertyCalculator,new TypePropertyCalculator,new DisplayNamePropertyCalculator,new MediaTypeCalculator,new SecuredByPropertyCalculator,new ProtocolsPropertyCalculator,new VersionParamEnumCalculator]}return AttributeDefaultsCalculator.prototype.attributeDefaultIfEnabled=function(node,attributeProperty){return this.enabled?this.getAttributeDefault(node,attributeProperty):null},AttributeDefaultsCalculator.prototype.getAttributeDefault=function(node,attributeProperty){if(!node||!attributeProperty)return null;try{return this.getAttributeDefault2(attributeProperty,node)}catch(Error){return console.log(Error),null}},AttributeDefaultsCalculator.prototype.getWrapperAttributeDefault=function(wrapperNode,attributeName){var highLevelNode=wrapperNode.highLevel();if(null==highLevelNode)return null;var property=highLevelNode.definition().property(attributeName);return null==property?null:this.getAttributeDefault(highLevelNode,property)},AttributeDefaultsCalculator.prototype.getAttributeDefault2=function(attributeProperty,node){for(var i=0;i<this.valueCalculators.length;i++){var calculator=this.valueCalculators[i];if(calculator.matches(attributeProperty,node)){var value=calculator.calculate(attributeProperty,node);if(null!=value)return value}}return null!=attributeProperty.defaultValue()?attributeProperty.defaultValue():null},AttributeDefaultsCalculator.prototype.isEnabled=function(){return this.enabled},AttributeDefaultsCalculator.prototype.insertionKind=function(node,attributeProperty){for(var i=0;i<this.valueCalculators.length;i++){var calculator=this.valueCalculators[i];if(calculator.matches(attributeProperty,node))return calculator.kind()}return null!=attributeProperty.defaultValue()?InsertionKind.BY_DEFAULT:null},AttributeDefaultsCalculator}();exports.AttributeDefaultsCalculator=AttributeDefaultsCalculator,function(InsertionKind){InsertionKind[InsertionKind.CALCULATED=0]="CALCULATED",InsertionKind[InsertionKind.BY_DEFAULT=1]="BY_DEFAULT"}(exports.InsertionKind||(exports.InsertionKind={}));var InsertionKind=exports.InsertionKind,MediaTypeCalculator=function(){function MediaTypeCalculator(){}return MediaTypeCalculator.prototype.calculate=function(attributeProperty,node){var root=search.declRoot(node);if(root&&universeHelpers.isApiSibling(root.definition())){var defaultMediaTypeAttr=root.attr(universes.Universe10.Api.properties.mediaType.name);if(defaultMediaTypeAttr)return defaultMediaTypeAttr.value()}return null},MediaTypeCalculator.prototype.matches=function(attributeProperty,node){if(!universeHelpers.isNameProperty(attributeProperty))return!1;var nodeDefinition=node.definition();if(!nodeDefinition)return!1;if(!universeHelpers.isBodyLikeType(nodeDefinition)&&!universeHelpers.isTypeDeclarationSibling(nodeDefinition))return!1;var parentNode=node.parent();if(null==parentNode)return!1;var parentDefinition=parentNode.definition();if(null==parentDefinition)return!1;if(!universeHelpers.isResponseType(parentDefinition)&&!universeHelpers.isMethodBaseSibling(parentDefinition))return!1;for(var ancestor=parentNode;ancestor;){var aDef=ancestor.definition();if(universeHelpers.isTraitType(aDef))return!1;if(universeHelpers.isResourceTypeType(aDef))return!1;ancestor=ancestor.parent()}return!0},MediaTypeCalculator.prototype.kind=function(){return InsertionKind.CALCULATED},MediaTypeCalculator}(),DisplayNamePropertyCalculator=function(){function DisplayNamePropertyCalculator(){}return DisplayNamePropertyCalculator.prototype.calculate=function(attributeProperty,node){var nodeDefinition=node.definition();if(null==nodeDefinition)return null;var adapter=nodeDefinition.getAdapter(services.RAMLService),keyProperty=adapter.getKeyProp();if(null!=keyProperty){var attributeValue=node.attrValue(keyProperty.nameId());return null!=attributeValue?attributeValue:new AttributeDefaultsCalculator((!0)).getAttributeDefault(node,keyProperty)}return null},DisplayNamePropertyCalculator.prototype.matches=function(attributeProperty,node){var nodeDefinition=node.definition();return null!=nodeDefinition&&((universeHelpers.isTypeDeclarationSibling(nodeDefinition)||nodeDefinition.isAssignableFrom(universes.Universe08.Parameter.name)||universeHelpers.isResourceType(nodeDefinition))&&universeHelpers.isDisplayNameProperty(attributeProperty))},DisplayNamePropertyCalculator.prototype.kind=function(){return InsertionKind.CALCULATED},DisplayNamePropertyCalculator}(),TypePropertyCalculator=function(){function TypePropertyCalculator(){}return TypePropertyCalculator.prototype.calculate=function(attributeProperty,node){return"object"},TypePropertyCalculator.prototype.matches=function(attributeProperty,node){return universeHelpers.isTypeProperty(attributeProperty)&&null!=node.definition()&&universeHelpers.isObjectTypeDeclarationSibling(node.definition())},TypePropertyCalculator.prototype.kind=function(){return InsertionKind.BY_DEFAULT},TypePropertyCalculator}(),RequiredPropertyCalculator=function(){function RequiredPropertyCalculator(){}return RequiredPropertyCalculator.prototype.calculate=function(attributeProperty,node){var nodeDefinition=node.definition(),nodeProperty=node.property();if(null==nodeDefinition)return null;var adapter=nodeDefinition.getAdapter(services.RAMLService),keyProperty=adapter.getKeyProp();if(null!=keyProperty){var attribute=node.attr(keyProperty.nameId());if(null!=attribute&&attribute.optional())return!1}if(null!=nodeProperty){if(universeHelpers.isHeadersProperty(nodeProperty)||universeHelpers.isFormParametersProperty(nodeProperty)||universeHelpers.isQueryParametersProperty(nodeProperty))return"RAML08"!=attributeProperty.domain().universe().version();if(universeHelpers.isUriParametersProperty(nodeProperty)||universeHelpers.isBaseUriParametersProperty(nodeProperty))return!0}return null!=attributeProperty.defaultValue()?attributeProperty.defaultValue():null},RequiredPropertyCalculator.prototype.matches=function(attributeProperty,node){return universeHelpers.isRequiredProperty(attributeProperty)},RequiredPropertyCalculator.prototype.kind=function(){return InsertionKind.BY_DEFAULT},RequiredPropertyCalculator}(),SecuredByPropertyCalculator=function(){function SecuredByPropertyCalculator(){}return SecuredByPropertyCalculator.prototype.calculate=function(attributeProperty,node){if(universeHelpers.isApiSibling(node.definition()))return null;var values,definition=node.definition();if(universeHelpers.isMethodType(definition)){var resource=node.parent();resource&&(values=resource.wrapperNode().securedBy())}if(!values||0==values.length){for(;null!=node&&!universeHelpers.isApiSibling(node.definition());)node=node.parent();node&&(values=node.wrapperNode().securedBy())}return values&&values.length>0?values:null},SecuredByPropertyCalculator.prototype.matches=function(attributeProperty,node){var nodeDefinition=node.definition();return null!=nodeDefinition&&universeHelpers.isSecuredByProperty(attributeProperty)},SecuredByPropertyCalculator.prototype.kind=function(){
return InsertionKind.CALCULATED},SecuredByPropertyCalculator}(),ProtocolsPropertyCalculator=function(){function ProtocolsPropertyCalculator(){}return ProtocolsPropertyCalculator.prototype.calculate=function(attributeProperty,node){for(;null!=node&&!universeHelpers.isApiSibling(node.definition());)node=node.parent();var result,baseUriAttr=node.attr(universes.Universe10.Api.properties.baseUri.name);if(baseUriAttr){var baseUri=baseUriAttr.value();if(baseUri){var ind=baseUri.indexOf("://");ind>=0&&(result=[baseUri.substring(0,ind).toUpperCase()]),result||(result=["HTTP"])}}return result},ProtocolsPropertyCalculator.prototype.matches=function(attributeProperty,node){if(!universeHelpers.isProtocolsProperty(attributeProperty))return!1;var nodeDefinition=node.definition(),hasAppropriateLocation=!1;if(universeHelpers.isApiSibling(nodeDefinition))hasAppropriateLocation=!0;else if(universeHelpers.isResourceType(nodeDefinition))hasAppropriateLocation=!0;else if(universeHelpers.isMethodType(nodeDefinition)){var parentNode=node.parent();hasAppropriateLocation=parentNode&&universeHelpers.isResourceType(parentNode.definition())}return hasAppropriateLocation},ProtocolsPropertyCalculator.prototype.kind=function(){return InsertionKind.CALCULATED},ProtocolsPropertyCalculator}(),VersionParamEnumCalculator=function(){function VersionParamEnumCalculator(){}return VersionParamEnumCalculator.prototype.calculate=function(attributeProperty,node){for(;null!=node&&!universeHelpers.isApiSibling(node.definition());)node=node.parent();var versionAttr=node.attr(universes.Universe10.Api.properties.version.name);if(versionAttr){var versionValue=versionAttr.value();if(versionValue&&versionValue.trim())return[versionValue]}return null},VersionParamEnumCalculator.prototype.matches=function(attributeProperty,node){if(!universeHelpers.isEnumProperty(attributeProperty))return!1;var nodeProperty=node.property();if(!nodeProperty)return!1;if(!universeHelpers.isBaseUriParametersProperty(nodeProperty))return!1;var nameAttr=node.attr(universes.Universe10.TypeDeclaration.properties.name.name),paramName=nameAttr&&nameAttr.value();return"version"==paramName},VersionParamEnumCalculator.prototype.kind=function(){return InsertionKind.CALCULATED},VersionParamEnumCalculator}()},function(module,exports,__webpack_require__){"use strict";function dump(node,serializeMeta){return void 0===serializeMeta&&(serializeMeta=!0),new TCKDumper({rootNodeDetails:!0,serializeMetadata:serializeMeta}).dump(node)}var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},universe=__webpack_require__(22),core=__webpack_require__(45),def=__webpack_require__(36),hlImpl=__webpack_require__(16),builder=__webpack_require__(26),universeHelpers=__webpack_require__(14),universes=__webpack_require__(22),RamlWrapper10=__webpack_require__(12);exports.dump=dump;var TCKDumper=function(){function TCKDumper(options){this.options=options,this.nodeTransformers=[new ResourcesTransformer,new TypeExampleTransformer,new TypesTransformer,new SecuritySchemesTransformer,new AnnotationTypesTransformer,new TemplateParametrizedPropertiesTransformer,new TraitsTransformer,new ResourceTypesTransformer,new SchemasTransformer,new ProtocolsToUpperCaseTransformer,new ResourceTypeMethodsToMapTransformer,new ReferencesTransformer],this.nodePropertyTransformers=[new ParametersTransformer,new PropertiesTransformer,new ResponsesTransformer,new BodiesTransformer,new AnnotationsTransformer,new FacetsTransformer,new OneElementArrayTransformer],this.ignore=new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isResponseType,universeHelpers.isDisplayNameProperty),new BasicObjectPropertyMatcher(universeHelpers.isApiSibling,universeHelpers.isDisplayNameProperty),new BasicObjectPropertyMatcher(universeHelpers.isAnnotationRefTypeOrDescendant,universeHelpers.isAnnotationProperty),new BasicObjectPropertyMatcher(universeHelpers.isSecuritySchemeRefType,universeHelpers.isSecuritySchemeProperty),new BasicObjectPropertyMatcher(universeHelpers.isTraitRefType,universeHelpers.isTraitProperty),new BasicObjectPropertyMatcher(universeHelpers.isResourceTypeRefType,universeHelpers.isResourceTypeProperty),new BasicObjectPropertyMatcher(universeHelpers.isApiSibling,universeHelpers.isRAMLVersionProperty)]),this.missingProperties=new PropertiesData,this.options=this.options||{},null==this.options.serializeMetadata&&(this.options.serializeMetadata=!0)}return TCKDumper.prototype.printMissingProperties=function(){return this.missingProperties.print()},TCKDumper.prototype.dump=function(node){var highLevelNode=node.highLevel(),highLevelParent=highLevelNode&&highLevelNode.parent(),rootNodeDetails=!highLevelParent&&this.options.rootNodeDetails;return this.dumpInternal(node,rootNodeDetails)},TCKDumper.prototype.dumpInternal=function(node,rootNodeDetails){var _this=this;if(void 0===rootNodeDetails&&(rootNodeDetails=!1),null==node)return null;if(node instanceof core.BasicNodeImpl){var props={},basicNode=node,definition=basicNode.highLevel().definition();definition.allProperties().filter(function(x){return!_this.ignore.match(basicNode.definition(),x)}).forEach(function(x){props[x.nameId()]=x}),definition.allCustomProperties().filter(function(x){return!_this.ignore.match(basicNode.definition(),x)}).forEach(function(x){props[x.nameId()]=x});var obj=this.dumpProperties(props,node);if(props.schema&&this.options.dumpSchemaContents&&props.schema.range().key()==universes.Universe08.SchemaString){var schemas=basicNode.highLevel().root().elementsOfKind("schemas");schemas.forEach(function(x){if(x.name()==obj.schema){var vl=x.attr("value");vl&&(obj.schema=vl.value(),obj.schemaContent=vl.value())}})}if(this.serializeScalarsAnnotations(obj,basicNode,props),this.serializeMeta(obj,basicNode),this.canBeFragment(node)&&RamlWrapper10.isFragment(node)){var fragment=RamlWrapper10.asFragment(node),uses=fragment.uses();uses.length>0&&(obj.uses=uses.map(function(x){return x.toJSON()}))}this.nodeTransformers.forEach(function(x){x.match(node,node.highLevel().property())&&(obj=x.transform(obj))});var result={};if(rootNodeDetails){if(definition){var ramlVersion=definition.universe().version();result.ramlVersion=ramlVersion,result.type=definition.nameId()}result.specification=obj,result.errors=this.dumpErrors(basicNode.errors())}else result=obj;return result}if(node instanceof core.AttributeNodeImpl){var props={},attrNode=node,definition=attrNode.highLevel().definition();definition.allCustomProperties().filter(function(x){return!_this.ignore.match(attrNode.highLevel().property().range(),x)}).forEach(function(x){props[x.nameId()]=x});var isValueType=attrNode.highLevel().property().range().isValueType();if(isValueType&&attrNode.value){var val=attrNode.value();if("number"==typeof val||"string"==typeof val||"boolean"==typeof val)return val}var obj=this.dumpProperties(props,node);return this.nodeTransformers.forEach(function(x){x.match(node,node.highLevel().property())&&(obj=x.transform(obj))}),this.serializeScalarsAnnotations(obj,node,props),this.serializeMeta(obj,attrNode),obj}return node instanceof core.TypeInstanceImpl?this.serializeTypeInstance(node):node instanceof core.TypeInstancePropertyImpl?this.serializeTypeInstanceProperty(node):node},TCKDumper.prototype.canBeFragment=function(node){var definition=node.definition(),arr=[definition].concat(definition.allSubTypes()),arr1=arr.filter(function(x){return x.getAdapter(def.RAMLService).possibleInterfaces().filter(function(y){return y.nameId()==def.universesInfo.Universe10.FragmentDeclaration.name}).length>0});return arr1.length>0},TCKDumper.prototype.dumpErrors=function(errors){return errors.map(function(x){var eObj={code:x.code,message:x.message,path:x.path,line:x.line,column:x.column,position:x.start,range:x.range};return x.isWarning===!0&&(eObj.isWarning=!0),eObj}).sort(function(x,y){return x.path!=y.path?x.path.localeCompare(y.path):x.position!=y.position?x.position-y.position:x.code-y.code})},TCKDumper.prototype.dumpProperties=function(props,node){var _this=this,obj={};return Object.keys(props).forEach(function(propName){if(!node[propName])return void _this.missingProperties.addProperty(props[propName],node.kind());var property=props[propName],value=node[propName]();if(value&&"structuredType"==propName&&"object"==typeof value){value=null;var highLevelNode=node.highLevel(),a=highLevelNode.lowLevel();a.children().forEach(function(x){if("type"==x.key()||"schema"==x.key()){var td=highLevelNode.definition().universe().type(universe.Universe10.TypeDeclaration.name),hasType=highLevelNode.definition().universe().type(universe.Universe10.LibraryBase.name),tNode=new hlImpl.ASTNodeImpl(x,highLevelNode,td,hasType.property(universe.Universe10.LibraryBase.properties.types.name));tNode.patchType(builder.doDescrimination(tNode)),value=dump(tNode.wrapperNode()),propName=x.key()}})}if((value||"type"!=propName)&&(value||"schema"!=propName)){if(node.definition&&universeHelpers.isTypeDeclarationSibling(node.definition())&&universeHelpers.isTypeProperty(property)){var schemaValue=node[universe.Universe10.TypeDeclaration.properties.schema.name]();if(null!=schemaValue&&(!Array.isArray(schemaValue)||0!=schemaValue.length))return;var highLevelNode=node.highLevel(),a=highLevelNode.lowLevel(),hasSchema=!1;if(a.children().forEach(function(x){if("schema"==x.key())return void(hasSchema=!0)}),hasSchema)return}if(Array.isArray(value)){for(var propertyValue=[],_i=0,value_1=value;_i<value_1.length;_i++){var val=value_1[_i],dumped=_this.dumpInternal(val);"examples"===propName&&_this.options&&_this.options.dumpXMLRepresentationOfExamples&&val.expandable&&val.expandable._owner&&(dumped.asXMLString=val.expandable.asXMLString()),propertyValue.push(dumped)}if(0==propertyValue.length&&node instanceof core.BasicNodeImpl&&!_this.isDefined(node,propName))return;for(var _a=0,_b=_this.nodePropertyTransformers;_a<_b.length;_a++){var x=_b[_a];x.match(node,property)&&(propertyValue=x.transform(propertyValue))}obj[propName]=propertyValue}else{var val=_this.dumpInternal(value);if(null==val&&node instanceof core.BasicNodeImpl&&!_this.isDefined(node,propName))return;node instanceof core.BasicNodeImpl&&_this.nodePropertyTransformers.forEach(function(x){x.match(node,property)&&(val=x.transform(val))}),obj[propName]=val,"example"===propName&&_this.options&&_this.options.dumpXMLRepresentationOfExamples&&value.expandable&&value.expandable._owner&&(val.asXMLString=value.expandable.asXMLString())}}}),obj},TCKDumper.prototype.serializeScalarsAnnotations=function(obj,node,props){var _this=this;if(node.scalarsAnnotations){for(var val={},accessor=node.scalarsAnnotations(),_i=0,_a=Object.keys(props);_i<_a.length;_i++){var propName=_a[_i];if(accessor[propName]){var arr=accessor[propName]();if(arr.length>0)if(Array.isArray(arr[0])){var arr1=[];arr.forEach(function(x,i){arr1.push(x.map(function(y){return _this.dumpInternal(y)}))}),arr1.filter(function(x){return x.length>0}).length>0&&(val[propName]=arr1)}else val[propName]=arr.map(function(x){return _this.dumpInternal(x)})}}Object.keys(val).length>0&&(obj.scalarsAnnotations=val)}},TCKDumper.prototype.serializeMeta=function(obj,node){if(this.options.serializeMetadata){var meta=node.meta();meta.isDefault()||(obj.__METADATA__=meta.toJSON())}},TCKDumper.prototype.serializeTypeInstance=function(inst){var _this=this;if(inst.isScalar())return inst.value();if(inst.isArray())return inst.items().map(function(x){return _this.serializeTypeInstance(x)});var props=inst.properties();if(0==props.length)return null;var obj={};return props.forEach(function(x){return obj[x.name()]=_this.serializeTypeInstanceProperty(x)}),obj},TCKDumper.prototype.serializeTypeInstanceProperty=function(prop){var _this=this;if(prop.isArray()){var values=prop.values(),arr=[];return values.forEach(function(x){return arr.push(_this.serializeTypeInstance(x))}),arr}return this.serializeTypeInstance(prop.value())},TCKDumper.prototype.isDefined=function(node,name){var hl=node.highLevel();return hl.elementsOfKind(name).length>0||hl.attributes(name).length>0},TCKDumper}();exports.TCKDumper=TCKDumper;var BasicObjectPropertyMatcher=function(){function BasicObjectPropertyMatcher(typeMatcher,propMatcher){this.typeMatcher=typeMatcher,this.propMatcher=propMatcher}return BasicObjectPropertyMatcher.prototype.match=function(td,prop){return(null==td||this.typeMatcher(td))&&(null==prop||this.propMatcher(prop))},BasicObjectPropertyMatcher}(),CompositeObjectPropertyMatcher=function(){function CompositeObjectPropertyMatcher(matchers){this.matchers=matchers}return CompositeObjectPropertyMatcher.prototype.match=function(td,prop){for(var l=this.matchers.length,i=0;i<l;i++)if(this.matchers[i].match(td,prop))return!0;return!1},CompositeObjectPropertyMatcher}(),ArrayToMapTransformer=function(){function ArrayToMapTransformer(matcher,propName){this.matcher=matcher,this.propName=propName}return ArrayToMapTransformer.prototype.match=function(node,prop){return this.matcher.match(node.definition(),prop)},ArrayToMapTransformer.prototype.transform=function(value){var _this=this;if(Array.isArray(value)&&value.length>0&&value[0][this.propName]){var obj={};return value.forEach(function(x){var key=x[_this.propName],previous=obj[key];previous?Array.isArray(previous)?previous.push(x):obj[key]=[previous,x]:obj[key]=x}),obj}return value},ArrayToMapTransformer}(),ArrayToMappingsArrayTransformer=function(){function ArrayToMappingsArrayTransformer(matcher,propName){this.matcher=matcher,this.propName=propName}return ArrayToMappingsArrayTransformer.prototype.match=function(node,prop){return this.matcher.match(node.definition?node.definition():null,prop)},ArrayToMappingsArrayTransformer.prototype.transform=function(value){if(Array.isArray(value))return value;var obj={};return obj[value[this.propName]]=value,obj},ArrayToMappingsArrayTransformer}(),ParametersTransformer=function(_super){function ParametersTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isApiSibling,universeHelpers.isBaseUriParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isResourceBaseSibling,universeHelpers.isUriParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isResourceBaseSibling,universeHelpers.isQueryParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isTraitType,universeHelpers.isQueryParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isMethodType,universeHelpers.isQueryParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isSecuritySchemePartType,universeHelpers.isQueryParametersProperty),new BasicObjectPropertyMatcher(universeHelpers.isTraitType,universeHelpers.isHeadersProperty),new BasicObjectPropertyMatcher(universeHelpers.isMethodType,universeHelpers.isHeadersProperty),new BasicObjectPropertyMatcher(universeHelpers.isSecuritySchemePartType,universeHelpers.isHeadersProperty),new BasicObjectPropertyMatcher(universeHelpers.isBodyLikeType,universeHelpers.isFormParametersProperty)]),"name")}return __extends(ParametersTransformer,_super),ParametersTransformer}(ArrayToMapTransformer),TypesTransformer=function(_super){function TypesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isLibraryBaseSibling,universeHelpers.isTypesProperty),new BasicObjectPropertyMatcher(function(x){return universeHelpers.isLibraryBaseSibling(x)&&universeHelpers.isRAML10Type(x)},universeHelpers.isSchemasProperty)]),"name")}return __extends(TypesTransformer,_super),TypesTransformer.prototype.match=function(node,prop){return null!=node.parent()&&this.matcher.match(node.parent().definition(),prop)},TypesTransformer}(ArrayToMappingsArrayTransformer),PropertiesTransformer=(function(_super){function UsesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isLibraryBaseSibling,universeHelpers.isUsesProperty)]),"name")}return __extends(UsesTransformer,_super),UsesTransformer}(ArrayToMapTransformer),function(_super){function PropertiesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isObjectTypeDeclarationSibling,universeHelpers.isPropertiesProperty)]),"name")}return __extends(PropertiesTransformer,_super),PropertiesTransformer}(ArrayToMapTransformer)),ResponsesTransformer=function(_super){function ResponsesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isMethodBaseSibling,universeHelpers.isResponsesProperty)]),"code")}return __extends(ResponsesTransformer,_super),ResponsesTransformer}(ArrayToMapTransformer),AnnotationsTransformer=function(_super){function AnnotationsTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(function(x){return!0},universeHelpers.isAnnotationsProperty)]),"name")}return __extends(AnnotationsTransformer,_super),AnnotationsTransformer}(ArrayToMapTransformer),BodiesTransformer=function(_super){function BodiesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isResponseType,universeHelpers.isBodyProperty),new BasicObjectPropertyMatcher(universeHelpers.isMethodBaseSibling,universeHelpers.isBodyProperty)]),"name")}return __extends(BodiesTransformer,_super),BodiesTransformer}(ArrayToMapTransformer),TraitsTransformer=function(_super){function TraitsTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isTraitType,universeHelpers.isTraitsProperty)]),"name")}return __extends(TraitsTransformer,_super),TraitsTransformer}(ArrayToMappingsArrayTransformer),ResourceTypesTransformer=function(_super){function ResourceTypesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isResourceTypeType,universeHelpers.isResourceTypesProperty)]),"name")}return __extends(ResourceTypesTransformer,_super),ResourceTypesTransformer.prototype.transform=function(value){var methodsPropertyName=universes.Universe10.ResourceBase.properties.methods.name;if(Array.isArray(value))return value;var methods=value[methodsPropertyName];return methods&&methods.forEach(function(m){var keys=Object.keys(m);if(keys.length>0){var methodName=keys[0];value[methodName]=m[methodName]}}),delete value[methodsPropertyName],_super.prototype.transform.call(this,value)},ResourceTypesTransformer}(ArrayToMappingsArrayTransformer),FacetsTransformer=function(_super){function FacetsTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isTypeDeclarationSibling,universeHelpers.isFacetsProperty)]),"name")}return __extends(FacetsTransformer,_super),FacetsTransformer}(ArrayToMapTransformer),SecuritySchemesTransformer=function(_super){function SecuritySchemesTransformer(){_super.call(this,null,"name")}return __extends(SecuritySchemesTransformer,_super),SecuritySchemesTransformer.prototype.match=function(node,prop){return null!=prop&&universeHelpers.isSecuritySchemesProperty(prop)},SecuritySchemesTransformer}(ArrayToMappingsArrayTransformer),AnnotationTypesTransformer=function(_super){function AnnotationTypesTransformer(){_super.call(this,new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isLibraryBaseSibling,universeHelpers.isAnnotationTypesProperty)]),"name")}return __extends(AnnotationTypesTransformer,_super),AnnotationTypesTransformer.prototype.match=function(node,prop){return null!=node.parent()&&this.matcher.match(node.parent().definition(),prop)},AnnotationTypesTransformer}(ArrayToMappingsArrayTransformer),ResourceTypeMethodsToMapTransformer=function(_super){function ResourceTypeMethodsToMapTransformer(){_super.call(this,null,"method")}return __extends(ResourceTypeMethodsToMapTransformer,_super),ResourceTypeMethodsToMapTransformer.prototype.match=function(node,prop){return null!=node.parent()&&universeHelpers.isResourceTypeType(node.parent().definition())&&universeHelpers.isMethodsProperty(prop)},ResourceTypeMethodsToMapTransformer}(ArrayToMappingsArrayTransformer),exampleNameProp=universe.Universe10.ExampleSpec.properties.name.name,exampleContentProp=universe.Universe10.ExampleSpec.properties.value.name,exampleStructuredContentProp="structuredContent",TypeExampleTransformer=(function(){function ExamplesTransformer(){}return ExamplesTransformer.prototype.match=function(node,prop){return universeHelpers.isExampleSpecType(node.definition())},ExamplesTransformer.prototype.transform=function(value){var _this=this;if(Array.isArray(value)&&value.length>0){if(value[0][exampleNameProp]){var obj={};return value.forEach(function(x){return obj[x[exampleNameProp]]=_this.getActualExample(x)}),obj}var arr=value.map(function(x){return _this.getActualExample(x)});return arr}return value},ExamplesTransformer.prototype.getActualExample=function(exampleSpecObj){return exampleSpecObj[exampleStructuredContentProp]?exampleSpecObj[exampleStructuredContentProp]:exampleSpecObj[exampleContentProp]},ExamplesTransformer}(),function(){function TypeExampleTransformer(){}return TypeExampleTransformer.prototype.match=function(node,prop){return node.definition&&universeHelpers.isTypeDeclarationSibling(node.definition())},TypeExampleTransformer.prototype.transform=function(value){var isArray=Array.isArray(value),arr=isArray?value:[value];return arr.forEach(function(x){var structuredExample=x.example;structuredExample&&(x.example=structuredExample.structuredValue,x.structuredExample=structuredExample)}),isArray?arr:arr[0]},TypeExampleTransformer}()),SchemasTransformer=function(){function SchemasTransformer(){this.matcher=new BasicObjectPropertyMatcher(function(x){return universeHelpers.isApiType(x)&&universeHelpers.isRAML08Type(x)},universeHelpers.isSchemasProperty)}return SchemasTransformer.prototype.match=function(node,prop){return null!=node.parent()&&this.matcher.match(node.parent().definition(),prop)},SchemasTransformer.prototype.transform=function(value){if(Array.isArray(value))return value;var obj={};return obj[value.key]=value.value,obj},SchemasTransformer.prototype.getActualExample=function(exampleSpecObj){return exampleSpecObj[exampleStructuredContentProp]?exampleSpecObj[exampleStructuredContentProp]:exampleSpecObj[exampleContentProp]},SchemasTransformer}(),ProtocolsToUpperCaseTransformer=function(){function ProtocolsToUpperCaseTransformer(){}return ProtocolsToUpperCaseTransformer.prototype.match=function(node,prop){return null!=prop&&universeHelpers.isProtocolsProperty(prop)},ProtocolsToUpperCaseTransformer.prototype.transform=function(value){return"string"==typeof value?value.toUpperCase():Array.isArray(value)?value.map(function(x){return x.toUpperCase()}):value},ProtocolsToUpperCaseTransformer}(),OneElementArrayTransformer=function(){function OneElementArrayTransformer(){this.usecases=new CompositeObjectPropertyMatcher([new BasicObjectPropertyMatcher(universeHelpers.isApiSibling,universeHelpers.isMediaTypeProperty)])}return OneElementArrayTransformer.prototype.match=function(node,prop){return this.usecases.match(node.definition(),prop)},OneElementArrayTransformer.prototype.transform=function(value){return Array.isArray(value)&&1==value.length?value[0]:value},OneElementArrayTransformer}(),ResourcesTransformer=function(){function ResourcesTransformer(){}return ResourcesTransformer.prototype.match=function(node,prop){return null!=prop&&universeHelpers.isResourcesProperty(prop)},ResourcesTransformer.prototype.transform=function(value){if(Array.isArray(value))return value;var relUri=value[universes.Universe10.Resource.properties.relativeUri.name];if(relUri){for(var segments=relUri.trim().split("/");segments.length>0&&0==segments[0].length;)segments.shift();value.relativeUriPathSegments=segments}return value},ResourcesTransformer}(),TemplateParametrizedPropertiesTransformer=function(){function TemplateParametrizedPropertiesTransformer(){}return TemplateParametrizedPropertiesTransformer.prototype.match=function(node,prop){var hlNode=node.highLevel();if(!hlNode)return!1;var d=hlNode.definition();return!!d&&(universeHelpers.isResourceTypeType(d)||universeHelpers.isTraitType(d)||universeHelpers.isMethodType(d)||universeHelpers.isTypeDeclarationSibling(d))},TemplateParametrizedPropertiesTransformer.prototype.transform=function(value){if(Array.isArray(value))return value;var propName=universe.Universe10.Trait.properties.parametrizedProperties.name,parametrizedProps=value[propName];return parametrizedProps&&(Object.keys(parametrizedProps).forEach(function(y){value[y]=parametrizedProps[y]}),delete value[propName]),value},TemplateParametrizedPropertiesTransformer}(),ReferencesTransformer=function(){function ReferencesTransformer(){}return ReferencesTransformer.prototype.match=function(node,prop){return null!=prop&&(universeHelpers.isSecuredByProperty(prop)||universeHelpers.isIsProperty(prop)||null!=node.parent()&&(universeHelpers.isResourceType(node.parent().highLevel().definition())||universeHelpers.isResourceTypeType(node.parent().highLevel().definition()))&&universeHelpers.isTypeProperty(prop))},ReferencesTransformer.prototype.transform=function(value){return value?Array.isArray(value)?value:this.toSimpleValue(value):null},ReferencesTransformer.prototype.toSimpleValue=function(x){var name=x.name,params=x.structuredValue;if(params){var obj={};return obj[name]=params,obj}return name},ReferencesTransformer}(),PropertiesData=function(){function PropertiesData(){this.map={}}return PropertiesData.prototype.addProperty=function(prop,wrapperKind){var data=this.map[wrapperKind];data||(data=new TypePropertiesData(wrapperKind),this.map[wrapperKind]=data),data.addProperty(prop)},PropertiesData.prototype.print=function(){var _this=this;return Object.keys(this.map).map(function(x){return _this.map[x].print()}).join("\n")+"\n"},PropertiesData}(),TypePropertiesData=function(){function TypePropertiesData(typeName){this.typeName=typeName,this.map={}}return TypePropertiesData.prototype.addProperty=function(prop){var name=prop.domain().nameId(),data=this.map[name];data||(data=new TypePropertiesData2(name),this.map[name]=data),data.addProperty(prop)},TypePropertiesData.prototype.print=function(){var _this=this;return this.typeName+":\n"+Object.keys(this.map).map(function(x){return"    "+_this.map[x].print()}).join("\n")},TypePropertiesData}(),TypePropertiesData2=function(){function TypePropertiesData2(typeName){this.typeName=typeName,this.map={}}return TypePropertiesData2.prototype.addProperty=function(prop){var name=prop.nameId();this.map[name]=prop},TypePropertiesData2.prototype.print=function(){return this.typeName+": "+Object.keys(this.map).sort().join(", ")},TypePropertiesData2}()},function(module,exports,__webpack_require__){"use strict";function newMapping(key,value){var end=value?value.endPosition:key.endPosition+1,node={key:key,value:value,startPosition:key.startPosition,endPosition:end,kind:Kind.MAPPING,parent:null,errors:[]};return node}function newAnchorRef(key,start,end,value){return{errors:[],referencesAnchor:key,value:value,startPosition:start,endPosition:end,kind:Kind.ANCHOR_REF,parent:null}}function newScalar(v){return void 0===v&&(v=""),{errors:[],startPosition:-1,endPosition:-1,value:v,kind:Kind.SCALAR,parent:null,doubleQuoted:!1}}function newItems(){return{errors:[],startPosition:-1,endPosition:-1,items:[],kind:Kind.SEQ,parent:null}}function newSeq(){return newItems()}function newMap(mappings){return{errors:[],startPosition:-1,endPosition:-1,mappings:mappings?mappings:[],kind:Kind.MAP,parent:null}}var loader=__webpack_require__(82),dumper=__webpack_require__(83),YAMLException=function(){function YAMLException(reason,mark){void 0===mark&&(mark=null),this.name="YAMLException",this.reason=reason,this.mark=mark,this.message=this.toString(!1)}return YAMLException.prototype.toString=function(compact){void 0===compact&&(compact=!1);var result;return result="JS-YAML: "+(this.reason||"(unknown reason)"),!compact&&this.mark&&(result+=" "+this.mark.toString()),result},YAMLException}();exports.YAMLException=YAMLException,function(Kind){Kind[Kind.SCALAR=0]="SCALAR",Kind[Kind.MAPPING=1]="MAPPING",Kind[Kind.MAP=2]="MAP",Kind[Kind.SEQ=3]="SEQ",Kind[Kind.ANCHOR_REF=4]="ANCHOR_REF",Kind[Kind.INCLUDE_REF=5]="INCLUDE_REF"}(exports.Kind||(exports.Kind={}));var Kind=exports.Kind;exports.newMapping=newMapping,exports.newAnchorRef=newAnchorRef,exports.newScalar=newScalar,exports.newItems=newItems,exports.newSeq=newSeq,exports.newMap=newMap,exports.load=loader.load,exports.loadAll=loader.loadAll,exports.safeLoad=loader.safeLoad,exports.dump=dumper.dump,exports.safeDump=dumper.safeDump},function(module,exports,__webpack_require__){exports.dot=exports.dotCase=__webpack_require__(119),exports.swap=exports.swapCase=__webpack_require__(118),exports.path=exports.pathCase=__webpack_require__(120),exports.upper=exports.upperCase=__webpack_require__(121),exports.lower=exports.lowerCase=__webpack_require__(124),exports.camel=exports.camelCase=__webpack_require__(123),exports.snake=exports.snakeCase=__webpack_require__(125),exports.title=exports.titleCase=__webpack_require__(122),exports.param=exports.paramCase=__webpack_require__(127),exports.pascal=exports.pascalCase=__webpack_require__(126),exports.constant=exports.constantCase=__webpack_require__(130),exports.sentence=exports.sentenceCase=__webpack_require__(128),exports.isUpper=exports.isUpperCase=__webpack_require__(131),exports.isLower=exports.isLowerCase=__webpack_require__(129),exports.ucFirst=exports.upperCaseFirst=__webpack_require__(132),exports.lcFirst=exports.lowerCaseFirst=__webpack_require__(133)},function(module,exports,__webpack_require__){!function(root,pluralize){module.exports=pluralize()}(this,function(){function toTitleCase(str){return str.charAt(0).toUpperCase()+str.substr(1).toLowerCase()}function sanitizeRule(rule){return"string"==typeof rule?new RegExp("^"+rule+"$","i"):rule}function restoreCase(word,token){return word===word.toUpperCase()?token.toUpperCase():word[0]===word[0].toUpperCase()?toTitleCase(token):token.toLowerCase()}function interpolate(str,args){return str.replace(/\$(\d{1,2})/g,function(match,index){return args[index]||""})}function sanitizeWord(token,word,collection){if(!token.length||uncountables.hasOwnProperty(token))return word;for(var len=collection.length;len--;){var rule=collection[len];if(rule[0].test(word))return word.replace(rule[0],function(match,index,word){var result=interpolate(rule[1],arguments);return""===match?restoreCase(word[index-1],result):restoreCase(match,result)})}return word}function replaceWord(replaceMap,keepMap,rules){return function(word){var token=word.toLowerCase();return keepMap.hasOwnProperty(token)?restoreCase(word,token):replaceMap.hasOwnProperty(token)?restoreCase(word,replaceMap[token]):sanitizeWord(token,word,rules)}}function pluralize(word,count,inclusive){var pluralized=1===count?pluralize.singular(word):pluralize.plural(word);return(inclusive?count+" ":"")+pluralized}var pluralRules=[],singularRules=[],uncountables={},irregularPlurals={},irregularSingles={};return pluralize.plural=replaceWord(irregularSingles,irregularPlurals,pluralRules),pluralize.singular=replaceWord(irregularPlurals,irregularSingles,singularRules),pluralize.addPluralRule=function(rule,replacement){pluralRules.push([sanitizeRule(rule),replacement])},pluralize.addSingularRule=function(rule,replacement){singularRules.push([sanitizeRule(rule),replacement])},pluralize.addUncountableRule=function(word){return"string"==typeof word?void(uncountables[word.toLowerCase()]=!0):(pluralize.addPluralRule(word,"$0"),void pluralize.addSingularRule(word,"$0"))},pluralize.addIrregularRule=function(single,plural){plural=plural.toLowerCase(),single=single.toLowerCase(),irregularSingles[single]=plural,irregularPlurals[plural]=single;
},[["I","we"],["me","us"],["he","they"],["she","they"],["them","them"],["myself","ourselves"],["yourself","yourselves"],["itself","themselves"],["herself","themselves"],["himself","themselves"],["themself","themselves"],["is","are"],["this","these"],["that","those"],["echo","echoes"],["dingo","dingoes"],["volcano","volcanoes"],["tornado","tornadoes"],["torpedo","torpedoes"],["genus","genera"],["viscus","viscera"],["stigma","stigmata"],["stoma","stomata"],["dogma","dogmata"],["lemma","lemmata"],["schema","schemata"],["anathema","anathemata"],["ox","oxen"],["axe","axes"],["die","dice"],["yes","yeses"],["foot","feet"],["eave","eaves"],["goose","geese"],["tooth","teeth"],["quiz","quizzes"],["human","humans"],["proof","proofs"],["carve","carves"],["valve","valves"],["thief","thieves"],["genie","genies"],["groove","grooves"],["pickaxe","pickaxes"],["whiskey","whiskies"]].forEach(function(rule){return pluralize.addIrregularRule(rule[0],rule[1])}),[[/s?$/i,"s"],[/([^aeiou]ese)$/i,"$1"],[/(ax|test)is$/i,"$1es"],[/(alias|[^aou]us|tlas|gas|ris)$/i,"$1es"],[/(e[mn]u)s?$/i,"$1s"],[/([^l]ias|[aeiou]las|[emjzr]as|[iu]am)$/i,"$1"],[/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i,"$1i"],[/(alumn|alg|vertebr)(?:a|ae)$/i,"$1ae"],[/(seraph|cherub)(?:im)?$/i,"$1im"],[/(her|at|gr)o$/i,"$1oes"],[/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$/i,"$1a"],[/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$/i,"$1a"],[/sis$/i,"ses"],[/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$/i,"$1$2ves"],[/([^aeiouy]|qu)y$/i,"$1ies"],[/([^ch][ieo][ln])ey$/i,"$1ies"],[/(x|ch|ss|sh|zz)$/i,"$1es"],[/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$/i,"$1ices"],[/(m|l)(?:ice|ouse)$/i,"$1ice"],[/(pe)(?:rson|ople)$/i,"$1ople"],[/(child)(?:ren)?$/i,"$1ren"],[/eaux$/i,"$0"],[/m[ae]n$/i,"men"],["thou","you"]].forEach(function(rule){return pluralize.addPluralRule(rule[0],rule[1])}),[[/s$/i,""],[/(ss)$/i,"$1"],[/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(?:sis|ses)$/i,"$1sis"],[/(^analy)(?:sis|ses)$/i,"$1sis"],[/(wi|kni|(?:after|half|high|low|mid|non|night|[^\w]|^)li)ves$/i,"$1fe"],[/(ar|(?:wo|[ae])l|[eo][ao])ves$/i,"$1f"],[/([^aeiouy]|qu)ies$/i,"$1y"],[/(^[pl]|zomb|^(?:neck)?t|[aeo][lt]|cut)ies$/i,"$1ie"],[/(\b(?:mon|smil))ies$/i,"$1ey"],[/(m|l)ice$/i,"$1ouse"],[/(seraph|cherub)im$/i,"$1"],[/(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$/i,"$1"],[/(e[mn]u)s?$/i,"$1"],[/(movie|twelve)s$/i,"$1"],[/(cris|test|diagnos)(?:is|es)$/i,"$1is"],[/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$/i,"$1us"],[/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$/i,"$1um"],[/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$/i,"$1on"],[/(alumn|alg|vertebr)ae$/i,"$1a"],[/(cod|mur|sil|vert|ind)ices$/i,"$1ex"],[/(matr|append)ices$/i,"$1ix"],[/(pe)(rson|ople)$/i,"$1rson"],[/(child)ren$/i,"$1"],[/(eau)x?$/i,"$1"],[/men$/i,"man"]].forEach(function(rule){return pluralize.addSingularRule(rule[0],rule[1])}),["advice","agenda","bison","bream","buffalo","carp","chassis","cod","cooperation","corps","digestion","debris","diabetes","energy","equipment","elk","excretion","expertise","flounder","gallows","garbage","graffiti","headquarters","health","herpes","highjinks","homework","information","jeans","justice","kudos","labour","machinery","mackerel","media","mews","moose","news","pike","plankton","pliers","pollution","premises","rain","rice","salmon","scissors","series","sewage","shambles","shrimp","species","staff","swine","trout","tuna","whiting","wildebeest","wildlife","you",/pox$/i,/ois$/i,/deer$/i,/fish$/i,/sheep$/i,/measles$/i,/[^aeiou]ese$/i].forEach(pluralize.addUncountableRule),pluralize})},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;!function(root,factory){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=factory():(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_FACTORY__=factory,__WEBPACK_AMD_DEFINE_RESULT__="function"==typeof __WEBPACK_AMD_DEFINE_FACTORY__?__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__):__WEBPACK_AMD_DEFINE_FACTORY__,!(void 0!==__WEBPACK_AMD_DEFINE_RESULT__&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__)))}("object"==typeof window?window:this,function(){"use strict";function CacheState(capacity){this.capacity=capacity>0?+capacity:Number.MAX_VALUE,this.data=Object.create?Object.create(null):{},this.hash=Object.create?Object.create(null):{},this.linkedList={length:0,head:null,end:null}}function LRUCache(capacity){return this instanceof LRUCache?void(this._LRUCacheState=new CacheState(capacity)):new LRUCache(capacity)}function refresh(linkedList,entry){entry!==linkedList.head&&(linkedList.end?linkedList.end===entry&&(linkedList.end=entry.n):linkedList.end=entry,link(entry.n,entry.p),link(entry,linkedList.head),linkedList.head=entry,linkedList.head.n=null)}function link(nextEntry,prevEntry){nextEntry!==prevEntry&&(nextEntry&&(nextEntry.p=prevEntry),prevEntry&&(prevEntry.n=nextEntry))}var proto=LRUCache.prototype;return proto.get=function(key){var state=this._LRUCacheState,lruEntry=state.hash[key];if(lruEntry)return refresh(state.linkedList,lruEntry),state.data[key]},proto.set=function(key,value){var state=this._LRUCacheState,lruEntry=state.hash[key];return void 0===value?this:(lruEntry||(state.hash[key]={key:key},state.linkedList.length+=1,lruEntry=state.hash[key]),refresh(state.linkedList,lruEntry),state.data[key]=value,state.linkedList.length>state.capacity&&this.remove(state.linkedList.end.key),this)},proto.update=function(key,parseFn){this._LRUCacheState;if(this.has(key)){var data=this.get(key);this.set(key,parseFn(data))}return this},proto.remove=function(key){var state=this._LRUCacheState,lruEntry=state.hash[key];return lruEntry?(lruEntry===state.linkedList.head&&(state.linkedList.head=lruEntry.p),lruEntry===state.linkedList.end&&(state.linkedList.end=lruEntry.n),link(lruEntry.n,lruEntry.p),delete state.hash[key],delete state.data[key],state.linkedList.length-=1,this):this},proto.removeAll=function(){return this._LRUCacheState=new CacheState(this._LRUCacheState.capacity),this},proto.info=function(){var state=this._LRUCacheState;return{capacity:state.capacity,length:state.linkedList.length}},proto.keys=function(){for(var state=this._LRUCacheState,keys=[],lruEntry=state.linkedList.head;lruEntry;)keys.push(lruEntry.key),lruEntry=lruEntry.p;return keys},proto.has=function(key){return!!this._LRUCacheState.hash[key]},proto.staleKey=function(){return this._LRUCacheState.linkedList.end&&this._LRUCacheState.linkedList.end.key},proto.popStale=function(){var staleKey=this.staleKey();if(!staleKey)return null;var stale=[staleKey,this._LRUCacheState.data[staleKey]];return this.remove(staleKey),stale},LRUCache.NAME="LRUCache",LRUCache.VERSION="v0.2.0",LRUCache})},function(module,exports,__webpack_require__){"use strict";function doRequest(method,url,options,callback){var result=new Promise(function(resolve,reject){function attempt(n){doRequest(method,url,{qs:options.qs,headers:options.headers,timeout:options.timeout}).nodeify(function(err,res){var retry=err||res.statusCode>=400;if("function"==typeof options.retry&&(retry=options.retry(err,res,n+1)),n>=(5|options.maxRetries)&&(retry=!1),retry){var delay=options.retryDelay;"function"==typeof options.retryDelay&&(delay=options.retryDelay(err,res,n+1)),delay=delay||200,setTimeout(function(){attempt(n+1)},delay)}else err?reject(err):resolve(res)})}var xhr=new window.XMLHttpRequest;if("string"!=typeof method)throw new TypeError("The method must be a string.");if("string"!=typeof url)throw new TypeError("The URL/path must be a string.");if("function"==typeof options&&(callback=options,options={}),null!==options&&void 0!==options||(options={}),"object"!=typeof options)throw new TypeError("Options must be an object (or null).");if("function"!=typeof callback&&(callback=void 0),method=method.toUpperCase(),options.headers=options.headers||{},options.retry&&"GET"===method)return attempt(0);var match,crossDomain=!(!(match=/^([\w-]+:)?\/\/([^\/]+)/.exec(url))||match[2]==window.location.host);if(crossDomain||(options.headers["X-Requested-With"]="XMLHttpRequest"),options.qs&&(url=handleQs(url,options.qs)),options.json&&(options.body=JSON.stringify(options.json),options.headers["Content-Type"]="application/json"),options.timeout){xhr.timeout=options.timeout;var start=Date.now();xhr.ontimeout=function(){var duration=Date.now()-start,err=new Error("Request timed out after "+duration+"ms");err.timeout=!0,err.duration=duration,reject(err)}}xhr.onreadystatechange=function(){if(4===xhr.readyState){var headers={};xhr.getAllResponseHeaders().split("\r\n").forEach(function(header){var h=header.split(":");h.length>1&&(headers[h[0].toLowerCase()]=h.slice(1).join(":").trim())});var res=new Response(xhr.status,headers,xhr.responseText);res.url=url,resolve(res)}},xhr.open(method,url,!0);for(var name in options.headers)xhr.setRequestHeader(name,options.headers[name]);xhr.send(options.body?options.body:null)});return result.getBody=function(){return result.then(function(res){return res.getBody()})},result.nodeify(callback)}var Promise=__webpack_require__(114),Response=__webpack_require__(64),handleQs=__webpack_require__(87);module.exports=doRequest},function(module,exports,__webpack_require__){function DOMParser(options){this.options=options||{locator:{}}}function buildErrorHandler(errorImpl,domBuilder,locator){function build(key){var fn=errorImpl[key];!fn&&isCallback&&(fn=2==errorImpl.length?function(msg){errorImpl(key,msg)}:errorImpl),errorHandler[key]=fn&&function(msg){fn("[xmldom "+key+"]\t"+msg+_locator(locator))}||function(){}}if(!errorImpl){if(domBuilder instanceof DOMHandler)return domBuilder;errorImpl=domBuilder}var errorHandler={},isCallback=errorImpl instanceof Function;return locator=locator||{},build("warning"),build("error"),build("fatalError"),errorHandler}function DOMHandler(){this.cdata=!1}function position(locator,node){node.lineNumber=locator.lineNumber,node.columnNumber=locator.columnNumber}function _locator(l){if(l)return"\n@"+(l.systemId||"")+"#[line:"+l.lineNumber+",col:"+l.columnNumber+"]"}function _toString(chars,start,length){return"string"==typeof chars?chars.substr(start,length):chars.length>=start+length||start?new java.lang.String(chars,start,length)+"":chars}function appendElement(hander,node){hander.currentElement?hander.currentElement.appendChild(node):hander.document.appendChild(node)}DOMParser.prototype.parseFromString=function(source,mimeType){var options=this.options,sax=new XMLReader,domBuilder=options.domBuilder||new DOMHandler,errorHandler=options.errorHandler,locator=options.locator,defaultNSMap=options.xmlns||{},entityMap={lt:"<",gt:">",amp:"&",quot:'"',apos:"'"};return locator&&domBuilder.setDocumentLocator(locator),sax.errorHandler=buildErrorHandler(errorHandler,domBuilder,locator),sax.domBuilder=options.domBuilder||domBuilder,/\/x?html?$/.test(mimeType)&&(entityMap.nbsp=" ",entityMap.copy="©",defaultNSMap[""]="http://www.w3.org/1999/xhtml"),defaultNSMap.xml=defaultNSMap.xml||"http://www.w3.org/XML/1998/namespace",source?sax.parse(source,defaultNSMap,entityMap):sax.errorHandler.error("invalid document source"),domBuilder.document},DOMHandler.prototype={startDocument:function(){this.document=(new DOMImplementation).createDocument(null,null,null),this.locator&&(this.document.documentURI=this.locator.systemId)},startElement:function(namespaceURI,localName,qName,attrs){var doc=this.document,el=doc.createElementNS(namespaceURI,qName||localName),len=attrs.length;appendElement(this,el),this.currentElement=el,this.locator&&position(this.locator,el);for(var i=0;i<len;i++){var namespaceURI=attrs.getURI(i),value=attrs.getValue(i),qName=attrs.getQName(i),attr=doc.createAttributeNS(namespaceURI,qName);attr.getOffset&&position(attr.getOffset(1),attr),attr.value=attr.nodeValue=value,el.setAttributeNode(attr)}},endElement:function(namespaceURI,localName,qName){var current=this.currentElement;current.tagName;this.currentElement=current.parentNode},startPrefixMapping:function(prefix,uri){},endPrefixMapping:function(prefix){},processingInstruction:function(target,data){var ins=this.document.createProcessingInstruction(target,data);this.locator&&position(this.locator,ins),appendElement(this,ins)},ignorableWhitespace:function(ch,start,length){},characters:function(chars,start,length){if(chars=_toString.apply(this,arguments),this.currentElement&&chars){if(this.cdata){var charNode=this.document.createCDATASection(chars);this.currentElement.appendChild(charNode)}else{var charNode=this.document.createTextNode(chars);this.currentElement.appendChild(charNode)}this.locator&&position(this.locator,charNode)}},skippedEntity:function(name){},endDocument:function(){this.document.normalize()},setDocumentLocator:function(locator){(this.locator=locator)&&(locator.lineNumber=0)},comment:function(chars,start,length){chars=_toString.apply(this,arguments);var comm=this.document.createComment(chars);this.locator&&position(this.locator,comm),appendElement(this,comm)},startCDATA:function(){this.cdata=!0},endCDATA:function(){this.cdata=!1},startDTD:function(name,publicId,systemId){var impl=this.document.implementation;if(impl&&impl.createDocumentType){var dt=impl.createDocumentType(name,publicId,systemId);this.locator&&position(this.locator,dt),appendElement(this,dt)}},warning:function(error){console.warn("[xmldom warning]\t"+error,_locator(this.locator))},error:function(error){console.error("[xmldom error]\t"+error,_locator(this.locator))},fatalError:function(error){throw console.error("[xmldom fatalError]\t"+error,_locator(this.locator)),error}},"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl".replace(/\w+/g,function(key){DOMHandler.prototype[key]=function(){return null}});var XMLReader=__webpack_require__(85).XMLReader,DOMImplementation=exports.DOMImplementation=__webpack_require__(86).DOMImplementation;exports.XMLSerializer=__webpack_require__(86).XMLSerializer,exports.DOMParser=DOMParser},function(module,exports,__webpack_require__){"use strict";function isEmpty(value){return null==value}function toString(value){return isEmpty(value)?"":String(value)}function toBoolean(value){return[0,!1,"","0","false"].indexOf(value)===-1}function toNumber(value){return isFinite(value)?Number(value):null}function toInteger(value){return value%1===0?Number(value):null}function toDate(value){return isNaN(Date.parse(value))?null:new Date(value)}function toSanitization(parameter,rules,types){var parameters=Array.isArray(parameter)?parameter:[parameter],sanitizations=parameters.map(function(parameter){function sanitize(value,key,src){for(var i=0;i<fns.length;i++){var fn=fns[i],value=fn(value,key,src);if(null!=value)return value}return null}var fns=[],typeSanitization=types[parameter.type];return"function"==typeof typeSanitization&&fns.push(typeSanitization),Object.keys(parameter).filter(function(key){return"type"!==key&&"repeat"!==key&&"default"!==key}).forEach(function(key){var fn=rules[key];"function"==typeof fn&&fns.push(fn(parameter[key],key))}),function(value,key,src){if(isEmpty(value))return null!=parameter.default?sanitize(parameter.default,key,src):parameter.repeat&&!parameter.required?[]:value;if(parameter.repeat){var values=Array.isArray(value)?value:[value];return values=values.map(function(value){return sanitize(value,key,src)}),values.some(isEmpty)?null:value}if(Array.isArray(value)){if(value.length>1)return null;value=value[0]}return sanitize(value,key,src)}});return function(value,key,src){for(var i=0;i<sanitizations.length;i++){var sanitization=sanitizations[i],result=sanitization(value,key,src);if(null!=result)return result}return value}}function sanitize(){function rule(parameter){return toSanitization(parameter,RULES,TYPES)}var s,RULES={},TYPES={string:toString,number:toNumber,integer:toInteger,boolean:toBoolean,date:toDate},sanitize=function(parameterMap){if(!parameterMap)return function(){return{}};var sanitizations={};return Object.keys(parameterMap).forEach(function(key){sanitizations[key]=sanitize.rule(parameterMap[key])}),function(src){src=src||{};var dest={};return Object.keys(sanitizations).forEach(function(key){var value=src[key],fn=sanitizations[key];Object.prototype.hasOwnProperty.call(src,key)&&(dest[key]=fn(value,key,src))}),dest}};return s=sanitize,s.rule=rule,s.TYPES=TYPES,s.RULES=RULES,s}exports.sanitize=sanitize},function(module,exports,__webpack_require__){(function(Buffer){"use strict";function isDateType(check){return"[object Date]"===_toString.call(check)&&!isNaN(check.getTime())}function isBooleanType(check){return"boolean"==typeof check}function isStringType(check){return"string"==typeof check}function isIntegerType(check){return"number"==typeof check&&check%1===0}function isNumberType(check){return"number"==typeof check&&isFinite(check)}function isMinimum(min){return function(check){return check>=min}}function isMaximum(max){return function(check){return check<=max}}function isMinimumLength(min){return function(check){return Buffer.byteLength(check)>=min}}function isMaximumLength(max){return function(check){return Buffer.byteLength(check)<=max}}function isEnum(values){return values&&0!=values.length?function(check){return values.indexOf(check)>-1}:function(check){return!0}}function isPattern(pattern){var regexp="string"==typeof pattern?new RegExp(pattern):pattern;return regexp.test.bind(regexp)}function toValidationResult(valid,key,value,rule,attr){return{valid:valid,rule:rule,attr:attr,value:value,key:key}}function toValidationFunction(parameter,rules){var validations=[];return Object.keys(parameter).forEach(function(name){var rule=rules[name];if(rule){var value=parameter[name];validations.push([name,rule(value,name),value])}}),function(value,key,src){for(var i=0;i<validations.length;i++){var validation=validations[i],name=validation[0],fn=validation[1],attr=validation[2],valid=fn(value,key,src);if(!valid)return toValidationResult(!1,key,value,name,attr)}return toValidationResult(!0,key,value)}}function toValidation(parameter,rules,types){var parameters=Array.isArray(parameter)?parameter:[parameter],isOptional=!parameters.length,simpleValidations=[],repeatValidations=[];return parameters.forEach(function(parameter){var validation=[parameter.type||"string",toValidationFunction(parameter,rules)];parameter.required||(isOptional=!0),parameter.repeat?repeatValidations.push(validation):simpleValidations.push(validation)}),function(value,key,src){if(null==value)return toValidationResult(isOptional,key,value,"required",!isOptional);var isArray=Array.isArray(value),values=isArray?value:[value],validations=isArray?repeatValidations:simpleValidations;if(!validations.length)return toValidationResult(!1,key,value,"repeat",!isArray);var response=null,originalValue=value;return validations.some(function(validation){var isValidType=values.every(function(value){var paramType=validation[0],isValidType=types[paramType]&&types[paramType](value,key,src);return isValidType||(response=toValidationResult(!1,key,originalValue,"type",paramType)),isValidType});return!!isValidType&&(values.every(function(value){var fn=validation[1];return response=fn(value,key),response.valid}),!0)}),response}}function validate(){function rule(parameter){return toValidation(parameter,RULES,TYPES)}var v,TYPES={date:isDateType,number:isNumberType,integer:isIntegerType,boolean:isBooleanType,string:isStringType},RULES={minimum:isMinimum,maximum:isMaximum,minLength:isMinimumLength,maxLength:isMaximumLength,enum:isEnum,pattern:isPattern},validate=function(parameterMap){if(!parameterMap)return function(check){return{valid:!0,errors:[]}};var validations={};return Object.keys(parameterMap).forEach(function(key){validations[key]=rule(parameterMap[key])}),function(src){src=src||{};var errors=Object.keys(validations).map(function(param){var value=src[param],fn=validations[param];return fn(value,param,src)}).filter(function(result){return!result.valid});return{valid:0===errors.length,errors:errors}}};return v=validate,v.rule=rule,v.TYPES=TYPES,v.RULES=RULES,v}var _toString=Object.prototype.toString;exports.validate=validate}).call(exports,__webpack_require__(92).Buffer)},function(module,exports,__webpack_require__){(function(global){(function(){var vm,__slice=[].slice;vm=__webpack_require__(101),exports.allowUnsafeEval=function(fn){var previousEval;previousEval=global.eval;try{return global.eval=function(source){return vm.runInThisContext(source)},fn()}finally{global.eval=previousEval}},exports.allowUnsafeNewFunction=function(fn){var previousFunction;previousFunction=global.Function;try{return global.Function=exports.Function,fn()}finally{global.Function=previousFunction}},exports.Function=function(){var body,paramList,paramLists,params,_i,_j,_len;for(paramLists=2<=arguments.length?__slice.call(arguments,0,_i=arguments.length-1):(_i=0,[]),body=arguments[_i++],params=[],_j=0,_len=paramLists.length;_j<_len;_j++)paramList=paramLists[_j],"string"==typeof paramList&&(paramList=paramList.split(/\s*,\s*/)),params.push.apply(params,paramList);return vm.runInThisContext("(function("+params.join(", ")+") {\n  "+body+"\n})")},exports.Function.prototype=global.Function.prototype}).call(this)}).call(exports,function(){return this}())},function(module,exports,__webpack_require__){"use strict";function handleTypeAnnotation(a,rangeType){"MetaModel.declaresSubTypeOf"==a.name&&rangeType.getAdapter(services.RAMLService).setExtendedTypeName(a.arguments[0]),"MetaModel.nameAtRuntime"==a.name&&rangeType.setNameAtRuntime(a.arguments[0]),"MetaModel.description"==a.name&&rangeType.withDescription(a.arguments[0]),"MetaModel.inlinedTemplates"==a.name&&rangeType.getAdapter(services.RAMLService).setInlinedTemplates(!0),"MetaModel.requireValue"==a.name&&rangeType.getAdapter(services.RAMLService).withContextRequirement(""+a.arguments[0],""+a.arguments[1]),"MetaModel.referenceIs"==a.name&&rangeType.getAdapter(services.RAMLService).withReferenceIs(""+a.arguments[0]),"MetaModel.actuallyExports"==a.name&&rangeType.getAdapter(services.RAMLService).withActuallyExports(""+a.arguments[0]),"MetaModel.convertsToGlobalOfType"==a.name&&rangeType.getAdapter(services.RAMLService).withConvertsToGlobal(""+a.arguments[0]),"MetaModel.allowAny"==a.name&&rangeType.getAdapter(services.RAMLService).withAllowAny(),"MetaModel.allowQuestion"==a.name&&rangeType.getAdapter(services.RAMLService).withAllowQuestion(),"MetaModel.alias"==a.name&&rangeType.getAdapter(services.RAMLService).addAlias(""+a.arguments[0]),"MetaModel.consumesRefs"==a.name&&rangeType.getAdapter(services.RAMLService).setConsumesRefs(!0),"MetaModel.canInherit"==a.name&&rangeType.getAdapter(services.RAMLService).withCanInherit(""+a.arguments[0]),"MetaModel.definingPropertyIsEnough"==a.name&&rangeType.getAdapter(services.RAMLService).definingPropertyIsEnough(""+a.arguments[0]),"MetaModel.customHandling"==a.name&&rangeType.setCustom(!0),"MetaModel.superclasses"==a.name&&rangeType.getAdapter(services.RAMLService).registerSupertypes(a.arguments[0]),"MetaModel.possibleInterfaces"==a.name&&rangeType.getAdapter(services.RAMLService).registerPossibleInterfaces(a.arguments[0])}function recordAnnotation(p,a){exports.annotationHandlers[a.name](a,p)}var def=__webpack_require__(36),khttp=__webpack_require__(134),_=__webpack_require__(88),services=def;exports.handleTypeAnnotation=handleTypeAnnotation,exports.annotationHandlers={key:function(a,f){f.withFromParentKey(),f.withKey(!0)},value:function(a,f){f.withFromParentValue()},canBeValue:function(a,f){f.withCanBeValue()},unmerged:function(a,f){f.unmerge()},startFrom:function(a,f){f.withKeyRestriction(a.arguments[0]),f.merge()},oneOf:function(a,f){f.withEnumOptions(a.arguments[0])},oftenKeys:function(a,f){f.withOftenKeys(a.arguments[0])},embeddedInMaps:function(a,f){f.getAdapter(services.RAMLPropertyParserService).withEmbedMap()},system:function(a,f){f.getAdapter(services.RAMLPropertyParserService).withSystem(!0)},required:function(a,f){"false"!=a.arguments[0]&&a.arguments[0]!==!1&&f.withRequired(!0)},noDirectParse:function(a,f){"false"!=a.arguments[0]&&a.arguments[0]!==!1&&f.withNoDirectParse()},setsContextValue:function(a,f){f.addChildValueConstraint(new def.ChildValueConstraint(""+a.arguments[0],""+a.arguments[1]))},defaultValue:function(a,f){f.setDefaultVal(""+a.arguments[0])},defaultIntegerValue:function(a,f){f.setDefaultIntegerVal(a.arguments[0])},defaultBooleanValue:function(a,f){f.setDefaultBooleanVal(a.arguments[0])},facetId:function(a,f){"minItems"==a.arguments[0]&&f.setFacetValidator(function(x,f){if(x instanceof Array){var length=Number.parseInt(""+f.value());if(length>x.length)return"array should contain at least "+f.value()+" items"}return null}),"enum"==a.arguments[0]&&f.setFacetValidator(function(x,f){var validateAgainst=x+"",array=f;try{if(!array.some(function(x){return x==validateAgainst}))return"value should be one of :"+array.join(",")}catch(e){return}return null}),"maxItems"==a.arguments[0]&&f.setFacetValidator(function(x,f){if(x instanceof Array){var length=Number.parseInt(""+f);if(length<x.length)return"array should contain not more then "+f.value()+" items"}return null}),"minProperties"==a.arguments[0]&&f.setFacetValidator(function(x,f){if(x instanceof Object){var length=Number.parseInt(""+f);if(length>Object.keys(x).length)return"object should contain at least "+f.value()+" properties"}return null}),"maxProperties"==a.arguments[0]&&f.setFacetValidator(function(x,f){if(x instanceof Object){var length=Number.parseInt(""+f);if(length<Object.keys(x).length)return"object should contain not more then "+f.value()+" properties"}return null}),"uniqueItems"==a.arguments[0]&&f.setFacetValidator(function(x,f){if(f instanceof Array){var length=_.unique(f).length;if(length<f.length)return"array should contain only unique items"}return null}),"minLength"==a.arguments[0]&&f.setFacetValidator(function(x,f){if("number"!=typeof x&&"boolean"!=typeof x||(x=""+x),"string"==typeof x){var length=Number.parseInt(""+f);if(length>x.length)return"string length should be at least "+length}return null}),"maxLength"==a.arguments[0]&&f.setFacetValidator(function(x,f){if("number"!=typeof x&&"boolean"!=typeof x||(x=""+x),"string"==typeof x){var length=Number.parseInt(""+f);if(length<x.length)return"string length should be not more then "+length}return null}),"minimum"==a.arguments[0]&&f.setFacetValidator(function(x,f){if("string"==typeof x&&(x=parseFloat(x)),"number"==typeof x){var length=parseFloat(f);if(length>x)return"value should be not less then "+length}return null}),"maximum"==a.arguments[0]&&f.setFacetValidator(function(x,f){if("string"==typeof x&&(x=parseFloat(x)),"number"==typeof x){var length=parseFloat(f);if(length<x)return"value should be not more then "+length}return null}),"pattern"==a.arguments[0]&&f.setFacetValidator(function(x,f){if("number"!=typeof x&&"boolean"!=typeof x||(x=""+x),"string"==typeof x){var regExp=new RegExp(f);if(!regExp.test(x))return"string should match to "+f}return null})},extraMetaKey:function(a,f){"statusCodes"==a.arguments[0]&&(f.withOftenKeys(khttp.statusCodes.filter(function(statusCode){return statusCode.code.indexOf("x")<0}).map(function(x){return x.code})),f.setValueDocProvider(function(name){var s=_.find(khttp.statusCodes,function(x){return x.code==name});return s?name+":"+s.description:null})),"headers"==a.arguments[0]&&(f.setValueSuggester(function(x){if(x.property()){var c=x.property().getChildValueConstraints();if(_.find(c,function(x){return"location"==x.name&&"Params.ParameterLocation.HEADERS"==x.value}))return khttp.headers.map(function(x){return x.header});if(x.property()&&"headers"==x.property().nameId())return khttp.headers.map(function(x){return x.header})}return null}),f.setValueDocProvider(function(name){var s=_.find(khttp.headers,function(x){return x.header==name});return s?name+":"+s.description:null})),"methods"==a.arguments[0]&&f.setValueDocProvider(function(name){var s=_.find(khttp.methods,function(x){return x.method==name.toUpperCase()});return s?name+":"+s.description:null})},requireValue:function(a,f){f.withContextRequirement(""+a.arguments[0],""+a.arguments[1])},allowMultiple:function(a,f){f.withMultiValue(!0)},constraint:function(a,f){},newInstanceName:function(a,f){f.withNewInstanceName(""+a.arguments[0])},declaringFields:function(a,f){f.withThisPropertyDeclaresFields()},describesAnnotation:function(a,f){f.withDescribes(a.arguments[0])},allowNull:function(a,f){f.withAllowNull()},descriminatingProperty:function(a,f){f.withDescriminating(!0)},description:function(a,f){f.withDescription(""+a.arguments[0])},inherited:function(a,f){f.withInherited(!0)},selfNode:function(a,f){f.withSelfNode()},grammarTokenKind:function(a,f){f.getAdapter(services.RAMLPropertyService).withPropertyGrammarType(""+a.arguments[0])},canInherit:function(a,f){f.withInheritedContextValue(""+a.arguments[0])},canBeDuplicator:function(a,f){f.setCanBeDuplicator()},example:function(a,f){f.getAdapter(services.RAMLPropertyService).setExample(!0)},typeExpression:function(a,f){f.getAdapter(services.RAMLPropertyService).setTypeExpression(!0)},hide:function(a,f){0==a.arguments.length?f.getAdapter(services.RAMLPropertyDocumentationService).setHidden(!0):f.getAdapter(services.RAMLPropertyDocumentationService).setHidden(a.arguments[0])},documentationTableLabel:function(a,f){f.getAdapter(services.RAMLPropertyDocumentationService).setDocTableName(""+a.arguments[0])},markdownDescription:function(a,f){f.getAdapter(services.RAMLPropertyDocumentationService).setMarkdownDescription(""+a.arguments[0])},valueDescription:function(a,f){f.getAdapter(services.RAMLPropertyDocumentationService).setValueDescription(null!=a.arguments[0]?""+a.arguments[0]:null)},customHandling:function(a,f){}},exports.recordAnnotation=recordAnnotation},function(module,exports,__webpack_require__){"use strict";exports.decode=exports.parse=__webpack_require__(93),exports.encode=exports.stringify=__webpack_require__(94)},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__;(function(module,global){!function(root){function error(type){throw RangeError(errors[type])}function map(array,fn){for(var length=array.length,result=[];length--;)result[length]=fn(array[length]);return result}function mapDomain(string,fn){var parts=string.split("@"),result="";parts.length>1&&(result=parts[0]+"@",string=parts[1]),string=string.replace(regexSeparators,".");var labels=string.split("."),encoded=map(labels,fn).join(".");return result+encoded}function ucs2decode(string){for(var value,extra,output=[],counter=0,length=string.length;counter<length;)value=string.charCodeAt(counter++),value>=55296&&value<=56319&&counter<length?(extra=string.charCodeAt(counter++),56320==(64512&extra)?output.push(((1023&value)<<10)+(1023&extra)+65536):(output.push(value),counter--)):output.push(value);return output}function ucs2encode(array){return map(array,function(value){var output="";return value>65535&&(value-=65536,output+=stringFromCharCode(value>>>10&1023|55296),value=56320|1023&value),output+=stringFromCharCode(value)}).join("")}function basicToDigit(codePoint){return codePoint-48<10?codePoint-22:codePoint-65<26?codePoint-65:codePoint-97<26?codePoint-97:base}function digitToBasic(digit,flag){return digit+22+75*(digit<26)-((0!=flag)<<5)}function adapt(delta,numPoints,firstTime){var k=0;for(delta=firstTime?floor(delta/damp):delta>>1,delta+=floor(delta/numPoints);delta>baseMinusTMin*tMax>>1;k+=base)delta=floor(delta/baseMinusTMin);return floor(k+(baseMinusTMin+1)*delta/(delta+skew))}function decode(input){var out,basic,j,index,oldi,w,k,digit,t,baseMinusT,output=[],inputLength=input.length,i=0,n=initialN,bias=initialBias;
for(basic=input.lastIndexOf(delimiter),basic<0&&(basic=0),j=0;j<basic;++j)input.charCodeAt(j)>=128&&error("not-basic"),output.push(input.charCodeAt(j));for(index=basic>0?basic+1:0;index<inputLength;){for(oldi=i,w=1,k=base;index>=inputLength&&error("invalid-input"),digit=basicToDigit(input.charCodeAt(index++)),(digit>=base||digit>floor((maxInt-i)/w))&&error("overflow"),i+=digit*w,t=k<=bias?tMin:k>=bias+tMax?tMax:k-bias,!(digit<t);k+=base)baseMinusT=base-t,w>floor(maxInt/baseMinusT)&&error("overflow"),w*=baseMinusT;out=output.length+1,bias=adapt(i-oldi,out,0==oldi),floor(i/out)>maxInt-n&&error("overflow"),n+=floor(i/out),i%=out,output.splice(i++,0,n)}return ucs2encode(output)}function encode(input){var n,delta,handledCPCount,basicLength,bias,j,m,q,k,t,currentValue,inputLength,handledCPCountPlusOne,baseMinusT,qMinusT,output=[];for(input=ucs2decode(input),inputLength=input.length,n=initialN,delta=0,bias=initialBias,j=0;j<inputLength;++j)currentValue=input[j],currentValue<128&&output.push(stringFromCharCode(currentValue));for(handledCPCount=basicLength=output.length,basicLength&&output.push(delimiter);handledCPCount<inputLength;){for(m=maxInt,j=0;j<inputLength;++j)currentValue=input[j],currentValue>=n&&currentValue<m&&(m=currentValue);for(handledCPCountPlusOne=handledCPCount+1,m-n>floor((maxInt-delta)/handledCPCountPlusOne)&&error("overflow"),delta+=(m-n)*handledCPCountPlusOne,n=m,j=0;j<inputLength;++j)if(currentValue=input[j],currentValue<n&&++delta>maxInt&&error("overflow"),currentValue==n){for(q=delta,k=base;t=k<=bias?tMin:k>=bias+tMax?tMax:k-bias,!(q<t);k+=base)qMinusT=q-t,baseMinusT=base-t,output.push(stringFromCharCode(digitToBasic(t+qMinusT%baseMinusT,0))),q=floor(qMinusT/baseMinusT);output.push(stringFromCharCode(digitToBasic(q,0))),bias=adapt(delta,handledCPCountPlusOne,handledCPCount==basicLength),delta=0,++handledCPCount}++delta,++n}return output.join("")}function toUnicode(input){return mapDomain(input,function(string){return regexPunycode.test(string)?decode(string.slice(4).toLowerCase()):string})}function toASCII(input){return mapDomain(input,function(string){return regexNonASCII.test(string)?"xn--"+encode(string):string})}var freeGlobal=("object"==typeof exports&&exports&&!exports.nodeType&&exports,"object"==typeof module&&module&&!module.nodeType&&module,"object"==typeof global&&global);freeGlobal.global!==freeGlobal&&freeGlobal.window!==freeGlobal&&freeGlobal.self!==freeGlobal||(root=freeGlobal);var punycode,maxInt=2147483647,base=36,tMin=1,tMax=26,skew=38,damp=700,initialBias=72,initialN=128,delimiter="-",regexPunycode=/^xn--/,regexNonASCII=/[^\x20-\x7E]/,regexSeparators=/[\x2E\u3002\uFF0E\uFF61]/g,errors={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},baseMinusTMin=base-tMin,floor=Math.floor,stringFromCharCode=String.fromCharCode;punycode={version:"1.3.2",ucs2:{decode:ucs2decode,encode:ucs2encode},decode:decode,encode:encode,toASCII:toASCII,toUnicode:toUnicode},__WEBPACK_AMD_DEFINE_RESULT__=function(){return punycode}.call(exports,__webpack_require__,exports,module),!(void 0!==__WEBPACK_AMD_DEFINE_RESULT__&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}(this)}).call(exports,__webpack_require__(138)(module),function(){return this}())},function(module,exports,__webpack_require__){"use strict";function is_EOL(c){return 10===c||13===c}function is_WHITE_SPACE(c){return 9===c||32===c}function is_WS_OR_EOL(c){return 9===c||32===c||10===c||13===c}function is_FLOW_INDICATOR(c){return 44===c||91===c||93===c||123===c||125===c}function fromHexCode(c){var lc;return 48<=c&&c<=57?c-48:(lc=32|c,97<=lc&&lc<=102?lc-97+10:-1)}function escapedHexLen(c){return 120===c?2:117===c?4:85===c?8:0}function fromDecimalCode(c){return 48<=c&&c<=57?c-48:-1}function simpleEscapeSequence(c){return 48===c?"\0":97===c?"":98===c?"\b":116===c?"\t":9===c?"\t":110===c?"\n":118===c?"\v":102===c?"\f":114===c?"\r":101===c?"":32===c?" ":34===c?'"':47===c?"/":92===c?"\\":78===c?"":95===c?" ":76===c?"\u2028":80===c?"\u2029":""}function charFromCodepoint(c){return c<=65535?String.fromCharCode(c):String.fromCharCode((c-65536>>10)+55296,(c-65536&1023)+56320)}function generateError(state,message){return new YAMLException(message,new Mark(state.filename,state.input,state.position,state.line-1,state.position-state.lineStart))}function throwError(state,message){var error=generateError(state,message),hash=error.message+error.mark.position;state.errorMap[hash]||(state.errors.push(error),state.errorMap[hash]=1);for(var or=state.position;;){if(state.position>=state.input.length-1)return;var c=state.input.charAt(state.position);if("\n"==c)return state.position--,void(state.position==or&&(state.position+=1));if("\r"==c)return state.position--,void(state.position==or&&(state.position+=1));state.position++}}function throwWarning(state,message){var error=generateError(state,message);state.onWarning&&state.onWarning.call(null,error)}function captureSegment(state,start,end,checkJson){var _position,_length,_character,_result,scalar=state.result;if(scalar.startPosition==-1&&(scalar.startPosition=start),start<=end){if(_result=state.input.slice(start,end),checkJson)for(_position=0,_length=_result.length;_position<_length;_position+=1)_character=_result.charCodeAt(_position),9===_character||32<=_character&&_character<=1114111||throwError(state,"expected valid JSON character");scalar.value+=_result,scalar.endPosition=end}}function storeMappingPair(state,_result,keyTag,keyNode,valueNode){if(null!=keyNode){if(null===_result&&(_result={startPosition:keyNode.startPosition,endPosition:valueNode.endPosition,parent:null,errors:[],mappings:[],kind:ast.Kind.MAP}),"tag:yaml.org,2002:merge"===keyTag)throw new Error("Should not happen");var mapping=ast.newMapping(keyNode,valueNode);return mapping.parent=_result,keyNode.parent=mapping,null!=valueNode&&(valueNode.parent=mapping),_result.mappings.push(mapping),_result.endPosition=valueNode?valueNode.endPosition:keyNode.endPosition+1,_result}}function readLineBreak(state){var ch;ch=state.input.charCodeAt(state.position),10===ch?state.position++:13===ch?(state.position++,10===state.input.charCodeAt(state.position)&&state.position++):throwError(state,"a line break is expected"),state.line+=1,state.lineStart=state.position}function skipSeparationSpace(state,allowComments,checkIndent){for(var lineBreaks=0,ch=state.input.charCodeAt(state.position);0!==ch;){for(;is_WHITE_SPACE(ch);)ch=state.input.charCodeAt(++state.position);if(allowComments&&35===ch)do ch=state.input.charCodeAt(++state.position);while(10!==ch&&13!==ch&&0!==ch);if(!is_EOL(ch))break;for(readLineBreak(state),ch=state.input.charCodeAt(state.position),lineBreaks++,state.lineIndent=0;32===ch;)state.lineIndent++,ch=state.input.charCodeAt(++state.position)}return-1!==checkIndent&&0!==lineBreaks&&state.lineIndent<checkIndent&&throwWarning(state,"deficient indentation"),lineBreaks}function testDocumentSeparator(state){var ch,_position=state.position;return ch=state.input.charCodeAt(_position),!(45!==ch&&46!==ch||state.input.charCodeAt(_position+1)!==ch||state.input.charCodeAt(_position+2)!==ch||(_position+=3,ch=state.input.charCodeAt(_position),0!==ch&&!is_WS_OR_EOL(ch)))}function writeFoldedLines(state,scalar,count){1===count?scalar.value+=" ":count>1&&(scalar.value+=common.repeat("\n",count-1))}function readPlainScalar(state,nodeIndent,withinFlowCollection){var preceding,following,captureStart,captureEnd,hasPendingContent,_line,_lineStart,_lineIndent,ch,_kind=state.kind,_result=state.result,state_result=ast.newScalar();if(state_result.plainScalar=!0,state.result=state_result,ch=state.input.charCodeAt(state.position),is_WS_OR_EOL(ch)||is_FLOW_INDICATOR(ch)||35===ch||38===ch||42===ch||33===ch||124===ch||62===ch||39===ch||34===ch||37===ch||64===ch||96===ch)return!1;if((63===ch||45===ch)&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following)))return!1;for(state.kind="scalar",captureStart=captureEnd=state.position,hasPendingContent=!1;0!==ch;){if(58===ch){if(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)||withinFlowCollection&&is_FLOW_INDICATOR(following))break}else if(35===ch){if(preceding=state.input.charCodeAt(state.position-1),is_WS_OR_EOL(preceding))break}else{if(state.position===state.lineStart&&testDocumentSeparator(state)||withinFlowCollection&&is_FLOW_INDICATOR(ch))break;if(is_EOL(ch)){if(_line=state.line,_lineStart=state.lineStart,_lineIndent=state.lineIndent,skipSeparationSpace(state,!1,-1),state.lineIndent>=nodeIndent){hasPendingContent=!0,ch=state.input.charCodeAt(state.position);continue}state.position=captureEnd,state.line=_line,state.lineStart=_lineStart,state.lineIndent=_lineIndent;break}}if(hasPendingContent&&(captureSegment(state,captureStart,captureEnd,!1),writeFoldedLines(state,state_result,state.line-_line),captureStart=captureEnd=state.position,hasPendingContent=!1),is_WHITE_SPACE(ch)||(captureEnd=state.position+1),ch=state.input.charCodeAt(++state.position),state.position>=state.input.length)return!1}return captureSegment(state,captureStart,captureEnd,!1),state.result.startPosition!=-1||(state.kind=_kind,state.result=_result,!1)}function readSingleQuotedScalar(state,nodeIndent){var ch,captureStart,captureEnd;if(ch=state.input.charCodeAt(state.position),39!==ch)return!1;var scalar=ast.newScalar();for(state.kind="scalar",state.result=scalar,scalar.startPosition=state.position,state.position++,captureStart=captureEnd=state.position;0!==(ch=state.input.charCodeAt(state.position));)if(39===ch){if(captureSegment(state,captureStart,state.position,!0),ch=state.input.charCodeAt(++state.position),scalar.endPosition=state.position,39!==ch)return!0;captureStart=captureEnd=state.position,state.position++}else is_EOL(ch)?(captureSegment(state,captureStart,captureEnd,!0),writeFoldedLines(state,scalar,skipSeparationSpace(state,!1,nodeIndent)),captureStart=captureEnd=state.position):state.position===state.lineStart&&testDocumentSeparator(state)?throwError(state,"unexpected end of the document within a single quoted scalar"):(state.position++,captureEnd=state.position,scalar.endPosition=state.position);throwError(state,"unexpected end of the stream within a single quoted scalar")}function readDoubleQuotedScalar(state,nodeIndent){var captureStart,captureEnd,hexLength,hexResult,tmp,ch;if(ch=state.input.charCodeAt(state.position),34!==ch)return!1;state.kind="scalar";var scalar=ast.newScalar();for(scalar.doubleQuoted=!0,state.result=scalar,scalar.startPosition=state.position,state.position++,captureStart=captureEnd=state.position;0!==(ch=state.input.charCodeAt(state.position));){if(34===ch)return captureSegment(state,captureStart,state.position,!0),state.position++,scalar.endPosition=state.position,!0;if(92===ch){if(captureSegment(state,captureStart,state.position,!0),ch=state.input.charCodeAt(++state.position),is_EOL(ch))skipSeparationSpace(state,!1,nodeIndent);else if(ch<256&&simpleEscapeCheck[ch])scalar.value+=simpleEscapeMap[ch],state.position++;else if((tmp=escapedHexLen(ch))>0){for(hexLength=tmp,hexResult=0;hexLength>0;hexLength--)ch=state.input.charCodeAt(++state.position),(tmp=fromHexCode(ch))>=0?hexResult=(hexResult<<4)+tmp:throwError(state,"expected hexadecimal character");scalar.value+=charFromCodepoint(hexResult),state.position++}else throwError(state,"unknown escape sequence");captureStart=captureEnd=state.position}else is_EOL(ch)?(captureSegment(state,captureStart,captureEnd,!0),writeFoldedLines(state,scalar,skipSeparationSpace(state,!1,nodeIndent)),captureStart=captureEnd=state.position):state.position===state.lineStart&&testDocumentSeparator(state)?throwError(state,"unexpected end of the document within a double quoted scalar"):(state.position++,captureEnd=state.position)}throwError(state,"unexpected end of the stream within a double quoted scalar")}function readFlowCollection(state,nodeIndent){var _line,_result,following,terminator,isPair,isExplicitPair,isMapping,keyNode,keyTag,valueNode,ch,readNext=!0,_tag=state.tag,_anchor=state.anchor;if(ch=state.input.charCodeAt(state.position),91===ch)terminator=93,isMapping=!1,_result=ast.newItems(),_result.startPosition=state.position;else{if(123!==ch)return!1;terminator=125,isMapping=!0,_result=ast.newMap(),_result.startPosition=state.position}for(null!==state.anchor&&(_result.anchorId=state.anchor,state.anchorMap[state.anchor]=_result),ch=state.input.charCodeAt(++state.position);0!==ch;){if(skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),ch===terminator)return state.position++,state.tag=_tag,state.anchor=_anchor,state.kind=isMapping?"mapping":"sequence",state.result=_result,_result.endPosition=state.position,!0;if(!readNext){var p=state.position;throwError(state,"missed comma between flow collection entries"),state.position=p+1}if(keyTag=keyNode=valueNode=null,isPair=isExplicitPair=!1,63===ch&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following)&&(isPair=isExplicitPair=!0,state.position++,skipSeparationSpace(state,!0,nodeIndent))),_line=state.line,composeNode(state,nodeIndent,CONTEXT_FLOW_IN,!1,!0),keyTag=state.tag,keyNode=state.result,skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),!isExplicitPair&&state.line!==_line||58!==ch||(isPair=!0,ch=state.input.charCodeAt(++state.position),skipSeparationSpace(state,!0,nodeIndent),composeNode(state,nodeIndent,CONTEXT_FLOW_IN,!1,!0),valueNode=state.result),isMapping)storeMappingPair(state,_result,keyTag,keyNode,valueNode);else if(isPair){var mp=storeMappingPair(state,null,keyTag,keyNode,valueNode);mp.parent=_result,_result.items.push(mp)}else keyNode.parent=_result,_result.items.push(keyNode);_result.endPosition=state.position+1,skipSeparationSpace(state,!0,nodeIndent),ch=state.input.charCodeAt(state.position),44===ch?(readNext=!0,ch=state.input.charCodeAt(++state.position)):readNext=!1}throwError(state,"unexpected end of the stream within a flow collection")}function readBlockScalar(state,nodeIndent){var captureStart,folding,tmp,ch,chomping=CHOMPING_CLIP,detectedIndent=!1,textIndent=nodeIndent,emptyLines=0,atMoreIndented=!1;if(ch=state.input.charCodeAt(state.position),124===ch)folding=!1;else{if(62!==ch)return!1;folding=!0}var sc=ast.newScalar();for(state.kind="scalar",state.result=sc,sc.startPosition=state.position;0!==ch;)if(ch=state.input.charCodeAt(++state.position),43===ch||45===ch)CHOMPING_CLIP===chomping?chomping=43===ch?CHOMPING_KEEP:CHOMPING_STRIP:throwError(state,"repeat of a chomping mode identifier");else{if(!((tmp=fromDecimalCode(ch))>=0))break;0===tmp?throwError(state,"bad explicit indentation width of a block scalar; it cannot be less than one"):detectedIndent?throwError(state,"repeat of an indentation width identifier"):(textIndent=nodeIndent+tmp-1,detectedIndent=!0)}if(is_WHITE_SPACE(ch)){do ch=state.input.charCodeAt(++state.position);while(is_WHITE_SPACE(ch));if(35===ch)do ch=state.input.charCodeAt(++state.position);while(!is_EOL(ch)&&0!==ch)}for(;0!==ch;){for(readLineBreak(state),state.lineIndent=0,ch=state.input.charCodeAt(state.position);(!detectedIndent||state.lineIndent<textIndent)&&32===ch;)state.lineIndent++,ch=state.input.charCodeAt(++state.position);if(!detectedIndent&&state.lineIndent>textIndent&&(textIndent=state.lineIndent),is_EOL(ch))emptyLines++;else{if(state.lineIndent<textIndent){chomping===CHOMPING_KEEP?sc.value+=common.repeat("\n",emptyLines):chomping===CHOMPING_CLIP&&detectedIndent&&(sc.value+="\n");break}for(folding?is_WHITE_SPACE(ch)?(atMoreIndented=!0,sc.value+=common.repeat("\n",emptyLines+1)):atMoreIndented?(atMoreIndented=!1,sc.value+=common.repeat("\n",emptyLines+1)):0===emptyLines?detectedIndent&&(sc.value+=" "):sc.value+=common.repeat("\n",emptyLines):detectedIndent&&(sc.value+=common.repeat("\n",emptyLines+1)),detectedIndent=!0,emptyLines=0,captureStart=state.position;!is_EOL(ch)&&0!==ch;)ch=state.input.charCodeAt(++state.position);captureSegment(state,captureStart,state.position,!1)}}sc.endPosition=state.position;for(var i=state.position-1,needMinus=!1;;){var c=state.input[i];if("\r"==c||"\n"==c){needMinus&&i--;break}if(" "!=c&&"\t"!=c)break;i--}return sc.endPosition=i,!0}function readBlockSequence(state,nodeIndent){var _line,following,ch,_tag=state.tag,_anchor=state.anchor,_result=ast.newItems(),detected=!1;for(null!==state.anchor&&(_result.anchorId=state.anchor,state.anchorMap[state.anchor]=_result),_result.startPosition=state.position,ch=state.input.charCodeAt(state.position);0!==ch&&45===ch&&(following=state.input.charCodeAt(state.position+1),is_WS_OR_EOL(following));)if(detected=!0,state.position++,skipSeparationSpace(state,!0,-1)&&state.lineIndent<=nodeIndent)_result.items.push(null),ch=state.input.charCodeAt(state.position);else if(_line=state.line,composeNode(state,nodeIndent,CONTEXT_BLOCK_IN,!1,!0),state.result.parent=_result,_result.items.push(state.result),skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position),(state.line===_line||state.lineIndent>nodeIndent)&&0!==ch)throwError(state,"bad indentation of a sequence entry");else if(state.lineIndent<nodeIndent)break;return _result.endPosition=state.position,!!detected&&(state.tag=_tag,state.anchor=_anchor,state.kind="sequence",state.result=_result,_result.endPosition=state.position,!0)}function readBlockMapping(state,nodeIndent,flowIndent){var following,allowCompact,_line,ch,_tag=state.tag,_anchor=state.anchor,_result=ast.newMap(),keyTag=null,keyNode=null,valueNode=null,atExplicitKey=!1,detected=!1;for(_result.startPosition=state.position,null!==state.anchor&&(_result.anchorId=state.anchor,state.anchorMap[state.anchor]=_result),ch=state.input.charCodeAt(state.position);0!==ch;){if(following=state.input.charCodeAt(state.position+1),_line=state.line,63!==ch&&58!==ch||!is_WS_OR_EOL(following)){if(!composeNode(state,flowIndent,CONTEXT_FLOW_OUT,!1,!0))break;if(state.line===_line){for(ch=state.input.charCodeAt(state.position);is_WHITE_SPACE(ch);)ch=state.input.charCodeAt(++state.position);if(58===ch)ch=state.input.charCodeAt(++state.position),is_WS_OR_EOL(ch)||throwError(state,"a whitespace character is expected after the key-value separator within a block mapping"),atExplicitKey&&(storeMappingPair(state,_result,keyTag,keyNode,null),keyTag=keyNode=valueNode=null),detected=!0,atExplicitKey=!1,allowCompact=!1,keyTag=state.tag,keyNode=state.result;else{if(!detected)return state.tag=_tag,state.anchor=_anchor,!0;throwError(state,"can not read an implicit mapping pair; a colon is missed")}}else{if(!detected)return state.tag=_tag,state.anchor=_anchor,!0;for(throwError(state,"can not read a block mapping entry; a multiline key may not be an implicit key");state.position>0;)if(ch=state.input.charCodeAt(--state.position),is_EOL(ch)){state.position++;break}}}else 63===ch?(atExplicitKey&&(storeMappingPair(state,_result,keyTag,keyNode,null),keyTag=keyNode=valueNode=null),detected=!0,atExplicitKey=!0,allowCompact=!0):atExplicitKey?(atExplicitKey=!1,allowCompact=!0):throwError(state,"incomplete explicit mapping pair; a key node is missed"),state.position+=1,ch=following;if((state.line===_line||state.lineIndent>nodeIndent)&&(composeNode(state,nodeIndent,CONTEXT_BLOCK_OUT,!0,allowCompact)&&(atExplicitKey?keyNode=state.result:valueNode=state.result),atExplicitKey||(storeMappingPair(state,_result,keyTag,keyNode,valueNode),keyTag=keyNode=valueNode=null),skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position)),state.lineIndent>nodeIndent&&0!==ch)throwError(state,"bad indentation of a mapping entry");else if(state.lineIndent<nodeIndent)break}return atExplicitKey&&storeMappingPair(state,_result,keyTag,keyNode,null),detected&&(state.tag=_tag,state.anchor=_anchor,state.kind="mapping",state.result=_result),detected}function readTagProperty(state){var _position,tagHandle,tagName,ch,isVerbatim=!1,isNamed=!1;if(ch=state.input.charCodeAt(state.position),33!==ch)return!1;if(null!==state.tag&&throwError(state,"duplication of a tag property"),ch=state.input.charCodeAt(++state.position),60===ch?(isVerbatim=!0,ch=state.input.charCodeAt(++state.position)):33===ch?(isNamed=!0,tagHandle="!!",ch=state.input.charCodeAt(++state.position)):tagHandle="!",_position=state.position,isVerbatim){do ch=state.input.charCodeAt(++state.position);while(0!==ch&&62!==ch);state.position<state.length?(tagName=state.input.slice(_position,state.position),ch=state.input.charCodeAt(++state.position)):throwError(state,"unexpected end of the stream within a verbatim tag")}else{for(;0!==ch&&!is_WS_OR_EOL(ch);)33===ch&&(isNamed?throwError(state,"tag suffix cannot contain exclamation marks"):(tagHandle=state.input.slice(_position-1,state.position+1),PATTERN_TAG_HANDLE.test(tagHandle)||throwError(state,"named tag handle cannot contain such characters"),isNamed=!0,_position=state.position+1)),ch=state.input.charCodeAt(++state.position);tagName=state.input.slice(_position,state.position),PATTERN_FLOW_INDICATORS.test(tagName)&&throwError(state,"tag suffix cannot contain flow indicator characters")}return tagName&&!PATTERN_TAG_URI.test(tagName)&&throwError(state,"tag name cannot contain such characters: "+tagName),isVerbatim?state.tag=tagName:_hasOwnProperty.call(state.tagMap,tagHandle)?state.tag=state.tagMap[tagHandle]+tagName:"!"===tagHandle?state.tag="!"+tagName:"!!"===tagHandle?state.tag="tag:yaml.org,2002:"+tagName:throwError(state,'undeclared tag handle "'+tagHandle+'"'),!0}function readAnchorProperty(state){var _position,ch;if(ch=state.input.charCodeAt(state.position),38!==ch)return!1;for(null!==state.anchor&&throwError(state,"duplication of an anchor property"),ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch);)ch=state.input.charCodeAt(++state.position);return state.position===_position&&throwError(state,"name of an anchor node must contain at least one character"),state.anchor=state.input.slice(_position,state.position),!0}function readAlias(state){var _position,alias,ch;state.length,state.input;if(ch=state.input.charCodeAt(state.position),42!==ch)return!1;for(ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch)&&!is_FLOW_INDICATOR(ch);)ch=state.input.charCodeAt(++state.position);return state.position<=_position&&(throwError(state,"name of an alias node must contain at least one character"),state.position=_position+1),alias=state.input.slice(_position,state.position),state.anchorMap.hasOwnProperty(alias)||(throwError(state,'unidentified alias "'+alias+'"'),state.position<=_position&&(state.position=_position+1)),state.result=ast.newAnchorRef(alias,_position,state.position,state.anchorMap[alias]),skipSeparationSpace(state,!0,-1),!0}function composeNode(state,parentIndent,nodeContext,allowToSeek,allowCompact){var allowBlockStyles,allowBlockScalars,allowBlockCollections,typeIndex,typeQuantity,type,flowIndent,blockIndent,indentStatus=1,atNewLine=!1,hasContent=!1;if(state.tag=null,state.anchor=null,state.kind=null,state.result=null,allowBlockStyles=allowBlockScalars=allowBlockCollections=CONTEXT_BLOCK_OUT===nodeContext||CONTEXT_BLOCK_IN===nodeContext,allowToSeek&&skipSeparationSpace(state,!0,-1)&&(atNewLine=!0,state.lineIndent>parentIndent?indentStatus=1:state.lineIndent===parentIndent?indentStatus=0:state.lineIndent<parentIndent&&(indentStatus=-1)),1===indentStatus)for(;readTagProperty(state)||readAnchorProperty(state);)skipSeparationSpace(state,!0,-1)?(atNewLine=!0,allowBlockCollections=allowBlockStyles,state.lineIndent>parentIndent?indentStatus=1:state.lineIndent===parentIndent?indentStatus=0:state.lineIndent<parentIndent&&(indentStatus=-1)):allowBlockCollections=!1;if(allowBlockCollections&&(allowBlockCollections=atNewLine||allowCompact),1!==indentStatus&&CONTEXT_BLOCK_OUT!==nodeContext||(flowIndent=CONTEXT_FLOW_IN===nodeContext||CONTEXT_FLOW_OUT===nodeContext?parentIndent:parentIndent+1,blockIndent=state.position-state.lineStart,1===indentStatus?allowBlockCollections&&(readBlockSequence(state,blockIndent)||readBlockMapping(state,blockIndent,flowIndent))||readFlowCollection(state,flowIndent)?hasContent=!0:(allowBlockScalars&&readBlockScalar(state,flowIndent)||readSingleQuotedScalar(state,flowIndent)||readDoubleQuotedScalar(state,flowIndent)?hasContent=!0:readAlias(state)?(hasContent=!0,null===state.tag&&null===state.anchor||throwError(state,"alias node should not have any properties")):readPlainScalar(state,flowIndent,CONTEXT_FLOW_IN===nodeContext)&&(hasContent=!0,null===state.tag&&(state.tag="?")),null!==state.anchor&&(state.anchorMap[state.anchor]=state.result,state.result.anchorId=state.anchor)):0===indentStatus&&(hasContent=allowBlockCollections&&readBlockSequence(state,blockIndent))),null!==state.tag&&"!"!==state.tag)if("!include"==state.tag)state.result||(state.result=ast.newScalar(),state.result.startPosition=state.position,state.result.endPosition=state.position,throwError(state,"!include without value")),state.result.kind=ast.Kind.INCLUDE_REF;else if("?"===state.tag)for(typeIndex=0,typeQuantity=state.implicitTypes.length;typeIndex<typeQuantity;typeIndex+=1){type=state.implicitTypes[typeIndex];var vl=state.result.value;if(type.resolve(vl)){state.result.valueObject=type.construct(state.result.value),state.tag=type.tag,null!==state.anchor&&(state.result.anchorId=state.anchor,state.anchorMap[state.anchor]=state.result);break}}else _hasOwnProperty.call(state.typeMap,state.tag)?(type=state.typeMap[state.tag],null!==state.result&&type.kind!==state.kind&&throwError(state,"unacceptable node kind for !<"+state.tag+'> tag; it should be "'+type.kind+'", not "'+state.kind+'"'),type.resolve(state.result)?(state.result=type.construct(state.result),null!==state.anchor&&(state.result.anchorId=state.anchor,state.anchorMap[state.anchor]=state.result)):throwError(state,"cannot resolve a node with !<"+state.tag+"> explicit tag")):throwWarning(state,"unknown tag !<"+state.tag+">");return null!==state.tag||null!==state.anchor||hasContent}function readDocument(state){var _position,directiveName,directiveArgs,ch,documentStart=state.position,hasDirectives=!1;for(state.version=null,state.checkLineBreaks=state.legacy,state.tagMap={},state.anchorMap={};0!==(ch=state.input.charCodeAt(state.position))&&(skipSeparationSpace(state,!0,-1),ch=state.input.charCodeAt(state.position),!(state.lineIndent>0||37!==ch));){for(hasDirectives=!0,ch=state.input.charCodeAt(++state.position),_position=state.position;0!==ch&&!is_WS_OR_EOL(ch);)ch=state.input.charCodeAt(++state.position);for(directiveName=state.input.slice(_position,state.position),directiveArgs=[],directiveName.length<1&&throwError(state,"directive name must not be less than one character in length");0!==ch;){for(;is_WHITE_SPACE(ch);)ch=state.input.charCodeAt(++state.position);if(35===ch){do ch=state.input.charCodeAt(++state.position);while(0!==ch&&!is_EOL(ch));break}if(is_EOL(ch))break;for(_position=state.position;0!==ch&&!is_WS_OR_EOL(ch);)ch=state.input.charCodeAt(++state.position);directiveArgs.push(state.input.slice(_position,state.position))}0!==ch&&readLineBreak(state),_hasOwnProperty.call(directiveHandlers,directiveName)?directiveHandlers[directiveName](state,directiveName,directiveArgs):(throwWarning(state,'unknown document directive "'+directiveName+'"'),state.position++)}return skipSeparationSpace(state,!0,-1),0===state.lineIndent&&45===state.input.charCodeAt(state.position)&&45===state.input.charCodeAt(state.position+1)&&45===state.input.charCodeAt(state.position+2)?(state.position+=3,skipSeparationSpace(state,!0,-1)):hasDirectives&&throwError(state,"directives end mark is expected"),composeNode(state,state.lineIndent-1,CONTEXT_BLOCK_OUT,!1,!0),skipSeparationSpace(state,!0,-1),state.checkLineBreaks&&PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart,state.position))&&throwWarning(state,"non-ASCII line breaks are interpreted as content"),state.documents.push(state.result),state.position===state.lineStart&&testDocumentSeparator(state)?void(46===state.input.charCodeAt(state.position)&&(state.position+=3,skipSeparationSpace(state,!0,-1))):void(state.position<state.length-1&&throwError(state,"end of the stream or a document separator is expected"))}function loadDocuments(input,options){input=String(input),options=options||{},0!==input.length&&(10!==input.charCodeAt(input.length-1)&&13!==input.charCodeAt(input.length-1)&&(input+="\n"),65279===input.charCodeAt(0)&&(input=input.slice(1)));var state=new State(input,options);for(PATTERN_NON_PRINTABLE.test(state.input)&&throwError(state,"the stream contains non-printable characters"),state.input+="\0";32===state.input.charCodeAt(state.position);)state.lineIndent+=1,state.position+=1;for(;state.position<state.length-1;){var q=state.position;if(readDocument(state),state.position<=q)for(;state.position<state.length-1;state.position++){var c=state.input.charAt(state.position);if("\n"==c)break}}return state.documents.forEach(function(x){return x.errors=state.errors}),state.documents}function loadAll(input,iterator,options){var index,length,documents=loadDocuments(input,options);for(index=0,length=documents.length;index<length;index+=1)iterator(documents[index])}function load(input,options){var documents=loadDocuments(input,options);if(0!==documents.length){if(1===documents.length){var result=documents[0];return result.endPosition=input.length,result.startPosition>result.endPosition&&(result.startPosition=result.endPosition),result}var e=new YAMLException("expected a single document in the stream, but found more");return e.mark=new Mark("","",0,0,0),e.mark.position=documents[0].endPosition,documents[0].errors.push(e),documents[0]}}function safeLoadAll(input,output,options){loadAll(input,output,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}function safeLoad(input,options){return load(input,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}for(var ast=__webpack_require__(99),common=__webpack_require__(97),YAMLException=__webpack_require__(98),Mark=__webpack_require__(100),DEFAULT_SAFE_SCHEMA=__webpack_require__(117),DEFAULT_FULL_SCHEMA=__webpack_require__(116),_hasOwnProperty=Object.prototype.hasOwnProperty,CONTEXT_FLOW_IN=1,CONTEXT_FLOW_OUT=2,CONTEXT_BLOCK_IN=3,CONTEXT_BLOCK_OUT=4,CHOMPING_CLIP=1,CHOMPING_STRIP=2,CHOMPING_KEEP=3,PATTERN_NON_PRINTABLE=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uD800-\uDFFF\uFFFE\uFFFF]/,PATTERN_NON_ASCII_LINE_BREAKS=/[\x85\u2028\u2029]/,PATTERN_FLOW_INDICATORS=/[,\[\]\{\}]/,PATTERN_TAG_HANDLE=/^(?:!|!!|![a-z\-]+!)$/i,PATTERN_TAG_URI=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i,simpleEscapeCheck=new Array(256),simpleEscapeMap=new Array(256),i=0;i<256;i++)simpleEscapeCheck[i]=simpleEscapeSequence(i)?1:0,simpleEscapeMap[i]=simpleEscapeSequence(i);var State=function(){function State(input,options){this.errorMap={},this.errors=[],this.input=input,this.filename=options.filename||null,this.schema=options.schema||DEFAULT_FULL_SCHEMA,this.onWarning=options.onWarning||null,this.legacy=options.legacy||!1,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=input.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.documents=[]}return State}(),directiveHandlers={YAML:function(state,name,args){var match,major,minor;null!==state.version&&throwError(state,"duplication of %YAML directive"),1!==args.length&&throwError(state,"YAML directive accepts exactly one argument"),match=/^([0-9]+)\.([0-9]+)$/.exec(args[0]),null===match&&throwError(state,"ill-formed argument of the YAML directive"),major=parseInt(match[1],10),minor=parseInt(match[2],10),1!==major&&throwError(state,"found incompatible YAML document (version 1.2 is required)"),state.version=args[0],state.checkLineBreaks=minor<2,2!==minor&&throwError(state,"found incompatible YAML document (version 1.2 is required)")},TAG:function(state,name,args){var handle,prefix;2!==args.length&&throwError(state,"TAG directive accepts exactly two arguments"),
handle=args[0],prefix=args[1],PATTERN_TAG_HANDLE.test(handle)||throwError(state,"ill-formed tag handle (first argument) of the TAG directive"),_hasOwnProperty.call(state.tagMap,handle)&&throwError(state,'there is a previously declared suffix for "'+handle+'" tag handle'),PATTERN_TAG_URI.test(prefix)||throwError(state,"ill-formed tag prefix (second argument) of the TAG directive"),state.tagMap[handle]=prefix}};exports.loadAll=loadAll,exports.load=load,exports.safeLoadAll=safeLoadAll,exports.safeLoad=safeLoad,module.exports.loadAll=loadAll,module.exports.load=load,module.exports.safeLoadAll=safeLoadAll,module.exports.safeLoad=safeLoad},function(module,exports,__webpack_require__){"use strict";function compileStyleMap(schema,map){var result,keys,index,length,tag,style,type;if(null===map)return{};for(result={},keys=Object.keys(map),index=0,length=keys.length;index<length;index+=1)tag=keys[index],style=String(map[tag]),"!!"===tag.slice(0,2)&&(tag="tag:yaml.org,2002:"+tag.slice(2)),type=schema.compiledTypeMap[tag],type&&_hasOwnProperty.call(type.styleAliases,style)&&(style=type.styleAliases[style]),result[tag]=style;return result}function encodeHex(character){var string,handle,length;if(string=character.toString(16).toUpperCase(),character<=255)handle="x",length=2;else if(character<=65535)handle="u",length=4;else{if(!(character<=4294967295))throw new YAMLException("code point within a string may not be greater than 0xFFFFFFFF");handle="U",length=8}return"\\"+handle+common.repeat("0",length-string.length)+string}function State(options){this.schema=options.schema||DEFAULT_FULL_SCHEMA,this.indent=Math.max(1,options.indent||2),this.skipInvalid=options.skipInvalid||!1,this.flowLevel=common.isNothing(options.flowLevel)?-1:options.flowLevel,this.styleMap=compileStyleMap(this.schema,options.styles||null),this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function indentString(string,spaces){for(var line,ind=common.repeat(" ",spaces),position=0,next=-1,result="",length=string.length;position<length;)next=string.indexOf("\n",position),next===-1?(line=string.slice(position),position=length):(line=string.slice(position,next+1),position=next+1),line.length&&"\n"!==line&&(result+=ind),result+=line;return result}function generateNextLine(state,level){return"\n"+common.repeat(" ",state.indent*level)}function testImplicitResolving(state,str){var index,length,type;for(index=0,length=state.implicitTypes.length;index<length;index+=1)if(type=state.implicitTypes[index],type.resolve(str))return!0;return!1}function StringBuilder(source){this.source=source,this.result="",this.checkpoint=0}function writeScalar(state,object,level){var simple,first,spaceWrap,folded,literal,single,double,sawLineFeed,linePosition,longestLine,indent,max,character,position,escapeSeq,hexEsc,previous,lineLength,modifier,trailingLineBreaks,result;if(0===object.length)return void(state.dump="''");if(0==object.indexOf("!include"))return void(state.dump=""+object);if(0==object.indexOf("!$$$novalue"))return void(state.dump="");if(-1!==DEPRECATED_BOOLEANS_SYNTAX.indexOf(object))return void(state.dump="'"+object+"'");for(simple=!0,first=object.length?object.charCodeAt(0):0,spaceWrap=CHAR_SPACE===first||CHAR_SPACE===object.charCodeAt(object.length-1),CHAR_MINUS!==first&&CHAR_QUESTION!==first&&CHAR_COMMERCIAL_AT!==first&&CHAR_GRAVE_ACCENT!==first||(simple=!1),spaceWrap?(simple=!1,folded=!1,literal=!1):(folded=!0,literal=!0),single=!0,double=new StringBuilder(object),sawLineFeed=!1,linePosition=0,longestLine=0,indent=state.indent*level,max=80,indent<40?max-=indent:max=40,position=0;position<object.length;position++){if(character=object.charCodeAt(position),simple){if(simpleChar(character))continue;simple=!1}single&&character===CHAR_SINGLE_QUOTE&&(single=!1),escapeSeq=ESCAPE_SEQUENCES[character],hexEsc=needsHexEscape(character),(escapeSeq||hexEsc)&&(character!==CHAR_LINE_FEED&&character!==CHAR_DOUBLE_QUOTE&&character!==CHAR_SINGLE_QUOTE?(folded=!1,literal=!1):character===CHAR_LINE_FEED&&(sawLineFeed=!0,single=!1,position>0&&(previous=object.charCodeAt(position-1),previous===CHAR_SPACE&&(literal=!1,folded=!1)),folded&&(lineLength=position-linePosition,linePosition=position,lineLength>longestLine&&(longestLine=lineLength))),character!==CHAR_DOUBLE_QUOTE&&(single=!1),double.takeUpTo(position),double.escapeChar())}if(simple&&testImplicitResolving(state,object)&&(simple=!1),modifier="",(folded||literal)&&(trailingLineBreaks=0,object.charCodeAt(object.length-1)===CHAR_LINE_FEED&&(trailingLineBreaks+=1,object.charCodeAt(object.length-2)===CHAR_LINE_FEED&&(trailingLineBreaks+=1)),0===trailingLineBreaks?modifier="-":2===trailingLineBreaks&&(modifier="+")),literal&&longestLine<max&&(folded=!1),sawLineFeed||(literal=!1),simple)state.dump=object;else if(single)state.dump="'"+object+"'";else if(folded)result=fold(object,max),state.dump=">"+modifier+"\n"+indentString(result,indent);else if(literal)modifier||(object=object.replace(/\n$/,"")),state.dump="|"+modifier+"\n"+indentString(object,indent);else{if(!double)throw new Error("Failed to dump scalar value");double.finish(),state.dump='"'+double.result+'"'}}function fold(object,max){var newLine,result="",position=0,length=object.length,trailing=/\n+$/.exec(object);for(trailing&&(length=trailing.index+1);position<length;)newLine=object.indexOf("\n",position),newLine>length||newLine===-1?(result&&(result+="\n\n"),result+=foldLine(object.slice(position,length),max),position=length):(result&&(result+="\n\n"),result+=foldLine(object.slice(position,newLine),max),position=newLine+1);return trailing&&"\n"!==trailing[0]&&(result+=trailing[0]),result}function foldLine(line,max){if(""===line)return line;for(var index,foldEnd,folded,foldRe=/[^\s] [^\s]/g,result="",prevMatch=0,foldStart=0,match=foldRe.exec(line);match;)index=match.index,index-foldStart>max&&(foldEnd=prevMatch!==foldStart?prevMatch:index,result&&(result+="\n"),folded=line.slice(foldStart,foldEnd),result+=folded,foldStart=foldEnd+1),prevMatch=index+1,match=foldRe.exec(line);return result&&(result+="\n"),result+=foldStart!==prevMatch&&line.length-foldStart>max?line.slice(foldStart,prevMatch)+"\n"+line.slice(prevMatch+1):line.slice(foldStart)}function simpleChar(character){return CHAR_TAB!==character&&CHAR_LINE_FEED!==character&&CHAR_CARRIAGE_RETURN!==character&&CHAR_COMMA!==character&&CHAR_LEFT_SQUARE_BRACKET!==character&&CHAR_RIGHT_SQUARE_BRACKET!==character&&CHAR_LEFT_CURLY_BRACKET!==character&&CHAR_RIGHT_CURLY_BRACKET!==character&&CHAR_SHARP!==character&&CHAR_AMPERSAND!==character&&CHAR_ASTERISK!==character&&CHAR_EXCLAMATION!==character&&CHAR_VERTICAL_LINE!==character&&CHAR_GREATER_THAN!==character&&CHAR_SINGLE_QUOTE!==character&&CHAR_DOUBLE_QUOTE!==character&&CHAR_PERCENT!==character&&CHAR_COLON!==character&&!ESCAPE_SEQUENCES[character]&&!needsHexEscape(character)}function needsHexEscape(character){return!(32<=character&&character<=126||133===character||160<=character&&character<=55295||57344<=character&&character<=65533||65536<=character&&character<=1114111)}function writeFlowSequence(state,level,object){var index,length,_result="",_tag=state.tag;for(index=0,length=object.length;index<length;index+=1)writeNode(state,level,object[index],!1,!1)&&(0!==index&&(_result+=", "),_result+=state.dump);state.tag=_tag,state.dump="["+_result+"]"}function writeBlockSequence(state,level,object,compact){var index,length,_result="",_tag=state.tag;for(index=0,length=object.length;index<length;index+=1)writeNode(state,level+1,object[index],!0,!0)&&(compact&&0===index||(_result+=generateNextLine(state,level)),_result+="- "+state.dump);state.tag=_tag,state.dump=_result||"[]"}function writeFlowMapping(state,level,object){var index,length,objectKey,objectValue,pairBuffer,_result="",_tag=state.tag,objectKeyList=Object.keys(object);for(index=0,length=objectKeyList.length;index<length;index+=1)pairBuffer="",0!==index&&(pairBuffer+=", "),objectKey=objectKeyList[index],objectValue=object[objectKey],writeNode(state,level,objectKey,!1,!1)&&(state.dump.length>1024&&(pairBuffer+="? "),pairBuffer+=state.dump+": ",writeNode(state,level,objectValue,!1,!1)&&(pairBuffer+=state.dump,_result+=pairBuffer));state.tag=_tag,state.dump="{"+_result+"}"}function writeBlockMapping(state,level,object,compact){var index,length,objectKey,objectValue,explicitPair,pairBuffer,_result="",_tag=state.tag,objectKeyList=Object.keys(object);for(index=0,length=objectKeyList.length;index<length;index+=1)pairBuffer="",compact&&0===index||(pairBuffer+=generateNextLine(state,level)),objectKey=objectKeyList[index],objectValue=object[objectKey],writeNode(state,level+1,objectKey,!0,!0)&&(explicitPair=null!==state.tag&&"?"!==state.tag||state.dump&&state.dump.length>1024,explicitPair&&(pairBuffer+=state.dump&&CHAR_LINE_FEED===state.dump.charCodeAt(0)?"?":"? "),pairBuffer+=state.dump,explicitPair&&(pairBuffer+=generateNextLine(state,level)),writeNode(state,level+1,objectValue,!0,explicitPair)&&(pairBuffer+=state.dump&&CHAR_LINE_FEED===state.dump.charCodeAt(0)?":":": ",pairBuffer+=state.dump,_result+=pairBuffer));state.tag=_tag,state.dump=_result||"{}"}function detectType(state,object,explicit){var _result,typeList,index,length,type,style;for(typeList=explicit?state.explicitTypes:state.implicitTypes,index=0,length=typeList.length;index<length;index+=1)if(type=typeList[index],(type.instanceOf||type.predicate)&&(!type.instanceOf||"object"==typeof object&&object instanceof type.instanceOf)&&(!type.predicate||type.predicate(object))){if(state.tag=explicit?type.tag:"?",type.represent){if(style=state.styleMap[type.tag]||type.defaultStyle,"[object Function]"===_toString.call(type.represent))_result=type.represent(object,style);else{if(!_hasOwnProperty.call(type.represent,style))throw new YAMLException("!<"+type.tag+'> tag resolver accepts not "'+style+'" style');_result=type.represent[style](object,style)}state.dump=_result}return!0}return!1}function writeNode(state,level,object,block,compact){state.tag=null,state.dump=object,detectType(state,object,!1)||detectType(state,object,!0);var type=_toString.call(state.dump);block&&(block=0>state.flowLevel||state.flowLevel>level),(null!==state.tag&&"?"!==state.tag||2!==state.indent&&level>0)&&(compact=!1);var duplicateIndex,duplicate,objectOrArray="[object Object]"===type||"[object Array]"===type;if(objectOrArray&&(duplicateIndex=state.duplicates.indexOf(object),duplicate=duplicateIndex!==-1),duplicate&&state.usedDuplicates[duplicateIndex])state.dump="*ref_"+duplicateIndex;else{if(objectOrArray&&duplicate&&!state.usedDuplicates[duplicateIndex]&&(state.usedDuplicates[duplicateIndex]=!0),"[object Object]"===type)block&&0!==Object.keys(state.dump).length?(writeBlockMapping(state,level,state.dump,compact),duplicate&&(state.dump="&ref_"+duplicateIndex+(0===level?"\n":"")+state.dump)):(writeFlowMapping(state,level,state.dump),duplicate&&(state.dump="&ref_"+duplicateIndex+" "+state.dump));else if("[object Array]"===type)block&&0!==state.dump.length?(writeBlockSequence(state,level,state.dump,compact),duplicate&&(state.dump="&ref_"+duplicateIndex+(0===level?"\n":"")+state.dump)):(writeFlowSequence(state,level,state.dump),duplicate&&(state.dump="&ref_"+duplicateIndex+" "+state.dump));else{if("[object String]"!==type){if(state.skipInvalid)return!1;throw new YAMLException("unacceptable kind of an object to dump "+type)}"?"!==state.tag&&writeScalar(state,state.dump,level)}null!==state.tag&&"?"!==state.tag&&(state.dump="!<"+state.tag+"> "+state.dump)}return!0}function getDuplicateReferences(object,state){var index,length,objects=[],duplicatesIndexes=[];for(inspectNode(object,objects,duplicatesIndexes),index=0,length=duplicatesIndexes.length;index<length;index+=1)state.duplicates.push(objects[duplicatesIndexes[index]]);state.usedDuplicates=new Array(length)}function inspectNode(object,objects,duplicatesIndexes){var objectKeyList,index,length;_toString.call(object);if(null!==object&&"object"==typeof object)if(index=objects.indexOf(object),-1!==index)-1===duplicatesIndexes.indexOf(index)&&duplicatesIndexes.push(index);else if(objects.push(object),Array.isArray(object))for(index=0,length=object.length;index<length;index+=1)inspectNode(object[index],objects,duplicatesIndexes);else for(objectKeyList=Object.keys(object),index=0,length=objectKeyList.length;index<length;index+=1)inspectNode(object[objectKeyList[index]],objects,duplicatesIndexes)}function dump(input,options){options=options||{};var state=new State(options);return getDuplicateReferences(input,state),writeNode(state,0,input,!0,!0)?state.dump+"\n":""}function safeDump(input,options){return dump(input,common.extend({schema:DEFAULT_SAFE_SCHEMA},options))}var common=__webpack_require__(97),YAMLException=__webpack_require__(98),DEFAULT_FULL_SCHEMA=__webpack_require__(116),DEFAULT_SAFE_SCHEMA=__webpack_require__(117),_toString=Object.prototype.toString,_hasOwnProperty=Object.prototype.hasOwnProperty,CHAR_TAB=9,CHAR_LINE_FEED=10,CHAR_CARRIAGE_RETURN=13,CHAR_SPACE=32,CHAR_EXCLAMATION=33,CHAR_DOUBLE_QUOTE=34,CHAR_SHARP=35,CHAR_PERCENT=37,CHAR_AMPERSAND=38,CHAR_SINGLE_QUOTE=39,CHAR_ASTERISK=42,CHAR_COMMA=44,CHAR_MINUS=45,CHAR_COLON=58,CHAR_GREATER_THAN=62,CHAR_QUESTION=63,CHAR_COMMERCIAL_AT=64,CHAR_LEFT_SQUARE_BRACKET=91,CHAR_RIGHT_SQUARE_BRACKET=93,CHAR_GRAVE_ACCENT=96,CHAR_LEFT_CURLY_BRACKET=123,CHAR_VERTICAL_LINE=124,CHAR_RIGHT_CURLY_BRACKET=125,ESCAPE_SEQUENCES={};ESCAPE_SEQUENCES[0]="\\0",ESCAPE_SEQUENCES[7]="\\a",ESCAPE_SEQUENCES[8]="\\b",ESCAPE_SEQUENCES[9]="\\t",ESCAPE_SEQUENCES[10]="\\n",ESCAPE_SEQUENCES[11]="\\v",ESCAPE_SEQUENCES[12]="\\f",ESCAPE_SEQUENCES[13]="\\r",ESCAPE_SEQUENCES[27]="\\e",ESCAPE_SEQUENCES[34]='\\"',ESCAPE_SEQUENCES[92]="\\\\",ESCAPE_SEQUENCES[133]="\\N",ESCAPE_SEQUENCES[160]="\\_",ESCAPE_SEQUENCES[8232]="\\L",ESCAPE_SEQUENCES[8233]="\\P";var DEPRECATED_BOOLEANS_SYNTAX=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"];StringBuilder.prototype.takeUpTo=function(position){var er;if(position<this.checkpoint)throw er=new Error("position should be > checkpoint"),er.position=position,er.checkpoint=this.checkpoint,er;return this.result+=this.source.slice(this.checkpoint,position),this.checkpoint=position,this},StringBuilder.prototype.escapeChar=function(){var character,esc;return character=this.source.charCodeAt(this.checkpoint),esc=ESCAPE_SEQUENCES[character]||encodeHex(character),this.result+=esc,this.checkpoint+=1,this},StringBuilder.prototype.finish=function(){this.source.length>this.checkpoint&&this.takeUpTo(this.source.length)},exports.dump=dump,exports.safeDump=safeDump},function(module,exports,__webpack_require__){"use strict";function getSchemaUtils(){return schemaUtil}function isParsedType(object){return object instanceof ts.AbstractType}function loadTypeCollection(data,registry){return void 0===registry&&(registry=ts.builtInRegistry()),tc.parseJSONTypeCollection(data,registry)}function loadType(data){return tc.parseJSON(null,data,ts.builtInRegistry())}function parse(data){return data.types||data.annotationTypes?tc.parseJSONTypeCollection(data):tc.parseJSON(null,data)}function parseType(data,collection){return tc.parseJSON(null,data,collection?collection.getTypeRegistry():ts.builtInRegistry())}function parseFromAST(data){return tc.parseTypeCollection(data,ts.builtInRegistry())}function parseTypeFromAST(name,data,collection,defaultsToAny,annotation,global,ignoreTypeAttr){return void 0===defaultsToAny&&(defaultsToAny=!1),void 0===annotation&&(annotation=!1),void 0===global&&(global=!0),void 0===ignoreTypeAttr&&(ignoreTypeAttr=!1),tc.parse(name,data,collection?collection.getTypeRegistry():ts.builtInRegistry(),defaultsToAny,annotation,global,ignoreTypeAttr)}function dump(ts){return tc.storeAsJSON(ts)}function validate(i,t,autoClose){void 0===autoClose&&(autoClose=!1),ts.autoCloseFlag=autoClose;try{return t.validate(i,autoClose)}finally{ts.autoCloseFlag=!1}}function validateTypeDefinition(t,collection){return t.validateType(collection.getAnnotationTypeRegistry())}function performAC(i,t){return t.ac(i)}function checkACStatus(t){return t.canDoAc()}function builtInFacets(){return fr.getInstance().allPrototypes()}function builtInTypes(){return ts.builtInRegistry()}function derive(name){for(var types=[],_i=1;_i<arguments.length;_i++)types[_i-1]=arguments[_i];return ts.derive(name,types)}function unify(name){for(var types=[],_i=1;_i<arguments.length;_i++)types[_i-1]=arguments[_i];return ts.union(name,types)}function setPropertyConstructor(c){nm.setPropertyConstructor(c)}function toNominal(t,bt){return nm.toNominal(t,bt)}var ts=__webpack_require__(103);exports.tsInterfaces=__webpack_require__(104);var tc=__webpack_require__(105),fr=__webpack_require__(106),restrictions_1=__webpack_require__(107),metainfo_1=__webpack_require__(108),metainfo_2=__webpack_require__(108),metainfo_3=__webpack_require__(108),nm=__webpack_require__(109);exports.nominalTypes=__webpack_require__(110),exports.nominalInterfaces=__webpack_require__(111),exports.typeExpressions=__webpack_require__(112);var schemaUtil=__webpack_require__(113);exports.TOP_LEVEL_EXTRA=exports.tsInterfaces.TOP_LEVEL_EXTRA,exports.DEFINED_IN_TYPES_EXTRA=exports.tsInterfaces.DEFINED_IN_TYPES_EXTRA,exports.USER_DEFINED_EXTRA=exports.tsInterfaces.USER_DEFINED_EXTRA,exports.SOURCE_EXTRA=exports.tsInterfaces.SOURCE_EXTRA,exports.getSchemaUtils=getSchemaUtils,exports.isParsedType=isParsedType,exports.loadTypeCollection=loadTypeCollection,exports.loadType=loadType,exports.parse=parse,exports.parseType=parseType,function(NodeKind){NodeKind[NodeKind.SCALAR=0]="SCALAR",NodeKind[NodeKind.ARRAY=1]="ARRAY",NodeKind[NodeKind.MAP=2]="MAP"}(exports.NodeKind||(exports.NodeKind={}));exports.NodeKind;exports.parseFromAST=parseFromAST,exports.parseTypeFromAST=parseTypeFromAST,exports.dump=dump,exports.validate=validate,exports.validateTypeDefinition=validateTypeDefinition,exports.performAC=performAC,exports.checkACStatus=checkACStatus,exports.builtInFacets=builtInFacets,exports.builtInTypes=builtInTypes,exports.derive=derive,exports.unify=unify;var TypeConstructor=function(){function TypeConstructor(target){this.target=target}return TypeConstructor.prototype.addProperty=function(name,type,optional){return this.target.declareProperty(name,type,optional),this},TypeConstructor.prototype.closeType=function(){return this.target.addMeta(new restrictions_1.KnownPropertyRestriction((!1))),this},TypeConstructor.prototype.annotate=function(name,value){return this.target.addMeta(new metainfo_1.Annotation(name,value)),this},TypeConstructor.prototype.customFacet=function(name,value){return this.target.addMeta(new metainfo_2.CustomFacet(name,value)),this},TypeConstructor.prototype.customFacetDeclaration=function(name,value,optional){return void 0===optional&&(optional=!0),this.target.addMeta(new metainfo_3.FacetDeclaration(name,value,optional)),this},TypeConstructor.prototype.addSimpleFacet=function(name,value){return this.target.addMeta(fr.getInstance().buildFacet(name,value)),this},TypeConstructor.prototype.getResult=function(){return this.target},TypeConstructor}();exports.TypeConstructor=TypeConstructor,exports.setPropertyConstructor=setPropertyConstructor,exports.toNominal=toNominal},function(module,exports,__webpack_require__){function XMLReader(){}function parse(source,defaultNSMapCopy,entityMap,domBuilder,errorHandler){function fixedFromCharCode(code){if(code>65535){code-=65536;var surrogate1=55296+(code>>10),surrogate2=56320+(1023&code);return String.fromCharCode(surrogate1,surrogate2)}return String.fromCharCode(code)}function entityReplacer(a){var k=a.slice(1,-1);return k in entityMap?entityMap[k]:"#"===k.charAt(0)?fixedFromCharCode(parseInt(k.substr(1).replace("x","0x"))):(errorHandler.error("entity not found:"+a),a)}function appendText(end){if(end>start){var xt=source.substring(start,end).replace(/&#?\w+;/g,entityReplacer);locator&&position(start),domBuilder.characters(xt,0,end-start),start=end}}function position(p,m){for(;p>=lineEnd&&(m=linePattern.exec(source));)lineStart=m.index,lineEnd=lineStart+m[0].length,locator.lineNumber++;locator.columnNumber=p-lineStart+1}for(var lineStart=0,lineEnd=0,linePattern=/.+(?:\r\n?|\n)|.*$/g,locator=domBuilder.locator,parseStack=[{currentNSMap:defaultNSMapCopy}],closeMap={},start=0;;){try{var tagStart=source.indexOf("<",start);if(tagStart<0){if(!source.substr(start).match(/^\s*$/)){var doc=domBuilder.document,text=doc.createTextNode(source.substr(start));doc.appendChild(text),domBuilder.currentElement=text}return}switch(tagStart>start&&appendText(tagStart),source.charAt(tagStart+1)){case"/":var end=source.indexOf(">",tagStart+3),tagName=source.substring(tagStart+2,end),config=parseStack.pop(),localNSMap=config.localNSMap;if(config.tagName!=tagName&&errorHandler.fatalError("end tag name: "+tagName+" is not match the current start tagName:"+config.tagName),domBuilder.endElement(config.uri,config.localName,tagName),localNSMap)for(var prefix in localNSMap)domBuilder.endPrefixMapping(prefix);end++;break;case"?":locator&&position(tagStart),end=parseInstruction(source,tagStart,domBuilder);break;case"!":locator&&position(tagStart),end=parseDCC(source,tagStart,domBuilder,errorHandler);break;default:locator&&position(tagStart);var el=new ElementAttributes,end=parseElementStartPart(source,tagStart,el,entityReplacer,errorHandler),len=el.length;if(locator){if(len)for(var i=0;i<len;i++){var a=el[i];position(a.offset),a.offset=copyLocator(locator,{})}position(end)}!el.closed&&fixSelfClosed(source,end,el.tagName,closeMap)&&(el.closed=!0,entityMap.nbsp||errorHandler.warning("unclosed xml attribute")),appendElement(el,domBuilder,parseStack),"http://www.w3.org/1999/xhtml"!==el.uri||el.closed?end++:end=parseHtmlSpecialContent(source,end,el.tagName,entityReplacer,domBuilder)}}catch(e){errorHandler.error("element parse error: "+e),end=-1}end>start?start=end:appendText(Math.max(tagStart,start)+1)}}function copyLocator(f,t){return t.lineNumber=f.lineNumber,t.columnNumber=f.columnNumber,t}function parseElementStartPart(source,start,el,entityReplacer,errorHandler){for(var attrName,value,p=++start,s=S_TAG;;){var c=source.charAt(p);switch(c){case"=":if(s===S_ATTR)attrName=source.slice(start,p),s=S_EQ;else{if(s!==S_ATTR_S)throw new Error("attribute equal must after attrName");s=S_EQ}break;case"'":case'"':if(s===S_EQ){if(start=p+1,p=source.indexOf(c,start),!(p>0))throw new Error("attribute value no end '"+c+"' match");value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer),el.add(attrName,value,start-1),s=S_E}else{if(s!=S_V)throw new Error('attribute value must after "="');value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer),el.add(attrName,value,start),errorHandler.warning('attribute "'+attrName+'" missed start quot('+c+")!!"),start=p+1,s=S_E}break;case"/":switch(s){case S_TAG:el.setTagName(source.slice(start,p));case S_E:case S_S:case S_C:s=S_C,el.closed=!0;case S_V:case S_ATTR:case S_ATTR_S:break;default:throw new Error("attribute invalid close char('/')")}break;case"":errorHandler.error("unexpected end of input");case">":switch(s){case S_TAG:el.setTagName(source.slice(start,p));case S_E:case S_S:case S_C:break;case S_V:case S_ATTR:value=source.slice(start,p),"/"===value.slice(-1)&&(el.closed=!0,value=value.slice(0,-1));case S_ATTR_S:s===S_ATTR_S&&(value=attrName),s==S_V?(errorHandler.warning('attribute "'+value+'" missed quot(")!!'),el.add(attrName,value.replace(/&#?\w+;/g,entityReplacer),start)):(errorHandler.warning('attribute "'+value+'" missed value!! "'+value+'" instead!!'),el.add(value,value,start));break;case S_EQ:throw new Error("attribute value missed!!")}return p;case"":c=" ";default:if(c<=" ")switch(s){case S_TAG:el.setTagName(source.slice(start,p)),s=S_S;break;case S_ATTR:attrName=source.slice(start,p),s=S_ATTR_S;break;case S_V:var value=source.slice(start,p).replace(/&#?\w+;/g,entityReplacer);errorHandler.warning('attribute "'+value+'" missed quot(")!!'),el.add(attrName,value,start);case S_E:s=S_S}else switch(s){case S_ATTR_S:errorHandler.warning('attribute "'+attrName+'" missed value!! "'+attrName+'" instead!!'),el.add(attrName,attrName,start),start=p,s=S_ATTR;break;case S_E:errorHandler.warning('attribute space is required"'+attrName+'"!!');case S_S:s=S_ATTR,start=p;break;case S_EQ:s=S_V,start=p;break;case S_C:throw new Error("elements closed character '/' and '>' must be connected to")}}p++}}function appendElement(el,domBuilder,parseStack){for(var tagName=el.tagName,localNSMap=null,currentNSMap=parseStack[parseStack.length-1].currentNSMap,i=el.length;i--;){var a=el[i],qName=a.qName,value=a.value,nsp=qName.indexOf(":");if(nsp>0)var prefix=a.prefix=qName.slice(0,nsp),localName=qName.slice(nsp+1),nsPrefix="xmlns"===prefix&&localName;else localName=qName,prefix=null,nsPrefix="xmlns"===qName&&"";a.localName=localName,nsPrefix!==!1&&(null==localNSMap&&(localNSMap={},_copy(currentNSMap,currentNSMap={})),currentNSMap[nsPrefix]=localNSMap[nsPrefix]=value,a.uri="http://www.w3.org/2000/xmlns/",domBuilder.startPrefixMapping(nsPrefix,value))}for(var i=el.length;i--;){a=el[i];var prefix=a.prefix;prefix&&("xml"===prefix&&(a.uri="http://www.w3.org/XML/1998/namespace"),"xmlns"!==prefix&&(a.uri=currentNSMap[prefix]))}var nsp=tagName.indexOf(":");nsp>0?(prefix=el.prefix=tagName.slice(0,nsp),localName=el.localName=tagName.slice(nsp+1)):(prefix=null,localName=el.localName=tagName);var ns=el.uri=currentNSMap[prefix||""];if(domBuilder.startElement(ns,localName,tagName,el),el.closed){if(domBuilder.endElement(ns,localName,tagName),localNSMap)for(prefix in localNSMap)domBuilder.endPrefixMapping(prefix)}else el.currentNSMap=currentNSMap,el.localNSMap=localNSMap,parseStack.push(el)}function parseHtmlSpecialContent(source,elStartEnd,tagName,entityReplacer,domBuilder){if(/^(?:script|textarea)$/i.test(tagName)){var elEndStart=source.indexOf("</"+tagName+">",elStartEnd),text=source.substring(elStartEnd+1,elEndStart);if(/[&<]/.test(text))return/^script$/i.test(tagName)?(domBuilder.characters(text,0,text.length),elEndStart):(text=text.replace(/&#?\w+;/g,entityReplacer),domBuilder.characters(text,0,text.length),elEndStart)}return elStartEnd+1}function fixSelfClosed(source,elStartEnd,tagName,closeMap){var pos=closeMap[tagName];return null==pos&&(pos=closeMap[tagName]=source.lastIndexOf("</"+tagName+">")),pos<elStartEnd}function _copy(source,target){for(var n in source)target[n]=source[n]}function parseDCC(source,start,domBuilder,errorHandler){var next=source.charAt(start+2);switch(next){case"-":if("-"===source.charAt(start+3)){var end=source.indexOf("-->",start+4);return end>start?(domBuilder.comment(source,start+4,end-start-4),end+3):(errorHandler.error("Unclosed comment"),-1)}return-1;default:if("CDATA["==source.substr(start+3,6)){var end=source.indexOf("]]>",start+9);return domBuilder.startCDATA(),domBuilder.characters(source,start+9,end-start-9),domBuilder.endCDATA(),end+3}var matchs=split(source,start),len=matchs.length;if(len>1&&/!doctype/i.test(matchs[0][0])){var name=matchs[1][0],pubid=len>3&&/^public$/i.test(matchs[2][0])&&matchs[3][0],sysid=len>4&&matchs[4][0],lastMatch=matchs[len-1];return domBuilder.startDTD(name,pubid&&pubid.replace(/^(['"])(.*?)\1$/,"$2"),sysid&&sysid.replace(/^(['"])(.*?)\1$/,"$2")),domBuilder.endDTD(),lastMatch.index+lastMatch[0].length}}return-1}function parseInstruction(source,start,domBuilder){var end=source.indexOf("?>",start);if(end){var match=source.substring(start,end).match(/^<\?(\S*)\s*([\s\S]*?)\s*$/);if(match){match[0].length;return domBuilder.processingInstruction(match[1],match[2]),end+2}return-1}return-1}function ElementAttributes(source){}function _set_proto_(thiz,parent){return thiz.__proto__=parent,thiz}function split(source,start){var match,buf=[],reg=/'[^']+'|"[^"]+"|[^\s<>\/=]+=?|(\/?\s*>|<)/g;for(reg.lastIndex=start,reg.exec(source);match=reg.exec(source);)if(buf.push(match),match[1])return buf}var nameStartChar=/[A-Z_a-z\xC0-\xD6\xD8-\xF6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/,nameChar=new RegExp("[\\-\\.0-9"+nameStartChar.source.slice(1,-1)+"·̀-ͯ\\u203F-⁀]"),tagNamePattern=new RegExp("^"+nameStartChar.source+nameChar.source+"*(?::"+nameStartChar.source+nameChar.source+"*)?$"),S_TAG=0,S_ATTR=1,S_ATTR_S=2,S_EQ=3,S_V=4,S_E=5,S_S=6,S_C=7;XMLReader.prototype={parse:function(source,defaultNSMap,entityMap){var domBuilder=this.domBuilder;domBuilder.startDocument(),_copy(defaultNSMap,defaultNSMap={}),parse(source,defaultNSMap,entityMap,domBuilder,this.errorHandler),domBuilder.endDocument()}},ElementAttributes.prototype={setTagName:function(tagName){if(!tagNamePattern.test(tagName))throw new Error("invalid tagName:"+tagName);this.tagName=tagName},add:function(qName,value,offset){if(!tagNamePattern.test(qName))throw new Error("invalid attribute:"+qName);this[this.length++]={qName:qName,value:value,offset:offset}},length:0,getLocalName:function(i){return this[i].localName},getOffset:function(i){return this[i].offset},getQName:function(i){return this[i].qName},getURI:function(i){return this[i].uri},getValue:function(i){return this[i].value}},_set_proto_({},_set_proto_.prototype)instanceof _set_proto_||(_set_proto_=function(thiz,parent){function p(){}p.prototype=parent,p=new p;for(parent in thiz)p[parent]=thiz[parent];return p}),exports.XMLReader=XMLReader},function(module,exports,__webpack_require__){function copy(src,dest){for(var p in src)dest[p]=src[p]}function _extends(Class,Super){function t(){}var pt=Class.prototype;if(Object.create){var ppt=Object.create(Super.prototype);pt.__proto__=ppt}pt instanceof Super||(t.prototype=Super.prototype,t=new t,copy(pt,t),Class.prototype=pt=t),pt.constructor!=Class&&("function"!=typeof Class&&console.error("unknow Class:"+Class),pt.constructor=Class)}function DOMException(code,message){if(message instanceof Error)var error=message;else error=this,Error.call(this,ExceptionMessage[code]),this.message=ExceptionMessage[code],Error.captureStackTrace&&Error.captureStackTrace(this,DOMException);return error.code=code,message&&(this.message=this.message+": "+message),error}function NodeList(){}function LiveNodeList(node,refresh){this._node=node,this._refresh=refresh,_updateLiveList(this)}function _updateLiveList(list){var inc=list._node._inc||list._node.ownerDocument._inc;if(list._inc!=inc){var ls=list._refresh(list._node);__set__(list,"length",ls.length),copy(ls,list),list._inc=inc}}function NamedNodeMap(){}function _findNodeIndex(list,node){for(var i=list.length;i--;)if(list[i]===node)return i}function _addNamedNode(el,list,newAttr,oldAttr){if(oldAttr?list[_findNodeIndex(list,oldAttr)]=newAttr:list[list.length++]=newAttr,el){newAttr.ownerElement=el;var doc=el.ownerDocument;doc&&(oldAttr&&_onRemoveAttribute(doc,el,oldAttr),_onAddAttribute(doc,el,newAttr))}}function _removeNamedNode(el,list,attr){var i=_findNodeIndex(list,attr);if(!(i>=0))throw DOMException(NOT_FOUND_ERR,new Error);for(var lastIndex=list.length-1;i<lastIndex;)list[i]=list[++i];if(list.length=lastIndex,el){var doc=el.ownerDocument;doc&&(_onRemoveAttribute(doc,el,attr),attr.ownerElement=null)}}function DOMImplementation(features){if(this._features={},features)for(var feature in features)this._features=features[feature]}function Node(){}function _xmlEncoder(c){return"<"==c&&"&lt;"||">"==c&&"&gt;"||"&"==c&&"&amp;"||'"'==c&&"&quot;"||"&#"+c.charCodeAt()+";"}function _visitNode(node,callback){if(callback(node))return!0;if(node=node.firstChild)do if(_visitNode(node,callback))return!0;while(node=node.nextSibling)}function Document(){}function _onAddAttribute(doc,el,newAttr){doc&&doc._inc++;var ns=newAttr.namespaceURI;"http://www.w3.org/2000/xmlns/"==ns&&(el._nsMap[newAttr.prefix?newAttr.localName:""]=newAttr.value)}function _onRemoveAttribute(doc,el,newAttr,remove){doc&&doc._inc++;var ns=newAttr.namespaceURI;"http://www.w3.org/2000/xmlns/"==ns&&delete el._nsMap[newAttr.prefix?newAttr.localName:""]}function _onUpdateChild(doc,el,newChild){if(doc&&doc._inc){
doc._inc++;var cs=el.childNodes;if(newChild)cs[cs.length++]=newChild;else{for(var child=el.firstChild,i=0;child;)cs[i++]=child,child=child.nextSibling;cs.length=i}}}function _removeChild(parentNode,child){var previous=child.previousSibling,next=child.nextSibling;return previous?previous.nextSibling=next:parentNode.firstChild=next,next?next.previousSibling=previous:parentNode.lastChild=previous,_onUpdateChild(parentNode.ownerDocument,parentNode),child}function _insertBefore(parentNode,newChild,nextChild){var cp=newChild.parentNode;if(cp&&cp.removeChild(newChild),newChild.nodeType===DOCUMENT_FRAGMENT_NODE){var newFirst=newChild.firstChild;if(null==newFirst)return newChild;var newLast=newChild.lastChild}else newFirst=newLast=newChild;var pre=nextChild?nextChild.previousSibling:parentNode.lastChild;newFirst.previousSibling=pre,newLast.nextSibling=nextChild,pre?pre.nextSibling=newFirst:parentNode.firstChild=newFirst,null==nextChild?parentNode.lastChild=newLast:nextChild.previousSibling=newLast;do newFirst.parentNode=parentNode;while(newFirst!==newLast&&(newFirst=newFirst.nextSibling));return _onUpdateChild(parentNode.ownerDocument||parentNode,parentNode),newChild.nodeType==DOCUMENT_FRAGMENT_NODE&&(newChild.firstChild=newChild.lastChild=null),newChild}function _appendSingleChild(parentNode,newChild){var cp=newChild.parentNode;if(cp){var pre=parentNode.lastChild;cp.removeChild(newChild);var pre=parentNode.lastChild}var pre=parentNode.lastChild;return newChild.parentNode=parentNode,newChild.previousSibling=pre,newChild.nextSibling=null,pre?pre.nextSibling=newChild:parentNode.firstChild=newChild,parentNode.lastChild=newChild,_onUpdateChild(parentNode.ownerDocument,parentNode,newChild),newChild}function Element(){this._nsMap={}}function Attr(){}function CharacterData(){}function Text(){}function Comment(){}function CDATASection(){}function DocumentType(){}function Notation(){}function Entity(){}function EntityReference(){}function DocumentFragment(){}function ProcessingInstruction(){}function XMLSerializer(){}function serializeToString(node,buf,attributeSorter,isHTML){switch(node.nodeType){case ELEMENT_NODE:var attrs=node.attributes,len=attrs.length,child=node.firstChild,nodeName=node.tagName;isHTML=htmlns===node.namespaceURI||isHTML,buf.push("<",nodeName),attributeSorter&&buf.sort.apply(attrs,attributeSorter);for(var i=0;i<len;i++)serializeToString(attrs.item(i),buf,attributeSorter,isHTML);if(child||isHTML&&!/^(?:meta|link|img|br|hr|input|button)$/i.test(nodeName)){if(buf.push(">"),isHTML&&/^script$/i.test(nodeName))child&&buf.push(child.data);else for(;child;)serializeToString(child,buf,attributeSorter,isHTML),child=child.nextSibling;buf.push("</",nodeName,">")}else buf.push("/>");return;case DOCUMENT_NODE:case DOCUMENT_FRAGMENT_NODE:for(var child=node.firstChild;child;)serializeToString(child,buf,attributeSorter,isHTML),child=child.nextSibling;return;case ATTRIBUTE_NODE:return buf.push(" ",node.name,'="',node.value.replace(/[<&"]/g,_xmlEncoder),'"');case TEXT_NODE:return buf.push(node.data.replace(/[<&]/g,_xmlEncoder));case CDATA_SECTION_NODE:return buf.push("<![CDATA[",node.data,"]]>");case COMMENT_NODE:return buf.push("<!--",node.data,"-->");case DOCUMENT_TYPE_NODE:var pubid=node.publicId,sysid=node.systemId;if(buf.push("<!DOCTYPE ",node.name),pubid)buf.push(' PUBLIC "',pubid),sysid&&"."!=sysid&&buf.push('" "',sysid),buf.push('">');else if(sysid&&"."!=sysid)buf.push(' SYSTEM "',sysid,'">');else{var sub=node.internalSubset;sub&&buf.push(" [",sub,"]"),buf.push(">")}return;case PROCESSING_INSTRUCTION_NODE:return buf.push("<?",node.target," ",node.data,"?>");case ENTITY_REFERENCE_NODE:return buf.push("&",node.nodeName,";");default:buf.push("??",node.nodeName)}}function importNode(doc,node,deep){var node2;switch(node.nodeType){case ELEMENT_NODE:node2=node.cloneNode(!1),node2.ownerDocument=doc;case DOCUMENT_FRAGMENT_NODE:break;case ATTRIBUTE_NODE:deep=!0}if(node2||(node2=node.cloneNode(!1)),node2.ownerDocument=doc,node2.parentNode=null,deep)for(var child=node.firstChild;child;)node2.appendChild(importNode(doc,child,deep)),child=child.nextSibling;return node2}function cloneNode(doc,node,deep){var node2=new node.constructor;for(var n in node){var v=node[n];"object"!=typeof v&&v!=node2[n]&&(node2[n]=v)}switch(node.childNodes&&(node2.childNodes=new NodeList),node2.ownerDocument=doc,node2.nodeType){case ELEMENT_NODE:var attrs=node.attributes,attrs2=node2.attributes=new NamedNodeMap,len=attrs.length;attrs2._ownerElement=node2;for(var i=0;i<len;i++)node2.setAttributeNode(cloneNode(doc,attrs.item(i),!0));break;case ATTRIBUTE_NODE:deep=!0}if(deep)for(var child=node.firstChild;child;)node2.appendChild(cloneNode(doc,child,deep)),child=child.nextSibling;return node2}function __set__(object,key,value){object[key]=value}function getTextContent(node){switch(node.nodeType){case 1:case 11:var buf=[];for(node=node.firstChild;node;)7!==node.nodeType&&8!==node.nodeType&&buf.push(getTextContent(node)),node=node.nextSibling;return buf.join("");default:return node.nodeValue}}var htmlns="http://www.w3.org/1999/xhtml",NodeType={},ELEMENT_NODE=NodeType.ELEMENT_NODE=1,ATTRIBUTE_NODE=NodeType.ATTRIBUTE_NODE=2,TEXT_NODE=NodeType.TEXT_NODE=3,CDATA_SECTION_NODE=NodeType.CDATA_SECTION_NODE=4,ENTITY_REFERENCE_NODE=NodeType.ENTITY_REFERENCE_NODE=5,ENTITY_NODE=NodeType.ENTITY_NODE=6,PROCESSING_INSTRUCTION_NODE=NodeType.PROCESSING_INSTRUCTION_NODE=7,COMMENT_NODE=NodeType.COMMENT_NODE=8,DOCUMENT_NODE=NodeType.DOCUMENT_NODE=9,DOCUMENT_TYPE_NODE=NodeType.DOCUMENT_TYPE_NODE=10,DOCUMENT_FRAGMENT_NODE=NodeType.DOCUMENT_FRAGMENT_NODE=11,NOTATION_NODE=NodeType.NOTATION_NODE=12,ExceptionCode={},ExceptionMessage={},NOT_FOUND_ERR=(ExceptionCode.INDEX_SIZE_ERR=(ExceptionMessage[1]="Index size error",1),ExceptionCode.DOMSTRING_SIZE_ERR=(ExceptionMessage[2]="DOMString size error",2),ExceptionCode.HIERARCHY_REQUEST_ERR=(ExceptionMessage[3]="Hierarchy request error",3),ExceptionCode.WRONG_DOCUMENT_ERR=(ExceptionMessage[4]="Wrong document",4),ExceptionCode.INVALID_CHARACTER_ERR=(ExceptionMessage[5]="Invalid character",5),ExceptionCode.NO_DATA_ALLOWED_ERR=(ExceptionMessage[6]="No data allowed",6),ExceptionCode.NO_MODIFICATION_ALLOWED_ERR=(ExceptionMessage[7]="No modification allowed",7),ExceptionCode.NOT_FOUND_ERR=(ExceptionMessage[8]="Not found",8)),INUSE_ATTRIBUTE_ERR=(ExceptionCode.NOT_SUPPORTED_ERR=(ExceptionMessage[9]="Not supported",9),ExceptionCode.INUSE_ATTRIBUTE_ERR=(ExceptionMessage[10]="Attribute in use",10));ExceptionCode.INVALID_STATE_ERR=(ExceptionMessage[11]="Invalid state",11),ExceptionCode.SYNTAX_ERR=(ExceptionMessage[12]="Syntax error",12),ExceptionCode.INVALID_MODIFICATION_ERR=(ExceptionMessage[13]="Invalid modification",13),ExceptionCode.NAMESPACE_ERR=(ExceptionMessage[14]="Invalid namespace",14),ExceptionCode.INVALID_ACCESS_ERR=(ExceptionMessage[15]="Invalid access",15);DOMException.prototype=Error.prototype,copy(ExceptionCode,DOMException),NodeList.prototype={length:0,item:function(index){return this[index]||null},toString:function(){for(var buf=[],i=0;i<this.length;i++)serializeToString(this[i],buf);return buf.join("")}},LiveNodeList.prototype.item=function(i){return _updateLiveList(this),this[i]},_extends(LiveNodeList,NodeList),NamedNodeMap.prototype={length:0,item:NodeList.prototype.item,getNamedItem:function(key){for(var i=this.length;i--;){var attr=this[i];if(attr.nodeName==key)return attr}},setNamedItem:function(attr){var el=attr.ownerElement;if(el&&el!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);var oldAttr=this.getNamedItem(attr.nodeName);return _addNamedNode(this._ownerElement,this,attr,oldAttr),oldAttr},setNamedItemNS:function(attr){var oldAttr,el=attr.ownerElement;if(el&&el!=this._ownerElement)throw new DOMException(INUSE_ATTRIBUTE_ERR);return oldAttr=this.getNamedItemNS(attr.namespaceURI,attr.localName),_addNamedNode(this._ownerElement,this,attr,oldAttr),oldAttr},removeNamedItem:function(key){var attr=this.getNamedItem(key);return _removeNamedNode(this._ownerElement,this,attr),attr},removeNamedItemNS:function(namespaceURI,localName){var attr=this.getNamedItemNS(namespaceURI,localName);return _removeNamedNode(this._ownerElement,this,attr),attr},getNamedItemNS:function(namespaceURI,localName){for(var i=this.length;i--;){var node=this[i];if(node.localName==localName&&node.namespaceURI==namespaceURI)return node}return null}},DOMImplementation.prototype={hasFeature:function(feature,version){var versions=this._features[feature.toLowerCase()];return!(!versions||version&&!(version in versions))},createDocument:function(namespaceURI,qualifiedName,doctype){var doc=new Document;if(doc.implementation=this,doc.childNodes=new NodeList,doc.doctype=doctype,doctype&&doc.appendChild(doctype),qualifiedName){var root=doc.createElementNS(namespaceURI,qualifiedName);doc.appendChild(root)}return doc},createDocumentType:function(qualifiedName,publicId,systemId){var node=new DocumentType;return node.name=qualifiedName,node.nodeName=qualifiedName,node.publicId=publicId,node.systemId=systemId,node}},Node.prototype={firstChild:null,lastChild:null,previousSibling:null,nextSibling:null,attributes:null,parentNode:null,childNodes:null,ownerDocument:null,nodeValue:null,namespaceURI:null,prefix:null,localName:null,insertBefore:function(newChild,refChild){return _insertBefore(this,newChild,refChild)},replaceChild:function(newChild,oldChild){this.insertBefore(newChild,oldChild),oldChild&&this.removeChild(oldChild)},removeChild:function(oldChild){return _removeChild(this,oldChild)},appendChild:function(newChild){return this.insertBefore(newChild,null)},hasChildNodes:function(){return null!=this.firstChild},cloneNode:function(deep){return cloneNode(this.ownerDocument||this,this,deep)},normalize:function(){for(var child=this.firstChild;child;){var next=child.nextSibling;next&&next.nodeType==TEXT_NODE&&child.nodeType==TEXT_NODE?(this.removeChild(next),child.appendData(next.data)):(child.normalize(),child=next)}},isSupported:function(feature,version){return this.ownerDocument.implementation.hasFeature(feature,version)},hasAttributes:function(){return this.attributes.length>0},lookupPrefix:function(namespaceURI){for(var el=this;el;){var map=el._nsMap;if(map)for(var n in map)if(map[n]==namespaceURI)return n;el=2==el.nodeType?el.ownerDocument:el.parentNode}return null},lookupNamespaceURI:function(prefix){for(var el=this;el;){var map=el._nsMap;if(map&&prefix in map)return map[prefix];el=2==el.nodeType?el.ownerDocument:el.parentNode}return null},isDefaultNamespace:function(namespaceURI){var prefix=this.lookupPrefix(namespaceURI);return null==prefix}},copy(NodeType,Node),copy(NodeType,Node.prototype),Document.prototype={nodeName:"#document",nodeType:DOCUMENT_NODE,doctype:null,documentElement:null,_inc:1,insertBefore:function(newChild,refChild){if(newChild.nodeType==DOCUMENT_FRAGMENT_NODE){for(var child=newChild.firstChild;child;){var next=child.nextSibling;this.insertBefore(child,refChild),child=next}return newChild}return null==this.documentElement&&1==newChild.nodeType&&(this.documentElement=newChild),_insertBefore(this,newChild,refChild),newChild.ownerDocument=this,newChild},removeChild:function(oldChild){return this.documentElement==oldChild&&(this.documentElement=null),_removeChild(this,oldChild)},importNode:function(importedNode,deep){return importNode(this,importedNode,deep)},getElementById:function(id){var rtv=null;return _visitNode(this.documentElement,function(node){if(1==node.nodeType&&node.getAttribute("id")==id)return rtv=node,!0}),rtv},createElement:function(tagName){var node=new Element;node.ownerDocument=this,node.nodeName=tagName,node.tagName=tagName,node.childNodes=new NodeList;var attrs=node.attributes=new NamedNodeMap;return attrs._ownerElement=node,node},createDocumentFragment:function(){var node=new DocumentFragment;return node.ownerDocument=this,node.childNodes=new NodeList,node},createTextNode:function(data){var node=new Text;return node.ownerDocument=this,node.appendData(data),node},createComment:function(data){var node=new Comment;return node.ownerDocument=this,node.appendData(data),node},createCDATASection:function(data){var node=new CDATASection;return node.ownerDocument=this,node.appendData(data),node},createProcessingInstruction:function(target,data){var node=new ProcessingInstruction;return node.ownerDocument=this,node.tagName=node.target=target,node.nodeValue=node.data=data,node},createAttribute:function(name){var node=new Attr;return node.ownerDocument=this,node.name=name,node.nodeName=name,node.localName=name,node.specified=!0,node},createEntityReference:function(name){var node=new EntityReference;return node.ownerDocument=this,node.nodeName=name,node},createElementNS:function(namespaceURI,qualifiedName){var node=new Element,pl=qualifiedName.split(":"),attrs=node.attributes=new NamedNodeMap;return node.childNodes=new NodeList,node.ownerDocument=this,node.nodeName=qualifiedName,node.tagName=qualifiedName,node.namespaceURI=namespaceURI,2==pl.length?(node.prefix=pl[0],node.localName=pl[1]):node.localName=qualifiedName,attrs._ownerElement=node,node},createAttributeNS:function(namespaceURI,qualifiedName){var node=new Attr,pl=qualifiedName.split(":");return node.ownerDocument=this,node.nodeName=qualifiedName,node.name=qualifiedName,node.namespaceURI=namespaceURI,node.specified=!0,2==pl.length?(node.prefix=pl[0],node.localName=pl[1]):node.localName=qualifiedName,node}},_extends(Document,Node),Element.prototype={nodeType:ELEMENT_NODE,hasAttribute:function(name){return null!=this.getAttributeNode(name)},getAttribute:function(name){var attr=this.getAttributeNode(name);return attr&&attr.value||""},getAttributeNode:function(name){return this.attributes.getNamedItem(name)},setAttribute:function(name,value){var attr=this.ownerDocument.createAttribute(name);attr.value=attr.nodeValue=""+value,this.setAttributeNode(attr)},removeAttribute:function(name){var attr=this.getAttributeNode(name);attr&&this.removeAttributeNode(attr)},appendChild:function(newChild){return newChild.nodeType===DOCUMENT_FRAGMENT_NODE?this.insertBefore(newChild,null):_appendSingleChild(this,newChild)},setAttributeNode:function(newAttr){return this.attributes.setNamedItem(newAttr)},setAttributeNodeNS:function(newAttr){return this.attributes.setNamedItemNS(newAttr)},removeAttributeNode:function(oldAttr){return this.attributes.removeNamedItem(oldAttr.nodeName)},removeAttributeNS:function(namespaceURI,localName){var old=this.getAttributeNodeNS(namespaceURI,localName);old&&this.removeAttributeNode(old)},hasAttributeNS:function(namespaceURI,localName){return null!=this.getAttributeNodeNS(namespaceURI,localName)},getAttributeNS:function(namespaceURI,localName){var attr=this.getAttributeNodeNS(namespaceURI,localName);return attr&&attr.value||""},setAttributeNS:function(namespaceURI,qualifiedName,value){var attr=this.ownerDocument.createAttributeNS(namespaceURI,qualifiedName);attr.value=attr.nodeValue=""+value,this.setAttributeNode(attr)},getAttributeNodeNS:function(namespaceURI,localName){return this.attributes.getNamedItemNS(namespaceURI,localName)},getElementsByTagName:function(tagName){return new LiveNodeList(this,function(base){var ls=[];return _visitNode(base,function(node){node===base||node.nodeType!=ELEMENT_NODE||"*"!==tagName&&node.tagName!=tagName||ls.push(node)}),ls})},getElementsByTagNameNS:function(namespaceURI,localName){return new LiveNodeList(this,function(base){var ls=[];return _visitNode(base,function(node){node===base||node.nodeType!==ELEMENT_NODE||"*"!==namespaceURI&&node.namespaceURI!==namespaceURI||"*"!==localName&&node.localName!=localName||ls.push(node)}),ls})}},Document.prototype.getElementsByTagName=Element.prototype.getElementsByTagName,Document.prototype.getElementsByTagNameNS=Element.prototype.getElementsByTagNameNS,_extends(Element,Node),Attr.prototype.nodeType=ATTRIBUTE_NODE,_extends(Attr,Node),CharacterData.prototype={data:"",substringData:function(offset,count){return this.data.substring(offset,offset+count)},appendData:function(text){text=this.data+text,this.nodeValue=this.data=text,this.length=text.length},insertData:function(offset,text){this.replaceData(offset,0,text)},appendChild:function(newChild){throw new Error(ExceptionMessage[3])},deleteData:function(offset,count){this.replaceData(offset,count,"")},replaceData:function(offset,count,text){var start=this.data.substring(0,offset),end=this.data.substring(offset+count);text=start+text+end,this.nodeValue=this.data=text,this.length=text.length}},_extends(CharacterData,Node),Text.prototype={nodeName:"#text",nodeType:TEXT_NODE,splitText:function(offset){var text=this.data,newText=text.substring(offset);text=text.substring(0,offset),this.data=this.nodeValue=text,this.length=text.length;var newNode=this.ownerDocument.createTextNode(newText);return this.parentNode&&this.parentNode.insertBefore(newNode,this.nextSibling),newNode}},_extends(Text,CharacterData),Comment.prototype={nodeName:"#comment",nodeType:COMMENT_NODE},_extends(Comment,CharacterData),CDATASection.prototype={nodeName:"#cdata-section",nodeType:CDATA_SECTION_NODE},_extends(CDATASection,CharacterData),DocumentType.prototype.nodeType=DOCUMENT_TYPE_NODE,_extends(DocumentType,Node),Notation.prototype.nodeType=NOTATION_NODE,_extends(Notation,Node),Entity.prototype.nodeType=ENTITY_NODE,_extends(Entity,Node),EntityReference.prototype.nodeType=ENTITY_REFERENCE_NODE,_extends(EntityReference,Node),DocumentFragment.prototype.nodeName="#document-fragment",DocumentFragment.prototype.nodeType=DOCUMENT_FRAGMENT_NODE,_extends(DocumentFragment,Node),ProcessingInstruction.prototype.nodeType=PROCESSING_INSTRUCTION_NODE,_extends(ProcessingInstruction,Node),XMLSerializer.prototype.serializeToString=function(node,attributeSorter){return node.toString(attributeSorter)},Node.prototype.toString=function(attributeSorter){var buf=[];return serializeToString(this,buf,attributeSorter),buf.join("")};try{Object.defineProperty&&(Object.defineProperty(LiveNodeList.prototype,"length",{get:function(){return _updateLiveList(this),this.$$length}}),Object.defineProperty(Node.prototype,"textContent",{get:function(){return getTextContent(this)},set:function(data){switch(this.nodeType){case 1:case 11:for(;this.firstChild;)this.removeChild(this.firstChild);(data||String(data))&&this.appendChild(this.ownerDocument.createTextNode(data));break;default:this.data=data,this.value=value,this.nodeValue=data}}}),__set__=function(object,key,value){object["$$"+key]=value})}catch(e){}exports.DOMImplementation=DOMImplementation,exports.XMLSerializer=XMLSerializer},function(module,exports,__webpack_require__){"use strict";function handleQs(url,query){url=url.split("?");var start=url[0],qs=(url[1]||"").split("#")[0],end=url[1]&&url[1].split("#").length>1?"#"+url[1].split("#")[1]:"",baseQs=parse(qs);for(var i in query)baseQs[i]=query[i];return qs=stringify(baseQs),""!==qs&&(qs="?"+qs),start+qs+end}var parse=__webpack_require__(166).parse,stringify=__webpack_require__(166).stringify;module.exports=handleQs},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;(function(){function createReduce(dir){function iterator(obj,iteratee,memo,keys,index,length){for(;index>=0&&index<length;index+=dir){var currentKey=keys?keys[index]:index;memo=iteratee(memo,obj[currentKey],currentKey,obj)}return memo}return function(obj,iteratee,memo,context){iteratee=optimizeCb(iteratee,context,4);var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=dir>0?0:length-1;return arguments.length<3&&(memo=obj[keys?keys[index]:index],index+=dir),iterator(obj,iteratee,memo,keys,index,length)}}function createPredicateIndexFinder(dir){return function(array,predicate,context){predicate=cb(predicate,context);for(var length=getLength(array),index=dir>0?0:length-1;index>=0&&index<length;index+=dir)if(predicate(array[index],index,array))return index;return-1}}function createIndexFinder(dir,predicateFind,sortedIndex){return function(array,item,idx){var i=0,length=getLength(array);if("number"==typeof idx)dir>0?i=idx>=0?idx:Math.max(idx+length,i):length=idx>=0?Math.min(idx+1,length):idx+length+1;else if(sortedIndex&&idx&&length)return idx=sortedIndex(array,item),array[idx]===item?idx:-1;if(item!==item)return idx=predicateFind(slice.call(array,i,length),_.isNaN),idx>=0?idx+i:-1;for(idx=dir>0?i:length-1;idx>=0&&idx<length;idx+=dir)if(array[idx]===item)return idx;return-1}}function collectNonEnumProps(obj,keys){var nonEnumIdx=nonEnumerableProps.length,constructor=obj.constructor,proto=_.isFunction(constructor)&&constructor.prototype||ObjProto,prop="constructor";for(_.has(obj,prop)&&!_.contains(keys,prop)&&keys.push(prop);nonEnumIdx--;)prop=nonEnumerableProps[nonEnumIdx],prop in obj&&obj[prop]!==proto[prop]&&!_.contains(keys,prop)&&keys.push(prop)}var root=this,previousUnderscore=root._,ArrayProto=Array.prototype,ObjProto=Object.prototype,FuncProto=Function.prototype,push=ArrayProto.push,slice=ArrayProto.slice,toString=ObjProto.toString,hasOwnProperty=ObjProto.hasOwnProperty,nativeIsArray=Array.isArray,nativeKeys=Object.keys,nativeBind=FuncProto.bind,nativeCreate=Object.create,Ctor=function(){},_=function(obj){return obj instanceof _?obj:this instanceof _?void(this._wrapped=obj):new _(obj)};"undefined"!=typeof module&&module.exports&&(exports=module.exports=_),exports._=_,_.VERSION="1.8.3";var optimizeCb=function(func,context,argCount){if(void 0===context)return func;switch(null==argCount?3:argCount){case 1:return function(value){return func.call(context,value)};case 2:return function(value,other){return func.call(context,value,other)};case 3:return function(value,index,collection){return func.call(context,value,index,collection)};case 4:return function(accumulator,value,index,collection){return func.call(context,accumulator,value,index,collection)}}return function(){return func.apply(context,arguments)}},cb=function(value,context,argCount){return null==value?_.identity:_.isFunction(value)?optimizeCb(value,context,argCount):_.isObject(value)?_.matcher(value):_.property(value)};_.iteratee=function(value,context){return cb(value,context,1/0)};var createAssigner=function(keysFunc,undefinedOnly){return function(obj){var length=arguments.length;if(length<2||null==obj)return obj;for(var index=1;index<length;index++)for(var source=arguments[index],keys=keysFunc(source),l=keys.length,i=0;i<l;i++){var key=keys[i];undefinedOnly&&void 0!==obj[key]||(obj[key]=source[key])}return obj}},baseCreate=function(prototype){if(!_.isObject(prototype))return{};if(nativeCreate)return nativeCreate(prototype);Ctor.prototype=prototype;var result=new Ctor;return Ctor.prototype=null,result},property=function(key){return function(obj){return null==obj?void 0:obj[key]}},MAX_ARRAY_INDEX=Math.pow(2,53)-1,getLength=property("length"),isArrayLike=function(collection){var length=getLength(collection);return"number"==typeof length&&length>=0&&length<=MAX_ARRAY_INDEX};_.each=_.forEach=function(obj,iteratee,context){iteratee=optimizeCb(iteratee,context);var i,length;if(isArrayLike(obj))for(i=0,length=obj.length;i<length;i++)iteratee(obj[i],i,obj);else{var keys=_.keys(obj);for(i=0,length=keys.length;i<length;i++)iteratee(obj[keys[i]],keys[i],obj)}return obj},_.map=_.collect=function(obj,iteratee,context){iteratee=cb(iteratee,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,results=Array(length),index=0;index<length;index++){var currentKey=keys?keys[index]:index;results[index]=iteratee(obj[currentKey],currentKey,obj)}return results},_.reduce=_.foldl=_.inject=createReduce(1),_.reduceRight=_.foldr=createReduce(-1),_.find=_.detect=function(obj,predicate,context){var key;if(key=isArrayLike(obj)?_.findIndex(obj,predicate,context):_.findKey(obj,predicate,context),void 0!==key&&key!==-1)return obj[key]},_.filter=_.select=function(obj,predicate,context){var results=[];return predicate=cb(predicate,context),_.each(obj,function(value,index,list){predicate(value,index,list)&&results.push(value)}),results},_.reject=function(obj,predicate,context){return _.filter(obj,_.negate(cb(predicate)),context)},_.every=_.all=function(obj,predicate,context){predicate=cb(predicate,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=0;index<length;index++){var currentKey=keys?keys[index]:index;if(!predicate(obj[currentKey],currentKey,obj))return!1}return!0},_.some=_.any=function(obj,predicate,context){predicate=cb(predicate,context);for(var keys=!isArrayLike(obj)&&_.keys(obj),length=(keys||obj).length,index=0;index<length;index++){var currentKey=keys?keys[index]:index;if(predicate(obj[currentKey],currentKey,obj))return!0}return!1},_.contains=_.includes=_.include=function(obj,item,fromIndex,guard){return isArrayLike(obj)||(obj=_.values(obj)),("number"!=typeof fromIndex||guard)&&(fromIndex=0),_.indexOf(obj,item,fromIndex)>=0},_.invoke=function(obj,method){var args=slice.call(arguments,2),isFunc=_.isFunction(method);return _.map(obj,function(value){var func=isFunc?method:value[method];return null==func?func:func.apply(value,args)})},_.pluck=function(obj,key){return _.map(obj,_.property(key))},_.where=function(obj,attrs){return _.filter(obj,_.matcher(attrs))},_.findWhere=function(obj,attrs){return _.find(obj,_.matcher(attrs))},_.max=function(obj,iteratee,context){var value,computed,result=-(1/0),lastComputed=-(1/0);if(null==iteratee&&null!=obj){obj=isArrayLike(obj)?obj:_.values(obj);for(var i=0,length=obj.length;i<length;i++)value=obj[i],value>result&&(result=value)}else iteratee=cb(iteratee,context),_.each(obj,function(value,index,list){computed=iteratee(value,index,list),(computed>lastComputed||computed===-(1/0)&&result===-(1/0))&&(result=value,lastComputed=computed)});return result},_.min=function(obj,iteratee,context){var value,computed,result=1/0,lastComputed=1/0;if(null==iteratee&&null!=obj){obj=isArrayLike(obj)?obj:_.values(obj);for(var i=0,length=obj.length;i<length;i++)value=obj[i],value<result&&(result=value)}else iteratee=cb(iteratee,context),_.each(obj,function(value,index,list){computed=iteratee(value,index,list),(computed<lastComputed||computed===1/0&&result===1/0)&&(result=value,lastComputed=computed)});return result},_.shuffle=function(obj){for(var rand,set=isArrayLike(obj)?obj:_.values(obj),length=set.length,shuffled=Array(length),index=0;index<length;index++)rand=_.random(0,index),rand!==index&&(shuffled[index]=shuffled[rand]),shuffled[rand]=set[index];return shuffled},_.sample=function(obj,n,guard){return null==n||guard?(isArrayLike(obj)||(obj=_.values(obj)),obj[_.random(obj.length-1)]):_.shuffle(obj).slice(0,Math.max(0,n))},_.sortBy=function(obj,iteratee,context){return iteratee=cb(iteratee,context),_.pluck(_.map(obj,function(value,index,list){return{value:value,index:index,criteria:iteratee(value,index,list)}}).sort(function(left,right){var a=left.criteria,b=right.criteria;if(a!==b){if(a>b||void 0===a)return 1;if(a<b||void 0===b)return-1}return left.index-right.index}),"value")};var group=function(behavior){return function(obj,iteratee,context){var result={};return iteratee=cb(iteratee,context),_.each(obj,function(value,index){var key=iteratee(value,index,obj);behavior(result,value,key)}),result}};_.groupBy=group(function(result,value,key){_.has(result,key)?result[key].push(value):result[key]=[value]}),_.indexBy=group(function(result,value,key){result[key]=value}),_.countBy=group(function(result,value,key){_.has(result,key)?result[key]++:result[key]=1}),_.toArray=function(obj){return obj?_.isArray(obj)?slice.call(obj):isArrayLike(obj)?_.map(obj,_.identity):_.values(obj):[]},_.size=function(obj){return null==obj?0:isArrayLike(obj)?obj.length:_.keys(obj).length},_.partition=function(obj,predicate,context){predicate=cb(predicate,context);var pass=[],fail=[];return _.each(obj,function(value,key,obj){(predicate(value,key,obj)?pass:fail).push(value)}),[pass,fail]},_.first=_.head=_.take=function(array,n,guard){if(null!=array)return null==n||guard?array[0]:_.initial(array,array.length-n)},_.initial=function(array,n,guard){return slice.call(array,0,Math.max(0,array.length-(null==n||guard?1:n)))},_.last=function(array,n,guard){if(null!=array)return null==n||guard?array[array.length-1]:_.rest(array,Math.max(0,array.length-n))},_.rest=_.tail=_.drop=function(array,n,guard){return slice.call(array,null==n||guard?1:n)},_.compact=function(array){return _.filter(array,_.identity)};var flatten=function(input,shallow,strict,startIndex){for(var output=[],idx=0,i=startIndex||0,length=getLength(input);i<length;i++){var value=input[i];if(isArrayLike(value)&&(_.isArray(value)||_.isArguments(value))){shallow||(value=flatten(value,shallow,strict));var j=0,len=value.length;for(output.length+=len;j<len;)output[idx++]=value[j++]}else strict||(output[idx++]=value)}return output};_.flatten=function(array,shallow){return flatten(array,shallow,!1)},_.without=function(array){return _.difference(array,slice.call(arguments,1))},_.uniq=_.unique=function(array,isSorted,iteratee,context){_.isBoolean(isSorted)||(context=iteratee,iteratee=isSorted,isSorted=!1),null!=iteratee&&(iteratee=cb(iteratee,context));for(var result=[],seen=[],i=0,length=getLength(array);i<length;i++){var value=array[i],computed=iteratee?iteratee(value,i,array):value;isSorted?(i&&seen===computed||result.push(value),seen=computed):iteratee?_.contains(seen,computed)||(seen.push(computed),result.push(value)):_.contains(result,value)||result.push(value)}return result},_.union=function(){return _.uniq(flatten(arguments,!0,!0))},_.intersection=function(array){for(var result=[],argsLength=arguments.length,i=0,length=getLength(array);i<length;i++){var item=array[i];if(!_.contains(result,item)){for(var j=1;j<argsLength&&_.contains(arguments[j],item);j++);j===argsLength&&result.push(item)}}return result},_.difference=function(array){var rest=flatten(arguments,!0,!0,1);return _.filter(array,function(value){return!_.contains(rest,value)})},_.zip=function(){return _.unzip(arguments)},_.unzip=function(array){for(var length=array&&_.max(array,getLength).length||0,result=Array(length),index=0;index<length;index++)result[index]=_.pluck(array,index);return result},_.object=function(list,values){for(var result={},i=0,length=getLength(list);i<length;i++)values?result[list[i]]=values[i]:result[list[i][0]]=list[i][1];return result},_.findIndex=createPredicateIndexFinder(1),_.findLastIndex=createPredicateIndexFinder(-1),_.sortedIndex=function(array,obj,iteratee,context){iteratee=cb(iteratee,context,1);for(var value=iteratee(obj),low=0,high=getLength(array);low<high;){var mid=Math.floor((low+high)/2);iteratee(array[mid])<value?low=mid+1:high=mid}return low},_.indexOf=createIndexFinder(1,_.findIndex,_.sortedIndex),_.lastIndexOf=createIndexFinder(-1,_.findLastIndex),_.range=function(start,stop,step){null==stop&&(stop=start||0,start=0),step=step||1;for(var length=Math.max(Math.ceil((stop-start)/step),0),range=Array(length),idx=0;idx<length;idx++,start+=step)range[idx]=start;return range};var executeBound=function(sourceFunc,boundFunc,context,callingContext,args){if(!(callingContext instanceof boundFunc))return sourceFunc.apply(context,args);var self=baseCreate(sourceFunc.prototype),result=sourceFunc.apply(self,args);return _.isObject(result)?result:self};_.bind=function(func,context){if(nativeBind&&func.bind===nativeBind)return nativeBind.apply(func,slice.call(arguments,1));if(!_.isFunction(func))throw new TypeError("Bind must be called on a function");var args=slice.call(arguments,2),bound=function(){return executeBound(func,bound,context,this,args.concat(slice.call(arguments)))};return bound},_.partial=function(func){var boundArgs=slice.call(arguments,1),bound=function(){for(var position=0,length=boundArgs.length,args=Array(length),i=0;i<length;i++)args[i]=boundArgs[i]===_?arguments[position++]:boundArgs[i];for(;position<arguments.length;)args.push(arguments[position++]);return executeBound(func,bound,this,this,args)};return bound},_.bindAll=function(obj){var i,key,length=arguments.length;if(length<=1)throw new Error("bindAll must be passed function names");
for(i=1;i<length;i++)key=arguments[i],obj[key]=_.bind(obj[key],obj);return obj},_.memoize=function(func,hasher){var memoize=function(key){var cache=memoize.cache,address=""+(hasher?hasher.apply(this,arguments):key);return _.has(cache,address)||(cache[address]=func.apply(this,arguments)),cache[address]};return memoize.cache={},memoize},_.delay=function(func,wait){var args=slice.call(arguments,2);return setTimeout(function(){return func.apply(null,args)},wait)},_.defer=_.partial(_.delay,_,1),_.throttle=function(func,wait,options){var context,args,result,timeout=null,previous=0;options||(options={});var later=function(){previous=options.leading===!1?0:_.now(),timeout=null,result=func.apply(context,args),timeout||(context=args=null)};return function(){var now=_.now();previous||options.leading!==!1||(previous=now);var remaining=wait-(now-previous);return context=this,args=arguments,remaining<=0||remaining>wait?(timeout&&(clearTimeout(timeout),timeout=null),previous=now,result=func.apply(context,args),timeout||(context=args=null)):timeout||options.trailing===!1||(timeout=setTimeout(later,remaining)),result}},_.debounce=function(func,wait,immediate){var timeout,args,context,timestamp,result,later=function(){var last=_.now()-timestamp;last<wait&&last>=0?timeout=setTimeout(later,wait-last):(timeout=null,immediate||(result=func.apply(context,args),timeout||(context=args=null)))};return function(){context=this,args=arguments,timestamp=_.now();var callNow=immediate&&!timeout;return timeout||(timeout=setTimeout(later,wait)),callNow&&(result=func.apply(context,args),context=args=null),result}},_.wrap=function(func,wrapper){return _.partial(wrapper,func)},_.negate=function(predicate){return function(){return!predicate.apply(this,arguments)}},_.compose=function(){var args=arguments,start=args.length-1;return function(){for(var i=start,result=args[start].apply(this,arguments);i--;)result=args[i].call(this,result);return result}},_.after=function(times,func){return function(){if(--times<1)return func.apply(this,arguments)}},_.before=function(times,func){var memo;return function(){return--times>0&&(memo=func.apply(this,arguments)),times<=1&&(func=null),memo}},_.once=_.partial(_.before,2);var hasEnumBug=!{toString:null}.propertyIsEnumerable("toString"),nonEnumerableProps=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"];_.keys=function(obj){if(!_.isObject(obj))return[];if(nativeKeys)return nativeKeys(obj);var keys=[];for(var key in obj)_.has(obj,key)&&keys.push(key);return hasEnumBug&&collectNonEnumProps(obj,keys),keys},_.allKeys=function(obj){if(!_.isObject(obj))return[];var keys=[];for(var key in obj)keys.push(key);return hasEnumBug&&collectNonEnumProps(obj,keys),keys},_.values=function(obj){for(var keys=_.keys(obj),length=keys.length,values=Array(length),i=0;i<length;i++)values[i]=obj[keys[i]];return values},_.mapObject=function(obj,iteratee,context){iteratee=cb(iteratee,context);for(var currentKey,keys=_.keys(obj),length=keys.length,results={},index=0;index<length;index++)currentKey=keys[index],results[currentKey]=iteratee(obj[currentKey],currentKey,obj);return results},_.pairs=function(obj){for(var keys=_.keys(obj),length=keys.length,pairs=Array(length),i=0;i<length;i++)pairs[i]=[keys[i],obj[keys[i]]];return pairs},_.invert=function(obj){for(var result={},keys=_.keys(obj),i=0,length=keys.length;i<length;i++)result[obj[keys[i]]]=keys[i];return result},_.functions=_.methods=function(obj){var names=[];for(var key in obj)_.isFunction(obj[key])&&names.push(key);return names.sort()},_.extend=createAssigner(_.allKeys),_.extendOwn=_.assign=createAssigner(_.keys),_.findKey=function(obj,predicate,context){predicate=cb(predicate,context);for(var key,keys=_.keys(obj),i=0,length=keys.length;i<length;i++)if(key=keys[i],predicate(obj[key],key,obj))return key},_.pick=function(object,oiteratee,context){var iteratee,keys,result={},obj=object;if(null==obj)return result;_.isFunction(oiteratee)?(keys=_.allKeys(obj),iteratee=optimizeCb(oiteratee,context)):(keys=flatten(arguments,!1,!1,1),iteratee=function(value,key,obj){return key in obj},obj=Object(obj));for(var i=0,length=keys.length;i<length;i++){var key=keys[i],value=obj[key];iteratee(value,key,obj)&&(result[key]=value)}return result},_.omit=function(obj,iteratee,context){if(_.isFunction(iteratee))iteratee=_.negate(iteratee);else{var keys=_.map(flatten(arguments,!1,!1,1),String);iteratee=function(value,key){return!_.contains(keys,key)}}return _.pick(obj,iteratee,context)},_.defaults=createAssigner(_.allKeys,!0),_.create=function(prototype,props){var result=baseCreate(prototype);return props&&_.extendOwn(result,props),result},_.clone=function(obj){return _.isObject(obj)?_.isArray(obj)?obj.slice():_.extend({},obj):obj},_.tap=function(obj,interceptor){return interceptor(obj),obj},_.isMatch=function(object,attrs){var keys=_.keys(attrs),length=keys.length;if(null==object)return!length;for(var obj=Object(object),i=0;i<length;i++){var key=keys[i];if(attrs[key]!==obj[key]||!(key in obj))return!1}return!0};var eq=function(a,b,aStack,bStack){if(a===b)return 0!==a||1/a===1/b;if(null==a||null==b)return a===b;a instanceof _&&(a=a._wrapped),b instanceof _&&(b=b._wrapped);var className=toString.call(a);if(className!==toString.call(b))return!1;switch(className){case"[object RegExp]":case"[object String]":return""+a==""+b;case"[object Number]":return+a!==+a?+b!==+b:0===+a?1/+a===1/b:+a===+b;case"[object Date]":case"[object Boolean]":return+a===+b}var areArrays="[object Array]"===className;if(!areArrays){if("object"!=typeof a||"object"!=typeof b)return!1;var aCtor=a.constructor,bCtor=b.constructor;if(aCtor!==bCtor&&!(_.isFunction(aCtor)&&aCtor instanceof aCtor&&_.isFunction(bCtor)&&bCtor instanceof bCtor)&&"constructor"in a&&"constructor"in b)return!1}aStack=aStack||[],bStack=bStack||[];for(var length=aStack.length;length--;)if(aStack[length]===a)return bStack[length]===b;if(aStack.push(a),bStack.push(b),areArrays){if(length=a.length,length!==b.length)return!1;for(;length--;)if(!eq(a[length],b[length],aStack,bStack))return!1}else{var key,keys=_.keys(a);if(length=keys.length,_.keys(b).length!==length)return!1;for(;length--;)if(key=keys[length],!_.has(b,key)||!eq(a[key],b[key],aStack,bStack))return!1}return aStack.pop(),bStack.pop(),!0};_.isEqual=function(a,b){return eq(a,b)},_.isEmpty=function(obj){return null==obj||(isArrayLike(obj)&&(_.isArray(obj)||_.isString(obj)||_.isArguments(obj))?0===obj.length:0===_.keys(obj).length)},_.isElement=function(obj){return!(!obj||1!==obj.nodeType)},_.isArray=nativeIsArray||function(obj){return"[object Array]"===toString.call(obj)},_.isObject=function(obj){var type=typeof obj;return"function"===type||"object"===type&&!!obj},_.each(["Arguments","Function","String","Number","Date","RegExp","Error"],function(name){_["is"+name]=function(obj){return toString.call(obj)==="[object "+name+"]"}}),_.isArguments(arguments)||(_.isArguments=function(obj){return _.has(obj,"callee")}),"function"!=typeof/./&&"object"!=typeof Int8Array&&(_.isFunction=function(obj){return"function"==typeof obj||!1}),_.isFinite=function(obj){return isFinite(obj)&&!isNaN(parseFloat(obj))},_.isNaN=function(obj){return _.isNumber(obj)&&obj!==+obj},_.isBoolean=function(obj){return obj===!0||obj===!1||"[object Boolean]"===toString.call(obj)},_.isNull=function(obj){return null===obj},_.isUndefined=function(obj){return void 0===obj},_.has=function(obj,key){return null!=obj&&hasOwnProperty.call(obj,key)},_.noConflict=function(){return root._=previousUnderscore,this},_.identity=function(value){return value},_.constant=function(value){return function(){return value}},_.noop=function(){},_.property=property,_.propertyOf=function(obj){return null==obj?function(){}:function(key){return obj[key]}},_.matcher=_.matches=function(attrs){return attrs=_.extendOwn({},attrs),function(obj){return _.isMatch(obj,attrs)}},_.times=function(n,iteratee,context){var accum=Array(Math.max(0,n));iteratee=optimizeCb(iteratee,context,1);for(var i=0;i<n;i++)accum[i]=iteratee(i);return accum},_.random=function(min,max){return null==max&&(max=min,min=0),min+Math.floor(Math.random()*(max-min+1))},_.now=Date.now||function(){return(new Date).getTime()};var escapeMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},unescapeMap=_.invert(escapeMap),createEscaper=function(map){var escaper=function(match){return map[match]},source="(?:"+_.keys(map).join("|")+")",testRegexp=RegExp(source),replaceRegexp=RegExp(source,"g");return function(string){return string=null==string?"":""+string,testRegexp.test(string)?string.replace(replaceRegexp,escaper):string}};_.escape=createEscaper(escapeMap),_.unescape=createEscaper(unescapeMap),_.result=function(object,property,fallback){var value=null==object?void 0:object[property];return void 0===value&&(value=fallback),_.isFunction(value)?value.call(object):value};var idCounter=0;_.uniqueId=function(prefix){var id=++idCounter+"";return prefix?prefix+id:id},_.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var noMatch=/(.)^/,escapes={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},escaper=/\\|'|\r|\n|\u2028|\u2029/g,escapeChar=function(match){return"\\"+escapes[match]};_.template=function(text,settings,oldSettings){!settings&&oldSettings&&(settings=oldSettings),settings=_.defaults({},settings,_.templateSettings);var matcher=RegExp([(settings.escape||noMatch).source,(settings.interpolate||noMatch).source,(settings.evaluate||noMatch).source].join("|")+"|$","g"),index=0,source="__p+='";text.replace(matcher,function(match,escape,interpolate,evaluate,offset){return source+=text.slice(index,offset).replace(escaper,escapeChar),index=offset+match.length,escape?source+="'+\n((__t=("+escape+"))==null?'':_.escape(__t))+\n'":interpolate?source+="'+\n((__t=("+interpolate+"))==null?'':__t)+\n'":evaluate&&(source+="';\n"+evaluate+"\n__p+='"),match}),source+="';\n",settings.variable||(source="with(obj||{}){\n"+source+"}\n"),source="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+source+"return __p;\n";try{var render=new Function(settings.variable||"obj","_",source)}catch(e){throw e.source=source,e}var template=function(data){return render.call(this,data,_)},argument=settings.variable||"obj";return template.source="function("+argument+"){\n"+source+"}",template},_.chain=function(obj){var instance=_(obj);return instance._chain=!0,instance};var result=function(instance,obj){return instance._chain?_(obj).chain():obj};_.mixin=function(obj){_.each(_.functions(obj),function(name){var func=_[name]=obj[name];_.prototype[name]=function(){var args=[this._wrapped];return push.apply(args,arguments),result(this,func.apply(_,args))}})},_.mixin(_),_.each(["pop","push","reverse","shift","sort","splice","unshift"],function(name){var method=ArrayProto[name];_.prototype[name]=function(){var obj=this._wrapped;return method.apply(obj,arguments),"shift"!==name&&"splice"!==name||0!==obj.length||delete obj[0],result(this,obj)}}),_.each(["concat","join","slice"],function(name){var method=ArrayProto[name];_.prototype[name]=function(){return result(this,method.apply(this._wrapped,arguments))}}),_.prototype.value=function(){return this._wrapped},_.prototype.valueOf=_.prototype.toJSON=_.prototype.value,_.prototype.toString=function(){return""+this._wrapped},__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return _}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),!(void 0!==__WEBPACK_AMD_DEFINE_RESULT__&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}).call(this)},function(module,exports,__webpack_require__){module.exports=[{classes:[{name:"GlobalSchema",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[{typeName:"Referencable",nameSpace:"",basicName:"Referencable",typeKind:0,typeArguments:[{typeName:"Sys.SchemaString",nameSpace:"Sys",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],fields:[{name:"key",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.key",arguments:[]},{name:"MetaModel.description",arguments:["Name of the global schema, used to refer on schema content"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"Sys.SchemaString",nameSpace:"Sys",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["Content of the schema"]},{name:"MetaModel.value",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.actuallyExports",arguments:["value"]},{name:"MetaModel.description",arguments:["Content of the schema"]}],extends:[{typeName:"RAMLSimpleElement",nameSpace:"",basicName:"RAMLSimpleElement",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],moduleName:"RAMLSpec",annotationOverridings:{}},{name:"Api",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.required",arguments:[]},{name:"MetaModel.description",arguments:["The title property is a short plain text description of the RESTful API. The value SHOULD be suitable for use as a title for the contained user documentation."]}],valueConstraint:null,optional:!1},{name:"version",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["If the RAML API definition is targeted to a specific API version, the API definition MUST contain a version property. The version property is OPTIONAL and should not be used if: The API itself is not versioned. The API definition does not change between versions. The API architect can decide whether a change to user documentation elements, but no change to the API's resources, constitutes a version change. The API architect MAY use any versioning scheme so long as version numbers retain the same format. For example, 'v3', 'v3.0', and 'V3' are all allowed, but are not considered to be equal."]}],valueConstraint:null,optional:!1},{name:"baseUri",type:{typeName:"Sys.FullUriTemplateString",nameSpace:"Sys",basicName:"FullUriTemplateString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["(Optional during development; Required after implementation) A RESTful API's resources are defined relative to the API's base URI. The use of the baseUri field is OPTIONAL to allow describing APIs that have not yet been implemented. After the API is implemented (even a mock implementation) and can be accessed at a service endpoint, the API definition MUST contain a baseUri property. The baseUri property's value MUST conform to the URI specification RFC2396 or a Level 1 Template URI as defined in RFC6570. The baseUri property SHOULD only be used as a reference value."]}],valueConstraint:null,optional:!1},{name:"baseUriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["Base uri parameters are named parameters which described template parameters in the base uri"]}],valueConstraint:null,optional:!1},{name:"uriParameters",type:{base:{typeName:"Params.Parameter",nameSpace:"Params",basicName:"Parameter",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.setsContextValue",arguments:["location","Params.ParameterLocation.BURI"]},{name:"MetaModel.description",arguments:["URI parameters can be further defined by using the uriParameters property. The use of uriParameters is OPTIONAL. The uriParameters property MUST be a map in which each key MUST be the name of the URI parameter as defined in the baseUri property. The uriParameters CANNOT contain a key named version because it is a reserved URI parameter name. The value of the uriParameters property is itself a map that specifies  the property's attributes as named parameters"]}],valueConstraint:null,optional:!1},{name:"protocols",type:{base:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},typeKind:1},annotations:[{name:"MetaModel.oneOf",arguments:[["HTTP","HTTPS"]]},{name:"MetaModel.description",arguments:["A RESTful API can be reached HTTP, HTTPS, or both. The protocols property MAY be used to specify the protocols that an API supports. If the protocols property is not specified, the protocol specified at the baseUri property is used. The protocols property MUST be an array of strings, of values `HTTP` and/or `HTTPS`."]}],valueConstraint:null,optional:!1},{name:"mediaType",type:{typeName:"Bodies.MimeType",nameSpace:"Bodies",basicName:"MimeType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.oftenKeys",arguments:[["application/json","application/xml","application/x-www-form-urlencoded","multipart/formdata"]]},{name:"MetaModel.description",arguments:["(Optional) The media types returned by API responses, and expected from API requests that accept a body, MAY be defaulted by specifying the mediaType property. This property is specified at the root level of the API definition. The property's value MAY be a single string with a valid media type described in the specification."]},{name:"MetaModel.inherited",arguments:[]}],valueConstraint:null,optional:!1},{name:"schemas",type:{base:{typeName:"GlobalSchema",nameSpace:"",basicName:"GlobalSchema",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["To better achieve consistency and simplicity, the API definition SHOULD include an OPTIONAL schemas property in the root section. The schemas property specifies collections of schemas that could be used anywhere in the API definition. The value of the schemas property is an array of maps; in each map, the keys are the schema name, and the values are schema definitions. The schema definitions MAY be included inline or by using the RAML !include user-defined data type."]}],valueConstraint:null,optional:!1},{name:"traits",type:{base:{typeName:"Methods.Trait",nameSpace:"Methods",basicName:"Trait",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declarations of traits used in this API"]}],valueConstraint:null,optional:!1},{name:"securedBy",type:{base:{typeName:"Security.SecuritySchemeRef",nameSpace:"Security",basicName:"SecuritySchemeRef",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.allowNull",arguments:[]},{name:"MetaModel.description",arguments:["A list of the security schemes to apply to all methods, these must be defined in the securitySchemes declaration."]}],valueConstraint:null,optional:!1},{name:"securitySchemes",type:{base:{typeName:"Security.AbstractSecurityScheme",nameSpace:"Security",basicName:"AbstractSecurityScheme",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Security schemes that can be applied using securedBy"]}],valueConstraint:null,optional:!1},{name:"resourceTypes",type:{base:{typeName:"Resources.ResourceType",nameSpace:"Resources",basicName:"ResourceType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.embeddedInMaps",arguments:[]},{name:"MetaModel.description",arguments:["Declaration of resource types used in this API"]}],valueConstraint:null,optional:!1},{name:"resources",type:{base:{typeName:"Resources.Resource",nameSpace:"Resources",basicName:"Resource",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.newInstanceName",arguments:["New Resource"]},{name:"MetaModel.description",arguments:["Resources are identified by their relative URI, which MUST begin with a slash (/). A resource defined as a root-level property is called a top-level resource. Its property's key is the resource's URI relative to the baseUri. A resource defined as a child property of another resource is called a nested resource, and its property's key is its URI relative to its parent resource's URI. Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property. The key of a resource, i.e. its relative URI, MAY consist of multiple URI path fragments separated by slashes; e.g. `/bom/items` may indicate the collection of items in a bill of materials as a single resource. However, if the individual URI path fragments are themselves resources, the API definition SHOULD use nested resources to describe this structure; e.g. if `/bom` is itself a resource then `/items` should be a nested resource of `/bom`, while `/bom/items` should not be used."]}],valueConstraint:null,optional:!1},{name:"documentation",type:{base:{typeName:"DocumentationItem",nameSpace:"",basicName:"DocumentationItem",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["The API definition can include a variety of documents that serve as a user guides and reference documentation for the API. Such documents can clarify how the API works or provide business context. Documentation-generators MUST include all the sections in an API definition's documentation property in the documentation output, and they MUST preserve the order in which the documentation is declared. To add user documentation to the API, include the documentation property at the root of the API definition. The documentation property MUST be an array of documents. Each document MUST contain title and content attributes, both of which are REQUIRED. If the documentation property is specified, it MUST include at least one document. Documentation-generators MUST process the content field as if it was defined using Markdown."]}],valueConstraint:null,optional:!1},{name:"RAMLVersion",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns AST node of security scheme, this reference refers to, or null."]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],extends:[],moduleName:"RAMLSpec",annotationOverridings:{}},{name:"DocumentationItem",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[{name:"title",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["title of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1},{name:"content",type:{typeName:"Sys.MarkdownString",nameSpace:"Sys",basicName:"MarkdownString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},annotations:[{name:"MetaModel.description",arguments:["Content of documentation section"]},{name:"MetaModel.required",arguments:[]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],extends:[{typeName:"RAMLSimpleElement",nameSpace:"",basicName:"RAMLSimpleElement",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"}],moduleName:"RAMLSpec",annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Sys:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts",Params:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/parameters.ts",Common:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/common.ts",Bodies:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/bodies.ts",Resources:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/resources.ts",Methods:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/methods.ts",Security:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/security.ts"},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/api.ts"},{classes:[{name:"SpecPartMetaData",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!0,annotations:[],extends:[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{},name:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts"},{classes:[{name:"ValueType",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[],extends:[],moduleName:null,annotationOverridings:{}},{name:"StringType",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["string"]}],extends:[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"AnyType",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["any"]}],extends:[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"NumberType",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["number"]}],extends:[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"BooleanType",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.nameAtRuntime",arguments:["boolean"]}],extends:[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"Referencable",methods:[],typeParameters:["T"],typeParameterConstraint:[null],implements:[],fields:[],isInterface:!0,annotations:[],extends:[],moduleName:null,annotationOverridings:{}},{name:"Reference",methods:[],typeParameters:["T"],typeParameterConstraint:[null],implements:[],fields:[{name:"structuredValue",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns a structured object if the reference point to one."]}],valueConstraint:null,optional:!1},{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.customHandling",arguments:[]},{name:"MetaModel.description",arguments:["Returns name of referenced object"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[],extends:[{typeName:"ValueType",nameSpace:"",basicName:"ValueType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"DeclaresDynamicType",methods:[],typeParameters:["T"],typeParameterConstraint:[null],implements:[],fields:[],isInterface:!0,annotations:[],extends:[{typeName:"Referencable",nameSpace:"",basicName:"Referencable",typeKind:0,typeArguments:[{typeName:"T",nameSpace:"",basicName:"T",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"UriTemplate",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This type currently serves both for absolute and relative urls"]}],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"RelativeUriString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes relative uri templates"]}],extends:[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FullUriTemplateString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["This  type describes absolute uri templates"]}],extends:[{typeName:"UriTemplate",nameSpace:"",basicName:"UriTemplate",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"FixedUri",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{
name:"MetaModel.description",arguments:["This  type describes fixed uris"]}],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"MarkdownString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.innerType",arguments:["markdown"]},{name:"MetaModel.description",arguments:["Mardown string is a string which can contain markdown as an extension this markdown should support links with RAML Pointers since 1.0"]}],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"SchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.description",arguments:["Schema at this moment only two subtypes are supported (json schema and xsd)"]}],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"JSonSchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType&&this.mediaType.isJSON()"]},{name:"MetaModel.description",arguments:["JSON schema"]}],extends:[{typeName:"SchemaString",nameSpace:"",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"XMLSchemaString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.innerType",arguments:["xml"]},{name:"MetaModel.description",arguments:["XSD schema"]}],extends:[{typeName:"SchemaString",nameSpace:"",basicName:"SchemaString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"ExampleString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"StatusCodeString",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[],extends:[{typeName:"StringType",nameSpace:"",basicName:"StringType",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"JSONExample",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType.isJSON()"]}],extends:[{typeName:"ExampleString",nameSpace:"",basicName:"ExampleString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"XMLExample",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[],isInterface:!1,annotations:[{name:"MetaModel.functionalDescriminator",arguments:["this.mediaType.isXML()"]}],extends:[{typeName:"ExampleString",nameSpace:"",basicName:"ExampleString",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"}],moduleName:null,annotationOverridings:{}},{name:"TypeInstance",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[{name:"properties",type:{base:{typeName:"TypeInstanceProperty",nameSpace:"",basicName:"TypeInstanceProperty",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Array of instance properties"]}],valueConstraint:null,optional:!1},{name:"isScalar",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Whether the type is scalar"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"any",nameSpace:"",basicName:"any",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["For instances of scalar types returns scalar value"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.customHandling",arguments:[]}],extends:[],moduleName:null,annotationOverridings:{}},{name:"TypeInstanceProperty",methods:[],typeParameters:[],typeParameterConstraint:[],implements:[],fields:[{name:"name",type:{typeName:"string",nameSpace:"",basicName:"string",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Property name"]}],valueConstraint:null,optional:!1},{name:"value",type:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},annotations:[{name:"MetaModel.description",arguments:["Property value"]}],valueConstraint:null,optional:!1},{name:"values",type:{base:{typeName:"TypeInstance",nameSpace:"",basicName:"TypeInstance",typeKind:0,typeArguments:[],modulePath:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/spec-0.8/systemTypes.ts"},typeKind:1},annotations:[{name:"MetaModel.description",arguments:["Array of values if property value is array"]}],valueConstraint:null,optional:!1},{name:"isArray",type:{typeName:"boolean",nameSpace:"",basicName:"boolean",typeKind:0,typeArguments:[],modulePath:null},annotations:[{name:"MetaModel.description",arguments:["Whether property has array as value"]}],valueConstraint:null,optional:!1}],isInterface:!1,annotations:[{name:"MetaModel.customHandling",arguments:[]}],extends:[],moduleName:null,annotationOverridings:{}}],aliases:[],enumDeclarations:[],imports:{MetaModel:"/Users/munch/work/repositories_official/raml-definition-system/raml-definition/metamodel.ts",Common:"/Users/munch/work/repositories_official/ra