/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InflectorBase {
    private static List<String[]> singulars = new ArrayList<String[]>();
    private static List<String[]> plurals = new ArrayList<String[]>();
    private static List<String[]> irregulars = new ArrayList<String[]>();
    private static List<String> uncountables = new ArrayList<String>();

    private static void addPlural(String rule, String replacement) {
        plurals.add(0, new String[]{rule, replacement});
    }

    private static void addSingular(String rule, String replacement) {
        singulars.add(0, new String[]{rule, replacement});
    }

    private static void addIrregular(String rule, String replacement) {
        irregulars.add(new String[]{rule, replacement});
    }

    private static String gsub(String word, String rule, String replacement) {
        Pattern pattern = Pattern.compile(rule, 2);
        Matcher matcher = pattern.matcher(word);
        return matcher.find() ? matcher.replaceFirst(replacement) : null;
    }

    public static String pluralize(String word) {
        if (uncountables.contains(word)) {
            return word;
        }
        for (String[] irregular : irregulars) {
            if (!irregular[0].equalsIgnoreCase(word)) continue;
            return irregular[1];
        }
        for (String[] pair : plurals) {
            String plural = InflectorBase.gsub(word, pair[0], pair[1]);
            if (plural == null) continue;
            return plural;
        }
        return word;
    }

    public static String singularize(String word) {
        if (uncountables.contains(word)) {
            return word;
        }
        for (String[] irregular : irregulars) {
            if (!irregular[1].equalsIgnoreCase(word)) continue;
            return irregular[0];
        }
        for (String[] pair : singulars) {
            String singular = InflectorBase.gsub(word, pair[0], pair[1]);
            if (singular == null) continue;
            return singular;
        }
        return word;
    }

    private static String tableize(String camelCase) {
        return InflectorBase.pluralize(InflectorBase.underscore(camelCase));
    }

    private static String underscore(String camel) {
        ArrayList<Integer> upper = new ArrayList<Integer>();
        byte[] bytes = camel.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b >= 97 && b <= 122) continue;
            upper.add(i);
        }
        StringBuffer b = new StringBuffer(camel);
        for (int i = upper.size() - 1; i >= 0; --i) {
            Integer index = (Integer)upper.get(i);
            if (index == 0) continue;
            b.insert((int)index, "_");
        }
        return b.toString().toLowerCase();
    }

    public static String camelize(String dash) {
        return InflectorBase.camelize(dash, true);
    }

    private static String camelize(String dash, boolean capitalizeFirstChar) {
        StringBuilder result = new StringBuilder("");
        StringTokenizer st = new StringTokenizer(dash, "-");
        while (st.hasMoreTokens()) {
            result.append(InflectorBase.capitalize(st.nextToken()));
        }
        return capitalizeFirstChar ? result.toString() : result.substring(0, 1).toLowerCase() + result.substring(1);
    }

    public static String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    private static String shortName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String getIdName(String tableName) {
        String idName = InflectorBase.singularize(tableName) + "_id";
        return idName.toLowerCase();
    }

    private static String getOtherName(String source, String target) {
        if (!target.contains(source) || target.equals(source)) {
            return null;
        }
        int start = target.indexOf(source);
        String other = start == 0 ? target.substring(source.length()) : target.substring(0, start);
        if (other.startsWith("_")) {
            other = other.replaceFirst("_", " ");
        }
        if (other.endsWith("_")) {
            byte[] otherb = other.getBytes();
            otherb[otherb.length - 1] = 32;
            other = new String(otherb);
        }
        return other.trim();
    }

    static {
        InflectorBase.addPlural("$", "s");
        InflectorBase.addPlural("s$", "s");
        InflectorBase.addPlural("(ax|test)is$", "$1es");
        InflectorBase.addPlural("(octop|vir)us$", "$1i");
        InflectorBase.addPlural("(alias|status)$", "$1es");
        InflectorBase.addPlural("(bu)s$", "$1ses");
        InflectorBase.addPlural("(buffal|tomat)o$", "$1oes");
        InflectorBase.addPlural("([ti])um$", "$1a");
        InflectorBase.addPlural("sis$", "ses");
        InflectorBase.addPlural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        InflectorBase.addPlural("(hive)$", "$1s");
        InflectorBase.addPlural("([^aeiouy]|qu)y$", "$1ies");
        InflectorBase.addPlural("(x|ch|ss|sh)$", "$1es");
        InflectorBase.addPlural("(matr|vert|ind)(?:ix|ex)$", "$1ices");
        InflectorBase.addPlural("([m|l])ouse$", "$1ice");
        InflectorBase.addPlural("^(ox)$", "$1en");
        InflectorBase.addPlural("(quiz)$", "$1zes");
        InflectorBase.addSingular("s$", "");
        InflectorBase.addSingular("(n)ews$", "$1ews");
        InflectorBase.addSingular("([ti])a$", "$1um");
        InflectorBase.addSingular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1sis");
        InflectorBase.addSingular("(^analy)ses$", "$1sis");
        InflectorBase.addSingular("([^f])ves$", "$1fe");
        InflectorBase.addSingular("(hive)s$", "$1");
        InflectorBase.addSingular("(tive)s$", "$1");
        InflectorBase.addSingular("([lr])ves$", "$1f");
        InflectorBase.addSingular("([^aeiouy]|qu)ies$", "$1y");
        InflectorBase.addSingular("(s)eries$", "$1eries");
        InflectorBase.addSingular("(m)ovies$", "$1ovie");
        InflectorBase.addSingular("(x|ch|ss|sh)es$", "$1");
        InflectorBase.addSingular("([m|l])ice$", "$1ouse");
        InflectorBase.addSingular("(bus)es$", "$1");
        InflectorBase.addSingular("(o)es$", "$1");
        InflectorBase.addSingular("(shoe)s$", "$1");
        InflectorBase.addSingular("(cris|ax|test)es$", "$1is");
        InflectorBase.addSingular("(octop|vir)i$", "$1us");
        InflectorBase.addSingular("(alias|status)es$", "$1");
        InflectorBase.addSingular("^(ox)en", "$1");
        InflectorBase.addSingular("(vert|ind)ices$", "$1ex");
        InflectorBase.addSingular("(matr)ices$", "$1ix");
        InflectorBase.addSingular("(quiz)zes$", "$1");
        InflectorBase.addSingular("(database)s$", "$1");
        InflectorBase.addIrregular("person", "people");
        InflectorBase.addIrregular("man", "men");
        InflectorBase.addIrregular("child", "children");
        InflectorBase.addIrregular("sex", "sexes");
        InflectorBase.addIrregular("move", "moves");
        InflectorBase.addIrregular("foot", "feet");
        InflectorBase.addIrregular("tooth", "teeth");
        uncountables = Arrays.asList("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }
}

