/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.injector;

import org.raml.model.Action;
import org.raml.model.Raml;
import org.raml.parser.visitor.RamlDocumentBuilder;

public abstract class InjectableRamlFeature {
    protected String name;
    private String yaml;

    protected InjectableRamlFeature(String name, String yaml) {
        if (name == null || yaml == null) {
            throw new IllegalArgumentException("neither name nor yaml can be null");
        }
        this.name = name;
        this.yaml = yaml;
    }

    protected Raml parse() {
        String[] split;
        StringBuilder wholeYaml = new StringBuilder(this.getBoilerPlateBefore());
        for (String s : split = this.yaml.split("[\r\n]+")) {
            wholeYaml.append(this.getIndentation()).append(s).append("\n");
        }
        wholeYaml.append(this.getBoilerPlateAfter());
        return (Raml)new RamlDocumentBuilder().build(wholeYaml.toString(), "");
    }

    public abstract void applyToAction(Action var1);

    protected abstract String getBoilerPlateBefore();

    protected abstract String getBoilerPlateAfter();

    protected abstract String getIndentation();
}

