/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.modules.cors.CorsFilter;
import org.mule.modules.cors.model.CorsConfig;
import org.mule.modules.cors.model.Origin;

public class MuleCorsFilter
implements CorsFilter {
    public static final String SEPARATOR = ", ";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final CorsConfig config;
    private final boolean publicResource;
    private final boolean acceptsCredentials;

    public MuleCorsFilter(CorsConfig config, boolean publicResource, boolean acceptsCredentials) {
        this.config = config;
        this.publicResource = publicResource;
        this.acceptsCredentials = acceptsCredentials;
    }

    @Override
    public MuleEvent filter(MuleEvent event) {
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        if (StringUtils.isEmpty((String)origin)) {
            this.logger.debug((Object)"Request is not a CORS request.");
            return event;
        }
        String method = (String)event.getMessage().getInboundProperty("http.method");
        if (this.shouldInvokeFlow(origin, method, this.publicResource)) {
            return event;
        }
        event.getMessage().setPayload(null);
        event.getMessage().setInvocationProperty("MULE___corsStopProcessing", (Object)true);
        return event;
    }

    @Override
    public void addHeaders(MuleEvent event) {
        String origin = (String)event.getMessage().getInboundProperty("Origin");
        String method = (String)event.getMessage().getInboundProperty("http.method");
        String requestMethod = (String)event.getMessage().getInboundProperty("Access-Control-Request-Method");
        String requestHeaders = (String)event.getMessage().getInboundProperty("Access-Control-Request-Headers");
        this.addHeaders(event, origin, method, requestMethod, requestHeaders);
    }

    @Override
    public void addHeaders(MuleEvent event, String origin, String method, String requestMethod, String requestHeaders) {
        MuleMessage message = event.getMessage();
        if (StringUtils.isEmpty((String)origin)) {
            return;
        }
        boolean isPreflight = StringUtils.equals((String)"OPTIONS", (String)method);
        if (this.publicResource) {
            this.handlePublicResource(message, isPreflight, requestMethod, requestHeaders);
        }
        Origin configuredOrigin = null;
        if (this.config != null) {
            configuredOrigin = this.config.findOrigin(origin);
        }
        if (configuredOrigin == null) {
            return;
        }
        if (isPreflight) {
            this.handlePreflightRequest(event.getMessage(), configuredOrigin, requestMethod, requestHeaders);
        } else {
            this.handleActualRequest(event.getMessage(), configuredOrigin, method);
        }
    }

    private void handlePublicResource(MuleMessage message, boolean isPreflight, String requestMethod, String requestHeaders) {
        message.setOutboundProperty("Access-Control-Allow-Origin", (Object)"*");
        if (isPreflight) {
            if (requestMethod != null) {
                message.setOutboundProperty("Access-Control-Allow-Methods", (Object)requestMethod);
            }
            if (requestHeaders != null) {
                message.setOutboundProperty("Access-Control-Allow-Headers", (Object)requestHeaders);
            }
        }
    }

    private void handlePreflightRequest(MuleMessage message, Origin origin, String method, String requestHeaders) {
        if (!this.isSupportedMethod(origin, method) || !this.isSupportedRequestHeaders(origin, requestHeaders)) {
            return;
        }
        message.setOutboundProperty("Access-Control-Allow-Origin", (Object)origin.getUrl());
        this.setAllowCredentials(message);
        if (!origin.getMethods().isEmpty()) {
            message.setOutboundProperty("Access-Control-Allow-Methods", (Object)StringUtils.join(origin.getMethods(), (String)SEPARATOR));
        }
        if (!origin.getHeaders().isEmpty()) {
            message.setOutboundProperty("Access-Control-Allow-Headers", (Object)StringUtils.join(origin.getHeaders(), (String)SEPARATOR));
        }
        if (!origin.getExposeHeaders().isEmpty()) {
            message.setOutboundProperty("Access-Control-Expose-Headers", (Object)StringUtils.join(origin.getExposeHeaders(), (String)SEPARATOR));
        }
        if (origin.getAccessControlMaxAge() != null) {
            message.setOutboundProperty("Access-Control-Max-Age", (Object)origin.getAccessControlMaxAge());
        }
    }

    private void handleActualRequest(MuleMessage message, Origin origin, String method) {
        if (!this.isSupportedMethod(origin, method)) {
            return;
        }
        message.setOutboundProperty("Access-Control-Allow-Origin", (Object)origin.getUrl());
        this.setAllowCredentials(message);
        if (!origin.getExposeHeaders().isEmpty()) {
            message.setOutboundProperty("Access-Control-Expose-Headers", (Object)StringUtils.join(origin.getExposeHeaders(), (String)SEPARATOR));
        }
    }

    private boolean isSupportedMethod(Origin origin, String method) {
        if (!origin.getMethods().contains(method)) {
            this.logger.debug((Object)("Unsupported HTTP method: " + method));
            return false;
        }
        return true;
    }

    private boolean isSupportedRequestHeaders(Origin origin, String requestHeaders) {
        String[] headers;
        List<String> supportedHeaders = origin.getHeaders();
        for (String header : headers = this.parseMultipleHeaderValues(requestHeaders)) {
            if (this.containsCaseInsensitive(header, supportedHeaders)) continue;
            this.logger.debug((Object)("Unsupported HTTP request header: " + header));
            return false;
        }
        return true;
    }

    public boolean containsCaseInsensitive(String header, List<String> supportedHeaders) {
        for (String supportedHeader : supportedHeaders) {
            if (!supportedHeader.equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    private void setAllowCredentials(MuleMessage message) {
        if (this.acceptsCredentials) {
            message.setOutboundProperty("Access-Control-Allow-Credentials", (Object)"true");
        }
    }

    private boolean shouldInvokeFlow(String origin, String method, boolean publicResource) {
        if (StringUtils.equals((String)"OPTIONS", (String)method)) {
            this.logger.debug((Object)"OPTIONS header, will not continue processing.");
            return false;
        }
        if (publicResource) {
            return true;
        }
        Origin configuredOrigin = this.config.findOrigin(origin);
        if (configuredOrigin == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not find configuration for origin: " + origin));
            }
            return false;
        }
        if (!configuredOrigin.getMethods().isEmpty()) {
            return configuredOrigin.getMethods().contains(method);
        }
        this.logger.warn((Object)"Configured origin has no methods. Not allowing the execution of the flow");
        return false;
    }

    private String[] parseMultipleHeaderValues(String headerValue) {
        if (StringUtils.isEmpty((String)headerValue)) {
            return new String[0];
        }
        String trimmedHeaderValue = headerValue.trim();
        if (StringUtils.isEmpty((String)trimmedHeaderValue)) {
            return new String[0];
        }
        return trimmedHeaderValue.split("\\s*,\\s*|\\s+");
    }
}

