/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class TransientAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private static final Annotation XML_TRANSIENT_ANNOTATION = XmlTransientProxyHandler.access$000();
    private static final Annotation[] XML_TRANSIENT_ANNOTATION_ONLY = new Annotation[]{XML_TRANSIENT_ANNOTATION};
    private final RuntimeInlineAnnotationReader delegate = new RuntimeInlineAnnotationReader();
    private final List<Class<?>> transientClasses = new ArrayList();
    private final List<Field> transientFields = new ArrayList<Field>();
    private final List<Method> transientMethods = new ArrayList<Method>();

    public void addTransientClass(Class<?> cls) {
        this.transientClasses.add(cls);
    }

    public void addTransientField(Field field) {
        this.transientFields.add(field);
    }

    public void addTransientMethod(Method method) {
        this.transientMethods.add(method);
    }

    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> annotationType) {
        if (this.transientClasses.contains(clazz)) {
            return true;
        }
        return this.delegate.hasClassAnnotation(clazz, annotationType);
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> annotationType, Class clazz, Locatable srcPos) {
        if (this.transientClasses.contains(clazz)) {
            return (A)XML_TRANSIENT_ANNOTATION;
        }
        return (A)this.delegate.getClassAnnotation(annotationType, clazz, srcPos);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field) {
        if (XmlTransient.class.isAssignableFrom(annotationType) && this.transientFields.contains(field)) {
            return true;
        }
        return this.delegate.hasFieldAnnotation(annotationType, field);
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> annotationType, Field field, Locatable srcPos) {
        if (XmlTransient.class.isAssignableFrom(annotationType) && this.transientFields.contains(field)) {
            return (A)XML_TRANSIENT_ANNOTATION;
        }
        return (A)this.delegate.getFieldAnnotation(annotationType, field, srcPos);
    }

    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        if (this.transientFields.contains(field)) {
            return XML_TRANSIENT_ANNOTATION_ONLY;
        }
        return this.delegate.getAllFieldAnnotations(field, srcPos);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> annotationType, Method method) {
        if (XmlTransient.class.isAssignableFrom(annotationType) && this.transientMethods.contains(method)) {
            return true;
        }
        return this.delegate.hasMethodAnnotation(annotationType, method);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType, Method method, Locatable srcPos) {
        if (XmlTransient.class.isAssignableFrom(annotationType) && this.transientMethods.contains(method)) {
            return (A)XML_TRANSIENT_ANNOTATION;
        }
        return (A)this.delegate.getMethodAnnotation(annotationType, method, srcPos);
    }

    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        if (this.transientMethods.contains(method)) {
            return XML_TRANSIENT_ANNOTATION_ONLY;
        }
        return this.delegate.getAllMethodAnnotations(method, srcPos);
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        return (A)this.delegate.getMethodParameterAnnotation(annotation, method, paramIndex, srcPos);
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        return (A)this.delegate.getPackageAnnotation(a, clazz, srcPos);
    }

    public Class getClassValue(Annotation a, String name) {
        return this.delegate.getClassValue(a, name);
    }

    public Class[] getClassArrayValue(Annotation a, String name) {
        return this.delegate.getClassArrayValue(a, name);
    }

    protected String fullName(Method m) {
        return m.getDeclaringClass().getName() + '#' + m.getName();
    }

    private static class XmlTransientProxyHandler
    implements InvocationHandler {
        private XmlTransientProxyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null || args.length == 0) {
                if (method.getName().equals("annotationType")) {
                    return XmlTransient.class;
                }
                if (method.getName().equals("toString")) {
                    return "@XmlTransient";
                }
            }
            throw new UnsupportedOperationException("@XmlTransient doesn't support method call: " + method.getName());
        }

        private static XmlTransient create() {
            return (XmlTransient)Proxy.newProxyInstance(XmlTransientProxyHandler.class.getClassLoader(), new Class[]{XmlTransient.class}, (InvocationHandler)new XmlTransientProxyHandler());
        }

        static /* synthetic */ XmlTransient access$000() {
            return XmlTransientProxyHandler.create();
        }
    }
}

