/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.loader;

import java.io.InputStream;
import org.raml.parser.loader.ResourceLoader;

public class ClassPathResourceLoader
implements ResourceLoader {
    ClassLoader customClassLoader;

    public ClassPathResourceLoader() {
    }

    public ClassPathResourceLoader(ClassLoader customClassLoader) {
        this.customClassLoader = customClassLoader;
    }

    @Override
    public InputStream fetchResource(String resourceName) {
        InputStream inputStream = null;
        if (this.customClassLoader != null) {
            inputStream = this.customClassLoader.getResourceAsStream(resourceName);
        } else {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            }
        }
        return inputStream;
    }
}

