/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.raml.v2.api.model.v10.declarations.AnnotationTarget;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypesNode;
import org.raml.v2.internal.impl.commons.nodes.CustomFacetDefinitionNode;
import org.raml.v2.internal.impl.commons.nodes.DocumentationItemNode;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.ExamplesNode;
import org.raml.v2.internal.impl.commons.nodes.ExtendsNode;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.nodes.FacetNode;
import org.raml.v2.internal.impl.commons.nodes.ResponseNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypesNode;
import org.raml.v2.internal.impl.commons.rule.NodeReferenceFactory;
import org.raml.v2.internal.impl.commons.rule.SchemaDeclarationRule;
import org.raml.v2.internal.impl.v10.grammar.AuthorizationUriRequiredField;
import org.raml.v2.internal.impl.v10.nodes.DisplayNameDefaultValue;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryNode;
import org.raml.v2.internal.impl.v10.nodes.NativeTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.nodes.factory.DefaultMimeTypeDeclarationFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.InlineTypeDeclarationFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.OverlayableSimpleTypeFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.RamlScalarValueFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.TypeExpressionReferenceFactory;
import org.raml.v2.internal.impl.v10.rules.TypeDefaultValue;
import org.raml.v2.internal.impl.v10.rules.TypeExpressionReferenceRule;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.yagi.framework.grammar.RuleFactory;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.ArrayWrapperFactory;
import org.raml.yagi.framework.grammar.rule.ConditionalRule;
import org.raml.yagi.framework.grammar.rule.DefaultValue;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.grammar.rule.RequiredField;
import org.raml.yagi.framework.grammar.rule.ResourceRefRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNodeImpl;

public class Raml10Grammar
extends BaseRamlGrammar {
    public static final String ANNOTATION_TYPES_KEY_NAME = "annotationTypes";
    public static final String DEFAULT_TYPE_RULE = "defaultTypeRule";
    public static final String PROPERTY_TYPE_RULE = "propertyTypeRule";
    public static final String TYPES_FACET_TYPE = "type";
    public static final String TYPES_FACET_SCHEMA = "schema";
    public static final String MIN_ITEMS_KEY_NAME = "minItems";
    public static final String MAX_ITEMS_KEY_NAME = "maxItems";
    public static final String UNIQUE_ITEMS_KEY_NAME = "uniqueItems";
    public static final String ITEMS_KEY_NAME = "items";
    public static final String FILE_TYPES_KEY_NAME = "fileTypes";
    public static final String MIN_LENGTH_KEY_NAME = "minLength";
    public static final String MAX_LENGTH_KEY_NAME = "maxLength";
    public static final String MINIMUM_KEY_NAME = "minimum";
    public static final String MAXIMUM_KEY_NAME = "maximum";
    public static final String FORMAT_KEY_NAME = "format";
    public static final String ENUM_KEY_NAME = "enum";
    public static final String MULTIPLE_OF_KEY_NAME = "multipleOf";
    public static final String PROPERTIES_KEY_NAME = "properties";
    public static final String MIN_PROPERTIES_KEY_NAME = "minProperties";
    public static final String MAX_PROPERTIES_KEY_NAME = "maxProperties";
    public static final String ADDITIONAL_PROPERTIES_KEY_NAME = "additionalProperties";
    public static final String DISCRIMINATOR_KEY_NAME = "discriminator";
    public static final String DISCRIMINATOR_VALUE_KEY_NAME = "discriminatorValue";
    public static final String PATTERN_KEY_NAME = "pattern";

    @Override
    public ObjectRule untitledRaml() {
        return super.untitledRaml().with(this.annotationTypesField()).with(this.annotationField()).with(this.typesField()).with(this.usesField()).with(this.exclusiveKeys(new String[]{"types", "schemas"}));
    }

    @Override
    protected ObjectRule resourceValue() {
        return (ObjectRule)this.named("resourceValue", (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.baseResourceValue().with(Raml10Grammar.this.methodField()).with(Raml10Grammar.this.resourceField()).with(Raml10Grammar.this.annotationField());
            }
        });
    }

    @Override
    protected ObjectRule methodValue() {
        return super.methodValue().with(this.field((Rule)this.queryStringKey(), this.type())).with(this.exclusiveKeys(new String[]{"queryString", "queryParameters"})).with(this.annotationField());
    }

    @Override
    public ObjectRule securityScheme() {
        return super.securityScheme().with(this.annotationField());
    }

    @Override
    protected ObjectRule securitySchemePart() {
        return super.securitySchemePart().with(this.annotationField()).with(this.field((Rule)this.queryStringKey(), this.type())).with(this.exclusiveKeys(new String[]{"queryString", "queryParameters"}));
    }

    @Override
    protected ObjectRule securitySchemeSettings() {
        return this.objectType().with(this.annotationField()).with(this.when("../../type", new ConditionalRule[]{this.is((Rule)this.string("OAuth 1.0")).add(this.requiredField((Rule)this.string("requestTokenUri"), this.ramlScalarValue())).add(this.requiredField((Rule)this.string("authorizationUri"), this.ramlScalarValue())).add(this.requiredField((Rule)this.string("tokenCredentialsUri"), this.ramlScalarValue())).add(this.field((Rule)this.string("signatures"), (Rule)this.array(this.scalarType()))), this.is((Rule)this.string("OAuth 2.0")).add(this.field((Rule)this.string("authorizationUri"), this.ramlScalarValue()).requiredWhen((RequiredField)new AuthorizationUriRequiredField())).add(this.requiredField((Rule)this.string("accessTokenUri"), this.ramlScalarValue())).add(this.requiredField((Rule)this.string("authorizationGrants"), (Rule)this.anyOf(new Rule[]{this.authorizationGrantsValue(), this.array(this.authorizationGrantsValue())}))).add(this.field((Rule)this.string("scopes"), (Rule)this.anyOf(new Rule[]{this.scalarType(), this.array(this.scalarType())})))}));
    }

    @Override
    protected Rule authorizationGrantsValue() {
        return this.anyOf(new Rule[]{this.string("authorization_code"), this.string("password"), this.string("client_credentials"), this.string("implicit"), this.regex("urn:.*"), this.regex("http://.*"), this.regex("https://.*")});
    }

    @Override
    protected KeyValueRule responseField() {
        return super.responseField().then(ResponseNode.class);
    }

    @Override
    protected ObjectRule response() {
        return super.response().with(this.annotationField());
    }

    protected KeyValueRule typesField() {
        return this.field((Rule)this.typesKey(), this.types()).then(TypesNode.class);
    }

    protected StringValueRule typesKey() {
        return this.string("types").description("Declarations of (data) types for use within this API.");
    }

    protected KeyValueRule annotationField() {
        return this.field(this.annotationKey().then((NodeFactory)new NodeReferenceFactory(AnnotationReferenceNode.class)), (Rule)this.any()).then(AnnotationNode.class);
    }

    protected RegexValueRule annotationKey() {
        return this.regex("\\((.+)\\)").label("(Annotation)").suggest("(<cursor>)").description("Annotations to be applied to this API. Annotations are any property whose key begins with \"(\" and ends with \")\" and whose name (the part between the beginning and ending parentheses) is a declared annotation name..");
    }

    public KeyValueRule usesField() {
        return this.field((Rule)this.usesKey(), (Rule)this.objectType().with(this.field(this.scalarType(), this.libraryRef()).then(LibraryNode.class)));
    }

    public ObjectRule extension() {
        return this.untitledRaml().with(this.requiredField((Rule)this.extendsKey(), this.scalarType()).then(ExtendsNode.class)).with(this.usageField()).with(this.optionalTitleField());
    }

    protected StringValueRule extendsKey() {
        return this.string("extends").description("The path to the base RAML document to be extended.");
    }

    protected KeyValueRule optionalTitleField() {
        return this.field((Rule)this.titleKey(), this.titleValue());
    }

    public Rule libraryRef() {
        return new ResourceRefRule().then(LibraryLinkNode.class);
    }

    public ObjectRule libraryValue() {
        return (ObjectRule)this.named("library", (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.objectType().with(Raml10Grammar.this.typesField()).with(Raml10Grammar.this.schemasField()).with(Raml10Grammar.this.resourceTypesField()).with(Raml10Grammar.this.traitsField()).with(Raml10Grammar.this.securitySchemesField()).with(Raml10Grammar.this.annotationTypesField()).with(Raml10Grammar.this.annotationField()).with(Raml10Grammar.this.usesField()).with(Raml10Grammar.this.usageField());
            }
        });
    }

    protected KeyValueRule annotationTypesField() {
        return this.field((Rule)this.annotationTypesKey(), this.annotationTypes()).then(AnnotationTypesNode.class);
    }

    protected StringValueRule annotationTypesKey() {
        return this.string(ANNOTATION_TYPES_KEY_NAME).description("Declarations of annotation types for use by annotations.");
    }

    protected Rule annotationTypes() {
        return this.objectType().with(this.field(this.scalarType(), this.annotationType()).then(AnnotationTypeNode.class));
    }

    private Rule annotationType() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType().with(this.allowedTargetsField())});
    }

    private KeyValueRule allowedTargetsField() {
        return this.field((Rule)this.string("allowedTargets"), this.anyOf(new Rule[]{this.allowedTargetValues(), this.array(this.allowedTargetValues())}).then((NodeFactory)new ArrayWrapperFactory()));
    }

    private Rule allowedTargetValues() {
        ArrayList<StringValueRule> values = new ArrayList<StringValueRule>();
        for (AnnotationTarget annotationTarget : AnnotationTarget.values()) {
            values.add(this.string(annotationTarget.name()));
        }
        return this.anyOf(values);
    }

    protected Rule types() {
        return this.objectType().with(this.field(this.ramlTypeKey(), this.type()).then(TypeDeclarationField.class));
    }

    protected Rule ramlTypeKey() {
        ArrayList<StringValueRule> types = new ArrayList<StringValueRule>();
        for (TypeId typeId : TypeId.values()) {
            types.add(this.string(typeId.getType()));
        }
        return this.not((Rule)this.anyOf(types));
    }

    @Override
    protected Rule parameter() {
        return this.anyOf(new Rule[]{this.inlineType(), this.propertyType()});
    }

    public Rule type() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType()});
    }

    private AnyOfRule typeRef() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType()});
    }

    protected Rule inlineType() {
        return this.anyOf(new Rule[]{this.typeExpressionReference(), this.array((Rule)this.typeExpressionReference())}).then((NodeFactory)new InlineTypeDeclarationFactory());
    }

    public ObjectRule explicitType() {
        return this.baseType(TypeId.STRING, DEFAULT_TYPE_RULE);
    }

    public ObjectRule annotationTypeDeclaration() {
        return this.explicitType().with(this.allowedTargetsField());
    }

    private ObjectRule baseType(final TypeId defaultType, String ruleName) {
        return (ObjectRule)this.named(ruleName, (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.objectType().with(Raml10Grammar.this.typeField(defaultType)).with(Raml10Grammar.this.xmlFacetField()).with(Raml10Grammar.this.displayNameField()).with(Raml10Grammar.this.descriptionField()).with(Raml10Grammar.this.usageField()).with(Raml10Grammar.this.annotationField()).with(Raml10Grammar.this.defaultField()).with(Raml10Grammar.this.requiredTypeField()).with(Raml10Grammar.this.facetsField()).with(Raml10Grammar.this.exampleField()).with(Raml10Grammar.this.examplesField()).with(Raml10Grammar.this.exclusiveKeys(new String[]{Raml10Grammar.TYPES_FACET_TYPE, Raml10Grammar.TYPES_FACET_SCHEMA})).with(Raml10Grammar.this.when(Arrays.asList(Raml10Grammar.TYPES_FACET_TYPE, Raml10Grammar.TYPES_FACET_SCHEMA), new ConditionalRule[]{Raml10Grammar.this.is((Rule)Raml10Grammar.this.stringTypeLiteral()).add(Raml10Grammar.this.patternField()).add(Raml10Grammar.this.minLengthField()).add(Raml10Grammar.this.maxLengthField()).add(Raml10Grammar.this.enumField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.booleanTypeLiteral()).add(Raml10Grammar.this.enumField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.dateTimeTypeLiteral()).add(Raml10Grammar.this.formatField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.arrayTypeLiteral()).add(Raml10Grammar.this.uniqueItemsField()).add(Raml10Grammar.this.itemsField()).add(Raml10Grammar.this.minItemsField()).add(Raml10Grammar.this.maxItemsField()), Raml10Grammar.this.is(Raml10Grammar.this.integerTypeLiteral()).add(Raml10Grammar.this.minimumField((Rule)Raml10Grammar.this.integerType())).add(Raml10Grammar.this.maximumField((Rule)Raml10Grammar.this.integerType())).add(Raml10Grammar.this.numberFormat()).add(Raml10Grammar.this.enumField()).add(Raml10Grammar.this.multipleOfField((Rule)Raml10Grammar.this.positiveIntegerType(false, Long.MAX_VALUE))), Raml10Grammar.this.is(Raml10Grammar.this.numericTypeLiteral()).add(Raml10Grammar.this.minimumField(Raml10Grammar.this.numberType())).add(Raml10Grammar.this.maximumField(Raml10Grammar.this.numberType())).add(Raml10Grammar.this.numberFormat()).add(Raml10Grammar.this.enumField()).add(Raml10Grammar.this.multipleOfField(Raml10Grammar.this.positiveNumberType())), Raml10Grammar.this.is((Rule)Raml10Grammar.this.fileTypeLiteral()).add(Raml10Grammar.this.fileTypesField()).add(Raml10Grammar.this.minLengthField()).add(Raml10Grammar.this.maxLengthField()), Raml10Grammar.this.is(Raml10Grammar.this.objectTypeLiteral()).add(Raml10Grammar.this.propertiesField()).add(Raml10Grammar.this.minPropertiesField()).add(Raml10Grammar.this.maxPropertiesField()).add(Raml10Grammar.this.additionalPropertiesField()).add(Raml10Grammar.this.discriminatorField()).add(Raml10Grammar.this.discriminatorValueField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.not(Raml10Grammar.this.builtinTypes())).add(Raml10Grammar.this.patternField().matchValue()).add(Raml10Grammar.this.minLengthField().matchValue()).add(Raml10Grammar.this.maxLengthField().matchValue()).add(Raml10Grammar.this.enumField().matchValue()).add(Raml10Grammar.this.formatField().matchValue()).add(Raml10Grammar.this.numberFormat().matchValue()).add(Raml10Grammar.this.uniqueItemsField().matchValue()).add(Raml10Grammar.this.itemsField().matchValue()).add(Raml10Grammar.this.minItemsField().matchValue()).add(Raml10Grammar.this.maxItemsField().matchValue()).add(Raml10Grammar.this.minimumField(Raml10Grammar.this.numberType()).matchValue()).add(Raml10Grammar.this.maximumField(Raml10Grammar.this.numberType()).matchValue()).add(Raml10Grammar.this.multipleOfField(Raml10Grammar.this.positiveNumberType()).matchValue()).add(Raml10Grammar.this.fileTypesField().matchValue()).add(Raml10Grammar.this.propertiesField().matchValue()).add(Raml10Grammar.this.minPropertiesField().matchValue()).add(Raml10Grammar.this.maxPropertiesField().matchValue()).add(Raml10Grammar.this.additionalPropertiesField().matchValue()).add(Raml10Grammar.this.discriminatorField().matchValue()).add(Raml10Grammar.this.discriminatorValueField().matchValue()).add(Raml10Grammar.this.customFacetField().matchValue())}).defaultValue((DefaultValue)new TypeDefaultValue(defaultType))).then(TypeDeclarationNode.class);
            }
        });
    }

    private KeyValueRule customFacetField() {
        return this.field((Rule)this.facetRegex(), (Rule)this.any()).then(FacetNode.class);
    }

    protected Rule builtinTypes() {
        TypeId[] values = TypeId.values();
        ArrayList<StringValueRule> typeNames = new ArrayList<StringValueRule>();
        for (TypeId value : values) {
            typeNames.add(this.string(value.getType()));
        }
        return this.anyOf(typeNames);
    }

    public KeyValueRule discriminatorValueField() {
        return this.field((Rule)this.string(DISCRIMINATOR_VALUE_KEY_NAME), this.scalarType()).then(FacetNode.class).description("Identifies the declaring type. Requires including a discriminator facet in the type declaration. A valid value is an actual value that might identify the type of an individual object and is unique in the hierarchy of the type. Inline type declarations are not supported.");
    }

    public KeyValueRule discriminatorField() {
        return this.field((Rule)this.string(DISCRIMINATOR_KEY_NAME), this.scalarType()).then(FacetNode.class).description("Determines the concrete type of an individual object at runtime when, for example, payloads contain ambiguous types due to unions or inheritance. The value must match the name of one of the declared properties of a type. Unsupported practices are inline type declarations and using discriminator with non-scalar properties.");
    }

    public KeyValueRule additionalPropertiesField() {
        return this.field((Rule)this.string(ADDITIONAL_PROPERTIES_KEY_NAME), (Rule)this.booleanType()).then(FacetNode.class).description("A Boolean that indicates if an object instance has additional properties.");
    }

    public KeyValueRule maxPropertiesField() {
        return this.field((Rule)this.string(MAX_PROPERTIES_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("The maximum number of properties allowed for instances of this type.");
    }

    public KeyValueRule minPropertiesField() {
        return this.field((Rule)this.string(MIN_PROPERTIES_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("The minimum number of properties allowed for instances of this type.");
    }

    public KeyValueRule propertiesField() {
        return this.field((Rule)this.string(PROPERTIES_KEY_NAME), (Rule)this.properties()).then(FacetNode.class).description("The properties that instances of this type can or must have.");
    }

    public KeyValueRule fileTypesField() {
        return this.field((Rule)this.string(FILE_TYPES_KEY_NAME), (Rule)this.any()).then(FacetNode.class).description("A list of valid content-type strings for the file. The file type */* MUST be a valid value.");
    }

    public KeyValueRule multipleOfField(Rule rule) {
        return this.field((Rule)this.string(MULTIPLE_OF_KEY_NAME), rule).then(FacetNode.class).description("A numeric instance is valid against \"multipleOf\" if the result of dividing the instance by this keyword's value is an integer.");
    }

    public KeyValueRule numberFormat() {
        return this.field((Rule)this.string(FORMAT_KEY_NAME), (Rule)this.anyOf(new Rule[]{this.string("int32"), this.string("int64"), this.string("int"), this.string("long"), this.string("float"), this.string("double"), this.string("int16"), this.string("int8")})).then(FacetNode.class).description("The format of the value. The value MUST be one of the following: int32, int64, int, long, float, double, int16, int8");
    }

    public KeyValueRule maximumField(Rule rule) {
        return this.field((Rule)this.string(MAXIMUM_KEY_NAME), rule).then(FacetNode.class).description("The maximum value of the parameter. Applicable only to parameters of type number or integer.");
    }

    public KeyValueRule minimumField(Rule rule) {
        return this.field((Rule)this.string(MINIMUM_KEY_NAME), rule).then(FacetNode.class).description("The minimum value of the parameter. Applicable only to parameters of type number or integer.");
    }

    public KeyValueRule maxItemsField() {
        return this.field((Rule)this.string(MAX_ITEMS_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("Maximum amount of items in array. Value MUST be equal to or greater than 0.");
    }

    public KeyValueRule minItemsField() {
        return this.field((Rule)this.string(MIN_ITEMS_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("Minimum amount of items in array. Value MUST be equal to or greater than 0.");
    }

    public KeyValueRule itemsField() {
        return this.field((Rule)this.string(ITEMS_KEY_NAME), (Rule)this.typeRef()).then(FacetNode.class).description("Indicates the type all items in the array are inherited from. Can be a reference to an existing type or an inline type declaration.");
    }

    public KeyValueRule uniqueItemsField() {
        return this.field((Rule)this.string(UNIQUE_ITEMS_KEY_NAME), (Rule)this.booleanType()).then(FacetNode.class).description("Boolean value that indicates if items in the array MUST be unique.");
    }

    public KeyValueRule formatField() {
        return this.field((Rule)this.string(FORMAT_KEY_NAME), (Rule)this.anyOf(new Rule[]{this.string("rfc3339"), this.string("rfc2616")})).then(FacetNode.class);
    }

    public KeyValueRule enumField() {
        return this.field((Rule)this.string(ENUM_KEY_NAME), (Rule)this.array(this.scalarType())).then(FacetNode.class).description("Enumeration of possible values for this built-in scalar type. The value is an array containing representations of possible values, or a single value if there is only one possible value.");
    }

    public KeyValueRule maxLengthField() {
        return this.field((Rule)this.string(MAX_LENGTH_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("Maximum length of the string. Value MUST be equal to or greater than 0.");
    }

    public KeyValueRule minLengthField() {
        return this.field((Rule)this.string(MIN_LENGTH_KEY_NAME), (Rule)this.positiveIntegerType(true, (Long)Integer.MAX_VALUE)).then(FacetNode.class).description("Minimum length of the string. Value MUST be equal to or greater than 0.");
    }

    public KeyValueRule patternField() {
        return this.field((Rule)this.string(PATTERN_KEY_NAME), this.scalarType()).then(FacetNode.class).description("Regular expression that this string should match.");
    }

    protected KeyValueRule examplesField() {
        return this.field((Rule)this.exclusiveWith("examples", "example"), (Rule)this.examplesValue()).then(ExamplesNode.class).description("Examples of instances of this type. This can be used, for example, by documentation generators to generate sample values for an object of this type. The \"examples\" facet MUST not be available when the \"example\" facet is already defined. See section Examples for more information.");
    }

    protected KeyValueRule exampleField() {
        return this.field((Rule)this.exclusiveWith("example", "examples"), this.exampleValue()).then(ExampleDeclarationNode.class).description("An example of an instance of this type that can be used, for example, by documentation generators to generate sample values for an object of this type. The \"example\" facet MUST not be available when the \"examples\" facet is already defined. See section Examples for more information.");
    }

    protected KeyValueRule facetsField() {
        return this.field((Rule)this.string("facets"), (Rule)this.objectType().with(this.field((Rule)this.facetRegex(), (Rule)this.typeRef()).then(CustomFacetDefinitionNode.class))).description("A map of additional, user-defined restrictions that will be inherited and applied by any extending subtype. See section User-defined Facets for more information.");
    }

    private RegexValueRule facetRegex() {
        return this.regex("[^\\(].*");
    }

    protected ObjectRule examplesValue() {
        return this.objectType().with(this.field(this.scalarType(), this.exampleValue()).then(ExampleDeclarationNode.class));
    }

    private KeyValueRule typeField(TypeId defaultType) {
        return this.field((Rule)this.anyOf(new Rule[]{this.typeKey(), this.schemaKey()}), (Rule)this.anyOf(new Rule[]{this.typeExpressionReference(), this.array((Rule)this.typeExpressionReference()), this.explicitType()})).defaultValue((DefaultValue)new TypeDefaultValue(defaultType)).description("A base type which the current type extends or just wraps. The value of a type node MUST be either a) the name of a user-defined type or b) the name of a built-in RAML data type (object, array, or one of the scalar types) or c) an inline type declaration.");
    }

    private KeyValueRule requiredTypeField() {
        return this.field((Rule)this.string("required"), (Rule)this.booleanType());
    }

    private StringValueRule schemaKey() {
        return this.string(TYPES_FACET_SCHEMA);
    }

    private KeyValueRule xmlFacetField() {
        return this.field((Rule)this.string("xml"), (Rule)this.objectType().with(this.attributeField()).with(this.wrappedField()).with(this.xmlNameField()).with(this.namespaceField()).with(this.prefixField()));
    }

    private KeyValueRule xmlNameField() {
        return this.field((Rule)this.string("name"), (Rule)this.stringType()).description("Overrides the name of the XML element or XML attribute.");
    }

    private KeyValueRule prefixField() {
        return this.field((Rule)this.string("prefix"), (Rule)this.stringType()).description("Configures the prefix used during serialization to XML.");
    }

    private KeyValueRule namespaceField() {
        return this.field((Rule)this.string("namespace"), (Rule)this.stringType()).description("Configures the name of the XML namespace.");
    }

    private KeyValueRule wrappedField() {
        return this.field((Rule)this.string("wrapped"), (Rule)this.booleanType()).description("true wraps a type instance in its own XML element. Cannot be true for scalar types or true at the same moment attribute is true.");
    }

    private KeyValueRule attributeField() {
        return this.field((Rule)this.string("attribute"), (Rule)this.booleanType()).description("Serializes a type instance as an XML attribute. Can be true only for scalar types.");
    }

    private KeyValueRule defaultField() {
        return this.field((Rule)this.string("default"), (Rule)this.any());
    }

    private AnyOfRule typeExpressionReference() {
        return this.anyOf(new Rule[]{this.nullValue().then(NativeTypeExpressionNode.class), new SchemaDeclarationRule().then(ExternalSchemaTypeExpressionNode.class), new TypeExpressionReferenceRule().then(new TypeExpressionReferenceFactory())});
    }

    @Override
    protected Rule mimeType() {
        return this.anyOf(new Rule[]{this.nullValue().then((NodeFactory)new DefaultMimeTypeDeclarationFactory()), this.anyOf(new Rule[]{this.inlineType(), this.baseType(TypeId.ANY, "mimeType")})});
    }

    protected Rule exampleValue() {
        return this.anyOf(new Rule[]{this.explicitExample(), this.any()});
    }

    public Rule exampleFragment() {
        return this.anyOf(new Rule[]{this.explicitExample(true), this.any()});
    }

    private ObjectRule explicitExample() {
        return this.explicitExample(false);
    }

    private ObjectRule explicitExample(boolean isFragment) {
        ConditionalRule nestedValue = this.is((Rule)this.not((Rule)this.nullValue())).add(this.displayNameField()).add(this.descriptionField()).add(this.annotationField()).add(this.field((Rule)this.string("value"), (Rule)this.any())).add(this.field((Rule)this.string("strict"), (Rule)this.booleanType()));
        if (isFragment) {
            nestedValue.add(this.usesField());
        }
        return this.objectType().with(this.when("value", new ConditionalRule[]{nestedValue, this.is((Rule)this.nullValue()).add(this.field(this.scalarType(), (Rule)this.any()))}).defaultValue((Node)new NullNodeImpl()));
    }

    protected StringValueRule fileTypeLiteral() {
        return this.string("file");
    }

    protected Rule numericTypeLiteral() {
        return this.anyOf(new Rule[]{this.numberTypeLiteral(), this.integerTypeLiteral()});
    }

    protected Rule numberTypeLiteral() {
        return this.string("number");
    }

    protected Rule integerTypeLiteral() {
        return this.string("integer");
    }

    protected StringValueRule stringTypeLiteral() {
        return this.string("string");
    }

    protected StringValueRule booleanTypeLiteral() {
        return this.string("boolean");
    }

    private StringValueRule dateTimeTypeLiteral() {
        return this.string("datetime");
    }

    protected AnyOfRule arrayTypeLiteral() {
        return new AnyOfRule(new Rule[]{this.regex(".+\\[\\]"), this.string("array")});
    }

    protected ObjectRule properties() {
        return this.objectType().with(this.propertyField()).named("Properties");
    }

    @Override
    protected Rule parameters() {
        return this.properties();
    }

    private KeyValueRule propertyField() {
        return this.field(this.scalarType(), (Rule)this.anyOf(new Rule[]{this.inlineType(), this.propertyType()})).then(PropertyNode.class);
    }

    private ObjectRule propertyType() {
        return this.baseType(TypeId.STRING, PROPERTY_TYPE_RULE).named("PropertyTypeRule");
    }

    protected Rule objectTypeLiteral() {
        return this.string("object");
    }

    @Override
    protected KeyValueRule mediaTypeField() {
        return this.field((Rule)this.mediaTypeKey(), (Rule)this.anyOf(new Rule[]{this.mimeTypeRegex(), this.array((Rule)this.mimeTypeRegex())}));
    }

    @Override
    protected KeyValueRule schemasField() {
        return this.field((Rule)this.schemasKey(), this.schemasValue()).then(TypesNode.class);
    }

    @Override
    protected Rule schemasValue() {
        return this.types();
    }

    @Override
    @Nonnull
    protected String schemasDescription() {
        return "Alias for the equivalent \"types\" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the \"types\" property, as the \"schemas\" alias for that property name may be removed in a future RAML version. The \"types\" property allows for XML and JSON schemas.";
    }

    @Override
    protected KeyValueRule displayNameField() {
        return this.field((Rule)this.displayNameKey(), this.overlayableRamlScalarValue()).defaultValue((DefaultValue)new DisplayNameDefaultValue());
    }

    protected Rule overlayableRamlScalarValue() {
        return this.firstOf(new Rule[]{this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(true)), this.annotatedScalarType(this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(false)))});
    }

    @Override
    protected Rule resourceTypesValue() {
        return this.resourceTypes();
    }

    @Override
    protected Rule securitySchemesValue() {
        return this.securitySchemes();
    }

    @Override
    protected Rule descriptionValue() {
        return this.overlayableRamlScalarValue();
    }

    @Override
    protected KeyValueRule docTitleField() {
        return this.requiredField((Rule)this.titleKey(), (Rule)this.firstOf(new Rule[]{this.allOf(new Rule[]{this.minLength(1), this.ramlScalarValue()}), this.annotatedScalarType((Rule)this.allOf(new Rule[]{this.minLength(1), this.scalarType()}))}));
    }

    @Override
    protected Rule titleValue() {
        return this.firstOf(new Rule[]{this.allOf(new Rule[]{this.minLength(1), this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(true))}), this.annotatedScalarType((Rule)this.allOf(new Rule[]{this.minLength(1), this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(false))}))});
    }

    @Override
    public Rule ramlScalarValue() {
        return this.firstOf(new Rule[]{this.scalarType().then((NodeFactory)new RamlScalarValueFactory()), this.annotatedScalarType()});
    }

    protected Rule annotatedScalarType() {
        return this.annotatedScalarType(this.scalarType());
    }

    protected Rule annotatedScalarType(Rule customScalarRule) {
        return this.objectType().with(this.field((Rule)this.string("value"), customScalarRule)).with(this.annotationField());
    }

    @Override
    public ObjectRule documentation() {
        return super.documentation().with(this.annotationField()).then(DocumentationItemNode.class);
    }
}

