/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.model.parameter;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.model.parameter.AbstractParam;

public class ParameterImpl
implements IParameter {
    AbstractParam parameter;

    public ParameterImpl(AbstractParam parameter) {
        this.parameter = parameter;
    }

    public boolean isRequired() {
        return this.parameter.isRequired();
    }

    public String getDefaultValue() {
        return this.parameter.getDefaultValue();
    }

    public boolean isRepeat() {
        return this.parameter.isRepeat();
    }

    public boolean isArray() {
        return false;
    }

    public boolean validate(String s) {
        return this.parameter.validate(s);
    }

    public void validate(String expectedKey, Object values, String parameterType) throws Exception {
        ArrayList properties = values instanceof Iterable ? Lists.newArrayList((Iterable)((Iterable)values)) : Collections.singletonList(values);
        if (properties.size() > 1 && !this.isRepeat()) {
            throw new Exception("Parameter " + expectedKey + " is not a repetable");
        }
        Collection stringProperties = Collections2.transform((Collection)properties, (Function)new Function<Object, String>(){

            @Nullable
            public String apply(@Nullable Object input) {
                return String.valueOf(input);
            }
        });
        for (String param : stringProperties) {
            if (this.parameter.validate(param)) continue;
            String msg = String.format("Invalid value '%s' for %s %s. %s", param, parameterType, expectedKey, this.message(param));
            throw new Exception(msg);
        }
    }

    public String message(String s) {
        return this.parameter.message(s);
    }

    public String getDisplayName() {
        return this.parameter.getDisplayName();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public String getExample() {
        return this.parameter.getExample();
    }

    public Map<String, String> getExamples() {
        return new HashMap<String, String>();
    }

    public Object getInstance() {
        return this.parameter;
    }

    public boolean isStringArray() {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public boolean isFacetArray(String facet) {
        return false;
    }
}

