/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import java.util.List;
import org.raml.v2.api.model.v10.declarations.AnnotationTarget;
import org.raml.v2.internal.impl.commons.nodes.FacetNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;

public class RamlErrorNodeFactory {
    public static ErrorNode createInvalidAnnotationTarget(List<AnnotationTarget> allowedTargets, AnnotationTarget target) {
        return new ErrorNode("Annotation not allowed at target: " + (Object)((Object)target) + ". Allowed targets are: " + allowedTargets);
    }

    public static ErrorNode createInvalidUriTemplate() {
        return new ErrorNode("Invalid uri template syntax");
    }

    public static ErrorNode createInvalidFacetState(String type, String message) {
        String prefix = "Invalid facets";
        if (type != null) {
            prefix = prefix + " for type " + type;
        }
        return new ErrorNode(prefix + ": " + message);
    }

    public static ErrorNode createInvalidRequiredFacet(String property) {
        return new ErrorNode("Required property '" + property + "' cannot be made optional");
    }

    public static ErrorNode createCanNotOverrideCustomFacet(String facetName, String typeName) {
        return new ErrorNode("Custom facet '" + facetName + "' cannot be set as it is already defined by " + typeName + ".");
    }

    public static ErrorNode createCanNotOverrideNativeFacet(String facetName) {
        return new ErrorNode("Custom facet '" + facetName + "' cannot be defined as is already defined by this type.");
    }

    public static ErrorNode createCanNotOverrideProperty(String propertyName) {
        return new ErrorNode("Property '" + propertyName + "' cannot be overwritten.");
    }

    public static ErrorNode createPropertyCanNotBeOfSchemaType(String propertyName) {
        return new ErrorNode("Property '" + propertyName + "' cannot have a schema type.");
    }

    public static ErrorNode createRecurrentTypeDefinition(String typeName) {
        return new ErrorNode("Recurrent type definition: " + typeName + ".");
    }

    public static ErrorNode createInvalidLibraryChaining(String value) {
        return new ErrorNode("Library references cannot be chained: " + value);
    }

    public static ErrorNode createInvalidFacetForType(FacetNode facetNode, String typeName) {
        return new ErrorNode("Facet '" + facetNode.getName() + "' cannot be applied to " + typeName);
    }

    public static Node createInvalidFormatValue(String value, String format) {
        return new ErrorNode(value + " is not a valid " + format + " value");
    }
}

