/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv1.model.ActionImpl;
import org.mule.raml.implv1.model.parameter.ParameterImpl;
import org.mule.raml.interfaces.ParserUtils;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.UriParameter;

public class ResourceImpl
implements IResource {
    Resource resource;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public IAction getAction(String s) {
        Action action = this.resource.getAction(s);
        if (action == null) {
            return null;
        }
        return new ActionImpl(action);
    }

    public String getUri() {
        return this.resource.getUri();
    }

    public String getResolvedUri(String version) {
        return ParserUtils.resolveVersion((String)this.getUri(), (String)version);
    }

    public void setParentUri(String s) {
        this.resource.setParentUri(s);
    }

    public Map<String, IResource> getResources() {
        if (this.resource.getResources() == null) {
            return null;
        }
        LinkedHashMap<String, IResource> map = new LinkedHashMap<String, IResource>();
        for (Map.Entry entry : this.resource.getResources().entrySet()) {
            map.put((String)entry.getKey(), new ResourceImpl((Resource)entry.getValue()));
        }
        return map;
    }

    public String getParentUri() {
        return this.resource.getParentUri();
    }

    public Map<IActionType, IAction> getActions() {
        if (this.resource.getActions() == null) {
            return null;
        }
        LinkedHashMap<IActionType, IAction> map = new LinkedHashMap<IActionType, IAction>();
        for (Map.Entry entry : this.resource.getActions().entrySet()) {
            map.put(IActionType.valueOf((String)((ActionType)entry.getKey()).name()), new ActionImpl((Action)entry.getValue()));
        }
        return map;
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        if (this.resource.getBaseUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, List<IParameter>> map = new LinkedHashMap<String, List<IParameter>>();
        for (Map.Entry entry : this.resource.getBaseUriParameters().entrySet()) {
            ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
            for (UriParameter parameter : (List)entry.getValue()) {
                list.add(new ParameterImpl((AbstractParam)parameter));
            }
            map.put((String)entry.getKey(), (List<IParameter>)list);
        }
        return map;
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        if (this.resource.getResolvedUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, IParameter> map = new LinkedHashMap<String, IParameter>();
        for (Map.Entry entry : this.resource.getResolvedUriParameters().entrySet()) {
            map.put((String)entry.getKey(), new ParameterImpl((AbstractParam)entry.getValue()));
        }
        return map;
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public String getRelativeUri() {
        return this.resource.getRelativeUri();
    }

    public void cleanBaseUriParameters() {
        this.resource.getBaseUriParameters().clear();
    }

    public String toString() {
        return this.getUri();
    }
}

