/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import java.util.List;
import org.mule.module.apikit.HttpProtocolAdapter;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.exception.MuleRestException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.raml.interfaces.model.IAction;

public class OutputRepresentationHandler {
    private final HttpProtocolAdapter adapter;
    private final boolean throwNotAcceptable;

    public OutputRepresentationHandler(HttpProtocolAdapter adapter, boolean throwNotAcceptable) {
        this.adapter = adapter;
        this.throwNotAcceptable = throwNotAcceptable;
    }

    public String negotiateOutputRepresentation(IAction action, List<String> mimeTypes) throws MuleRestException {
        if (action == null || action.getResponses() == null || mimeTypes.isEmpty()) {
            return null;
        }
        String bestMatch = RestContentTypeParser.bestMatchAsString(mimeTypes, this.adapter.getAcceptableResponseMediaTypes());
        if (bestMatch == null) {
            return this.handleNotAcceptable();
        }
        for (String representation : mimeTypes) {
            if (!representation.equals(bestMatch)) continue;
            return representation;
        }
        return this.handleNotAcceptable();
    }

    private String handleNotAcceptable() throws NotAcceptableException {
        if (this.throwNotAcceptable) {
            throw new NotAcceptableException();
        }
        return null;
    }
}

