/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.mule.raml.interfaces.model.IMimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestContentTypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestContentTypeParser.class);
    private static final String WILDCARD = "*";

    protected static ParseResults parseMimeType(String mimeType) {
        String[] parts = StringUtils.split((String)mimeType, (String)";");
        ParseResults results = new ParseResults();
        results.params = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = StringUtils.split((String)p, (char)'=');
            if (subParts.length != 2) continue;
            results.params.put(subParts[0].trim(), subParts[1].trim());
        }
        String fullType = parts[0].trim();
        if (fullType.equals(WILDCARD)) {
            fullType = "*/*";
        }
        String[] types = StringUtils.split((String)fullType, (String)"/");
        results.type = types[0].trim();
        if (types.length > 1) {
            results.subType = types[1].trim();
        }
        return results;
    }

    protected static ParseResults parseMediaRange(String range) {
        ParseResults results = RestContentTypeParser.parseMimeType(range);
        String q = results.params.get("q");
        float f = NumberUtils.toFloat((String)q, (float)1.0f);
        if (StringUtils.isBlank((String)q) || f < 0.0f || f > 1.0f) {
            results.params.put("q", "1");
        }
        return results;
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(MediaType target, List<MediaType> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        for (MediaType range : parsedRanges) {
            if (!target.type().equals(range.type()) && !range.type().equals(WILDCARD) && !target.type().equals(WILDCARD) || !target.subtype().equals(range.subtype()) && !range.subtype().equals(WILDCARD) && !target.subtype().equals(WILDCARD)) continue;
            for (String k : target.parameters().keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.parameters().containsKey((Object)k) && target.parameters().get((Object)k).equals((Object)range.parameters().get((Object)k))) {
                    ++paramMatches;
                }
                int fitness = range.type().equals(target.type()) ? 100 : 0;
                fitness += range.subtype().equals(target.subtype()) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                if (range.type().equals(WILDCARD) && range.subtype().equals(WILDCARD)) {
                    bestFitQ = NumberUtils.toFloat((String)((String)target.parameters().get((Object)"q").get(0)), (float)0.0f);
                    continue;
                }
                bestFitQ = NumberUtils.toFloat((String)((String)range.parameters().get((Object)"q").get(0)), (float)0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        ParseResults target = RestContentTypeParser.parseMediaRange(mimeType);
        for (ParseResults range : parsedRanges) {
            if (!target.type.equals(range.type) && !range.type.equals(WILDCARD) && !target.type.equals(WILDCARD) || !target.subType.equals(range.subType) && !range.subType.equals(WILDCARD) && !target.subType.equals(WILDCARD)) continue;
            for (String k : target.params.keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.params.containsKey(k) && target.params.get(k).equals(range.params.get(k))) {
                    ++paramMatches;
                }
                int fitness = range.type.equals(target.type) ? 100 : 0;
                fitness += range.subType.equals(target.subType) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                if (range.type.equals(WILDCARD) && range.subType.equals(WILDCARD)) {
                    bestFitQ = NumberUtils.toFloat((String)target.params.get("q"), (float)0.0f);
                    continue;
                }
                bestFitQ = NumberUtils.toFloat((String)range.params.get("q"), (float)0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    public static float quality(MediaType mimeType, List<MediaType> ranges) {
        return RestContentTypeParser.fitnessAndQualityParsed((MediaType)mimeType, ranges).quality;
    }

    public static MediaType bestMatch(List<String> supportedRepresentations, String header) {
        String bestMatch = RestContentTypeParser.bestMatchAsString(supportedRepresentations, header);
        return bestMatch != null ? MediaType.parse((String)bestMatch) : null;
    }

    public static String bestMatchAsString(List<String> supportedRepresentations, String header) {
        LinkedList<ParseResults> parseResults = new LinkedList<ParseResults>();
        for (String r : StringUtils.split((String)header, (char)',')) {
            parseResults.add(RestContentTypeParser.parseMediaRange(r));
        }
        LinkedList<FitnessAndQuality> weightedMatches = new LinkedList<FitnessAndQuality>();
        String quality = "1";
        for (String representation : supportedRepresentations) {
            FitnessAndQuality fitnessAndQuality = RestContentTypeParser.fitnessAndQualityParsed(representation + ";q=" + quality, parseResults);
            fitnessAndQuality.mimeType = representation;
            weightedMatches.add(fitnessAndQuality);
            quality = "0.5";
        }
        Collections.sort(weightedMatches);
        FitnessAndQuality lastOne = (FitnessAndQuality)weightedMatches.get(weightedMatches.size() - 1);
        return NumberUtils.compare((float)lastOne.quality, (float)0.0f) != 0 ? lastOne.mimeType : null;
    }

    @Deprecated
    private static MediaType getMediaType(IMimeType mimeType) {
        MediaType mediaType = MediaType.parse((String)mimeType.getType());
        return mediaType.withParameter("q", "1");
    }

    public static boolean isMediaTypeAcceptable(List<MediaType> acceptContentTypes, MediaType mediaType) {
        for (MediaType accept : acceptContentTypes) {
            if (!accept.withoutParameters().equals((Object)mediaType)) continue;
            return true;
        }
        return false;
    }

    private RestContentTypeParser() {
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        ArrayList parsedMediaTypes = Lists.newArrayList();
        for (String r : StringUtils.split((String)mediaTypes, (char)',')) {
            try {
                if (r != null && r.equals(WILDCARD)) {
                    r = "*/*";
                }
                parsedMediaTypes.add(MediaType.parse((String)StringUtils.trim((String)r)));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unable to parse", (Throwable)e);
            }
        }
        return parsedMediaTypes;
    }

    protected static class FitnessAndQuality
    implements Comparable<FitnessAndQuality> {
        int fitness;
        float quality;
        String mimeType;

        public FitnessAndQuality(int fitness, float quality) {
            this.fitness = fitness;
            this.quality = quality;
        }

        @Override
        public int compareTo(FitnessAndQuality o) {
            if (this.fitness == o.fitness) {
                if (this.quality == o.quality) {
                    return 0;
                }
                return this.quality < o.quality ? -1 : 1;
            }
            return this.fitness < o.fitness ? -1 : 1;
        }
    }

    protected static class ParseResults {
        String type;
        String subType;
        Map<String, String> params;

        protected ParseResults() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer("('" + this.type + "', '" + this.subType + "', {");
            for (String k : this.params.keySet()) {
                s.append("'" + k + "':'" + this.params.get(k) + "',");
            }
            return s.append("})").toString();
        }
    }
}

