/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.transform;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.apikit.RestContentTypeParser;
import org.mule.module.apikit.exception.ApikitRuntimeException;
import org.mule.module.apikit.transform.DataTypePair;
import org.mule.module.apikit.transform.TransformerCache;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class ApikitResponseTransformer
extends AbstractMessageTransformer {
    public static final String BEST_MATCH_REPRESENTATION = "_ApikitResponseTransformer_bestMatchRepresentation";
    public static final String CONTRACT_MIME_TYPES = "_ApikitResponseTransformer_contractMimeTypes";
    public static final String APIKIT_ROUTER_REQUEST = "_ApikitResponseTransformer_apikitRouterRequest";
    public static final String ACCEPT_HEADER = "_ApikitResponseTransformer_AcceptedHeaders";
    private static final String CHARSET_PARAMETER = ";charset=";

    public Object transformMessage(MuleMessage message, String encoding) throws TransformerException {
        if (message.getInvocationProperty(APIKIT_ROUTER_REQUEST) == null) {
            return message;
        }
        String responseRepresentation = (String)message.getInvocationProperty(BEST_MATCH_REPRESENTATION);
        List responseMimeTypes = (List)message.getInvocationProperty(CONTRACT_MIME_TYPES);
        String acceptedHeader = (String)message.getInvocationProperty(ACCEPT_HEADER);
        if (responseRepresentation == null) {
            if (message.getOutboundProperty("http.status") == null) {
                message.setPayload((Object)NullPayload.getInstance());
            }
            return message;
        }
        return this.transformToExpectedContentType(message, responseRepresentation, responseMimeTypes, acceptedHeader);
    }

    public Object transformToExpectedContentType(MuleMessage message, String responseRepresentation, List<String> responseMimeTypes, String acceptedHeader) throws TransformerException {
        Object payload = message.getPayload();
        DataType dataType = message.getDataType();
        String msgMimeType = dataType != null ? dataType.getMimeType() : null;
        String msgEncoding = message.getEncoding();
        String msgContentType = (String)message.getOutboundProperty("Content-Type");
        if ("*/*".equals(responseRepresentation)) {
            if (msgContentType == null) {
                throw new ApikitRuntimeException("Content-Type must be set in the flow when declaring */* response type");
            }
            return payload;
        }
        if (payload instanceof NullPayload) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Response transformation not required. Message payload type is NullPayload");
            }
            return payload;
        }
        Collection<String> conjunctionTypes = this.getBestMatchMediaTypes(responseMimeTypes, acceptedHeader);
        String msgAcceptedContentType = this.acceptedContentType(msgMimeType, msgEncoding, msgContentType, conjunctionTypes);
        if (msgAcceptedContentType != null) {
            message.setOutboundProperty("Content-Type", (Object)msgAcceptedContentType);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Response transformation not required. Message payload type is " + msgAcceptedContentType));
            }
            return payload;
        }
        DataType sourceDataType = DataTypeFactory.create(message.getPayload().getClass(), (String)this.appendEncoding(msgEncoding, msgMimeType));
        DataType resultDataType = DataTypeFactory.create(String.class, (String)responseRepresentation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Resolving transformer between [source=%s] and [result=%s]", sourceDataType, resultDataType));
        }
        try {
            Transformer transformer = (Transformer)TransformerCache.getTransformerCache(this.muleContext).get((Object)new DataTypePair(sourceDataType, resultDataType));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Transformer resolved to [transformer=%s]", transformer));
            }
            Object newPayload = transformer.transform(message.getPayload());
            message.setOutboundProperty("Content-Type", (Object)responseRepresentation);
            return newPayload;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    private Collection<String> getBestMatchMediaTypes(List<String> responseMimeTypes, String acceptedHeader) {
        if (acceptedHeader.contains("*/*")) {
            return responseMimeTypes;
        }
        Collection<String> acceptedTypes = this.transformAcceptedTypes(acceptedHeader);
        return this.filterAccepted(responseMimeTypes, acceptedTypes);
    }

    private Collection<String> filterAccepted(List<String> responseMimeTypes, final Collection<String> acceptedTypes) {
        return Collections2.filter(responseMimeTypes, (Predicate)new Predicate<String>(){

            public boolean apply(String m) {
                return acceptedTypes.contains(m);
            }
        });
    }

    private Collection<String> transformAcceptedTypes(String acceptedHeader) {
        List<MediaType> acceptedMediaTypes = RestContentTypeParser.parseMediaTypes(acceptedHeader);
        return Collections2.transform(acceptedMediaTypes, (Function)new Function<MediaType, String>(){

            public String apply(MediaType mediaType) {
                return mediaType.type() + "/" + mediaType.subtype();
            }
        });
    }

    private String acceptedContentType(String msgMimeType, String encoding, String msgContentType, Collection<String> conjunctionTypes) {
        if (conjunctionTypes.contains(msgMimeType)) {
            return this.appendEncoding(encoding, msgMimeType);
        }
        for (String acceptedMediaType : conjunctionTypes) {
            if (!this.areCompatibleTypes(msgMimeType, acceptedMediaType)) continue;
            return acceptedMediaType.contains("*") ? this.appendEncoding(encoding, msgMimeType) : this.appendEncoding(encoding, acceptedMediaType);
        }
        for (String acceptedMediaType : conjunctionTypes) {
            if (!this.areCompatibleTypes(msgContentType, acceptedMediaType)) continue;
            if (acceptedMediaType.contains("*")) {
                return this.appendEncoding(encoding, msgContentType);
            }
            String contentTypeEncoding = this.extractEncoding(msgContentType);
            return this.appendEncoding(contentTypeEncoding, acceptedMediaType);
        }
        return null;
    }

    private String appendEncoding(String encoding, String mimeType) {
        return encoding != null && mimeType != null && !mimeType.contains(CHARSET_PARAMETER) ? mimeType + CHARSET_PARAMETER + encoding : mimeType;
    }

    private String extractEncoding(String msgContentType) {
        if (msgContentType == null) {
            return null;
        }
        int charsetKeyIndex = msgContentType.indexOf(CHARSET_PARAMETER);
        if (charsetKeyIndex == -1) {
            return null;
        }
        int endCharsetDefinition = msgContentType.indexOf(";", charsetKeyIndex + 1);
        return endCharsetDefinition != -1 ? msgContentType.substring(charsetKeyIndex + CHARSET_PARAMETER.length(), endCharsetDefinition) : msgContentType.substring(charsetKeyIndex + CHARSET_PARAMETER.length());
    }

    private boolean areCompatibleTypes(String baseMimeType, String mimeType) {
        if (baseMimeType == null && mimeType == null || "*/*".equals(mimeType)) {
            return true;
        }
        if (baseMimeType != null && mimeType != null) {
            if (baseMimeType.equals(mimeType)) {
                return true;
            }
            String baseSubType = this.getMimeSubtype(baseMimeType);
            String subtype = this.getMimeSubtype(mimeType);
            return "*".equals(subtype) || baseSubType.equals(subtype);
        }
        return false;
    }

    private String getMimeSubtype(String mimeType) {
        String mimeTypeWithoutParameters;
        String string = mimeTypeWithoutParameters = mimeType.contains(";") ? mimeType.split(";")[0] : mimeType;
        if (mimeTypeWithoutParameters.contains("+")) {
            return mimeTypeWithoutParameters.split("\\+")[1];
        }
        return mimeTypeWithoutParameters.split("/")[1];
    }
}

