/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.io.IOException;
import java.io.InputStream;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.v10.Raml10Builder;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.nodes.IncludeErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Transformer;

public class LibraryLinkingTransformation
implements Transformer {
    private final Raml10Builder builder;
    private final ResourceLoader resourceLoader;

    public LibraryLinkingTransformation(Raml10Builder builder, ResourceLoader resourceLoader) {
        this.builder = builder;
        this.resourceLoader = resourceLoader;
    }

    public boolean matches(Node node) {
        return node instanceof LibraryLinkNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node transform(Node node) {
        LibraryLinkNode linkNode = (LibraryLinkNode)node;
        String baseLocation = linkNode.getStartPosition().getPath();
        String refName = linkNode.getRefName();
        String absoluteLocation = ResourcePathUtils.toAbsoluteLocation(baseLocation, refName);
        try (InputStream inputStream = this.resourceLoader.fetchResource(absoluteLocation);){
            if (inputStream == null) {
                IncludeErrorNode includeErrorNode = new IncludeErrorNode("Library cannot be resolved: " + absoluteLocation);
                return includeErrorNode;
            }
            String content = StreamUtils.toString(inputStream);
            Node libraryReference = this.builder.build((Node)linkNode, content, RamlFragment.Library, this.resourceLoader, absoluteLocation, RamlBuilder.ALL_PHASES);
            linkNode.setLibraryReference(libraryReference);
            return linkNode;
        }
        catch (IOException e) {
            return new IncludeErrorNode(String.format("Library cannot be resolved: %s. (%s)", absoluteLocation, e.getMessage()));
        }
    }
}

