/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.module.apikit.CharsetUtils;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.module.apikit.validation.AbstractRestSchemaValidator;
import org.mule.module.apikit.validation.cache.XmlSchemaCache;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RestXmlSchemaValidator
extends AbstractRestSchemaValidator {
    public static final String EXTERNAL_ENTITIES_PROPERTY = "raml.xml.expandExternalEntities";
    public static final String EXPAND_ENTITIES_PROPERTY = "raml.xml.expandInternalEntities";
    private static final Boolean externalEntities = Boolean.parseBoolean(System.getProperty("raml.xml.expandExternalEntities", "false"));
    private static final Boolean expandEntities = Boolean.parseBoolean(System.getProperty("raml.xml.expandInternalEntities", "false"));
    protected static final Logger logger = LoggerFactory.getLogger(RestXmlSchemaValidator.class);

    public RestXmlSchemaValidator(MuleContext muleContext) {
        super(muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(String configId, String schemaPath, MuleEvent muleEvent, IRaml api) throws BadRequestException {
        try {
            Document data;
            Object input = muleEvent.getMessage().getPayload();
            String charset = CharsetUtils.getHeaderCharset(muleEvent.getMessage(), logger);
            if (input instanceof InputStream) {
                logger.debug("Transforming payload to perform XSD validation");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)((InputStream)input), (OutputStream)baos);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)((InputStream)input));
                }
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream(baos.toByteArray()), charset);
                String encoding = charset != null ? charset : CharsetUtils.getXmlEncoding(muleEvent, baos.toByteArray(), data, logger);
                DataType<?> dataType = this.getDataType(muleEvent, ByteArrayInputStream.class, encoding);
                muleEvent.getMessage().setPayload((Object)new ByteArrayInputStream(baos.toByteArray()), dataType);
            } else if (input instanceof String) {
                data = RestXmlSchemaValidator.loadDocument(new StringReader((String)input));
            } else if (input instanceof byte[]) {
                data = RestXmlSchemaValidator.loadDocument(new ByteArrayInputStream((byte[])input), charset);
                String encoding = charset != null ? charset : CharsetUtils.getXmlEncoding(muleEvent, (byte[])input, data, logger);
                muleEvent.getMessage().setPayload(input, this.getDataType(muleEvent, encoding));
            } else {
                throw new BadRequestException("Don't know how to parse " + input.getClass().getName());
            }
            Schema schema = (Schema)XmlSchemaCache.getXmlSchemaCache(this.muleContext, configId, api).get((Object)schemaPath);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(data.getDocumentElement()));
        }
        catch (Exception e) {
            logger.info("Schema validation failed: " + e.getMessage());
            throw new BadRequestException(e);
        }
    }

    private DataType<?> getDataType(MuleEvent muleEvent, String encoding) {
        return this.getDataType(muleEvent, muleEvent.getMessage().getDataType().getType(), encoding);
    }

    private DataType<?> getDataType(MuleEvent muleEvent, Class<?> type, String encoding) {
        DataType messageDataType = muleEvent.getMessage().getDataType();
        DataType dataType = DataTypeFactory.create(type, (String)messageDataType.getMimeType());
        dataType.setEncoding(encoding);
        return dataType;
    }

    private static Document loadDocument(InputStream stream, String charset) throws IOException {
        if (charset == null) {
            return RestXmlSchemaValidator.loadDocument(new InputSource(stream));
        }
        return RestXmlSchemaValidator.loadDocument(new InputSource(new InputStreamReader(stream, charset)));
    }

    private static Document loadDocument(Reader reader) throws IOException {
        return RestXmlSchemaValidator.loadDocument(new InputSource(reader));
    }

    private static Document loadDocument(InputSource source) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        RestXmlSchemaValidator.setFeatures(factory);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("An internal operation failed.", e);
        }
        catch (SAXException e) {
            throw new IOException("An internal operation failed.", e);
        }
    }

    private static void setFeatures(DocumentBuilderFactory dbf) {
        String feature = null;
        try {
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, externalEntities);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, externalEntities);
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, expandEntities == false);
            dbf.setXIncludeAware(expandEntities);
            dbf.setExpandEntityReferences(expandEntities);
        }
        catch (ParserConfigurationException e) {
            logger.info("ParserConfigurationException was thrown. The feature '" + feature + "' is probably not supported by your XML processor.");
        }
    }
}

