/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlSchemaValidationRule
extends Rule {
    public static final String EXTERNAL_ENTITIES_PROPERTY = "raml.xml.expandExternalEntities";
    public static final String EXPAND_ENTITIES_PROPERTY = "raml.xml.expandInternalEntities";
    public static final Boolean externalEntities = Boolean.parseBoolean(System.getProperty("raml.xml.expandExternalEntities", "false"));
    public static final Boolean expandEntities = Boolean.parseBoolean(System.getProperty("raml.xml.expandInternalEntities", "false"));
    public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    public static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private Schema schema;
    private String type;

    public XmlSchemaValidationRule(XmlSchemaExternalType schemaNode, ResourceLoader resourceLoader) {
        try {
            this.schema = SchemaGenerator.generateXmlSchema(resourceLoader, schemaNode);
            this.type = schemaNode.getInternalFragment();
        }
        catch (SAXException e) {
            this.schema = null;
        }
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Lists.newArrayList();
    }

    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)"Invalid XmlSchema");
        }
        if (node instanceof SimpleTypeNode) {
            return this.validateXmlExample(node);
        }
        return node;
    }

    private Node validateXmlExample(@Nonnull Node node) {
        String value = ((SimpleTypeNode)node).getLiteralValue();
        try {
            QName rootElement;
            if (this.type != null && (rootElement = this.getRootElement(value)) != null && !rootElement.getLocalPart().equals(this.type)) {
                return ErrorNodeFactory.createInvalidXmlExampleNode((String)("Provided object is not of type " + this.type));
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.setFeatures(factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            Document document = builder.parse(new InputSource(new StringReader(value)));
            this.schema.newValidator().validate(new DOMSource(document.getDocumentElement()));
        }
        catch (IOException | ParserConfigurationException | XMLStreamException | SAXException e) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)e.getMessage());
        }
        return node;
    }

    private void setFeatures(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        Object feature = null;
        dbf.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, externalEntities);
        dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, externalEntities);
        dbf.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, expandEntities == false);
        dbf.setXIncludeAware(expandEntities);
        dbf.setExpandEntityReferences(expandEntities);
        dbf.setNamespaceAware(true);
    }

    @Nullable
    public QName getRootElement(String xmlContent) throws XMLStreamException {
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLStreamReader r = f.createXMLStreamReader(new StringReader(xmlContent));
        r.nextTag();
        return r.getName();
    }

    public String getDescription() {
        return "Xml Schema validation Rule.";
    }
}

