/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.interfaces.model.IQueryString;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class QueryStringImpl
implements IQueryString {
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;

    public QueryStringImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet typeIds = Sets.newHashSet((Object[])TypeId.values());
        typeIds.remove(TypeId.OBJECT);
        typeIds.remove(TypeId.ARRAY);
        this.scalarTypes = Collections2.transform((Collection)typeIds, (Function)new Function<TypeId, String>(){

            @Nullable
            public String apply(@Nullable TypeId input) {
                return input.getType();
            }
        });
    }

    public String getDefaultValue() {
        return this.typeDeclaration.defaultValue();
    }

    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public boolean validate(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.typeDeclaration.type());
    }

    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }

    public Map<String, IParameter> facets() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                result.put(type.name(), new ParameterImpl(type));
            }
        }
        return result;
    }
}

