/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class MaxLengthRule
extends Rule {
    private int maxLength;

    public MaxLengthRule(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof SimpleTypeNode) {
            return ((SimpleTypeNode)node).getLiteralValue().length() <= this.maxLength;
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidMaxLength(this.maxLength, node);
        }
        return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getLiteralValue());
    }

    @Override
    public String getDescription() {
        return "Max length";
    }
}

