/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;

public class NumberResolvedType
extends XmlFacetsCapableType {
    private Number minimum;
    private Number maximum;
    private Number multiple;
    private String format;
    private List<Number> enums = new ArrayList<Number>();

    public NumberResolvedType(TypeExpressionNode from) {
        super(NumberResolvedType.getTypeName(from, TypeId.NUMBER.getType()), from, new ResolvedCustomFacets("minimum", "maximum", "multipleOf", "format"));
    }

    public NumberResolvedType(String typeName, TypeExpressionNode declarationNode, XmlFacets xmlFacets, Number minimum, Number maximum, Number multiple, String format, ResolvedCustomFacets customFacets) {
        super(typeName, declarationNode, xmlFacets, customFacets);
        this.minimum = minimum;
        this.maximum = maximum;
        this.multiple = multiple;
        this.format = format;
    }

    @Override
    public NumberResolvedType copy() {
        return new NumberResolvedType(this.getTypeName(), this.getTypeExpressionNode(), this.getXmlFacets().copy(), this.minimum, this.maximum, this.multiple, this.format, this.customFacets.copy());
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.minimumField(raml10Grammar.numberType())).add((Rule)raml10Grammar.maximumField(raml10Grammar.numberType())).add((Rule)raml10Grammar.numberFormat()).add((Rule)raml10Grammar.enumField()).add((Rule)raml10Grammar.multipleOfField(raml10Grammar.numberType())).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public boolean doAccept(ResolvedType valueType) {
        return valueType instanceof NumberResolvedType;
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        NumberResolvedType result = this.copy();
        result.customFacets = this.customFacets.overwriteFacets(from);
        result.setMinimum(NodeSelector.selectNumberValue((String)"minimum", (Node)from));
        result.setMaximum(NodeSelector.selectNumberValue((String)"maximum", (Node)from));
        result.setMultiple(NodeSelector.selectNumberValue((String)"multipleOf", (Node)from));
        result.setFormat(NodeSelector.selectStringValue((String)"format", (Node)from));
        result.setEnums(this.getEnumValues(from));
        return this.overwriteFacets(result, from);
    }

    @Nonnull
    private List<Number> getEnumValues(Node typeNode) {
        Node values = typeNode.get("enum");
        ArrayList<Number> enumValues = new ArrayList<Number>();
        if (values != null && values instanceof ArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add((Number)((SimpleTypeNode)node).getValue());
            }
        }
        return enumValues;
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        NumberResolvedType result = this.copy();
        if (with instanceof NumberResolvedType) {
            NumberResolvedType numberTypeDefinition = (NumberResolvedType)with;
            result.setMinimum(numberTypeDefinition.getMinimum());
            result.setMaximum(numberTypeDefinition.getMaximum());
            result.setMultiple(numberTypeDefinition.getMultiple());
            result.setFormat(numberTypeDefinition.getFormat());
            result.setEnums(numberTypeDefinition.getEnums());
        }
        result.customFacets = result.customFacets.mergeWith(with.customFacets());
        return this.mergeFacets(result, with);
    }

    @Override
    public void validateState() {
        super.validateState();
        ErrorNode errorNode = this.validateFacets();
        if (errorNode != null) {
            this.getTypeExpressionNode().replaceWith((Node)errorNode);
        }
    }

    public ErrorNode validateFacets() {
        BigDecimal mult;
        BigDecimal min = this.minimum != null ? new BigDecimal(this.minimum.toString()) : new BigDecimal(Integer.MIN_VALUE);
        BigDecimal max = this.maximum != null ? new BigDecimal(this.maximum.toString()) : new BigDecimal(Integer.MAX_VALUE);
        BigDecimal bigDecimal = mult = this.multiple != null ? new BigDecimal(this.multiple.toString()) : null;
        if (max.compareTo(min) < 0) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "maximum must be greater than or equal to minimum");
        }
        if (mult != null && !this.hasValidMultiplesInRange(min, max, mult)) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "There must be at least one multiple of " + mult + " in the given range");
        }
        for (Number thisEnum : this.enums) {
            BigDecimal value = new BigDecimal(thisEnum.toString());
            if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
                return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "enum values must be between " + min + " and " + max);
            }
            if (mult == null || value.remainder(mult).compareTo(BigDecimal.ZERO) == 0) continue;
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "enum values must be multiple of " + mult);
        }
        return null;
    }

    private boolean hasValidMultiplesInRange(BigDecimal min, BigDecimal max, BigDecimal mult) {
        BigDecimal divideMin;
        if (mult.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        BigDecimal divideMax = max.divide(mult, 0, 1);
        BigDecimal subtract = divideMax.subtract(divideMin = min.divide(mult, 0, 2));
        BigDecimal plusOne = subtract.add(BigDecimal.ONE);
        BigDecimal max0 = plusOne.max(BigDecimal.ZERO);
        BigDecimal numberOfMultiplesInRange = max0.setScale(0, 1);
        return numberOfMultiplesInRange.compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitNumber(this);
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public List<Number> getEnums() {
        return this.enums;
    }

    public void setEnums(List<Number> enums) {
        if (enums != null && !enums.isEmpty()) {
            this.enums = enums;
        }
    }

    private void setMinimum(Number minimum) {
        if (minimum != null) {
            this.minimum = minimum;
        }
    }

    public Number getMaximum() {
        return this.maximum;
    }

    private void setMaximum(Number maximum) {
        if (maximum != null) {
            this.maximum = maximum;
        }
    }

    public Number getMultiple() {
        return this.multiple;
    }

    private void setMultiple(Number multiple) {
        if (multiple != null) {
            this.multiple = multiple;
        }
    }

    public String getFormat() {
        return this.format;
    }

    private void setFormat(String format) {
        if (format != null) {
            this.format = format;
        }
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.NUMBER.getType();
    }
}

