/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONRPCServlet;
import org.jabsorb.serializer.Serializer;
import org.mule.api.MuleContext;
import org.mule.ibeans.ConfigManager;
import org.mule.ibeans.web.jabsorb.ClassSerializer;
import org.mule.ibeans.web.jabsorb.EnumSerializer;
import org.mule.module.ibeans.config.IBeanHolder;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;

public class IBeansRpcServlet
extends JSONRPCServlet {
    public static final String ENABLED_IBEANS_PARAM = "enabled.ibeans";
    public static final String ENABLE_ALL_IBEANS = "*";
    public static final String CONFIG_BEAN_NAME = "config";
    private String accessibleIbeans = "*";
    private MuleContext muleContext;
    private MuleIBeansPlugin plugin;

    public void init() throws ServletException {
        super.init();
        this.muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        String temp = this.getServletConfig().getInitParameter(ENABLED_IBEANS_PARAM);
        if (temp != null) {
            this.accessibleIbeans = temp;
        }
        this.accessibleIbeans = this.accessibleIbeans.replaceAll(" ", "");
        this.plugin = new MuleIBeansPlugin(this.muleContext);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpSession session = ((HttpServletRequest)servletRequest).getSession();
        JSONRPCBridge bridge = (JSONRPCBridge)session.getAttribute(JSONRPCBridge.class.getSimpleName());
        if (bridge == null) {
            bridge = new JSONRPCBridge();
            session.setAttribute(JSONRPCBridge.class.getSimpleName(), (Object)bridge);
            this.initBridge(bridge);
        }
        super.service(servletRequest, servletResponse);
    }

    protected void initBridge(JSONRPCBridge bridge) throws ServletException {
        try {
            bridge.registerSerializer((Serializer)new EnumSerializer());
            bridge.registerSerializer((Serializer)new ClassSerializer());
            boolean all = ENABLE_ALL_IBEANS.equals(this.accessibleIbeans);
            Collection col = this.muleContext.getRegistry().lookupObjects(IBeanHolder.class);
            for (IBeanHolder holder : col) {
                if (all) {
                    bridge.registerObject((Object)holder.getId(), holder.create(this.muleContext, this.plugin));
                    continue;
                }
                if (!this.accessibleIbeans.contains(holder.getId())) continue;
                bridge.registerObject((Object)holder.getId(), holder.create(this.muleContext, this.plugin));
            }
            if (all || this.accessibleIbeans.contains(CONFIG_BEAN_NAME)) {
                bridge.registerObject((Object)CONFIG_BEAN_NAME, (Object)new ConfigManager(this.muleContext));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

