/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web.jabsorb;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.mule.util.ClassUtils;

public class ClassSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class<?>[] _JSONClasses = new Class[]{String.class};
    private static Class<?>[] _serializableClasses = new Class[]{Class.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        return null;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class aClass, Object json) throws UnmarshallException {
        Class<?>[] classes = json.getClass().getClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].equals(Class.class)) continue;
            state.setSerialized(json, (Object)ObjectMatch.OKAY);
            return ObjectMatch.OKAY;
        }
        state.setSerialized(json, (Object)ObjectMatch.SIMILAR);
        return ObjectMatch.SIMILAR;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        String val = json.toString();
        if (clazz.equals(Class.class)) {
            try {
                return ClassUtils.loadClass((String)val, ((Object)((Object)this)).getClass());
            }
            catch (Exception e) {
                throw new UnmarshallException("could not load class: " + val, (Throwable)e);
            }
        }
        return null;
    }
}

