/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.module.http;

import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.ReceiveException;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpClientMessageRequester;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.MapUtils;

public class HttpClientMessageRequester2
extends HttpClientMessageRequester {
    protected String etag = null;
    private boolean checkEtag = false;

    public HttpClientMessageRequester2(InboundEndpoint endpoint) {
        super(endpoint);
        this.receiveTransformer.setMuleContext(this.getConnector().getMuleContext());
        this.checkEtag = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"checkEtag", (boolean)false);
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        GetMethod httpMethod = new GetMethod(this.endpoint.getEndpointURI().getAddress());
        if (this.endpoint.getProperties().containsKey("Authorization")) {
            httpMethod.setDoAuthentication(true);
            this.client.getParams().setAuthenticationPreemptive(true);
            httpMethod.setRequestHeader("Authorization", (String)this.endpoint.getProperty((Object)"Authorization"));
        }
        boolean releaseConn = false;
        try {
            HttpClient client = new HttpClient();
            if (this.etag != null && this.checkEtag) {
                httpMethod.setRequestHeader("If-None-Match", this.etag);
            }
            client.executeMethod((HttpMethod)httpMethod);
            if (httpMethod.getStatusCode() < 400) {
                MuleMessage message = new HttpMuleMessageFactory(this.connector.getMuleContext()).create((Object)httpMethod, null);
                this.etag = (String)message.getInboundProperty("ETag", null);
                if (httpMethod.getStatusCode() == 200 || httpMethod.getStatusCode() != 304 || !this.checkEtag) {
                    if ("".equals(message.getPayload())) {
                        releaseConn = true;
                    }
                    MuleMessage muleMessage = message;
                    return muleMessage;
                }
                DefaultMuleMessage defaultMuleMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getConnector().getMuleContext());
                return defaultMuleMessage;
            }
            try {
                releaseConn = true;
                throw new ReceiveException(HttpMessages.requestFailedWithStatus((String)httpMethod.getStatusLine().toString()), this.endpoint, timeout);
            }
            catch (ReceiveException e) {
                releaseConn = true;
                throw e;
            }
            catch (Exception e) {
                releaseConn = true;
                throw new ReceiveException(this.endpoint, timeout, (Throwable)e);
            }
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }
}

