/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.Collections;
import java.util.Map;
import javax.activation.MimeTypeParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ibeans.api.DataType;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.ReceiveException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.CustomNotification;
import org.mule.context.notification.NotificationException;
import org.mule.ibeans.ConfigManager;
import org.mule.ibeans.i18n.IBeansMessages;
import org.mule.module.annotationx.config.ChannelConfigBuilder;
import org.mule.module.ibeans.config.IBeanBinding;
import org.mule.module.ibeans.config.IBeanFlowConstruct;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;
import org.mule.module.ibeans.spi.support.DataTypeConverter;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.AbstractConnector;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IBeansContext {
    public static final String CONTEXT_PROPERTY = "mule.ibeans.context";
    protected static final Log logger = LogFactory.getLog(IBeansContext.class);
    private MuleContext muleContext;
    private ConfigManager configManager;
    private MuleIBeansPlugin plugin;
    private ConcurrentMap inboundEndpointCache = new ConcurrentHashMap();
    private ConcurrentMap outboundEndpointCache = new ConcurrentHashMap();

    IBeansContext(MuleContext context) throws MuleException {
        this.init(context);
    }

    private void init(MuleContext context) throws MuleException {
        this.muleContext = context;
        if (this.muleContext == null) {
            throw new DefaultMuleException(CoreMessages.objectIsNull((String)"muleContext"));
        }
        this.configManager = new ConfigManager(this.muleContext);
        this.plugin = new MuleIBeansPlugin(context);
    }

    protected void exceptionCheck(MuleMessage message) throws MuleException {
        if (message != null && message.getExceptionPayload() != null) {
            throw ExceptionHelper.getRootMuleException((Throwable)message.getExceptionPayload().getException());
        }
    }

    public void send(String uriOrRef, Object payload) throws MuleException {
        this.send(uriOrRef, (MuleMessage)new DefaultMuleMessage(payload, Collections.EMPTY_MAP, this.muleContext));
    }

    public void send(String uriOrRef, Object payload, Map properties) throws MuleException {
        this.send(uriOrRef, (MuleMessage)new DefaultMuleMessage(payload, properties, this.muleContext));
    }

    private void send(String uriOrRef, MuleMessage message) throws MuleException {
        MuleEvent event = this.getEvent(message, uriOrRef, false);
        try {
            ((OutboundEndpoint)event.getEndpoint()).process(event);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(IBeansMessages.failedToSendMessageUsingUri(uriOrRef), (Throwable)e);
        }
    }

    public Object request(String uriOrRef, Object payload, Map properties) throws MuleException {
        return this.request(uriOrRef, Object.class, payload, properties);
    }

    public Object request(String uriOrRef, Object payload) throws MuleException {
        return this.request(uriOrRef, Object.class, payload);
    }

    public <T> T request(String uriOrRef, Class<T> returnType, Object payload) throws MuleException {
        MuleMessage message = this.request(uriOrRef, (MuleMessage)new DefaultMuleMessage(payload, Collections.EMPTY_MAP, this.muleContext));
        this.exceptionCheck(message);
        if (message == null) {
            return null;
        }
        if (returnType == null) {
            return (T)message.getPayload();
        }
        if (MuleMessage.class.isAssignableFrom(returnType)) {
            return (T)message;
        }
        return (T)message.getPayload(returnType);
    }

    public <T> T request(String uriOrRef, Class<T> returnType, Object payload, Map properties) throws MuleException {
        MuleMessage message = this.request(uriOrRef, (MuleMessage)new DefaultMuleMessage(payload, properties, this.muleContext));
        this.exceptionCheck(message);
        if (returnType == null) {
            return (T)message.getPayload();
        }
        if (MuleMessage.class.isAssignableFrom(returnType)) {
            return (T)message;
        }
        return (T)message.getPayload(returnType);
    }

    private MuleMessage request(String uriOrRef, MuleMessage message) throws MuleException {
        MuleEvent requestEvent = this.getEvent(message, uriOrRef, true);
        requestEvent.setTimeout(this.getConfiguration().getDefaultResponseTimeout());
        try {
            MuleEvent event = ((OutboundEndpoint)requestEvent.getEndpoint()).process(requestEvent);
            if (event == null || event.getMessage().getPayload() instanceof NullPayload) {
                return null;
            }
            this.exceptionCheck(event.getMessage());
            return event.getMessage();
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(IBeansMessages.failedToSendMessageUsingUri(uriOrRef), (Throwable)e);
        }
    }

    public <T> T receive(String uriOrRef, Class<T> returnType) throws MuleException {
        return this.receive(uriOrRef, returnType, this.getConfiguration().getDefaultResponseTimeout());
    }

    public <T> T receive(String uriOrRef, Class<T> returnType, int timeout) throws MuleException {
        InboundEndpoint endpoint = this.getInboundEndpoint(uriOrRef);
        try {
            MuleMessage message = endpoint.request((long)timeout);
            this.exceptionCheck(message);
            if (message == null || message.getPayload() instanceof NullPayload) {
                return null;
            }
            if (returnType == null) {
                return (T)message.getPayload();
            }
            if (MuleMessage.class.isAssignableFrom(returnType)) {
                return (T)message;
            }
            return (T)message.getPayload(returnType);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ReceiveException((ImmutableEndpoint)endpoint, (long)timeout, (Throwable)ex);
        }
    }

    protected MuleEvent getEvent(MuleMessage message, String uri, boolean synchronous) throws MuleException {
        OutboundEndpoint endpoint = this.getOutboundEndpoint(uri);
        if (!endpoint.getConnector().isStarted() && this.muleContext.isStarted()) {
            endpoint.getConnector().start();
        }
        DefaultMuleSession session = new DefaultMuleSession(message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler(), this.muleContext);
        return new DefaultMuleEvent(message, (ImmutableEndpoint)endpoint, (MuleSession)session);
    }

    protected InboundEndpoint getInboundEndpoint(String uri) throws MuleException {
        Object temp;
        InboundEndpoint concurrentlyAddedEndpoint;
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get((Object)uri);
        if (endpoint == null && (concurrentlyAddedEndpoint = (InboundEndpoint)this.inboundEndpointCache.putIfAbsent((Object)uri, (Object)(endpoint = (temp = this.muleContext.getRegistry().lookupObject(uri + ".builder")) != null && temp instanceof ChannelConfigBuilder ? ((ChannelConfigBuilder)temp).buildReceiveAndReplyChannel() : this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(uri)))) != null) {
            return concurrentlyAddedEndpoint;
        }
        return endpoint;
    }

    protected OutboundEndpoint getOutboundEndpoint(String uri) throws MuleException {
        Object temp;
        OutboundEndpoint concurrentlyAddedEndpoint;
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get((Object)uri);
        if (endpoint == null && (concurrentlyAddedEndpoint = (OutboundEndpoint)this.outboundEndpointCache.putIfAbsent((Object)uri, (Object)(endpoint = (temp = this.muleContext.getRegistry().lookupObject(uri + ".builder")) != null && temp instanceof ChannelConfigBuilder ? ((ChannelConfigBuilder)temp).buildSendChannel() : this.muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri)))) != null) {
            return concurrentlyAddedEndpoint;
        }
        return endpoint;
    }

    public <T> T createIBean(Class<T> clazz) {
        IBeanBinding router = new IBeanBinding(new IBeanFlowConstruct(clazz.getName(), this.muleContext), this.muleContext, this.plugin);
        router.setInterface(clazz);
        return (T)router.createProxy(new Object());
    }

    MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void registerApplicationIBean(String name, Object bean) throws MuleException {
        this.getMuleContext().getRegistry().registerObject(name, bean);
    }

    public void unregisterApplicationIBean(String name) throws MuleException {
        this.getMuleContext().getRegistry().unregisterObject(name);
        this.getMuleContext().getRegistry().unregisterObject(name + ".service");
    }

    protected MuleConfiguration getConfiguration() {
        return this.muleContext.getConfiguration();
    }

    public void fireNotification(CustomNotification n) {
        this.getMuleContext().fireNotification((ServerNotification)n);
    }

    public void registerNotificationListener(ServerNotificationListener l) throws NotificationException {
        this.getMuleContext().registerListener(l);
    }

    public void registerNotificationListener(ServerNotificationListener l, String subscriptionKey) throws NotificationException {
        this.getMuleContext().registerListener(l, subscriptionKey);
    }

    public <T> T transform(Object source, Class<T> resultType) throws TransformerException, MimeTypeParseException {
        return this.transform(source, DataTypeFactory.create(resultType));
    }

    public <T> T transform(Object source, DataType<T> result) throws TransformerException, MimeTypeParseException {
        DataType sourceType = source instanceof MuleMessage ? DataTypeFactory.createFromObject((Object)source) : DataTypeFactory.create(source.getClass(), (String)"*/*");
        Class<?> sourceClass = source.getClass();
        if (source instanceof MuleMessage) {
            if (result.getType().equals(MuleMessage.class)) {
                return (T)source;
            }
            sourceClass = ((MuleMessage)source).getPayload().getClass();
        }
        if (result.isCompatibleWith(sourceType)) {
            if (sourceClass.equals(source.getClass())) {
                return (T)source;
            }
            return (T)((MuleMessage)source).getPayload();
        }
        Transformer transformer = this.getMuleContext().getRegistry().lookupTransformer(DataTypeConverter.convertIBeansToMule((DataType)sourceType), DataTypeConverter.convertIBeansToMule(result));
        return (T)transformer.transform(source);
    }

    public ConfigManager getConfig() {
        return this.configManager;
    }

    public <T> T eval(String expression, Object data, Class<T> returnType) throws TransformerException, MimeTypeParseException {
        String o = this.muleContext.getExpressionManager().parse(expression, (MuleMessage)new DefaultMuleMessage(data, this.muleContext));
        return this.transform((Object)o, returnType);
    }

    public Object eval(String expression, Object data) throws TransformerException {
        return this.muleContext.getExpressionManager().parse(expression, (MuleMessage)new DefaultMuleMessage(data, this.muleContext));
    }
}

